/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.bundle.OM;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    private Serializable object;

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(Serializable object) {
        this.object = object;
    }

    public Serializable getObject() {
        return this.object;
    }

    public void setObject(Serializable object) {
        this.object = object;
    }

    @Override
    public void populate(Message source) throws JMSException {
        super.populate(source);
        ObjectMessage object = (ObjectMessage)source;
        this.setObject(object.getObject());
    }

    @Override
    public void write(ExtendedDataOutputStream out) throws IOException {
        super.write(out);
        if (this.object != null) {
            out.writeBoolean(true);
            ObjectOutputStream stream = new ObjectOutputStream((OutputStream)out);
            stream.writeObject(this.object);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void read(ExtendedDataInputStream in) throws IOException {
        super.read(in);
        boolean notNull = in.readBoolean();
        if (notNull) {
            try {
                ObjectInputStream stream = new ObjectInputStream((InputStream)in);
                this.object = (Serializable)stream.readObject();
            }
            catch (ClassNotFoundException ex) {
                OM.LOG.error((Throwable)ex);
                throw new IOException(ex.getMessage());
            }
        }
    }
}

