/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.providers;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.emf.cdo.internal.ui.CDOAdapterFactoryContentProvider;
import org.eclipse.emf.cdo.internal.ui.CDOContentProvider;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.StringUtil;

public class SystemContentProvider
extends CDOContentProvider<ISystemDescriptor> {
    public static final Comparator<Object> SYSTEM_COMPARATOR = Comparator.comparing(SystemContentProvider::name);
    private static final Object[] NO_CHILDREN = new Object[0];
    private final AdapterFactory adapterFactory;
    private final CDOAdapterFactoryContentProvider delegate;

    public SystemContentProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.delegate = new CDOAdapterFactoryContentProvider(adapterFactory);
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        super.inputChanged(newViewer, oldInput, newInput);
        this.delegate.inputChanged(newViewer, oldInput, newInput);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object[] getChildren(Object object) {
        if (object == ISystemManager.INSTANCE) {
            ISystemDescriptor[] descriptors = ISystemManager.INSTANCE.getDescriptors();
            Object[] children = new Object[descriptors.length];
            int i = 0;
            while (i < descriptors.length) {
                ISystemDescriptor descriptor = descriptors[i];
                System system = descriptor.getSystem();
                children[i] = system != null ? system : descriptor;
                ++i;
            }
            Arrays.sort(children, SYSTEM_COMPARATOR);
            return children;
        }
        if (object instanceof ISystemDescriptor) {
            return NO_CHILDREN;
        }
        Object[] children = super.getChildren(object);
        children = this.filteredChildren(children);
        if (object instanceof System) {
            Arrays.sort(children, Module.COMPARATOR);
        } else if (object instanceof Module) {
            Arrays.sort(children, Baseline.COMPARATOR);
        } else if (object instanceof Stream) {
            Arrays.sort(children, Baseline.COMPARATOR);
        }
        return children;
    }

    protected Object[] filteredChildren(Object[] children) {
        return children;
    }

    public boolean hasChildren(Object object) {
        if (object == ISystemManager.INSTANCE) {
            return !ISystemManager.INSTANCE.isEmpty();
        }
        if (object instanceof ISystemDescriptor) {
            return false;
        }
        return super.hasChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof ISystemDescriptor || object instanceof System) {
            return ISystemManager.INSTANCE;
        }
        return super.getParent(object);
    }

    protected Object adapt(Object target, Object type) {
        return this.adapterFactory.adapt(target, type);
    }

    protected Object[] modifyChildren(Object parent, Object[] children) {
        return children;
    }

    protected ITreeContentProvider getContentProvider(Object object) {
        return this.delegate;
    }

    protected RunnableViewerRefresh getViewerRefresh() {
        return this.delegate.getViewerRefresh();
    }

    protected boolean isContext(Object object) {
        return object instanceof ISystemDescriptor;
    }

    protected CDOContentProvider.ContextState getContextState(ISystemDescriptor descriptor) {
        switch (descriptor.getState()) {
            case Closing: 
            case Closed: {
                return CDOContentProvider.ContextState.Closed;
            }
            case Opening: {
                return CDOContentProvider.ContextState.Opening;
            }
            case Open: {
                return CDOContentProvider.ContextState.Open;
            }
        }
        throw new IllegalStateException("Unexpected system state: " + String.valueOf(descriptor));
    }

    protected void openContext(ISystemDescriptor descriptor) {
        descriptor.open();
    }

    protected void closeContext(ISystemDescriptor descriptor) {
        descriptor.close();
    }

    protected Object getRootObject(ISystemDescriptor descriptor) {
        return descriptor.getSystem();
    }

    private static String name(Object o) {
        if (o instanceof System) {
            return StringUtil.safe((String)((System)o).getName());
        }
        if (o instanceof ISystemDescriptor) {
            return StringUtil.safe((String)((ISystemDescriptor)o).getSystemName());
        }
        return "";
    }
}

