/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol;

import java.text.MessageFormat;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.util.MessageUtil;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.ServerSession;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.messages.Messages;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSCommitIndication
extends IndicationWithResponse {
    private String[] messageIDs;

    public JMSCommitIndication(JMSServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)12);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        int sessionID = in.readInt();
        int size = in.readInt();
        MessageImpl[] messages = new MessageImpl[size];
        int i = 0;
        while (i < messages.length) {
            messages[i] = MessageUtil.read((ExtendedDataInputStream)in);
            ++i;
        }
        JMSServerProtocol protocol = (JMSServerProtocol)this.getProtocol();
        ServerConnection connection = (ServerConnection)protocol.getInfraStructure();
        ServerSession session = connection.getSession(sessionID);
        if (session == null) {
            OM.LOG.warn(MessageFormat.format(Messages.getString("JMSCommitIndication_0"), sessionID));
            return;
        }
        this.messageIDs = session.handleCommit(messages);
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        if (this.messageIDs == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.messageIDs.length);
            String[] stringArray = this.messageIDs;
            int n = this.messageIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String messageID = stringArray[n2];
                out.writeString(messageID);
                ++n2;
            }
        }
    }
}

