/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class TableElementList
extends QueryTreeNodeVector<TableElementNode> {
    private int numColumns;
    private TableDescriptor td;

    public TableElementList(ContextManager cm) {
        super(TableElementNode.class, cm);
    }

    void addTableElement(TableElementNode tableElement) {
        this.addElement(tableElement);
        if (tableElement instanceof ColumnDefinitionNode || tableElement.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    void setCollationTypesOnCharacterStringColumns(SchemaDescriptor sd) throws StandardException {
        for (TableElementNode te : this) {
            if (!(te instanceof ColumnDefinitionNode)) continue;
            this.setCollationTypeOnCharacterStringColumn(sd, (ColumnDefinitionNode)te);
        }
    }

    void setCollationTypeOnCharacterStringColumn(SchemaDescriptor sd, ColumnDefinitionNode cdn) throws StandardException {
        int collationType = sd.getCollationType();
        DataTypeDescriptor dtd = cdn.getType();
        if (dtd == null) {
            if (!cdn.hasGenerationClause()) {
                throw StandardException.newException("42XA9", cdn.getColumnName());
            }
        } else if (dtd.getTypeId().isStringTypeId()) {
            cdn.setCollationType(collationType);
        }
    }

    void validate(DDLStatementNode ddlStmt, DataDictionary dd, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl;
        this.td = td;
        int numAutoCols = 0;
        int size = this.size();
        HashSet<String> columnNames = new HashSet<String>(size + 2, 0.999f);
        HashSet<String> constraintNames = new HashSet<String>(size + 2, 0.999f);
        ArrayList<Object> constraints = new ArrayList<Object>();
        if (td != null && (cdl = dd.getConstraintDescriptors(td)) != null) {
            for (int i = 0; i < cdl.size(); ++i) {
                ConstraintDescriptor cd = cdl.elementAt(i);
                if (cd.getConstraintType() != 2 && cd.getConstraintType() != 3) continue;
                constraints.add(cd);
            }
        }
        int tableType = 0;
        if (ddlStmt instanceof CreateTableNode) {
            tableType = ((CreateTableNode)ddlStmt).tableType;
        }
        for (TableElementNode tableElement : this) {
            String dropConstraintName;
            TableElementNode cdn;
            if (tableElement instanceof ColumnDefinitionNode) {
                cdn = (ColumnDefinitionNode)tableElement;
                if (tableType == 3 && (((ColumnDefinitionNode)cdn).getType().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)cdn).getType().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)cdn).getColumnName());
                }
                this.checkForDuplicateColumns(ddlStmt, columnNames, ((ColumnDefinitionNode)cdn).getColumnName());
                ((ColumnDefinitionNode)cdn).checkUserType(td);
                ((ColumnDefinitionNode)cdn).bindAndValidateDefault(dd, td);
                ((ColumnDefinitionNode)cdn).validateAutoincrement(dd, td, tableType);
                if (tableElement instanceof ModifyColumnNode) {
                    ModifyColumnNode mcdn = (ModifyColumnNode)cdn;
                    mcdn.checkExistingConstraints(td);
                    mcdn.useExistingCollation(td);
                } else if (((ColumnDefinitionNode)cdn).isAutoincrementColumn()) {
                    ++numAutoCols;
                }
            } else if (tableElement.getElementType() == 7) {
                String colName = tableElement.getName();
                if (td.getColumnDescriptor(colName) != null) break;
                throw StandardException.newException("42X14", colName, td.getQualifiedName());
            }
            if (!tableElement.hasConstraint()) continue;
            cdn = (ConstraintDefinitionNode)tableElement;
            ((ConstraintDefinitionNode)cdn).bind(ddlStmt, dd);
            if (((ConstraintDefinitionNode)cdn).getConstraintType() == 2 || ((ConstraintDefinitionNode)cdn).getConstraintType() == 3) {
                String destName = null;
                String[] destColumnNames = null;
                for (int i = 0; i < constraints.size(); ++i) {
                    Object destConstraint = constraints.get(i);
                    if (destConstraint instanceof ConstraintDefinitionNode) {
                        ConstraintDefinitionNode destCDN = (ConstraintDefinitionNode)destConstraint;
                        destName = destCDN.getConstraintMoniker();
                        destColumnNames = destCDN.getColumnList().getColumnNames();
                    } else if (destConstraint instanceof ConstraintDescriptor) {
                        ConstraintDescriptor destCD = (ConstraintDescriptor)destConstraint;
                        destName = destCD.getConstraintName();
                        destColumnNames = destCD.getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)cdn).getColumnList().getColumnNames(), destColumnNames)) continue;
                    throw StandardException.newException("42Z93", ((ConstraintDefinitionNode)cdn).getConstraintMoniker(), destName);
                }
                constraints.add(cdn);
            }
            this.checkForDuplicateConstraintNames(ddlStmt, constraintNames, ((ConstraintDefinitionNode)cdn).getConstraintMoniker());
            if ((((ConstraintDefinitionNode)cdn).getConstraintType() == 5 || ((ConstraintDefinitionNode)cdn).getConstraintType() == 7) && (dropConstraintName = ((ConstraintDefinitionNode)cdn).getConstraintMoniker()) != null) {
                String dropSchemaName = ((ConstraintDefinitionNode)cdn).getDropSchemaName();
                SchemaDescriptor sd = dropSchemaName == null ? td.getSchemaDescriptor() : this.getSchemaDescriptor(dropSchemaName);
                ConstraintDescriptor cd = dd.getConstraintDescriptorByName(td, sd, dropConstraintName, false);
                if (cd == null) {
                    throw StandardException.newException("42X86", sd.getSchemaName() + "." + dropConstraintName, td.getQualifiedName());
                }
                this.getCompilerContext().createDependency(cd);
            }
            if (((ConstraintDefinitionNode)cdn).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                continue;
            }
            if (((ConstraintDefinitionNode)cdn).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                if (dd.checkVersion(160, null)) continue;
                this.checkForNullColumns((ConstraintDefinitionNode)cdn, td);
                continue;
            }
            if (!((ConstraintDefinitionNode)cdn).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
        }
        if (numAutoCols > 1 || numAutoCols > 0 && td != null && td.tableHasAutoincrement()) {
            throw StandardException.newException("428C1", new Object[0]);
        }
    }

    public void validatePrimaryKeyNullability() throws StandardException {
        for (TableElementNode tableElement : this) {
            ConstraintDefinitionNode cdn;
            if (!tableElement.hasConstraint() || !(cdn = (ConstraintDefinitionNode)tableElement).hasPrimaryKeyConstraint()) continue;
            if (this.td == null) {
                this.setColumnListToNotNull(cdn);
                continue;
            }
            this.checkForNullColumns(cdn, this.td);
        }
    }

    int countConstraints(int constraintType) {
        int numConstraints = 0;
        for (TableElementNode element : this) {
            if (!(element instanceof ConstraintDefinitionNode) || ((ConstraintDefinitionNode)element).getConstraintType() != constraintType) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    int countGenerationClauses() {
        int numGenerationClauses = 0;
        for (TableElementNode element : this) {
            if (!(element instanceof ColumnDefinitionNode) || !((ColumnDefinitionNode)element).hasGenerationClause()) continue;
            ++numGenerationClauses;
        }
        return numGenerationClauses;
    }

    int countNumberOfColumns() {
        return this.numColumns;
    }

    int genColumnInfos(ColumnInfo[] colInfos) throws StandardException {
        int numConstraints = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((TableElementNode)this.elementAt(index)).getElementType() == 7) {
                String columnName = ((TableElementNode)this.elementAt(index)).getName();
                colInfos[index] = new ColumnInfo(columnName, this.td.getColumnDescriptor(columnName).getType(), null, null, null, null, null, 1, 0L, 0L, false, 0L);
                break;
            }
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) {
                SanityManager.ASSERT(this.elementAt(index) instanceof ConstraintDefinitionNode, "elementAt(index) expected to be instanceof ConstraintDefinitionNode");
                ++numConstraints;
                continue;
            }
            ColumnDefinitionNode coldef = (ColumnDefinitionNode)this.elementAt(index);
            ProviderList apl = null;
            ProviderInfo[] providerInfos = null;
            if (coldef.hasGenerationClause()) {
                apl = coldef.getGenerationClauseNode().getAuxiliaryProviderList();
            }
            if (apl != null && apl.size() > 0) {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                providerInfos = dm.getPersistentProviderInfos(apl);
            }
            colInfos[index - numConstraints] = new ColumnInfo(coldef.getColumnName(), coldef.getType(), coldef.getDefaultValue(), coldef.getDefaultInfo(), providerInfos, null, coldef.getOldDefaultUUID(), coldef.getAction(), coldef.isAutoincrementColumn() ? coldef.getAutoincrementStart() : 0L, coldef.isAutoincrementColumn() ? coldef.getAutoincrementIncrement() : 0L, coldef.isAutoincrementColumn() ? coldef.getAutoincrementCycle() : false, coldef.isAutoincrementColumn() ? coldef.getAutoinc_create_or_modify_Start_Increment() : -1L);
            if (!coldef.hasConstraint()) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    void appendNewColumnsToRCL(FromBaseTable table) throws StandardException {
        int size = this.size();
        ResultColumnList rcl = table.getResultColumns();
        TableName exposedName = table.getTableName();
        for (int index = 0; index < size; ++index) {
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode cdn = (ColumnDefinitionNode)this.elementAt(index);
            BaseColumnNode valueNode = new BaseColumnNode(cdn.getColumnName(), exposedName, cdn.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(cdn.getType(), (ValueNode)valueNode, this.getContextManager());
            resultColumn.setName(cdn.getColumnName());
            rcl.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable table = (FromBaseTable)fromList.elementAt(0);
        CompilerContext cc = this.getCompilerContext();
        ArrayList<AggregateNode> aggregates = new ArrayList<AggregateNode>();
        for (TableElementNode element : this) {
            ConstraintDefinitionNode cdn;
            if (!(element instanceof ConstraintDefinitionNode) || (cdn = (ConstraintDefinitionNode)element).getConstraintType() != 4) continue;
            ValueNode checkTree = cdn.getCheckCondition();
            int previousReliability = cc.getReliability();
            try {
                ProviderList apl = new ProviderList();
                ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.setReliability(18041);
                checkTree = checkTree.bindExpression(fromList, null, aggregates);
                if (!aggregates.isEmpty()) {
                    throw StandardException.newException("42Y01", cdn.getConstraintText());
                }
                checkTree = checkTree.checkIsBoolean();
                cdn.setCheckCondition(checkTree);
                if (apl.size() > 0) {
                    cdn.setAuxiliaryProviderList(apl);
                }
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            finally {
                cc.setReliability(previousReliability);
            }
            ResultColumnList rcl = table.getResultColumns();
            int numReferenced = rcl.countReferencedColumns();
            ResultColumnList refRCL = new ResultColumnList(this.getContextManager());
            rcl.copyReferencedColumnsToNewList(refRCL);
            if (cdn.getColumnList() != null) {
                String colName = ((ResultColumn)cdn.getColumnList().elementAt(0)).getName();
                if (numReferenced > 1 || !colName.equals(((ResultColumn)refRCL.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", colName);
                }
            }
            cdn.setColumnList(refRCL);
            rcl.clearColumnReferences();
            cdn.qualifyNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateGenerationClauses(SchemaDescriptor sd, FromList fromList, FormatableBitSet generatedColumns, TableDescriptor baseTable) throws StandardException {
        FromBaseTable table = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList tableColumns = table.getResultColumns();
        int columnCount = table.getResultColumns().size();
        this.findIllegalGenerationReferences(fromList, baseTable);
        generatedColumns.grow(columnCount + 1);
        CompilerContext cc = this.getCompilerContext();
        ArrayList<AggregateNode> aggregates = new ArrayList<AggregateNode>();
        for (TableElementNode element : this) {
            ColumnDefinitionNode cdn;
            if (!(element instanceof ColumnDefinitionNode) || !(cdn = (ColumnDefinitionNode)element).hasGenerationClause()) continue;
            GenerationClauseNode generationClauseNode = cdn.getGenerationClauseNode();
            int previousReliability = cc.getReliability();
            ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
            try {
                ProviderList apl = new ProviderList();
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.setReliability(30329);
                ValueNode generationTree = generationClauseNode.bindExpression(fromList, null, aggregates);
                SelectNode.checkNoWindowFunctions(generationClauseNode, "generation clause");
                DataTypeDescriptor generationClauseType = generationTree.getTypeServices();
                DataTypeDescriptor declaredType = cdn.getType();
                if (declaredType == null) {
                    cdn.setType(generationClauseType);
                    tableColumns.getResultColumn(cdn.getColumnName(), false).setType(generationClauseType);
                    this.setCollationTypeOnCharacterStringColumn(sd, cdn);
                    cdn.checkUserType(table.getTableDescriptor());
                } else {
                    TypeId declaredTypeId = declaredType.getTypeId();
                    TypeId resolvedTypeId = generationClauseType.getTypeId();
                    if (!this.getTypeCompiler(resolvedTypeId).convertible(declaredTypeId, false)) {
                        throw StandardException.newException("42XA0", cdn.getName(), resolvedTypeId.getSQLTypeName());
                    }
                }
                if (!aggregates.isEmpty()) {
                    throw StandardException.newException("42XA1", cdn.getName());
                }
                if (apl.size() > 0) {
                    generationClauseNode.setAuxiliaryProviderList(apl);
                }
            }
            finally {
                cc.setCurrentAuxiliaryProviderList(prevAPL);
                cc.setReliability(previousReliability);
            }
            ResultColumnList rcl = table.getResultColumns();
            int numReferenced = rcl.countReferencedColumns();
            int[] generationClauseColumnReferences = new int[numReferenced];
            int position = rcl.getPosition(cdn.getColumnName(), 1);
            generatedColumns.set(position);
            rcl.recordColumnReferences(generationClauseColumnReferences, 1);
            String[] referencedColumnNames = new String[numReferenced];
            for (int i = 0; i < numReferenced; ++i) {
                referencedColumnNames[i] = ((ResultColumn)rcl.elementAt(generationClauseColumnReferences[i] - 1)).getName();
            }
            String currentSchemaName = this.getLanguageConnectionContext().getCurrentSchemaName();
            DefaultInfoImpl dii = new DefaultInfoImpl(generationClauseNode.getExpressionText(), referencedColumnNames, currentSchemaName);
            cdn.setDefaultInfo(dii);
            rcl.clearColumnReferences();
        }
    }

    void findIllegalGenerationReferences(FromList fromList, TableDescriptor baseTable) throws StandardException {
        ArrayList<ColumnDefinitionNode> generatedColumns = new ArrayList<ColumnDefinitionNode>();
        HashSet<String> names = new HashSet<String>();
        if (baseTable != null) {
            ColumnDescriptorList cdl = baseTable.getGeneratedColumns();
            int count = cdl.size();
            for (int i = 0; i < count; ++i) {
                names.add(cdl.elementAt(i).getColumnName());
            }
        }
        for (TableElementNode element : this) {
            ColumnDefinitionNode cdn;
            if (!(element instanceof ColumnDefinitionNode) || !(cdn = (ColumnDefinitionNode)element).hasGenerationClause()) continue;
            generatedColumns.add(cdn);
            names.add(cdn.getColumnName());
        }
        int count = generatedColumns.size();
        for (int i = 0; i < count; ++i) {
            ColumnDefinitionNode cdn = (ColumnDefinitionNode)generatedColumns.get(i);
            GenerationClauseNode generationClauseNode = cdn.getGenerationClauseNode();
            List<ColumnReference> referencedColumns = generationClauseNode.findReferencedColumns();
            int refCount = referencedColumns.size();
            for (int j = 0; j < refCount; ++j) {
                String name = referencedColumns.get(j).getColumnName();
                if (name == null || !names.contains(name)) continue;
                throw StandardException.newException("42XA4", cdn.getColumnName());
            }
        }
    }

    void validateForeignKeysOnGenerationClauses(FromList fromList, FormatableBitSet generatedColumns) throws StandardException {
        if (generatedColumns.getNumBitsSet() <= 0) {
            return;
        }
        FromBaseTable table = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList tableColumns = table.getResultColumns();
        for (TableElementNode element : this) {
            if (!(element instanceof FKConstraintDefinitionNode)) continue;
            FKConstraintDefinitionNode fk = (FKConstraintDefinitionNode)element;
            ConstraintInfo ci = fk.getReferencedConstraintInfo();
            int deleteRule = ci.getReferentialActionDeleteRule();
            int updateRule = ci.getReferentialActionUpdateRule();
            if (updateRule != 1 && updateRule != 2) {
                throw StandardException.newException("XSCB3.S", new Object[0]);
            }
            if (deleteRule != 3 && deleteRule != 4) continue;
            for (ResultColumn keyCol : fk.getColumnList()) {
                String keyColName = keyCol.getName();
                int position = tableColumns.getPosition(keyColName, 1);
                if (!generatedColumns.isSet(position)) continue;
                throw StandardException.newException("42XA6", keyColName);
            }
        }
    }

    void genConstraintActions(boolean forCreateTable, ConstraintConstantAction[] conActions, String tableName, SchemaDescriptor tableSd, DataDictionary dd) throws StandardException {
        int conActionIndex = 0;
        for (TableElementNode ten : this) {
            ProviderInfo[] providerInfos;
            String[] columnNames = null;
            IndexConstantAction indexAction = null;
            if (!ten.hasConstraint() || ten instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDN = (ConstraintDefinitionNode)ten;
            if (constraintDN.getColumnList() != null) {
                columnNames = new String[constraintDN.getColumnList().size()];
                constraintDN.getColumnList().exportNames(columnNames);
            }
            int constraintType = constraintDN.getConstraintType();
            boolean[] cChars = constraintDN.getCharacteristics();
            String constraintText = constraintDN.getConstraintText();
            String constraintName = constraintDN.getConstraintMoniker();
            if (constraintDN.requiresBackingIndex()) {
                if (constraintDN.constraintType == 3 && dd.checkVersion(160, null)) {
                    boolean contains_nullable_columns = this.areColumnsNullable(constraintDN, this.td);
                    boolean unique = !contains_nullable_columns;
                    boolean uniqueWithDuplicateNulls = contains_nullable_columns;
                    indexAction = this.genIndexAction(forCreateTable, unique, uniqueWithDuplicateNulls, cChars[0], cChars[1], null, constraintDN, columnNames, true, tableSd, tableName, constraintType, dd);
                } else {
                    indexAction = this.genIndexAction(forCreateTable, constraintDN.requiresUniqueIndex(), false, cChars[0], cChars[1], null, constraintDN, columnNames, true, tableSd, tableName, constraintType, dd);
                }
            }
            if (constraintType == 5) {
                SanityManager.ASSERT(!forCreateTable);
                conActions[conActionIndex] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(constraintName, constraintDN.getDropSchemaName(), tableName, this.td.getUUID(), tableSd.getSchemaName(), indexAction, constraintDN.getDropBehavior(), constraintDN.getVerifyType());
                continue;
            }
            if (constraintType == 7) {
                conActions[conActionIndex] = this.getGenericConstantActionFactory().getAlterConstraintConstantAction(constraintName, constraintDN.getDropSchemaName(), cChars, tableName, this.td.getUUID(), tableSd.getSchemaName(), indexAction);
                continue;
            }
            ProviderList apl = constraintDN.getAuxiliaryProviderList();
            ConstraintInfo refInfo = null;
            if (constraintDN instanceof FKConstraintDefinitionNode) {
                refInfo = ((FKConstraintDefinitionNode)constraintDN).getReferencedConstraintInfo();
            }
            if (apl != null && apl.size() > 0) {
                DependencyManager dm = dd.getDependencyManager();
                providerInfos = dm.getPersistentProviderInfos(apl);
            } else {
                providerInfos = new ProviderInfo[]{};
            }
            conActions[conActionIndex++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(constraintName, constraintType, cChars, forCreateTable, tableName, this.td != null ? this.td.getUUID() : (UUID)null, tableSd.getSchemaName(), columnNames, indexAction, constraintText, refInfo, providerInfos);
        }
    }

    private boolean columnsMatch(String[] columnNames1, String[] columnNames2) {
        if (columnNames1.length != columnNames2.length) {
            return false;
        }
        int srcSize = columnNames1.length;
        int destSize = columnNames2.length;
        for (int srcCount = 0; srcCount < srcSize; ++srcCount) {
            boolean match = false;
            for (int destCount = 0; destCount < destSize; ++destCount) {
                if (!columnNames1[srcCount].equals(columnNames2[destCount])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean forCreateTable, boolean isUnique, boolean isUniqueWithDuplicateNulls, boolean hasDeferrableChecking, boolean initiallyDeferred, String indexName, ConstraintDefinitionNode cdn, String[] columnNames, boolean isConstraint, SchemaDescriptor sd, String tableName, int constraintType, DataDictionary dd) throws StandardException {
        if (indexName == null) {
            indexName = cdn.getBackingIndexName(dd);
        }
        if (constraintType == 5) {
            if (forCreateTable) {
                SanityManager.THROWASSERT("DROP INDEX with forCreateTable true");
            }
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, indexName, tableName, sd.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] isAscending = new boolean[columnNames.length];
        for (int i = 0; i < isAscending.length; ++i) {
            isAscending[i] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(forCreateTable, isUnique, isUniqueWithDuplicateNulls, hasDeferrableChecking, initiallyDeferred, constraintType, "BTREE", sd.getSchemaName(), indexName, tableName, this.td != null ? this.td.getUUID() : (UUID)null, columnNames, isAscending, isConstraint, cdn.getBackingIndexUUID(), this.checkIndexPageSizeProperty(cdn));
    }

    private Properties checkIndexPageSizeProperty(ConstraintDefinitionNode cdn) throws StandardException {
        Properties result = cdn.getProperties();
        if (result == null) {
            result = new Properties();
        }
        if (result.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null) {
            return result;
        }
        int approxLength = 0;
        for (ResultColumn rc : cdn.getColumnList()) {
            String colName = rc.getName();
            DataTypeDescriptor dtd = this.td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, this.td);
            if (dtd == null) continue;
            approxLength += dtd.getTypeId().getApproximateLengthInBytes(dtd);
        }
        if (approxLength > 1024) {
            result.put("derby.storage.pageSize", "32768");
        }
        return result;
    }

    private void checkForDuplicateColumns(DDLStatementNode ddlStmt, Set<String> seenNames, String colName) throws StandardException {
        if (!seenNames.add(colName) && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X12", colName);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode ddlStmt, Set<String> seenNames, String constraintName) throws StandardException {
        if (constraintName == null) {
            return;
        }
        if (!seenNames.add(constraintName) && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X91", constraintName);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode ddlStmt, ConstraintDefinitionNode cdn) throws StandardException {
        String invalidColName;
        if (ddlStmt instanceof CreateTableNode && (invalidColName = cdn.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", ddlStmt.getRelativeName(), invalidColName);
        }
        invalidColName = cdn.getColumnList().verifyUniqueNames(false);
        if (invalidColName != null) {
            throw StandardException.newException("42X92", invalidColName);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode cdn) {
        for (ResultColumn rc : cdn.getColumnList()) {
            this.findColumnDefinition(rc.getName()).setNullability(false);
        }
    }

    private boolean areColumnsNullable(ConstraintDefinitionNode cdn, TableDescriptor td) {
        for (ResultColumn rc : cdn.getColumnList()) {
            String colName = rc.getName();
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, td);
            if (dtd == null || !dtd.isNullable()) continue;
            return true;
        }
        return false;
    }

    private void checkForNullColumns(ConstraintDefinitionNode cdn, TableDescriptor td) throws StandardException {
        for (ResultColumn rc : cdn.getColumnList()) {
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(rc.getName()) : this.getColumnDataTypeDescriptor(rc.getName(), td);
            if (dtd == null || !dtd.isNullable()) continue;
            String errorState = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42831.S.1" : "42831";
            throw StandardException.newException(errorState, rc.getName());
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName) {
        ColumnDefinitionNode col = this.findColumnDefinition(colName);
        if (col != null) {
            return col.getType();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName, TableDescriptor td) {
        ColumnDescriptor cd = td.getColumnDescriptor(colName);
        if (cd != null) {
            return cd.getType();
        }
        return this.getColumnDataTypeDescriptor(colName);
    }

    private ColumnDefinitionNode findColumnDefinition(String colName) {
        for (TableElementNode te : this) {
            ColumnDefinitionNode cdn;
            if (!(te instanceof ColumnDefinitionNode) || !colName.equals((cdn = (ColumnDefinitionNode)te).getName())) continue;
            return cdn;
        }
        return null;
    }

    boolean containsColumnName(String colName) {
        return this.findColumnDefinition(colName) != null;
    }
}

