/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.loader.ClassFactory;

class ApplicationObjectInputStream
extends ObjectInputStream
implements ErrorObjectInput {
    protected ClassFactory cf;
    protected ObjectStreamClass initialClass;

    ApplicationObjectInputStream(InputStream in, ClassFactory cf) throws IOException {
        super(in);
        this.cf = cf;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        if (this.initialClass == null) {
            this.initialClass = v;
        }
        if (this.cf != null) {
            return this.cf.loadApplicationClass(v);
        }
        throw new ClassNotFoundException(v.getName());
    }

    @Override
    public String getErrorInfo() {
        if (this.initialClass == null) {
            return "";
        }
        return this.initialClass.getName() + " (serialVersionUID=" + this.initialClass.getSerialVersionUID() + ")";
    }

    @Override
    public Exception getNestedException() {
        return null;
    }
}

