/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.widgets;

import java.util.Objects;
import org.eclipse.emf.cdo.lm.internal.client.TimeStamp;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimeStampComposite
extends Composite {
    private ConcurrentArray<ModifyListener> listeners = new ConcurrentArray<ModifyListener>(){

        protected ModifyListener[] newArray(int length) {
            return new ModifyListener[length];
        }
    };
    private final Text text;
    private final long minTimeStamp;
    private final long maxTimeStamp;
    private long timeStamp = -1L;
    private String error;
    private boolean settingValue;
    private static TimeStampSelectorContributor[] selectors = new TimeStampSelectorContributor[]{new TimeStampSelectorContributor(){

        @Override
        public boolean contributeTimeStampSelector(final TimeStampComposite composite, Object context) {
            Button button = new Button((Composite)composite, 8);
            button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            button.setText("Now");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    composite.setTimeStamp(System.currentTimeMillis());
                }
            });
            return true;
        }
    }};

    public TimeStampComposite(Composite parent, int style, long minTimeStamp, long maxTimeStamp, Object context) {
        super(parent, style);
        this.minTimeStamp = minTimeStamp;
        this.maxTimeStamp = maxTimeStamp;
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).create());
        this.text.addModifyListener(e -> {
            if (!this.settingValue) {
                long oldValue = this.timeStamp;
                String oldError = this.error;
                this.validate();
                this.notifyModifyListeners(oldValue, oldError);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldString;
                String string;
                if (TimeStampComposite.this.timeStamp != -1L && !Objects.equals(string = TimeStamp.toString((long)TimeStampComposite.this.timeStamp), oldString = TimeStampComposite.this.text.getText())) {
                    try {
                        TimeStampComposite.this.settingValue = true;
                        TimeStampComposite.this.text.setText(string);
                    }
                    finally {
                        TimeStampComposite.this.settingValue = false;
                    }
                }
            }
        });
        int columns = 1;
        if (context != null) {
            int i = 0;
            while (i < selectors.length) {
                TimeStampSelectorContributor selector = selectors[i];
                if (selector.contributeTimeStampSelector(this, context)) {
                    ++columns;
                }
                ++i;
            }
        }
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(columns).create());
    }

    public void addModifyListener(ModifyListener listener) {
        CheckUtil.checkArg((Object)listener, (String)"listener");
        this.listeners.add((Object)listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        CheckUtil.checkArg((Object)listener, (String)"listener");
        this.listeners.remove((Object)listener);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (this.timeStamp != timeStamp) {
            long oldValue = this.timeStamp;
            String oldError = this.error;
            this.timeStamp = timeStamp;
            this.validateValue();
            if (!this.text.isDisposed()) {
                try {
                    this.settingValue = true;
                    this.text.setText(TimeStamp.toString((long)timeStamp));
                }
                finally {
                    this.settingValue = false;
                }
            }
            this.notifyModifyListeners(oldValue, oldError);
        }
    }

    public String getError() {
        return this.error;
    }

    protected void validate() {
        String string = this.text.getText();
        this.error = null;
        try {
            this.timeStamp = TimeStamp.parseTimeStamp((String)string);
        }
        catch (Exception ex) {
            this.timeStamp = -1L;
            this.error = ex.getMessage();
            return;
        }
        this.validateValue();
    }

    private void validateValue() {
        this.error = null;
        if (this.minTimeStamp != 0L && this.timeStamp < this.minTimeStamp) {
            this.timeStamp = -1L;
            this.error = "Time stamp must not be smaller than " + TimeStamp.toString((long)this.minTimeStamp);
            return;
        }
        if (this.maxTimeStamp != 0L && this.timeStamp > this.maxTimeStamp) {
            this.timeStamp = -1L;
            this.error = "Time stamp must not be greater than " + TimeStamp.toString((long)this.maxTimeStamp);
            return;
        }
    }

    private void notifyModifyListeners(long oldValue, String oldError) {
        if (this.timeStamp != oldValue || !Objects.equals(this.error, oldError)) {
            ModifyListener[] array = (ModifyListener[])this.listeners.get();
            int i = 0;
            while (i < array.length) {
                try {
                    ModifyListener listener = array[i];
                    if (listener != null) {
                        listener.modifyTimeStamp(this, this.timeStamp, this.error);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++i;
            }
        }
    }

    @FunctionalInterface
    public static interface ModifyListener {
        public void modifyTimeStamp(TimeStampComposite var1, long var2, String var4);
    }

    @FunctionalInterface
    public static interface TimeStampSelectorContributor {
        public boolean contributeTimeStampSelector(TimeStampComposite var1, Object var2);
    }
}

