/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.mpt.transformation;

import activity.Activity;
import activity.ActivitySet;
import activity.util.ActivityParametersUtil;
import com.google.common.collect.Sets;
import common.HasName;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Add a named Activity for all combinations of ResourceItems.
 * The original (unusable) activity is removed.
 */
@SuppressWarnings("all")
public final class ExpandActivities {
  private ExpandActivities() {
  }

  public static void expand(final ActivitySet activitySet) {
    final LinkedHashMap<String, Activity> expandMap = ExpandActivities.expandNames(activitySet.getActivities());
    int _size = expandMap.size();
    int _size_1 = activitySet.getActivities().size();
    boolean _equals = (_size == _size_1);
    if (_equals) {
      return;
    }
    final Function1<Activity, Boolean> _function = (Activity it) -> {
      boolean _isEmpty = it.getResourcesNeedingItem().isEmpty();
      return Boolean.valueOf((!_isEmpty));
    };
    final List<Activity> eligibleActivities = IterableExtensions.<Activity>toList(IterableExtensions.<Activity>filter(activitySet.getActivities(), _function));
    final Consumer<Activity> _function_1 = (Activity it) -> {
      ExpandActivities.expand(it);
    };
    eligibleActivities.forEach(_function_1);
  }

  private static void expand(final Activity activity) {
    final List<Set<List<? extends HasName>>> declarations = ActivityParametersUtil.findCandidates(activity);
    final Consumer<List<List<? extends HasName>>> _function = (List<List<? extends HasName>> it) -> {
      ActivityParametersUtil.queryCreateExpandedActivity(activity, it);
    };
    Sets.<List<? extends HasName>>cartesianProduct(declarations).forEach(_function);
    EObject _eContainer = activity.eContainer();
    final ActivitySet c = ((ActivitySet) _eContainer);
    EList<Activity> _activities = c.getActivities();
    _activities.remove(activity);
  }

  /**
   * returns a map with all possible activity names and activity as values
   */
  public static LinkedHashMap<String, Activity> expandNames(final List<Activity> activities) {
    final LinkedHashMap<String, Activity> result = CollectionLiterals.<String, Activity>newLinkedHashMap();
    final Consumer<Activity> _function = (Activity activity) -> {
      result.put(activity.getName(), activity);
      final List<Set<List<? extends HasName>>> modelCandidates = ActivityParametersUtil.findCandidates(activity);
      final Function1<List<List<? extends HasName>>, String> _function_1 = (List<List<? extends HasName>> it) -> {
        return ActivityParametersUtil.expandName(activity, it);
      };
      final Consumer<String> _function_2 = (String it) -> {
        result.put(it, activity);
      };
      IterableExtensions.<List<List<? extends HasName>>, String>map(Sets.<List<? extends HasName>>cartesianProduct(modelCandidates), _function_1).forEach(_function_2);
    };
    activities.forEach(_function);
    return result;
  }
}
