/**
 */
package distributions.impl;

import distributions.DistributionsPackage;
import distributions.NormalDistribution;

import distributions.math.ModeDistribution;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Normal Distribution</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getDefaultExp <em>Default Exp</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getModeDistributionInstance <em>Mode Distribution Instance</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getMean <em>Mean</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getSd <em>Sd</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getMeanExp <em>Mean Exp</em>}</li>
 *   <li>{@link distributions.impl.NormalDistributionImpl#getSdExp <em>Sd Exp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class NormalDistributionImpl extends ExpressionImpl implements NormalDistribution
{
    /**
     * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefault()
     * @generated
     * @ordered
     */
    protected static final BigDecimal DEFAULT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDefaultExp() <em>Default Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefaultExp()
     * @generated
     * @ordered
     */
    protected Expression defaultExp;

    /**
     * The default value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected static final ModeDistribution MODE_DISTRIBUTION_INSTANCE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected ModeDistribution modeDistributionInstance = MODE_DISTRIBUTION_INSTANCE_EDEFAULT;

    /**
     * The default value of the '{@link #getMean() <em>Mean</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMean()
     * @generated
     * @ordered
     */
    protected static final BigDecimal MEAN_EDEFAULT = null;

    /**
     * The default value of the '{@link #getSd() <em>Sd</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSd()
     * @generated
     * @ordered
     */
    protected static final BigDecimal SD_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMeanExp() <em>Mean Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMeanExp()
     * @generated
     * @ordered
     */
    protected Expression meanExp;

    /**
     * The cached value of the '{@link #getSdExp() <em>Sd Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSdExp()
     * @generated
     * @ordered
     */
    protected Expression sdExp;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NormalDistributionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return DistributionsPackage.Literals.NORMAL_DISTRIBUTION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getDefault()
    {
        return defaultExp==null ? null:  defaultExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getDefaultExp()
    {
        return defaultExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDefaultExp(Expression newDefaultExp, NotificationChain msgs)
    {
        Expression oldDefaultExp = defaultExp;
        defaultExp = newDefaultExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP, oldDefaultExp, newDefaultExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setDefaultExp(Expression newDefaultExp)
    {
        if (newDefaultExp != defaultExp)
        {
            NotificationChain msgs = null;
            if (defaultExp != null)
                msgs = ((InternalEObject)defaultExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            if (newDefaultExp != null)
                msgs = ((InternalEObject)newDefaultExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            msgs = basicSetDefaultExp(newDefaultExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP, newDefaultExp, newDefaultExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistributionInstance()
    {
        return modeDistributionInstance;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeDistributionInstance(ModeDistribution newModeDistributionInstance)
    {
        ModeDistribution oldModeDistributionInstance = modeDistributionInstance;
        modeDistributionInstance = newModeDistributionInstance;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE, oldModeDistributionInstance, modeDistributionInstance));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getMean()
    {
        return meanExp==null ? null:  meanExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getSd()
    {
        return sdExp==null ? null:  sdExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getMeanExp()
    {
        return meanExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetMeanExp(Expression newMeanExp, NotificationChain msgs)
    {
        Expression oldMeanExp = meanExp;
        meanExp = newMeanExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP, oldMeanExp, newMeanExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setMeanExp(Expression newMeanExp)
    {
        if (newMeanExp != meanExp)
        {
            NotificationChain msgs = null;
            if (meanExp != null)
                msgs = ((InternalEObject)meanExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP, null, msgs);
            if (newMeanExp != null)
                msgs = ((InternalEObject)newMeanExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP, null, msgs);
            msgs = basicSetMeanExp(newMeanExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP, newMeanExp, newMeanExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getSdExp()
    {
        return sdExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSdExp(Expression newSdExp, NotificationChain msgs)
    {
        Expression oldSdExp = sdExp;
        sdExp = newSdExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP, oldSdExp, newSdExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setSdExp(Expression newSdExp)
    {
        if (newSdExp != sdExp)
        {
            NotificationChain msgs = null;
            if (sdExp != null)
                msgs = ((InternalEObject)sdExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP, null, msgs);
            if (newSdExp != null)
                msgs = ((InternalEObject)newSdExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP, null, msgs);
            msgs = basicSetSdExp(newSdExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP, newSdExp, newSdExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution createModeDistribution(final RandomGenerator generator)
    {
        return new distributions.math.NormalModeDistribution(generator, 
            getMean().doubleValue(), 
            getSd().doubleValue(), 
            org.apache.commons.math3.distribution.NormalDistribution.DEFAULT_INVERSE_ABSOLUTE_ACCURACY,
            null == getDefault() ? null : getDefault().doubleValue()
        );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        var adapter =  distributions.DistributionsAdapter.getAdapter(this);
        var mode = adapter.getCalculationMode();
        if( mode == distributions.CalculationMode.DISTRIBUTED ){
            if( adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on Distributions");
            }
            return BigDecimal.valueOf(getModeDistribution().nextSample());
        }
        return BigDecimal.valueOf(getModeDistribution().getDefault());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistribution()
    {
        if( modeDistributionInstance == null){
            var adapter = distributions.DistributionsAdapter.getAdapter(this);
            if( adapter.getCalculationMode()==distributions.CalculationMode.DISTRIBUTED && adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on DistributionsAdapter");
            }
            setModeDistributionInstance( createModeDistribution(adapter.getRandomGenerator()) );
        }
        return modeDistributionInstance;
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP:
                return basicSetDefaultExp(null, msgs);
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP:
                return basicSetMeanExp(null, msgs);
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP:
                return basicSetSdExp(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT:
                return getDefault();
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP:
                return getDefaultExp();
            case DistributionsPackage.NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return getModeDistributionInstance();
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN:
                return getMean();
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD:
                return getSd();
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP:
                return getMeanExp();
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP:
                return getSdExp();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)newValue);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance((ModeDistribution)newValue);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP:
                setMeanExp((Expression)newValue);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP:
                setSdExp((Expression)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)null);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance(MODE_DISTRIBUTION_INSTANCE_EDEFAULT);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP:
                setMeanExp((Expression)null);
                return;
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP:
                setSdExp((Expression)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT:
                return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
            case DistributionsPackage.NORMAL_DISTRIBUTION__DEFAULT_EXP:
                return defaultExp != null;
            case DistributionsPackage.NORMAL_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return MODE_DISTRIBUTION_INSTANCE_EDEFAULT == null ? modeDistributionInstance != null : !MODE_DISTRIBUTION_INSTANCE_EDEFAULT.equals(modeDistributionInstance);
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN:
                return MEAN_EDEFAULT == null ? getMean() != null : !MEAN_EDEFAULT.equals(getMean());
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD:
                return SD_EDEFAULT == null ? getSd() != null : !SD_EDEFAULT.equals(getSd());
            case DistributionsPackage.NORMAL_DISTRIBUTION__MEAN_EXP:
                return meanExp != null;
            case DistributionsPackage.NORMAL_DISTRIBUTION__SD_EXP:
                return sdExp != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case DistributionsPackage.NORMAL_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR:
                return createModeDistribution((RandomGenerator)arguments.get(0));
            case DistributionsPackage.NORMAL_DISTRIBUTION___EVALUATE:
                return evaluate();
            case DistributionsPackage.NORMAL_DISTRIBUTION___GET_MODE_DISTRIBUTION:
                return getModeDistribution();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (modeDistributionInstance: ");
        result.append(modeDistributionInstance);
        result.append(')');
        return result.toString();
    }

} //NormalDistributionImpl
