/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.rest.provider;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.eclipse.kura.core.keystore.request.PrivateKeyWriteRequest;
import org.eclipse.kura.core.keystore.rest.provider.KeystoreRestService;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.utils.Validable;

@Path(value="/keystores/v2")
public class KeystoreRestServiceV2
extends KeystoreRestService {
    private static final String BAD_WRITE_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: {\"keystoreServicePid\": \"MyKeystoreName\", \"alias\": \"MyAlias\", \"certificateChain\": \"...\", \"privateKey\": \"...\"}";

    @POST
    @Path(value="/entries/privatekey")
    @RolesAllowed(value={"keystores"})
    @Consumes(value={"application/json"})
    public void storeKeypairEntry(PrivateKeyWriteRequest writeRequest) {
        Validable.validate((Validable)writeRequest, (String)BAD_WRITE_REQUEST_ERROR_MESSAGE);
        try {
            this.storePrivateKeyEntryInternal(writeRequest);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

