/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.request.handler.jaxrs;

import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.request.handler.jaxrs.ResponseBodyHandlers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    private DefaultExceptionHandler() {
    }

    public static WebApplicationException toWebApplicationException(Throwable e) {
        if (e instanceof KuraException) {
            return DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
        if (e instanceof WebApplicationException) {
            return (WebApplicationException)e;
        }
        if (e instanceof InvocationTargetException && e.getCause() != null) {
            return DefaultExceptionHandler.toWebApplicationException(e.getCause());
        }
        return DefaultExceptionHandler.buildWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
    }

    public static WebApplicationException toWebApplicationException(KuraException e) {
        if (e.getCode() == KuraErrorCode.NOT_FOUND) {
            return DefaultExceptionHandler.buildWebApplicationException(Response.Status.NOT_FOUND, e.getMessage());
        }
        if (e.getCode() == KuraErrorCode.BAD_REQUEST || e.getCode() == KuraErrorCode.CONFIGURATION_ERROR) {
            return DefaultExceptionHandler.buildWebApplicationException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return DefaultExceptionHandler.buildWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
    }

    public static KuraMessage toKuraMessage(WebApplicationException e, Optional<Gson> gson) {
        Response response = e.getResponse();
        KuraResponsePayload responsePayload = new KuraResponsePayload(response.getStatus());
        try {
            ResponseBodyHandlers.responseHandler(gson.orElseGet(Gson::new)).buildBody(response).ifPresent(arg_0 -> ((KuraPayload)responsePayload).setBody(arg_0));
        }
        catch (Exception ex) {
            logger.warn("failed to serialize WebApplicationException entity", (Throwable)ex);
        }
        return new KuraMessage((KuraPayload)responsePayload);
    }

    public static WebApplicationException buildWebApplicationException(Response.Status status, String message) {
        String actualMessage = message != null ? message : "An internal error occurred";
        return new WebApplicationException(Response.status((Response.Status)status).type("application/json").entity((Object)new Failure(actualMessage)).build());
    }

    private static class Failure {
        private final String message;

        public Failure(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

