/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.BluetoothAdapter;
import org.eclipse.kura.bluetooth.BluetoothBeaconCommandListener;
import org.eclipse.kura.bluetooth.BluetoothService;
import org.eclipse.kura.linux.bluetooth.BluetoothAdapterImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothServiceImpl
implements BluetoothService {
    private static final Logger s_logger = LoggerFactory.getLogger(BluetoothServiceImpl.class);
    private static ComponentContext s_context;

    protected void activate(ComponentContext context) {
        s_logger.info("Activating Bluetooth Service...");
        s_context = context;
    }

    protected void deactivate(ComponentContext context) {
        s_logger.debug("Deactivating Bluetooth Service...");
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.getBluetoothAdapter("hci0");
    }

    public BluetoothAdapter getBluetoothAdapter(String name) {
        try {
            return new BluetoothAdapterImpl(name);
        }
        catch (KuraException e) {
            s_logger.error("Could not get bluetooth adapter", (Throwable)e);
            return null;
        }
    }

    public BluetoothAdapter getBluetoothAdapter(String name, BluetoothBeaconCommandListener bbcl) {
        try {
            BluetoothAdapterImpl bbs = new BluetoothAdapterImpl(name, bbcl);
            return bbs;
        }
        catch (KuraException e) {
            s_logger.error("Could not get bluetooth beacon service", (Throwable)e);
            return null;
        }
    }

    static BundleContext getBundleContext() {
        return s_context.getBundleContext();
    }
}

