/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KuraResponsePayload
extends KuraPayload {
    public static final int RESPONSE_CODE_OK = 200;
    public static final int RESPONSE_CODE_BAD_REQUEST = 400;
    public static final int RESPONSE_CODE_NOTFOUND = 404;
    public static final int RESPONSE_CODE_ERROR = 500;
    public static final String METRIC_RESPONSE_CODE = "response.code";
    public static final String METRIC_EXCEPTION_MSG = "response.exception.message";
    public static final String METRIC_EXCEPTION_STACK = "response.exception.stack";

    public KuraResponsePayload(int responseCode) {
        this.addMetric(METRIC_RESPONSE_CODE, responseCode);
    }

    public KuraResponsePayload(Throwable t) {
        this(500, t);
    }

    public KuraResponsePayload(int responseCode, Throwable t) {
        this.addMetric(METRIC_RESPONSE_CODE, responseCode);
        this.setException(t);
    }

    public KuraResponsePayload(KuraPayload kuraPayload) {
        for (String name : kuraPayload.metricNames()) {
            Object value = kuraPayload.getMetric(name);
            this.addMetric(name, value);
        }
        this.setBody(kuraPayload.getBody());
    }

    public int getResponseCode() {
        return (Integer)this.getMetric(METRIC_RESPONSE_CODE);
    }

    public void setResponseCode(int responseCode) {
        this.addMetric(METRIC_RESPONSE_CODE, responseCode);
    }

    public String getExceptionMessage() {
        return (String)this.getMetric(METRIC_EXCEPTION_MSG);
    }

    public void setExceptionMessage(String message) {
        if (message != null) {
            this.addMetric(METRIC_EXCEPTION_MSG, message);
        }
    }

    public String getExceptionStack() {
        return (String)this.getMetric(METRIC_EXCEPTION_STACK);
    }

    public void setExceptionStack(String stack) {
        if (stack != null) {
            this.addMetric(METRIC_EXCEPTION_STACK, stack);
        }
    }

    public void setException(Throwable t) {
        if (t != null) {
            this.addMetric(METRIC_EXCEPTION_MSG, t.getMessage());
            this.addMetric(METRIC_EXCEPTION_STACK, this.stackTraceAsString(t));
        }
    }

    private String stackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

