/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.publisher;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudConnectionManagerImpl;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudConnectionManagerOptions;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudPublisherDeliveryListener;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.publisher.CloudPublisherOptions;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.MessageConstants;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message.MessageType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPublisherImpl
implements CloudPublisher,
ConfigurableComponent,
CloudConnectionListener,
CloudPublisherDeliveryListener {
    private static final Logger logger = LoggerFactory.getLogger(CloudPublisherImpl.class);
    private static final String TOPIC_PATTERN_STRING = "\\$([^\\s/]+)";
    private static final Pattern TOPIC_PATTERN = Pattern.compile("\\$([^\\s/]+)");
    private final Set<CloudConnectionListener> cloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();
    private final Set<CloudDeliveryListener> cloudDeliveryListeners = new CopyOnWriteArraySet<CloudDeliveryListener>();
    private ServiceTrackerCustomizer<CloudConnectionManager, CloudConnectionManager> cloudConnectionManagerTrackerCustomizer;
    private ServiceTracker<CloudConnectionManager, CloudConnectionManager> cloudConnectionManagerTracker;
    private CloudPublisherOptions cloudPublisherOptions;
    private CloudConnectionManagerImpl cloudConnectionImpl;
    private BundleContext bundleContext;
    private final ExecutorService worker = Executors.newCachedThreadPool();

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Cloud Publisher...");
        this.bundleContext = componentContext.getBundleContext();
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        this.cloudConnectionManagerTrackerCustomizer = new CloudConnectionManagerTrackerCustomizer();
        this.initCloudConnectionManagerTracking();
        logger.debug("Activating Cloud Publisher... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Cloud Publisher...");
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        if (Objects.nonNull(this.cloudConnectionManagerTracker)) {
            this.cloudConnectionManagerTracker.close();
        }
        this.initCloudConnectionManagerTracking();
        logger.debug("Updating Cloud Publisher... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Cloud Publisher...");
        if (Objects.nonNull(this.cloudConnectionManagerTracker)) {
            this.cloudConnectionManagerTracker.close();
        }
        this.worker.shutdown();
        logger.debug("Deactivating Cloud Publisher... Done");
    }

    public String publish(KuraMessage message) throws KuraException {
        if (this.cloudConnectionImpl == null) {
            logger.info("Null cloud service");
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE);
        }
        if (message == null) {
            logger.warn("Received null message!");
            throw new IllegalArgumentException();
        }
        MessageType messageType = this.cloudPublisherOptions.getMessageType();
        String fullTopic = this.encodeFullTopic(message, messageType.getTopicPrefix());
        int qos = messageType.getQos();
        boolean retain = false;
        int priority = messageType.getPriority();
        HashMap<String, Object> publishMessageProps = new HashMap<String, Object>();
        publishMessageProps.put(MessageConstants.FULL_TOPIC.name(), fullTopic);
        publishMessageProps.put(MessageConstants.QOS.name(), qos);
        publishMessageProps.put(MessageConstants.RETAIN.name(), retain);
        publishMessageProps.put(MessageConstants.PRIORITY.name(), priority);
        KuraMessage publishMessage = new KuraMessage(message.getPayload(), publishMessageProps);
        return this.cloudConnectionImpl.publish(publishMessage);
    }

    private String encodeFullTopic(KuraMessage message, String topicPrefix) {
        String fullTopic = this.encodeTopic(topicPrefix, this.cloudPublisherOptions.getSemanticTopic());
        return this.fillTopicPlaceholders(fullTopic, message);
    }

    private void initCloudConnectionManagerTracking() {
        String selectedCloudServicePid = this.cloudPublisherOptions.getCloudServicePid();
        String filterString = String.format("(&(%s=%s)(kura.service.pid=%s))", "objectClass", CloudConnectionManager.class.getName(), selectedCloudServicePid);
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Filter setup exception ", (Throwable)e);
        }
        this.cloudConnectionManagerTracker = new ServiceTracker(this.bundleContext, filter, this.cloudConnectionManagerTrackerCustomizer);
        this.cloudConnectionManagerTracker.open();
    }

    private String encodeTopic(String topicPrefix, String semanticTopic) {
        CloudConnectionManagerOptions options = this.cloudConnectionImpl.getCloudConnectionManagerOptions();
        String topicSeparator = options.getTopicSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(topicPrefix).append(topicSeparator).append(topicSeparator);
        if (semanticTopic != null && !semanticTopic.isEmpty()) {
            sb.append(topicSeparator).append(semanticTopic);
        }
        return sb.toString();
    }

    private String fillTopicPlaceholders(String semanticTopic, KuraMessage message) {
        Matcher matcher = TOPIC_PATTERN.matcher(semanticTopic);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            Map properties = message.getProperties();
            if (!properties.containsKey(matcher.group(1))) continue;
            String replacement = matcher.group(0);
            Object value = properties.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, value.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void onDisconnected() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onDisconnected()));
    }

    public void onConnectionLost() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onConnectionLost()));
    }

    public void onConnectionEstablished() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onConnectionEstablished()));
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.remove(cloudDeliveryListener);
    }

    @Override
    public void onMessageConfirmed(String messageId, String topic) {
        int index;
        String[] semanticTopicElements;
        String semanticTopicComparisonElement;
        CloudConnectionManagerOptions options = this.cloudConnectionImpl.getCloudConnectionManagerOptions();
        String topicSeparator = options.getTopicSeparator();
        String[] messageSemanticTopicElements = this.getMessageSemanticTopicElements(topic, topicSeparator, semanticTopicComparisonElement = (semanticTopicElements = this.cloudPublisherOptions.getSemanticTopic().split(topicSeparator))[index = this.getSemanticTopicComparisonOffset(semanticTopicElements)]);
        if (messageSemanticTopicElements.length == 0) {
            return;
        }
        index = 0;
        String[] stringArray = semanticTopicElements;
        int n = semanticTopicElements.length;
        int n2 = 0;
        while (n2 < n) {
            String semanticTopicElement = stringArray[n2];
            if (!semanticTopicElement.equals(messageSemanticTopicElements[index])) {
                return;
            }
            ++index;
            ++n2;
        }
        this.cloudDeliveryListeners.forEach(deliveryListener -> this.worker.execute(() -> deliveryListener.onMessageConfirmed(messageId)));
    }

    private String[] getMessageSemanticTopicElements(String topic, String topicSeparator, String semanticTopicComparisonElement) {
        int messagePostfixTopicOffset = topic.indexOf(semanticTopicComparisonElement);
        if (messagePostfixTopicOffset >= 0) {
            String messagePostfixTopic = topic.substring(messagePostfixTopicOffset, topic.length());
            return messagePostfixTopic.split(topicSeparator);
        }
        return new String[0];
    }

    private int getSemanticTopicComparisonOffset(String[] semanticTopicElements) {
        int index = 0;
        String[] stringArray = semanticTopicElements;
        int n = semanticTopicElements.length;
        int n2 = 0;
        while (n2 < n) {
            String semanticTopicElement = stringArray[n2];
            if (!semanticTopicElement.startsWith("$")) break;
            ++index;
            ++n2;
        }
        return index;
    }

    private final class CloudConnectionManagerTrackerCustomizer
    implements ServiceTrackerCustomizer<CloudConnectionManager, CloudConnectionManager> {
        private CloudConnectionManagerTrackerCustomizer() {
        }

        public CloudConnectionManager addingService(ServiceReference<CloudConnectionManager> reference) {
            CloudConnectionManager tempCloudService = (CloudConnectionManager)CloudPublisherImpl.this.bundleContext.getService(reference);
            if (tempCloudService instanceof CloudConnectionManagerImpl) {
                CloudPublisherImpl.this.cloudConnectionImpl = (CloudConnectionManagerImpl)tempCloudService;
                CloudPublisherImpl.this.cloudConnectionImpl.registerCloudConnectionListener(CloudPublisherImpl.this);
                CloudPublisherImpl.this.cloudConnectionImpl.registerCloudPublisherDeliveryListener(CloudPublisherImpl.this);
                return tempCloudService;
            }
            CloudPublisherImpl.this.bundleContext.ungetService(reference);
            return null;
        }

        public void removedService(ServiceReference<CloudConnectionManager> reference, CloudConnectionManager service) {
            CloudPublisherImpl.this.cloudConnectionImpl.unregisterCloudConnectionListener(CloudPublisherImpl.this);
            CloudPublisherImpl.this.cloudConnectionImpl.unregisterCloudPublisherDeliveryListener(CloudPublisherImpl.this);
            CloudPublisherImpl.this.cloudConnectionImpl = null;
        }

        public void modifiedService(ServiceReference<CloudConnectionManager> reference, CloudConnectionManager service) {
        }
    }
}

