/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.status;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.messages.ValidationMessages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.EventService;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.eclipse.kura.web.shared.service.GwtStatusService;
import org.eclipse.kura.web.shared.service.GwtStatusServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Well;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class StatusPanelUi
extends Composite {
    private static final Logger logger = Logger.getLogger(StatusPanelUi.class.getSimpleName());
    private static StatusPanelUiUiBinder uiBinder = (StatusPanelUiUiBinder)GWT.create(StatusPanelUiUiBinder.class);
    private static final ValidationMessages msgs = (ValidationMessages)GWT.create(ValidationMessages.class);
    private static final Messages MSG = (Messages)GWT.create(Messages.class);
    private final GwtStatusServiceAsync gwtStatusService = (GwtStatusServiceAsync)GWT.create(GwtStatusService.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private GwtSession currentSession;
    private final ListDataProvider<GwtGroupedNVPair> statusGridProvider = new ListDataProvider();
    private EntryClassUi parent;
    @UiField
    Well statusWell;
    @UiField
    Button statusRefresh;
    @UiField
    CellTable<GwtGroupedNVPair> statusGrid = new CellTable();

    public StatusPanelUi() {
        logger.log(Level.FINER, "Initializing StatusPanelUi...");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.statusRefresh.setText(MSG.refresh());
        this.statusGrid.setRowStyles((RowStyles)new RowStyles<GwtGroupedNVPair>(){

            public String getStyleNames(GwtGroupedNVPair row, int rowIndex) {
                if ("Cloud Services".equals(row.getName()) || "Connection Name".equals(row.getName()) || "Ethernet Settings".equals(row.getName()) || "Wireless Settings".equals(row.getName()) || "Cellular Settings".equals(row.getName()) || "Position Status".equals(row.getName())) {
                    return "rowHeader";
                }
                return " ";
            }
        });
        this.loadStatusTable(this.statusGrid, this.statusGridProvider);
        this.statusRefresh.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StatusPanelUi.this.loadStatusData();
            }
        });
        EventService.Handler connectionStateChangeHandler = new EventService.Handler(){

            @Override
            public void handleEvent(GwtEventInfo eventInfo) {
                if (StatusPanelUi.this.isVisible() && StatusPanelUi.this.isAttached()) {
                    StatusPanelUi.this.loadStatusData();
                }
            }
        };
        EventService.subscribe(ForwardedEventTopic.CLOUD_CONNECTION_STATUS_ESTABLISHED, connectionStateChangeHandler);
        EventService.subscribe(ForwardedEventTopic.CLOUD_CONNECTION_STATUS_LOST, connectionStateChangeHandler);
    }

    public void setSession(GwtSession gwtBSSession) {
        this.currentSession = gwtBSSession;
    }

    public void loadStatusTable(CellTable<GwtGroupedNVPair> grid, ListDataProvider<GwtGroupedNVPair> dataProvider) {
        TextColumn<GwtGroupedNVPair> col1 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return String.valueOf(object.getName());
            }
        };
        col1.setCellStyleNames("status-table-row");
        grid.addColumn((Column)col1);
        Column<GwtGroupedNVPair, SafeHtml> col2 = new Column<GwtGroupedNVPair, SafeHtml>((Cell)new SafeHtmlCell()){

            public SafeHtml getValue(GwtGroupedNVPair object) {
                return SafeHtmlUtils.fromTrustedString((String)String.valueOf(object.getValue()));
            }
        };
        col2.setCellStyleNames("status-table-row");
        grid.addColumn((Column)col2);
        dataProvider.addDataDisplay(grid);
    }

    public void loadStatusData() {
        this.statusGridProvider.getList().clear();
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                StatusPanelUi.this.gwtStatusService.getDeviceConfig(token, StatusPanelUi.this.currentSession.isNetAdminAvailable(), new AsyncCallback<ArrayList<GwtGroupedNVPair>>(){

                    public void onFailure(Throwable caught) {
                        FailureHandler.handle(caught);
                        StatusPanelUi.this.statusGridProvider.flush();
                        EntryClassUi.hideWaitModal();
                    }

                    public void onSuccess(ArrayList<GwtGroupedNVPair> result) {
                        String title = "cloudStatus";
                        StatusPanelUi.this.statusGridProvider.getList().add(new GwtGroupedNVPair(" ", msgs.getString(title), " "));
                        for (GwtGroupedNVPair connectionName : result) {
                            if (!title.equals(connectionName.getGroup())) {
                                title = connectionName.getGroup();
                                StatusPanelUi.this.statusGridProvider.getList().add(new GwtGroupedNVPair(" ", msgs.getString(title), " "));
                            }
                            StatusPanelUi.this.statusGridProvider.getList().add(connectionName);
                        }
                        int size = StatusPanelUi.this.statusGridProvider.getList().size();
                        (this).StatusPanelUi.this.statusGrid.setVisibleRange(0, size);
                        StatusPanelUi.this.statusGridProvider.flush();
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    public void setParent(EntryClassUi parent) {
        this.parent = parent;
    }

    static interface StatusPanelUiUiBinder
    extends UiBinder<Widget, StatusPanelUi> {
    }
}

