/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCertificatesService;
import org.eclipse.kura.web.shared.service.GwtCertificatesServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Span;

public class ApplicationCertsTabUi
extends Composite
implements Tab {
    private static ApplicationCertsTabUiUiBinder uiBinder = (ApplicationCertsTabUiUiBinder)GWT.create(ApplicationCertsTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtCertificatesServiceAsync gwtCertificatesService = (GwtCertificatesServiceAsync)GWT.create(GwtCertificatesService.class);
    private boolean dirty;
    @UiField
    Form appCertsForm;
    @UiField
    FormGroup groupStorageAlias;
    @UiField
    FormGroup groupFormCert;
    @UiField
    HTMLPanel description;
    @UiField
    FormLabel storageAliasLabel;
    @UiField
    FormLabel certificateLabel;
    @UiField
    TextArea formCert;
    @UiField
    Input formStorageAlias;
    @UiField
    Button reset;
    @UiField
    Button apply;

    public ApplicationCertsTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initForm();
        this.setDirty(false);
        this.apply.setEnabled(false);
        this.reset.setEnabled(false);
    }

    @Override
    public boolean isValid() {
        boolean validAlias = this.isAliasValid();
        boolean validAppCert = this.isAppCertValid();
        return validAlias && validAppCert;
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.reset();
        }
    }

    private void initForm() {
        this.description.add((Widget)new Span("<p>" + MSGS.settingsAddBundleCertsDescription() + "</p>"));
        this.storageAliasLabel.setText(MSGS.settingsStorageAliasLabel());
        this.formStorageAlias.addChangeHandler(event -> {
            this.isAliasValid();
            this.setDirty(true);
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        });
        this.certificateLabel.setText(MSGS.settingsPublicCertLabel());
        this.formCert.setVisibleLines(20);
        this.formCert.addChangeHandler(event -> {
            this.isAppCertValid();
            this.setDirty(true);
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        });
        this.reset.setText(MSGS.reset());
        this.reset.addClickHandler(event -> {
            this.reset();
            this.setDirty(false);
            this.apply.setEnabled(false);
            this.reset.setEnabled(false);
        });
        this.apply.setText(MSGS.apply());
        this.apply.addClickHandler(event -> {
            if (this.isValid()) {
                EntryClassUi.showWaitModal();
                this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                        EntryClassUi.hideWaitModal();
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        ApplicationCertsTabUi.this.gwtCertificatesService.storeApplicationPublicChain(token, ApplicationCertsTabUi.this.formCert.getValue(), (String)ApplicationCertsTabUi.this.formStorageAlias.getValue(), new AsyncCallback<Integer>(){

                            public void onFailure(Throwable caught) {
                                FailureHandler.handle(caught);
                                EntryClassUi.hideWaitModal();
                            }

                            public void onSuccess(Integer certsStored) {
                                ApplicationCertsTabUi.this.reset();
                                ApplicationCertsTabUi.this.setDirty(false);
                                (this).ApplicationCertsTabUi.this.apply.setEnabled(false);
                                (this).ApplicationCertsTabUi.this.reset.setEnabled(false);
                                EntryClassUi.hideWaitModal();
                            }
                        });
                    }
                });
            }
        });
    }

    private void reset() {
        this.formStorageAlias.setText("");
        this.formCert.setText("");
    }

    private boolean isAliasValid() {
        if (this.formStorageAlias.getText() == null || "".equals(this.formStorageAlias.getText().trim())) {
            this.groupStorageAlias.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.groupStorageAlias.setValidationState(ValidationState.NONE);
        return true;
    }

    private boolean isAppCertValid() {
        if (this.formCert.getText() == null || "".equals(this.formCert.getText().trim())) {
            this.groupFormCert.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.groupFormCert.setValidationState(ValidationState.NONE);
        return true;
    }

    static interface ApplicationCertsTabUiUiBinder
    extends UiBinder<Widget, ApplicationCertsTabUi> {
    }
}

