/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ne extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "नाउरू";
        final String metaValue_WS = "सामोआ";
        final String metaValue_ar = "अरबी";
        final String metaValue_hy = "आर्मेनियाली";
        final String metaValue_ban = "बाली";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_ka = "जर्जियाली";
        final String metaValue_got = "गोथिक";
        final String metaValue_el = "ग्रीक";
        final String metaValue_gu = "गुजराती";
        final String metaValue_he = "हिब्रु";
        final String metaValue_jv = "जाभानी";
        final String metaValue_ja = "जापानी";
        final String metaValue_km = "खमेर";
        final String metaValue_lo = "लाओ";
        final String metaValue_la = "ल्याटिन";
        final String metaValue_syr = "सिरियाक";
        final String metaValue_ta = "तामिल";
        final String metaValue_te = "तेलुगु";
        final String metaValue_th = "थाई";
        final String metaValue_bo = "तिब्बती";
        final String metaValue_vai = "भाइ";
        final String metaValue_Hans = "सरलिकृत चिनियाँ";
        final String metaValue_Deva = "देवानागरी";
        final Object[][] data = new Object[][] {
            { "001", "विश्व" },
            { "002", "अफ्रिका" },
            { "003", "उत्तर अमेरिका" },
            { "005", "दक्षिण अमेरिका" },
            { "009", "ओसनिया" },
            { "011", "पश्चिमी अफ्रिका" },
            { "013", "केन्द्रीय अमेरिका" },
            { "014", "पूर्वी अफ्रिका" },
            { "015", "उत्तरी अफ्रिका" },
            { "017", "मध्य अफ्रिका" },
            { "018", "दक्षिणी अफ्रिका" },
            { "019", "अमेरिकास" },
            { "021", "उत्तरी अमेरिका" },
            { "029", "क्यारिबियन" },
            { "030", "पूर्वी एशिया" },
            { "034", "दक्षिणी एशिया" },
            { "035", "दक्षिण पूर्वी एशिया" },
            { "039", "दक्षिणी युरोप" },
            { "053", "अष्ट्रालासिया" },
            { "054", "मेलानेसिया" },
            { "057", "माइक्रोनेसियाली क्षेत्र" },
            { "061", "पोलिनेशिया" },
            { "142", "एशिया" },
            { "143", "केन्द्रीय एशिया" },
            { "145", "पश्चिमी एशिया" },
            { "150", "युरोप" },
            { "151", "पूर्वी युरोप" },
            { "154", "उत्तरी युरोप" },
            { "155", "पश्चिमी युरोप" },
            { "202", "उप-साहारा अफ्रिका" },
            { "419", "ल्याटिन अमेरिका" },
            { "AC", "असेन्सन टापु" },
            { "AD", "अन्डोर्रा" },
            { "AE", "संयुक्त अरब इमिराट्स" },
            { "AF", "अफगानिस्तान" },
            { "AG", "एन्टिगुआ र बारबुडा" },
            { "AI", "आङ्गुइला" },
            { "AL", "अल्बेनिया" },
            { "AM", "आर्मेनिया" },
            { "AO", "अङ्गोला" },
            { "AQ", "अन्टारटिका" },
            { "AR", "अर्जेन्टिना" },
            { "AS", "अमेरिकी समोआ" },
            { "AT", "अष्ट्रिया" },
            { "AU", "अस्ट्रेलिया" },
            { "AW", "अरुबा" },
            { "AX", "अलान्ड टापुहरु" },
            { "AZ", "अजरबैजान" },
            { "BA", "बोस्निया एण्ड हर्जगोभिनिया" },
            { "BB", "बार्बाडोस" },
            { "BD", "बङ्गलादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्किना फासो" },
            { "BG", "बुल्गेरिया" },
            { "BH", "बहराइन" },
            { "BI", "बुरूण्डी" },
            { "BJ", "बेनिन" },
            { "BL", "सेन्ट बार्थेलेमी" },
            { "BM", "बर्मुडा" },
            { "BN", "ब्रुनाइ" },
            { "BO", "बोलिभिया" },
            { "BQ", "क्यारिवियन नेदरल्याण्ड्स" },
            { "BR", "ब्राजिल" },
            { "BS", "बहामास" },
            { "BT", "भुटान" },
            { "BV", "बुभेट टापु" },
            { "BW", "बोट्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलिज" },
            { "CA", "क्यानाडा" },
            { "CC", "कोकोस (किलिंग) टापुहरु" },
            { "CD", "कङ्गो - किन्शासा" },
            { "CF", "मध्य अफ्रिकी गणतन्त्र" },
            { "CG", "कङ्गो ब्राजाभिल" },
            { "CH", "स्विजरल्याण्ड" },
            { "CI", "कोट दिभोर" },
            { "CK", "कुक टापुहरु" },
            { "CL", "चिली" },
            { "CM", "क्यामरून" },
            { "CN", "चीन" },
            { "CO", "कोलोम्बिया" },
            { "CP", "क्लिप्पेर्टन टापु" },
            { "CQ", "सार्क" },
            { "CR", "कोष्टारिका" },
            { "CU", "क्युबा" },
            { "CV", "केप भर्डे" },
            { "CW", "कुराकाओ" },
            { "CX", "क्रिष्टमस टापु" },
            { "CY", "साइप्रस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डियगो गार्सिया" },
            { "DJ", "डिजिबुटी" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन गणतन्त्र" },
            { "DZ", "अल्जेरिया" },
            { "EA", "सिउटा र मेलिला" },
            { "EC", "इक्वेडोर" },
            { "EE", "इस्टोनिया" },
            { "EG", "इजिप्ट" },
            { "EH", "पश्चिमी साहारा" },
            { "ER", "एरिट्रीया" },
            { "ES", "स्पेन" },
            { "ET", "इथियोपिया" },
            { "EU", "युरोपियन युनियन" },
            { "EZ", "युरोजोन" },
            { "FI", "फिनल्याण्ड" },
            { "FJ", "फिजी" },
            { "FK", "फकल्याण्ड टापुहरु" },
            { "FM", "माइक्रोनेसिया" },
            { "FO", "फारो टापुहरू" },
            { "FR", "फ्रान्स" },
            { "GA", "गावोन" },
            { "GB", "संयुक्त अधिराज्य" },
            { "GD", "ग्रेनाडा" },
            { "GE", "जर्जिया" },
            { "GF", "फ्रान्सेली गायना" },
            { "GG", "ग्यूर्न्सी" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टार" },
            { "GL", "ग्रिनल्याण्ड" },
            { "GM", "गाम्विया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलुप" },
            { "GQ", "भू-मध्यीय गिनी" },
            { "GR", "ग्रीस" },
            { "GS", "दक्षिण जर्जिया र दक्षिण स्यान्डवीच टापुहरू" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुवाम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गुयाना" },
            { "HK", "हङकङ चिनियाँ विशेष प्रशासनिक क्षेत्र" },
            { "HM", "हर्ड टापु र म्याकडोनाल्ड टापुहरु" },
            { "HN", "हन्डुरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैटी" },
            { "HU", "हङ्गेरी" },
            { "IC", "क्यानारी टापुहरू" },
            { "ID", "इन्डोनेशिया" },
            { "IE", "आयरल्याण्ड" },
            { "IL", "इजरायल" },
            { "IM", "आइल अफ म्यान" },
            { "IN", "भारत" },
            { "IO", "बेलायती हिन्द महासागर क्षेत्र" },
            { "IQ", "इराक" },
            { "IR", "इरान" },
            { "IS", "आइस्ल्याण्ड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमैका" },
            { "JO", "जोर्डन" },
            { "JP", "जापान" },
            { "KE", "केन्या" },
            { "KG", "किर्गिस्तान" },
            { "KH", "कम्बोडिया" },
            { "KI", "किरिबाटी" },
            { "KM", "कोमोरोस" },
            { "KN", "सेन्ट किट्स र नेभिस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दक्षिण कोरिया" },
            { "KW", "कुवेत" },
            { "KY", "केयमान टापु" },
            { "KZ", "काजाकस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनन" },
            { "LC", "सेन्ट लुसिया" },
            { "LI", "लिकटेन्सटाइन" },
            { "LK", "श्रीलङ्का" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लिथुएनिया" },
            { "LU", "लक्जेमबर्ग" },
            { "LV", "लाट्भिया" },
            { "LY", "लिबिया" },
            { "MA", "मोरोक्को" },
            { "MC", "मोनाको" },
            { "MD", "माल्डोभा" },
            { "ME", "मोन्टेनिग्रो" },
            { "MF", "सेन्ट मार्टिन" },
            { "MG", "माडागास्कर" },
            { "MH", "मार्शल टापुहरु" },
            { "MK", "उत्तर म्यासेडोनिया" },
            { "ML", "माली" },
            { "MM", "म्यान्मार (बर्मा)" },
            { "MN", "मङ्गोलिया" },
            { "MO", "मकाउ चिनियाँ विशेष प्रशासनिक क्षेत्र" },
            { "MP", "उत्तरी मारिआना टापु" },
            { "MQ", "मार्टिनिक" },
            { "MR", "माउरिटानिया" },
            { "MS", "मोन्टसेर्राट" },
            { "MT", "माल्टा" },
            { "MU", "मौरिसियस" },
            { "MV", "माल्दिभ्स" },
            { "MW", "मालावी" },
            { "MX", "मेक्सिको" },
            { "MY", "मलेसिया" },
            { "MZ", "मोजाम्बिक" },
            { "NA", "नामिबिया" },
            { "NC", "न्यु क्यालेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नोरफोल्क टापु" },
            { "NG", "नाइजेरिया" },
            { "NI", "निकारागुवा" },
            { "NL", "नेदरल्याण्ड" },
            { "NO", "नर्वे" },
            { "NP", "नेपाल" },
            { "NR", metaValue_NR },
            { "NU", "नियुइ" },
            { "NZ", "न्युजिल्याण्ड" },
            { "OM", "ओमन" },
            { "PA", "प्यानामा" },
            { "PE", "पेरू" },
            { "PF", "फ्रान्सेली पोलिनेसिया" },
            { "PG", "पपुआ न्यू गाइनिया" },
            { "PH", "फिलिपिन्स" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोल्याण्ड" },
            { "PM", "सेन्ट पिर्रे र मिक्केलोन" },
            { "PN", "पिटकाइर्न टापुहरु" },
            { "PR", "पुएर्टो रिको" },
            { "PS", "प्यालेस्टिनी भू-भागहरू" },
            { "PT", "पोर्चुगल" },
            { "PW", "पलाउ" },
            { "PY", "प्याराग्वे" },
            { "QA", "कतार" },
            { "QO", "बाह्य ओसनिया" },
            { "RE", "रियुनियन" },
            { "RO", "रोमेनिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "रवाण्डा" },
            { "SA", "साउदी अरब" },
            { "SB", "सोलोमन टापुहरू" },
            { "SC", "सेचेलेस" },
            { "SD", "सुडान" },
            { "SE", "स्विडेन" },
            { "SG", "सिङ्गापुर" },
            { "SH", "सेन्ट हेलेना" },
            { "SI", "स्लोभेनिया" },
            { "SJ", "सभाल्बार्ड र जान मायेन" },
            { "SK", "स्लोभाकिया" },
            { "SL", "सिएर्रा लिओन" },
            { "SM", "सान् मारिनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सुरिनेम" },
            { "SS", "दक्षिण सुडान" },
            { "ST", "साओ टोमे र प्रिन्सिप" },
            { "SV", "एल् साल्भाडोर" },
            { "SX", "सिन्ट मार्टेन" },
            { "SY", "सिरिया" },
            { "SZ", "स्वाजिल्याण्ड" },
            { "TA", "ट्रिस्टान डा कुन्हा" },
            { "TC", "तुर्क र काइकोस टापु" },
            { "TD", "चाड" },
            { "TF", "फ्रेन्च दक्षिणी राज्यहरू" },
            { "TG", "टोगो" },
            { "TH", "थाइल्याण्ड" },
            { "TJ", "ताजिकिस्तान" },
            { "TK", "तोकेलाउ" },
            { "TL", "टिमोर-लेस्टे" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्युनिसिया" },
            { "TO", "टोंगा" },
            { "TR", "तुर्किये" },
            { "TT", "त्रिनिडाड एण्ड टोबागो" },
            { "TV", "तुभालु" },
            { "TW", "ताइवान" },
            { "TZ", "तान्जानिया" },
            { "UA", "युक्रेन" },
            { "UG", "युगाण्डा" },
            { "UM", "संयुक्त राज्यका बाह्य टापुहरु" },
            { "UN", "संयुक्त राष्ट्र संघ" },
            { "US", "संयुक्त राज्य" },
            { "UY", "उरूग्वे" },
            { "UZ", "उज्बेकिस्तान" },
            { "VA", "भेटिकन सिटी" },
            { "VC", "सेन्ट भिन्सेन्ट र ग्रेनाडिन्स" },
            { "VE", "भेनेजुएला" },
            { "VG", "बेलायती भर्जिन टापुहरू" },
            { "VI", "संयुक्त राज्य भर्जिन टापुहरु" },
            { "VN", "भिएतनाम" },
            { "VU", "भानुआतु" },
            { "WF", "वालिस र फुटुना" },
            { "WS", metaValue_WS },
            { "XA", "सिउडो-एक्सेन्ट्स" },
            { "XB", "सिउडो-बिडी" },
            { "XK", "कोसोभो" },
            { "YE", "येमेन" },
            { "YT", "मायोट्ट" },
            { "ZA", "दक्षिण अफ्रिका" },
            { "ZM", "जाम्बिया" },
            { "ZW", "जिम्बाबवे" },
            { "ZZ", "अज्ञात क्षेत्र" },
            { "aa", "अफार" },
            { "ab", "अब्खाजियाली" },
            { "ae", "अवेस्तान" },
            { "af", "अफ्रिकान्स" },
            { "ak", "आकान" },
            { "am", "अम्हारिक" },
            { "an", "अरागोनी" },
            { "ar", metaValue_ar },
            { "as", "आसामी" },
            { "av", "अवारिक" },
            { "ay", "ऐमारा" },
            { "az", "अजरबैजानी" },
            { "ba", "बास्किर" },
            { "be", "बेलारुसी" },
            { "bg", "बुल्गेरियाली" },
            { "bi", "बिस्लाम" },
            { "bm", "बाम्बारा" },
            { "bn", "बंगाली" },
            { "bo", metaValue_bo },
            { "br", "ब्रेटन" },
            { "bs", "बोस्नियाली" },
            { "ca", "क्याटालन" },
            { "ce", "चेचेन" },
            { "ch", "चामोर्रो" },
            { "co", "कोर्सिकन" },
            { "cr", "क्री" },
            { "cs", "चेक" },
            { "cu", "चर्च स्लाभिक" },
            { "cv", "चुभास" },
            { "cy", "वेल्श" },
            { "da", "डेनिस" },
            { "de", "जर्मन" },
            { "dv", "दिबेही" },
            { "dz", "जोङ्खा" },
            { "ee", "इवी" },
            { "el", metaValue_el },
            { "en", "अङ्ग्रेजी" },
            { "eo", "एस्पेरान्तो" },
            { "es", "स्पेनी" },
            { "et", "इस्टोनियन" },
            { "eu", "बास्क" },
            { "fa", "फारसी" },
            { "ff", "फुलाह" },
            { "fi", "फिनिस" },
            { "fj", "फिजियन" },
            { "fo", "फारोज" },
            { "fr", "फ्रान्सेली" },
            { "fy", "पश्चिमी फ्रिसियन" },
            { "ga", "आइरिस" },
            { "gd", "स्कटिस गाएलिक" },
            { "gl", "गलिसियाली" },
            { "gn", "गुवारानी" },
            { "gu", metaValue_gu },
            { "gv", "मान्क्स" },
            { "ha", "हाउसा" },
            { "he", metaValue_he },
            { "hi", "हिन्दी" },
            { "ho", "हिरी मोटु" },
            { "hr", "क्रोयसियाली" },
            { "ht", "हैटियाली क्रियोल" },
            { "hu", "हङ्गेरियाली" },
            { "hy", metaValue_hy },
            { "hz", "हेरेरो" },
            { "ia", "इन्टर्लिङ्गुआ" },
            { "id", "इन्डोनेसियाली" },
            { "ie", "इन्टरलिङ्ग्वे" },
            { "ig", "इग्बो" },
            { "ii", "सिचुआन यि" },
            { "ik", "इनुपिआक्" },
            { "io", "इडो" },
            { "is", "आइसल्यान्डियाली" },
            { "it", "इटालेली" },
            { "iu", "इनुक्टिटुट" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "कोङ्गो" },
            { "ki", "किकुयु" },
            { "kj", "कुआन्यामा" },
            { "kk", "काजाख" },
            { "kl", "कालालिसुट" },
            { "km", metaValue_km },
            { "kn", "कन्नाडा" },
            { "ko", "कोरियाली" },
            { "kr", "कानुरी" },
            { "ks", "कास्मिरी" },
            { "ku", "कुर्मान्जी" },
            { "kv", "कोमी" },
            { "kw", "कोर्निस" },
            { "ky", "किर्गिज" },
            { "la", metaValue_la },
            { "lb", "लक्जेम्बर्गी" },
            { "lg", "गान्डा" },
            { "li", "लिम्बुर्गी" },
            { "ln", "लिङ्गाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियाली" },
            { "lu", "लुबा-काताङ्गा" },
            { "lv", "लात्भियाली" },
            { "mg", "मलागासी" },
            { "mh", "मार्साली" },
            { "mi", "माओरी" },
            { "mk", "म्यासेडोनियन" },
            { "ml", "मलयालम" },
            { "mn", "मङ्गोलियाली" },
            { "mr", "मराठी" },
            { "ms", "मलाय" },
            { "mt", "माल्टिज" },
            { "my", "बर्मेली" },
            { "na", metaValue_NR },
            { "nb", "नर्वेली बोकमाल" },
            { "nd", "उत्तरी न्डेबेले" },
            { "ne", "नेपाली" },
            { "ng", "न्दोन्गा" },
            { "nl", "डच" },
            { "nn", "नर्वेली नाइनोर्स्क" },
            { "no", "नर्वेली" },
            { "nr", "दक्षिण न्देबेले" },
            { "nv", "नाभाजो" },
            { "ny", "न्यान्जा" },
            { "oc", "अक्सिटन" },
            { "oj", "ओजिब्वा" },
            { "om", "ओरोमो" },
            { "or", "उडिया" },
            { "os", "ओस्सेटिक" },
            { "pa", "पंजाबी" },
            { "pi", "पाली" },
            { "pl", "पोलिस" },
            { "ps", "पास्तो" },
            { "pt", "पोर्तुगी" },
            { "qu", "क्वेचुवा" },
            { "rm", "रोमानिस" },
            { "rn", "रुन्डी" },
            { "ro", "रोमानियाली" },
            { "ru", "रसियाली" },
            { "rw", "किन्यारवान्डा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्डिनियाली" },
            { "sd", "सिन्धी" },
            { "se", "उत्तरी सामी" },
            { "sg", "साङ्गो" },
            { "si", "सिन्हाली" },
            { "sk", "स्लोभाकियाली" },
            { "sl", "स्लोभेनियाली" },
            { "sm", metaValue_WS },
            { "sn", "शोना" },
            { "so", "सोमाली" },
            { "sq", "अल्बानियाली" },
            { "sr", "सर्बियाली" },
            { "ss", "स्वाती" },
            { "st", "दक्षिणी सोथो" },
            { "su", "सुडानी" },
            { "sv", "स्विडिस" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "टिग्रिन्या" },
            { "tk", "टर्कमेन" },
            { "tn", "ट्स्वाना" },
            { "to", "टोङ्गन" },
            { "tr", "टर्किश" },
            { "ts", "ट्सोङ्गा" },
            { "tt", "तातार" },
            { "ty", "टाहिटियन" },
            { "ug", "उइघुर" },
            { "uk", "युक्रेनी" },
            { "ur", "उर्दु" },
            { "uz", "उज्बेकी" },
            { "ve", "भेन्डा" },
            { "vi", "भियतनामी" },
            { "vo", "भोलापिक" },
            { "wa", "वाल्लुन" },
            { "wo", "वुलुफ" },
            { "xh", "खोसा" },
            { "yi", "यिद्दिस" },
            { "yo", "योरूवा" },
            { "za", "झुुआङ्ग" },
            { "zh", "चिनियाँ" },
            { "zu", "जुलु" },
            { "ace", "अचाइनिज" },
            { "ach", "अकोली" },
            { "ada", "अदाङमे" },
            { "ady", "अदिघे" },
            { "afh", "अफ्रिहिली" },
            { "agq", "आघेम" },
            { "ain", "अइनु" },
            { "akk", "अक्कादियाली" },
            { "akz", "अलाबामा" },
            { "ale", "अलेउट" },
            { "aln", "घेग अल्बानियाली" },
            { "alt", "दक्षिणी आल्टाइ" },
            { "ang", "पुरातन अङ्ग्रेजी" },
            { "ann", "ओबोलो" },
            { "anp", "अङ्गिका" },
            { "arc", "अरामाइक" },
            { "arn", "मापुचे" },
            { "aro", "अराओना" },
            { "arp", "अरापाहो" },
            { "arq", "अल्जेरियाली अरबी" },
            { "ars", "नाज्दी अरविक" },
            { "arw", "अरावाक" },
            { "ary", "मोरोक्कोली अरबी" },
            { "arz", "इजिप्ट अरबी" },
            { "asa", "आसु" },
            { "ase", "अमेरिकी साङ्केतिक भाषा" },
            { "ast", "अस्टुरियाली" },
            { "atj", "आतिकामिको" },
            { "avk", "कोटावा" },
            { "awa", "अवधी" },
            { "bal", "बालुची" },
            { "ban", metaValue_ban },
            { "bar", "बाभारियाली" },
            { "bas", "बासा" },
            { "bax", "बामुन" },
            { "bbc", "बाताक तोबा" },
            { "bbj", "घोमाला" },
            { "bej", "बेजा" },
            { "bem", "बेम्बा" },
            { "bew", "बेटावी" },
            { "bez", "बेना" },
            { "bfd", "बाफुट" },
            { "bfq", "बडागा" },
            { "bgc", "हरयाणवी" },
            { "bgn", "पश्चिम बालोची" },
            { "bho", "भोजपुरी" },
            { "bik", "बिकोल" },
            { "bin", "बिनी" },
            { "bjn", "बन्जार" },
            { "bkm", "कोम" },
            { "bla", "सिक्सिका" },
            { "blo", "अनी" },
            { "bpy", "विष्णुप्रिया" },
            { "bqi", "बाख्तिआरी" },
            { "bra", "ब्रज" },
            { "brh", "ब्राहुइ" },
            { "brx", "बोडो" },
            { "bss", "अकुज" },
            { "bua", "बुरिआत" },
            { "bug", "बुगिनियाली" },
            { "bum", "बुलु" },
            { "byn", "ब्लिन" },
            { "byv", "मेडुम्बा" },
            { "cad", "काड्डो" },
            { "car", "क्यारिब" },
            { "cay", "कायुगा" },
            { "cch", "अट्साम" },
            { "ccp", "चाक्मा" },
            { "ceb", "सेबुआनो" },
            { "cgg", "चिगा" },
            { "chb", "चिब्चा" },
            { "chg", "चागाटाई" },
            { "chk", "चुकेसे" },
            { "chm", "मारी" },
            { "chn", "चिनुक जार्गन" },
            { "cho", "चोक्टाव" },
            { "chp", "चिपेव्यान" },
            { "chr", metaValue_chr },
            { "chy", "चेयेन्ने" },
            { "ckb", "मध्यवर्ती कुर्दिस" },
            { "clc", "चिलकोटिन" },
            { "cop", "कोप्टिक" },
            { "cps", "कापिज्नोन" },
            { "crg", "मिचिफ" },
            { "crh", "क्रिमियाली तुर्क" },
            { "crj", "दक्षिण पूर्वी क्री" },
            { "crk", "प्लेन्स क्री" },
            { "crl", "उत्तर पूर्वी क्री" },
            { "crm", "मुज क्री" },
            { "crr", "क्यारोलिना एल्गोनक्वियन" },
            { "crs", "सेसेल्वा क्रिओल फ्रान्सेली" },
            { "csb", "कासुवियन" },
            { "csw", "स्वाम्पी क्री" },
            { "dak", "डाकोटा" },
            { "dar", "दार्ग्वा" },
            { "dav", "ताइता" },
            { "del", "देलावर" },
            { "dgr", "दोग्रिब" },
            { "din", "दिन्का" },
            { "dje", "जर्मा" },
            { "doi", "डोगरी" },
            { "dsb", "तल्लो सोर्बियन" },
            { "dtp", "केन्द्रीय दुसुन" },
            { "dua", "दुवाला" },
            { "dum", "मध्य डच" },
            { "dyo", "जोला-फोनिल" },
            { "dyu", "द्युला" },
            { "dzg", "दाजागा" },
            { "ebu", "एम्बु" },
            { "efi", "एफिक" },
            { "egl", "एमिलियाली" },
            { "egy", "पुरातन इजिप्टी" },
            { "eka", "एकाजुक" },
            { "elx", "एलामाइट" },
            { "enm", "मध्य अङ्ग्रेजी" },
            { "esu", "केन्द्रीय युपिक" },
            { "ewo", "इवोन्डो" },
            { "ext", "एक्सट्रेमादुराली" },
            { "fan", "फाङ" },
            { "fat", "फान्टी" },
            { "fil", "फिलिपिनी" },
            { "fon", "फोन" },
            { "frc", "काहुन फ्रान्सेली" },
            { "frm", "मध्य फ्रान्सेली" },
            { "fro", "पुरातन फ्रान्सेली" },
            { "frp", "अर्पितान" },
            { "frr", "उत्तरी फ्रिजी" },
            { "frs", "पूर्वी फ्रिसियाली" },
            { "fur", "फ्रिउलियाली" },
            { "gaa", "गा" },
            { "gag", "गगाउज" },
            { "gan", "गान चिनियाँ" },
            { "gay", "गायो" },
            { "gba", "ग्बाया" },
            { "gez", "गिज" },
            { "gil", "गिल्बर्टी" },
            { "glk", "गिलाकी" },
            { "gmh", "मध्य उच्च जर्मन" },
            { "goh", "पुरातन उच्च जर्मन" },
            { "gon", "गोन्डी" },
            { "gor", "गोरोन्टालो" },
            { "got", metaValue_got },
            { "grb", "ग्रेबो" },
            { "grc", "पुरातन ग्रिक" },
            { "gsw", "स्वीस जर्मन" },
            { "gur", "फ्राफ्रा" },
            { "guz", "गुसी" },
            { "gwi", "गुइचिन" },
            { "hai", "हाइदा" },
            { "hak", "हक्का चिनियाँ" },
            { "haw", "हवाइयन" },
            { "hax", "दक्षिणी हैडा" },
            { "hif", "फिजी हिन्दी" },
            { "hil", "हिलिगायनोन" },
            { "hit", "हिट्टिटे" },
            { "hmn", "हमोङ" },
            { "hsb", "माथिल्लो सोर्बियन" },
            { "hsn", "जियाङ चिनियाँ" },
            { "hup", "हुपा" },
            { "hur", "हाल्कोमेलेम" },
            { "iba", "इबान" },
            { "ibb", "इबिबियो" },
            { "ikt", "पश्चिमी क्यानेडेली इनुक्टिटुट" },
            { "ilo", "इयोको" },
            { "inh", "इन्गस" },
            { "izh", "इन्ग्रियाली" },
            { "jam", "जमैकाली क्रेओले अङ्ग्रेजी" },
            { "jbo", "लोज्बान" },
            { "jgo", "न्गोम्बा" },
            { "jmc", "माचामे" },
            { "jpr", "जुडियो-फारसी" },
            { "jrb", "जुडियो-अरबी" },
            { "jut", "जुटिस" },
            { "kaa", "कारा-काल्पाक" },
            { "kab", "काबिल" },
            { "kac", "काचिन" },
            { "kaj", "ज्जु" },
            { "kam", "काम्बा" },
            { "kaw", "कावी" },
            { "kbd", "काबार्दियाली" },
            { "kbl", "कानेम्बु" },
            { "kcg", "टुआप" },
            { "kde", "माकोन्डे" },
            { "kea", "काबुभेर्डियानु" },
            { "ken", "केनयाङ" },
            { "kfo", "कोरो" },
            { "kgp", "काइनगाङ" },
            { "kha", "खासी" },
            { "kho", "खोटानी" },
            { "khq", "कोयरा चिनी" },
            { "khw", "खोवार" },
            { "kiu", "किर्मान्जकी" },
            { "kkj", "काको" },
            { "kln", "कालेन्जिन" },
            { "kmb", "किम्बुन्डु" },
            { "koi", "कोमी-पर्म्याक" },
            { "kok", "कोन्कानी" },
            { "kos", "कोस्राली" },
            { "kpe", "क्पेल्ले" },
            { "krc", "काराचाय-बाल्कर" },
            { "kri", "क्रिओ" },
            { "krj", "किनाराय-ए" },
            { "krl", "करेलियन" },
            { "kru", "कुरुख" },
            { "ksb", "शाम्बाला" },
            { "ksf", "बाफिया" },
            { "ksh", "कोलोग्नियाली" },
            { "kum", "कुमिक" },
            { "kut", "कुतेनाइ" },
            { "kwk", "क्वाकवाला" },
            { "kxv", "कुभी" },
            { "lad", "लाडिनो" },
            { "lag", "लाङ्गी" },
            { "lah", "लाहन्डा" },
            { "lam", "लाम्बा" },
            { "lez", "लाज्घियाली" },
            { "lfn", "लिङ्गुवा फ्राङ्का नोभा" },
            { "lij", "लिगुरियाली" },
            { "lil", "लिलुएट" },
            { "liv", "लिभोनियाली" },
            { "lkt", "लाकोता" },
            { "lmo", "लोम्बार्ड" },
            { "lol", "मोङ्गो" },
            { "lou", "लुसियाना क्रियोल" },
            { "loz", "लोजी" },
            { "lrc", "उत्तरी लुरी" },
            { "lsm", "सामिया" },
            { "ltg", "लाट्गाली" },
            { "lua", "लुबा-लुलुआ" },
            { "lui", "लुइसेनो" },
            { "lun", "लुन्डा" },
            { "luo", "लुओ" },
            { "lus", "मिजो" },
            { "luy", "लुइया" },
            { "lzh", "साहित्यिक चिनियाँ" },
            { "lzz", "लाज" },
            { "mad", "मादुरेसे" },
            { "maf", "माफा" },
            { "mag", "मगधी" },
            { "mai", "मैथिली" },
            { "mak", "माकासार" },
            { "man", "मान्दिङो" },
            { "mas", "मसाई" },
            { "mde", "माबा" },
            { "mdf", "मोक्ष" },
            { "mdr", "मन्दर" },
            { "men", "मेन्डे" },
            { "mer", "मेरू" },
            { "mfe", "मोरिसेन" },
            { "mga", "मध्य आयरिस" },
            { "mgh", "माखुवा-मिट्टो" },
            { "mgo", "मेटा" },
            { "mic", "मिकमाक" },
            { "min", "मिनाङकाबाउ" },
            { "mnc", "मान्चु" },
            { "mni", "मनिपुरी" },
            { "moe", "इन्नु-ऐमन" },
            { "moh", "मोहक" },
            { "mos", "मोस्सी" },
            { "mua", "मुन्डाङ" },
            { "mul", "बहुभाषा" },
            { "mus", "क्रिक" },
            { "mwl", "मिरान्डी" },
            { "mwr", "माडवारी" },
            { "mwv", "मेन्टावाई" },
            { "mye", "म्येने" },
            { "myv", "इर्ज्या" },
            { "mzn", "मजानडेरानी" },
            { "nan", "मिन नान चिनियाँ" },
            { "nap", "नेपोलिटान" },
            { "naq", "नामा" },
            { "nds", "तल्लो जर्मन" },
            { "new", "नेवारी" },
            { "nia", "नियास" },
            { "niu", "निउएन" },
            { "njo", "अओ नागा" },
            { "nmg", "क्वासियो" },
            { "nnh", "न्गिएम्बुन" },
            { "nog", "नोगाइ" },
            { "non", "पुरानो नोर्से" },
            { "nov", "नोभियल" },
            { "nqo", "नको" },
            { "nso", "उत्तरी सोथो" },
            { "nus", "नुएर" },
            { "nwc", "परम्परागत नेवारी" },
            { "nym", "न्यामवेजी" },
            { "nyn", "न्यान्कोल" },
            { "nyo", "न्योरो" },
            { "nzi", "नजिमा" },
            { "ojb", "उत्तरपश्चिम ओजिब्बा" },
            { "ojc", "सेन्ट्रल अजिब्बा" },
            { "ojs", "ओजी क्री" },
            { "ojw", "पश्चिमी ओजिबा" },
            { "oka", "ओकानागान" },
            { "osa", "ओसागे" },
            { "ota", "अटोमन तुर्की" },
            { "pag", "पाङ्गासिनान" },
            { "pal", "पाहलावी" },
            { "pam", "पामपाङ्गा" },
            { "pap", "पापियामेन्तो" },
            { "pau", "पालाउवाली" },
            { "pcd", "पिकार्ड" },
            { "pcm", "नाइजेरियाली पिड्जिन" },
            { "pdc", "पेन्सिलभानियाली जर्मन" },
            { "peo", "पुरातन फारसी" },
            { "pfl", "पालाटिन जर्मन" },
            { "phn", "फोनिसियाली" },
            { "pis", "पिजिन" },
            { "pms", "पिएडमोन्तेसे" },
            { "pnt", "पोन्टिक" },
            { "pqm", "मालिसीट पासामाक्वेडी" },
            { "prg", "प्रसियाली" },
            { "pro", "पुरातन प्रोभेन्काल" },
            { "quc", "किचे" },
            { "qug", "चिम्बोराजो उच्चस्थान किचुआ" },
            { "raj", "राजस्थानी" },
            { "rap", "रापानुई" },
            { "rar", "रारोटोङ्गान" },
            { "rhg", "रोहिङ्ग्या" },
            { "rof", "रोम्बो" },
            { "rup", "अरोमानीयाली" },
            { "rwk", "र्‌वा" },
            { "sad", "सान्डेअ" },
            { "sah", "साखा" },
            { "saq", "साम्बुरू" },
            { "sat", "सान्ताली" },
            { "sba", "न्गामबाय" },
            { "sbp", "साङ्गु" },
            { "scn", "सिसिलियाली" },
            { "sco", "स्कट्स" },
            { "sdh", "दक्षिणी कुर्दिश" },
            { "seh", "सेना" },
            { "ses", "कोयराबोरो सेन्नी" },
            { "sga", "पुरातन आयरीस" },
            { "shi", "टाचेल्हिट" },
            { "shn", "शान" },
            { "shu", "चाड अरबी" },
            { "slh", "दक्षिनी लुस्होस्टेड" },
            { "sli", "तल्लो सिलेसियाली" },
            { "sma", "दक्षिणी सामी" },
            { "smj", "लुले सामी" },
            { "smn", "इनारी सामी" },
            { "sms", "स्कोइट सामी" },
            { "snk", "सोनिन्के" },
            { "srn", "स्रानान टोङ्गो" },
            { "ssy", "साहो" },
            { "str", "स्ट्रेट स्यालिस" },
            { "suk", "सुकुमा" },
            { "sus", "सुसू" },
            { "sux", "सुमेरियाली" },
            { "swb", "कोमोरी" },
            { "syc", "परम्परागत सिरियाक" },
            { "syr", metaValue_syr },
            { "szl", "सिलेसियाली" },
            { "tce", "दक्षिनी टुट्चोन" },
            { "tem", "टिम्ने" },
            { "teo", "टेसो" },
            { "tet", "टेटुम" },
            { "tgx", "टागिस" },
            { "tht", "टाहल्टन" },
            { "tig", "टिग्रे" },
            { "tlh", "क्लिङ्गन" },
            { "tli", "ट्लिङ्गिट" },
            { "tog", "न्यास टोङ्गा" },
            { "tok", "टोकी पोना" },
            { "tpi", "टोक पिसिन" },
            { "trv", "टारोको" },
            { "ttm", "उत्तरी टुचोन" },
            { "ttt", "मुस्लिम टाट" },
            { "tum", "टुम्बुका" },
            { "tvl", "टुभालु" },
            { "twq", "तासावाक" },
            { "tyv", "टुभिनियाली" },
            { "tzm", "केन्द्रीय एट्लास टामाजिघट" },
            { "udm", "उड्मुर्ट" },
            { "umb", "उम्बुन्डी" },
            { "und", "अज्ञात भाषा" },
            { "vai", metaValue_vai },
            { "vec", "भेनेसियाली" },
            { "vmf", "मुख्य-फ्राङ्कोनियाली" },
            { "vmw", "मखुवा" },
            { "vun", "भुन्जो" },
            { "wae", "वाल्सर" },
            { "wal", "वोलेट्टा" },
            { "war", "वारे" },
            { "wbp", "वार्ल्पिरी" },
            { "wuu", "ऊ चिनियाँ" },
            { "xal", "काल्मिक" },
            { "xmf", "मिनग्रेलियाली" },
            { "xnr", "काङ्ग्री" },
            { "xog", "सोगा" },
            { "yav", "याङ्बेन" },
            { "ybb", "येम्बा" },
            { "yrl", "न्हिनगातु" },
            { "yue", "क्यान्टोनिज" },
            { "zbl", "ब्लिससिम्बोल्स" },
            { "zgh", "मानक मोरोक्कोन तामाजिघट" },
            { "zun", "जुनी" },
            { "zxx", "भाषिक सामग्री छैन" },
            { "zza", "जाजा" },
            { "Adlm", "एडलाम" },
            { "Arab", metaValue_ar },
            { "Aran", "नास्टालिक" },
            { "Armi", "आर्मी" },
            { "Armn", metaValue_hy },
            { "Avst", "आभेस्टान" },
            { "Bali", metaValue_ban },
            { "Batk", "बाटक" },
            { "Beng", "बङ्गाली" },
            { "Blis", "ब्लिजसिम्बोल्स" },
            { "Bopo", "बोपोमोफो" },
            { "Brah", "ब्राह्मी" },
            { "Brai", "ब्रेल" },
            { "Bugi", "बुगिनिज" },
            { "Buhd", "बुहिद" },
            { "Cakm", "काक्म्" },
            { "Cans", "एकीकृत क्यानेडाली आदिवादीको सिलाबिक्स" },
            { "Cari", "कारियन" },
            { "Cham", "चाम" },
            { "Cher", metaValue_chr },
            { "Cirt", "किर्थ" },
            { "Copt", "कप्टिक" },
            { "Cprt", "कप्रियट" },
            { "Cyrl", "सिरिलिक" },
            { "Deva", metaValue_Deva },
            { "Dsrt", "डेसेरेट" },
            { "Egyd", "इजिप्टियन डेमोटिक" },
            { "Egyh", "इजिप्टियन हाइरटिक" },
            { "Egyp", "इजिप्टियन हाइरोग्लिफ्स" },
            { "Ethi", "इथियोपिक" },
            { "Geok", "ग्रुजियाली खुट्सुरी" },
            { "Geor", metaValue_ka },
            { "Glag", "ग्लागोलिटिक" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरूमुखी" },
            { "Hanb", "हान्ब" },
            { "Hang", "हान्गुल" },
            { "Hani", "हान" },
            { "Hano", "हानुनु" },
            { "Hans", metaValue_Hans },
            { "Hant", "परम्परागत" },
            { "Hebr", metaValue_he },
            { "Hira", "हिरागना" },
            { "Hmng", "पहावह हमोङ्ग" },
            { "Hrkt", "काताकाना वा हिरागाना" },
            { "Hung", "पुरानो हङ्गेरियाली" },
            { "Inds", "इन्दुस" },
            { "Ital", "पुरानो इटालिक" },
            { "Jamo", "जामो" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "कायाहली" },
            { "Kana", "काताकाना" },
            { "Khar", "खारोस्थिति" },
            { "Khmr", metaValue_km },
            { "Knda", "कान्नाडा" },
            { "Kore", "कोरियन" },
            { "Kthi", "क्थी" },
            { "Lana", "लान्ना" },
            { "Laoo", metaValue_lo },
            { "Latf", "फ्राक्टुर ल्याटिन" },
            { "Latg", "ग्यालिक ल्याटिन" },
            { "Latn", metaValue_la },
            { "Lepc", "लेप्चा" },
            { "Limb", "लिम्बु" },
            { "Lyci", "लाइसियन" },
            { "Lydi", "लाइडियन" },
            { "Mand", "मान्डाएन" },
            { "Mani", "मानिकाएन" },
            { "Maya", "माया हाइरोग्लिफ्स" },
            { "Mero", "मेरियोटिक" },
            { "Mlym", "मलायालम" },
            { "Mong", "मङ्गोल" },
            { "Moon", "जून" },
            { "Mtei", "माइटेइ मायेक" },
            { "Mymr", "म्यान्मार" },
            { "Nkoo", "एन्को" },
            { "Ogam", "ओघाम" },
            { "Olck", "ओलचिकी" },
            { "Orkh", "ओर्खोन" },
            { "Orya", "ओडिया" },
            { "Osma", "ओस्मान्या" },
            { "Perm", "पुरानो पर्मिक" },
            { "Phag", "फाग्स-पा" },
            { "Phli", "फ्लि" },
            { "Phlp", "फ्ल्प" },
            { "Phlv", "बुक पहल्भी" },
            { "Phnx", "फोनिसियन" },
            { "Plrd", "पोल्लार्ड फोनेटिक" },
            { "Prti", "पिआरटी" },
            { "Rjng", "रेजाङ" },
            { "Rohg", "हानिफी" },
            { "Roro", "रोङ्गोरोङ्गो" },
            { "Runr", "रूनिक" },
            { "Samr", "समारिटन" },
            { "Sara", "सारती" },
            { "Saur", "सौराष्ट्र" },
            { "Sgnw", "साइनराइटिङ" },
            { "Shaw", "शाभियन" },
            { "Sinh", "सिन्हाला" },
            { "Sund", "सुन्डानेली" },
            { "Sylo", "स्ल्योटी नाग्री" },
            { "Syrc", metaValue_syr },
            { "Syre", "इस्ट्रेनजेलो सिरियाक" },
            { "Syrj", "पश्चिमी सिरियाक" },
            { "Syrn", "पूर्वी सिरियाक" },
            { "Tagb", "टाग्वान्वा" },
            { "Tale", "टाइले" },
            { "Talu", "न्यू टाइ लुइ" },
            { "Taml", metaValue_ta },
            { "Tavt", "टाभ्ट" },
            { "Telu", metaValue_te },
            { "Teng", "टेङ्वार" },
            { "Tfng", "टिफिनाघ" },
            { "Tglg", "टागालोग" },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "युगारिटिक" },
            { "Vaii", metaValue_vai },
            { "Visp", "दृश्यमय वाणी" },
            { "Xpeo", "पुरानो पर्सियन" },
            { "Yiii", "यी" },
            { "Zinh", "इन्हेरिटेड" },
            { "Zmth", "गणितीय चिन्ह" },
            { "Zsye", "इमोजी" },
            { "Zsym", "प्रतीकहरू" },
            { "Zxxx", "नलेखिएको" },
            { "Zyyy", "साझा" },
            { "Zzzz", "अज्ञात लिपि" },
            { "de_AT", "अस्ट्रिएन जर्मन" },
            { "de_CH", "स्वीस हाई जर्मन" },
            { "en_AU", "अस्ट्रेलियाली अङ्ग्रेजी" },
            { "en_CA", "क्यानाडेली अङ्ग्रेजी" },
            { "en_GB", "बेलायती अङ्ग्रेजी" },
            { "en_US", "अमेरिकी अङ्ग्रेजी" },
            { "es_ES", "युरोपेली स्पेनी" },
            { "es_MX", "मेक्सिकन स्पेनी" },
            { "fa_AF", "दारी" },
            { "fr_CA", "क्यानेडाली फ्रान्सेली" },
            { "fr_CH", "स्विस फ्रेन्च" },
            { "nl_BE", "फ्लेमिस" },
            { "pt_BR", "ब्राजिली पोर्तुगी" },
            { "pt_PT", "युरोपेली पोर्तुगी" },
            { "ro_MD", "मोल्डाभियाली" },
            { "sw_CD", "कङ्गो स्वाहिली" },
            { "ar_001", "आधुनिक मानक अरबी" },
            { "es_419", "ल्याटिन अमेरिकी स्पेनी" },
            { "key.ca", "पात्रो" },
            { "key.cf", "मुद्राको ढाँचा" },
            { "key.co", "क्रमबद्ध सुची" },
            { "key.cu", "मुद्रा" },
            { "key.em", "इमोजी प्रेजन्टेसन" },
            { "key.hc", "समय चक्र (12 तथा 24)" },
            { "key.lb", "पङ्क्ति विच्छेदको शैली" },
            { "key.lw", "शब्दबीचका लाइन ब्रेकहरू" },
            { "key.ms", "मापन प्रणाली" },
            { "key.nu", "अङ्कहरू" },
            { "key.ss", "संक्षिप्त शब्दपछि आउने वाक्यान्त" },
            { "nds_NL", "तल्लो साक्सन" },
            { "%%POSIX", "कम्प्युटर" },
            { "zh_Hans", metaValue_Hans },
            { "zh_Hant", "परम्परागत चिनियाँ" },
            { "%%AREVELA", "पूर्वी आर्मेनियाली" },
            { "type.ca.roc", "चिनियाँ गणतन्त्रको पात्रो" },
            { "type.hc.h11", "१२ घण्टे प्रणाली (०–११)" },
            { "type.hc.h12", "१२ घन्टाको प्रणाली (१–१२)" },
            { "type.hc.h23", "२४ घन्टाको प्रणाली (०–२३)" },
            { "type.hc.h24", "२४ घन्टाको प्रणाली (१–२४)" },
            { "type.nu.arab", "अरबी भारतीय अङ्कहरू" },
            { "type.nu.armn", "आर्मेनियाली अङ्कहरू" },
            { "type.nu.beng", "बङ्गाली अङ्कहरू" },
            { "type.nu.cakm", "चाक्मा अङ्क" },
            { "type.nu.deva", metaValue_Deva },
            { "type.nu.ethi", "इथियोपाली अङ्कहरू" },
            { "type.nu.geor", "जर्जियाली अङ्कहरू" },
            { "type.nu.grek", "ग्रीक अङ्कहरू" },
            { "type.nu.gujr", "गुजराती अङ्कहरू" },
            { "type.nu.guru", "गुरूमुखी अङ्कहरू" },
            { "type.nu.hans", "सरलिकृत चिनियाँ अङ्कहरू" },
            { "type.nu.hant", "परम्परागत चिनियाँ अङ्कहरू" },
            { "type.nu.hebr", "हिब्रु अङ्कहरू" },
            { "type.nu.java", "जाभानी अङ्क" },
            { "type.nu.jpan", "जापानी अङ्कहरू" },
            { "type.nu.khmr", "खमेर अङ्कहरू" },
            { "type.nu.knda", "कन्नाडा अङ्कहरू" },
            { "type.nu.laoo", "लाओ अङ्कहरू" },
            { "type.nu.latn", "पश्चिमी अङ्कहरू" },
            { "type.nu.mlym", "मलायलम अङ्कहरू" },
            { "type.nu.mtei", "मिटै मेएक अङ्क" },
            { "type.nu.mymr", "म्यान्मारका अङ्कहरू" },
            { "type.nu.olck", "ओइ चिकी अङ्क" },
            { "type.nu.orya", "ओरिया अङ्कहरू" },
            { "type.nu.taml", "परम्परागत तामिल अङ्कहरू" },
            { "type.nu.telu", "तेलेगु अङ्कहरू" },
            { "type.nu.thai", "थाई अङ्कहरू" },
            { "type.nu.tibt", "तिब्बती अङ्कहरू" },
            { "type.nu.vaii", "भाई अङ्क" },
            { "type.ca.dangi", "डाङ्गी पात्रो" },
            { "type.co.ducet", "पूर्वनिर्धारित युनिकोडको क्रमबद्धता सूची" },
            { "type.lb.loose", "पङ्क्ति विच्छेदको खुला शैली" },
            { "type.nu.roman", "रोमन अङ्कहरू" },
            { "type.ca.coptic", "कोप्टिक पात्र" },
            { "type.ca.hebrew", "हिब्रु पात्रो" },
            { "type.ca.indian", "भारतीय राष्ट्रिय पात्रो" },
            { "type.co.pinyin", "पिनयिन क्रमबद्धता पद्दति" },
            { "type.co.search", "सामान्य उद्देशीय खोजी" },
            { "type.co.stroke", "स्ट्रोक क्रमबद्धता पद्दति" },
            { "type.lb.normal", "पङ्क्ति विच्छेदको सामान्य शैली" },
            { "type.lb.strict", "पङ्क्ति विच्छेदको कडा शैली" },
            { "type.ms.metric", "मेट्रिक प्रणाली" },
            { "type.ca.chinese", "चिनियाँ पात्रो" },
            { "type.ca.islamic", "हिजरी पात्रो" },
            { "type.ca.iso8601", "ISO-8601 पात्रो" },
            { "type.ca.persian", "फारसी पात्रो" },
            { "type.cf.account", "लेखासम्बन्धी मुद्राको ढाँचा" },
            { "type.nu.arabext", "विस्तृत अरबी भारतीय अङ्कहरू" },
            { "type.nu.armnlow", "आर्मेनियाली साना अङ्कहरू" },
            { "type.nu.greklow", "ग्रीक साना अङ्कहरू" },
            { "type.nu.hanidec", "चिनियाँ दशमलव अङ्कहरू" },
            { "type.nu.hansfin", "सरलिकृत चिनियाँ वित्तीय अङ्कहरू" },
            { "type.nu.hantfin", "परम्परागत चिनियाँ वित्तीय अङ्कहरू" },
            { "type.nu.jpanfin", "जापानी वित्तीय अङ्कहरू" },
            { "type.nu.tamldec", "तामिल अङ्कहरू" },
            { "type.ca.buddhist", "बुद्धिष्ट पात्रो" },
            { "type.ca.ethiopic", "इथिओपिक पात्रो" },
            { "type.ca.japanese", "जापानी पात्रो" },
            { "type.cf.standard", "मानक मुद्राको ढाँचा" },
            { "type.co.standard", "मानक क्रमबद्धता" },
            { "type.ms.uksystem", "इम्पेरियल मापन प्रणाली" },
            { "type.ms.ussystem", "संयुक्त राज्य मापन प्रणाली" },
            { "type.nu.fullwide", "पूरा चौंडाइका अङ्कहरू" },
            { "type.nu.romanlow", "रोमन साना केसका अङ्कहरू" },
            { "type.ca.gregorian", "ग्रेगोरियन पात्रो" },
            { "type.co.phonebook", "टेलिफोन पुस्तिका क्रमबद्धतापद्दति" },
            { "type.co.traditional", "परम्परागत क्रमबद्धता पद्दति" },
            { "type.ca.islamic-civil", "हिजरी पात्रो (टेबुलर, नागरिक युग)" },
            { "type.ca.islamic-umalqura", "इस्लामी पात्रो" },
            { "type.ca.ethiopic-amete-alem", "इथियिपियाली आमेट आलेम पात्र" },
        };
        return data;
    }
}
