/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ja extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "グリニッジ標準時",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "アクレ標準時",
               "",
               "アクレ夏時間",
               "",
               "アクレ時間",
               "",
            };
        final String[] Apia = new String[] {
               "サモア標準時",
               "",
               "サモア夏時間",
               "",
               "サモア時間",
               "",
            };
        final String[] Cook = new String[] {
               "クック諸島標準時",
               "",
               "クック諸島夏時間",
               "",
               "クック諸島時間",
               "",
            };
        final String[] Cuba = new String[] {
               "キューバ標準時",
               "CST",
               "キューバ夏時間",
               "CDT",
               "キューバ時間",
               "CT",
            };
        final String[] Fiji = new String[] {
               "フィジー標準時",
               "",
               "フィジー夏時間",
               "",
               "フィジー時間",
               "",
            };
        final String[] Gulf = new String[] {
               "湾岸標準時",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ホブド標準時",
               "",
               "ホブド夏時間",
               "",
               "ホブド時間",
               "",
            };
        final String[] Iran = new String[] {
               "イラン標準時",
               "",
               "イラン夏時間",
               "",
               "イラン時間",
               "",
            };
        final String[] Niue = new String[] {
               "ニウエ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "オムスク標準時",
               "",
               "オムスク夏時間",
               "",
               "オムスク時間",
               "",
            };
        final String[] Peru = new String[] {
               "ペルー標準時",
               "",
               "ペルー夏時間",
               "",
               "ペルー時間",
               "",
            };
        final String[] Truk = new String[] {
               "チューク時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ウェーク島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "チリ標準時",
               "",
               "チリ夏時間",
               "",
               "チリ時間",
               "",
            };
        final String[] China = new String[] {
               "中国標準時",
               "CST",
               "中国夏時間",
               "CDT",
               "中国時間",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ココス諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "デービス基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "インド標準時",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "日本標準時",
               "JST",
               "日本夏時間",
               "JDT",
               "日本時間",
               "∅∅∅",
            };
        final String[] Korea = new String[] {
               "韓国標準時",
               "KST",
               "韓国夏時間",
               "KST",
               "韓国時間",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ナウル時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ネパール時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "パラオ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "米領サモア標準時",
               "SST",
               "米領サモア夏時間",
               "SST",
               "米領サモア時間",
               "SST",
            };
        final String[] Syowa = new String[] {
               "昭和基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "トンガ標準時",
               "",
               "トンガ夏時間",
               "",
               "トンガ時間",
               "",
            };
        final String[] Yukon = new String[] {
               "ユーコン時間",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "アラスカ標準時",
               "AKST",
               "アラスカ夏時間",
               "AKDT",
               "アラスカ時間",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "アマゾン標準時",
               "",
               "アマゾン夏時間",
               "",
               "アマゾン時間",
               "",
            };
        final String[] Azores = new String[] {
               "アゾレス標準時",
               "",
               "アゾレス夏時間",
               "",
               "アゾレス時間",
               "",
            };
        final String[] Bhutan = new String[] {
               "ブータン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ブルネイ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "イースター島標準時",
               "",
               "イースター島夏時間",
               "",
               "イースター島時間",
               "",
            };
        final String[] Guyana = new String[] {
               "ガイアナ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ハワイ・アリューシャン標準時",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "イスラエル標準時",
               "IST",
               "イスラエル夏時間",
               "IDT",
               "イスラエル時間",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "コスラエ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "モーソン基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "モスクワ標準時",
               "MSK",
               "モスクワ夏時間",
               "MSK",
               "モスクワ時間",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ポンペイ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "サマラ標準時",
               "",
               "サマラ夏時間",
               "",
               "サマラ時間",
               "",
            };
        final String[] Tahiti = new String[] {
               "タヒチ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "台湾標準時",
               "CST",
               "台湾夏時間",
               "CDT",
               "台湾時間",
               "CT",
            };
        final String[] Turkey = new String[] {
               "トルコ標準時",
               "",
               "トルコ夏時間",
               "",
               "トルコ時間",
               "",
            };
        final String[] Tuvalu = new String[] {
               "ツバル時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ボストーク基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ウォリス・フツナ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "アラビア標準時",
               "",
               "アラビア夏時間",
               "",
               "アラビア時間",
               "",
            };
        final String[] Armenia = new String[] {
               "アルメニア標準時",
               "",
               "アルメニア夏時間",
               "",
               "アルメニア時間",
               "",
            };
        final String[] Bolivia = new String[] {
               "ボリビア時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "チャタム標準時",
               "",
               "チャタム夏時間",
               "",
               "チャタム時間",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "協定世界時",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "エクアドル時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ガンビエ諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ジョージア標準時",
               "",
               "ジョージア夏時間",
               "",
               "ジョージア時間",
               "",
            };
        final String[] Irkutsk = new String[] {
               "イルクーツク標準時",
               "",
               "イルクーツク夏時間",
               "",
               "イルクーツク時間",
               "",
            };
        final String[] Magadan = new String[] {
               "マガダン標準時",
               "",
               "マガダン夏時間",
               "",
               "マガダン時間",
               "",
            };
        final String[] Myanmar = new String[] {
               "ミャンマー時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ノーフォーク島標準時",
               "",
               "ノーフォーク島夏時間",
               "",
               "ノーフォーク島時間",
               "",
            };
        final String[] Noronha = new String[] {
               "フェルナンド・デ・ノローニャ標準時",
               "",
               "フェルナンド・デ・ノローニャ夏時間",
               "",
               "フェルナンド・デ・ノローニャ時間",
               "",
            };
        final String[] Reunion = new String[] {
               "レユニオン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ロゼラ基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ソロモン諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "トケラウ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ウルグアイ標準時",
               "",
               "ウルグアイ夏時間",
               "",
               "ウルグアイ時間",
               "",
            };
        final String[] Vanuatu = new String[] {
               "バヌアツ標準時",
               "",
               "バヌアツ夏時間",
               "",
               "バヌアツ時間",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ヤクーツク標準時",
               "",
               "ヤクーツク夏時間",
               "",
               "ヤクーツク時間",
               "",
            };
        final String[] Atlantic = new String[] {
               "大西洋標準時",
               "AST",
               "大西洋夏時間",
               "AST",
               "大西洋時間",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ブラジリア標準時",
               "",
               "ブラジリア夏時間",
               "",
               "ブラジリア時間",
               "",
            };
        final String[] Chamorro = new String[] {
               "チャモロ時間",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "コロンビア標準時",
               "",
               "コロンビア夏時間",
               "",
               "コロンビア時間",
               "",
            };
        final String[] Falkland = new String[] {
               "フォークランド諸島標準時",
               "",
               "フォークランド諸島夏時間",
               "",
               "フォークランド諸島時間",
               "",
            };
        final String[] Malaysia = new String[] {
               "マレーシア時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "モルディブ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ウランバートル標準時",
               "",
               "ウランバートル夏時間",
               "",
               "ウランバートル時間",
               "",
            };
        final String[] Pakistan = new String[] {
               "パキスタン標準時",
               "PKT",
               "パキスタン夏時間",
               "PKST",
               "パキスタン時間",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "パラグアイ標準時",
               "",
               "パラグアイ夏時間",
               "",
               "パラグアイ時間",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ピトケアン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "スリナム時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "アルゼンチン標準時",
               "",
               "アルゼンチン夏時間",
               "",
               "アルゼンチン時間",
               "",
            };
        final String[] Christmas = new String[] {
               "クリスマス島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ガラパゴス時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "香港標準時",
               "HKT",
               "香港夏時間",
               "HKST",
               "香港時間",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "インドシナ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "ペトロパブロフスク・カムチャツキー標準時",
               "",
               "ペトロパブロフスク・カムチャツキー夏時間",
               "",
               "ペトロパブロフスク・カムチャツキー時間",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "キルギス時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ロードハウ標準時",
               "",
               "ロードハウ夏時間",
               "",
               "ロードハウ時間",
               "",
            };
        final String[] Marquesas = new String[] {
               "マルキーズ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "モーリシャス標準時",
               "",
               "モーリシャス夏時間",
               "",
               "モーリシャス時間",
               "",
            };
        final String[] Singapore = new String[] {
               "シンガポール標準時",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ベネズエラ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "アゼルバイジャン標準時",
               "",
               "アゼルバイジャン夏時間",
               "",
               "アゼルバイジャン時間",
               "",
            };
        final String[] Bangladesh = new String[] {
               "バングラデシュ標準時",
               "",
               "バングラデシュ夏時間",
               "",
               "バングラデシュ時間",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "カーボベルデ標準時",
               "",
               "カーボベルデ夏時間",
               "",
               "カーボベルデ時間",
               "",
            };
        final String[] East_Timor = new String[] {
               "東ティモール時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "カザフスタン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "セーシェル時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "タジキスタン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ウズベキスタン標準時",
               "",
               "ウズベキスタン夏時間",
               "",
               "ウズベキスタン時間",
               "",
            };
        final String[] Afghanistan = new String[] {
               "アフガニスタン時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "クラスノヤルスク標準時",
               "",
               "クラスノヤルスク夏時間",
               "",
               "クラスノヤルスク時間",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ニュージーランド標準時",
               "NZST",
               "ニュージーランド夏時間",
               "NZDT",
               "ニュージーランド時間",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "フィリピン標準時",
               "PST",
               "フィリピン夏時間",
               "PDT",
               "フィリピン時間",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ウラジオストク標準時",
               "",
               "ウラジオストク夏時間",
               "",
               "ウラジオストク時間",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "インド洋時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ライン諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ニューファンドランド標準時",
               "NST",
               "ニューファンドランド夏時間",
               "NDT",
               "ニューファンドランド時間",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "トルクメニスタン標準時",
               "",
               "トルクメニスタン夏時間",
               "",
               "トルクメニスタン時間",
               "",
            };
        final String[] French_Guiana = new String[] {
               "仏領ギアナ時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ニューカレドニア標準時",
               "",
               "ニューカレドニア夏時間",
               "",
               "ニューカレドニア時間",
               "",
            };
        final String[] South_Georgia = new String[] {
               "サウスジョージア時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "エカテリンブルグ標準時",
               "",
               "エカテリンブルグ夏時間",
               "",
               "エカテリンブルグ時間",
               "",
            };
        final String[] Africa_Central = new String[] {
               "中央アフリカ時間",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "東アフリカ時間",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "西アフリカ時間",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "デュモン・デュルヴィル基地時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "中央ヨーロッパ標準時",
               "CET",
               "中央ヨーロッパ夏時間",
               "CEST",
               "中央ヨーロッパ時間",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "東ヨーロッパ標準時",
               "EET",
               "東ヨーロッパ夏時間",
               "EEST",
               "東ヨーロッパ時間",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "西ヨーロッパ標準時",
               "WET",
               "西ヨーロッパ夏時間",
               "WEST",
               "西ヨーロッパ時間",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "メキシコ太平洋標準時",
               "MST",
               "メキシコ太平洋夏時間",
               "MDT",
               "メキシコ太平洋時間",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "南アフリカ標準時",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "米国中部標準時",
               "CST",
               "米国中部夏時間",
               "CDT",
               "米国中部時間",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "米国東部標準時",
               "EST",
               "米国東部夏時間",
               "EST",
               "米国東部時間",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "米国太平洋標準時",
               "PST",
               "米国太平洋夏時間",
               "PDT",
               "米国太平洋時間",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "仏領南方南極時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ギルバート諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ハワイ・アリューシャン標準時",
               "HST",
               "ハワイ・アリューシャン夏時間",
               "HDT",
               "ハワイ・アリューシャン時間",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "フェニックス諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "サンピエール島・ミクロン島標準時",
               "",
               "サンピエール島・ミクロン島夏時間",
               "",
               "サンピエール島・ミクロン島時間",
               "",
            };
        final String[] America_Mountain = new String[] {
               "米国山岳標準時",
               "MST",
               "米国山岳夏時間",
               "MST",
               "米国山岳部時間",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "マーシャル諸島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "パプアニューギニア時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "オーストラリア中部標準時",
               "ACST",
               "オーストラリア中部夏時間",
               "ACDT",
               "オーストラリア中部時間",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "オーストラリア東部標準時",
               "AEST",
               "オーストラリア東部夏時間",
               "AEDT",
               "オーストラリア東部時間",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "オーストラリア西部標準時",
               "AWST",
               "オーストラリア西部夏時間",
               "AWDT",
               "オーストラリア西部時間",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "インドネシア中部時間",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "インドネシア東部時間",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "インドネシア西部時間",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "オーストラリア中西部標準時",
               "",
               "オーストラリア中西部夏時間",
               "",
               "オーストラリア中西部時間",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "アイルランド標準時",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "協定世界時",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "アイルランド標準時",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "グリニッジ標準時",
                    "GMT",
                    "英国夏時間",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "アデン" },
            { "timezone.excity.Asia/Baku", "バクー" },
            { "timezone.excity.Asia/Dili", "ディリ" },
            { "timezone.excity.Asia/Gaza", "ガザ" },
            { "timezone.excity.Asia/Hovd", "ホブド" },
            { "timezone.excity.Asia/Omsk", "オムスク" },
            { "timezone.excity.Asia/Oral", "オラル" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "アンマン" },
            { "timezone.excity.Asia/Aqtau", "アクタウ" },
            { "timezone.excity.Asia/Chita", "チタ" },
            { "timezone.excity.Asia/Dhaka", "ダッカ" },
            { "timezone.excity.Asia/Dubai", "ドバイ" },
            { "timezone.excity.Asia/Kabul", "カブール" },
            { "timezone.excity.Asia/Macau", "マカオ" },
            { "timezone.excity.Asia/Qatar", "カタール" },
            { "timezone.excity.Asia/Seoul", "ソウル" },
            { "timezone.excity.Asia/Tokyo", "東京" },
            { "timezone.excity.Asia/Tomsk", "トムスク" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ジュバ" },
            { "timezone.excity.Africa/Lome", "ロメ" },
            { "timezone.excity.Asia/Almaty", "アルマトイ" },
            { "timezone.excity.Asia/Anadyr", "アナディリ" },
            { "timezone.excity.Asia/Aqtobe", "アクトベ" },
            { "timezone.excity.Asia/Atyrau", "アティラウ" },
            { "timezone.excity.Asia/Beirut", "ベイルート" },
            { "timezone.excity.Asia/Brunei", "ブルネイ" },
            { "timezone.excity.Asia/Hebron", "ヘブロン" },
            { "timezone.excity.Asia/Kuwait", "クウェート" },
            { "timezone.excity.Asia/Manila", "マニラ" },
            { "timezone.excity.Asia/Muscat", "マスカット" },
            { "timezone.excity.Asia/Riyadh", "リヤド" },
            { "timezone.excity.Asia/Saigon", "ホーチミン" },
            { "timezone.excity.Asia/Taipei", "台北" },
            { "timezone.excity.Asia/Tehran", "テヘラン" },
            { "timezone.excity.Asia/Urumqi", "ウルムチ" },
            { "timezone.excity.Etc/Unknown", "地域不明" },
            { "timezone.excity.Europe/Kiev", "キーウ" },
            { "timezone.excity.Europe/Oslo", "オスロ" },
            { "timezone.excity.Europe/Riga", "リガ" },
            { "timezone.excity.Europe/Rome", "ローマ" },
            { "timezone.excity.Indian/Mahe", "マヘ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "アクラ" },
            { "timezone.excity.Africa/Cairo", "カイロ" },
            { "timezone.excity.Africa/Ceuta", "セウタ" },
            { "timezone.excity.Africa/Dakar", "ダカール" },
            { "timezone.excity.Africa/Lagos", "ラゴス" },
            { "timezone.excity.Africa/Tunis", "チュニス" },
            { "timezone.excity.America/Adak", "アダック" },
            { "timezone.excity.America/Lima", "リマ" },
            { "timezone.excity.America/Nome", "ノーム" },
            { "timezone.excity.Asia/Baghdad", "バグダッド" },
            { "timezone.excity.Asia/Bahrain", "バーレーン" },
            { "timezone.excity.Asia/Bangkok", "バンコク" },
            { "timezone.excity.Asia/Barnaul", "バルナウル" },
            { "timezone.excity.Asia/Bishkek", "ビシュケク" },
            { "timezone.excity.Asia/Colombo", "コロンボ" },
            { "timezone.excity.Asia/Irkutsk", "イルクーツク" },
            { "timezone.excity.Asia/Jakarta", "ジャカルタ" },
            { "timezone.excity.Asia/Karachi", "カラチ" },
            { "timezone.excity.Asia/Kuching", "クチン" },
            { "timezone.excity.Asia/Magadan", "マガダン" },
            { "timezone.excity.Asia/Nicosia", "ニコシア" },
            { "timezone.excity.Asia/Rangoon", "ヤンゴン" },
            { "timezone.excity.Asia/Tbilisi", "トビリシ" },
            { "timezone.excity.Asia/Thimphu", "ティンプー" },
            { "timezone.excity.Asia/Yakutsk", "ヤクーツク" },
            { "timezone.excity.Asia/Yerevan", "エレバン" },
            { "timezone.excity.Europe/Kirov", "キーロフ" },
            { "timezone.excity.Europe/Malta", "マルタ" },
            { "timezone.excity.Europe/Minsk", "ミンスク" },
            { "timezone.excity.Europe/Paris", "パリ" },
            { "timezone.excity.Europe/Sofia", "ソフィア" },
            { "timezone.excity.Europe/Vaduz", "ファドゥーツ" },
            { "timezone.excity.Indian/Cocos", "ココス諸島" },
            { "timezone.excity.Pacific/Apia", "アピア" },
            { "timezone.excity.Pacific/Fiji", "フィジー" },
            { "timezone.excity.Pacific/Guam", "グアム" },
            { "timezone.excity.Pacific/Niue", "ニウエ" },
            { "timezone.excity.Pacific/Truk", "チューク" },
            { "timezone.excity.Pacific/Wake", "ウェーク島" },
            { "timezone.excity.Africa/Asmera", "アスマラ" },
            { "timezone.excity.Africa/Bamako", "バマコ" },
            { "timezone.excity.Africa/Bangui", "バンギ" },
            { "timezone.excity.Africa/Banjul", "バンジュール" },
            { "timezone.excity.Africa/Bissau", "ビサウ" },
            { "timezone.excity.Africa/Douala", "ドゥアラ" },
            { "timezone.excity.Africa/Harare", "ハラレ" },
            { "timezone.excity.Africa/Kigali", "キガリ" },
            { "timezone.excity.Africa/Luanda", "ルアンダ" },
            { "timezone.excity.Africa/Lusaka", "ルサカ" },
            { "timezone.excity.Africa/Malabo", "マラボ" },
            { "timezone.excity.Africa/Maputo", "マプト" },
            { "timezone.excity.Africa/Maseru", "マセル" },
            { "timezone.excity.Africa/Niamey", "ニアメ" },
            { "timezone.excity.America/Aruba", "アルバ" },
            { "timezone.excity.America/Bahia", "バイーア" },
            { "timezone.excity.America/Belem", "ベレン" },
            { "timezone.excity.America/Boise", "ボイシ" },
            { "timezone.excity.America/Jujuy", "フフイ" },
            { "timezone.excity.America/Sitka", "シトカ" },
            { "timezone.excity.America/Thule", "チューレ" },
            { "timezone.excity.Asia/Ashgabat", "アシガバード" },
            { "timezone.excity.Asia/Calcutta", "コルカタ" },
            { "timezone.excity.Asia/Damascus", "ダマスカス" },
            { "timezone.excity.Asia/Dushanbe", "ドゥシャンベ" },
            { "timezone.excity.Asia/Jayapura", "ジャヤプラ" },
            { "timezone.excity.Asia/Katmandu", "カトマンズ" },
            { "timezone.excity.Asia/Khandyga", "ハンドゥイガ" },
            { "timezone.excity.Asia/Makassar", "マカッサル" },
            { "timezone.excity.Asia/Qostanay", "コスタナイ" },
            { "timezone.excity.Asia/Sakhalin", "サハリン" },
            { "timezone.excity.Asia/Shanghai", "上海" },
            { "timezone.excity.Asia/Tashkent", "タシケント" },
            { "timezone.excity.Asia/Ust-Nera", "ウスチネラ" },
            { "timezone.excity.Europe/Athens", "アテネ" },
            { "timezone.excity.Europe/Berlin", "ベルリン" },
            { "timezone.excity.Europe/Dublin", "ダブリン" },
            { "timezone.excity.Europe/Jersey", "ジャージー" },
            { "timezone.excity.Europe/Lisbon", "リスボン" },
            { "timezone.excity.Europe/London", "ロンドン" },
            { "timezone.excity.Europe/Madrid", "マドリード" },
            { "timezone.excity.Europe/Monaco", "モナコ" },
            { "timezone.excity.Europe/Moscow", "モスクワ" },
            { "timezone.excity.Europe/Prague", "プラハ" },
            { "timezone.excity.Europe/Samara", "サマラ" },
            { "timezone.excity.Europe/Skopje", "スコピエ" },
            { "timezone.excity.Europe/Tirane", "ティラナ" },
            { "timezone.excity.Europe/Vienna", "ウィーン" },
            { "timezone.excity.Europe/Warsaw", "ワルシャワ" },
            { "timezone.excity.Europe/Zagreb", "ザグレブ" },
            { "timezone.excity.Europe/Zurich", "チューリッヒ" },
            { "timezone.excity.Indian/Chagos", "チャゴス" },
            { "timezone.excity.Indian/Comoro", "コモロ" },
            { "timezone.excity.Pacific/Efate", "エフェテ島" },
            { "timezone.excity.Pacific/Nauru", "ナウル" },
            { "timezone.excity.Pacific/Palau", "パラオ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "アビジャン" },
            { "timezone.excity.Africa/Algiers", "アルジェ" },
            { "timezone.excity.Africa/Conakry", "コナクリ" },
            { "timezone.excity.Africa/Kampala", "カンパラ" },
            { "timezone.excity.Africa/Mbabane", "ムババーネ" },
            { "timezone.excity.Africa/Nairobi", "ナイロビ" },
            { "timezone.excity.Africa/Tripoli", "トリポリ" },
            { "timezone.excity.America/Belize", "ベリーズ" },
            { "timezone.excity.America/Bogota", "ボゴタ" },
            { "timezone.excity.America/Cancun", "カンクン" },
            { "timezone.excity.America/Cayman", "ケイマン" },
            { "timezone.excity.America/Cuiaba", "クイアバ" },
            { "timezone.excity.America/Dawson", "ドーソン" },
            { "timezone.excity.America/Denver", "デンバー" },
            { "timezone.excity.America/Guyana", "ガイアナ" },
            { "timezone.excity.America/Havana", "ハバナ" },
            { "timezone.excity.America/Inuvik", "イヌヴィク" },
            { "timezone.excity.America/Juneau", "ジュノー" },
            { "timezone.excity.America/La_Paz", "ラパス" },
            { "timezone.excity.America/Maceio", "マセイオ" },
            { "timezone.excity.America/Manaus", "マナウス" },
            { "timezone.excity.America/Merida", "メリダ" },
            { "timezone.excity.America/Nassau", "ナッソー" },
            { "timezone.excity.America/Panama", "パナマ" },
            { "timezone.excity.America/Recife", "レシフェ" },
            { "timezone.excity.America/Regina", "レジャイナ" },
            { "timezone.excity.Asia/Famagusta", "ファマグスタ" },
            { "timezone.excity.Asia/Hong_Kong", "香港" },
            { "timezone.excity.Asia/Jerusalem", "エルサレム" },
            { "timezone.excity.Asia/Kamchatka", "カムチャッカ" },
            { "timezone.excity.Asia/Pontianak", "ポンティアナック" },
            { "timezone.excity.Asia/Pyongyang", "平壌" },
            { "timezone.excity.Asia/Qyzylorda", "クズロルダ" },
            { "timezone.excity.Asia/Samarkand", "サマルカンド" },
            { "timezone.excity.Asia/Singapore", "シンガポール" },
            { "timezone.excity.Asia/Vientiane", "ビエンチャン" },
            { "timezone.excity.Europe/Andorra", "アンドラ" },
            { "timezone.excity.Europe/Saratov", "サラトフ" },
            { "timezone.excity.Europe/Tallinn", "タリン" },
            { "timezone.excity.Europe/Vatican", "バチカン" },
            { "timezone.excity.Europe/Vilnius", "ヴィリニュス" },
            { "timezone.excity.Indian/Mayotte", "マヨット" },
            { "timezone.excity.Indian/Reunion", "レユニオン" },
            { "timezone.excity.Pacific/Easter", "イースター島" },
            { "timezone.excity.Pacific/Kosrae", "コスラエ" },
            { "timezone.excity.Pacific/Majuro", "マジュロ" },
            { "timezone.excity.Pacific/Midway", "ミッドウェー島" },
            { "timezone.excity.Pacific/Noumea", "ヌメア" },
            { "timezone.excity.Pacific/Ponape", "ポンペイ島" },
            { "timezone.excity.Pacific/Saipan", "サイパン" },
            { "timezone.excity.Pacific/Tahiti", "タヒチ" },
            { "timezone.excity.Pacific/Tarawa", "タラワ" },
            { "timezone.excity.Pacific/Wallis", "ウォリス諸島" },
            { "timezone.excity.Africa/Blantyre", "ブランタイヤ" },
            { "timezone.excity.Africa/Djibouti", "ジブチ" },
            { "timezone.excity.Africa/El_Aaiun", "アイウン" },
            { "timezone.excity.Africa/Freetown", "フリータウン" },
            { "timezone.excity.Africa/Gaborone", "ハボローネ" },
            { "timezone.excity.Africa/Khartoum", "ハルツーム" },
            { "timezone.excity.Africa/Kinshasa", "キンシャサ" },
            { "timezone.excity.Africa/Monrovia", "モンロビア" },
            { "timezone.excity.Africa/Ndjamena", "ンジャメナ" },
            { "timezone.excity.Africa/Sao_Tome", "サントメ" },
            { "timezone.excity.Africa/Windhoek", "ウィントフック" },
            { "timezone.excity.America/Antigua", "アンティグア" },
            { "timezone.excity.America/Caracas", "カラカス" },
            { "timezone.excity.America/Cayenne", "カイエンヌ" },
            { "timezone.excity.America/Chicago", "シカゴ" },
            { "timezone.excity.America/Cordoba", "コルドバ" },
            { "timezone.excity.America/Creston", "クレストン" },
            { "timezone.excity.America/Curacao", "キュラソー" },
            { "timezone.excity.America/Detroit", "デトロイト" },
            { "timezone.excity.America/Godthab", "ヌーク" },
            { "timezone.excity.America/Grenada", "グレナダ" },
            { "timezone.excity.America/Halifax", "ハリファクス" },
            { "timezone.excity.America/Iqaluit", "イカルイット" },
            { "timezone.excity.America/Jamaica", "ジャマイカ" },
            { "timezone.excity.America/Managua", "マナグア" },
            { "timezone.excity.America/Marigot", "マリゴ" },
            { "timezone.excity.America/Mendoza", "メンドーサ" },
            { "timezone.excity.America/Moncton", "モンクトン" },
            { "timezone.excity.America/Noronha", "ノローニャ" },
            { "timezone.excity.America/Ojinaga", "オヒナガ" },
            { "timezone.excity.America/Phoenix", "フェニックス" },
            { "timezone.excity.America/Tijuana", "ティフアナ" },
            { "timezone.excity.America/Toronto", "トロント" },
            { "timezone.excity.America/Tortola", "トルトーラ" },
            { "timezone.excity.America/Yakutat", "ヤクタット" },
            { "timezone.excity.Asia/Phnom_Penh", "プノンペン" },
            { "timezone.excity.Atlantic/Azores", "アゾレス" },
            { "timezone.excity.Atlantic/Canary", "カナリア" },
            { "timezone.excity.Atlantic/Faeroe", "フェロー" },
            { "timezone.excity.Australia/Eucla", "ユークラ" },
            { "timezone.excity.Australia/Perth", "パース" },
            { "timezone.excity.Europe/Belgrade", "ベオグラード" },
            { "timezone.excity.Europe/Brussels", "ブリュッセル" },
            { "timezone.excity.Europe/Budapest", "ブダペスト" },
            { "timezone.excity.Europe/Busingen", "ビュージンゲン" },
            { "timezone.excity.Europe/Chisinau", "キシナウ" },
            { "timezone.excity.Europe/Guernsey", "ガーンジー" },
            { "timezone.excity.Europe/Helsinki", "ヘルシンキ" },
            { "timezone.excity.Europe/Istanbul", "イスタンブール" },
            { "timezone.excity.Europe/Sarajevo", "サラエボ" },
            { "timezone.excity.Indian/Maldives", "モルディブ" },
            { "timezone.excity.Pacific/Chatham", "チャタム" },
            { "timezone.excity.Pacific/Fakaofo", "ファカオフォ" },
            { "timezone.excity.Pacific/Gambier", "ガンビエ諸島" },
            { "timezone.excity.Pacific/Norfolk", "ノーフォーク島" },
            { "timezone.excity.Africa/Bujumbura", "ブジュンブラ" },
            { "timezone.excity.Africa/Mogadishu", "モガディシオ" },
            { "timezone.excity.America/Anguilla", "アンギラ" },
            { "timezone.excity.America/Asuncion", "アスンシオン" },
            { "timezone.excity.America/Barbados", "バルバドス" },
            { "timezone.excity.America/Dominica", "ドミニカ" },
            { "timezone.excity.America/Edmonton", "エドモントン" },
            { "timezone.excity.America/Eirunepe", "エイルネペ" },
            { "timezone.excity.America/Mazatlan", "マサトラン" },
            { "timezone.excity.America/Miquelon", "ミクロン島" },
            { "timezone.excity.America/New_York", "ニューヨーク" },
            { "timezone.excity.America/Resolute", "レゾリュート" },
            { "timezone.excity.America/Santarem", "サンタレム" },
            { "timezone.excity.America/Santiago", "サンチアゴ" },
            { "timezone.excity.America/St_Johns", "セントジョンズ" },
            { "timezone.excity.America/St_Kitts", "セントクリストファー" },
            { "timezone.excity.America/St_Lucia", "セントルシア" },
            { "timezone.excity.America/Winnipeg", "ウィニペグ" },
            { "timezone.excity.Antarctica/Casey", "ケーシー基地" },
            { "timezone.excity.Antarctica/Davis", "デービス基地" },
            { "timezone.excity.Antarctica/Syowa", "昭和基地" },
            { "timezone.excity.Antarctica/Troll", "トロル基地" },
            { "timezone.excity.Asia/Krasnoyarsk", "クラスノヤルスク" },
            { "timezone.excity.Asia/Novosibirsk", "ノヴォシビルスク" },
            { "timezone.excity.Asia/Ulaanbaatar", "ウランバートル" },
            { "timezone.excity.Asia/Vladivostok", "ウラジオストク" },
            { "timezone.excity.Atlantic/Bermuda", "バミューダ" },
            { "timezone.excity.Atlantic/Madeira", "マデイラ" },
            { "timezone.excity.Atlantic/Stanley", "スタンレー" },
            { "timezone.excity.Australia/Darwin", "ダーウィン" },
            { "timezone.excity.Australia/Hobart", "ホバート" },
            { "timezone.excity.Australia/Sydney", "シドニー" },
            { "timezone.excity.Europe/Amsterdam", "アムステルダム" },
            { "timezone.excity.Europe/Astrakhan", "アストラハン" },
            { "timezone.excity.Europe/Bucharest", "ブカレスト" },
            { "timezone.excity.Europe/Gibraltar", "ジブラルタル" },
            { "timezone.excity.Europe/Ljubljana", "リュブリャナ" },
            { "timezone.excity.Europe/Mariehamn", "マリエハムン" },
            { "timezone.excity.Europe/Podgorica", "ポドゴリツァ" },
            { "timezone.excity.Europe/Stockholm", "ストックホルム" },
            { "timezone.excity.Europe/Ulyanovsk", "ウリヤノフスク" },
            { "timezone.excity.Europe/Volgograd", "ボルゴグラード" },
            { "timezone.excity.Indian/Christmas", "クリスマス島" },
            { "timezone.excity.Indian/Kerguelen", "ケルゲレン諸島" },
            { "timezone.excity.Indian/Mauritius", "モーリシャス" },
            { "timezone.excity.Pacific/Auckland", "オークランド" },
            { "timezone.excity.Pacific/Funafuti", "フナフティ" },
            { "timezone.excity.Pacific/Honolulu", "ホノルル" },
            { "timezone.excity.Pacific/Pitcairn", "ピトケアン諸島" },
            { "timezone.excity.Africa/Casablanca", "カサブランカ" },
            { "timezone.excity.Africa/Libreville", "リーブルヴィル" },
            { "timezone.excity.Africa/Lubumbashi", "ルブンバシ" },
            { "timezone.excity.Africa/Nouakchott", "ヌアクショット" },
            { "timezone.excity.Africa/Porto-Novo", "ポルトノボ" },
            { "timezone.excity.America/Anchorage", "アンカレッジ" },
            { "timezone.excity.America/Araguaina", "アラグァイナ" },
            { "timezone.excity.America/Boa_Vista", "ボアビスタ" },
            { "timezone.excity.America/Catamarca", "カタマルカ" },
            { "timezone.excity.America/Chihuahua", "チワワ" },
            { "timezone.excity.America/Coyhaique", "コジャイケ" },
            { "timezone.excity.America/Fortaleza", "フォルタレザ" },
            { "timezone.excity.America/Glace_Bay", "グレースベイ" },
            { "timezone.excity.America/Goose_Bay", "グースベイ" },
            { "timezone.excity.America/Guatemala", "グアテマラ" },
            { "timezone.excity.America/Guayaquil", "グアヤキル" },
            { "timezone.excity.America/Matamoros", "マタモロス" },
            { "timezone.excity.America/Menominee", "メノミニー" },
            { "timezone.excity.America/Monterrey", "モンテレイ" },
            { "timezone.excity.America/Sao_Paulo", "サンパウロ" },
            { "timezone.excity.America/St_Thomas", "セントトーマス" },
            { "timezone.excity.America/Vancouver", "バンクーバー" },
            { "timezone.excity.Antarctica/Mawson", "モーソン基地" },
            { "timezone.excity.Antarctica/Palmer", "パーマー基地" },
            { "timezone.excity.Antarctica/Vostok", "ボストーク基地" },
            { "timezone.excity.Asia/Kuala_Lumpur", "クアラルンプール" },
            { "timezone.excity.Asia/Novokuznetsk", "ノヴォクズネツク" },
            { "timezone.excity.Europe/Bratislava", "ブラチスラバ" },
            { "timezone.excity.Europe/Copenhagen", "コペンハーゲン" },
            { "timezone.excity.Europe/Luxembourg", "ルクセンブルク" },
            { "timezone.excity.Europe/San_Marino", "サンマリノ" },
            { "timezone.excity.Europe/Simferopol", "シンフェロポリ" },
            { "timezone.excity.Pacific/Enderbury", "カントン島" },
            { "timezone.excity.Pacific/Galapagos", "ガラパゴス" },
            { "timezone.excity.Pacific/Kwajalein", "クェゼリン" },
            { "timezone.excity.Pacific/Marquesas", "マルキーズ" },
            { "timezone.excity.Pacific/Pago_Pago", "パゴパゴ" },
            { "timezone.excity.Pacific/Rarotonga", "ラロトンガ" },
            { "timezone.excity.Pacific/Tongatapu", "トンガタプ" },
            { "timezone.excity.Africa/Addis_Ababa", "アジスアベバ" },
            { "timezone.excity.Africa/Brazzaville", "ブラザビル" },
            { "timezone.excity.Africa/Ouagadougou", "ワガドゥグー" },
            { "timezone.excity.America/Costa_Rica", "コスタリカ" },
            { "timezone.excity.America/Grand_Turk", "グランドターク" },
            { "timezone.excity.America/Guadeloupe", "グアドループ" },
            { "timezone.excity.America/Hermosillo", "エルモシヨ" },
            { "timezone.excity.America/Kralendijk", "クラレンダイク" },
            { "timezone.excity.America/Louisville", "ルイビル" },
            { "timezone.excity.America/Martinique", "マルティニーク" },
            { "timezone.excity.America/Metlakatla", "メトラカトラ" },
            { "timezone.excity.America/Montevideo", "モンテビデオ" },
            { "timezone.excity.America/Montserrat", "モントセラト" },
            { "timezone.excity.America/Paramaribo", "パラマリボ" },
            { "timezone.excity.America/Rio_Branco", "リオブランコ" },
            { "timezone.excity.America/St_Vincent", "セントビンセント" },
            { "timezone.excity.America/Whitehorse", "ホワイトホース" },
            { "timezone.excity.Antarctica/McMurdo", "マクマード基地" },
            { "timezone.excity.Antarctica/Rothera", "ロゼラ基地" },
            { "timezone.excity.Asia/Srednekolymsk", "スレドネコリムスク" },
            { "timezone.excity.Asia/Yekaterinburg", "エカテリンブルグ" },
            { "timezone.excity.Atlantic/Reykjavik", "レイキャビク" },
            { "timezone.excity.Atlantic/St_Helena", "セントヘレナ" },
            { "timezone.excity.Australia/Adelaide", "アデレード" },
            { "timezone.excity.Australia/Brisbane", "ブリスベン" },
            { "timezone.excity.Australia/Lindeman", "リンデマン" },
            { "timezone.excity.Europe/Isle_of_Man", "マン島" },
            { "timezone.excity.Europe/Kaliningrad", "カリーニングラード" },
            { "timezone.excity.Pacific/Kiritimati", "キリスィマスィ島" },
            { "timezone.excity.Africa/Johannesburg", "ヨハネスブルグ" },
            { "timezone.excity.America/El_Salvador", "エルサルバドル" },
            { "timezone.excity.America/Fort_Nelson", "フォートネルソン" },
            { "timezone.excity.America/Los_Angeles", "ロサンゼルス" },
            { "timezone.excity.America/Mexico_City", "メキシコシティー" },
            { "timezone.excity.America/Porto_Velho", "ポルトベーリョ" },
            { "timezone.excity.America/Puerto_Rico", "プエルトリコ" },
            { "timezone.excity.America/Tegucigalpa", "テグシガルパ" },
            { "timezone.excity.Arctic/Longyearbyen", "ロングイェールビーン" },
            { "timezone.excity.Atlantic/Cape_Verde", "カーボベルデ" },
            { "timezone.excity.Australia/Lord_Howe", "ロードハウ" },
            { "timezone.excity.Australia/Melbourne", "メルボルン" },
            { "timezone.excity.Indian/Antananarivo", "アンタナナリボ" },
            { "timezone.excity.Pacific/Guadalcanal", "ガダルカナル" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ダルエスサラーム" },
            { "timezone.excity.America/Blanc-Sablon", "ブラン・サブロン" },
            { "timezone.excity.America/Buenos_Aires", "ブエノスアイレス" },
            { "timezone.excity.America/Campo_Grande", "カンポグランデ" },
            { "timezone.excity.America/Danmarkshavn", "デンマークシャウン" },
            { "timezone.excity.America/Dawson_Creek", "ドーソンクリーク" },
            { "timezone.excity.America/Indiana/Knox", "インディアナ州ノックス" },
            { "timezone.excity.America/Indianapolis", "インディアナポリス" },
            { "timezone.excity.America/Punta_Arenas", "プンタアレナス" },
            { "timezone.excity.America/Rankin_Inlet", "ランキンインレット" },
            { "timezone.excity.America/Scoresbysund", "イトコルトルミット" },
            { "timezone.excity.Antarctica/Macquarie", "マッコリー" },
            { "timezone.excity.Pacific/Bougainville", "ブーゲンビル" },
            { "timezone.excity.Pacific/Port_Moresby", "ポートモレスビー" },
            { "timezone.excity.America/Cambridge_Bay", "ケンブリッジベイ" },
            { "timezone.excity.America/Ciudad_Juarez", "シウダー・フアレス" },
            { "timezone.excity.America/Coral_Harbour", "アティコカン" },
            { "timezone.excity.America/Indiana/Vevay", "インディアナ州ビベー" },
            { "timezone.excity.America/Lower_Princes", "ローワー・プリンセズ・クウォーター" },
            { "timezone.excity.America/Port_of_Spain", "ポートオブスペイン" },
            { "timezone.excity.America/Santo_Domingo", "サントドミンゴ" },
            { "timezone.excity.America/St_Barthelemy", "サン・バルテルミー" },
            { "timezone.excity.America/Swift_Current", "スウィフトカレント" },
            { "timezone.excity.Australia/Broken_Hill", "ブロークンヒル" },
            { "timezone.excity.America/Bahia_Banderas", "バイアバンデラ" },
            { "timezone.excity.America/Port-au-Prince", "ポルトープランス" },
            { "timezone.excity.Atlantic/South_Georgia", "サウスジョージア" },
            { "timezone.excity.America/Argentina/Salta", "サルタ" },
            { "timezone.excity.America/Indiana/Marengo", "インディアナ州マレンゴ" },
            { "timezone.excity.America/Indiana/Winamac", "インディアナ州ウィナマック" },
            { "timezone.excity.America/Argentina/Tucuman", "トゥクマン" },
            { "timezone.excity.America/Argentina/Ushuaia", "ウシュアイア" },
            { "timezone.excity.America/Indiana/Tell_City", "インディアナ州テルシティ" },
            { "timezone.excity.America/Indiana/Vincennes", "インディアナ州ビンセンス" },
            { "timezone.excity.Antarctica/DumontDUrville", "デュモン・デュルヴィル基地" },
            { "timezone.excity.America/Argentina/La_Rioja", "ラリオハ" },
            { "timezone.excity.America/Argentina/San_Juan", "サンファン" },
            { "timezone.excity.America/Argentina/San_Luis", "サンルイス" },
            { "timezone.excity.America/Indiana/Petersburg", "インディアナ州ピーターズバーグ" },
            { "timezone.excity.America/Kentucky/Monticello", "ケンタッキー州モンティチェロ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ノースダコタ州ビューラー" },
            { "timezone.excity.America/North_Dakota/Center", "ノースダコタ州センター" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "リオガジェゴス" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ノースダコタ州ニューセーラム" },
        };
        return data;
    }
}
