/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_shn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_057 = "ၼႃႈလိၼ် မၢႆႇၶရူဝ်ႇၼေးသျၼ်း";
        final String metaValue_AZ = "ဢႃႇၸႃႇပၢႆႇၸၼ်ႇ";
        final String metaValue_BY = "ပႄႇလႃႇရုတ်ႈ";
        final String metaValue_BG = "ပူႇၵႃႇရီႇယႃႇ";
        final String metaValue_CZ = "ၶျႅၵ်ႈ";
        final String metaValue_GR = "ၵရိတ်ႈ";
        final String metaValue_ES = "သပဵၼ်ႇ";
        final String metaValue_EE = "ဢႄႇသတူဝ်းၼီးယႃး";
        final String metaValue_FI = "ၾိၼ်ႇလႅၼ်ႇ";
        final String metaValue_FR = "ၾရၢင်ႇသဵတ်ႈ";
        final String metaValue_HR = "ၶရူဝ်ႇဢေးသျႃး";
        final String metaValue_HU = "ႁၢင်ႇၵေႇရီႇ";
        final String metaValue_AM = "ဢႃႇမေးၼီးယႃး";
        final String metaValue_ID = "ဢိၼ်ႇတူဝ်ႇၼီးသျႃး";
        final String metaValue_IS = "ဢၢႆးသလႅၼ်ႇ";
        final String metaValue_IT = "ဢီႇတႃႇလီႇ";
        final String metaValue_JP = "ၵျႃႇပၢၼ်ႇ";
        final String metaValue_GE = "ၵျေႃႇၵျႃႇ";
        final String metaValue_LU = "လၢၵ်ႈၸိမ်ႇပၢၵ်ႈ";
        final String metaValue_LA = "လၢဝ်း";
        final String metaValue_LT = "လီႉတူႇဝေးၼီးယႃး";
        final String metaValue_LV = "လၢတ်ႈဝီႇယႃႇ";
        final String metaValue_MN = "မူင်ႇၵူဝ်းလီးယႃး";
        final String metaValue_NO = "ၼေႃႇဝူၺ်း";
        final String metaValue_PL = "ပူဝ်ႇလႅၼ်ႇ";
        final String metaValue_PT = "ပေႃးတူႉၵၢဝ်ႇ";
        final String metaValue_RO = "ရူဝ်ႇမေးၼီးယႃး";
        final String metaValue_RU = "ရတ်ႈသျႃး";
        final String metaValue_AL = "ဢႃႇပႃးၼီးယႃး";
        final String metaValue_RS = "သႃးပီးယႃး";
        final String metaValue_TR = "တိူဝ်ႇၵီႇ";
        final String metaValue_UA = "ယူႇၶရဵၼ်း";
        final String metaValue_VN = "ဝႅတ်ႉၼမ်း";
        final String metaValue_CN = "ၶႄႇ";
        final String metaValue_PH = "ၾီလိပ်ႈပိၼ်း";
        final String metaValue_ar = "ဢႃႇရၢပ်ႈ";
        final String metaValue_gu = "ၵူးၵျရႃႇတီႇ";
        final String metaValue_he = "ႁီးပရူး";
        final String metaValue_km = "ၶမဵၼ်";
        final String metaValue_ko = "ၵၢဝ်းလီ";
        final String metaValue_la = "လတိၼ်ႇ";
        final String metaValue_osa = "ဢူဝ်းသဵတ်ႉ";
        final String metaValue_si = "သိၼ်ႁႃးလႃႇ";
        final String metaValue_syr = "သီးရီးဢႅၵ်ႉ";
        final String metaValue_ta = "တမီးလ်";
        final String metaValue_te = "ထႄးလူႇၵူႇ";
        final String metaValue_th = "ထႆး";
        final String metaValue_bo = "ထိပႅတ်ႉ";
        final String metaValue_vai = "ဝၢႆး";
        final Object[][] data = new Object[][] {
            { "001", "ၵမ်ႇၽႃႇ" },
            { "002", "ဢႃႇၾရိၵ" },
            { "003", "ဢမႄႇရိၵႁွင်ႇ" },
            { "005", "ဢမႄႇရိၵၸၢၼ်း" },
            { "009", "ဢူဝ်းသီးၼီးယႃး" },
            { "011", "ဢႃႇၾရိၵ ပွတ်းတူၵ်း" },
            { "013", "ဢမႄႇရိၵ ပွတ်းၵၢင်" },
            { "014", "ဢႃႇၾရိၵ ပွတ်းဢွၵ်ႇ" },
            { "015", "ဢႃႇၾရိၵ ပွတ်းႁွင်ႇ" },
            { "017", "ဢႃႇၾရိၵ တွၼ်ႈၵၢင်" },
            { "018", "ဢႃႇၾရိၵ ပွတ်းၸၢၼ်း" },
            { "019", "ဢမႄႇရိၵ" },
            { "021", "ဢမႄႇရိၵ ပွတ်းႁွင်ႇ" },
            { "029", "ၶႃႇရိပ်ႈပီႇယၼ်ႇ" },
            { "030", "ဢေးသျႃး ပွတ်းဢွၵ်ႇ" },
            { "034", "ဢေးသျႃး ပွတ်းၸၢၼ်း" },
            { "035", "ဢေးသျႃး ၸဵင်ႇၸၢၼ်းဝၼ်းဢွၵ်ႇ" },
            { "039", "ယူးရူပ်ႉ ပွတ်းၸၢၼ်း" },
            { "053", "ဢေႃႉသထရႃႇလေးသျႃး" },
            { "054", "မႄႇလၼ်ႇၼီးသျႃး" },
            { "057", metaValue_057 },
            { "061", "ပေႃႇလီႇၼေးသျႃး" },
            { "142", "ဢေးသျႃး" },
            { "143", "ဢေးသျႃး ပွတ်းၵၢင်" },
            { "145", "ဢေးသျႃး ပွတ်းတူၵ်း" },
            { "150", "ယူးရူပ်ႉ" },
            { "151", "ယူးရူပ်ႉ ပွတ်းဢွၵ်ႇ" },
            { "154", "ယူးရူပ်ႉ ပွတ်းႁွင်ႇ" },
            { "155", "ယူးရူပ်ႉ ပွတ်းတူၵ်း" },
            { "202", "ဢႃႇၾရိၵ သႃႇႁႃႇရၽႄ" },
            { "419", "လတိၼ်ႇ ဢမႄႇရိၵ" },
            { "AC", "ၵုၼ်ဢေႇသႅၼ်းသျိၼ်ႇ" },
            { "AD", "ဢႅၼ်ႇတူဝ်ႇရႃႇ" },
            { "AE", "မိူင်းႁူမ်ႈတုမ် ၸဝ်ႈၾႃႉ ဢႃႇရၢပ်ႈ" },
            { "AF", "ဢႃႇၾၵၢၼ်ႇၼီႇသတၢၼ်ႇ" },
            { "AG", "ဢႅၼ်ႇထီႇၵႂႃႇ လႄႈ ပႃႇပူးတႃႇ" },
            { "AI", "ဢႅၼ်ႇၵုၺ်ႇလႃႇ" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "ဢႅၼ်ႇၵူဝ်ႇလႃႇ" },
            { "AQ", "ဢႅၼ်ႇတၢၵ်ႈတီးၵႃႈ" },
            { "AR", "ဢႃႇၵျႅၼ်ႇတီးၼႃး" },
            { "AS", "သႃႇမူဝ်းဝႃႇ ၶွ​င် ဢမႄႇရိၵၢၼ်ႇ" },
            { "AT", "ဢေႃးသထရီးယႃး" },
            { "AU", "ဢေႃႉသထရေးလီးယႃး" },
            { "AW", "ဢႃႇရူးပႃး" },
            { "AX", "မူႇၵုၼ် ဢေႃးလႅၼ်ႇ" },
            { "AZ", metaValue_AZ },
            { "BA", "ပေႃးသၼီးယႃး လႄႈ ႁႃႇၸီႇၵူဝ်းဝီးၼႃး" },
            { "BB", "ပႃးပေႇတူတ်ႈ" },
            { "BD", "ပင်းၵလႃးတဵတ်ႈ" },
            { "BE", "ပႄႇၵျီႇယမ်ႇ" },
            { "BF", "ပူႇၵီႇၼႃးၾႃးသူဝ်ႇ" },
            { "BG", metaValue_BG },
            { "BH", "ပႃႇရဵၼ်း" },
            { "BI", "ပူႇရုၼ်းတီႇ" },
            { "BJ", "ပႄႇၼိၼ်း" },
            { "BL", "သဵင်ႉပႃႇထႄးလႄႇမီႇ" },
            { "BM", "ပႃႇမိဝ်းတႃး" },
            { "BN", "ပရူႇၼၢႆး" },
            { "BO", "ပူဝ်ႇလီးပီးယႃး" },
            { "BQ", "ၼႄႇတႃႇလႅၼ်ႇ တီႈ ၶႃႇရိပ်ႈပီႇယၼ်ႇ" },
            { "BR", "ပရႃႇၸီး" },
            { "BS", "ပႃႇႁႃးမႃး" },
            { "BT", "ၽူႇတၢၼ်ႇ" },
            { "BV", "မူႇၵုၼ် ပူးဝႅတ်ႉ" },
            { "BW", "ပွတ်ႉသဝႃႇၼႃႇ" },
            { "BY", metaValue_BY },
            { "BZ", "ပႄႇလိတ်ႈ" },
            { "CA", "ၶႅၼ်ႇၼေႇတႃႇ" },
            { "CC", "မူႇၵုၼ် ၶူဝ်းၵတ်ႉ (ၶီးလိင်း)" },
            { "CD", "ၶွင်ႇၵူဝ်ႇ - ၶိၼ်သျႃးသႃႇ" },
            { "CF", "မိူင်းႁူမ်ႈပွင်လူၺ်ႈၵူၼ်းလၢႆ ဢႃႇၾရိၵ ပွတ်းၵၢင်" },
            { "CG", "ၶွင်ႇၵူဝ်ႇ - ပရႃၸဝီးလ်" },
            { "CH", "သဝိတ်ႈၸႃႇလႅၼ်ႇ" },
            { "CI", "ဢၢႆႇဝူဝ်ႇရီႇၶူတ်ႈ" },
            { "CK", "မူႇၵုၼ် ၶုၵ်ႈ" },
            { "CL", "ၶျီႇလီႇ" },
            { "CM", "ၶႅမ်းမႃးရုၼ်း" },
            { "CN", metaValue_CN },
            { "CO", "ၵူဝ်ႇလမ်ႇပီႇယႃႇ" },
            { "CP", "ၵုၼ်ၶလိပ်ႉပႃႇတၼ်ႇ" },
            { "CQ", "သၢၵ်ႉၶ်" },
            { "CR", "ၵေႃးသတႃႇရိၵႃႇ" },
            { "CU", "ၵူးပႃး" },
            { "CV", "ၶဵပ်ႉဝႄႇတီႇ" },
            { "CW", "ၵူးရႃႇသၢဝ်ႇ" },
            { "CX", "ၵုၼ်ၶရိတ်ႉသမၢတ်ႉ" },
            { "CY", "သၢႆႉပရႅတ်ႈ" },
            { "CZ", metaValue_CZ },
            { "DE", "ၵျႃႇမၼီႇ" },
            { "DG", "တီႇယေးၵူဝ်း ၵရႃႇသီးယႃး" },
            { "DJ", "ၵျီႇပူးတီႇ" },
            { "DK", "တႅၼ်းမၢၵ်ႈ" },
            { "DM", "တူဝ်ႇမီႇၼိၵ" },
            { "DO", "တူဝ်ႇမီႇၼီႇၵၼ်ႇ" },
            { "DZ", "ဢႄးၵျီးရီးယႃး" },
            { "EA", "သူးတ လႄႈ မႄႇလီႇလႃႇ" },
            { "EC", "ဢေႇၵႂႃႇတေႃႇ" },
            { "EE", metaValue_EE },
            { "EG", "ဢီးၵျိပ်ႈ" },
            { "EH", "သႃႇႁႃႇရႃႇ ပွတ်းတူၵ်း" },
            { "ER", "ဢႄႇရီႇထရီးယႃး" },
            { "ES", metaValue_ES },
            { "ET", "ဢီႇတီႇယူဝ်းပီးယႃး" },
            { "EU", "ၸုမ်းၽွမ်ႉႁူမ်ႈ ယူးရူပ်ႉ" },
            { "EZ", "ၸူၼ်ႇယူးရူပ်ႉ" },
            { "FI", metaValue_FI },
            { "FJ", "ၾီႇၵျီႇ" },
            { "FK", "မူႇၵုၼ် ၾွၵ်ႉလႅၼ်ႇ" },
            { "FM", metaValue_057 },
            { "FO", "မူႇၵုၼ် ၾႄးရူဝ်း" },
            { "FR", metaValue_FR },
            { "GA", "ၵႄးပုၼ်ႇ" },
            { "GB", "မိူင်းႁူမ်ႈတုမ်ႁေႃၶမ်း ပရိတ်ႈတဵၼ်ႇ" },
            { "GD", "ၵရႄႇၼႃႇတႃႇ" },
            { "GE", metaValue_GE },
            { "GF", "ၵုၺ်ႇယႃႇၼႃႇ ၶွင် ၾရၢင်ႇသဵတ်ႈ" },
            { "GG", "ၵႂၢၼ်းသီ" },
            { "GH", "ၵႃႇၼႃႇ" },
            { "GI", "ၵျီႇပရေႃးတႃး" },
            { "GL", "ၵရိၼ်းလႅၼ်း" },
            { "GM", "ၵမ်ႇပီးယႃး" },
            { "GN", "ၵီးၼီး" },
            { "GP", "ၵႂႃးတီႇလုပ်ႈ" },
            { "GQ", "ဢီႇၵူၺ်ႇတေႃႇရီႇယႃႇ ၵီးၼီး" },
            { "GR", metaValue_GR },
            { "GS", "ၵျေႃႇၵျႃႇ ပွတ်းၸၢၼ်း လႄႈ မူႇၵုၼ် သၢၼ်းဝိတ်ႉ ပွတ်းၸၢတ်း" },
            { "GT", "ၵႂႃႇတမႃႇလႃႇ" },
            { "GU", "ၵႂၢမ်ႇ" },
            { "GW", "ၵီးၼီး-ပိတ်ႈသၢဝ်ႇ" },
            { "GY", "ၵၢႆႇယႃးၼႃႇ" },
            { "HK", "ႁွင်းၵွင်း ၼႃႈလိၵ်ႈဢုပ်ႉပိူင်ႇၶိုၵ်ႉတွၼ်း ၶႄႇ" },
            { "HM", "မူႇၵုၼ် ႁိူတ်ႉ လႄႈ မူႇၵုၼ် မႅၵ်ႇတေႃႇၼႄႇ" },
            { "HN", "ႁွၼ်ႇတူးရႅတ်ႈ" },
            { "HR", metaValue_HR },
            { "HT", "ႁေးတီႇ" },
            { "HU", metaValue_HU },
            { "IC", "မူႇၵုၼ် ၶႅၼ်ႇၼရီႇ" },
            { "ID", metaValue_ID },
            { "IE", "ဢၢႆႇယႃႇလႅၼ်ႇ" },
            { "IL", "ဢိတ်ႇသရေး" },
            { "IM", "ၵုၼ်မႅၼ်း" },
            { "IN", "ဢိၼ်းတီးယႃး" },
            { "IO", "ၼႃႈလိၼ် သမုၵ်ႉတရႃႇဢိၼ်းတီးယႃး ၶွင် ဢိင်းၵလဵတ်ႈ" },
            { "IQ", "ဢီႇရၢၵ်ႈ" },
            { "IR", "ဢီႇရၢၼ်း" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "ၵျႃႇသီႇ" },
            { "JM", "ၵျႃႇမေႇၵႃႇ" },
            { "JO", "ၵျေႃႇတၼ်ႇ" },
            { "JP", metaValue_JP },
            { "KE", "ၶႅၼ်ႇၺႃႇ" },
            { "KG", "ၵႃႇၵိတ်ႈသတၼ်ႇ" },
            { "KH", "ၵမ်ႇပေႃးတီးယႃး" },
            { "KI", "ၵိရိပတီႇ" },
            { "KM", "ၶူဝ်ႇမူဝ်ႇရူတ်ႈ" },
            { "KN", "သဵင်ႉၶိတ်ႈ လႄႈ ၼႄးဝိတ်ႈ" },
            { "KP", "ၵၢဝ်းလီႁွင်ႇ" },
            { "KR", "ၵၢဝ်းလီၸၢၼ်း" },
            { "KW", "ၶူႇဝဵတ်ႈ" },
            { "KY", "မူႇၵုၼ် ၶေးမႅၼ်း" },
            { "KZ", "ၵႃႇၸၢၵ်ႈသတၼ်ႇ" },
            { "LA", metaValue_LA },
            { "LB", "လႄႇပႃႇၼွၼ်ႇ" },
            { "LC", "သဵင်ႉလူႉသျႃႇ" },
            { "LI", "လိၵ်ႈတိၼ်ႇသတၢႆႇ" },
            { "LK", "သီႇရိလင်းၵႃ" },
            { "LR", "လၢႆႇပေးရီးယႃး" },
            { "LS", "လႄႇသူဝ်းတူဝ်ႇ" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "လိပ်ႉပျႃး" },
            { "MA", "မေႃႇရူဝ်ႇၵူဝ်ႇ" },
            { "MC", "မူဝ်ႇၼႃႉၶူဝ်ႇ" },
            { "MD", "မေႃႇတူဝ်းဝႃး" },
            { "ME", "မွၼ်ႇတေႇၼေးၵရူဝ်ႇ" },
            { "MF", "သဵင်ႉမႃႇတိၼ်" },
            { "MG", "မၢတ်ႈတႃႇၵၢတ်ႈသၵႃႇ" },
            { "MH", "မူႇၵုၼ် မႃးသျႄႇ" },
            { "MK", "မႄႇၶေႇတူဝ်းၼီးယႃးႁွင်ႇ" },
            { "ML", "မႃႇလီႇ" },
            { "MM", "မျၢၼ်ႇမႃႇ (မိူင်းမၢၼ်ႈ)" },
            { "MN", metaValue_MN },
            { "MO", "မႃႇၵၢဝ်ႈ ၼႃႈလိၼ်ဢုပ်ႉပိူင်ႇၶိုၵ်ႉတွၼ်း ၶႄႇ" },
            { "MP", "မူႇၵုၼ် မေႇရီႇယႃႇၼႃႇ ပွတ်းႁွင်ႇ" },
            { "MQ", "မႃးတိၼ်ႇၼိၵ်ႈ" },
            { "MR", "မေႃႇရီႇတေးၼီးယႃး" },
            { "MS", "မွၼ်းသိူဝ်းရၢတ်ႈ" },
            { "MT", "မေႃးတႃႇ" },
            { "MU", "မေႃးရီႇသႃႇ" },
            { "MV", "မေႃႇတိပ်ႈ" },
            { "MW", "မႃႇလႃႇဝီႇ" },
            { "MX", "မႅၵ်ႇသီႇၵူဝ်ႇ" },
            { "MY", "မလေးသျႃး" },
            { "MZ", "မူဝ်ႇၸမ်းပိၵ်ႈ" },
            { "NA", "ၼႃႇမီးပီးယႃး" },
            { "NC", "ၼိဝ်းၶႄႇလီႇတူဝ်းၼီးယႃး" },
            { "NE", "ၼၢႆးၵျႃး" },
            { "NF", "ၵုၼ်ၼေႃႇၾုၵ်ႉ" },
            { "NG", "ၼၢႆႇၵျီးရီးယႃး" },
            { "NI", "ၼီႇၵႃႇရႃႇၵႂႃႇ" },
            { "NL", "ၼႄႇတႃႇလႅၼ်ႇ" },
            { "NO", metaValue_NO },
            { "NP", "ၼေႇပေႃး" },
            { "NR", "ၼၢဝ်ရူး" },
            { "NU", "ၼီးဝႄႇ" },
            { "NZ", "ၼိဝ်းၸီႇလႅၼ်ႇ" },
            { "OM", "ဢူဝ်ႇမၢၼ်ႇ" },
            { "PA", "ပႃႈၼႃးမႃး" },
            { "PE", "ပေႇရူႉ" },
            { "PF", "ပေႃႇလီႇၼေးသျႃး ၶွင် ၾရၢင်ႇသဵတ်ႈ" },
            { "PG", "ပႃးပႂႃႇၼိဝ်းၵီးၼီး" },
            { "PH", metaValue_PH },
            { "PK", "ပႃႇၵိတ်ႈသတၼ်ႇ" },
            { "PL", metaValue_PL },
            { "PM", "သဵင်ႉပီးယႃး လႄႈ မိၵ်ႈၵွႆႇလွၼ်ႇ" },
            { "PN", "မူႇၵုၼ် ၽိတ်ႉၶႅၼ်ႇ" },
            { "PR", "ပေႃႇတူဝ်ႇရီးၵူဝ်း" },
            { "PS", "ၼႃႈလိၼ် ပႃႇလႅတ်ႇသတိၼ်းၼီးယႅၼ်း" },
            { "PT", metaValue_PT },
            { "PW", "ပႃႇလၢဝ်း" },
            { "PY", "ပႃႇရႃႇၵူၺ်း" },
            { "QA", "ၶႃႇတႃႇ" },
            { "QO", "ဢွၵ်ႉလၢႆးယိၼ်း ဢူဝ်းသီးၼီးယႃး" },
            { "RE", "ရေႇၼီႇယၼ်ႇ" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", "ရဝၢၼ်းတႃႇ" },
            { "SA", "သေႃႇတီႇဢႃႇရေးပီးယႃး" },
            { "SB", "မူႇၵုၼ် သေႃႇလေႃႇမၼ်ႇ" },
            { "SC", "သေးသျႄႇ" },
            { "SD", "သူႇတၼ်ႇ" },
            { "SE", "သုၺ်ႇတိၼ်ႇ" },
            { "SG", "သိင်ႇၵႃႇပူဝ်ႇ" },
            { "SH", "သဵင်ႉႁႄးလႄးၼႃႇ" },
            { "SI", "သလူဝ်ႇဝေးၼီးယႃး" },
            { "SJ", "သဝႃးလ်ပၢတ်ႇ လႄႈ ၸၼ်မၢႆးယႅၼ်ႇ" },
            { "SK", "သလူဝ်ႇဝႃးၵီးယႃး" },
            { "SL", "သီႇဢႄႇရႃႇလီႇယူၼ်ႇ" },
            { "SM", "သၼ်းမႃႇရီႇၼေႃႇ" },
            { "SN", "သီႇၼီႇၵႃႇ" },
            { "SO", "သူဝ်ႇမႃႇလီႇယႃး" },
            { "SR", "သျူးရီးၼႃႇမႄႇ" },
            { "SS", "သူႇတၼ်ႇၸၢၼ်း" },
            { "ST", "သူၼ်ႇတူဝ်ႇမေး လႄႈ ပရိၼ်ႇသီႇပေႇ" },
            { "SV", "ဢႄႇသႃႇဝႃႇတေႃႇ" },
            { "SX", "သိၼ်ႉမႃႇတိၼ်ႇ" },
            { "SY", "သီးရီးယႃး" },
            { "SZ", "ဢႅတ်ႇသ်ဝႃႇတီးၼီႇ" },
            { "TA", "ထရီႇသၼ်ႇ တႃႇ ၶုၼ်းၺႃႇ" },
            { "TC", "မူႇၵုၼ် ထၢၵ်ႈ လႄႈ ၶေးၶတ်ႉ" },
            { "TD", "ၶျၢတ်ႈ" },
            { "TF", "ၼႃႈလိၼ် ၾရၢင်ႇသဵတ်ႈ ပွတ်းၸၢၼ်း" },
            { "TG", "ထူဝ်းၵူဝ်ႇ" },
            { "TH", "မိူင်းထႆး" },
            { "TJ", "တႃႇၵျီႇၵီႇသတၼ်ႇ" },
            { "TK", "ထူဝ်းၵေႇလၢဝ်ႇ" },
            { "TL", "တီႇမေႃး-လႅတ်ႉသ်တႄး" },
            { "TM", "တၢၵ်ႈမႅၼ်ႇၼီႇသတၼ်ႇ" },
            { "TN", "တူႇၼီးသျႃး" },
            { "TO", "ထွင်းၵႃႇ" },
            { "TR", metaValue_TR },
            { "TT", "ထရီႇၼီႇတၢတ်ႈ လႄႈ ထူဝ်ႇပေးၵူဝ်ႇ" },
            { "TV", "ထူးဝႃႇလူႇ" },
            { "TW", "ထၢႆႇဝၢၼ်း" },
            { "TZ", "ထၼ်ႇၸၼ်းၼီးယႃး" },
            { "UA", metaValue_UA },
            { "UG", "ယူႇၵၼ်ႇတႃႇ" },
            { "UM", "မူႇၵုၼ်ဢွၼ်ႇ ဢၼ်မီးၽၢႆႇၼွၵ်ႈ ယူႇဢႅတ်ႉသ်" },
            { "UN", "ၸၢတ်ႈၸိုင်ႈလုမ်ႈၾႃႉ" },
            { "US", "မိူင်းႁူမ်ႈတုမ် ဢမႄႇရိၵ" },
            { "UY", "ဢုရုၵူၺ်း" },
            { "UZ", "ဢူႇၸပႄႉၵိတ်ႇသတၼ်ႇ" },
            { "VA", "ဝႃႇတီႇၵၼ်ႇသီးတီး" },
            { "VC", "သဵင်ႉဝိၼ်းသႅၼ်ႉ လႄႈ ၵရႄးၼႃးတိၼ်း" },
            { "VE", "ဝႄႇၼေႇၸွႆးလႃး" },
            { "VG", "မူႇၵုၼ် ဝႃႇၵျိၼ်ႇ ၶွင် ဢိင်းၵလဵတ်ႈ" },
            { "VI", "မူႇၵုၼ် ဝႃႇၵျိၼ်ႇ ၶွင် ယူႇဢႅတ်ႉသ်" },
            { "VN", metaValue_VN },
            { "VU", "ဝႅၼ်ႇၼူးဝႃႇထူႇ" },
            { "WF", "ဝႃးလိတ်ႈ လႄႈ ၾူႇတူးၼႃး" },
            { "WS", "သႃႇမူဝ်းဝႃႇ" },
            { "XA", "သူႇတူဝ်ႇ-ဢႅၵ်ႉသႅၼ်ႉ" },
            { "XB", "သူႇတူဝ်ႇ-ပီးတီႇ" },
            { "XK", "ၵူဝ်ႇသူဝ်ႇဝူဝ်ႇ" },
            { "YE", "ယႄႇမႅၼ်ႇ" },
            { "YT", "မႃႇယူတ်ႈ" },
            { "ZA", "ဢႃႇၾရိၵၸၢၼ်း" },
            { "ZM", "ၸမ်းပီးယႃး" },
            { "ZW", "ၸိမ်ႇပႃႇပူၺ်ႇ" },
            { "ZZ", "ၼႃႈလိၼ် ဢမ်ႇႁူႉၸၵ်း" },
            { "aa", "ဢႃးၾႃႇ" },
            { "ab", "ဢပ်ႇၶႃးၸီႇယႅၼ်ႇ" },
            { "af", "ဢၾရိၵၢၼ်း" },
            { "ak", "ဢႃးၵၼ်ႇ" },
            { "am", "ဢမ်ႇႁႄးရိၵ်ႉ" },
            { "an", "ဢရၵၼိတ်ႉ" },
            { "ar", metaValue_ar },
            { "as", "ဢႃႇသမ်ႇ" },
            { "az", metaValue_AZ },
            { "ba", "ပၢတ်ႇသျ်ၵေးသ်" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bm", "ပႅမ်ပႃရႃႇ" },
            { "bn", "ပင်းၵလႃႇ" },
            { "bo", metaValue_bo },
            { "br", "ပရႅတ်ႉတၼ်ႇ" },
            { "bs", "ပေႃးသၼီးယႃး" },
            { "ca", "ၶႅတ်ႇတလၼ်ႇ" },
            { "ce", "ၶျႅတ်ႉၶျႅၼ်ႇ" },
            { "co", "ၵေႃသီၵၼ်ႇ" },
            { "cs", metaValue_CZ },
            { "cu", "ၶျၢတ်ႉသလႃးဝိၵ်ႉ" },
            { "cv", "ၶျူးဝၢတ်ႇ" },
            { "cy", "ဝႄးလ်သျ်" },
            { "da", "တေးၼိတ်ႉသျ်" },
            { "de", "ၵျႃႇမၼ်ႇ" },
            { "dv", "တီႇဝႄးႁီႇ" },
            { "dz", "ၸွင်းၵႃႇ" },
            { "ee", "ယူး" },
            { "el", metaValue_GR },
            { "en", "ဢိင်းၵလဵတ်ႈ" },
            { "eo", "ဢႅတ်ႉသ်ပရႅၼ်တူဝ်ႇ" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "ပႃႉသ်" },
            { "fa", "ပႃႇသျႃး" },
            { "ff", "ၾူလႃႇ" },
            { "fi", metaValue_FI },
            { "fo", "ၾႄးရူဝ်းဢီးသ်" },
            { "fr", metaValue_FR },
            { "fy", "ၾရီႇသီႇယႅၼ်ႇ ပွတ်းတူၵ်း" },
            { "ga", "ဢၢႆးရိတ်ႉသျ်" },
            { "gd", "ၵေးလိၵ်ႉ သၵွတ်ႉတိသျ်" },
            { "gl", "ၵလီးသီယႅၼ်ႇ" },
            { "gn", "ၵႂႃႇရႃၼီး" },
            { "gu", metaValue_gu },
            { "gv", "မႅၼ်ႉ" },
            { "ha", "ႁၢဝ်းသႃႇ" },
            { "he", metaValue_he },
            { "hi", "ႁိၼ်ႇတီႇ" },
            { "hr", metaValue_HR },
            { "ht", "ႁေးသျုၼ်း ၶရီးဢူဝ်ႇ" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "ia", "ဢိၼ်ထႃလိၼ်းၵႂႃႇ" },
            { "id", metaValue_ID },
            { "ie", "ဢိၼ်ႇထႃႇလိၼ်းၵူၺ်ႇ" },
            { "ig", "ဢိၵ်ႉပူဝ်း" },
            { "ii", "သိသျွၼ်ယီႈ" },
            { "io", "ဢီးတူဝ်ႇ" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "ဢီၼွၵ်းတီတုတ်ႈ" },
            { "ja", metaValue_JP },
            { "jv", "ၵျႃးဝၼိတ်ႉ" },
            { "ka", metaValue_GE },
            { "ki", "ၶူႇၶူးယူႇ" },
            { "kk", "ၵႃးၸႅၵ်ႇ" },
            { "kl", "ၵလႃႈလီးသုတ်ႇ" },
            { "km", metaValue_km },
            { "kn", "ၶၼႃးတႃႇ" },
            { "ko", metaValue_ko },
            { "ks", "ၶႅသ်ႉမီးရီႇ" },
            { "ku", "ၵူႇရမၼ်ႇၵျီႇ" },
            { "kw", "ၶူဝ်းၼိတ်ႉသျ်" },
            { "ky", "ၶေးလ်ၵဵတ်ႇ" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "ၵႅၼ်တႃႇ" },
            { "ln", "လိင်ႇၵႄလ်လႃႇ" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "လူႇပႃႇ-ၵႃႇတၢၼ်ႇၵႃႇ" },
            { "lv", metaValue_LV },
            { "mg", "မလၵႅတ်ႉသီႇ" },
            { "mi", "မၢဝ်းရီႇ" },
            { "mk", "မႄႇၶေႇတူဝ်းၼီးယႃး" },
            { "ml", "မလေႇယႃလမ်ႇ" },
            { "mn", metaValue_MN },
            { "mr", "မရႃႉတီႇ" },
            { "ms", "မလေး" },
            { "mt", "မႄးလ်ထီး" },
            { "my", "မၢၼ်ႈ" },
            { "nb", "ၼေႃႇဝူၺ်း ပွၵ်ႉၶ်မေႃႇ" },
            { "nd", "ဢိၼ်တပႄႇလႃႇ ပွတ်းႁွင်ႇ" },
            { "ne", "ၼေႇပႃႇလီႇ" },
            { "nl", "တၢတ်ႉၶျ်" },
            { "nn", "ၼေႃႇဝူၺ်း ၼၢႆးၼေႃႉၸ်ၶ်" },
            { "no", metaValue_NO },
            { "nr", "ဢိၼ်တပႄႇလႃႇ ပွတ်းၸၢၼ်း" },
            { "nv", "ၼႃးဝႁူဝ်ႇ" },
            { "ny", "ၺႅၼ်ၵျႃႇ" },
            { "oc", "ဢွၵ်ႉသီထႅၼ်ႈ" },
            { "om", "ဢူဝ်ရူဝ်မူဝ်" },
            { "or", "ဢူဝ်ႇတီးယႃး" },
            { "os", "ဢေႃႈသႅတ်ႉထိၵ်ႉ" },
            { "pa", "ပုၼ်ႇၵျႃႇပီႇ" },
            { "pi", "ပႃႇလိ" },
            { "pl", metaValue_PL },
            { "ps", "ၽတ်ႉသ်ျတူဝ်ႇ" },
            { "pt", metaValue_PT },
            { "qu", "ၶႅတ်ႉၶျူႇဝႃႇ" },
            { "rm", "ရူဝ်မႅၼ်ႇသ်ျ" },
            { "rn", "ရုၼ်းတီႇ" },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", "ၶိၼ်ၺႃဝၼ်းတႃႇ" },
            { "sa", "သၼ်းသၶရိတ်ႉ" },
            { "sc", "သႃတီးၼီးယႅၼ်း" },
            { "sd", "သိၼ်းတီႇ" },
            { "se", "သႃးမီး ပွတ်းႁွင်ႇ" },
            { "sg", "သၼ်ၵူဝ်ႇ" },
            { "si", metaValue_si },
            { "sk", "သလူဝ်ႇဝၵ်ႉ" },
            { "sl", "သလူဝ်ႇဝီးၼီးယႃး" },
            { "sn", "သျူဝ်းၼႃႇ" },
            { "so", "သူဝ်ႇမႃႇလီႇ" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "သဝႃတီ" },
            { "st", "သူဝ်ထူဝ်ႇ ပွတ်းၸၢၼ်း" },
            { "su", "သုၼ်းတၼိတ်ႉသ်" },
            { "sv", "သုၺ်းတိတ်ႉသျ်" },
            { "sw", "သုၺ်ႇႁီးလီႇ" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "တႃၵျိၵ်ႉ" },
            { "th", metaValue_th },
            { "ti", "ထီႇၵရိၼ်းၺႃႇ" },
            { "tk", "ထၢၵ်ႉမႅၼ်ႇ" },
            { "tn", "သဝႃးၼႃႇ" },
            { "to", "ထွင်းၵၼ်ႇ" },
            { "tr", metaValue_TR },
            { "ts", "သွင်းၵႃႇ" },
            { "tt", "ထထႃး" },
            { "ug", "ဝီႇၵႃႇ" },
            { "uk", metaValue_UA },
            { "ur", "ဢူးတူႇ" },
            { "uz", "ဢူးၸပၵ်ႉ" },
            { "ve", "ဝႅၼ်းတႃႇ" },
            { "vi", metaValue_VN },
            { "vo", "ဝေႃးလၽုၵ်း" },
            { "wa", "ဝေႃးလုၼ်း" },
            { "wo", "ဝေႃးလွပ်ႇ" },
            { "xh", "ႁူဝ်းသႃႇ" },
            { "yi", "ယိတ်ႉတိတ်ႉသျ်" },
            { "yo", "ယေႃးရူႇပႃႇ" },
            { "za", "ၸႂၢင်ႈ" },
            { "zh", metaValue_CN },
            { "zu", "ၸူးလူး" },
            { "agq", "ဢၵ်ႉႁဵမ်" },
            { "ann", "ဢူဝ်ႇပူဝ်ႇလူဝ်ႇ" },
            { "apc", "လႄႇဝၼ်ႇတိၼ်း ဢႃႇရၢပ်ႉ" },
            { "arn", "မပူးၶျီႇ" },
            { "asa", "ဢသူး" },
            { "ast", "ဢတိူဝ်ႇရီႇယႅၼ်ႇ" },
            { "bal", "ပလူးၶျီႇ" },
            { "bas", "ပႃးသႃႇ" },
            { "bem", "ပႅမ်ႇပႃႇ" },
            { "bew", "ပႅတ်ႉထဝီႇ" },
            { "bez", "ပႅၼ်းၼႃႈ" },
            { "bgc", "ႁႃႇယၼ်ႇဝီႇ" },
            { "bgn", "ပလူးၶျီႇ ပွတ်းတူၵ်း" },
            { "bho", "ပူဝ်ႉၵျ်ပူႇရီႇ" },
            { "blo", "ဢႃးၼီႈ" },
            { "blt", "တႆးလမ်" },
            { "bqi", "ပၵ်းထီႇဢႃးရီႇ" },
            { "brx", "ပူဝ်တူဝ်" },
            { "bss", "ဢၵ်ႉၶူးသ်" },
            { "bua", "ပိူဝ်းယႅတ်ႇ" },
            { "byn", "ပလိၼ်ႇ" },
            { "cad", "ၶႅတ်ႇတူဝ်း" },
            { "cch", "ဢႅတ်ႉသမ်ႇ" },
            { "ccp", "ၶျၵ်ႉမႃး" },
            { "ceb", "သိုပ်ႇပႂႃးၼူဝ်ႇ" },
            { "cgg", "ၶျီၵႃႇ" },
            { "cho", "ၶျွၵ်ႉတေႃႇ" },
            { "chr", "ၶျေရၵီႇ" },
            { "cic", "ၶျိၵ်ႉၵသေႃး" },
            { "ckb", "ၶိူဝ်းတိတ်ႉသျ် ပွတ်းၵၢင်" },
            { "cop", "ၶွပ်းထိၵ်ႇ" },
            { "csw", "သွမ်ႇပီႇၶရိ" },
            { "dav", "တၢႆးတႃႇ" },
            { "dje", "ၸႃမႃႇ" },
            { "doi", "တွၵ်ႉၵရိပ်ႉ" },
            { "dsb", "လူဝ်းဝႃးသေႃႇပီႇယႅၼ်ႇ" },
            { "dua", "တူးဝႃးလႃႇ" },
            { "dyo", "ၵျူဝ်လႃ-ၾူင်းၼီႇ" },
            { "ebu", "ဢႅမ်းပူး" },
            { "ewo", "ဢဝၢၼ်တူဝ်ႇ" },
            { "fil", metaValue_PH },
            { "frc", "ၾရၢင်ႇသဵတ်ႈ ၶေးၵျုၼ်ႇ" },
            { "frr", "ၾရီႇသီႇယႅၼ်ႇ ပွတ်းႁွင်ႇ" },
            { "fur", "ၾရီႇယူးလီယႅၼ်ႇ" },
            { "gaa", "ၵႃႉ" },
            { "gez", "ၵျီႉသ်" },
            { "gsw", "ၵျႃႇမၼ်ႇသဝိတ်ႉ" },
            { "guz", "ၵတ်ႉသီး" },
            { "haw", "ႁဝၢႆႇယၼ်ႇ" },
            { "hnj", "မင်းၼိဝ်းဝႃႇ" },
            { "hsb", "သေႃးပီးယႅၼ်း ပွတ်းၼိူဝ်" },
            { "jbo", "လူဝ်ၸပႅၼ်ႇ" },
            { "jgo", "ဢၢမ်းၵူမ်ႈပႃႇ" },
            { "jmc", "မၶျၢမ်း" },
            { "kaa", "ၶရႃး-ၶႄႇလ်ၽၵ်ႉ" },
            { "kab", "ၶပၢႆယႂ်ႇ" },
            { "kaj", "ၵျူး" },
            { "kam", "ၶမ်းပႃႇ" },
            { "kcg", "တႃယႅပ်ႉ" },
            { "kde", "မၢၵ်ႈၶွၼ်းတေႇ" },
            { "kea", "ၶပ်ႉပူဝႃႇတီႇယႃႇၼူဝ်ႇ" },
            { "kek", "ၶႅၵ်ႉၶျီႇ" },
            { "ken", "ၶႅၼ်ယင်ႇ" },
            { "kgp", "ၶဵင်းၵင်ႇ" },
            { "khq", "ၶူဝ်းရၶျိၼ်းၼၢႆး" },
            { "kkj", "ၵႃးၵူဝ်ႇ" },
            { "kln", "ၵႄလႅၼ်ႈၵျိၼ်ႇ" },
            { "kok", "ၶွၼ်းၶႃၼီး" },
            { "kpe", "ၽႄႈလႄႈ" },
            { "ksb", "သျမ်ပလႃႇ" },
            { "ksf", "ပဵပ်ႉၾီးယႃး" },
            { "ksh", "ၵူဝ်ႇလူဝ်ၼီယႅၼ်ႇ" },
            { "kxv", "ၵူႇဝီႇ" },
            { "lag", "လႅင်းၵျီႇ" },
            { "lij", "လီႇၵူးရီႇယႅၼ်ႇ" },
            { "lkt", "လၶူဝ်တႃႇ" },
            { "lld", "လႃႇတိၼ်ႇ" },
            { "lmo", "လွမ်းပၢတ်ႉ" },
            { "lou", "လူႇဝီႇသီႇယႃးၼႃးၶရီးဢူဝ်ႇ" },
            { "lrc", "လူႇရီႇ ပွတ်းႁွင်ႇ" },
            { "ltg", "လတ်ႉၵေႇလီႇယႅၼ်ႇ" },
            { "luo", "လူဝ်" },
            { "luy", "လူးယီယႃး" },
            { "lzz", "လၢတ်ႉၸ်" },
            { "mai", "မၢႆႇတီႇလီႇ" },
            { "mas", "မၸၢႆႇ" },
            { "mdf", "မူၵ်ႉသျႃႇ" },
            { "mer", "မေရူႇ" },
            { "mfe", "မူဝ်ရိသျႅၼ်ႇ" },
            { "mgh", "မၵ်ႉၶႂႃး-မီထူဝ်ႇ" },
            { "mgo", "မႅတ်ႉထႃႇ" },
            { "mhn", "မေႃႇၶျီႇၼူဝ်ႇ" },
            { "mic", "မီးၵမႃႇ" },
            { "mni", "မၼိပူႇရ်" },
            { "moh", "မူဝ်ႉႁၢၵ်ႇ" },
            { "mua", "မုၼ်းတင်ႈ" },
            { "mul", "ၽႃႇသႃႇလၢႆလၢႆဢၼ်" },
            { "mus", "မတ်ႉသ်ၶူဝ်းၵီႇ" },
            { "mww", "မင်းတေႃႇ" },
            { "myv", "ဢႄရၸီးယႃး" },
            { "mzn", "မႃၸၼ်တႃရၼ်ၼီႇ" },
            { "nan", "ၶႄႇမိၼ်းၼၢၼ်" },
            { "naq", "ၼႃးမႃႈ" },
            { "nds", "ၵျႃႇမၼ်ႇပွတ်းတႂ်ႈ" },
            { "nmg", "ၶႂႃႇသျိဝ်း" },
            { "nnh", "ဢႅၼ်ၵျႅၼ်းပုၼ်း" },
            { "nqo", "ဢင်းၶူဝ်း" },
            { "nso", "သူဝ်​ထူဝ်ႇ ပွတ်းႁွင်ႇ" },
            { "nus", "ၼူဝ်းဝႃႇ" },
            { "nyn", "ၺၢၼ်ၶေႃးလႄႇ" },
            { "oka", "ဢူဝ်ႇၵႃႇၼႃႇၵၼ်ႇ" },
            { "osa", metaValue_osa },
            { "pap", "ပႃပီယႃမႅၼ်းတူဝ်ႇ" },
            { "pcm", "ၼၢႆႇၵျီးရီးယႅၼ်းၽိတ်ႉၵျိၼ်ႇ" },
            { "pis", "ၽိၵျိၼ်ႇ" },
            { "pms", "ၽိတ်ႉမွၼ်းထိတ်ႉသ်" },
            { "prg", "ၽရတ်ႉသီႇယႅၼ်ႇ" },
            { "quc", "ၶေးသ်ျ" },
            { "raj", "ရၵျသထႃးၼီႇ" },
            { "rhg", "ရူဝ်ႇႁိၼ်ႇၵျႃႇ" },
            { "rif", "ရပ်ႉၾီႇယႅၼ်ႇ" },
            { "rof", "ရွမ်ႇပူဝ်ႇ" },
            { "rwk", "ရဝႃ" },
            { "sah", "ယႃႇၵုတ်ႉ" },
            { "saq", "သႅမ်ပူးရူး" },
            { "sat", "သၼ်ႇတႃႇလီႇ" },
            { "sbp", "သၼ်ၵူး" },
            { "scn", "သီႇသီးလီးယႅၼ်း" },
            { "sdh", "ၶိူဝ်းတိတ်ႉသ်ျ ပွတ်းၸၢၼ်း" },
            { "seh", "သႄၼႃႇ" },
            { "ses", "ၶူဝ်ရႃပူဝ်ႇရူဝ်ႇသႅၼ်ၼီႇ" },
            { "sgs", "သမူဝ်ႇၵျိတ်ႉသျၼ်ႇ" },
            { "shi", "တႃႉၶျႄႇလ်ႁိတ်ႉ" },
            { "shn", "တႆး" },
            { "sid", "သီတႃးမူဝ်း" },
            { "skr", "သရၢႆးၵီႇ" },
            { "sma", "သႃးမီး ပွတ်းၸၢၼ်း" },
            { "smj", "လူးသႅမ်းမီး" },
            { "smn", "ဢိၼ်းၼရီႇသႃးမီး" },
            { "sms", "သၵွတ်ႉသႃးမီး" },
            { "ssy", "သႁူဝ်ႇ" },
            { "suz", "သုၼ်ႇဝႃႇ" },
            { "syr", metaValue_syr },
            { "szl", "သၢႆလီးသီႇယႅၼ်ႇ ပွတ်းတႂ်ႈ" },
            { "teo", "ထႄးသူဝ်ႇ" },
            { "tig", "ထီးၵရီႇ" },
            { "tok", "ထူဝ်ႇၶီႇၽူဝ်းၼႃႇ" },
            { "tpi", "ထွၵ်ႉၽိသိၼ်ႇ" },
            { "trv", "တႃႇရူဝ်ႇၵူဝ်ႇ" },
            { "trw", "ထေႃးဝႃႇလီႇ" },
            { "twq", "ထႅတ်ႉသဝၢၵ်ႉ" },
            { "tyv", "ထူးဝႃႇ" },
            { "tzm", "ဢတ်ႉလႅတ်ႉ ထမၸိတ်ႉ ပွတ်းၵၢင်" },
            { "und", "ဢမ်ႇႁူႉၸၵ်း ၽႃႇသႃႇ" },
            { "vai", metaValue_vai },
            { "vec", "ဝႅၼ်ႇၼီးသျၼ်ႇ" },
            { "vmw", "မၵ်ႉၶႂႃး" },
            { "vun", "ဝၼ်ၵျူဝ်" },
            { "wae", "ဝေႃးသႃႇ" },
            { "wal", "ဝူဝ်လေတႃႇ" },
            { "wbp", "ဝေႃးပီႇရီႇ" },
            { "xnr", "ၵင်ႇၵရီႇ" },
            { "xog", "သူဝ်းၵႃႇ" },
            { "yav", "ယၢင်းပႅၼ်" },
            { "yrl", "ၼိၼ်းၵႃတူႇ" },
            { "yue", "ၶႅၼ်းထူၼ်းၼိတ်ႉသ်" },
            { "zgh", "လၵ်းၸဵင် မူဝ်ရူဝ်ၵၼ်ႇ ထမၸိတ်ႉ" },
            { "zxx", "ဢမ်ႇမီးၶေႃႈၼမ်းၽႃႇသႃႇ" },
            { "Adlm", "ဢတ်ႉလမ်ႇ" },
            { "Aghb", "ၶႃႇၶေးသီးသႅၼ်း ဢႃႇပႃးၼီးယႅၼ်း" },
            { "Ahom", "ဢႃႇႁူမ်ႇ" },
            { "Arab", metaValue_ar },
            { "Aran", "ၼၢတ်ႉတလိၵ်ႉ" },
            { "Armi", "ဢႅမ်ႇပႃႇရႃႇ ဢႃႇရၢမ်ႇ" },
            { "Armn", metaValue_AM },
            { "Avst", "ဢဝႅတ်ႉသတၼ်ႇ" },
            { "Bali", "ပႃႇလီႇ" },
            { "Bamu", "ပမ်မုမ်ႇ" },
            { "Bass", "ပၢတ်ႉသ်သဝႃႇ" },
            { "Batk", "ပႃတၢၵ်ႇ" },
            { "Beng", "ပင်းၵလႃး" },
            { "Berf", "ပီးရီးယႃးဢိူပ်ႉၾ်" },
            { "Bhks", "ပႁၢႆသူၶီႇ" },
            { "Bopo", "ပူဝ်ႇပူဝ်ႇမူဝ်ႇၾူဝ်ႇ" },
            { "Brah", "ပရႃမီႇ" },
            { "Brai", "ပရႄးလ်" },
            { "Bugi", "ပူႇၵီးၼီးၸ်" },
            { "Buhd", "ပူးႁိတ်ႉ" },
            { "Cakm", "ၶျႅၵ်ႉမႃး" },
            { "Cans", "တူဝ်လိၵ်ႈ ၵူၼ်းၶိူဝ်းဢႅပ်ႉပူဝ်းရီႇၵျိၼ်ႇၼႄႇ ၶႅၼ်ႇၼေႇတႃႇ ဢၼ်ႁူမ်ႈၵၼ်ဝႆႉ" },
            { "Cari", "ၶျႃရီယႅၼ်ႇ" },
            { "Cham", "ၶျႅမ်" },
            { "Cher", "ၶျႄးရူဝ်ၵီႇ" },
            { "Chrs", "ၶူဝ်ရသမီးယႅၼ်ႇ" },
            { "Copt", "ၶွပ်းထိၵ်ႉ" },
            { "Cpmn", "သၢႆႉပရူဝ်-မိၼ်ၼူဝ်းဢႅၼ်ႇ" },
            { "Cprt", "သိပ်းပရဵတ်ႉ" },
            { "Cyrl", "သရီးရိၵ်ႉ" },
            { "Cyrs", "သရီးရိၵ်ႉသလႃႇဝူဝ်းၼိၵ်ႉၶျၢတ်ႉၵဝ်ႇ" },
            { "Deva", "တႄဝၼႃးၵရီႇ" },
            { "Diak", "တၢႆႉၾ်ဢၵ်ႉၶူးလူႇ" },
            { "Dogr", "တွၵ်ႉၵရႃႇ" },
            { "Dsrt", "တႅတ်ႉသရႅတ်ႉ" },
            { "Dupl", "လိၵ်ႈပွတ်း တူႇပလူဝ်ႇယၼ်ႇ" },
            { "Egyp", "ႁၢႆးရူဝ်ႇၵလိပ်ႉဢီးၵျိပ်ႈ" },
            { "Elba", "ဢႄႇလ်ပႃႇသၼ်ႇ" },
            { "Elym", "ဢႄးလႃးမိၵ်ႉ" },
            { "Ethi", "ဢီႇတီႇယူဝ်းၽိၵ်ႉ" },
            { "Gara", "ၵႃႇရေး" },
            { "Geor", "​ၵျေႃၵျၼ်ႇၶတ်ႉသူႇရီႇ" },
            { "Glag", "ၵလႃႉၵူဝ်လိတ်ႉထိၵ်ႉ" },
            { "Gong", "ၵုၼ်ၵျႃလႃၵွၼ်းတီႇ" },
            { "Gonm", "မသႃရမ်ႇ ၵွၼ်းတီႇ" },
            { "Goth", "ၵွတ်ႉတိၵ်ႉ" },
            { "Gran", "ၵရၼ်းထ" },
            { "Grek", metaValue_GR },
            { "Gujr", metaValue_gu },
            { "Gukh", "ၵူႇရူင်ႇၶေႇမ" },
            { "Guru", "ၵူရမုၵ်ႉၶီႇ" },
            { "Hanb", "ႁၢၼ် ဢိၵ်ႇတင်း ပူဝ်ႇပူဝ်ႇမူဝ်ႇၾူဝ်ႇ" },
            { "Hang", "ႁင်းၵူးလ်" },
            { "Hani", "ႁၢၼ်" },
            { "Hano", "ႁၼ်ၼုၼ်းဢူး" },
            { "Hans", "ပၢၼ်မႂ်ႇ" },
            { "Hant", "ပၢၼ်ၵဝ်ႇ" },
            { "Hatr", "ႁႅတ်ႉတရၼ်ႇ" },
            { "Hebr", metaValue_he },
            { "Hira", "ႁီးရၵႃးၼႃႇ" },
            { "Hluw", "ႁၢႆးရူဝ်ႇၵလိပ်ႉ ဢႅၼ်ႇၼထူဝ်းလီးယႅၼ်း" },
            { "Hmng", "ပႁၢဝ်ႉၸၢဝ်းမူင်း" },
            { "Hmnp", "ၺႃႇၵဵင်းပႂႃႈၶျူႈၸၢဝ်းမူင်း" },
            { "Hrkt", "တူဝ်လိၵ်ႈ ၵျႃႇပၢၼ်ႇ" },
            { "Hung", "ႁၢင်ႇၵေႇရီႇၵဝ်ႇ" },
            { "Ital", "လိၵ်ႈၵဝ်ႇ" },
            { "Jamo", "ၵျေးမူဝ်" },
            { "Java", "ၵျႃႇဝႃး" },
            { "Jpan", metaValue_JP },
            { "Kali", "ၵယႃးလီ" },
            { "Kana", "ၶႃႇတႃႉၵႃႉၼႃႉ" },
            { "Kawi", "ၵဝီႇ" },
            { "Khar", "ၶရူတ်ႉထိ" },
            { "Khmr", metaValue_km },
            { "Khoj", "ၶုတ်းၸ်ၵီႇ" },
            { "Kits", "တူဝ်လိၵ်ႈဢွၼ်ႇ ၶိတ်ႉတၢၼ်ႇ" },
            { "Knda", "ၶၼ်ၼႃးတႃႇ" },
            { "Kore", metaValue_ko },
            { "Krai", "ၵီႇရတ်ႉရၢႆး" },
            { "Kthi", "ၵၢႆးထီႇ" },
            { "Lana", "လၢၼ်ႉၼႃး" },
            { "Laoo", metaValue_LA },
            { "Latf", "လတိၼ်ႇ ၾရၢၵ်ႇထိူဝ်း" },
            { "Latg", "လတိၼ်ႇ ၵေးလိၵ်ႉ" },
            { "Latn", metaValue_la },
            { "Lepc", "လိပ်ႉၶျႃႇ" },
            { "Limb", "လိမ်ပူး" },
            { "Lina", "ထႅဝ် ဢေႇ" },
            { "Linb", "ထႅဝ် ပီႇ" },
            { "Lisu", "ၾရေးသႃႇ" },
            { "Lyci", "လၢႆႉသီႇယႅၼ်ႇ" },
            { "Lydi", "လၢႆႉတီႇယႅၼ်ႇ" },
            { "Mahj", "မႁႃႇၸၼိ" },
            { "Maka", "မၵၢတ်ႉသႃႇ" },
            { "Mand", "မၼ်တီးယႅၼ်ႇ" },
            { "Mani", "မၼီးၶီးယႅၼ်ႇ" },
            { "Marc", "မႃးၶျႅၼ်ႇ" },
            { "Medf", "မေတေၾႃဢိတရိၼ်" },
            { "Mend", "မႅၼ်ႉတႄ" },
            { "Merc", "မႄႇရူဝ်ႇတိၵ်ႉ ၶႃးသိပ်ႉ" },
            { "Mero", "မႄႇရူဝ်ႇတိၵ်ႉ" },
            { "Mlym", "မလေးယႃးလမ်ႇ" },
            { "Modi", "မူဝ်ႇတီႇ" },
            { "Mong", metaValue_MN },
            { "Mroo", "မရူဝ်ႇ" },
            { "Mtei", "မေးတေးမယႅၵ်ႉ" },
            { "Mult", "မႃတၼ်ၼိ" },
            { "Mymr", "မျၢၼ်ႇမႃႇ" },
            { "Nagm", "ၼၢၵ်ႉမုၼ်ႇတရီႇ" },
            { "Nand", "ၼၼ်တီၼၵရီ" },
            { "Narb", "ဢႃႇရပီးယႅၼ်းႁွင်ႇၵဝ်ႇ" },
            { "Nbat", "ၼပထီးယႅၼ်း" },
            { "Newa", "ၼႄးဝႃႇ" },
            { "Nkoo", "ဢိၼ်းၶူဝ်း" },
            { "Nshu", "ၼူသျူး" },
            { "Ogam", "ဢူဝ်ႇႁမ်ႇ" },
            { "Olck", "ဢူဝ်းၶျိၶီ" },
            { "Onao", "ဢူဝ်ႇလ်ဢူဝ်ႇၼႃႇလ်" },
            { "Orkh", "ဢေႃၶွၼ်ႇ" },
            { "Orya", "ဢူဝ်းတီးယႃႇ" },
            { "Osge", metaValue_osa },
            { "Osma", "ဢေႃသမႅၼ်းၺႃႇ" },
            { "Ougr", "ဝီႇၵႃႇၵဝ်ႇ" },
            { "Palm", "ပႄးလ်မၢႆရႄႇၼီႇ" },
            { "Pauc", "ၽၢဝ်းသိၼ်းႁၢဝ်း" },
            { "Perm", "ပႃႇမိၵ်ႉၶ်ၵဝ်ႇ" },
            { "Phag", "ၽႅၵ်ႉ-ပႃႉ" },
            { "Phli", "လိၵ်ႈႁိၼ် ပႃႇႁလႃႇဝီႇ" },
            { "Phlp", "လိၵ်ႈထမ်း ပႃႇႁလႃႇဝီႇ" },
            { "Phnx", "ၽူဝ်ႇၼီးသီႇယႅၼ်ႇ" },
            { "Plrd", "ၽူဝ်ၼႅတ်ႉထိၵ်ႉ ၽေႃးလၢတ်ႉ" },
            { "Prti", "လိၵ်ႈႁိၼ် ၽၢတ်ႉထီႇယႅၼ်ႇ" },
            { "Qaag", "ၸေႃႇၵျီႇ" },
            { "Rjng", "ရတ်ႉၵျင်ႇ" },
            { "Rohg", "ႁၼ်ၼီၾီး" },
            { "Runr", "ရုၼ်းၼိၵ်ႉ" },
            { "Samr", "သမႃးရိတၼ်ႇ" },
            { "Sarb", "ဢႃႇရပီးယႅၼ်းၸၢၼ်းၵဝ်ႇ" },
            { "Saur", "သေႃရတ်ႉသ်ျထရႃႇ" },
            { "Sgnw", "လွင်ႈတႅမ်ႈပၢႆႉ" },
            { "Shaw", "သျေးပီးယႅၼ်း" },
            { "Shrd", "သျႃရႃးတႃႇ" },
            { "Sidd", "သိတ်ႉတမ်ႇ" },
            { "Sidt", "သၢႆႉတႄးတိၵ်ႉ" },
            { "Sind", "ၶူႇတႃႇဝႃႇတီႇ" },
            { "Sinh", metaValue_si },
            { "Sogd", "သူၵ်ႉတီႇယႅၼ်ႇ" },
            { "Sogo", "သူၵ်ႉတီႇယႅၼ်ႇၵဝ်ႇ" },
            { "Sora", "သူဝ်ႇရႃႇသူမ်ႈပႅင်း" },
            { "Soyo", "သူဝ်ယွမ်ပူဝ်ႇ" },
            { "Sund", "သုၼ်တၼိတ်ႉ" },
            { "Sunu", "သုၼုဝႃႈ" },
            { "Sylo", "သလွတ်ႉတီႇၼႃၵႃးရိ" },
            { "Syrc", metaValue_syr },
            { "Syre", "ဢႅတ်ႉသထရႅၼ်ႇၵျီႇလူဝ်ႇ သီးရီးဢႅၵ်ႉ" },
            { "Syrj", "သီးရီးဢႅၵ်ႉ ပွတ်းတူၵ်း" },
            { "Syrn", "သီးရီးဢႅၵ်ႉ ပွတ်းဢွၵ်ႇ" },
            { "Tagb", "ထႅၵ်ႉပၢၼ်ႇဝႃႇ" },
            { "Takr", "တၵ်ႉၵရီႇ" },
            { "Tale", "တႆးၼိူဝ်" },
            { "Talu", "တႆးလိုဝ်ႉမႂ်ႇ" },
            { "Taml", metaValue_ta },
            { "Tang", "တင်းၵုတ်ႇ" },
            { "Tavt", "တႆးဝႅတ်ႉ" },
            { "Tayo", "တႆးယူဝ်" },
            { "Telu", metaValue_te },
            { "Tfng", "တိၾိၼ်ႇၼႃႇ" },
            { "Tglg", "တၵႃးလွၵ်ႉ" },
            { "Thaa", "ထၢၼ်းၼ" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "တီႇႁူးတႃႇ" },
            { "Tnsa", "ထႅင်းသႃႇ" },
            { "Todr", "တူဝ်ႇထရီႇ" },
            { "Tols", "တူဝ်ႇလူင်သီႇၵီႇ" },
            { "Toto", "ထူဝ်းထူဝ်ႇ" },
            { "Tutg", "တူႇလူႇ-တိၵႃႇလႃႇရီႇ" },
            { "Ugar", "ဢူးၵရိတ်ႈထိၵ်ႉ" },
            { "Vaii", metaValue_vai },
            { "Vith", "ဝိတ်ႉၶူးၶျီႇ" },
            { "Wara", "ဝႃႇရၢင်းၶျိတ်ႉတီႇ" },
            { "Wcho", "ဝၼ်ႉၶျၢဝ်" },
            { "Xpeo", "ပႃႇသျႃးၵဝ်ႇ" },
            { "Xsux", "သူးမီးရူဝ်-ဢၵ်ႉၵႃးတီးယၼ်း ၶိဝ်ႇၼီႇၾွမ်း" },
            { "Yezi", "ယႄးၸီႇတီႇ" },
            { "Yiii", "ယီႈ" },
            { "Zanb", "ၸၼ်ၼပၸႃႇသၵႂႄး" },
            { "Zinh", "သိုပ်ႇယိုၼ်ႈမႃး" },
            { "Zmth", "မၢႆပိူင် ပၢႆးၼပ်ႉ" },
            { "Zsye", "ဢီႇမူဝ်းၵျိ" },
            { "Zsym", "တူဝ်မၢႆ" },
            { "Zxxx", "ဢၼ်ဢမ်ႇတႅမ်ႈဝႆႉ" },
            { "Zyyy", "ဢၼ်ၸႂ်ႉၼမ်" },
            { "Zzzz", "တူဝ်လိၵ်ႈ ဢၼ်ဢမ်ႇႁူႉၸၵ်း" },
            { "de_AT", "ၵျႃႇမၼ်ႇ (ဢေႃးသထရီးယႃး)" },
            { "de_CH", "ၵျႃႇမၼ်ႇ (သဝိတ်ႈၸႃႇလႅၼ်ႇ)" },
            { "en_AU", "ဢိင်းၵလဵတ်ႈ (ဢေႃႉသထရေးလီးယႃး)" },
            { "en_CA", "ဢိင်းၵလဵတ်ႈ (ၶႅၼ်ႇၼေႇတႃႇ)" },
            { "en_GB", "ဢိင်းၵလဵတ်ႈ (မိူင်းႁူမ်ႈတုမ်ႁေႃၶမ်း ပရိတ်ႈတဵၼ်ႇ)" },
            { "en_US", "ဢိင်းၵလဵတ်ႈ (မိူင်းႁူမ်ႈတုမ် ဢမႄႇရိၵ)" },
            { "es_ES", "သပဵၼ် (ယူးရူပ်ႉ)" },
            { "es_MX", "သပဵၼ်ႇ (မႅၵ်ႇသီႇၵူဝ်ႇ)" },
            { "fa_AF", "ပႃႇသျႃး (ဢႃႇၾၵၢၼ်ႇၼီႇသတၢၼ်ႇ)" },
            { "fr_CA", "ၾရၢင်ႇသဵတ်ႈ (ၶႅၼ်ႇၼေႇတႃႇ)" },
            { "fr_CH", "ၾရၢင်ႇသဵတ်ႈ (သဝိတ်ႈၸႃႇလႅၼ်ႇ)" },
            { "nl_BE", "တၢတ်ႉၶျ် (ပႄႇၵျီႇယမ်ႇ)" },
            { "pt_BR", "ပေႃးတူႉၵၢဝ်ႇ ပရႃႇၸီး" },
            { "pt_PT", "ပေႃးတူႉၵၢဝ်ႇ ယူးရူပ်ႉ" },
            { "ro_MD", "ရူဝ်ႇမေးၼီးယႃး (မေႃႇတူဝ်းဝႃး)" },
            { "sw_CD", "သုၺ်ႇႁီးလီႇ (ၶွင်ႇၵူဝ်ႇ - ၶိၼ်သျႃးသႃႇ)" },
            { "%%1901", "လၢႆးတႅမ်ႈလိၵ်ႈၾိင်ႈထုင်းၵျႃႇမၼ်ႇ" },
            { "%%1994", "လိၵ်ႈလၢႆး ရီႇသျႅၼ်ႇ ဢၼ်မီးပိူင်တၢႆ" },
            { "%%1996", "လိၵ်ႈၵျႃႇမၼ်ႇ မိူဝ်ႈပီ 1996" },
            { "ar_001", "လၵ်းၸဵင် ဢႃႇရၢပ်ႈ ပၢၼ်မႂ်ႇ" },
            { "es_419", "သပဵၼ်ႇ လတိၼ်ႇ ဢမႄႇရိၵၢၼ်ႇ" },
            { "key.ca", "ပၵ်းယဵမ်ႈဝၼ်း" },
            { "key.cf", "ပိူင်ၽၢင်ငိုၼ်းတွင်း" },
            { "key.co", "ၸႅၵ်ႇၶပ်ႉ" },
            { "key.cu", "ငိုၼ်းတွင်း" },
            { "key.em", "လွင်ႈၼႄဢီႇမူဝ်းၵျိ" },
            { "key.hc", "တူင်ႇဝူင်းယၢမ်းမူင်း (12 လႄႈ 24)" },
            { "key.lb", "လွင်ႈၶဵင်ႈၶႅင် ၼႂ်းၵၢၼ်တတ်းထႅဝ်လိၵ်ႈ" },
            { "key.lw", "လွင်ႈတတ်းထႅဝ်ၼႂ်းၶေႃႈၵႂၢမ်း" },
            { "key.ms", "ပိူင်ၵၢၼ်တႅၵ်ႈ" },
            { "key.nu", "တူဝ်ၼပ်ႉ" },
            { "key.ss", "တတ်းတူၼ်ႈထႅဝ်လိၵ်ႈဝၢႆးၵႂၢမ်းယေႃႈ" },
            { "nds_NL", "ၵျႃႇမၼ်ႇပွတ်းတႂ်ႈ (ၼႄႇတႃႇလႅၼ်ႇ)" },
            { "%%ALUKU", "ၵႂၢမ်းလၢတ်ႈဢႃႇလူႇၵူႇ" },
            { "%%BARLA", "ၸုမ်းၵႂၢမ်းလၢတ်ႈ ပႃႇလႃႇဝႅၼ်ႇတူဝ်ႇ ၶွင် ၵႃႇပူဝ်ႇဝႃႇတီႇဢႃႇၼူႇ" },
            { "%%BISKE", "ၵႂၢမ်းလၢတ်ႈ ၵျူဝ်းၵျီဢူဝ်/ပီႇလႃႇ" },
            { "%%BOONT", "ပူၼ်းတလိၼ်ႇ" },
            { "%%KKCOR", "လၢႆးတႅမ်ႈလိၵ်ႈ ဢၼ်ၸႂ်ႉတိုဝ်းၼမ်" },
            { "%%KSCOR", "လၵ်းၸဵင် လၢႆးတႅမ်ႈလိၵ်ႈ" },
            { "%%LIPAW", "ၵႂၢမ်းလၢတ်ႈ လီႇပူဝ်ႇဝႃႇၸ် ၶွင် ရီႇသျႅၼ်ႇ" },
            { "%%NEDIS", "ၵႂၢမ်းလၢတ်ႈ ၼႃတီသွၼ်" },
            { "%%NJIVA", "ၵႂၢမ်းလၢတ်ႈ ၼိဝႃႇ/ၵျိဝႃႇ" },
            { "%%NULIK", "ဝူဝ်ႇလႃႇပူၵ်ႉ ၵၢပ်ႈပၢၼ်မႂ်ႇ" },
            { "%%OSOJS", "ၵႂၢမ်းလၢတ်ႈ ဢူဝ်ႇသီးယႃးၵူဝ်ႇ/ဢူဝ်ႇသူဝ်ႇၸႅၼ်ႇ" },
            { "%%POSIX", "ၶွမ်ႇပိဝ်ႇတႃႇ" },
            { "%%RIGIK", "ၶလၢတ်ႉသိၵ်ႉ ဝူဝ်ႇလႃႇပူၵ်ႉ" },
            { "%%ROZAJ", "ရီႇသျႅၼ်ႇ" },
            { "%%SAAHO", "သႃႇႁူဝ်ႇ" },
            { "%%SOLBA", "ၵႂၢမ်းလၢတ်ႈ သတူဝ်းလ်ဝီႇၸႃႇ/သူဝ်ႇလ်ပီႇၵႃႇ" },
            { "%%SOTAV", "ၸုမ်းၵႂၢမ်းလၢတ်ႈ သူဝ်ႇတႃႇဝႅၼ်ႇတူဝ်ႇ ၶွင် ၵႃႇပူႇဝႃႇတီႇဢႃၼူႇ" },
            { "%%UCCOR", "လၢႆးတႅမ်ႈလိၵ်ႈၽွမ်ႉႁူမ်ႈ" },
            { "hi_Latn", "ႁိၼ်ႇတီႇ (လတိၼ်ႇ)" },
            { "zh_Hans", "ၶႄႇ (ပၢၼ်မႂ်ႇ)" },
            { "zh_Hant", "ၶႄႇ (ပၢၼ်ၵဝ်ႇ)" },
            { "%%AO1990", "လိၵ်ႈႁူမ်ႈမၢႆ ၽႃႇသႃႇၵႂၢမ်းလၢတ်ႈ ပေႃးတူႉၵၢဝ်ႇ မိူဝ်ႈပီ 1990" },
            { "%%DAJNKO", "တူဝ်မႄႈလိၵ်ႈ တၢၼ်ၵူဝ်" },
            { "%%EKAVSK", "သႃးပီးယႅၼ်း ဢၼ်မီးသဵင်ဢွၵ်ႇ ဢီႇၵႃႇဝီႇယႅၼ်ႇ" },
            { "%%FONIPA", "ပၢႆးသဵင် IPA" },
            { "%%FONUPA", "ပၢႆးသဵင် UPA" },
            { "%%NDYUKA", "ၵႂၢမ်းလၢတ်ႈ ဢိၼ်ႇတူးၵ" },
            { "%%PAMAKA", "ၵႂၢမ်းလၢတ်ႈပႃႇမၵ" },
            { "%%PINYIN", "ပိၼ်းယိၼ်း ရူဝ်ႇမႅၼ်ႇ" },
            { "%%SCOUSE", "သၵၢဝ်ႉ" },
            { "%%TARASK", "လိၵ်ႈလၢႆး တႃရႃသၵီးဝီႇၵႃႇ" },
            { "%%UCRCOR", "လၢႆးတႅမ်ႈလိၵ်ႈ ဢၼ်ၽွမ်ႉႁူမ်ႈၶိုၼ်းမႄးထတ်းဝႆႉ" },
            { "%%UNIFON", "တူဝ်လိၵ်ႈယူႇၼီႇၾူၼ်းပၢႆးသဵင်" },
            { "%%ABL1943", "ပိူင်ၽွတ်ႇၶွတ်ႈ လွင်ႈတႅမ်ႈလိၵ်ႈ မိူဝ်ႈပီ 1943" },
            { "%%ALALC97", "ALA-LC လွင်ႈႁဵတ်းႁႂ်ႈပဵၼ် ရူဝ်ႇမႅၼ်ႇ မိူဝ်ႈပီ 1997" },
            { "%%BALANKA", "ၵႂၢမ်းလၢတ်ႈ ပႃႇလၼ်ၵႃ ဢၼီႇ" },
            { "%%BOHORIC", "တူဝ်မႄႈလိၵ်ႈ ပူဝ်ႁူဝ်ရိၵ်ႉ" },
            { "%%EMODENG", "ဢိင်းၵလဵတ်ႈပၢၼ်မႂ်ႇမိူဝ်ႈၸဝ်ႉ" },
            { "%%HEPBURN", "ႁႅပ်ႉပၢၼ်ႇ ႁဵတ်းႁႂ်ႈပဵၼ် ရူဝ်ႇမႅၼ်ႇ" },
            { "%%METELKO", "တူဝ်မႄႈလိၵ်ႈ မႅတ်ႉတႄႇလ်ၵူဝ်ႇ" },
            { "%%MONOTON", "သဵင်လဵဝ်" },
            { "%%POLYTON", "ပူဝ်ႇလီတွၼ်းၼိၵ်ႉ" },
            { "%%REVISED", "လၢႆးတႅမ်ႈလိၵ်ႈဢၼ်ၶိုၼ်းမႄးထတ်းဝႆႉ" },
            { "%%1606NICT", "ဝၢႆးလင် ၾရၢင်ႇသဵတ်ႈ ပွတ်းၵၢင် တေႃႇထိုင် 1606" },
            { "%%1694ACAD", "ၾရၢင်ႇသဵတ်ႈပၢၼ်မႂ်ႇမိူဝ်ႈၸဝ်ႉ" },
            { "%%1959ACAD", "ပၢႆးပၺ်ႇၺႃႇ" },
            { "%%BAKU1926", "တူဝ်မႄႈလိၵ်ႈလတိၼ်ႇ တိူဝ်ႇၵီႇၽွမ်ႉႁူမ်ႈ" },
            { "%%COLB1945", "ပၢင်ၵုမ်လူင် ၵၢၼ်တႅမ်ႈလိၵ်ႈ ၽႃႇသႃႇပေႃးတူႉၵၢဝ်ႇ-ပရႃႇၸီး မိူဝ်ႈပီ 1945" },
            { "%%IJEKAVSK", "သႃးပီးယႅၼ်း ဢၼ်မီးသဵင်ဢွၵ်ႇ ဢီႇၸႅၵ်ႉဝီႇယႅၼ်ႇ" },
            { "%%OXENDICT", "လွင်ႈတႅမ်ႈလိၵ်ႈ ပပ်ႉပိုတ်ႇတႅတ်ႈ ဢိင်းၵလဵတ်ႈ ဢွၵ်ႉသ်ၾူတ်ႉ" },
            { "%%SCOTLAND", "ၽႃႇသႃႇဢိင်းၵလဵတ်ႈ ပိူင်သၵွတ်ႉ" },
            { "%%VALENCIA", "ဝႃလႅၼ်သီႇယႅၼ်ႇ" },
            { "%%WADEGILE", "ဝဵတ်ႉ-ၵိဝ်းသ် ရူဝ်ႇမႅၼ်ႇ" },
            { "type.ca.roc", "ပၵ်းယဵမ်ႈဝၼ်းမိင်းၵူႈ" },
            { "type.co.eor", "ပိူင်ၶပ်ႉၸႅၼ်ႇမိူင်းယူးရူပ်ႉ" },
            { "type.hc.h11", "ပိူင်ယၢမ်းမူင်း 12 (0–11)" },
            { "type.hc.h12", "ပိူင်ယၢမ်းမူင်း 12 (1–12)" },
            { "type.hc.h23", "ပိူင်ယၢမ်းမူင်း 24 (0–23)" },
            { "type.hc.h24", "ပိူင်ယၢမ်းမူင်း 24 (1–24)" },
            { "type.nu.ahom", "တူဝ်ၼပ်ႉ ဢႃႇႁူမ်ႇ" },
            { "type.nu.arab", "တူဝ်ၼပ်ႉ ဢႃရပိၵ်ႉ-ဢိၼ်တိၵ်ႉ" },
            { "type.nu.armn", "တူဝ်ၼပ်ႉ ဢႃႇမေးၼီးယႃး" },
            { "type.nu.bali", "တူဝ်ၼပ်ႉ ပႃႇလီႇ" },
            { "type.nu.beng", "တူဝ်ၼပ်ႉ ပင်းၵလႃး" },
            { "type.nu.brah", "တူဝ်ၼပ်ႉ ပရႃမီႇ" },
            { "type.nu.cakm", "တူဝ်ၼပ်ႉ ၶျႅၵ်ႉမႃး" },
            { "type.nu.cham", "တူဝ်ၼပ်ႉ ၶျႅမ်" },
            { "type.nu.cyrl", "တူဝ်ၼပ်ႉ သရီးရိၵ်ႉ" },
            { "type.nu.deva", "တူဝ်ၼပ်ႉ တႄဝၼႃးၵရီႇ" },
            { "type.nu.diak", "တူဝ်ၼပ်ႉ တၢႆႉၾ်ဢၵ်ႉၶူးလူႇ" },
            { "type.nu.ethi", "တူဝ်ၼပ်ႉ ဢီႇတီႇယူဝ်းပီးယႃး" },
            { "type.nu.gara", "တူဝ်ၼပ်ႉ ၵႃႇရေး" },
            { "type.nu.geor", "တူဝ်ၼပ်ႉ ၵျေႃႇၵျႃႇ" },
            { "type.nu.gong", "တူဝ်ၼပ်ႉ ၵုၼ်ၵျႃလႃၵွၼ်းတီႇ" },
            { "type.nu.gonm", "တူဝ်ၼပ်ႉ မသႃရမ်ႇၵွၼ်းတီႇ" },
            { "type.nu.grek", "တူဝ်ၼပ်ႉ ၵရိတ်ႈ" },
            { "type.nu.gujr", "တူဝ်ၼပ်ႉ ၵူးၵျရႃႇတီႇ" },
            { "type.nu.gukh", "တူဝ်ၼပ်ႉ ၵူႇရုင်ႇၶေႇမ" },
            { "type.nu.guru", "တူဝ်ၼပ်ႉ ၵူရမုၵ်ႉၶီႇ" },
            { "type.nu.hans", "တူဝ်ၼပ်ႉ ၶႄႇမႂ်ႇ" },
            { "type.nu.hant", "တူဝ်ၼပ်ႉ ၶႄႇၵဝ်ႇ" },
            { "type.nu.hebr", "တူဝ်ၼပ်ႉ ႁီးပရူး" },
            { "type.nu.hmng", "တူဝ်ၼပ်ႉ ပႃႁႃမူင်း" },
            { "type.nu.hmnp", "တူဝ်ၼပ်ႉ ၺႃႇၵဵင်းပႂႃႈၶျူႈမူင်း" },
            { "type.nu.java", "တူဝ်ၼပ်ႉ ၵျႃႇဝႃး" },
            { "type.nu.jpan", "တူဝ်ၼပ်ႉ ၵျႃႇပၢၼ်ႇ" },
            { "type.nu.kali", "တူဝ်ၼပ်ႉ ၵယႃးလီ" },
            { "type.nu.kawi", "တူဝ်ၼပ်ႉ ၶႃးဝီ" },
            { "type.nu.khmr", "တူဝ်ၼပ်ႉ ၶမဵၼ်" },
            { "type.nu.knda", "တူဝ်ၼပ်ႉ ၶၼ်ၼႃးတႃႇ" },
            { "type.nu.krai", "တူဝ်ၼပ်ႉ ၵီႇရတ်ႉရၢႆး" },
            { "type.nu.lana", "တူဝ်ၼပ်ႉ တႆးထမ်း ႁူဝ်ႇရႃႇ" },
            { "type.nu.laoo", "တူဝ်ၼပ်ႉ လၢဝ်း" },
            { "type.nu.latn", "တူဝ်ၼပ်ႉမိူင်းဝၼ်းတူၵ်း" },
            { "type.nu.lepc", "တူဝ်ၼပ်ႉ လိပ်ႉၶျႃႇ" },
            { "type.nu.limb", "တူဝ်ၼပ်ႉ လိမ်ပူး" },
            { "type.nu.mlym", "တူဝ်ၼပ်ႉ မလေးယႃးလမ်ႇ" },
            { "type.nu.modi", "တူဝ်ၼပ်ႉ မူဝ်ႇတီႇ" },
            { "type.nu.mong", "တူဝ်ၼပ်ႉ မူင်ႇၵူဝ်းလီးယႃး" },
            { "type.nu.mroo", "တူဝ်ၼပ်ႉ မရူဝ်ႇ" },
            { "type.nu.mtei", "တူဝ်ၼပ်ႉ မီး​တီးမယဵၵ်ႇၶ်" },
            { "type.nu.mymr", "တူဝ်ၼပ်ႉမၢၼ်ႈ" },
            { "type.nu.nagm", "တူဝ်ၼပ်ႉ ၼၢၵ်ႉမုၼ်ႇတရီႇ" },
            { "type.nu.nkoo", "တူဝ်ၼပ်ႉ ဢိၼ်းၶူဝ်း" },
            { "type.nu.olck", "တူဝ်ၼပ်ႉ ဢူဝ်းၶျိၶီ" },
            { "type.nu.onao", "တူဝ်ၼပ်ႉ ဢူဝ်ႇလ်ဢူဝ်ႇၼႃႇလ်" },
            { "type.nu.orya", "တူဝ်ၼပ်ႉ ဢူဝ်းတီးယႃႇ" },
            { "type.nu.osma", "တူဝ်ၼပ်ႉ ဢေႃသမႅၼ်းၺႃႇ" },
            { "type.nu.rohg", "တူဝ်ၼပ်ႉ ရူဝ်ႇႁိၼ်ႇၵျႃႇ ႁၼ်ၼီၾီး" },
            { "type.nu.saur", "တူဝ်ၼပ်ႉ သေႃရတ်ႉသ်ျထရႃႇ" },
            { "type.nu.shrd", "တူဝ်ၼပ်ႉ သျႃရႃးတႃႇ" },
            { "type.nu.sind", "တူဝ်ၼပ်ႉ ၶူးတဝႃႇတီႇ" },
            { "type.nu.sinh", "တူဝ်ၼပ်ႉ သိၼ်ႇႁႃႇလႃႇလိတ်ႉ" },
            { "type.nu.sora", "တူဝ်ၼပ်ႉ သူဝ်ႇရႃႇသူမ်ႈပႅင်း" },
            { "type.nu.sund", "တူဝ်ၼပ်ႉ သုၼ်တၼိတ်ႉ" },
            { "type.nu.sunu", "တူဝ်ၼပ်ႉ သုၼုဝႃႇ" },
            { "type.nu.takr", "တူဝ်ၼပ်ႉ တၵ်ႉၵရီႇ" },
            { "type.nu.talu", "တူဝ်ၼပ်ႉ တႆးလိုဝ်ႉ" },
            { "type.nu.taml", "တူဝ်ၼပ်ႉ တမီးလ်ၵဝ်ႇ" },
            { "type.nu.telu", "တူဝ်ၼပ်ႉ ထႄးလူႇၵူႇ" },
            { "type.nu.thai", "တူဝ်ၼပ်ႉ ထႆး" },
            { "type.nu.tibt", "တူဝ်ၼပ်ႉ တိပႅတ်ႉ" },
            { "type.nu.tirh", "တူဝ်ၼပ်ႉ တီႇႁူးတႃႇ" },
            { "type.nu.tnsa", "တူဝ်ၼပ်ႉ ထႅင်းသႃႇ" },
            { "type.nu.tols", "တူဝ်ၼပ်ႉ တူဝ်ႇလူင်သီႇၵီႇ" },
            { "type.nu.vaii", "တူဝ်ၼပ်ႉ ဝၢႆး" },
            { "type.nu.wara", "တူဝ်ၼပ်ႉ ဝႃႇရၢင်းသီႇတီႇ" },
            { "type.nu.wcho", "တူဝ်ၼပ်ႉ ဝၼ်ႉၶျၢဝ်" },
            { "type.ca.dangi", "ပၵ်းယဵမ်ႈဝၼ်း တႅင်းၵီႇ" },
            { "type.co.ducet", "လၵ်းၸဵင် ၸႅၵ်ႇၶပ်ႉ ယူႇၼီႇၶူတ်ႉ" },
            { "type.co.emoji", "ၸႅၵ်ႇၶပ်ႉ ဢီႇမူဝ်းၵျိ" },
            { "type.lb.loose", "လၢႆးတတ်းထႅဝ်လိၵ်ႈ ဝႆႉလူမ်" },
            { "type.nu.roman", "တူဝ်ၼပ်ႉ ရူဝ်ႇမႅၼ်ႇ" },
            { "type.ca.coptic", "ပၵ်းယဵမ်ႈဝၼ်း ၶွပ်ႉတိၵ်ႉ" },
            { "type.ca.hebrew", "ပပ်ႉယဵမ်ႈဝၼ်း ႁီးပရူး" },
            { "type.ca.indian", "ပၵ်းယဵမ်ႈဝၼ်းၸိူဝ်ႉၸၢတ်ႈဢိၼ်းတီးယႃး" },
            { "type.co.compat", "ၸႅၵ်ႇၶပ်ႉ ဢၼ်ပူၼ်ႉမႃး တႃႇႁႂ်ႈမၼ်း ၵိုင်ႇငၢမ်ႇၵၼ်" },
            { "type.co.pinyin", "ၸႅၵ်ႇၶပ်ႉ ပိၼ်းယိၼ်း" },
            { "type.co.search", "ၵၢၼ်ၶူၼ်ႉႁႃ ဢၼ်ၸႂ်ႉတိုဝ်း ၵူႈလွင်ႈလွင်ႈ" },
            { "type.co.stroke", "ၸႅၵ်ႇၶပ်ႉ ႁွႆးမိုဝ်းၸၼ်" },
            { "type.co.unihan", "ၸႅၵ်ႇၶပ်ႉ ႁွႆးမိုဝ်း-ငဝ်ႈပိုၼ်ႉ" },
            { "type.co.zhuyin", "ၸႅၵ်ႇၶပ်ႉ ၸူးယိၼ်း" },
            { "type.lb.normal", "လၢႆးတတ်းထႅဝ်လိၵ်ႈ ပၵတိ" },
            { "type.lb.strict", "လၢႆးတတ်းထႅဝ်လိၵ်ႈ ၶဵင်ႈၶႅင်" },
            { "type.ms.metric", "ပိူင်မႅတ်ႉထရိတ်ႉ" },
            { "type.ca.chinese", "ပၵ်းယဵမ်ႈဝၼ်းၶႄႇ" },
            { "type.ca.islamic", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ" },
            { "type.ca.iso8601", "ပၵ်းယဵမ်ႈဝၼ်း ၵရႅၵ်ႉၵူဝ်ႇရီႇယၼ်ႇ (ပီဢွၼ်တၢင်းသုတ်း)" },
            { "type.ca.persian", "ပၵ်းယဵမ်ႈဝၼ်းပႃႇသျႃး" },
            { "type.cf.account", "ပိူင်ငိုၼ်း ၵၢၼ်ၼပ်ႉသွၼ်ႇ" },
            { "type.nu.arabext", "တူဝ်ၼပ်ႉ ဢႃရပိၵ်ႉ-ဢိၼ်တိၵ်ႉ ဢၼ်ၶႂၢၵ်ႈဝႆႉ" },
            { "type.nu.armnlow", "တူဝ်ၼပ်ႉတူဝ်ဢွၼ်ႇ ဢႃႇမေးၼီးယႃး" },
            { "type.nu.greklow", "တူဝ်ၼပ်ႉတူဝ်ဢွၼ်ႇ ၵရိတ်ႈ" },
            { "type.nu.hanidec", "တူဝ်ၼပ်ႉ ၸုတ်ႉၶႄႇ" },
            { "type.nu.hansfin", "တူဝ်ၼပ်ႉ ၵၢၼ်ငိုၼ်းတွင်း ၶႄႇမႂ်ႇ" },
            { "type.nu.hantfin", "တူဝ်ၼပ်ႉ ၵၢၼ်ငိုၼ်းတွင်း ၶႄႇၵဝ်ႇ" },
            { "type.nu.jpanfin", "တူဝ်ၼပ်ႉ ၵၢၼ်ငိုၼ်းတွင်း ၵျႃႇပၢၼ်ႇ" },
            { "type.nu.mathdbl", "တူဝ်ၼပ်ႉ ပၢႆးၼပ်ႉ ဢၼ်ပႃးသွင်ႁွႆး" },
            { "type.nu.mymrpao", "တူဝ်ၼပ်ႉ ပဢူဝ်း" },
            { "type.nu.tamldec", "တူဝ်ၼပ်ႉ တမီးလ်" },
            { "type.ca.buddhist", "ပၵ်းယဵမ်ႈဝၼ်း ၸၢဝ်းပုတ်ႉထ" },
            { "type.ca.ethiopic", "ပၵ်းယဵမ်ႈဝၼ်း ဢီႇတီႇယူဝ်းပီးယႃး" },
            { "type.ca.japanese", "ပၵ်းယဵမ်ႈဝၼ်းၵျႃႇပၢၼ်ႇ" },
            { "type.cf.standard", "လၵ်းၸဵင် ပိူင်ၽၢင်ငိုၼ်းတွင်း" },
            { "type.co.searchjl", "ၶူၼ်ႉႁႃၸွမ်း တူဝ်မႄႈလိၵ်ႈတႄႇ ႁင်းၵူးလ်" },
            { "type.co.standard", "ၸႅၵ်ႇၶပ်ႉလၵ်းၸဵင်" },
            { "type.ms.uksystem", "ပိူင်ၵၢၼ်တႅၵ်ႈ ဢိမ်ႇၽီးရီးယႄးလ်" },
            { "type.ms.ussystem", "ပိူင်ၵၢၼ်တႅၵ်ႈ ယူႇဢႅတ်ႉသ်" },
            { "type.nu.fullwide", "တူဝ်ၼပ်ႉ တၢင်းၵႂၢင်ႈတဵမ်ထူၼ်ႈ" },
            { "type.nu.lanatham", "တူဝ်ၼပ်ႉ တႆးထမ်း" },
            { "type.nu.mathbold", "တူဝ်ၼပ်ႉ ပၢႆးၼပ်ႉ ဢၼ်ၼႃ" },
            { "type.nu.mathmono", "တူဝ်ၼပ်ႉ ပၢႆးၼပ်ႉ မူဝ်ႇၼူဝ်ႇသပေႉသ်" },
            { "type.nu.mathsanb", "တူဝ်ၼပ်ႉ ပၢႆးၼပ်ႉ သႅၼ်းသႄႇရိပ်ႉ ဢၼ်ၼႃ" },
            { "type.nu.mathsans", "တူဝ်ၼပ်ႉ ပၢႆးၼပ်ႉ သႅၼ်းသႄႇရိပ်ႉ" },
            { "type.nu.mymrepka", "တူဝ်ၼပ်ႉ ယၢင်းပူဝ်း မျၢၼ်ႇမႃႇ ပွတ်းဢွၵ်ႇ" },
            { "type.nu.mymrshan", "တူဝ်ၼပ်ႉတႆး" },
            { "type.nu.mymrtlng", "တူဝ်ၼပ်ႉ တႆးလႅင်" },
            { "type.nu.outlined", "တူဝ်ၼပ်ႉ ဢၢဝ်ႉလၢႆး" },
            { "type.nu.romanlow", "တူဝ်ၼပ်ႉ တူဝ်ဢွၼ်ႇရူဝ်ႇမႅၼ်ႇ" },
            { "type.ca.gregorian", "ပၵ်းယဵမ်ႈဝၼ်း ၵရႅၵ်ႉၵူဝ်ႇရီႇယၼ်ႇ" },
            { "type.co.phonebook", "ၸႅၵ်ႇၶပ်ႉပပ်ႉၽူၼ်း" },
            { "type.co.dictionary", "ၸႅၵ်ႇၶပ်ႉ ပပ်ႉပိုတ်ႇတႅတ်ႈ" },
            { "type.co.traditional", "ၸႅၵ်ႇၶပ်ႉၽိင်ႈထုင်း" },
            { "type.ca.islamic-rgsa", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ (သေႃႇတီႇဢႃႇရေးပီးယႃး၊ လွင်ႈႁၼ်)" },
            { "type.ca.islamic-tbla", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ (လွၵ်းသဵၼ်ႈ၊ ပၢၼ်ပၢႆးလႅင်လၢဝ်)" },
            { "type.ca.islamic-civil", "ပပ်ႉယဵမ်ႈဝၼ်းႁိၸရိ (လွၵ်းသဵၼ်ႈ၊ ပၢၼ်ၵူၼ်းမိူင်း)" },
            { "ListCompositionPattern", "{0}၊ {1}" },
            { "type.ca.islamic-umalqura", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ (ဢုမ်ဢႄလ်ၵူးရႃႇ)" },
            { "type.ca.ethiopic-amete-alem", "ပၵ်းယဵမ်ႈဝၼ်း ဢမိတ်ႉဢလႅမ်း ဢီႇတီႇယူဝ်းပီးယႃး" },
        };
        return data;
    }
}
