/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_uz_Cyrl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Гринвич вақти",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Cook = new String[] {
               "Кук ороллари стандарт вақти",
               "",
               "Кук ороллари ярим ёзги вақти",
               "",
               "Кук ороллари вақти",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба стандарт вақти",
               "CST",
               "Куба кундузги вақти",
               "CDT",
               "Куба вақти",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фижи стандарт вақти",
               "",
               "Фижи ёзги вақти",
               "",
               "Фижи вақти",
               "",
            };
        final String[] Gulf = new String[] {
               "Кўрфаз вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд стандарт вақти",
               "",
               "Ховд ёзги вақти",
               "",
               "Ховд вақти",
               "",
            };
        final String[] Iran = new String[] {
               "Эрон стандарт вақти",
               "",
               "Эрон кундузги вақти",
               "",
               "Эрон вақти",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуе вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск стандарт вақти",
               "",
               "Омск ёзги вақти",
               "",
               "Омск вақти",
               "",
            };
        final String[] Peru = new String[] {
               "Перу стандарт вақти",
               "",
               "Перу ёзги вақти",
               "",
               "Перу вақти",
               "",
            };
        final String[] Truk = new String[] {
               "Чуук вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уэйк ороли вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чили стандарт вақти",
               "",
               "Чили ёзги вақти",
               "",
               "Чили вақти",
               "",
            };
        final String[] China = new String[] {
               "Хитой стандарт вақти",
               "CST",
               "Хитой кундузги вақти",
               "CDT",
               "Хитой вақти",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокос ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дэвис вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ҳиндистон вақти",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Япония стандарт вақти",
               "JST",
               "Япония кундузги вақти",
               "JDT",
               "Япония вақти",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корея стандарт вақти",
               "KST",
               "Корея кундузги вақти",
               "KST",
               "Корея вақти",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа стандарт вақти",
               "SST",
               "Самоа кундузги вақти",
               "SST",
               "Самоа вақти",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Сьова вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга стандарт вақти",
               "",
               "Тонга ёзги вақти",
               "",
               "Тонга вақти",
               "",
            };
        final String[] Alaska = new String[] {
               "Аляска стандарт вақти",
               "AKST",
               "Аляска кундузги вақти",
               "AKDT",
               "Аляска вақти",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонка стандарт вақти",
               "",
               "Амазонка ёзги вақти",
               "",
               "Амазонка вақти",
               "",
            };
        final String[] Azores = new String[] {
               "Азор стандарт вақти",
               "",
               "Азор ёзги вақти",
               "",
               "Азор вақти",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней Даруссалом вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Пасхи ороли стандарт вақти",
               "",
               "Пасхи ороли ёзги вақти",
               "",
               "Пасхи Ороли вақти",
               "",
            };
        final String[] Guyana = new String[] {
               "Гайана вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Гавайи-алеут стандарт вақти",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Исроил стандарт вақти",
               "IST",
               "Исроил кундузги вақти",
               "IDT",
               "Исроил вақти",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косрае вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моувсон вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва стандарт вақти",
               "MSK",
               "Москва ёзги вақти",
               "MSK",
               "Москва вақти",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понапе вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таити вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайпей стандарт вақти",
               "CST",
               "Тайпей кундузги вақти",
               "CDT",
               "Тайпей вақти",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уэллис ва Футуна вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабистон стандарт вақти",
               "",
               "Арабистон кундузги вақти",
               "",
               "Арабистон вақти",
               "",
            };
        final String[] Armenia = new String[] {
               "Арманистон стандарт вақти",
               "",
               "Арманистон ёзги вақти",
               "",
               "Арамнистон вақти",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливия вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатхам стандарт вақти",
               "",
               "Чатхам кундузги вақти",
               "",
               "Чатхам вақти",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадор вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбиер вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузия стандарт вақти",
               "",
               "Грузия ёзги вақти",
               "",
               "Грузия вақти",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутск стандарт вақти",
               "",
               "Иркутск ёзги вақти",
               "",
               "Иркутск вақти",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан стандарт вақти",
               "",
               "Магадан ёзги вақти",
               "",
               "Магадан вақти",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мьянма вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк ороли стандарт вақти",
               "",
               "Норфолк ороли ёзги вақти",
               "",
               "Норфолк ороли вақти",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Норонья стандарт вақти",
               "",
               "Фернандо де Норонья ёзги вақти",
               "",
               "Фернандо де Норонья вақти",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюньон вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломон ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвай стандарт вақти",
               "",
               "Уругвай ёзги вақти",
               "",
               "Уругвай вақти",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату стандарт вақти",
               "",
               "Вануату ёзги вақти",
               "",
               "Вануату вақти",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск стандарт вақти",
               "",
               "Якутск ёзги вақти",
               "",
               "Якутск вақти",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантика стандарт вақти",
               "AST",
               "Атлантика кундузги вақти",
               "AST",
               "Атлантика вақти",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилия стандарт вақти",
               "",
               "Бразилия ёзги вақти",
               "",
               "Бразилия вақти",
               "",
            };
        final String[] Chamorro = new String[] {
               "Каморро вақти",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбия стандарт вақти",
               "",
               "Колумбия ёзги вақти",
               "",
               "Колумбия вақти",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолькленд ороллари стандарт вақти",
               "",
               "Фолькленд ороллари ёзги вақти",
               "",
               "Фолькленд ороллари вақти",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзия вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдив ороллар",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан-Батор стандарт вақти",
               "",
               "Улан-Батор ёзги вақти",
               "",
               "Улан-Батор вақти",
               "",
            };
        final String[] Pakistan = new String[] {
               "Покистон стандарт вақти",
               "PKT",
               "Покистон ёзги вақти",
               "PKST",
               "Покистон вақти",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвай стандарт вақти",
               "",
               "Парагвай ёзги вақти",
               "",
               "Парагвай вақти",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкерн вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина стандарт вақти",
               "",
               "Аргентина ёзги вақти",
               "",
               "Аргентина вақти",
               "",
            };
        final String[] Christmas = new String[] {
               "Рождество ороли вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагос вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Гонконг стандарт вақти",
               "HKT",
               "Гонконг ёзги вақти",
               "HKST",
               "Гонконг вақти",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ҳинд-Хитой вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Қирғизистон вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хове стандарт вақти",
               "",
               "Лорд Хове кундузги вақти",
               "",
               "Лорд Хове вақти",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркезас вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврикий стандарт вақти",
               "",
               "Маврикий ёзги вақти",
               "",
               "Маврикий вақти",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэла вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Озарбайжон стандарт вақти",
               "",
               "Озарбайжон ёзги вақти",
               "",
               "Озарбайжон вақти",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш стандарт вақти",
               "",
               "Бангладеш ёзги вақти",
               "",
               "Бангладеш вақти",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо-Верде стандарт вақти",
               "",
               "Кабо-Верде ёзги вақти",
               "",
               "Кабо-Верде вақти",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Шарқий Тимор вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшел ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Тожикистон вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ўзбекистон стандарт вақти",
               "",
               "Ўзбекистон ёзги вақти",
               "",
               "Ўзбекистон вақти",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афғонистон вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярск стандарт вақти",
               "",
               "Красноярск ёзги вақти",
               "",
               "Красноярск вақти",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Янги Зеландия стандарт вақти",
               "NZST",
               "Янги Зеландия кундузги вақти",
               "NZDT",
               "Янги Зеландия вақти",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Филиппин стандарт вақти",
               "PST",
               "Филиппин ёзги вақти",
               "PDT",
               "Филиппин вақти",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток стандарт вақти",
               "",
               "Владивосток ёзги вақти",
               "",
               "Владивосток вақти",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ҳинд океани вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Лайн ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ньюфаундленд стандарт вақти",
               "NST",
               "Ньюфаундленд кундузги вақти",
               "NDT",
               "Ньюфаундленд вақти",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркманистон стандарт вақти",
               "",
               "Туркманистон ёзги вақти",
               "",
               "Туркманистон вақти",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Француз Гвианаси вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Янги Каледония стандарт вақти",
               "",
               "Янги Каледония ёзги вақти",
               "",
               "Янги Каледония вақти",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Жанубий Джорджия вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбург стандарт вақти",
               "",
               "Екатеринбург ёзги вақти",
               "",
               "Екатеринбург вақти",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Марказий Африка вақти",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Шарқий Африка вақти",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ғарбий Африка вақти",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Думонт-д-Урвил вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Марказий Европа стандарт вақти",
               "CET",
               "Марказий Европа ёзги вақти",
               "CEST",
               "Марказий Европа вақти",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Шарқий Европа стандарт вақти",
               "EET",
               "Шарқий Европа ёзги вақти",
               "EEST",
               "Шарқий Европа вақти",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ғарбий Европа стандарт вақти",
               "WET",
               "Ғарбий Европа ёзги вақти",
               "WEST",
               "Ғарбий Европа вақти",
               "WET",
            };
        final String[] Africa_Southern = new String[] {
               "Жанубий Африка вақти",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Шимолий Америка марказий стандарт вақти",
               "CST",
               "Шимолий Америка марказий кундузги вақти",
               "CDT",
               "Шимолий Америка",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Шимолий Америка шарқий стандарт вақти",
               "EST",
               "Шимолий Америка шарқий кундузги вақти",
               "EST",
               "Шимолий Америка шарқий вақти",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Шимолий Америка тинч океани стандарт вақти",
               "PST",
               "Шимолий Америка тинч океани кундузги вақти",
               "PDT",
               "Шимолий Америка тинч океани вақти",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Француз жанубий ва Антарктика вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилберт ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайи-алеут стандарт вақти",
               "HST",
               "Гавайи-алеут кундузги вақти",
               "HDT",
               "Гавайи-алеут вақти",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сент-Пьер ва Микелон стандарт вақти",
               "",
               "Сент-Пьер ва Микелон кундузги вақти",
               "",
               "Сент-Пьер ва Микелон вақти",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Шимолий Америка тоғ стандарт вақти",
               "MST",
               "Шимолий Америка тоғ кундузги вақти",
               "MST",
               "Шимолий Америка тоғ вақти",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалл ороллари вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа-Янги Гвинея вақти",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Марказий Австралия стандарт вақти",
               "ACST",
               "Марказий Австралия кундузги вақти",
               "ACDT",
               "Марказий Австралия вақти",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Шарқий Австралия стандарт вақти",
               "AEST",
               "Шарқий Австралия кундузги вақти",
               "AEDT",
               "Шарқий Австралия вақти",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ғарбий Австралия стандарт вақти",
               "AWST",
               "Ғарбий Австралия кундузги вақти",
               "AWDT",
               "Ғарбий Австралия вақти",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Марказий Индонезия вақти",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Шарқий Индонезия вақти",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ғарбий Индонезия вақти",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Марказий Австралия Ғарбий стандарт вақти",
               "",
               "Марказий Австралия Ғарбий кундузги вақти",
               "",
               "Марказий Австралия Ғарбий вақти",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Ирландия ёзги вақти",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Ирландия ёзги вақти",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Гринвич вақти",
                    "GMT",
                    "Британия ёзги вақти",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Номаълум" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Lower_Princes", "Lower Princeʼs Quarter" },
        };
        return data;
    }
}
