/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Àkókò Àfẹnukò Apia",
               "",
               "Àkókò Ojúmọmọ Apia",
               "",
               "Àkókò Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Àkókò Àfẹnukò Àwọn Erekusu Kuuku",
               "",
               "Àkókò Ilaji Sọma Àwọn Erekusu Kuuku",
               "",
               "Àkókò Àwọn Erekusu Kuuku",
               "",
            };
        final String[] Cuba = new String[] {
               "Àkókò Àfẹnukò Kúbà",
               "CST",
               "Àkókò Ojúmọmọ Kúbà",
               "CDT",
               "Àkókò Kúbà",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Àkókò Àfẹnukò Fiji",
               "",
               "Àkókò Sọma Fiji",
               "",
               "Àkókò Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Àkókò Àfẹnukò Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Àkókò Ìfẹnukòsí Hofidi",
               "",
               "Àkókò Sọmà Hofidi",
               "",
               "Àkókò Hofidi",
               "",
            };
        final String[] Iran = new String[] {
               "Àkókò Àfẹnukò Irani",
               "",
               "Àkókò Ojúmọmọ Irani",
               "",
               "Àkókò Irani",
               "",
            };
        final String[] Niue = new String[] {
               "Àkókò Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Àkókò Àfẹnukò Omisiki",
               "",
               "Àkókò Sọmà Omisiki",
               "",
               "Àkókò Omisiki",
               "",
            };
        final String[] Peru = new String[] {
               "Àkókò Àfẹnukò Pérù",
               "",
               "Àkókò Ooru Pérù",
               "",
               "Àkókò Pérù",
               "",
            };
        final String[] Truk = new String[] {
               "Àkókò Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Àkókò Erékùsù Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Àkókò Àfẹnukò Ṣílè",
               "",
               "Àkókò Oru Ṣílè",
               "",
               "Àkókò Ṣílè",
               "",
            };
        final String[] China = new String[] {
               "Àkókò Ìfẹnukòsí Ṣáínà",
               "CST",
               "Àkókò Ojúmọmọ Ṣáínà",
               "CDT",
               "Àkókò Ṣáínà",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Àkókò Àwọn Erékùsù Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Àkókò Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Àkókò Àfẹnukò India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Àkókò Ìfẹnukòsí Japan",
               "JST",
               "Àkókò Sọmà Japan",
               "JDT",
               "Àkókò Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Àkókò Ìfẹnukòsí Koria",
               "KST",
               "Àkókò Ojúmọmọ Koria",
               "KST",
               "Àkókò Koria",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Àkókò Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Àkókò Nepali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Àkókò Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Àkókò Àfẹnukò Samoa",
               "SST",
               "Àkókò Ojúmọmọ Samoa",
               "SST",
               "Àkókò Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Àkókò Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Àkókò Àfẹnukò Tonga",
               "",
               "Àkókò Sọmà Tonga",
               "",
               "Àkókò Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Àkókò Yúkọ́nì",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Àkókò Àfẹnukò Alásíkà",
               "AKST",
               "Àkókò Ojúmọ́ Alásíkà",
               "AKDT",
               "Àkókò Alásíkà",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Àkókò Afẹnukò Amásọ́nì",
               "",
               "Àkókò Oru Amásọ́nì",
               "",
               "Àkókò Amásọ́nì",
               "",
            };
        final String[] Azores = new String[] {
               "Àkókò Àfẹnukò Ásọ́sì",
               "",
               "Àkókò Ooru Ásọ́sì",
               "",
               "Àkókò Ásọ́sì",
               "",
            };
        final String[] Bhutan = new String[] {
               "Àkókò Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Aago àsìkò Easter Island",
               "",
               "Aago Soma Easter Island",
               "",
               "Aago Ajnde Ibùgbé Omi",
               "",
            };
        final String[] Guyana = new String[] {
               "Àkókò Gúyànà",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Àkókò Àfẹnukò Israel",
               "IST",
               "Àkókò Ojúmọmọ Israel",
               "IDT",
               "Àkókò Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Àkókò Kosirai",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Àkókò Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Àkókò Àfẹnukò Mosiko",
               "MSK",
               "Àkókò Sọmà Mosiko",
               "MSK",
               "Àkókò Mosiko",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Àkókò Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Àkókò Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Àkókò Ìfẹnukòsí Taipei",
               "CST",
               "Àkókò Ojúmọmọ Taipei",
               "CDT",
               "Àkókò Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Àkókò Tufalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Àkókò Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Àkókò Wallis & Futuina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Àkókò Àfẹnukò Arabia",
               "",
               "Àkókò Ojúmọmọ Arabia",
               "",
               "Àkókò Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Àkókò Àfẹnukò Armenia",
               "",
               "Àkókò Sọmà Arabia",
               "",
               "Àkókò Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Aago Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Àkókò Àfẹnukò Chatam",
               "",
               "Àkókò Ojúmọmọ Chatam",
               "",
               "Àkókò Chatam",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Àpapọ̀ Àkókò Àgbáyé",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Aago Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Àkókò Gambia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Àkókò Àfẹnukò Georgia",
               "",
               "Àkókò Sọmà Georgia",
               "",
               "Àkókò Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Àkókò Àfẹnukò Íkósíkì",
               "",
               "Àkókò Sọmà Íkúsíkì",
               "",
               "Àkókò Íkósíkì",
               "",
            };
        final String[] Magadan = new String[] {
               "Àkókò Àfẹnukò Magadani",
               "",
               "Àkókò Sọmà Magadani",
               "",
               "Àkókò Magadani",
               "",
            };
        final String[] Myanmar = new String[] {
               "Àkókò Ìlà Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Àkókò Àfẹnukò Erékùsù Norfolk",
               "",
               "Àkókò Ojúmọmọ Erékùsù Norfolk",
               "",
               "Àkókò Erékùsù Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Aago àsìkò Fenando de Norona",
               "",
               "Aago Soma Fernando de Noronha",
               "",
               "Aago Fenando de Norona",
               "",
            };
        final String[] Reunion = new String[] {
               "Àkókò Rẹ́yúníọ́nì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Àkókò Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Àkókò Àwọn Erekusu Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Àkókò Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Àkókò Àfẹnukò Úrúgúwè",
               "",
               "Aago Soma Uruguay",
               "",
               "Aago Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Àkókò Àfẹnukò Fanuatu",
               "",
               "Àkókò Sọmà Fanuatu",
               "",
               "Àkókò Fanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Àkókò Àfẹnukò Yatutsk",
               "",
               "Àkókò Sọmà Yatutsk",
               "",
               "Àkókò Yatutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Àkókò àsikò Àtìláńtíìkì",
               "AST",
               "Àkókò Ìyálẹta Àtìláńtíìkì",
               "AST",
               "Àkókò Àtìláńtíìkì",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Aago àsìkò Bùràsílíà",
               "",
               "Aago Soma Brasilia",
               "",
               "Aago Bùràsílíà",
               "",
            };
        final String[] Chamorro = new String[] {
               "Àkókò Àfẹnukò Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Aago àsìkò Kolombia",
               "",
               "Aago Soma Colombia",
               "",
               "Aago Kolombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Àkókò Àfẹnukò Etíkun Fókílándì",
               "",
               "Àkókò Ooru Etíkun Fókílándì",
               "",
               "Àkókò Fókílándì",
               "",
            };
        final String[] Malaysia = new String[] {
               "Àkókò Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Àkókò Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Àkókò Ìfẹnukòsí Ulaanbaatar",
               "",
               "Àkókò Sọmà Ulaanbaatar",
               "",
               "Àkókò Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Àkókò Àfẹnukò Pakistani",
               "PKT",
               "Àkókò Sọmà Pakistani",
               "PKST",
               "Àkókò Pakistani",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Àkókò Àfẹnukò Párágúwè",
               "",
               "Àkókò Ooru Párágúwè",
               "",
               "Àkókò Párágúwè",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Àkókò Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Àkókò Àfẹnukò Sakhalin",
               "",
               "Àkókò Sọmà Sakhalin",
               "",
               "Àkókò Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Àkókò Súrínámù",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Aago àsìkò Argentina",
               "",
               "Aago Soma Argentina",
               "",
               "Aago Ajẹntìnà",
               "",
            };
        final String[] Christmas = new String[] {
               "Àkókò Erékùsù Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Aago Galapago",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Àkókò Ìfẹnukòsí Hong Kong",
               "HKT",
               "Àkókò Sọmà Hong Kong",
               "HKST",
               "Àkókò Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Àkókò Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Àkókò Kirigisitaani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Àkókò Àfẹnukò Lord Howe",
               "",
               "Àkókò Ojúmọmọ Lord Howe",
               "",
               "Àkókò Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Àkókò Makuesasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Àkókò Àfẹnukò Máríṣúṣì",
               "",
               "Àkókò Ooru Máríṣúṣì",
               "",
               "Àkókò Máríṣúṣì",
               "",
            };
        final String[] Singapore = new String[] {
               "Àkókò Àfẹnukò Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Aago Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Àkókò Àfẹnukò Foligogiradi",
               "MSK",
               "Àkókò Sọmà Foligogiradi",
               "MSK",
               "Àkókò Foligogiradi",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Àkókò Àfẹnukò Azerbaijan",
               "",
               "Àkókò Sọmà Azerbaijan",
               "",
               "Àkókò Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Àkókò Àfẹnukò Bangladesh",
               "",
               "Àkókò Sọmà Bangladesh",
               "",
               "Àkókò Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Àkókò Àfẹnukò Képú Fáàdì",
               "",
               "Àkókò Ẹ̀rún Képú Fáàdì",
               "",
               "Àkókò Képú Fáàdì",
               "",
            };
        final String[] East_Timor = new String[] {
               "Àkókò Ìlà oorùn Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Aago Kasasitáànì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Àkókò Sèṣẹ́ẹ̀lì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Àkókò Tajikisitaani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Àkókò Àfẹnukò Usibekistani",
               "",
               "Àkókò Sọmà Usibekistani",
               "",
               "Àkókò Usibekistani",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Àkókò Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Àkókò Àfẹnukò Krasinoyasiki",
               "",
               "Àkókò Sọmà Krasinoyasiki",
               "",
               "Àkókò Krasinoyasiki",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Àkókò Àfẹnukò New zealand",
               "NZST",
               "Àkókò Ojúmọmọ New Zealand",
               "NZDT",
               "Àkókò New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Àkókò Àfẹnukò Nofosibiriki",
               "",
               "Àkókò Sọmà Noforibisiki",
               "",
               "Àkókò Nofosibiriski",
               "",
            };
        final String[] Philippines = new String[] {
               "Àkókò Àfẹnukò Filipininni",
               "PST",
               "Àkókò Sọmà Filipininni",
               "PDT",
               "Àkókò Filipininni",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Àkókò Àfẹnukò Filadifositoki",
               "",
               "Àkókò Sọmà Filadifositoki",
               "",
               "Àkókò Filadifositoki",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Àkókò Etíkun Índíà",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Àkókò Àwọn Erekusu Laini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Àkókò Àfẹnukò Newfoundland",
               "NST",
               "Àkókò Ojúmọmọ Newfoundland",
               "NDT",
               "Àkókò Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Àkókò Àfẹnukò Turkimenistani",
               "",
               "Àkókò Sọmà Turkmenistani",
               "",
               "Àkókò Turkimenistani",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Àkókò Gúyánà Fáránsè",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Àkókò Àfẹnukò Kalidonia Tuntun",
               "",
               "Àkókò Sọma Kalidonia Tuntun",
               "",
               "Àkókò Kalidonia Tuntun",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Àkókò Gúsù Jọ́jíà",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Àkókò Àfẹnukò Yekaterinburg",
               "",
               "Àkókò Sọmà Yekaterinburg",
               "",
               "Àkókò Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Àkókò Àárín Afírikà",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Àkókò Ìlà-Oòrùn Afírikà",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Àkókò Ìwọ̀-Oòrùn Àfẹnukò Afírikà",
               "WAT",
               "Àkókò Ìwọ̀-Oòrùn Ooru Afírikà",
               "WAT",
               "Àkókò Ìwọ̀-Oòrùn Afírikà",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Àkókò Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Àkókò Àárin àsikò Europe",
               "CET",
               "Àkókò Àárin Sọmà Europe",
               "CEST",
               "Àkókò Àárin Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Àkókò àsikò Ìhà Ìlà Oòrùn Europe",
               "EET",
               "Àkókò Sọmà Ìha Ìlà Oòrùn Europe",
               "EEST",
               "Àkókò Ìhà Ìlà Oòrùn Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Àkókò àsikò Ìwọ Oòrùn Europe",
               "WET",
               "Àkókò Sọmà Ìhà Ìwọ Oòrùn Europe",
               "WEST",
               "Àkókò Ìwọ Oòrùn Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Àkókò Àfẹnukò Pásífíìkì Mẹ́síkò",
               "MST",
               "Àkókò Ojúmọmọ Pásífíìkì Mẹ́síkò",
               "MDT",
               "Àkókò Pásífíìkì Mẹ́ṣíkò",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "àkókò asiko àárín gbùngbùn",
               "CST",
               "Akókò àárín gbùngbùn ojúmọmọ",
               "CDT",
               "àkókò àárín gbùngbùn",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Akókò Àsikò Ìha Ìla Oòrùn",
               "EST",
               "Àkókò ojúmọmọ Ìhà Ìlà Oòrun",
               "EST",
               "Àkókò ìhà ìlà oòrùn",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Àkókò àsikò Pàsífíìkì",
               "PST",
               "Àkókò Ìyálẹta Pàsífíìkì",
               "PDT",
               "Àkókò Pàsífíìkì",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Àkókò Gúsù Fáransé àti Àntátíìkì",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Àkókò Àwọn Erekusu Gilibati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Àkókò Àfẹnukò Hawaii-Aleutian",
               "HST",
               "Àkókò Ojúmọmọ Hawaii-Aleutian",
               "HST",
               "Àkókò Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Àkókò Àwọn Erékùsù Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Àkókò Àfẹnukò Pierre & Miquelon",
               "",
               "Àkókò Ojúmọmọ Pierre & Miquelon",
               "",
               "Àkókò Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Àkókò asiko òkè",
               "MST",
               "Àkókò ojúmọmọ Ori-òkè",
               "MST",
               "Àkókò òkè",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Àkókò Àwọn Erekusu Masaali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Àkókò Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Àkókò Àfẹnukò Ààrin Gùngùn Australia",
               "ACST",
               "Àkókò Ojúmọmọ Ààrin Gùngùn Australia",
               "ACDT",
               "Àkókò Ààrin Gùngùn Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Àkókò Àfẹnukò Ìlà-Oòrùn Australia",
               "AEST",
               "Àkókò Ojúmọmọ Ìlà-Oòrùn Australia",
               "AEDT",
               "Àkókò Ìlà-Oòrùn Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Àkókò Àfẹnukò Ìwọ̀-Oòrùn Australia",
               "AWST",
               "Àkókò Ojúmọmọ Ìwọ̀-Oòrùn Australia",
               "AWDT",
               "Àkókò Ìwọ̀-Oòrùn Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Àkókò Ààrin Gbùngbùn Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Àkókò Ìlà oorùn Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Àkókò Ìwọ̀ oorùn Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Àkókò Àfẹnukò Ààrin Gùngùn Ìwọ̀-Oòrùn Australia",
               "",
               "Àkókò Ojúmọmọ Ààrin Gùngùn Ìwọ̀-Oòrùn Australia",
               "",
               "Àkókò Ààrin Gùngùn Ìwọ̀-Oòrùn Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Àfẹnukò Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Àpapọ̀ Àkókò Àgbáyé",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Àfẹnukò Airiisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Àkókò Sọmà Gẹẹsi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "Ilu Ho Chi Minh" },
            { "timezone.excity.Etc/Unknown", "Ìlú Àìmọ̀" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.America/Adak", "ìlú Adákì" },
            { "timezone.excity.America/Nome", "ìlú Nomi" },
            { "timezone.excity.America/Aruba", "ìlú Arúbá" },
            { "timezone.excity.America/Boise", "ìlú Bọ́isè" },
            { "timezone.excity.America/Sitka", "ìlú Sika" },
            { "timezone.excity.America/Thule", "ìlú Tulè" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "ìlú Bẹ̀líìsì" },
            { "timezone.excity.America/Cancun", "ìlú Kancun" },
            { "timezone.excity.America/Cayman", "ilú Kayman" },
            { "timezone.excity.America/Dawson", "ìlú Dawson" },
            { "timezone.excity.America/Denver", "ìlú Denver" },
            { "timezone.excity.America/Havana", "ìlú Havana" },
            { "timezone.excity.America/Inuvik", "ìlú Inuvik" },
            { "timezone.excity.America/Juneau", "ìlú Junu" },
            { "timezone.excity.America/Merida", "ìlú Merida" },
            { "timezone.excity.America/Nassau", "ìlú Nasaò" },
            { "timezone.excity.America/Panama", "ìlú Panama" },
            { "timezone.excity.America/Regina", "ìlú Regina" },
            { "timezone.excity.America/Antigua", "ìlú Antígùà" },
            { "timezone.excity.America/Chicago", "ìlú Chicago" },
            { "timezone.excity.America/Creston", "ìlú Kírẹstọ́ọ̀nù" },
            { "timezone.excity.America/Curacao", "ìlú Kuraṣao" },
            { "timezone.excity.America/Detroit", "ìlú Detroit" },
            { "timezone.excity.America/Godthab", "ìlú Nuuk" },
            { "timezone.excity.America/Grenada", "ìlú Grenada" },
            { "timezone.excity.America/Halifax", "ìlú Halifásì" },
            { "timezone.excity.America/Iqaluit", "ìlú Iqaluit" },
            { "timezone.excity.America/Jamaica", "ìlú Jamaikà" },
            { "timezone.excity.America/Managua", "ìlú Managua" },
            { "timezone.excity.America/Marigot", "ìlú Marigọ́ọ̀tì" },
            { "timezone.excity.America/Moncton", "ìlú Montoni" },
            { "timezone.excity.America/Ojinaga", "ìlú Ojinaga" },
            { "timezone.excity.America/Phoenix", "ìlú Fínísì" },
            { "timezone.excity.America/Tijuana", "ìlú Tíjúana" },
            { "timezone.excity.America/Toronto", "ìlú Toronto" },
            { "timezone.excity.America/Tortola", "ìlú Totola" },
            { "timezone.excity.America/Yakutat", "ìlú Yakuta" },
            { "timezone.excity.America/Anguilla", "ìlú Angúílà" },
            { "timezone.excity.America/Barbados", "ìlú Bábádọ́ọ̀sì" },
            { "timezone.excity.America/Dominica", "ìlú Dominika" },
            { "timezone.excity.America/Edmonton", "ìlú Edmonton" },
            { "timezone.excity.America/Mazatlan", "ìlú Masatiani" },
            { "timezone.excity.America/Miquelon", "ìlú Mikulọ́nì" },
            { "timezone.excity.America/New_York", "ìlú New York" },
            { "timezone.excity.America/Resolute", "ìlú Resolútì" },
            { "timezone.excity.America/St_Johns", "ìlú St Jọ́ọ̀nù" },
            { "timezone.excity.America/St_Kitts", "ìlú St kitisì" },
            { "timezone.excity.America/St_Lucia", "ìlú St Lusia" },
            { "timezone.excity.America/Winnipeg", "ìlú Winipegì" },
            { "timezone.excity.Atlantic/Bermuda", "ìlú Bẹ̀múdà" },
            { "timezone.excity.America/Anchorage", "ìlú Ankọ́réèjì" },
            { "timezone.excity.America/Chihuahua", "ìlú Ṣihuahua" },
            { "timezone.excity.America/Glace_Bay", "ìlú omi Glace" },
            { "timezone.excity.America/Goose_Bay", "ìlú omi Goosù" },
            { "timezone.excity.America/Guatemala", "ìlú Guatemala" },
            { "timezone.excity.America/Matamoros", "ìlú Matamorosì" },
            { "timezone.excity.America/Menominee", "ìlú Menominì" },
            { "timezone.excity.America/Monterrey", "ìlú Monteri" },
            { "timezone.excity.America/St_Thomas", "ìlú St Tọ́màsì" },
            { "timezone.excity.America/Vancouver", "ìlú Vankuva" },
            { "timezone.excity.America/Costa_Rica", "ìlú Kosta Ríkà" },
            { "timezone.excity.America/Grand_Turk", "ìlú Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "ìlú Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "ìlú Hermosilo" },
            { "timezone.excity.America/Kralendijk", "ìlú Kíralẹ́ndáikì" },
            { "timezone.excity.America/Louisville", "ìlú Lúífíìlì" },
            { "timezone.excity.America/Martinique", "ìlú Mátíníkì" },
            { "timezone.excity.America/Metlakatla", "ìlú Metilakatila" },
            { "timezone.excity.America/Montserrat", "ìlú Monseratì" },
            { "timezone.excity.America/St_Vincent", "ìlú Finsentì" },
            { "timezone.excity.America/Whitehorse", "ìlú Whitehosì" },
            { "timezone.excity.America/El_Salvador", "ìlú El Savador" },
            { "timezone.excity.America/Fort_Nelson", "ìlú Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "ìlú Los Angeles" },
            { "timezone.excity.America/Mexico_City", "ìlú Mẹ́síkò" },
            { "timezone.excity.America/Puerto_Rico", "ìlú Puerto Riko" },
            { "timezone.excity.America/Tegucigalpa", "ìlú Tegusigapà" },
            { "timezone.excity.America/Blanc-Sablon", "ìlú Blank Sabulọ́ọ̀nì" },
            { "timezone.excity.America/Danmarkshavn", "ìlú Banmarkshan" },
            { "timezone.excity.America/Dawson_Creek", "ìlú Dawson Creek" },
            { "timezone.excity.America/Indiana/Knox", "ìlú nọ́sì" },
            { "timezone.excity.America/Indianapolis", "ìlú Indianapolis" },
            { "timezone.excity.America/Rankin_Inlet", "ìlú Rankin Inlet" },
            { "timezone.excity.America/Scoresbysund", "ìlú Itokotomiti" },
            { "timezone.excity.America/Cambridge_Bay", "ìlú òkun kambíríìjì" },
            { "timezone.excity.America/Coral_Harbour", "ìlú àtikọkàn" },
            { "timezone.excity.America/Indiana/Vevay", "ìlú Vevay" },
            { "timezone.excity.America/Lower_Princes", "ìlú Lower Prince’s Quarter" },
            { "timezone.excity.America/Port_of_Spain", "ìlú etí omi Sípéènì" },
            { "timezone.excity.America/Santo_Domingo", "ìlú Santo Domigo" },
            { "timezone.excity.America/St_Barthelemy", "ìlú Batilemì" },
            { "timezone.excity.America/Swift_Current", "ìlú Súfítù Kọ̀rentì" },
            { "timezone.excity.America/Bahia_Banderas", "ìlú Báhì Bándẹ́rásì" },
            { "timezone.excity.America/Port-au-Prince", "ìlú Port-au-Prince" },
            { "timezone.excity.America/Indiana/Marengo", "ìlú Marẹ́ngo" },
            { "timezone.excity.America/Indiana/Winamac", "ìlú Winamak ní Indiana" },
            { "timezone.excity.America/Indiana/Tell_City", "ìlú Tell City" },
            { "timezone.excity.America/Indiana/Vincennes", "ìlú Vincennes ní Indiana" },
            { "timezone.excity.America/Indiana/Petersburg", "ìlú Petersburg" },
            { "timezone.excity.America/Kentucky/Monticello", "ìlú Montisẹ́lò" },
            { "timezone.excity.America/North_Dakota/Beulah", "ìlú Beulà ní North Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "ìlú Senta North Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ìlú New Salem ni North Dakota" },
        };
        return data;
    }
}
