/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_is extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_cop = "koptíska";
        final String metaValue_gu = "gújaratí";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kannada";
        final String metaValue_te = "telúgú";
        final Object[][] data = new Object[][] {
            { "001", "Heimurinn" },
            { "002", "Afríka" },
            { "003", "Norður-Ameríka" },
            { "005", "Suður-Ameríka" },
            { "009", "Eyjaálfa" },
            { "011", "Vestur-Afríka" },
            { "013", "Mið-Ameríka" },
            { "014", "Austur-Afríka" },
            { "015", "Norður-Afríka" },
            { "017", "Mið-Afríka" },
            { "018", "Suðurhluti Afríku" },
            { "019", "Ameríka" },
            { "021", "Ameríka norðan Mexíkó" },
            { "029", "Karíbahafið" },
            { "030", "Austur-Asía" },
            { "034", "Suður-Asía" },
            { "035", "Suðaustur-Asía" },
            { "039", "Suður-Evrópa" },
            { "053", "Ástralasía" },
            { "054", "Melanesía" },
            { "057", "Míkrónesíusvæðið" },
            { "061", "Pólýnesía" },
            { "142", "Asía" },
            { "143", "Mið-Asía" },
            { "145", "Vestur-Asía" },
            { "150", "Evrópa" },
            { "151", "Austur-Evrópa" },
            { "154", "Norður-Evrópa" },
            { "155", "Vestur-Evrópa" },
            { "202", "Afríka sunnan Sahara" },
            { "419", "Rómanska Ameríka" },
            { "AC", "Ascension-eyja" },
            { "AD", "Andorra" },
            { "AE", "Sameinuðu arabísku furstadæmin" },
            { "AF", "Afganistan" },
            { "AG", "Antígva og Barbúda" },
            { "AI", "Angvilla" },
            { "AL", "Albanía" },
            { "AM", "Armenía" },
            { "AO", "Angóla" },
            { "AQ", "Suðurskautslandið" },
            { "AR", "Argentína" },
            { "AS", "Bandaríska Samóa" },
            { "AT", "Austurríki" },
            { "AU", "Ástralía" },
            { "AW", "Arúba" },
            { "AX", "Álandseyjar" },
            { "AZ", "Aserbaídsjan" },
            { "BA", "Bosnía og Hersegóvína" },
            { "BB", "Barbados" },
            { "BD", "Bangladess" },
            { "BE", "Belgía" },
            { "BF", "Búrkína Fasó" },
            { "BG", "Búlgaría" },
            { "BH", "Barein" },
            { "BI", "Búrúndí" },
            { "BJ", "Benín" },
            { "BL", "Sankti Bartólómeusareyjar" },
            { "BM", "Bermúdaeyjar" },
            { "BN", "Brúnei" },
            { "BO", "Bólivía" },
            { "BQ", "Karíbahafshluti Hollands" },
            { "BR", "Brasilía" },
            { "BS", "Bahamaeyjar" },
            { "BT", "Bútan" },
            { "BV", "Bouveteyja" },
            { "BW", "Botsvana" },
            { "BY", "Hvíta-Rússland" },
            { "BZ", "Belís" },
            { "CA", "Kanada" },
            { "CC", "Kókoseyjar (Keeling)" },
            { "CD", "Kongó-Kinshasa" },
            { "CF", "Mið-Afríkulýðveldið" },
            { "CG", "Kongó-Brazzaville" },
            { "CH", "Sviss" },
            { "CI", "Fílabeinsströndin" },
            { "CK", "Cooks-eyjar" },
            { "CL", "Síle" },
            { "CM", "Kamerún" },
            { "CN", "Kína" },
            { "CO", "Kólumbía" },
            { "CP", "Clipperton-eyja" },
            { "CR", "Kostaríka" },
            { "CU", "Kúba" },
            { "CV", "Grænhöfðaeyjar" },
            { "CW", "Curacao" },
            { "CX", "Jólaey" },
            { "CY", "Kýpur" },
            { "CZ", "Tékkland" },
            { "DE", "Þýskaland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djíbútí" },
            { "DK", "Danmörk" },
            { "DM", "Dóminíka" },
            { "DO", "Dóminíska lýðveldið" },
            { "DZ", "Alsír" },
            { "EA", "Ceuta og Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Eistland" },
            { "EG", "Egyptaland" },
            { "EH", "Vestur-Sahara" },
            { "ER", "Erítrea" },
            { "ES", "Spánn" },
            { "ET", "Eþíópía" },
            { "EU", "Evrópusambandið" },
            { "EZ", "Evrusvæðið" },
            { "FI", "Finnland" },
            { "FJ", "Fídjíeyjar" },
            { "FK", "Falklandseyjar" },
            { "FM", "Míkrónesía" },
            { "FO", "Færeyjar" },
            { "FR", "Frakkland" },
            { "GA", "Gabon" },
            { "GB", "Bretland" },
            { "GD", "Grenada" },
            { "GE", "Georgía" },
            { "GF", "Franska Gvæjana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gíbraltar" },
            { "GL", "Grænland" },
            { "GM", "Gambía" },
            { "GN", "Gínea" },
            { "GP", "Gvadelúpeyjar" },
            { "GQ", "Miðbaugs-Gínea" },
            { "GR", "Grikkland" },
            { "GS", "Suður-Georgía og Suður-Sandvíkureyjar" },
            { "GT", "Gvatemala" },
            { "GU", "Gvam" },
            { "GW", "Gínea-Bissá" },
            { "GY", "Gvæjana" },
            { "HK", "sérstjórnarsvæðið Hong Kong" },
            { "HM", "Heard og McDonaldseyjar" },
            { "HN", "Hondúras" },
            { "HR", "Króatía" },
            { "HT", "Haítí" },
            { "HU", "Ungverjaland" },
            { "IC", "Kanaríeyjar" },
            { "ID", "Indónesía" },
            { "IE", "Írland" },
            { "IL", "Ísrael" },
            { "IM", "Mön" },
            { "IN", "Indland" },
            { "IO", "Bresku Indlandshafseyjar" },
            { "IQ", "Írak" },
            { "IR", "Íran" },
            { "IS", "Ísland" },
            { "IT", "Ítalía" },
            { "JE", "Jersey" },
            { "JM", "Jamaíka" },
            { "JO", "Jórdanía" },
            { "JP", "Japan" },
            { "KE", "Kenía" },
            { "KG", "Kirgistan" },
            { "KH", "Kambódía" },
            { "KI", "Kíribatí" },
            { "KM", "Kómoreyjar" },
            { "KN", "Sankti Kitts og Nevis" },
            { "KP", "Norður-Kórea" },
            { "KR", "Suður-Kórea" },
            { "KW", "Kúveit" },
            { "KY", "Caymaneyjar" },
            { "KZ", "Kasakstan" },
            { "LA", "Laos" },
            { "LB", "Líbanon" },
            { "LC", "Sankti Lúsía" },
            { "LI", "Liechtenstein" },
            { "LK", "Srí Lanka" },
            { "LR", "Líbería" },
            { "LS", "Lesótó" },
            { "LT", "Litháen" },
            { "LU", "Lúxemborg" },
            { "LV", "Lettland" },
            { "LY", "Líbía" },
            { "MA", "Marokkó" },
            { "MC", "Mónakó" },
            { "MD", "Moldóva" },
            { "ME", "Svartfjallaland" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleyjar" },
            { "MK", "Norður-Makedónía" },
            { "ML", "Malí" },
            { "MM", "Mjanmar (Búrma)" },
            { "MN", "Mongólía" },
            { "MO", "sérstjórnarsvæðið Makaó" },
            { "MP", "Norður-Maríanaeyjar" },
            { "MQ", "Martiník" },
            { "MR", "Máritanía" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Máritíus" },
            { "MV", "Maldíveyjar" },
            { "MW", "Malaví" },
            { "MX", "Mexíkó" },
            { "MY", "Malasía" },
            { "MZ", "Mósambík" },
            { "NA", "Namibía" },
            { "NC", "Nýja-Kaledónía" },
            { "NE", "Níger" },
            { "NF", "Norfolkeyja" },
            { "NG", "Nígería" },
            { "NI", "Níkaragva" },
            { "NL", "Holland" },
            { "NO", "Noregur" },
            { "NP", "Nepal" },
            { "NR", "Nárú" },
            { "NU", "Niue" },
            { "NZ", "Nýja-Sjáland" },
            { "OM", "Óman" },
            { "PA", "Panama" },
            { "PE", "Perú" },
            { "PF", "Franska Pólýnesía" },
            { "PG", "Papúa Nýja-Gínea" },
            { "PH", "Filippseyjar" },
            { "PK", "Pakistan" },
            { "PL", "Pólland" },
            { "PM", "Sankti Pierre og Miquelon" },
            { "PN", "Pitcairn-eyjar" },
            { "PR", "Púertó Ríkó" },
            { "PS", "Heimastjórnarsvæði Palestínumanna" },
            { "PT", "Portúgal" },
            { "PW", "Palá" },
            { "PY", "Paragvæ" },
            { "QA", "Katar" },
            { "QO", "Ytri Eyjaálfa" },
            { "RE", "Réunion" },
            { "RO", "Rúmenía" },
            { "RS", "Serbía" },
            { "RU", "Rússland" },
            { "RW", "Rúanda" },
            { "SA", "Sádi-Arabía" },
            { "SB", "Salómonseyjar" },
            { "SC", "Seychelles-eyjar" },
            { "SD", "Súdan" },
            { "SE", "Svíþjóð" },
            { "SG", "Singapúr" },
            { "SH", "Sankti Helena" },
            { "SI", "Slóvenía" },
            { "SJ", "Svalbarði og Jan Mayen" },
            { "SK", "Slóvakía" },
            { "SL", "Síerra Leóne" },
            { "SM", "San Marínó" },
            { "SN", "Senegal" },
            { "SO", "Sómalía" },
            { "SR", "Súrínam" },
            { "SS", "Suður-Súdan" },
            { "ST", "Saó Tóme og Prinsípe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sýrland" },
            { "SZ", "Esvatíní" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicoseyjar" },
            { "TD", "Tsjad" },
            { "TF", "Frönsku suðlægu landsvæðin" },
            { "TG", "Tógó" },
            { "TH", "Taíland" },
            { "TJ", "Tadsíkistan" },
            { "TK", "Tókelá" },
            { "TL", "Tímor-Leste" },
            { "TM", "Túrkmenistan" },
            { "TN", "Túnis" },
            { "TO", "Tonga" },
            { "TR", "Tyrkland" },
            { "TT", "Trínidad og Tóbagó" },
            { "TV", "Túvalú" },
            { "TW", "Taívan" },
            { "TZ", "Tansanía" },
            { "UA", "Úkraína" },
            { "UG", "Úganda" },
            { "UM", "Smáeyjar Bandaríkjanna" },
            { "UN", "Sameinuðu þjóðirnar" },
            { "US", "Bandaríkin" },
            { "UY", "Úrúgvæ" },
            { "UZ", "Úsbekistan" },
            { "VA", "Vatíkanið" },
            { "VC", "Sankti Vinsent og Grenadíneyjar" },
            { "VE", "Venesúela" },
            { "VG", "Bresku Jómfrúaeyjar" },
            { "VI", "Bandarísku Jómfrúaeyjar" },
            { "VN", "Víetnam" },
            { "VU", "Vanúatú" },
            { "WF", "Wallis- og Fútúnaeyjar" },
            { "WS", "Samóa" },
            { "XA", "gervihreimur" },
            { "XB", "gervistaður" },
            { "XK", "Kósóvó" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Suður-Afríka" },
            { "ZM", "Sambía" },
            { "ZW", "Simbabve" },
            { "ZZ", "Óþekkt svæði" },
            { "aa", "afár" },
            { "ab", "abkasíska" },
            { "ae", "avestíska" },
            { "af", "afríkanska" },
            { "ak", "akan" },
            { "am", "amharíska" },
            { "an", "aragonska" },
            { "ar", "arabíska" },
            { "as", "assamska" },
            { "av", "avaríska" },
            { "ay", "aímara" },
            { "az", "aserska" },
            { "ba", "baskír" },
            { "be", "hvítrússneska" },
            { "bg", "búlgarska" },
            { "bi", "bíslama" },
            { "bm", "bambara" },
            { "bn", "bengalska" },
            { "bo", "tíbeska" },
            { "br", "bretónska" },
            { "bs", "bosníska" },
            { "ca", "katalónska" },
            { "ce", "tsjetsjenska" },
            { "ch", "kamorró" },
            { "co", "korsíska" },
            { "cr", "krí" },
            { "cs", "tékkneska" },
            { "cu", "kirkjuslavneska" },
            { "cv", "sjúvas" },
            { "cy", "velska" },
            { "da", "danska" },
            { "de", "þýska" },
            { "dv", "dívehí" },
            { "dz", "dsongka" },
            { "ee", "ewe" },
            { "el", "gríska" },
            { "en", "enska" },
            { "eo", "esperantó" },
            { "es", "spænska" },
            { "et", "eistneska" },
            { "eu", "baskneska" },
            { "fa", "persneska" },
            { "ff", "fúla" },
            { "fi", "finnska" },
            { "fj", "fídjeyska" },
            { "fo", "færeyska" },
            { "fr", "franska" },
            { "fy", "vesturfrísneska" },
            { "ga", "írska" },
            { "gd", "skosk gelíska" },
            { "gl", "galisíska" },
            { "gn", "gvaraní" },
            { "gu", metaValue_gu },
            { "gv", "manska" },
            { "ha", "hása" },
            { "he", "hebreska" },
            { "hi", "hindí" },
            { "ho", "hírímótú" },
            { "hr", "króatíska" },
            { "ht", "haítíska" },
            { "hu", "ungverska" },
            { "hy", "armenska" },
            { "hz", "hereró" },
            { "ia", "interlingua" },
            { "id", "indónesíska" },
            { "ie", "interlingve" },
            { "ig", "ígbó" },
            { "ii", "sísúanjí" },
            { "ik", "ínúpíak" },
            { "io", "ídó" },
            { "is", "íslenska" },
            { "it", "ítalska" },
            { "iu", "inúktitút" },
            { "ja", "japanska" },
            { "jv", "javanska" },
            { "ka", "georgíska" },
            { "kg", "kongóska" },
            { "ki", "kíkújú" },
            { "kj", "kúanjama" },
            { "kk", "kasakska" },
            { "kl", "grænlenska" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "kóreska" },
            { "kr", "kanúrí" },
            { "ks", "kasmírska" },
            { "ku", "kúrdíska" },
            { "kv", "komíska" },
            { "kw", "kornbreska" },
            { "ky", "kirgiska" },
            { "la", "latína" },
            { "lb", "lúxemborgíska" },
            { "lg", "ganda" },
            { "li", "limbúrgíska" },
            { "ln", "lingala" },
            { "lo", "laó" },
            { "lt", "litháíska" },
            { "lu", "lúbakatanga" },
            { "lv", "lettneska" },
            { "mg", "malagasíska" },
            { "mh", "marshallska" },
            { "mi", "maorí" },
            { "mk", "makedónska" },
            { "ml", "malajalam" },
            { "mn", "mongólska" },
            { "mr", "maratí" },
            { "ms", "malaíska" },
            { "mt", "maltneska" },
            { "my", "búrmneska" },
            { "na", "nárúska" },
            { "nb", "norskt bókmál" },
            { "nd", "norður-ndebele" },
            { "ne", "nepalska" },
            { "ng", "ndonga" },
            { "nl", "hollenska" },
            { "nn", "nýnorska" },
            { "no", "norska" },
            { "nr", "suðurndebele" },
            { "nv", "navahó" },
            { "ny", "nýanja" },
            { "oc", "oksítaníska" },
            { "oj", "ojibva" },
            { "om", "oromo" },
            { "or", "óría" },
            { "os", "ossetíska" },
            { "pa", "púnjabí" },
            { "pi", "palí" },
            { "pl", "pólska" },
            { "ps", "pastú" },
            { "pt", "portúgalska" },
            { "qu", "kvesjúa" },
            { "rm", "rómanska" },
            { "rn", "rúndí" },
            { "ro", "rúmenska" },
            { "ru", "rússneska" },
            { "rw", "kínjarvanda" },
            { "sa", "sanskrít" },
            { "sc", "sardínska" },
            { "sd", "sindí" },
            { "se", "norðursamíska" },
            { "sg", "sangó" },
            { "sh", "serbókróatíska" },
            { "si", "singalíska" },
            { "sk", "slóvakíska" },
            { "sl", "slóvenska" },
            { "sm", "samóska" },
            { "sn", "shona" },
            { "so", "sómalska" },
            { "sq", "albanska" },
            { "sr", "serbneska" },
            { "ss", "svatí" },
            { "st", "suðursótó" },
            { "su", "súndanska" },
            { "sv", "sænska" },
            { "sw", "svahílí" },
            { "ta", "tamílska" },
            { "te", metaValue_te },
            { "tg", "tadsjikska" },
            { "th", "taílenska" },
            { "ti", "tígrinja" },
            { "tk", "túrkmenska" },
            { "tl", "tagalog" },
            { "tn", "tsúana" },
            { "to", "tongverska" },
            { "tr", "tyrkneska" },
            { "ts", "tsonga" },
            { "tt", "tatarska" },
            { "tw", "tví" },
            { "ty", "tahítíska" },
            { "ug", "úígúr" },
            { "uk", "úkraínska" },
            { "ur", "úrdú" },
            { "uz", "úsbekska" },
            { "ve", "venda" },
            { "vi", "víetnamska" },
            { "vo", "volapyk" },
            { "wa", "vallónska" },
            { "wo", "volof" },
            { "xh", "sósa" },
            { "yi", "jiddíska" },
            { "yo", "jórúba" },
            { "za", "súang" },
            { "zh", "kínverska" },
            { "zu", "súlú" },
            { "ace", "akkíska" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adýge" },
            { "afh", "afríhílí" },
            { "agq", "aghem" },
            { "ain", "aínu (Japan)" },
            { "akk", "akkadíska" },
            { "ale", "aleúska" },
            { "alt", "suðuraltaíska" },
            { "ang", "fornenska" },
            { "ann", "obolo" },
            { "anp", "angíka" },
            { "arc", "arameíska" },
            { "arn", "mapuche" },
            { "arp", "arapahó" },
            { "ars", "najdi-arabíska" },
            { "arw", "aravakska" },
            { "asa", "asu" },
            { "ast", "astúríska" },
            { "atj", "atikamekw" },
            { "awa", "avadí" },
            { "bal", "balúkí" },
            { "ban", "balíska" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanví" },
            { "bgn", "vesturbalotsí" },
            { "bho", "bojpúrí" },
            { "bik", "bíkol" },
            { "bin", "bíní" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braí" },
            { "brx", "bódó" },
            { "bss", "bakossi" },
            { "bua", "búríat" },
            { "bug", "búgíska" },
            { "byn", "blín" },
            { "cad", "kaddó" },
            { "car", "karíbamál" },
            { "cay", "kajúga" },
            { "cch", "atsam" },
            { "ccp", "tsjakma" },
            { "ceb", "kebúanó" },
            { "cgg", "kíga" },
            { "chb", "síbsja" },
            { "chg", "sjagataí" },
            { "chk", "sjúkíska" },
            { "chm", "marí" },
            { "chn", "sínúk" },
            { "cho", "sjoktá" },
            { "chp", "sípevíska" },
            { "chr", "Cherokee-mál" },
            { "chy", "sjeyen" },
            { "ckb", "miðkúrdíska" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "krímtyrkneska" },
            { "crj", "suðaustur-cree" },
            { "crk", "nehiyawak" },
            { "crl", "norðaustur-cree" },
            { "crm", "moose cree" },
            { "crr", "Karólínu-algonkvínska" },
            { "crs", "seychelles-kreólska" },
            { "csb", "kasúbíska" },
            { "csw", "maskekon" },
            { "dak", "dakóta" },
            { "dar", "dargva" },
            { "dav", "taíta" },
            { "del", "delaver" },
            { "den", "slavneska" },
            { "dgr", "dogríb" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogrí" },
            { "dsb", "lágsorbneska" },
            { "dua", "dúala" },
            { "dum", "miðhollenska" },
            { "dyo", "jola-fonyi" },
            { "dyu", "djúla" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efík" },
            { "egy", "fornegypska" },
            { "eka", "ekajúk" },
            { "elx", "elamít" },
            { "enm", "miðenska" },
            { "ewo", "evondó" },
            { "fan", "fang" },
            { "fat", "fantí" },
            { "fil", "filippseyska" },
            { "fon", "fón" },
            { "frc", "cajun-franska" },
            { "frm", "miðfranska" },
            { "fro", "fornfranska" },
            { "frr", "norðurfrísneska" },
            { "frs", "austurfrísneska" },
            { "fur", "fríúlska" },
            { "gaa", "ga" },
            { "gag", "gagás" },
            { "gan", "gan" },
            { "gay", "gajó" },
            { "gba", "gbaja" },
            { "gez", "gís" },
            { "gil", "gilberska" },
            { "gmh", "miðháþýska" },
            { "goh", "fornháþýska" },
            { "gon", "gondí" },
            { "gor", "gorontaló" },
            { "got", "gotneska" },
            { "grb", "gerbó" },
            { "grc", "forngríska" },
            { "gsw", "svissnesk þýska" },
            { "guz", "gusii" },
            { "gwi", "gvísín" },
            { "hai", "haída" },
            { "haw", "havaíska" },
            { "hax", "suður-haída" },
            { "hil", "híligaínon" },
            { "hit", "hettitíska" },
            { "hmn", "hmong" },
            { "hsb", "hásorbneska" },
            { "hup", "húpa" },
            { "hur", "halkomelem" },
            { "iba", "íban" },
            { "ibb", "ibibio" },
            { "ikt", "vestur-kanadískt inúktitút" },
            { "ilo", "ílokó" },
            { "inh", "ingús" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "masjáme" },
            { "jpr", "gyðingapersneska" },
            { "jrb", "gyðingaarabíska" },
            { "kaa", "karakalpak" },
            { "kab", "kabíle" },
            { "kac", "kasín" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kaví" },
            { "kbd", "kabardíska" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "grænhöfðeyska" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kasí" },
            { "kho", "kotaska" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbúndú" },
            { "koi", "kómí-permyak" },
            { "kok", "konkaní" },
            { "kos", "kosraska" },
            { "kpe", "kpelle" },
            { "krc", "karasaíbalkar" },
            { "krl", "karélska" },
            { "kru", "kúrúk" },
            { "ksb", "sjambala" },
            { "ksf", "bafía" },
            { "ksh", "kölníska" },
            { "kum", "kúmík" },
            { "kut", "kútenaí" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kúví" },
            { "lad", "ladínska" },
            { "lag", "langí" },
            { "lah", "landa" },
            { "lam", "lamba" },
            { "lez", "lesgíska" },
            { "lij", "lígúríska" },
            { "lil", "lillooet" },
            { "lkt", "lakóta" },
            { "lmo", "lombardíska" },
            { "lol", "mongó" },
            { "lou", "kreólska (Louisiana)" },
            { "loz", "lozi" },
            { "lrc", "norðurlúrí" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "lúisenó" },
            { "lun", "lúnda" },
            { "luo", "lúó" },
            { "lus", "lúsaí" },
            { "luy", "luyia" },
            { "mad", "madúrska" },
            { "mag", "magahí" },
            { "mai", "maítílí" },
            { "mak", "makasar" },
            { "man", "mandingó" },
            { "mas", "masaí" },
            { "mdf", "moksa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "merú" },
            { "mfe", "máritíska" },
            { "mga", "miðírska" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "mikmak" },
            { "min", "mínangkabá" },
            { "mnc", "mansjú" },
            { "mni", "manípúrí" },
            { "moe", "innu-aimun" },
            { "moh", "móhíska" },
            { "mos", "mossí" },
            { "mua", "mundang" },
            { "mul", "mörg tungumál" },
            { "mus", "krík" },
            { "mwl", "mirandesíska" },
            { "mwr", "marvarí" },
            { "myv", "ersja" },
            { "mzn", "masanderaní" },
            { "nap", "napólíska" },
            { "naq", "nama" },
            { "nds", "lágþýska; lágsaxneska" },
            { "new", "nevarí" },
            { "nia", "nías" },
            { "niu", "níveska" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nógaí" },
            { "non", "norræna" },
            { "nqo", "n’ko" },
            { "nso", "norðursótó" },
            { "nus", "núer" },
            { "nwc", "klassísk nevaríska" },
            { "nym", "njamvesí" },
            { "nyn", "nyankole" },
            { "nyo", "njóró" },
            { "nzi", "nsíma" },
            { "ojb", "norðvestur-ojibwa" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "vestur-ojibwa" },
            { "oka", "okanagan" },
            { "osa", "ósage" },
            { "ota", "tyrkneska, ottóman" },
            { "pag", "pangasínmál" },
            { "pal", "palaví" },
            { "pam", "pampanga" },
            { "pap", "papíamentó" },
            { "pau", "paláska" },
            { "pcm", "nígerískt pidgin" },
            { "peo", "fornpersneska" },
            { "phn", "fönikíska" },
            { "pis", "pijin" },
            { "pon", "ponpeiska" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prússneska" },
            { "pro", "fornpróvensalska" },
            { "quc", "kiche" },
            { "raj", "rajastaní" },
            { "rap", "rapanúí" },
            { "rar", "rarótongska" },
            { "rhg", "rohingja" },
            { "rof", "rombó" },
            { "rom", "romaní" },
            { "rup", "arúmenska" },
            { "rwk", "rúa" },
            { "sad", "sandave" },
            { "sah", "jakút" },
            { "sam", "samversk arameíska" },
            { "saq", "sambúrú" },
            { "sas", "sasak" },
            { "sat", "santalí" },
            { "sba", "ngambay" },
            { "sbp", "sangú" },
            { "scn", "sikileyska" },
            { "sco", "skoska" },
            { "sdh", "suðurkúrdíska" },
            { "seh", "sena" },
            { "sel", "selkúp" },
            { "ses", "koíraboró-senní" },
            { "sga", "fornírska" },
            { "shi", "tachelhit" },
            { "shn", "sjan" },
            { "sid", "sídamó" },
            { "slh", "suður-lushootseed" },
            { "sma", "suðursamíska" },
            { "smj", "lúlesamíska" },
            { "smn", "enaresamíska" },
            { "sms", "skoltesamíska" },
            { "snk", "sóninke" },
            { "sog", "sogdíen" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "Straits-salisíanska" },
            { "suk", "súkúma" },
            { "sus", "súsú" },
            { "sux", "súmerska" },
            { "swb", "shimaoríska" },
            { "syc", "klassísk sýrlenska" },
            { "syr", "sýrlenska" },
            { "szl", "slesíska" },
            { "tce", "suður-tutchone" },
            { "tem", "tímne" },
            { "teo", "tesó" },
            { "ter", "terenó" },
            { "tet", "tetúm" },
            { "tgx", "tagíska" },
            { "tht", "tahltan" },
            { "tig", "tígre" },
            { "tiv", "tív" },
            { "tkl", "tókeláska" },
            { "tlh", "klingonska" },
            { "tli", "tlingit" },
            { "tmh", "tamasjek" },
            { "tog", "tongverska (nyasa)" },
            { "tok", "toki pona" },
            { "tpi", "tokpisin" },
            { "trv", "tarókó" },
            { "tsi", "tsimsíska" },
            { "ttm", "norður-tutchone" },
            { "tum", "túmbúka" },
            { "tvl", "túvalúska" },
            { "twq", "tasawaq" },
            { "tyv", "túvínska" },
            { "tzm", "tamazight" },
            { "udm", "údmúrt" },
            { "uga", "úgarítíska" },
            { "umb", "úmbúndú" },
            { "und", "óþekkt tungumál" },
            { "vai", "vaí" },
            { "vec", "feneyska" },
            { "vmw", "makúva" },
            { "vot", "votíska" },
            { "vun", "vunjó" },
            { "wae", "valser" },
            { "wal", "volayatta" },
            { "war", "varaí" },
            { "was", "vasjó" },
            { "wbp", "varlpiri" },
            { "wuu", "wu-kínverska" },
            { "xal", "kalmúkska" },
            { "xnr", "kangrí" },
            { "xog", "sóga" },
            { "yao", "jaó" },
            { "yap", "japíska" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantónska" },
            { "zap", "sapótek" },
            { "zbl", "blisstákn" },
            { "zen", "senaga" },
            { "zgh", "staðlað marokkóskt tamazight" },
            { "zun", "súní" },
            { "zxx", "ekkert tungumálaefni" },
            { "zza", "zázáíska" },
            { "Adlm", "adlam" },
            { "Arab", "arabískt" },
            { "Aran", "nastaliq" },
            { "Armn", "armenskt" },
            { "Bali", "balinesíska" },
            { "Batk", "batakíska" },
            { "Beng", "bengalskt" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmíska" },
            { "Brai", "blindraletur" },
            { "Cakm", "chakma" },
            { "Cans", "samræmt kanadískt samstöfuletur frumbyggja" },
            { "Cher", "cherokí" },
            { "Copt", metaValue_cop },
            { "Cyrl", "kyrillískt" },
            { "Deva", "devanagari" },
            { "Ethi", "eþíópískt" },
            { "Geor", "georgískt" },
            { "Grek", "grískt" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "kínverskt" },
            { "Hans", "einfaldað" },
            { "Hant", "hefðbundið" },
            { "Hebr", "hebreskt" },
            { "Hira", "hiragana" },
            { "Hrkt", "japönsk samstöfuletur" },
            { "Jamo", "jamo" },
            { "Java", "javanesíska" },
            { "Jpan", "japanskt" },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "kóreskt" },
            { "Laoo", "lao" },
            { "Latn", "latneskt" },
            { "Mand", "mandaíska" },
            { "Mlym", "malalajam" },
            { "Mong", "mongólskt" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "mjanmarskt" },
            { "Nkoo", "n-kó" },
            { "Olck", "ol chiki" },
            { "Orya", "oriya" },
            { "Rohg", "hanifi" },
            { "Sinh", "sinhala" },
            { "Sund", "sundanesískt" },
            { "Syrc", "syriakískt" },
            { "Taml", "tamílskt" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Thaa", "thaana" },
            { "Thai", "taílenskt" },
            { "Tibt", "tíbeskt" },
            { "Vaii", "vai" },
            { "Yiii", "yí" },
            { "Zmth", "stærðfræðitákn" },
            { "Zsye", "emoji-tákn" },
            { "Zsym", "tákn" },
            { "Zxxx", "óskrifað" },
            { "Zyyy", "almennt" },
            { "Zzzz", "óþekkt letur" },
            { "de_AT", "austurrísk þýska" },
            { "de_CH", "svissnesk háþýska" },
            { "en_AU", "áströlsk enska" },
            { "en_CA", "kanadísk enska" },
            { "en_GB", "bresk enska" },
            { "en_US", "bandarísk enska" },
            { "es_ES", "evrópsk spænska" },
            { "es_MX", "mexíkósk spænska" },
            { "fa_AF", "darí" },
            { "fr_CA", "kanadísk franska" },
            { "fr_CH", "svissnesk franska" },
            { "nl_BE", "flæmska" },
            { "pt_BR", "brasílísk portúgalska" },
            { "pt_PT", "evrópsk portúgalska" },
            { "ro_MD", "moldóvska" },
            { "sw_CD", "kongósvahílí" },
            { "ar_001", "stöðluð nútímaarabíska" },
            { "es_419", "rómönsk-amerísk spænska" },
            { "key.ca", "Tímatal" },
            { "key.cf", "Gjaldmiðilssnið" },
            { "key.co", "Röðun" },
            { "key.cu", "Gjaldmiðill" },
            { "key.hc", "Tímakerfi (12 eða 24)" },
            { "key.lb", "Línuskipting" },
            { "key.ms", "Mælingakerfi" },
            { "key.nu", "Tölur" },
            { "key.tz", "Tímabelti" },
            { "key.va", "Landsstaðalsafbrigði" },
            { "nds_NL", "lágsaxneska" },
            { "zh_Hans", "kínverska (einfölduð)" },
            { "zh_Hant", "kínverska (hefðbundin)" },
            { "type.ca.roc", "Minguo tímatal" },
            { "type.co.eor", "Evrópskar reglur um röðun" },
            { "type.hc.h11", "12 tíma kerfi (0–11)" },
            { "type.hc.h12", "12 tíma kerfi (1–12)" },
            { "type.hc.h23", "24 tíma kerfi (0–23)" },
            { "type.hc.h24", "24 tíma kerfi (1–24)" },
            { "type.m0.bgn", "US BGN umritun" },
            { "type.nu.ahom", "ahom-tölur" },
            { "type.nu.arab", "Arabískar-indverskar tölur" },
            { "type.nu.armn", "Armenskir tölustafir" },
            { "type.nu.beng", "Bengalskar tölur" },
            { "type.nu.cakm", "Chakma-tölur" },
            { "type.nu.deva", "Devanagari tölur" },
            { "type.nu.ethi", "Eþíópískir tölustafir" },
            { "type.nu.geor", "Georgískir tölustafir" },
            { "type.nu.grek", "Grískir tölustafir" },
            { "type.nu.gujr", "Gujarati-tölur" },
            { "type.nu.guru", "Gurmukhi-tölur" },
            { "type.nu.hans", "Einfaldaðir kínverskir tölustafir" },
            { "type.nu.hant", "Hefðbundnir kínverskir tölustafir" },
            { "type.nu.hebr", "Hebreskir tölustafir" },
            { "type.nu.java", "Javanskar tölur" },
            { "type.nu.jpan", "Japanskir tölustafir" },
            { "type.nu.khmr", "Kmerískar tölur" },
            { "type.nu.knda", "Kannada-tölur" },
            { "type.nu.laoo", "Lao-tölur" },
            { "type.nu.latn", "Vestrænar tölur" },
            { "type.nu.mlym", "Malayalam-tölur" },
            { "type.nu.mong", "Mongólskar tölur" },
            { "type.nu.mtei", "Meetei mayek-tölur" },
            { "type.nu.mymr", "Mjanmarskar tölur" },
            { "type.nu.olck", "Ol chiki-tölur" },
            { "type.nu.orya", "Odia-tölur" },
            { "type.nu.taml", "Hefðbundnir tamílskir tölustafir" },
            { "type.nu.telu", "Telúgú-tölur" },
            { "type.nu.thai", "Tælenskar tölur" },
            { "type.nu.tibt", "Tíbeskir tölustafir" },
            { "type.nu.vaii", "Vai-tölustafir" },
            { "type.ca.dangi", "Dangi tímatal" },
            { "type.co.ducet", "Sjálfgefin Unicode-röðun" },
            { "type.lb.loose", "Laus línuskipting" },
            { "type.nu.roman", "Rómverskir tölustafir" },
            { "type.ca.coptic", "Koptískt tímatal" },
            { "type.ca.hebrew", "Hebreskt tímatal" },
            { "type.ca.indian", "indverskt dagatal" },
            { "type.co.compat", "Fyrri röðun, til samræmis" },
            { "type.co.pinyin", "Pinyin-röðun" },
            { "type.co.search", "Almenn leit" },
            { "type.co.stroke", "Strikaröðun" },
            { "type.co.unihan", "Röðun eftir grunnstrikum" },
            { "type.d0.fwidth", "Full breidd" },
            { "type.d0.hwidth", "Hálfbreidd" },
            { "type.lb.normal", "Venjuleg línuskipting" },
            { "type.lb.strict", "Ströng línuskipting" },
            { "type.m0.ungegn", "UN GEGN umritun" },
            { "type.ms.metric", "Metrakerfi" },
            { "type.nu.native", "Upprunalegir tölustafir" },
            { "type.ca.chinese", "Kínversk tímatal" },
            { "type.ca.islamic", "Íslamskt tímatal" },
            { "type.ca.iso8601", "ISO-8601 tímatal" },
            { "type.ca.persian", "Persneskt tímatal" },
            { "type.cf.account", "Bókhaldsgjaldmiðill" },
            { "type.co.big5han", "hefðbundin kínversk röðun - Big5" },
            { "type.d0.npinyin", "Tölulegur" },
            { "type.nu.arabext", "Auknar arabískar-indverskar tölur" },
            { "type.nu.armnlow", "Armenskar lágstafatölur" },
            { "type.nu.finance", "Viðskiptafræðileg töluorð" },
            { "type.nu.greklow", "Grískar lágstafatölur" },
            { "type.nu.hanidec", "Kínverskir tugatölustafir" },
            { "type.nu.hansfin", "Einfaldaðar kínverskar fjármálatölur" },
            { "type.nu.hantfin", "Hefðbundnar kínverskar fjármálatölur" },
            { "type.nu.jpanfin", "Japanskar fjármálatölur" },
            { "type.nu.tamldec", "Tamílskar tölur" },
            { "type.ca.buddhist", "Búddískt tímatal" },
            { "type.ca.ethiopic", "Eþíópískt tímatal" },
            { "type.ca.japanese", "Japanskt tímatal" },
            { "type.cf.standard", "Staðlað gjaldmiðilssnið" },
            { "type.co.phonetic", "Hljóðfræðileg röð" },
            { "type.co.searchjl", "Leita eftir upphafssamhljóða í Hangul" },
            { "type.co.standard", "Stöðluð röðun" },
            { "type.ms.uksystem", "Breskt mælingakerfi" },
            { "type.ms.ussystem", "Bandarískt mælingakerfi" },
            { "type.nu.fullwide", "Tölur í fullri breidd" },
            { "type.nu.romanlow", "Rómverskar lágstafatölur" },
            { "type.ca.gregorian", "Gregorískt tímatal" },
            { "type.co.gb2312han", "einfölduð kínversk röðun - GB2312" },
            { "type.co.phonebook", "Símaskráarröðun" },
            { "type.co.dictionary", "Orðabókarröð" },
            { "type.co.traditional", "Hefðbundin" },
            { "type.nu.traditional", "Hefðbundin tölutákn" },
            { "type.ca.islamic-civil", "Íslamskt borgaradagatal" },
            { "type.ca.islamic-umalqura", "Íslamskt dagatal (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Eþíópískt ‘amete alem’ tímatal" },
        };
        return data;
    }
}
