/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabiska";
        final String metaValue_hy = "armeniska";
        final String metaValue_ae = "avestiska";
        final String metaValue_ban = "balinesiska";
        final String metaValue_bax = "bamunska";
        final String metaValue_zbl = "blissymboler";
        final String metaValue_bug = "buginesiska";
        final String metaValue_ccp = "chakma";
        final String metaValue_cop = "koptiska";
        final String metaValue_gez = "etiopiska";
        final String metaValue_ka = "georgiska";
        final String metaValue_got = "gotiska";
        final String metaValue_el = "grekiska";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreiska";
        final String metaValue_ja = "japanska";
        final String metaValue_ko = "koreanska";
        final String metaValue_lo = "laotiska";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongoliska";
        final String metaValue_my = "burmesiska";
        final String metaValue_new = "newariska";
        final String metaValue_nqo = "n-kå";
        final String metaValue_or = "oriya";
        final String metaValue_osa = "osage";
        final String metaValue_phn = "feniciska";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "singalesiska";
        final String metaValue_sog = "sogdiska";
        final String metaValue_su = "sundanesiska";
        final String metaValue_syr = "syriska";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thailändska";
        final String metaValue_bo = "tibetanska";
        final String metaValue_uga = "ugaritiska";
        final String metaValue_vai = "vaj";
        final String metaValue_peo = "fornpersiska";
        final Object[][] data = new Object[][] {
            { "001", "världen" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Sydamerika" },
            { "009", "Oceanien" },
            { "011", "Västafrika" },
            { "013", "Centralamerika" },
            { "014", "Östafrika" },
            { "015", "Nordafrika" },
            { "017", "Centralafrika" },
            { "018", "södra Afrika" },
            { "019", "Nord- och Sydamerika" },
            { "021", "norra Amerika" },
            { "029", "Karibien" },
            { "030", "Östasien" },
            { "034", "Sydasien" },
            { "035", "Sydostasien" },
            { "039", "Sydeuropa" },
            { "053", "Australasien" },
            { "054", "Melanesien" },
            { "057", "Mikronesiska öarna" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Centralasien" },
            { "145", "Västasien" },
            { "150", "Europa" },
            { "151", "Östeuropa" },
            { "154", "Nordeuropa" },
            { "155", "Västeuropa" },
            { "202", "Subsahariska Afrika" },
            { "419", "Latinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Förenade Arabemiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua och Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "Österrike" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "Åland" },
            { "AZ", "Azerbajdzjan" },
            { "BA", "Bosnien och Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S:t Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibiska Nederländerna" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetön" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosöarna" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralafrikanska republiken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskusten" },
            { "CK", "Cooköarna" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clippertonön" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Julön" },
            { "CY", "Cypern" },
            { "CZ", "Tjeckien" },
            { "DE", "Tyskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanska republiken" },
            { "DZ", "Algeriet" },
            { "EA", "Ceuta och Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypten" },
            { "EH", "Västsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Europeiska unionen" },
            { "EZ", "euroområdet" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandsöarna" },
            { "FM", "Mikronesien" },
            { "FO", "Färöarna" },
            { "FR", "Frankrike" },
            { "GA", "Gabon" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorialguinea" },
            { "GR", "Grekland" },
            { "GS", "Sydgeorgien och Sydsandwichöarna" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR" },
            { "HM", "Heardön och McDonaldöarna" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungern" },
            { "IC", "Kanarieöarna" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Brittiska territoriet i Indiska oceanen" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorerna" },
            { "KN", "S:t Kitts och Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "KW", "Kuwait" },
            { "KY", "Caymanöarna" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "S:t Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marocko" },
            { "MC", "Monaco" },
            { "MD", "Moldavien" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallöarna" },
            { "MK", "Nordmakedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongoliet" },
            { "MO", "Macao SAR" },
            { "MP", "Nordmarianerna" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiverna" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Moçambique" },
            { "NA", "Namibia" },
            { "NC", "Nya Kaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolkön" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederländerna" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nya Zeeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesien" },
            { "PG", "Papua Nya Guinea" },
            { "PH", "Filippinerna" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "S:t Pierre och Miquelon" },
            { "PN", "Pitcairnöarna" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinska territorierna" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "yttre öar i Oceanien" },
            { "RE", "Réunion" },
            { "RO", "Rumänien" },
            { "RS", "Serbien" },
            { "RU", "Ryssland" },
            { "RW", "Rwanda" },
            { "SA", "Saudiarabien" },
            { "SB", "Salomonöarna" },
            { "SC", "Seychellerna" },
            { "SD", "Sudan" },
            { "SE", "Sverige" },
            { "SG", "Singapore" },
            { "SH", "S:t Helena" },
            { "SI", "Slovenien" },
            { "SJ", "Svalbard och Jan Mayen" },
            { "SK", "Slovakien" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sydsudan" },
            { "ST", "São Tomé och Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- och Caicosöarna" },
            { "TD", "Tchad" },
            { "TF", "Franska sydterritorierna" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelauöarna" },
            { "TL", "Östtimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisien" },
            { "TO", "Tonga" },
            { "TR", "Turkiet" },
            { "TT", "Trinidad och Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "USA:s yttre öar" },
            { "UN", "Förenta Nationerna" },
            { "US", "USA" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanstaten" },
            { "VC", "S:t Vincent och Grenadinerna" },
            { "VE", "Venezuela" },
            { "VG", "Brittiska Jungfruöarna" },
            { "VI", "Amerikanska Jungfruöarna" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis- och Futunaöarna" },
            { "WS", "Samoa" },
            { "XA", "fejkade accenter (för test)" },
            { "XB", "fejkad bidi (för test)" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "okänd region" },
            { "aa", "afar" },
            { "ab", "abchaziska" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariska" },
            { "an", "aragonesiska" },
            { "ar", metaValue_ar },
            { "as", "assamesiska" },
            { "av", "avariska" },
            { "ay", "aymara" },
            { "az", "azerbajdzjanska" },
            { "ba", "basjkiriska" },
            { "be", "belarusiska" },
            { "bg", "bulgariska" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "br", "bretonska" },
            { "bs", "bosniska" },
            { "ca", "katalanska" },
            { "ce", "tjetjenska" },
            { "ch", "chamorro" },
            { "co", "korsikanska" },
            { "cr", "cree" },
            { "cs", "tjeckiska" },
            { "cu", "kyrkslaviska" },
            { "cv", "tjuvasjiska" },
            { "cy", "walesiska" },
            { "da", "danska" },
            { "de", "tyska" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "engelska" },
            { "eo", "esperanto" },
            { "es", "spanska" },
            { "et", "estniska" },
            { "eu", "baskiska" },
            { "fa", "persiska" },
            { "ff", "fulani" },
            { "fi", "finska" },
            { "fj", "fijianska" },
            { "fo", "färöiska" },
            { "fr", "franska" },
            { "fy", "västfrisiska" },
            { "ga", "iriska" },
            { "gd", "skotsk gaeliska" },
            { "gl", "galiciska" },
            { "gn", "guaraní" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "kroatiska" },
            { "ht", "haitiska" },
            { "hu", "ungerska" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiska" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "szezuan i" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "isländska" },
            { "it", "italienska" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanesiska" },
            { "ka", metaValue_ka },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakiska" },
            { "kl", "grönländska" },
            { "km", "kambodjanska" },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiriska" },
            { "ku", "kurdiska" },
            { "kv", "kome" },
            { "kw", "korniska" },
            { "ky", "kirgiziska" },
            { "la", "latin" },
            { "lb", "luxemburgiska" },
            { "lg", "luganda" },
            { "li", "limburgiska" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litauiska" },
            { "lu", "luba-katanga" },
            { "lv", "lettiska" },
            { "mg", "malagassiska" },
            { "mh", "marshalliska" },
            { "mi", "maori" },
            { "mk", "makedonska" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malajiska" },
            { "mt", "maltesiska" },
            { "my", metaValue_my },
            { "na", "nauruanska" },
            { "nb", "norskt bokmål" },
            { "nd", "nordndebele" },
            { "ne", "nepalesiska" },
            { "ng", "ndonga" },
            { "nl", "nederländska" },
            { "nn", "nynorska" },
            { "no", "norska" },
            { "nr", "sydndebele" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occitanska" },
            { "oj", "odjibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiska" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polska" },
            { "ps", "afghanska" },
            { "pt", "portugisiska" },
            { "qu", "quechua" },
            { "rm", "rätoromanska" },
            { "rn", "rundi" },
            { "ro", "rumänska" },
            { "ru", "ryska" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinska" },
            { "sd", "sindhi" },
            { "se", "nordsamiska" },
            { "sg", "sango" },
            { "sh", "serbokroatiska" },
            { "si", metaValue_si },
            { "sk", "slovakiska" },
            { "sl", "slovenska" },
            { "sm", "samoanska" },
            { "sn", "shona" },
            { "so", "somaliska" },
            { "sq", "albanska" },
            { "sr", "serbiska" },
            { "ss", "swati" },
            { "st", "sydsotho" },
            { "su", metaValue_su },
            { "sv", "svenska" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", metaValue_te },
            { "tg", "tadzjikiska" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "turkmeniska" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganska" },
            { "tr", "turkiska" },
            { "ts", "tsonga" },
            { "tt", "tatariska" },
            { "tw", "twi" },
            { "ty", "tahitiska" },
            { "ug", "uiguriska" },
            { "uk", "ukrainska" },
            { "ur", "urdu" },
            { "uz", "uzbekiska" },
            { "ve", "venda" },
            { "vi", "vietnamesiska" },
            { "vo", "volapük" },
            { "wa", "vallonska" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddisch" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "kinesiska" },
            { "zu", "zulu" },
            { "ace", "acehnesiska" },
            { "ach", "acholi" },
            { "ada", "adangme" },
            { "ady", "adygeiska" },
            { "aeb", "tunisisk arabiska" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadiska" },
            { "akz", "Alabama-muskogee" },
            { "ale", "aleutiska" },
            { "aln", "gegiska" },
            { "alt", "sydaltaiska" },
            { "ang", "fornengelska" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameiska" },
            { "arn", "mapudungun" },
            { "aro", "araoniska" },
            { "arp", "arapaho" },
            { "arq", "algerisk arabiska" },
            { "ars", "najdiarabiska" },
            { "arw", "arawakiska" },
            { "ary", "marockansk arabiska" },
            { "arz", "egyptisk arabiska" },
            { "asa", "asu" },
            { "ase", "amerikanskt teckenspråk" },
            { "ast", "asturiska" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baluchiska" },
            { "ban", metaValue_ban },
            { "bar", "bayerska" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbc", "batak-toba" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bew", "betawiska" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "bagada" },
            { "bgc", "hariyanvi" },
            { "bgn", "västbaluchiska" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjariska" },
            { "bkm", "bamekon" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahuiska" },
            { "brx", "bodo" },
            { "bss", "bakossi" },
            { "bua", "burjätiska" },
            { "bug", metaValue_bug },
            { "bum", "boulou" },
            { "byn", "blin" },
            { "byv", "bagangte" },
            { "cad", "caddo" },
            { "car", "karibiska" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukesiska" },
            { "chm", "mariska" },
            { "chn", "chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokesiska" },
            { "chy", "cheyenne" },
            { "ckb", "centralkurdiska" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "kapisnon" },
            { "crg", "michif" },
            { "crh", "krimtatariska" },
            { "crj", "sydostcree" },
            { "crk", "slättcree" },
            { "crl", "nordost-cree" },
            { "crm", "moose cree" },
            { "crr", "Carolina-algonkinska" },
            { "crs", "seychellisk kreol" },
            { "csb", "kasjubiska" },
            { "csw", "träskcree" },
            { "dak", "dakota" },
            { "dar", "darginska" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavej" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "lågsorbiska" },
            { "dtp", "centraldusun" },
            { "dua", "duala" },
            { "dum", "medelnederländska" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emiliska" },
            { "egy", "fornegyptiska" },
            { "eka", "ekajuk" },
            { "elx", "elamitiska" },
            { "enm", "medelengelska" },
            { "esu", "centralalaskisk jupiska" },
            { "ewo", "ewondo" },
            { "ext", "extremaduriska" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippinska" },
            { "fit", "meänkieli" },
            { "fon", "fonspråket" },
            { "frc", "cajun-franska" },
            { "frm", "medelfranska" },
            { "fro", "fornfranska" },
            { "frp", "frankoprovensalska" },
            { "frr", "nordfrisiska" },
            { "frs", "östfrisiska" },
            { "fur", "friulianska" },
            { "gaa", "gã" },
            { "gag", "gagauziska" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "zoroastrisk dari" },
            { "gez", metaValue_gez },
            { "gil", "gilbertiska" },
            { "glk", "gilaki" },
            { "gmh", "medelhögtyska" },
            { "goh", "fornhögtyska" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "forngrekiska" },
            { "gsw", "schweizertyska" },
            { "guc", "wayuu" },
            { "gur", "farefare" },
            { "guz", "gusii" },
            { "gwi", "gwichin" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawaiiska" },
            { "hax", "sydhaida" },
            { "hif", "Fiji-hindi" },
            { "hil", "hiligaynon" },
            { "hit", "hettitiska" },
            { "hmn", "hmongspråk" },
            { "hsb", "högsorbiska" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "ibanska" },
            { "ibb", "ibibio" },
            { "ikt", "inuktun" },
            { "ilo", "iloko" },
            { "inh", "ingusjiska" },
            { "izh", "ingriska" },
            { "jam", "jamaikansk engelsk kreol" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "kimashami" },
            { "jpr", "judisk persiska" },
            { "jrb", "judisk arabiska" },
            { "jut", "jylländska" },
            { "kaa", "karakalpakiska" },
            { "kab", "kabyliska" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardinska" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdiska" },
            { "ken", "kenjang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanesiska" },
            { "khq", "Timbuktu-songhai" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "mkako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permjakiska" },
            { "kok", "konkani" },
            { "kos", "kosreanska" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelska" },
            { "kru", "kurukh" },
            { "ksb", "kisambaa" },
            { "ksf", "bafia" },
            { "ksh", "kölniska" },
            { "kum", "kumykiska" },
            { "kut", "kutenaj" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lfn", "lingua franca nova" },
            { "lij", "liguriska" },
            { "lil", "lillooet" },
            { "liv", "livoniska" },
            { "lkt", "lakota" },
            { "lmo", "lombardiska" },
            { "lol", "mongo" },
            { "lou", "louisiana-kreol" },
            { "loz", "lozi" },
            { "lrc", "nordluri" },
            { "lsm", "saamia" },
            { "ltg", "lettgalliska" },
            { "lua", "luba-lulua" },
            { "lui", "luiseño" },
            { "lun", "lunda" },
            { "lus", "lushai" },
            { "luy", "luhya" },
            { "lzh", "litterär kineiska" },
            { "lzz", "laziska" },
            { "mad", "maduresiska" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mande" },
            { "mas", "massajiska" },
            { "mde", "maba" },
            { "mdf", "moksja" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "mauritansk kreol" },
            { "mga", "medeliriska" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "mi’kmaq" },
            { "min", "minangkabau" },
            { "mnc", "manchuriska" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "västmariska" },
            { "mua", "mundang" },
            { "mul", "flera språk" },
            { "mus", "muskogee" },
            { "mwl", "mirandesiska" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erjya" },
            { "mzn", "mazanderani" },
            { "nan", "min nan" },
            { "nap", "napolitanska" },
            { "naq", "nama" },
            { "nds", "lågtyska" },
            { "new", metaValue_new },
            { "nia", "nias" },
            { "niu", "niueanska" },
            { "njo", "ao-naga" },
            { "nmg", "kwasio" },
            { "nnh", "bamileké-ngiemboon" },
            { "nog", "nogai" },
            { "non", "fornnordiska" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "nordsotho" },
            { "nus", "nuer" },
            { "nwc", "klassisk newariska" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "nordvästojibwa" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "västojibwe" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "ota", "ottomanska" },
            { "pag", "pangasinan" },
            { "pal", "medelpersiska" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardiska" },
            { "pcm", "nigeriansk pidgin" },
            { "pdc", "Pennsylvaniatyska" },
            { "pdt", "mennonitisk lågtyska" },
            { "peo", metaValue_peo },
            { "pfl", "Pfalz-tyska" },
            { "phn", metaValue_phn },
            { "pis", "pidginspråk" },
            { "pms", "piemontesiska" },
            { "pnt", "pontiska" },
            { "pon", "pohnpeiska" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "fornpreussiska" },
            { "pro", "fornprovensalska" },
            { "quc", "quiché" },
            { "qug", "Chimborazo-höglandskichwa" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonganska" },
            { "rgn", "romagnol" },
            { "rhg", "ruáingga" },
            { "rif", "riffianska" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotumänska" },
            { "rue", "rusyn" },
            { "rug", "rovianska" },
            { "rup", "arumänska" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutiska" },
            { "sam", "samaritanska" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilianska" },
            { "sco", "skotska" },
            { "sdc", "sassaresisk sardiska" },
            { "sdh", "sydkurdiska" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "songhai" },
            { "sga", "forniriska" },
            { "sgs", "samogitiska" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "Tchad-arabiska" },
            { "sid", "sidamo" },
            { "slh", "sydlushootseed" },
            { "sli", "lågsilesiska" },
            { "sly", "selayar" },
            { "sma", "sydsamiska" },
            { "smj", "lulesamiska" },
            { "smn", "enaresamiska" },
            { "sms", "skoltsamiska" },
            { "snk", "soninke" },
            { "sog", metaValue_sog },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "saterfrisiska" },
            { "str", "sundsalishanska" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriska" },
            { "swb", "shimaoré" },
            { "syc", "klassisk syriska" },
            { "syr", metaValue_syr },
            { "szl", "silesiska" },
            { "tce", "sydtutchone" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tiv", "tivi" },
            { "tkl", "tokelauiska" },
            { "tkr", "tsakhur" },
            { "tlh", "klingonska" },
            { "tli", "tlingit" },
            { "tly", "talysh" },
            { "tmh", "tamashek" },
            { "tog", "nyasatonganska" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "tsakodiska" },
            { "tsi", "tsimshian" },
            { "ttm", "nordtutchone" },
            { "ttt", "muslimsk tatariska" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluanska" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniska" },
            { "tzm", "centralmarockansk tamazight" },
            { "udm", "udmurtiska" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "obestämt språk" },
            { "vai", metaValue_vai },
            { "vec", "venetianska" },
            { "vep", "veps" },
            { "vls", "västflamländska" },
            { "vmf", "Main-frankiska" },
            { "vmw", "makua" },
            { "vot", "votiska" },
            { "vro", "võru" },
            { "vun", "vunjo" },
            { "wae", "walsertyska" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmuckiska" },
            { "xmf", "mingrelianska" },
            { "xnr", "kangri" },
            { "xog", "lusoga" },
            { "yao", "kiyao" },
            { "yap", "japetiska" },
            { "yav", "yangben" },
            { "ybb", "bamileké-jemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonesiska" },
            { "zap", "zapotek" },
            { "zbl", metaValue_zbl },
            { "zea", "zeeländska" },
            { "zen", "zenaga" },
            { "zgh", "marockansk standard-tamazight" },
            { "zun", "zuni" },
            { "zxx", "inget språkligt innehåll" },
            { "zza", "zazaiska" },
            { "Adlm", "adlamiska" },
            { "Afak", "afakiska" },
            { "Aghb", "kaukasiska albanska" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "imperisk arameiska" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "bassaiska vah" },
            { "Batk", "batak" },
            { "Beng", "bengaliska" },
            { "Bhks", "bhaiksukiska" },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brami" },
            { "Brai", "punktskrift" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "kanadensiska stavelsetecken" },
            { "Cari", "kariska" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Chrs", "khwarezmiska" },
            { "Cirt", "cirt" },
            { "Copt", metaValue_cop },
            { "Cpmn", "cypro-minoisk skrift" },
            { "Cprt", "cypriotiska" },
            { "Cyrl", "kyrilliska" },
            { "Cyrs", "fornkyrkoslavisk kyrilliska" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogriska" },
            { "Dsrt", "deseret" },
            { "Dupl", "Duployéstenografiska" },
            { "Egyd", "demotiska" },
            { "Egyh", "hieratiska" },
            { "Egyp", "egyptiska hieroglyfer" },
            { "Elba", "elbasiska" },
            { "Elym", "elymaiska" },
            { "Ethi", metaValue_gez },
            { "Geok", "kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitiska" },
            { "Gong", "gunjalgondiska" },
            { "Gonm", "masaram-gondi" },
            { "Goth", metaValue_got },
            { "Gran", "gammaltamilska" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhiska" },
            { "Hanb", "han med bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunó’o" },
            { "Hans", "förenklad" },
            { "Hant", "traditionell" },
            { "Hatr", "hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "hittitiska hieroglyfer" },
            { "Hmng", "pahaw mong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "katakana/hiragana" },
            { "Hung", "fornungerska" },
            { "Inds", "indus" },
            { "Ital", "fornitaliska" },
            { "Jamo", "jamo" },
            { "Java", "javanska" },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchenska" },
            { "Kali", "kaya li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshti" },
            { "Khmr", "khmeriska" },
            { "Khoj", "khojkiska" },
            { "Kits", "khitanska" },
            { "Knda", "kanaresiska" },
            { "Kore", metaValue_ko },
            { "Kpel", "kpellé" },
            { "Kthi", "kaithiska" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "frakturlatin" },
            { "Latg", "gaeliskt latin" },
            { "Latn", "latinska" },
            { "Lepc", "rong" },
            { "Limb", "limbu" },
            { "Lina", "linjär A" },
            { "Linb", "linjär B" },
            { "Lisu", "Fraser" },
            { "Loma", "loma" },
            { "Lyci", "lykiska" },
            { "Lydi", "lydiska" },
            { "Mahj", "mahajaniska" },
            { "Maka", "makasariska" },
            { "Mand", "mandaéiska" },
            { "Mani", "manikeanska" },
            { "Marc", "marchenska" },
            { "Maya", "mayahieroglyfer" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "kursiv-meroitiska" },
            { "Mero", "meroitiska" },
            { "Mlym", metaValue_ml },
            { "Modi", "modiska" },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mru" },
            { "Mtei", "meitei-mayek" },
            { "Mult", "multaniska" },
            { "Mymr", metaValue_my },
            { "Nand", "nandinagari" },
            { "Narb", "fornnordarabiska" },
            { "Nbat", "nabateiska" },
            { "Newa", metaValue_new },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmanja" },
            { "Palm", "palmyreniska" },
            { "Pauc", "Pau Cin Hau-skrift" },
            { "Perm", "fornpermiska" },
            { "Phag", "phags-pa" },
            { "Phli", "tidig pahlavi" },
            { "Phlp", "psaltaren-pahlavi" },
            { "Phlv", "bokpahlavi" },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollardtecken" },
            { "Prti", "tidig parthianska" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifiska" },
            { "Roro", "rongo-rongo" },
            { "Runr", "runor" },
            { "Samr", "samaritiska" },
            { "Sara", "sarati" },
            { "Sarb", "fornsydarabiska" },
            { "Saur", metaValue_saz },
            { "Sgnw", "teckningsskrift" },
            { "Shaw", "shawiska" },
            { "Shrd", "sharada" },
            { "Sidd", "siddhamska" },
            { "Sind", "sindhiska" },
            { "Sinh", metaValue_si },
            { "Sogd", metaValue_sog },
            { "Sogo", "gammalsogdiska" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "estrangelosyriska" },
            { "Syrj", "västsyriska" },
            { "Syrn", "östsyriska" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takritiska" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", "tamilska" },
            { "Tang", "tangutiska" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinaghiska" },
            { "Tglg", metaValue_tl },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "synligt tal" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumero-akkadisk kilskrift" },
            { "Yezi", "yazidiska" },
            { "Yiii", "yi" },
            { "Zanb", "zanabazar kvadratisk skrift" },
            { "Zinh", "ärvda" },
            { "Zmth", "matematisk notation" },
            { "Zsye", "emoji" },
            { "Zsym", "symboler" },
            { "Zxxx", "oskrivet språk" },
            { "Zyyy", "gemensamma" },
            { "Zzzz", "okänt skriftsystem" },
            { "de_AT", "österrikisk tyska" },
            { "de_CH", "schweizisk högtyska" },
            { "en_AU", "australisk engelska" },
            { "en_CA", "kanadensisk engelska" },
            { "en_GB", "brittisk engelska" },
            { "en_US", "amerikansk engelska" },
            { "es_ES", "europeisk spanska" },
            { "es_MX", "mexikansk spanska" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadensisk franska" },
            { "fr_CH", "schweizisk franska" },
            { "nl_BE", "flamländska" },
            { "pt_BR", "brasiliansk portugisiska" },
            { "pt_PT", "europeisk portugisiska" },
            { "ro_MD", "moldaviska" },
            { "sw_CD", "Kongo-swahili" },
            { "%%1901", "traditionell tysk stavning" },
            { "%%1994", "1994 års resisk stavning" },
            { "%%1996", "1996 års reformerad tysk stavning" },
            { "ar_001", "modern standardarabiska" },
            { "es_419", "latinamerikansk spanska" },
            { "key.ca", "kalender" },
            { "key.cf", "valutaformat" },
            { "key.co", "sorteringsordning" },
            { "key.cu", "valuta" },
            { "key.hc", "12- eller 24-timmarsklocka" },
            { "key.lb", "radbrytningstyp" },
            { "key.ms", "enhetssystem" },
            { "key.nu", "siffror" },
            { "key.tz", "Tidszon" },
            { "key.va", "Språkvariant" },
            { "nds_NL", "lågsaxiska" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "%%BARLA", "barlavento-dialekt" },
            { "%%BISKE", "Bila-dialekt" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "kornisk engelska" },
            { "%%JAUER", "jauer-dialekt" },
            { "%%KKCOR", "vanlig stavning" },
            { "%%KSCOR", "standardstavning" },
            { "%%LIPAW", "Lipovaz-dialekt" },
            { "%%NEDIS", "natisonsk dialekt" },
            { "%%NJIVA", "Njiva-dialekt" },
            { "%%NULIK", "nulik-stavning" },
            { "%%OSOJS", "Osojane-dialekt" },
            { "%%POSIX", "Posix" },
            { "%%PUTER", "puter-dialekt" },
            { "%%RIGIK", "klassisk volapük" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%RUMGR", "grischun-dialekt" },
            { "%%SAAHO", "saho-dialekt" },
            { "%%SOLBA", "Solbica-dialekt" },
            { "%%SOTAV", "sotavento-dialekt" },
            { "%%UCCOR", "unifierad stavning" },
            { "hi_Latn", "hindi (latinsk)" },
            { "zh_Hans", "förenklad kinesiska" },
            { "zh_Hant", "traditionell kinesiska" },
            { "%%AO1990", "stavning enligt 1990 års överenskommelse" },
            { "%%ARANES", "aranesiska (occitanska)" },
            { "%%ASANTE", "asante (twi)" },
            { "%%AUVERN", "auvergniska (occitanska)" },
            { "%%CISAUP", "cisalpinska (occitanska)" },
            { "%%CREISS", "croissant-occitanska" },
            { "%%DAJNKO", "Dajnko-alfabetet" },
            { "%%EKAVSK", "ekavisk dialekt" },
            { "%%FONIPA", "internationell fonetisk notation - IPA" },
            { "%%FONUPA", "uralisk fonetisk notation" },
            { "%%GASCON", "Gascogne-occitanska" },
            { "%%GRITAL", "italiensk-inspirerad occitanska" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "%%NICARD", "Nice-occitanska" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%SIMPLE", "lätt" },
            { "%%TARASK", "Taraskievika-stavning" },
            { "%%UCRCOR", "reviderad unifierad stavning" },
            { "%%ULSTER", "Ulster-dialekt" },
            { "%%UNIFON", "unifon-skrift" },
            { "%%ABL1943", "1943 års stavning" },
            { "%%AKUAPEM", "akapuem (twi)" },
            { "%%ALALC97", "1997 års ALA-LC" },
            { "%%AREVELA", "östarmeniska" },
            { "%%AREVMDA", "västarmeniska" },
            { "%%BALANKA", "balanka-dialekt" },
            { "%%BAUDDHA", "bauddha-dialekt" },
            { "%%BOHORIC", "Bohorič-alfabetet" },
            { "%%EMODENG", "tidig modern engelska" },
            { "%%FONNAPA", "nordamerikanskt fonetiskt alfabet" },
            { "%%GRCLASS", "klassisk occitanska" },
            { "%%GRMISTR", "Mistral-occitanska" },
            { "%%HEPBURN", "Hepburn" },
            { "%%ITIHASA", "itihasa-dialekt" },
            { "%%LAUKIKA", "laukika-dialekt" },
            { "%%LEMOSIN", "Limousin-occitanska" },
            { "%%METELKO", "Metelko-alfabetet" },
            { "%%MONOTON", "monotonisk stavning" },
            { "%%PAHAWH2", "pahawh hmong andra steget reducerad stavning" },
            { "%%PAHAWH3", "pahawh hmong tredje steget reducerad stavning" },
            { "%%PAHAWH4", "pahawh hmong sista steget reducerad stavning" },
            { "%%POLYTON", "polytonisk stavning" },
            { "%%PROVENC", "provensalska" },
            { "%%REVISED", "reformerad stavning" },
            { "%%SURSILV", "sursilvan-dialekt" },
            { "%%SUTSILV", "sutsilvan-dialekt" },
            { "%%VAIDIKA", "vedisk dialekt" },
            { "%%1606NICT", "1606 års stavning" },
            { "%%1694ACAD", "1694 års stavning" },
            { "%%1959ACAD", "1959 års stavning" },
            { "%%BAKU1926", "1926 års stavning" },
            { "%%BASICENG", "Ogdens basic english" },
            { "%%BISCAYAN", "Biscaya-dialekt" },
            { "%%BORNHOLM", "Bornholm" },
            { "%%COLB1945", "stavning enligt 1945 års konvention mellan Portugal och Brasilien" },
            { "%%FONKIRSH", "Kirshenbaums fonetiska alfabet" },
            { "%%FONXSAMP", "X-SAMPA fonetisk notation" },
            { "%%HOGNORSK", "högnorsk dialekt" },
            { "%%HSISTEMO", "h-system" },
            { "%%IJEKAVSK", "ijekavisk dialekt" },
            { "%%IVANCHOV", "bulgariska i 1899 års stavning" },
            { "%%JYUTPING", "jyutping" },
            { "%%KOCIEWIE", "kociewiska" },
            { "%%LENGADOC", "languedociska" },
            { "%%LUNA1918", "1918 års stavning" },
            { "%%NEWFOUND", "Newfoundland-engelska" },
            { "%%OXENDICT", "Oxford-stavning" },
            { "%%PETR1708", "1708 års stavning" },
            { "%%SCOTLAND", "skotsk engelska" },
            { "%%SPANGLIS", "spangelska" },
            { "%%SURMIRAN", "surmiran-dialekt" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "%%VALLADER", "vallader-dialekt" },
            { "%%VIVARAUP", "vivaroalpinska (occitanska)" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%XSISTEMO", "x-system" },
            { "type.ca.roc", "kinesiska republikens kalender" },
            { "type.co.eor", "sorteringsordning för flerspråkliga europeiska dokument" },
            { "type.hc.h11", "12-timmarsklocka (0–11)" },
            { "type.hc.h12", "12-timmarsklocka (1–12)" },
            { "type.hc.h23", "24-timmarsklocka (0–23)" },
            { "type.hc.h24", "24-timmarsklocka (1–24)" },
            { "type.m0.bgn", "enligt USA:s geografiska namnkommitté" },
            { "type.nu.ahom", "ahom-siffror" },
            { "type.nu.arab", "indo-arabiska siffror" },
            { "type.nu.armn", "armeniska taltecken" },
            { "type.nu.bali", "balinesiska siffror" },
            { "type.nu.beng", "bengaliska siffror" },
            { "type.nu.brah", "brahmiska siffror" },
            { "type.nu.cakm", "chakma-siffror" },
            { "type.nu.cham", "chamiska siffror" },
            { "type.nu.cyrl", "kyrilliska taltecken" },
            { "type.nu.deva", "devanagariska siffror" },
            { "type.nu.diak", "dives akuru-siffror" },
            { "type.nu.ethi", "etiopiska taltecken" },
            { "type.nu.geor", "georgiska taltecken" },
            { "type.nu.gong", "gunjalagondiska siffror" },
            { "type.nu.gonm", "masaramgondiska siffror" },
            { "type.nu.grek", "grekiska taltecken" },
            { "type.nu.gujr", "gujaratiska siffror" },
            { "type.nu.guru", "gurmukhiska siffror" },
            { "type.nu.hans", "förenklat kinesiskt stavade tal" },
            { "type.nu.hant", "traditionellt kinesiskt stavade tal" },
            { "type.nu.hebr", "hebreiska taltecken" },
            { "type.nu.hmng", "pahawh hmong-siffror" },
            { "type.nu.hmnp", "nyiakeng puachue hmong-siffror" },
            { "type.nu.java", "javanesiska siffror" },
            { "type.nu.jpan", "japanskt stavade tal" },
            { "type.nu.kali", "kayah li-siffror" },
            { "type.nu.khmr", "khmeriska siffror" },
            { "type.nu.knda", "kannadiska siffror" },
            { "type.nu.lana", "tai tham hora-siffror" },
            { "type.nu.laoo", "laotiska siffror" },
            { "type.nu.latn", "västerländska siffror" },
            { "type.nu.lepc", "lepcha-siffror" },
            { "type.nu.limb", "limbu-siffror" },
            { "type.nu.mlym", "malayalamiska siffror" },
            { "type.nu.modi", "modi-siffror" },
            { "type.nu.mong", "mongoliska siffror" },
            { "type.nu.mroo", "mro-siffror" },
            { "type.nu.mtei", "meetei mayek-siffror" },
            { "type.nu.mymr", "burmesiska siffror" },
            { "type.nu.nkoo", "n’ko-siffror" },
            { "type.nu.olck", "ol chiki-siffror" },
            { "type.nu.orya", "oriyiska siffror" },
            { "type.nu.osma", "osmanya-siffror" },
            { "type.nu.rohg", "hanifisiffror" },
            { "type.nu.saur", "saurashtra-siffror" },
            { "type.nu.shrd", "sharada-siffror" },
            { "type.nu.sind", "khudawidiska siffror" },
            { "type.nu.sinh", "sinhala lith-siffror" },
            { "type.nu.sora", "sora sompeng-siffror" },
            { "type.nu.sund", "sundanesiska siffror" },
            { "type.nu.takr", "takri-siffror" },
            { "type.nu.talu", "ny tai lü-siffror" },
            { "type.nu.taml", "traditionella tamilska taltecken" },
            { "type.nu.telu", "telugiska siffror" },
            { "type.nu.thai", "thailändska siffror" },
            { "type.nu.tibt", "tibetanska siffror" },
            { "type.nu.tirh", "tirhuta-siffror" },
            { "type.nu.vaii", "vai-siffror" },
            { "type.nu.wara", "varang kshiti-siffror" },
            { "type.nu.wcho", "wanchosiffror" },
            { "type.ca.dangi", "koreansk kalender" },
            { "type.co.ducet", "grundläggande Unicode-sorteringsordning" },
            { "type.co.emoji", "emojisorteringsordning" },
            { "type.lb.loose", "fri radbrytning" },
            { "type.nu.roman", "romerska taltecken" },
            { "type.ca.coptic", "koptisk kalender" },
            { "type.ca.hebrew", "hebreisk kalender" },
            { "type.ca.indian", "indisk kalender" },
            { "type.co.compat", "bakåtkompatibel sorteringsordning" },
            { "type.co.pinyin", "pinyin-sorteringsordning" },
            { "type.co.search", "allmän sökning" },
            { "type.co.stroke", "strecksorteringsordning" },
            { "type.co.unihan", "radikal-streck-sorteringsordning" },
            { "type.co.zhuyin", "zhuyin-sorteringsordning" },
            { "type.d0.fwidth", "till helbreda" },
            { "type.d0.hwidth", "till halvbreda" },
            { "type.lb.normal", "normal radbrytning" },
            { "type.lb.strict", "strikt radbrytning" },
            { "type.m0.ungegn", "enligt FN:s geografiska namnkommitté" },
            { "type.ms.metric", "metersystem" },
            { "type.nu.native", "språkspecifika siffror" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "type.ca.islamic", "islamisk kalender" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "type.ca.persian", "persisk kalender" },
            { "type.cf.account", "redovisningsformat" },
            { "type.co.big5han", "big5-sorteringsordning" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.arabext", "utökade indo-arabiska siffror" },
            { "type.nu.armnlow", "gemena armeniska taltecken" },
            { "type.nu.finance", "finansiella siffror" },
            { "type.nu.greklow", "små grekiska taltecken" },
            { "type.nu.hanidec", "kinesiska decimaltal" },
            { "type.nu.hansfin", "förenklat kinesiskt finansiellt stavade tal" },
            { "type.nu.hantfin", "traditionellt kinesiskt finansiellt stavade tal" },
            { "type.nu.jpanfin", "japanskt finansiellt stavade tal" },
            { "type.nu.mathdbl", "matematiska siffror med dubbelstreck" },
            { "type.nu.tamldec", "tamilska siffror" },
            { "type.ca.buddhist", "buddistisk kalender" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "type.ca.japanese", "japansk kalender" },
            { "type.cf.standard", "normalt format" },
            { "type.co.phonetic", "fonetisk sorteringsordning" },
            { "type.co.searchjl", "söksorteringsordning för att söka på inledande Hangul-konsonant" },
            { "type.co.standard", "normal sorteringsordning" },
            { "type.ms.uksystem", "brittiskt måttsystem" },
            { "type.ms.ussystem", "USA:s måttsystem" },
            { "type.nu.fullwide", "fullbreddssiffror" },
            { "type.nu.lanatham", "tai tham tham-siffror" },
            { "type.nu.mathbold", "matematiska siffror i fetstil" },
            { "type.nu.mathmono", "matematiska siffror med fast teckenbredd" },
            { "type.nu.mathsanb", "matematiska siffror i sans-serif fetstil" },
            { "type.nu.mathsans", "matematiska siffror i sans-serif" },
            { "type.nu.mymrshan", "burmesiska shan-siffror" },
            { "type.nu.mymrtlng", "burmesiska tai laing-siffror" },
            { "type.nu.romanlow", "små romerska taltecken" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "type.co.gb2312han", "gb2312-sorteringsordning" },
            { "type.co.phonebook", "telefonkatalogssorteringsordning" },
            { "type.co.dictionary", "ordbokssorteringsordning" },
            { "type.co.traditional", "traditionell sorteringsordning" },
            { "type.nu.traditional", "Traditionella siffror" },
            { "type.ca.islamic-rgsa", "islamisk kalender, Saudi-Arabien" },
            { "type.ca.islamic-tbla", "islamisk kalender, astronomisk" },
            { "type.ca.islamic-civil", "islamisk civil kalender" },
            { "type.ca.islamic-umalqura", "islamisk kalender, Umm al-Qura" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
        };
        return data;
    }
}
