/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nqo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_nqo = "ߒߞߏ";
        final Object[][] data = new Object[][] {
            { "001", "ߞߌߢߍ߲߫" },
            { "002", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫" },
            { "003", "ߊߡߋߙߌߞߌ߬ ߞߐ߬ߘߎ߮" },
            { "005", "ߊߡߋߙߌߞߌ߬ ߥߙߏ߬ߘߎ߮" },
            { "009", "ߟߌ߲ߓߊ߲ߘߎ߯" },
            { "011", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߋ" },
            { "013", "ߊߡߋߙߌߞߌ߬ ߕߊ߲ߓߊ߲" },
            { "014", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߟߋ߬ߓߐ" },
            { "015", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߐ߬ߘߎ߮" },
            { "017", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߕߊ߲ߓߊ߲" },
            { "018", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߥߙߏ߬ߘߎ߮" },
            { "019", "ߊߡߋߙߌߞߌ߬" },
            { "021", "ߞߐ߰ߘߎ߮ ߊߡߋߙߌߞߌ߬" },
            { "029", "ߞߙߊߦߌߓ" },
            { "030", "ߊߖ߭ߌ߫ ߕߟߋ߬ߓߐ" },
            { "034", "ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮" },
            { "035", "ߊߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮-ߕߟߋ߬ߓߐ" },
            { "039", "ߋߙߐߔߎ߬ ߥߙߏ߬ߘߎ߮" },
            { "053", "ߐߛߑߕߙߊߟߊߖ߭ߌ߫" },
            { "054", "ߡߋߟߊߣߋߖ߭ߌ߫" },
            { "057", "ߡߌߞߙߏߣߋߖ߭ߌ߫ ߕߌ߲߬ߞߎߘߎ߲" },
            { "061", "ߔߏߟߣߋߖ߭ߌ߫" },
            { "142", "ߊߖ߭ߌ߫" },
            { "143", "ߊߖ߭ߌ߫ ߕߊ߲ߓߊ߲" },
            { "145", "ߊߖ߭ߌ߫ ߕߟߋ߬ߓߋ" },
            { "150", "ߋߙߐߔߎ߬" },
            { "151", "ߋߙߐߔߎ߬ ߕߟߋ߬ߓߐ" },
            { "154", "ߋߙߐߔߎ߬ ߞߐ߬ߘߎ߮" },
            { "155", "ߋߙߐߔߎ߬ ߕߟߋ߬ߓߋ" },
            { "202", "ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߌ߬ߢߍ߬ߞߏ߲ߞߏ߫ ߘߎ߰ߟߊ߬-ߖߡߊߣߊ" },
            { "419", "ߊߡߋߙߞߌ߬ ߟߊ߬ߕߍ߬ߡߊ߬ ߦߙߐ" },
            { "AC", "ߊߛߊ߲ߛߌߦߐ߲߫ ߕߌ߲" },
            { "AD", "ߊ߲ߘߐߙ" },
            { "AE", "ߋߡߌߙߊߕ ߊߙߊߓߎ߫ ߘߍ߬ߣߍ߲" },
            { "AF", "ߊߝߎߜ߭ߊߣߌߛߑߕߊ߲߫" },
            { "AG", "ߊ߲ߕߌߞߎߥߊ߫ ߣߌ߫ ߓߊߙߑߓߎߘߊ߫" },
            { "AI", "ߊ߲ߞߎ߳ߟߊ߫" },
            { "AL", "ߊߟߑߓߊߣߌ߫" },
            { "AM", "ߊߙߑߡߋߣߌ߫" },
            { "AO", "ߊ߲ߜߏߟߊ߫" },
            { "AQ", "ߊ߲ߕߊߙߑߛߕߌߞ" },
            { "AR", "ߊߙߑߖ߭ߊ߲ߕߌߣ" },
            { "AS", "ߛߊߡߏߥߊ߫ ߊߡߋߙߞߌߞߊ" },
            { "AT", "ߏߕߑߙߌߛ" },
            { "AU", "ߐߛߑߕߙߊߟߌ߫" },
            { "AW", "ߊߙߎߓߊ߫" },
            { "AX", "ߊߟߊ߲ߘ ߕߌ߲" },
            { "AZ", "ߊߖߊߙߑߓߊߦߌߖߊ߲" },
            { "BA", "ߓߐߛߑߣߌ߫-ߍߙߑߖ߭ߋߜ߭ߏߝ߭ߌߣ" },
            { "BB", "ߓߊߙߑߓߊߘ" },
            { "BD", "ߓߊ߲ߜ߭ߑߟߊߘߍߛ" },
            { "BE", "ߓߍߟߑߖ߭ߌߞ" },
            { "BF", "ߓߙߎߞߌߣߊ߫ ߝߊ߬ߛߏ߫" },
            { "BG", "ߓߌߟߑߜ߭ߊ߯ߙߌ߫" },
            { "BH", "ߓߤߊ߬ߙߊߦߌ߬ߣ" },
            { "BI", "ߓߎߙߎ߲ߘߌ߫" },
            { "BJ", "ߓߋߣߍ߲߫" },
            { "BL", "ߛߍ߲ߕ-ߓߌߙߑߕߟߋߡߌ߫" },
            { "BM", "ߓߍߙߑߓߎߘ" },
            { "BN", "ߓߙߎߣߋ߫" },
            { "BO", "ߓߏߟߝ߭ߌ߫" },
            { "BQ", "ߤߏߟߊ߲ߘ ߞߊߙߌߓߋ߫" },
            { "BR", "ߓߙߋߖ߭ߌߟ" },
            { "BS", "ߓߤߊߡߊߛ" },
            { "BT", "ߓߎߕߊ߲߫" },
            { "BV", "ߓߎߝ߭ߋ߫ ߕߌ߲" },
            { "BW", "ߓߐߛߎߥߣߊ߫" },
            { "BY", "ߓߌߟߏߙߌߛ" },
            { "BZ", "ߓߋߟߌߖ߭" },
            { "CA", "ߞߣߊߘߊ߫" },
            { "CC", "ߞߏߞߏ߫ ߕߌ߲" },
            { "CD", "ߞߏ߲߬ߜ߭ߏ߫-ߞߌ߲ߛߊߛߊ߫" },
            { "CF", "ߕߊ߲ߓߊ߲-ߝߘߊ߬ߝߌ߲߬ߠߊ߫ ߞߊ߲ߓߍ߲" },
            { "CG", "ߞߏ߲߬ߜ߭ߏ߫-ߓߙߊߖ߭ߊ߫" },
            { "CH", "ߛߎߥߌߛ" },
            { "CI", "ߜߋ߲-ߞߐ߰ߖߌ߬ߘߊ" },
            { "CK", "ߞߎߞ ߕߌ߲" },
            { "CL", "ߛ߭ߟߌ߫" },
            { "CM", "ߞߊߡߋߙߎ߲" },
            { "CN", "ߛߌߣ" },
            { "CO", "ߞߏߟߐ߲ߓߌ߫" },
            { "CP", "ߞߟߌߔߍߙߑߕߐ߲߫ ߕߌ߲" },
            { "CR", "ߞߐߛߑߕߊ߫ ߙߌߞߊ߫" },
            { "CU", "ߞߎ߳ߓߊ߫" },
            { "CV", "ߜߙߋߞߎ߲߫-ߝߙߌߛߌ߫" },
            { "CW", "ߞߎߙߛߊߏ߫" },
            { "CX", "ߞߙߌߛߑߕߌߡߊ߫ ߕߌ߲" },
            { "CY", "ߛߌߔߑߙߎ߫" },
            { "CZ", "ߗߍߞ" },
            { "DE", "ߊߟߑߡߊ߲ߘߎ߯" },
            { "DG", "ߖߋߜ߭ߏ߫-ߜ߭ߊߙߑߛߌߦߊ߫" },
            { "DJ", "ߖߌߓߎߕߌ߫" },
            { "DK", "ߘߊߣߌߡߊߙߑߞ" },
            { "DM", "ߘߏߡߣߌߞ" },
            { "DO", "ߘߏߡߣߌߞ ߞߊ߲ߓߍ߲" },
            { "DZ", "ߊߟߑߖ߭ߋߙߌ߫" },
            { "EA", "ߛߋߎߕߊ߫ ߣߌ߫ ߡߋߟߌߣߊ߫" },
            { "EC", "ߕߍߡߊߓߊ߲߮" },
            { "EE", "ߋߛߑߕߏߣߌ߫" },
            { "EG", "ߋߖ߭ߌߔߑߕ" },
            { "EH", "ߞߌ߲߬ߢߍ߬ߞߏ߲ߞߏ߫ ߕߟߋ߬ߓߋ" },
            { "ER", "ߋߙߕߌߙߋ߫" },
            { "ES", "ߊߛߌߔߊ߲߫" },
            { "ET", "ߋߗߏߔߌ߫" },
            { "EU", "ߋߙߐߔߎ߬ ߘߍ߭" },
            { "EZ", "ߋߙߐߔߎ߬ ߞߣߍ" },
            { "FI", "ߝߍ߲ߟߊ߲ߘ" },
            { "FJ", "ߝߖߌ߫" },
            { "FK", "ߡߊߟߎ߲ߌ߲߫ ߕߌ߲" },
            { "FM", "ߡߌߞߙߏߣߋߖ߭ߌ߫" },
            { "FO", "ߝߋߙߏߦߋ߫ ߕߌ߲" },
            { "FR", "ߝߊ߬ߙߊ߲߬ߛߌ߫" },
            { "GA", "ߜ߭ߊߓߐ߲߫" },
            { "GB", "ߡߊ߲߬ߛߊ߬ߟߊ߫ ߟߊߘߍ߬ߣߍ߲" },
            { "GD", "ߜ߭ߙߋߣߊߘ" },
            { "GE", "ߖ߭ߋߐߙߑߖ߭ߌ߫" },
            { "GF", "ߝߊ߲߬ߙߊ߲߬ߛߌ߫ ߜ߭ߎ߳ߦߊߣ" },
            { "GG", "ߜ߭ߋߙߑߣߋߖ߭ߌ߫" },
            { "GH", "ߜ߭ߊ߯ߣߊ߫" },
            { "GI", "ߜ߭ߌߓߙߊߟߑߕߊߙ" },
            { "GL", "ߜ߭ߎߙߎ߲ߟߊ߲ߘ" },
            { "GM", "ߜ߭ߊ߲ߓߌ߫" },
            { "GN", "ߖߌ߬ߣߍ߫" },
            { "GP", "ߜ߭ߎߥߊߘߋߟߎߔ" },
            { "GQ", "ߕߍߡߊߓߊ߲߮-ߖߌ߬ߣߍ߫" },
            { "GR", "ߜ߭ߙߍ߬ߞߌ߬" },
            { "GS", "ߖ߭ߐߙߑߖ߭ߌ߫ ߥߙߏ߬ߘߎ߮ ߣߌ߫ ߛߊ߲ߘߎߥߌߛ ߕߌ߲" },
            { "GT", "ߜ߭ߎߥߊߕߋߡߟߊ߫" },
            { "GU", "ߜ߭ߎߥߊߡ" },
            { "GW", "ߖߌ߬ߣߍ߫ ߓߌߛߊߥߏ߫" },
            { "GY", "ߜ߭ߎߦߊߣ" },
            { "HK", "ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߤߐ߲ߞߐ߲߫" },
            { "HM", "ߡߊߞߑߘߏߣߊߟߑߘ ߕߌ߲" },
            { "HN", "ߤߎ߲ߘߎߙߊ߫" },
            { "HR", "ߞߙߏߥߊߛߌ߫" },
            { "HT", "ߤߊߦߕߌ߫" },
            { "HU", "ߤߐ߲ߜ߭ߙߌ߫" },
            { "IC", "ߞߣߊߙߌ߫ ߕߌ߲" },
            { "ID", "ߍ߲ߘߣߏߖ߭ߌ߫" },
            { "IE", "ߌߙߑߟߊ߲ߘ" },
            { "IL", "ߌߛߑߙߊߍߟ" },
            { "IM", "ߡߊ߲߯ ߕߌ߲" },
            { "IN", "ߌߘߎ߬" },
            { "IO", "ߓߙߌߕߊ߲ߓߊ߫ ߟߊ߫ ߌ߲ߘߎ߫ ߟߌ߲ߓߊ߲ ߞߣߍ" },
            { "IQ", "ߌߙߊߞߌ߬" },
            { "IR", "ߌߙߊ߲߫" },
            { "IS", "ߌߛߑߟߊߘ" },
            { "IT", "ߌߕߊߟߌ߫" },
            { "JE", "ߖߋߙߑߖ߭ߌ߫" },
            { "JM", "ߖ߭ߡߊߦߌߞ" },
            { "JO", "ߖߐߙߑߘߊߣߌ߫" },
            { "JP", "ߖ߭ߊߔߐ߲߫" },
            { "KE", "ߞߋߣߌߦߊ߫" },
            { "KG", "ߞߌߙߑߜ߭ߌߛߑߕߊ߲߫" },
            { "KH", "ߞߊ߲ߓߐߘߑߖ" },
            { "KI", "ߞߙߌߓߊߕߌ߫" },
            { "KM", "ߞߡߐߙ" },
            { "KN", "ߛߍ߲ߕ-ߞߙߌߛߑߕߐߝ ߣߌ߫ ߢߝ߭ߋ߫" },
            { "KP", "ߞߐ߬ߘߎ߮ ߞߏ߯ߙߋ߫" },
            { "KR", "ߕߟߋ߬ߓߋ ߞߏ߯ߙߋ߫" },
            { "KW", "ߞߎ߬ߥߊ߬ߕ" },
            { "KY", "ߓߊ߲߬ߓߊ߬-ߕߌ߲" },
            { "KZ", "ߞߖ߭ߊߞߌߛߑߕߊ߲߫" },
            { "LA", "ߟߊߐߛ" },
            { "LB", "ߟߌߓߊ߲߫" },
            { "LC", "ߛߍ߲ߕ-ߟߎ߳ߛߌ߫" },
            { "LI", "ߟߎߛߑߕߊ߲ߛߑߕߍ߲߫" },
            { "LK", "ߛߙߌߟߊ߲ߞߊ߫" },
            { "LR", "ߟߌߓߋߙߌߦߊ߫" },
            { "LS", "ߟߋߛߕߏ߫" },
            { "LT", "ߟߎߕߎ߳ߦߊߣߌ߫" },
            { "LU", "ߟߎߜ߭ߑߛߊ߲ߓߎ߯ߙ" },
            { "LV", "ߟߋߕߏߣߌ߫" },
            { "LY", "ߟߓߌ߫" },
            { "MA", "ߡߊ߬ߙߐߞߎ߬" },
            { "MC", "ߡߏߣߊߞߏ߫" },
            { "MD", "ߡߐߟߑߘߊߝ߭ߌ߫" },
            { "ME", "ߡߐ߲ߕߣߋߜ߭ߙߏ߫" },
            { "MF", "ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫" },
            { "MG", "ߡߘߊߜ߭ߛߑߞߊ߯ߙ" },
            { "MH", "ߡߊߙߑߛߊߟ ߕߌ߲" },
            { "MK", "ߞߐ߬ߘߎ߮ ߡߊߛߋߘߏߣߌ߫" },
            { "ML", "ߡߊ߬ߟߌ߬" },
            { "MM", "ߡߌߦߊߡߊ߯ߙ ( ߓߙߌߡߊߣߌ߫ )" },
            { "MN", "ߡߐ߲ߜ߭ߐߟߌ߫" },
            { "MO", "ߛߌߣ ߕߌ߲߬ߞߎߘߎ߲߫ ߡߊߡߙߊ߬ߣߍ߲ ߡߞߊߥߏ߫" },
            { "MP", "ߡߊߙߌߦߊߣ ߞߐ߬ߘߎ߮ ߕߌ߲" },
            { "MQ", "ߡߊߙߑߕߣߌߞ" },
            { "MR", "ߡߏߙߌߕߊߣߌ߫" },
            { "MS", "ߡߐ߲ߗߋߙߊ߫" },
            { "MT", "ߡߊߟߑߕ" },
            { "MU", "ߡߏߙߌߛ" },
            { "MV", "ߡߊߟߑߘߌߝ߭" },
            { "MW", "ߡߟߊߥߌ߫" },
            { "MX", "ߡߍߞߑߛߌߞ" },
            { "MY", "ߡߊߟߍߘߎ߯" },
            { "MZ", "ߡߏߖ߭ߊ߲ߓߌߞ" },
            { "NA", "ߣߊߡߌ߲ߓߌ߫" },
            { "NC", "ߞߊߟߋߘߏߣߌ߫-ߞߎߘߊ߫" },
            { "NE", "ߖߋ߬ߟߌ߬ߓߊߘߎ߯" },
            { "NF", "ߣߐߙߑߝߐߟߑߞ" },
            { "NG", "ߖߋ߬ߟߌ߬ߓߊ߬ߟߊ߫" },
            { "NI", "ߣߌߞߙߊߜ߭ߎߥߊ߫" },
            { "NL", "ߤߏߟߊ߲ߘ" },
            { "NO", "ߣߐߙߑߝ߭ߍߖ" },
            { "NP", "ߣߋߔߊߟ" },
            { "NR", "ߣߏ߯ߙߎ߫" },
            { "NU", "ߣߎ߳ߋ߫" },
            { "NZ", "ߖ߭ߋߟߊ߲ߘߌ߫-ߞߎߘߊ߫" },
            { "OM", "ߏߡߊ߲߫" },
            { "PA", "ߔߣߊߡߊ߫" },
            { "PE", "ߔߋߙߎ߫" },
            { "PF", "ߝߊ߬ߙߊ߲߬ߛߌ߫ ߔߏߟߌߣߋߖ߭ߌ߫" },
            { "PG", "ߡߊߡߎߥߊߖ߭ߌ߫ ߖߌ߬ߣߍ߬-ߞߎߘߊ߫" },
            { "PH", "ߝߟߌߔߌ߲ߣ" },
            { "PK", "ߔߊߞߌߛߑߕߊ߲߫" },
            { "PL", "ߔߏߟߐߢ" },
            { "PM", "ߛߍ߲ߕ-ߔߍ߯ߙ ߣߌ߫ ߡߌ߲ߞߋߟߐ߲߫" },
            { "PN", "ߔߌߕߑߞߍ߲ ߕߌ߲" },
            { "PR", "ߔߐߙߑߕߏ߫-ߙߌߞߏ߫" },
            { "PS", "ߔߊߟߍߛߑߕߌߣ ߞߣߍ" },
            { "PT", "ߔߐߙߑߕߎߜ߭ߊߟ" },
            { "PW", "ߔߟߊߐߛ" },
            { "PY", "ߔߙߊߜ߭ߏߦߋ߫" },
            { "QA", "ߞߊߕߊ߯ߙ" },
            { "QO", "ߟߌ߲ߓߊ߲ߘߎ߯ ߕߌ߲߬ߞߎߘߎ߲ ߦߙߐ߫ ߡߊߕߊ߯ߣߍ߲" },
            { "RE", "ߟߊ߬ߘߍ" },
            { "RO", "ߙߎߡߊߣߌ߫" },
            { "RS", "ߛߍߙߑߓߌ߫" },
            { "RU", "ߌߙߌ߬ߛߌ߫" },
            { "RW", "ߙߎߥߊ߲ߘߊ߫" },
            { "SA", "ߛߎ߰ߘߎ߬ߟߊ߫-ߡߊ߲߬ߛߊ߬ߟߊ" },
            { "SB", "ߛߊߟߏߡߐ߲߫ ߕߌ߲" },
            { "SC", "ߛߋߦߌߛߍߟ" },
            { "SD", "ߛߎߘߊ߲߫" },
            { "SE", "ߛߎߥߍߘ" },
            { "SG", "ߛߌ߲ߜ߭ߊߔߎߙ" },
            { "SH", "ߛߍ߲ߕ-ߋߟߍߣ" },
            { "SI", "ߛߑߟߏߝ߭ߋߣߌ߫" },
            { "SJ", "ߛߊߟߑߓߊߙ ߣߌ߫ ߖ߭ߊ߲ ߡߊߦߍ߲߫" },
            { "SK", "ߛߑߟߏߝ߭ߊߞߌ߫" },
            { "SL", "ߛߙߊ߬ߟߏ߲߫" },
            { "SM", "ߛߍߕ-ߡߊߙߍ߲߫" },
            { "SN", "ߛߣߍ߬ߜߊ߯ߟߌ߫" },
            { "SO", "ߛߏߡߊߟߌ߫" },
            { "SR", "ߛߎߙߑߣߊߡ" },
            { "SS", "ߥߙߏ߬ߘߎ߮ ߛߎ߬ߘߊ߲߫" },
            { "ST", "ߛߊߥߕߏߡߋ߫ ߣߌ߫ ߔߑߙߍ߲ߛߌߔ" },
            { "SV", "ߛߊߟߑߝ߭ߊߘߐߙ" },
            { "SX", "ߛߍ߲ߕ-ߡߊߙߑߕߍ߲߫ ( ߤߏߟߊ߲ߘ ߝߊ߲߭ߝߍ߬ )" },
            { "SY", "ߛߙߌ߫" },
            { "SZ", "ߒߛߎߥߊߕߣߌ߫" },
            { "TA", "ߞߎ߲ߓߊ߫ ߕߑߙߌߛߑߕߊ߫" },
            { "TC", "ߕߎߙߑߞߌ߫ ߣߌ߫ ߞߊߦߌߞ" },
            { "TD", "ߗߊߘ" },
            { "TF", "ߝߊ߬ߙߊ߲߬ߛߌ߫ ߘߎ߰ߞߟߏ ߓߊߙߌ ߘߐ߫" },
            { "TG", "ߕߜ߭ߏ߫" },
            { "TH", "ߕߊߦߌߘߎ߯" },
            { "TJ", "ߕߊߖߞߌߛߑߕߊ߲߫" },
            { "TK", "ߕߏߞߋߟߊߏ߫" },
            { "TL", "ߕߌߡߐߙ ߕߟߋ߬ߓߐ߬ߝߊ߲" },
            { "TM", "ߕߎߙߑߞߌߡߋߣߌߛߑߕߊ߲߫" },
            { "TN", "ߕߎߣߖ߭ߌ߫" },
            { "TO", "ߕߏ߲ߜ߭ߊ߫" },
            { "TR", "ߕߎߙߑߞߌ߫" },
            { "TT", "ߕߙߌߣߌߕߋ߫ ߣߌ߫ ߕߏߓߊߜ߭ߏ߫" },
            { "TV", "ߕߎߝ߭ߊߟߎ߫" },
            { "TW", "ߕߊߦߌߥߊ߲߫" },
            { "TZ", "ߕߊ߲ߖ߭ߊߣߌ߫" },
            { "UA", "ߎ߳ߞߑߙߍߣ" },
            { "UG", "ߎߜ߭ߊ߲ߘߊ߫" },
            { "UM", "ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߘߌߣߍ߲߫ ߕߌ߲߫ ߡߊߕߊ߯ߣߍ߲" },
            { "UN", "ߡߊ߲߬ߕߏ߲߫ ߠߊߘߍ߬ߣߍ߲ ߛߌ߬ߝߏ߲߬ߧߊ߬ߟߌ" },
            { "US", "ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲" },
            { "UY", "ߎ߳ߙߑߜ߭ߋߦߌ߫" },
            { "UZ", "ߎߖ߭ߑߓߋߞߌߛߑߕߊ߲߫" },
            { "VA", "ߝ߭ߊߕߌߞߊ߲߫ ߞߊ߬ߝߏ" },
            { "VC", "ߛߍ߲ߕ-ߝ߭ߍߛߊ߲ ߜ߭ߙߋߣߊߘߌ߫" },
            { "VE", "ߝ߭ߣߋߖ߭ߎߦߋߟߊ߫" },
            { "VG", "ߓߙߌߕߊ߲ߓߊ߫ ߕߌ߲߫ ߞߊߓߊ߲" },
            { "VI", "ߞߊ߬ߝߏ߫ ߘߍ߬ߣߍ߲ ߕߌ߲߫ ߞߊߓߊ߲߫" },
            { "VN", "ߝ߭ߌߦߍߕߑߣߊߡ" },
            { "VU", "ߝ߭ߊߣߎߦߊߕߎ߫" },
            { "WF", "ߥߊߟߌߛߌ߫ ߣߌ߫ ߝߕߎߣߊ߫" },
            { "WS", "ߛߊߡߏߥߊ߫" },
            { "XA", "ߔߛߏߘߏ߫ ߊߞߑߛߊ߲" },
            { "XB", "ߔߛߔߘߏ߫-ߓߘߌ߫" },
            { "XK", "ߞߛߏߝ߭ߏ߫" },
            { "YE", "ߦߡߊߣߌ߲߫" },
            { "YT", "ߡߊߦߐߕ" },
            { "ZA", "ߥߙߏ߬ߘߎ߮ ߝߘߊ߬ߝߌ߲߬ߠߊ߫" },
            { "ZM", "ߖ߭ߊ߲ߓߌ߫" },
            { "ZW", "ߖ߭ߌ߲ߓߊߓߏߦߋ߫" },
            { "ZZ", "ߕߌ߲߬ߞߎߘߎ߲߫ ߕߊ߲߬ߠߊߕߍ߰ߓߊߟߌ" },
            { "af", "ߊߝߙߌߞߊ߲߯ߛߑߞߊ߲" },
            { "ak", "ߊߞߊ߲ߞߊ" },
            { "am", "ߊߡߑߤߊߙߌ" },
            { "ar", "ߊߙߓߎߞߊ߲" },
            { "as", "ߊߛߊߡߍߞߊ߲" },
            { "az", "ߊߖߍߙߑߓߊߦߌߖߊߞߊ߲" },
            { "be", "ߓߌߟߏߙߎ߳ߛߌߞߊ߲" },
            { "bg", "ߓߌߟߑߜ߭ߊߙߌߞߊ߲" },
            { "bm", "ߒߞߏ ߡߊߟߌ" },
            { "bn", "ߓߍ߲ߜ߭ߊߟߌߞߊ߲" },
            { "bo", "ߕߌߓߋߕߌߞߊ߲" },
            { "br", "ߓߙߋߕߐ߲ߞߊ߲" },
            { "bs", "ߓߐߛߑߣߌߞߊ߲" },
            { "ca", "ߞߕߊߟߊ߲ߞߊ߲" },
            { "ce", "ߗߋߗߋߣߌߞߊ߲" },
            { "co", "ߞߐߙߑߛߌߞߊ߲" },
            { "cs", "ߗߍߞߌߞߊ߲" },
            { "cu", "ߛߌߟߊߝ߭ߐ߲ߞߊ߲ ߓߊ߬ߕߏ߬ߓߏ߲߬ߞߊ߲" },
            { "cy", "ߜ߭ߟߏߥߊߞߊ߲" },
            { "da", "ߘߊߣߏߥߊߞߊ߲" },
            { "de", "ߊߟߑߡߊ߲ߞߊ߲" },
            { "dz", "ߖ߭ߏ߲ߜ߭ߊߞߊ߲" },
            { "ee", "ߋߥߋߞߊ߲" },
            { "el", "ߜ߭ߙߍ߬ߞߌ߬ߞߊ߲" },
            { "en", "ߊ߲߬ߜߑߟߋ߬ߞߊ߲" },
            { "eo", "ߍߛߑߔߋߙߊ߲ߕߏߞߊ߲" },
            { "es", "ߊߛߌߔߞߊ߲" },
            { "et", "ߍߛߑߕߏߣߌߞߊ߲" },
            { "eu", "ߓߊߛߑߞߌߞߊ߲" },
            { "fa", "ߝߊ߯ߙߛߌߞߊ߲" },
            { "ff", "ߝߎߟߊߞߊ߲" },
            { "fi", "ߝߍߣߏߥߊߞߊ߲" },
            { "fo", "ߝߋߙߏߞߊ" },
            { "fr", "ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲" },
            { "fy", "ߕߟߋ߬ߓߋ ߝߙߌߛߐ߲ߞߊ߲" },
            { "ga", "ߌߙߑߟߊ߲ߘߌߞߊ߲" },
            { "gd", "ߋߞߐߛߌ߬ ߖ߭ߋߏߟߌߞߊ߲" },
            { "gl", "ߜ߭ߊߟߌߛߌߞߊ߲" },
            { "gu", "ߜ߭ߎߖߙߊߞߊ߲" },
            { "gv", "ߡߊߣߏߥߊߞߊ߲" },
            { "ha", "ߤߊߥߎߛߊߞߊ߲" },
            { "he", "ߋߓߙߋߞߊ߲" },
            { "hi", "ߍ߲ߘߎߞߊ߲" },
            { "hr", "ߞߙߏߥߊߛߌߞߊ߲" },
            { "ht", "ߤߊߦߌߕߌ߫ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲" },
            { "hu", "ߤߐ߲ߜ߭ߙߌߞߊ߲" },
            { "hy", "ߊߙߊߡߋߣߌߞߊ߲" },
            { "ia", "ߍ߲ߕߍߙߑߟߌ߲ߜ߭ߏߥߊߞߊ߲" },
            { "id", "ߍ߲ߘߣߏߛߌߞߊ߲" },
            { "ig", "ߊߜߏߞߊ߲" },
            { "ii", "ߛߌߛߎߥߊ߲߫ ߦߌߞߊ߲" },
            { "is", "ߌߛߑߟߊ߲ߘߌߞߊ߲" },
            { "it", "ߌߕߊߟߌߞߊ߲" },
            { "ja", "ߖ߭ߊߔߐ߲ߞߊ߲" },
            { "jv", "ߖ߭ߝ߭ߊߣߊߞߊ߲" },
            { "ka", "ߖ߭ߋߐߙߑߖ߭ߌߞߊ߲" },
            { "ki", "ߞߌߞߌߦߎߞߊ߲" },
            { "kk", "ߞߖ߭ߊߞߌߞߊ߲" },
            { "kl", "ߜ߭ߙߏߟߊ߲ߘߌߞߊ߲" },
            { "km", "ߞߑߡߍߙߑߞߊ߲" },
            { "kn", "ߞߊ߲ߣߊߘߊߞߊ߲" },
            { "ko", "ߞߏߙߋߞߊ߲" },
            { "ks", "ߞߊߛߑߡߙߌߞߊ߲" },
            { "ku", "ߞߎߙߑߘߎߞߊ߲" },
            { "kw", "ߞߐߙߑߣߌߞߌߞߊ߲" },
            { "ky", "ߞߌߙߑߞߌߖ߭ߑߞߊ߲" },
            { "la", "ߟߊ߬ߕߍ߲߬ߞߊ߲" },
            { "lb", "ߟߎߞߑߛߊ߲ߓߎ߯ߙߎߞߊ߲" },
            { "lg", "ߜ߭ߊ߲ߘߊߞߊ߲" },
            { "ln", "ߟߌ߲ߜ߭ߟߊߞߊ߲" },
            { "lo", "ߟߊߏߞߊ߲" },
            { "lt", "ߟߌߕߎ߳ߦߊߣߌߞߊ߲" },
            { "lu", "ߞߊߕߊ߲ߜ߭ߊ߫-ߗߌ߬ߟߎ߬ߓߊ߬ߞߊ߲" },
            { "lv", "ߟߋߕߐ߲ߞߊ߲" },
            { "mg", "ߡߊߟߑߜ߭ߊߛߌߞߊ߲" },
            { "mi", "ߡߊߏߙߌߞߊ߲" },
            { "mk", "ߡߊߛߋߘߏߣߌߞߊ߲" },
            { "ml", "ߡߟߊߦߟߊߡߑߞߊ߲" },
            { "mn", "ߡߐ߲ߜ߭ߐߟߌߞߊ߲" },
            { "mr", "ߡߙߊߕߌߞߊ߲" },
            { "ms", "ߡߊߟߍߞߊ߲" },
            { "mt", "ߡߊߟߑߕߍߞߊ߲" },
            { "my", "ߓߙߌߡߊ߲ߞߊ߲" },
            { "nb", "ߣߐߙߑߝ߭ߍߖ߭ ߓߏߞߑߡߊߟߑߞߊ߲" },
            { "nd", "ߕߟߋ߬ߓߐ ߒߘߓߋߟߋߞߊ߲" },
            { "ne", "ߣߋߔߌߟߌߞߊ߲" },
            { "nl", "ߣߍ߯ߙߑߟߊ߲ߘߌߞߊ߲" },
            { "nn", "ߣߐߙߑߝ߭ߍߖ߭ ߢߙߐߛߌߞߊ߲" },
            { "no", "ߣߐߙߑߝ߭ߍߖ߭ߌߞߊ߲" },
            { "nv", "ߣߝ߭ߊߖߏߞߊ߲" },
            { "ny", "ߛߋߥߞߊ߲" },
            { "om", "ߏߙߏߡߏߞߊ߲" },
            { "or", "ߏߖߊߞߊ߲" },
            { "os", "ߏߛߍߕߌߞߊ߲" },
            { "pa", "ߔߍ߲ߖߊߓߌߞߊ߲" },
            { "pl", "ߔߟߏߣߍߞߊ߲" },
            { "ps", "ߔߊߛߑߕߏߞߊ߲" },
            { "pt", "ߔߕߏ߬ߞߌ߬ߞߊ߲" },
            { "qu", "ߞߋߛߎߥߊߞߊ߲" },
            { "rm", "ߙߏߡߊ߲ߛߌߞߊ߲" },
            { "rn", "ߙߎ߲ߘߌߞߊ߲" },
            { "ro", "ߙߏߡߍߞߊ߲" },
            { "ru", "ߌ߬ߙߛߌ߬ߞߊ߲" },
            { "rw", "ߞߌ߲ߦߊߙߎߥߊ߲ߘߊߞߊ߲" },
            { "sa", "ߛߊߛߑߞߙߌߞߊ߲" },
            { "sd", "ߛߌ߲ߘߌߞߊ߲" },
            { "se", "ߛߋߡߌ߫ ߕߟߋ߬ߓߐ߬ߞߊ߲" },
            { "sg", "ߛߊ߲ߜߵߏߞߊ߲" },
            { "si", "ߛߌ߲ߜ߭ߟߊߞߊ߲" },
            { "sk", "ߛߑߟߏߝ߭ߊߞߌߞߊ߲" },
            { "sl", "ߛߑߟߏߝ߭ߋߣߌߞߊ߲" },
            { "sm", "ߛߊߡߏߥߊߞߊ߲" },
            { "sn", "ߛߏߣߊߞߊ߲" },
            { "so", "ߛߏߡߊߟߌߞߊ߲" },
            { "sq", "ߊߟߑߓߊߣߌߞߊ߲" },
            { "sr", "ߛߍߙߑߓߌߞߊ߲" },
            { "st", "ߛߕߏ߫ ߥߙߏ߬ߘߎ߰ߞߊ߲" },
            { "su", "ߛߎ߲ߘߣߊߞߊ߲" },
            { "sv", "ߛߎߥߍߘߌߞߊ߲" },
            { "sw", "ߛߎߥߊߤߟߌߞߊ߲" },
            { "ta", "ߕߊߡߎߟߌߞߊ߲" },
            { "te", "ߕߋߟߎߜ߭ߎߞߊ߲" },
            { "tg", "ߕߊߖߞߌߞߊ߲" },
            { "th", "ߕߊߦߌߞߊ߲" },
            { "ti", "ߕߜ߭ߌߙߌߢߊߞߊ߲" },
            { "tk", "ߕߎߙߞߌߡߍߣߌߞߊ߲" },
            { "to", "ߕߏ߲ߖ߭ߌߞߊ߲" },
            { "tr", "ߕߙߎߞߌߞߊ߲" },
            { "tt", "ߕߊߕߊߙߌߞߊ߲" },
            { "ug", "ߥߌߜ߭ߎ߯ߙߎߞߊ߲" },
            { "uk", "ߎߞߌߙߍߣߌߞߊ߲" },
            { "ur", "ߎߙߘߎߞߊ߲" },
            { "uz", "ߎߖ߭ߑߓߋߞߌߞߊ߲" },
            { "vi", "ߝ߭ߌߦߋߕߌߣߊߡߌߞߊ߲" },
            { "vo", "ߝ߭ߏߟߊߔߎߞߊ߲" },
            { "wo", "ߥߟߐߝߐߞߊ߲" },
            { "xh", "ߛߏߖ߭ߊߞߊ߲" },
            { "yi", "ߦߘߌߛߌߞߊ߲" },
            { "yo", "ߙߦߏߓߊߞߊ߲" },
            { "zh", "ߛߣߌߥߊߞߊ߲" },
            { "zu", "ߖ߭ߟߎߞߊ߲" },
            { "agq", "ߊߜ߭ߍߡߑߞߊ߲" },
            { "asa", "ߊߖ߭ߎߞߊ߲" },
            { "ast", "ߊߛߑߕߎߙߌߞߊ߲" },
            { "bal", "ߓߊߟߎߗߌߞߊ߲" },
            { "bas", "ߓߛߊߞߊ߲" },
            { "bem", "ߓߋ߲ߓߊߞߊ߲" },
            { "bew", "ߓߋߕߊߥߌߞߊ߲" },
            { "bez", "ߓߋߣߊߞߊ߲" },
            { "blo", "ߊߣߌ߯ߞߊ߲" },
            { "brx", "ߓߏߘߏߞߊ߲" },
            { "ccp", "ߞߏߘߊ߫ ߗߊߜ߭ߑߡߊߞߊ߲" },
            { "ceb", "ߛߋߓߎߥߊߞߊ߲" },
            { "cgg", "ߞߌߜ߭ߊߞߊ߲" },
            { "chr", "ߗߋߙߏߞߌߞߊ߲" },
            { "ckb", "ߛߏߙߊߣߌߞߊ߲" },
            { "dav", "ߕߊߦߌߕߊߞߊ߲" },
            { "dje", "ߖ߭ߍߙߑߡߊߞߊ߲" },
            { "doi", "ߘߏߜ߭ߙߌߞߊ߲" },
            { "dsb", "ߛߏߙߊߓ-ߓߊߛߑߞߊ߲" },
            { "dua", "ߘߎߥߟߊߞߊ߲" },
            { "dyo", "ߝߐߢߌ߫ ߖߏ߬ߟߊ߬ߞߊ߲" },
            { "ebu", "ߋ߲ߓߎߞߊ߲" },
            { "ewo", "ߋߥߏ߲ߘߏߞߊ߲" },
            { "fil", "ߝߟߌߔߌ߲ߞߊ߲" },
            { "frc", "ߞߊߘߌ߫ ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲" },
            { "fur", "ߝߙߌߥߎߟߊߞߊ߲" },
            { "gsw", "ߛߥߌߛߌ߬ ߊߟߑߡߊ߲ߞߊ߲" },
            { "guz", "ߜߎ߭ߛߌߞߊ߲" },
            { "haw", "ߤߥߊߦߌߞߊ߲" },
            { "hmn", "ߡߐ߲ߜ߭ߑߞߊ߲" },
            { "hsb", "ߛߏߙߊߓߎ߫ ߛߊ߲ߘߐ߫ ߞߊ߲" },
            { "jgo", "ߒߜ߭ߏ߲ߓߊߞߊ߲" },
            { "jmc", "ߡߊߗߊߡߋߞߊ߲" },
            { "kab", "ߞߊߓߟߌߞߊ߲" },
            { "kam", "ߞߊ߲ߓߊߞߊ߲" },
            { "kde", "ߡߊߞߐ߲ߘߋߞߊ߲" },
            { "kea", "ߜߙߋߞߎ߲ߝߙߌߛߌߞߊ߲" },
            { "kgp", "ߞߍ߲ߜ߭ߊ߲ߞߊ߲" },
            { "khq", "ߞߏߙߌߦߊߗߣߌߞߊ߲" },
            { "kkj", "ߞߊߞߏߞߊ߲" },
            { "kln", "ߞߊߟߊ߲ߖߌߞߊ߲" },
            { "kok", "ߞߐ߲ߞߊߣߌߞߊ߲" },
            { "ksb", "ߛߊ߲ߓߟߊߞߊ߲" },
            { "ksf", "ߓߊߝߌߞߊ߲" },
            { "ksh", "ߞߐߟߑߗߌߞߊ߲" },
            { "lag", "ߟߊ߲ߖߌߞߊ߲" },
            { "lij", "ߟߌ߭ߎ߳ߙߌߞߊ߲" },
            { "lkt", "ߟߊߞߏߕߊߞߊ߲" },
            { "lou", "ߟߌߖ߭ߌߦߊߣߌ߫ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲" },
            { "lrc", "ߕߟߋ߬ߓߐ ߟߏߙߌߞߊ߲" },
            { "luo", "ߟߎ߳ߏߞߊ߲" },
            { "luy", "ߟߎ߳ߦߌߞߊ߲" },
            { "mai", "ߡߊߗߟߌߞߊ߲" },
            { "mas", "ߡߊ߯ߛߊߞߊ߲" },
            { "mer", "ߡߋߙߎߞߊ߲" },
            { "mfe", "ߡߏߙߌߛ ߕߊ߬ߓߎ߰ߛߌ߬ߞߊ߲" },
            { "mgh", "ߡߊߞߎߞߊ߲" },
            { "mgo", "ߡߋߕߊߞߊ߲" },
            { "mni", "ߡߊߣߌߔߎߙߌߞߊ߲" },
            { "mua", "ߡߎ߲ߘߊ߲ߞߊ߲" },
            { "mul", "ߞߊ߲ߥߙߍߞߊ߲" },
            { "mzn", "ߡߊߖ߭ߊ߲ߘߋߙߊߣߞߊ߲" },
            { "naq", "ߣߡߊߞߊ߲" },
            { "nds", "ߊߟߑߡߊ߲ߘߎ߯-ߓߊߛߑߞߊ߲" },
            { "nmg", "ߒߜ߭ߎ߲ߓߊߞߊ߲" },
            { "nnh", "ߒߖߋ߲ߓߎ߲ߞߊ߲" },
            { "nqo", metaValue_nqo },
            { "nus", "ߣߎߦߋߞߊ߲" },
            { "nyn", "ߢߊ߲ߞߏߟߋߞߊ߲" },
            { "pap", "ߔߊߔߌߦߊߡߊ߲ߕߏߞߊ߲" },
            { "pcm", "ߖߋ߬ߟߌ߬ߓߊߟߊ߫ ߔߌߘߑߜ߭ߍ߲ߞߊ߲" },
            { "prg", "ߔߎߙߛߌߞߊ߲" },
            { "rhg", "ߙߏߤߌ߲ߜ߭ߊ" },
            { "rof", "ߙߏ߲ߓߏߞߊ߲" },
            { "rwk", "ߙߥߊߞߊ߲" },
            { "sah", "ߌߦߊߞߎߕߌߞߊ߲" },
            { "saq", "ߛߊ߲ߓߙߎߞߊ߲" },
            { "sat", "ߛߊ߲ߕߊߟߌߞߊ߲" },
            { "sbp", "ߌߛߊ߲ߜ߭ߎߞߊ߲" },
            { "scn", "ߛߌߛߟߌߦߊߞߊ߲" },
            { "seh", "ߛߌߛߋߣߊߞߊ߲" },
            { "ses", "ߞߏߦߌߙߊߓߙߏ߫ ߛߋߣߌߞߊ߲" },
            { "shi", "ߗߑߟߋߥߎߞߊ߲" },
            { "smn", "ߌߣߊߙߌ߫ ߛߊߡߌߞߊ߲" },
            { "teo", "ߕߋߛߏߞߊ߲" },
            { "tig", "ߕߌߜ߭ߙߋߞߊ߲" },
            { "twq", "ߕߛߊߥߊߜ߭ߌߞߊ߲" },
            { "tzm", "ߊߕߌߟߊ߲ߕߊ߫ ߕߊ߲ߓߊ߲ ߊߡߊ߲ߖ߭ߌ߲ߞߊ߲" },
            { "und", "ߞߊ߲߫ ߘߊ߲߬ߠߊ߬ߕߍ߰ߓߊߟߌ" },
            { "vai", "ߒߝ߭ߊߦߌ߲ߞߊ߲" },
            { "vec", "ߝ߭ߣߋߛߌߦߊߞߊ߲" },
            { "vun", "ߝ߭ߎߖߏߞߊ߲" },
            { "wae", "ߥߊߟߑߛߍߙߌߞߊ߲" },
            { "xog", "ߛߏߜ߭ߊߞߊ߲" },
            { "yav", "ߦߊ߲ߜߌߞߊ߲" },
            { "yue", "ߞߊ߲ߕߏߣߊߞߊ߲" },
            { "zgh", "ߡߊ߬ߙߐߞߎ߬ ߢߊߓߘߍߡߊ" },
            { "zxx", "ߞߊ߲߫ ߘߐߞߏߟߏ߲" },
            { "Adlm", "ߊߘߑߟߊߡ" },
            { "Aghb", "ߊߜ߭ߑߓߊߣߌ" },
            { "Ahom", "ߊߤߏ߲" },
            { "Arab", "ߊߙߊߓߎ" },
            { "Aran", "ߣߊߛߑߕߊߟߌߞ" },
            { "Armi", "ߝߊ߰ߡߊ߬ߟߊ-ߊߙߊߡߋ" },
            { "Armn", "ߊߙߌߡߋߣߌ" },
            { "Avst", "ߊߝ߭ߋߛߑߕߌ" },
            { "Bali", "ߓߊߟߌߣߍ" },
            { "Bamu", "ߓߊߡߎ߲" },
            { "Bass", "ߓߊ߯ߛߊ" },
            { "Batk", "ߓߕߊߞ" },
            { "Beng", "ߓߍ߲ߜ߭ߊߟߌ" },
            { "Bhks", "ߓߊߦߌߞߑߛߎߞߌ" },
            { "Bopo", "ߔߓߏߡߝߏ" },
            { "Brah", "ߓߑߙߊߤߡߌ" },
            { "Brai", "ߓߑߙߊߦߌ" },
            { "Bugi", "ߓߎߜ߭ߌ" },
            { "Buhd", "ߓߎߤߌߘ" },
            { "Cakm", "ߗߍߞߑߡߊ" },
            { "Cans", "ߞߣߊߘߊ߫ ߘߎ߰ߙߋ߲߬ ߛߓߍ߬ߛߎ߲߬ ߞߝߊ ߟߊߘߍ߬ߣߍ߲" },
            { "Cari", "ߞߊ߯ߙߌ" },
            { "Cham", "ߛߊ߲" },
            { "Cher", "ߛߋߙߐߞ" },
            { "Chrs", "ߞߏߙߊߦߌߛߑߡߌ" },
            { "Copt", "ߞߐߔߑߕ" },
            { "Cpmn", "ߛߌߔߙߏ-ߡߌߣߏߞߊ" },
            { "Cprt", "ߛߔߙߌߐߕ ߜߋ߲߬ߞߝߊ" },
            { "Cyrl", "ߛߙߌߟߌߞ" },
            { "Deva", "ߘߋߝ߭ߣߊߜ߭ߊߙߌ߫" },
            { "Diak", "ߊߞߎ߯ߙߎ" },
            { "Dogr", "ߘߏߜ߭ߑߙߌ" },
            { "Dsrt", "ߘߖ߭ߋߙߋ" },
            { "Dupl", "ߛߑߕߋߣߏߜ߭ߙߊߝߌ ߘߎߔߑߟߏߦߋ" },
            { "Egyp", "ߋߖ߭ߌߔߑߕ ߤߌߙߏߜ߭ߟߌߝߌ" },
            { "Elba", "ߍߟߑߓߊߛߊ߲" },
            { "Elym", "ߋߟߌߡߊߦߌߞ" },
            { "Ethi", "ߋߗߏߔߌߞ" },
            { "Geor", "ߖ߭ߐߙߑߖ߭ߌߞߊ" },
            { "Glag", "ߜ߭ߑߟߊߜ߭ߏߟߌߕߌߞ" },
            { "Gong", "ߜ߭ߏ߲ߖߌ߫ ߜ߭ߎ߲ߖߋߟߊ ߘߐ߫" },
            { "Gonm", "ߡߛߊߙߊ߲߫-ߜ߭ߏ߲ߘߌ" },
            { "Goth", "ߜ߭ߏߕߌߞ" },
            { "Gran", "ߜ߭ߑߙߊ߲ߗߊ" },
            { "Grek", "ߜ߭ߙߍ߬ߞߌ" },
            { "Gujr", "ߜ߭ߎߖߙߊߕߌ" },
            { "Guru", "ߜ߭ߎߙߑߡߎߞߌ" },
            { "Hanb", "ߤߊ߲߫ ߓߔߏߡߝߏ ߘߐ߫" },
            { "Hang", "ߤߊ߲ߜ߭ߎ" },
            { "Hani", "ߛߌߣߏߜ߭ߙߊߡ" },
            { "Hano", "ߤߊߣߎߣߏ" },
            { "Hans", "ߘߐߞߣߍߣߍ߲" },
            { "Hant", "ߦߋߢߐ߲߯ߠߊ" },
            { "Hatr", "ߤߊߕߙߋߣߌ" },
            { "Hebr", "ߋߓߙߋ" },
            { "Hira", "ߤߌߙߊߜ߭ߣߊ" },
            { "Hluw", "ߤߕߌ-ߤߙߏߜ߭ߟߌߝߌ" },
            { "Hmng", "ߔߤߊߥ ߡߐ߲ߜ߭" },
            { "Hmnp", "ߢߊߞߋ߲ߜ߭ ߔߎߛߑߡߐ߲ߜ߭" },
            { "Hrkt", "ߞߊߕߊ߲ߞߣߊ" },
            { "Hung", "ߤߐ߲ߜ߭ߙߌ߫ ߞߘߐ߬ߡߊ߲" },
            { "Ital", "ߌߕߊߟߌߞ ߞߘߐ߬ߡߊ߲" },
            { "Jamo", "ߖߡߏ" },
            { "Java", "ߖ߭ߝ߭ߊߣߍߛ" },
            { "Jpan", "ߣߌߔߐ߲߫" },
            { "Kali", "ߞߦߊߟߌ߫" },
            { "Kana", "ߞߕߊߞߣߊ" },
            { "Khar", "ߞߊߙߏߗߌ߮" },
            { "Khmr", "ߞߑߡߍߙ" },
            { "Khoj", "ߞߏߖߞߌ" },
            { "Kits", "ߞߌߕߊ߲߫ ߛߓߍߟߌߣߍ߲" },
            { "Knda", "ߞߌߡߍߙ" },
            { "Kore", "ߞߏߙߋ߫" },
            { "Kthi", "ߞߊߦߌߗߌ߮" },
            { "Lana", "ߟߣߊ" },
            { "Laoo", "ߟߊߏ" },
            { "Latn", "ߟߊ߬ߕߍ߲" },
            { "Lepc", "ߟߋߔߑߛߊ" },
            { "Limb", "ߟߌ߲ߓߎ" },
            { "Lina", "ߟߌߣߍ߯ߙ ߊ" },
            { "Linb", "ߟߌߣߍ߯ߙ ߓ" },
            { "Lisu", "ߟߌߛߎ" },
            { "Lyci", "ߟߛߌ" },
            { "Lydi", "ߟߘߌ" },
            { "Mahj", "ߡߤߊߖߊߣߌ" },
            { "Maka", "ߡߞߊߛߊ߯ߙ" },
            { "Mand", "ߡߊ߲߬ߘߋ߲߬ߞߊ ߡߋߛߔߏߕߊߡߌ߫" },
            { "Mani", "ߡߊߣߌߛߋ" },
            { "Marc", "ߡߊߙߑߛߋ" },
            { "Medf", "ߡߋߘߑߝߘߌߙߌ߲" },
            { "Mend", "ߡߍ߲߬ߘߋ" },
            { "Merc", "ߡߋߞߙߏߕߌߞ ߞߎ߳ߙߑߛߌߝ" },
            { "Mero", "ߡߋߙߏߦߕߌߞ" },
            { "Mlym", "ߡߟߊߦߊߟߊ߲" },
            { "Modi", "ߡߏߘߌ" },
            { "Mong", "ߡߐ߲ߜ߭ߐߟ" },
            { "Mroo", "ߡߑߙߏ" },
            { "Mtei", "ߡߋߦߌߕߋ ߡߊߦߌߞ" },
            { "Mult", "ߡߎߟߑߕߊߣߌ" },
            { "Mymr", "ߓߙߌߡߊ߲" },
            { "Nand", "ߣߊ߲ߘߌߣߜ߭ߊߙߌ" },
            { "Narb", "ߕߟߋ߬ߓߐ-ߊߙߊߓߎ" },
            { "Nbat", "ߣߓߊߕߋ" },
            { "Newa", "ߣߋߥߊ" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "ߣߎ߳ߛߎ" },
            { "Ogam", "ߏߜ߭ߊ߲" },
            { "Olck", "ߏߟߑߗߞߌ" },
            { "Orkh", "ߐߙߑߞߐ߲" },
            { "Orya", "ߏߖߊ" },
            { "Osge", "ߏߛߊߖ߭" },
            { "Osma", "ߎߛߑߡߊߣߌ" },
            { "Ougr", "ߎߜ߭ߎߙ ߞߘߐ߬ߡߊ߲" },
            { "Palm", "ߔߊߟߑߡߙߋߣߌ" },
            { "Pauc", "ߔߊߎ-ߛߌ߲ߤߊߥߎ" },
            { "Perm", "ߡߙߋߡߌ߫ ߞߘߐ߬ߡߊ߲" },
            { "Phag", "ߝߊߜ߭-ߔߊ" },
            { "Phli", "ߝߋ߲ߟߋߥߌ߫ ߛߓߍߟߌ ߟߎ߬" },
            { "Phlp", "ߛߏߕߌߦߋ߫ ߝߋ߲ߟߋߝ߭ߌ" },
            { "Phnx", "ߝߋߣߌߛߌ" },
            { "Plrd", "ߔߏߟߊߙ ߞߊ߲ߡߊߛߙߋߡߊ" },
            { "Prti", "ߔߊߙߑߕ ߛߓߍߟߌ" },
            { "Qaag", "ߖ߭ߊߎߜ߭ߌ" },
            { "Rjng", "ߙߋߖ߭ߊ߲ߜ߭" },
            { "Rohg", "ߤߊߣߝߌ" },
            { "Runr", "ߙߎߣߌߞ" },
            { "Samr", "ߛߡߊߙߌߕߍ߲" },
            { "Sarb", "ߥߙߏ߬ߘߎ߮ ߊߙߊߓߎ߫ ߞߘߐ߬ߡߊ߲" },
            { "Saur", "ߛߏߙߊߗߌߙߊ" },
            { "Sgnw", "ߞߐߙߍߦߊ߫-ߛߓߍߟߌ ߟߎ߬" },
            { "Shaw", "ߛߊߝ߭ߌ" },
            { "Shrd", "ߛߙߊߘߊ" },
            { "Sidd", "ߛߌߘߊߡ" },
            { "Sind", "ߛߌ߲ߘߌ" },
            { "Sinh", "ߛߌ߲ߜ߭ߟߊ" },
            { "Sogd", "ߛߏߜ߭ߑߘߌ" },
            { "Sogo", "ߛߏߜ߭ߑߘߌ ߞߘߐ߬ߡߊ߲" },
            { "Sora", "ߛߏߙߊ ߛߎ߲ߔߍ߲ߜ߭" },
            { "Soyo", "ߛߏߦߏ߲ߓߏ" },
            { "Sund", "ߛߎ߲ߘߣߊ" },
            { "Sylo", "ߛߌߟߏߕߌ ߣߊߜ߭ߑߙߌ" },
            { "Syrc", "ߛߙߌߦߊߞ" },
            { "Tagb", "ߕߜߊߣߎߥߊ" },
            { "Takr", "ߕߊߞߙߌ" },
            { "Tale", "ߕߊߦߌ-ߟߋ߫" },
            { "Talu", "ߕߊߦߌ-ߟߎ߫ ߞߎߘߊ߫" },
            { "Taml", "ߕߊߡߎߟ" },
            { "Tang", "ߕߊ߲ߜ߭ߎߕ" },
            { "Tavt", "ߕߊߦߌ-ߝ߭ߌߋ߫" },
            { "Telu", "ߕߟߋߜ߭ߎ" },
            { "Tfng", "ߕߝߌߣߊߜ߭" },
            { "Tglg", "ߕߜ߭ߊߟ" },
            { "Thaa", "ߕߡߊ" },
            { "Thai", "ߕߊߦߌ" },
            { "Tibt", "ߕߓߌߕߋߕߍ߲" },
            { "Tirh", "ߕߌߙߎߕߊ" },
            { "Tnsa", "ߕߊ߲ߜߑߛߊ߫" },
            { "Toto", "ߕߏߕߏ߫" },
            { "Ugar", "ߎߜ߭ߊߙߕߌߞ" },
            { "Vaii", "ߒߝ߭ߊߦߌ" },
            { "Vith", "ߝ߭ߌߕߑߞߎߜ߭ߌ߫" },
            { "Wara", "ߥߊߙߊ߲ߜ߭ ߛߕߌ" },
            { "Wcho", "ߥߊ߲ߗߏ" },
            { "Xpeo", "ߝߊ߯ߙߛߌ߫ ߞߘߐߡߊ߲" },
            { "Xsux", "ߛߎߡߋߙߏ-ߊߞߊߘߌ" },
            { "Yezi", "ߦߋߖ߭ߘߌ" },
            { "Yiii", "ߦߌ" },
            { "Zanb", "ߖ߭ߣߊߓߊߖ߭ߊ߯ߙ ߝߘߎ߬ߓߍ߲" },
            { "Zinh", "ߤߋߙߌߕߋ" },
            { "Zmth", "ߘߡߊ߬ߟߐ߲ ߛߙߍߛߙߍߦߊߟߌ" },
            { "Zsye", "ߋߡߏߖߌ߬" },
            { "Zsym", "ߕߐ߰ߡߊ߬ߛߙߋ" },
            { "Zxxx", "ߛߓߍߓߊߟߌ" },
            { "Zyyy", "ߞߏߡߎ߲" },
            { "Zzzz", "ߛߓߍߟߌ߫ ߡߊߟߐ߲ߓߊߟߌ" },
            { "de_AT", "ߏߕߑߙߌߛߌ߬ ߊߟߑߡߊߞߊ߲" },
            { "de_CH", "ߛߥߌߛ ߊߟߑߡߊ߲ߞߊ߲" },
            { "en_AU", "ߐߛߑߕߙߊߟߌ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲" },
            { "en_CA", "ߞߣߊߘߊ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲" },
            { "en_GB", "ߓߙߌߕߊ߲ߓߊ߫ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲" },
            { "en_US", "ߊߡߋߙߌߞߌ߬ ߊ߲߬ߜ߭ߑߟߋ߬ߞߊ߲" },
            { "es_ES", "ߊߛߌߔߊ߲߫ ߊߛߌߔߊ߲ߞߊ߲" },
            { "es_MX", "ߡߍߞߑߛߌߞ ߊߛߌߔߊ߲ߞߊ߲" },
            { "fa_AF", "ߘߊߙߌߞߊ߲" },
            { "fr_CA", "ߞߣߊߘߊ߫ ߝߊ߬ߙߊ߲߬ߛߌ߬ߞߊ߲" },
            { "fr_CH", "ߛߥߌߛ ߝߙߊ߬ߛߌ߬ߞߊ߲" },
            { "nl_BE", "ߝߌߟߊߡߊ߲ߞߊ߲" },
            { "pt_BR", "ߓߙߋߖ߭ߌߟ ߔߕߏ߬ߞߌ߬ߞߊ߲" },
            { "pt_PT", "ߋߙߐߔߎ߬ ߔߕߏ߬ߞߌ߬ߞߊ߲" },
            { "ro_MD", "ߡߐߟߑߘߊߝ߭ߌߞߊ߲" },
            { "ar_001", "ߊߙߊߓߎߞߊ߲ ߘߐߞߣߍߣߍ߲" },
            { "es_419", "ߊߡߋߙߌߞߌ߬ ߊߛߌߔߊ߲ߞߊ߲ ߟߊ߬ߕߍ߬ߡߊ" },
            { "nds_NL", "ߤߏߟߊ߲ߘߌ߬ ߓߊߛߊߞߑߛߐ߲ߞߊ߲" },
            { "zh_Hans", "ߛߣߌߥߊߞߊ߲ ߘߐߞߣߍߣߍ߲" },
            { "zh_Hant", "ߛߣߌߥߊߞߊ߲ ߦߋ߲ߢߐ߲߯ߠߊ" },
            { "ListCompositionPattern", "{0}، {1}" },
        };
        return data;
    }
}
