/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kxv_Deva extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रीनविच मीन बेला",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "एपिआ मानांकॉ बेला",
               "",
               "एपिआ डेलाइट बेला",
               "",
               "एपिआ बेला",
               "",
            };
        final String[] Cook = new String[] {
               "कुक द्वीप मानांकॉ बेला",
               "",
               "कुक द्वीप आधा काराँ मासा बेला",
               "",
               "कुक द्वीप बेला",
               "",
            };
        final String[] Cuba = new String[] {
               "क्यूबा मानांकॉ बेला",
               "CST",
               "क्यूबा डेलाइट बेला",
               "CDT",
               "क्यूबा बेला",
               "CT",
            };
        final String[] Fiji = new String[] {
               "प़िजी मानांकॉ बेला",
               "",
               "प़िजी काराँ मासा बेला",
               "",
               "प़िजी बेला",
               "",
            };
        final String[] Gulf = new String[] {
               "गल्प मानांकॉ बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "होव्ड मानांकॉ बेला",
               "",
               "होव्ड काराँ मासा बेला",
               "",
               "होव्ड बेला",
               "",
            };
        final String[] Iran = new String[] {
               "इरान मानांकॉ बेला",
               "",
               "तिरान डेलाइट बेला",
               "",
               "इरान बेला",
               "",
            };
        final String[] Niue = new String[] {
               "नीयू बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ओम्स्क मानांकॉ बेला",
               "",
               "ओम्स्क काराँ मासा बेला",
               "",
               "ओम्स्क बेला",
               "",
            };
        final String[] Peru = new String[] {
               "पेरू मानांकॉ बेला",
               "",
               "पेरू काराँ मासा बेला",
               "",
               "पेरू बेला",
               "",
            };
        final String[] Truk = new String[] {
               "चुक बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "वेक द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "चिली मानांकॉ बेला",
               "",
               "चिली काराँ मासा बेला",
               "",
               "चिली बेला",
               "",
            };
        final String[] China = new String[] {
               "चीन मानांकॉ बेला",
               "CST",
               "चीन डेलाइट बेला",
               "CDT",
               "चीन बेला",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कोकोस द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "डेविस बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "बारतीय मानांकॉ बेला",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जापान मानांकॉ बेला",
               "JST",
               "जापान डेलाइट बेला",
               "JDT",
               "जापान बेला",
               "JT",
            };
        final String[] Korea = new String[] {
               "कोरियाति मानांकॉ बेला",
               "KST",
               "कोरियाति डेलाइट बेला",
               "KST",
               "कोरियाति बेला",
               "KST",
            };
        final String[] Nauru = new String[] {
               "नॉउरु बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "नेपाल बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "पलाउ बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "समोआ मानांकॉ बेला",
               "SST",
               "समोआ डेलाइट बेला",
               "SST",
               "समोआ बेला",
               "SST",
            };
        final String[] Syowa = new String[] {
               "स्योवा बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "टोंगा मानांकॉ बेला",
               "",
               "टोंगा काराँ मासा बेला",
               "",
               "टोंगा बेला",
               "",
            };
        final String[] Alaska = new String[] {
               "अलास्‍का मानांकॉ बेला",
               "AKST",
               "अलास्‍का डेलाइट बेला",
               "AKDT",
               "अलास्का बेला",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "अमेज़न मानांकॉ बेला",
               "",
               "अमेज़न काराँ मासा बेला",
               "",
               "अमेज़न बेला",
               "",
            };
        final String[] Azores = new String[] {
               "अज़ोरेस मानांकॉ बेला",
               "",
               "अज़ोरेस काराँ मासा बेला",
               "",
               "अज़ोरेस बेला",
               "",
            };
        final String[] Bhutan = new String[] {
               "बुटान बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रूनेति दारूस्सलम बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ईस्टर द्वीप मानांकॉ बेला",
               "",
               "ईस्टर द्वीप काराँ मासा बेला",
               "",
               "ईस्टर द्वीप बेला",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "इज़राइल मानांकॉ बेला",
               "IST",
               "इज़राइल डेलाइट बेला",
               "IDT",
               "इज़राइल बेला",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "कोसराए बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "माव्सन बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "मॉस्को मानांकॉ बेला",
               "MSK",
               "मॉस्को काराँ मासा बेला",
               "MSK",
               "मॉस्को बेला",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "पोनापे बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ताहिती बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ताइपे मानांकॉ बेला",
               "CST",
               "ताइपे डेलाइट बेला",
               "CDT",
               "ताइपे बेला",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "तुवालू बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "वोस्तोक बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "वालिस ऑड़े प़्यूचूना बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "अरब मानांकॉ बेला",
               "",
               "अरब डेलाइट बेला",
               "",
               "अरब बेला",
               "",
            };
        final String[] Armenia = new String[] {
               "आर्मेनिया मानांकॉ बेला",
               "",
               "आर्मेनिया काराँ मासा बेला",
               "",
               "आर्मेनिया बेला",
               "",
            };
        final String[] Bolivia = new String[] {
               "बोलीविया बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "च्याताम मानांकॉ बेला",
               "",
               "च्याताम डेलाइट बेला",
               "",
               "च्याताम बेला",
               "",
            };
        final String[] Ecuador = new String[] {
               "इक्वाडोर बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ग्याम्बीयर बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जॉर्जिया मानांकॉ बेला",
               "",
               "जॉर्जिया काराँ मासा बेला",
               "",
               "जॉर्जिया बेला",
               "",
            };
        final String[] Irkutsk = new String[] {
               "इर्कुत्स्क मानांकॉ बेला",
               "",
               "इर्कुत्स्क काराँ मासा बेला",
               "",
               "इर्कुत्स्क बेला",
               "",
            };
        final String[] Magadan = new String[] {
               "मागादान मानांकॉ बेला",
               "",
               "मागादान काराँ मासा बेला",
               "",
               "मागादान बेला",
               "",
            };
        final String[] Myanmar = new String[] {
               "म्यांमार बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "नॉरप़ॉक द्वीप मानांकॉ बेला",
               "",
               "नॉरप़ॉक द्वीप डेलाइट बेला",
               "",
               "नॉरप़ॉक द्वीप बेला",
               "",
            };
        final String[] Noronha = new String[] {
               "प़र्नांर्डो डे नोरोन्हा मानांकॉ बेला",
               "",
               "प़र्नांर्डो डे नोरोन्हा काराँ मासा बेला",
               "",
               "प़र्नांर्डो डे नोरोन्हा बेला",
               "",
            };
        final String[] Reunion = new String[] {
               "रीयूनियन बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "रोथेरा बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "सोलोमन द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "टोकेलाऊ बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरुग्वे मानांकॉ बेला",
               "",
               "उरुग्वे काराँ मासा बेला",
               "",
               "उरुग्वे बेला",
               "",
            };
        final String[] Vanuatu = new String[] {
               "वनुआतू मानांकॉ बेला",
               "",
               "वनुआतू काराँ मासा बेला",
               "",
               "वनुआतू बेला",
               "",
            };
        final String[] Yakutsk = new String[] {
               "याकुत्स्क मानांकॉ बेला",
               "",
               "याकुत्स्क काराँ मासा बेला",
               "",
               "याकुत्स्क बेला",
               "",
            };
        final String[] Atlantic = new String[] {
               "अटलांटिक मानांकॉ बेला",
               "AST",
               "अटलांटिक डेलाइट बेला",
               "AST",
               "अटलांटिक बेला",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राज़ीलिया मानांकॉ बेला",
               "",
               "ब्राज़ीलिया काराँ मासा बेला",
               "",
               "ब्राज़ीलिया बेला",
               "",
            };
        final String[] Chamorro = new String[] {
               "चामोरो मानांकॉ बेला",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "कोलंबिया मानांकॉ बेला",
               "",
               "कोलंबिया काराँ मासा बेला",
               "",
               "कोलंबिया बेला",
               "",
            };
        final String[] Falkland = new String[] {
               "पाक -लेंड द्वीप मानांकॉ बेला",
               "",
               "पाक -लेंड द्वीप काराँ मासा बेला",
               "",
               "पाक -लेंड द्वीप बेला",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेसिया बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "मालदीव बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलान बटोर मानांकॉ बेला",
               "",
               "उलान बटोर काराँ मासा बेला",
               "",
               "उलान बटोर बेला",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्तान मानांकॉ बेला",
               "PKT",
               "पाकिस्तान काराँ मासा बेला",
               "PKST",
               "पाकिस्तान बेला",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "पैराग्वे मानांकॉ बेला",
               "",
               "पैराग्वे काराँ मासा बेला",
               "",
               "पैराग्वे बेला",
               "",
            };
        final String[] Pitcairn = new String[] {
               "पिटकेर्न बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "सकालिन मानांकॉ बेला",
               "",
               "सकालिन काराँ मासा बेला",
               "",
               "सकालिन बेला",
               "",
            };
        final String[] Suriname = new String[] {
               "सूरीनाम बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "अर्जेंटीना मानांकॉ बेला",
               "",
               "अर्जेंटीना काराँ मासा बेला",
               "",
               "अर्जेंटीना बेला",
               "",
            };
        final String[] Christmas = new String[] {
               "क्रिसमस द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ग्यालापागोस ति बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हाँग काँग मानांकॉ बेला",
               "HKT",
               "हाँग काँग काराँ मासा बेला",
               "HKST",
               "हाँग काँग बेला",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "इंडोचाइना बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "किर्गिस्‍तान बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लॉर्ड होवे मानांकॉ बेला",
               "",
               "लॉर्ड होवे डेलाइट बेला",
               "",
               "लॉर्ड होवे बेला",
               "",
            };
        final String[] Marquesas = new String[] {
               "मार्केसस बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "मॉरीसस मानांकॉ बेला",
               "",
               "मॉरीसस काराँ मासा बेला",
               "",
               "मॉरीसस बेला",
               "",
            };
        final String[] Singapore = new String[] {
               "सिंगापुर बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "वेनेज़ुएला बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "वोल्गोग्राड मानांकॉ बेला",
               "MSK",
               "वोल्गोग्राड काराँ मासा बेला",
               "MSK",
               "वोल्गोग्राड बेला",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "अजरबाइजान मानांकॉ बेला",
               "",
               "अजरबाइजान काराँ मासा बेला",
               "",
               "अजरबाइजान बेला",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बांग्लादेस मानांकॉ बेला",
               "",
               "बांग्लादेस काराँ मासा बेला",
               "",
               "बांग्लादेस बेला",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप वर्ड मानांकॉ बेला",
               "",
               "केप वर्ड काराँ मासा बेला",
               "",
               "केप वर्ड बेला",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "वेड़ा हॉपु तिमोर बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "कज़ाकस्तान बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेसेल्स बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ताजिकिस्तान बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उज़्बेकिस्तान मानांकॉ बेला",
               "",
               "उज़्बेकिस्तान काराँ मासा बेला",
               "",
               "उज़्बेकिस्तान बेला",
               "",
            };
        final String[] Afghanistan = new String[] {
               "आपगानिस्तान बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रास्नोयार्स्क मानांकॉ बेला",
               "",
               "क्रास्नोयार्स्क काराँ मासा बेला",
               "",
               "क्रास्नोयार्स्क बेला",
               "",
            };
        final String[] New_Zealand = new String[] {
               "न्यूज़ीलेंड मानांकॉ बेला",
               "NZST",
               "न्यूज़ीलेंड डेलाइट बेला",
               "NZDT",
               "न्यूज़ीलेंड बेला",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "नोवोसिबिर्स्क मानांकॉ बेला",
               "",
               "नोवोसिबिर्स्क काराँ मासा बेला",
               "",
               "नोवोसिबिर्स्क बेला",
               "",
            };
        final String[] Philippines = new String[] {
               "प़िलिपीन मानांकॉ बेला",
               "PST",
               "प़िलिपीन काराँ मासा बेला",
               "PDT",
               "प़िलिपीन बेला",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "व्लादिवोस्तोक मानांकॉ बेला",
               "",
               "व्लादिवोस्तोक काराँ मासा बेला",
               "",
               "व्लादिवोस्तोक बेला",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "बारॉत काजा सामुद्री बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "लाइन द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "न्यूप़ाउंडलेंड मानांकॉ बेला",
               "NST",
               "न्यूप़ाउंडलेंड डेलाइट बेला",
               "NDT",
               "न्यूप़ाउंडलेंड बेला",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनिस्तान मानांकॉ बेला",
               "",
               "तुर्कमेनिस्तान काराँ मासा बेला",
               "",
               "तुर्कमेनिस्तान बेला",
               "",
            };
        final String[] French_Guiana = new String[] {
               "प़्रेंच गुयाना बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "न्यू केलेडोनिया मानांकॉ बेला",
               "",
               "न्यू केलेडोनिया काराँ मासा बेला",
               "",
               "न्यू केलेडोनिया बेला",
               "",
            };
        final String[] South_Georgia = new String[] {
               "दक्षिणी जॉर्जिया बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकातेरिनबर्ग मानांकॉ बेला",
               "",
               "येकातेरिनबर्ग काराँ मासा बेला",
               "",
               "येकातेरिनबर्ग बेला",
               "",
            };
        final String[] Africa_Central = new String[] {
               "मादिनी आप्रिका बेला",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "वेड़ा हॉपु आप्रिका बेला",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "पस्चिम आप्रिका मानांकॉ बेला",
               "WAT",
               "पस्चिम आप्रिका काराँ मासा बेला",
               "WAT",
               "पस्चिम आप्रिका बेला",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ड्यूमोंट डी अर्विले बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "मादिनी युरोप-ति मानांकॉ बेला",
               "CET",
               "मादिनी युरोप-ति काराँ मासा बेला",
               "CEST",
               "मादिनी युरोप-ति बेला",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "वेड़ा हॉपु युरोप-ति मानांकॉ बेला",
               "EET",
               "वेड़ा हॉपु युरोप-ति काराँ मासा बेला",
               "EEST",
               "वेड़ा हॉपु युरोप-ति बेला",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "वेड़ा कुण्पु युरोप-ति मानांकॉ बेला",
               "WET",
               "वेड़ा कुण्पु युरोप-ति काराँ मासा बेला",
               "WEST",
               "वेड़ा कुण्पु युरोप-ति बेला",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मेक्सिकोति पेसिपिक मानांकॉ बेला",
               "MST",
               "मेक्सिकोति पेसिपिक डेलाइट बेला",
               "MDT",
               "मेक्सिकोति पेसिपिक बेला",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "दक्षिण आप्रिका मानांकॉ बेला",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "मादिनी मानांकॉ बेला",
               "CST",
               "मादिनी डेलाइट बेला",
               "CDT",
               "मादिनी बेला",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "वेड़ा हॉपु मानांकॉ बेला",
               "EST",
               "वेड़ा हॉपु डेलाइट बेला",
               "EST",
               "वेड़ा हॉपु बेला",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "पेसिपिक मानांकॉ बेला",
               "PST",
               "पेसिपिक डेलाइट बेला",
               "PDT",
               "पेसिपिक बेला",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "दॉकिणॉ प़्रांस ऑड़े अंटार्कटिक बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "गिल्बर्ट द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हवाति–आल्यूसन मानांकॉ बेला",
               "HST",
               "हवाति–आल्यूसन डेलाइट बेला",
               "HST",
               "हवाति–आल्यूसन बेला",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "प़ीनिक्स द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सेंट पिएरे ऑड़े मिक्वेलान मानांकॉ बेला",
               "",
               "सेंट पिएरे ऑड़े मिक्वेलान डेलाइट बेला",
               "",
               "सेंट पिएरे ऑड़े मिक्वेलान बेला",
               "",
            };
        final String[] America_Mountain = new String[] {
               "हॉर्का मानांकॉ बेला",
               "MST",
               "हॉर्का डेलाइट बेला",
               "MST",
               "हॉर्का बेला",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "मार्सल द्वीप बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "पापुआ न्यू गिनी बेला",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ऑस्‍ट्रेलियाति मादिनी मानांकॉ बेला",
               "ACST",
               "ऑस्‍ट्रेलियाति मादिनी डेलाइट बेला",
               "ACDT",
               "मादिनी ऑस्ट्रेलियाति बेला",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ऑस्‍ट्रेलियाति वेड़ा हॉपु मानांकॉ बेला",
               "AEST",
               "ऑस्‍ट्रेलियाति वेड़ा हॉपु डेलाइट बेला",
               "AEDT",
               "वेड़ा हॉपु ऑस्ट्रेलिया बेला",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ऑस्ट्रेलियाति वेड़ा कुण्पु मानांकॉ बेला",
               "AWST",
               "ऑस्ट्रेलियाति वेड़ा कुण्पु डेलाइट बेला",
               "AWDT",
               "वेड़ा कुण्पु ऑस्ट्रेलिया बेला",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "मध्य इंडोनेसिया बेला",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "वेड़ा हॉपु इंडोनेसिया बेला",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "वेड़ा कुण्पु इंडोनेसिया बेला",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ऑस्‍ट्रेलियाति मादिनी वेड़ा कुण्पु मानांकॉ बेला",
               "",
               "ऑस्‍ट्रेलियाति मादिनी वेड़ा कुण्पु डेलाइट बेला",
               "",
               "ऑस्‍ट्रेलियाति मादिनी वेड़ा कुण्पु बेला",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB", GMT },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire", GMT },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire", GMT },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "आदेन" },
            { "timezone.excity.Asia/Baku", "बाकु" },
            { "timezone.excity.Asia/Dili", "डिलि" },
            { "timezone.excity.Asia/Gaza", "गाज़ा" },
            { "timezone.excity.Asia/Hovd", "होव्ड" },
            { "timezone.excity.Asia/Omsk", "ओम्स्क" },
            { "timezone.excity.Asia/Oral", "ओरल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "अम्मान" },
            { "timezone.excity.Asia/Aqtau", "अक्ताउ" },
            { "timezone.excity.Asia/Chita", "त्सिता" },
            { "timezone.excity.Asia/Dhaka", "ढाका" },
            { "timezone.excity.Asia/Dubai", "दुबति" },
            { "timezone.excity.Asia/Kabul", "काबुल" },
            { "timezone.excity.Asia/Macau", "मकाऊ" },
            { "timezone.excity.Asia/Qatar", "कतर" },
            { "timezone.excity.Asia/Seoul", "सिओल" },
            { "timezone.excity.Asia/Tokyo", "टोक्यो" },
            { "timezone.excity.Asia/Tomsk", "तोम्स्क" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लोम" },
            { "timezone.excity.Asia/Almaty", "अल्माटी" },
            { "timezone.excity.Asia/Anadyr", "अनाडिर" },
            { "timezone.excity.Asia/Aqtobe", "अक्टोबे" },
            { "timezone.excity.Asia/Atyrau", "एतराउ" },
            { "timezone.excity.Asia/Beirut", "बेरुत" },
            { "timezone.excity.Asia/Brunei", "ब्रूनेति" },
            { "timezone.excity.Asia/Hebron", "हेब्रोन" },
            { "timezone.excity.Asia/Kuwait", "कुवेत" },
            { "timezone.excity.Asia/Manila", "मनीला" },
            { "timezone.excity.Asia/Muscat", "मस्कट" },
            { "timezone.excity.Asia/Riyadh", "रियाद" },
            { "timezone.excity.Asia/Saigon", "हो ची मिन्ह सिटी" },
            { "timezone.excity.Asia/Taipei", "तातिपेति" },
            { "timezone.excity.Asia/Tehran", "तेहरान" },
            { "timezone.excity.Asia/Urumqi", "उरूम्की" },
            { "timezone.excity.Etc/Unknown", "पुण्-आँऽ ति गाड़ा" },
            { "timezone.excity.Europe/Kiev", "कीव" },
            { "timezone.excity.Europe/Oslo", "ओस्लो" },
            { "timezone.excity.Europe/Riga", "रीगा" },
            { "timezone.excity.Europe/Rome", "रोम" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "एक्रा" },
            { "timezone.excity.Africa/Cairo", "कायरो" },
            { "timezone.excity.Africa/Ceuta", "सेउटा" },
            { "timezone.excity.Africa/Dakar", "डकार" },
            { "timezone.excity.Africa/Lagos", "लागोस" },
            { "timezone.excity.Africa/Tunis", "ट्यूनिस" },
            { "timezone.excity.America/Adak", "अडक" },
            { "timezone.excity.America/Lima", "लीमा" },
            { "timezone.excity.America/Nome", "नोम" },
            { "timezone.excity.Asia/Baghdad", "बगदाद" },
            { "timezone.excity.Asia/Bahrain", "बहरीन" },
            { "timezone.excity.Asia/Bangkok", "ब्यांगकॉक" },
            { "timezone.excity.Asia/Barnaul", "बर्नोल" },
            { "timezone.excity.Asia/Bishkek", "बिस्केक" },
            { "timezone.excity.Asia/Colombo", "कोलंबो" },
            { "timezone.excity.Asia/Irkutsk", "इर्कुत्स्क" },
            { "timezone.excity.Asia/Jakarta", "जकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कूचिंग" },
            { "timezone.excity.Asia/Magadan", "मागादान" },
            { "timezone.excity.Asia/Nicosia", "निकोसिया" },
            { "timezone.excity.Asia/Rangoon", "यांगॉन" },
            { "timezone.excity.Asia/Tbilisi", "ट्-बिलिसि" },
            { "timezone.excity.Asia/Thimphu", "थिंपू" },
            { "timezone.excity.Asia/Yakutsk", "याकूत्स्क" },
            { "timezone.excity.Asia/Yerevan", "येरेवान" },
            { "timezone.excity.Europe/Kirov", "किरोव" },
            { "timezone.excity.Europe/Malta", "माल्टा" },
            { "timezone.excity.Europe/Minsk", "मिंस्क" },
            { "timezone.excity.Europe/Paris", "पेरिस" },
            { "timezone.excity.Europe/Sofia", "सोप़िया" },
            { "timezone.excity.Europe/Vaduz", "वादुज़" },
            { "timezone.excity.Indian/Cocos", "कोकोस" },
            { "timezone.excity.Pacific/Apia", "एपिया" },
            { "timezone.excity.Pacific/Fiji", "प़िजी" },
            { "timezone.excity.Pacific/Guam", "गुआम" },
            { "timezone.excity.Pacific/Niue", "नीयू" },
            { "timezone.excity.Pacific/Truk", "चक" },
            { "timezone.excity.Pacific/Wake", "वेक" },
            { "timezone.excity.Africa/Asmera", "अस्मारा" },
            { "timezone.excity.Africa/Bamako", "बामाको" },
            { "timezone.excity.Africa/Bangui", "बांगुइ" },
            { "timezone.excity.Africa/Banjul", "ब्यान्जुल" },
            { "timezone.excity.Africa/Bissau", "बिसाऊ" },
            { "timezone.excity.Africa/Douala", "डूआला" },
            { "timezone.excity.Africa/Harare", "हरारे" },
            { "timezone.excity.Africa/Kigali", "किगाली" },
            { "timezone.excity.Africa/Luanda", "लुआंडा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मलाबो" },
            { "timezone.excity.Africa/Maputo", "मापुटो" },
            { "timezone.excity.Africa/Maseru", "मासेरू" },
            { "timezone.excity.Africa/Niamey", "नियामी" },
            { "timezone.excity.America/Aruba", "अरूबा" },
            { "timezone.excity.America/Bahia", "बहिया" },
            { "timezone.excity.America/Belem", "बेलेम" },
            { "timezone.excity.America/Boise", "बॉइसी" },
            { "timezone.excity.America/Jujuy", "जुजोए" },
            { "timezone.excity.America/Sitka", "सिट्का" },
            { "timezone.excity.America/Thule", "तुले" },
            { "timezone.excity.Asia/Ashgabat", "अस्गाबात" },
            { "timezone.excity.Asia/Calcutta", "कोलकाता" },
            { "timezone.excity.Asia/Damascus", "दमास्कस" },
            { "timezone.excity.Asia/Dushanbe", "दुसांबे" },
            { "timezone.excity.Asia/Jayapura", "जयापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमांडू" },
            { "timezone.excity.Asia/Khandyga", "काडिंगा" },
            { "timezone.excity.Asia/Makassar", "मकस्सर" },
            { "timezone.excity.Asia/Qostanay", "कोस्टाने" },
            { "timezone.excity.Asia/Sakhalin", "साकालिन" },
            { "timezone.excity.Asia/Shanghai", "संघाति" },
            { "timezone.excity.Asia/Tashkent", "तासकंत" },
            { "timezone.excity.Asia/Ust-Nera", "यूस्ट–नेरा" },
            { "timezone.excity.Europe/Athens", "एतेन्स" },
            { "timezone.excity.Europe/Berlin", "बर्लिन" },
            { "timezone.excity.Europe/Dublin", "डबलिन" },
            { "timezone.excity.Europe/Jersey", "जर्सी" },
            { "timezone.excity.Europe/Lisbon", "लिस्बन" },
            { "timezone.excity.Europe/London", "लंदन" },
            { "timezone.excity.Europe/Madrid", "म्याड्रिड" },
            { "timezone.excity.Europe/Monaco", "मोनाको" },
            { "timezone.excity.Europe/Moscow", "मॉस्को" },
            { "timezone.excity.Europe/Prague", "प्राग" },
            { "timezone.excity.Europe/Samara", "समारा" },
            { "timezone.excity.Europe/Skopje", "स्कोप्ये" },
            { "timezone.excity.Europe/Tirane", "टाइरेन" },
            { "timezone.excity.Europe/Vienna", "विएना" },
            { "timezone.excity.Europe/Warsaw", "वॉरसॉ" },
            { "timezone.excity.Europe/Zagreb", "ज़ाग्रेब" },
            { "timezone.excity.Europe/Zurich", "ज़्यूरिक़" },
            { "timezone.excity.Indian/Chagos", "चागोस" },
            { "timezone.excity.Indian/Comoro", "कोमोरो" },
            { "timezone.excity.Pacific/Efate", "एप़ेट" },
            { "timezone.excity.Pacific/Nauru", "नाॅउरु" },
            { "timezone.excity.Pacific/Palau", "पलाऊ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अबिदजान" },
            { "timezone.excity.Africa/Algiers", "अल्जीयर्स" },
            { "timezone.excity.Africa/Conakry", "कोनाक्री" },
            { "timezone.excity.Africa/Kampala", "कंपाला" },
            { "timezone.excity.Africa/Mbabane", "म्-बाबाने" },
            { "timezone.excity.Africa/Nairobi", "नाइरोबि" },
            { "timezone.excity.Africa/Tripoli", "त्रिपोली" },
            { "timezone.excity.America/Belize", "बेलीज़" },
            { "timezone.excity.America/Bogota", "बोगोटा" },
            { "timezone.excity.America/Cancun", "क्यानकुन" },
            { "timezone.excity.America/Cayman", "केम्यान" },
            { "timezone.excity.America/Cuiaba", "क्यूआबा" },
            { "timezone.excity.America/Dawson", "डॉसन" },
            { "timezone.excity.America/Denver", "डेनवर" },
            { "timezone.excity.America/Guyana", "गयाना" },
            { "timezone.excity.America/Havana", "हवाना" },
            { "timezone.excity.America/Inuvik", "इनूविक" },
            { "timezone.excity.America/Juneau", "ज्यूनाउ" },
            { "timezone.excity.America/La_Paz", "ला पाज़" },
            { "timezone.excity.America/Maceio", "मेसीओ" },
            { "timezone.excity.America/Manaus", "मनोस" },
            { "timezone.excity.America/Merida", "मेरिडा" },
            { "timezone.excity.America/Nassau", "नासाउ" },
            { "timezone.excity.America/Panama", "पनामा" },
            { "timezone.excity.America/Recife", "रेसाइप़" },
            { "timezone.excity.America/Regina", "रेजिना" },
            { "timezone.excity.Asia/Famagusta", "प़ामागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हाँग काँग" },
            { "timezone.excity.Asia/Jerusalem", "येरुसलेम" },
            { "timezone.excity.Asia/Kamchatka", "कमचत्का" },
            { "timezone.excity.Asia/Pontianak", "पोंटीयांक" },
            { "timezone.excity.Asia/Pyongyang", "प्योंगयांग" },
            { "timezone.excity.Asia/Qyzylorda", "किजिलॉर्डा" },
            { "timezone.excity.Asia/Samarkand", "समरकंद" },
            { "timezone.excity.Asia/Singapore", "सिंगापुर" },
            { "timezone.excity.Asia/Vientiane", "विएनतियान" },
            { "timezone.excity.Europe/Andorra", "अंडोरा" },
            { "timezone.excity.Europe/Saratov", "सारातोव" },
            { "timezone.excity.Europe/Tallinn", "तेलिन" },
            { "timezone.excity.Europe/Vatican", "वेटिकन" },
            { "timezone.excity.Europe/Vilnius", "विल्नियस" },
            { "timezone.excity.Indian/Mayotte", "मायोत्ते" },
            { "timezone.excity.Indian/Reunion", "रीयूनियन" },
            { "timezone.excity.Pacific/Easter", "तिस्टर" },
            { "timezone.excity.Pacific/Kanton", "केंटन" },
            { "timezone.excity.Pacific/Kosrae", "कोसराए" },
            { "timezone.excity.Pacific/Majuro", "माजुरो" },
            { "timezone.excity.Pacific/Midway", "मिडवे" },
            { "timezone.excity.Pacific/Noumea", "नॉमिया" },
            { "timezone.excity.Pacific/Ponape", "पोनपेति" },
            { "timezone.excity.Pacific/Saipan", "सायपान" },
            { "timezone.excity.Pacific/Tahiti", "ताहिती" },
            { "timezone.excity.Pacific/Tarawa", "टारावा" },
            { "timezone.excity.Pacific/Wallis", "वालिस" },
            { "timezone.excity.Africa/Blantyre", "ब्लांटायर" },
            { "timezone.excity.Africa/Djibouti", "जिबूती" },
            { "timezone.excity.Africa/El_Aaiun", "अल आइयून" },
            { "timezone.excity.Africa/Freetown", "प़्रीटाउन" },
            { "timezone.excity.Africa/Gaborone", "गाबोरोन" },
            { "timezone.excity.Africa/Khartoum", "कार्तुम" },
            { "timezone.excity.Africa/Kinshasa", "किंसासा" },
            { "timezone.excity.Africa/Monrovia", "मोनरोविया" },
            { "timezone.excity.Africa/Ndjamena", "द्जामीना" },
            { "timezone.excity.Africa/Sao_Tome", "साओ टोम" },
            { "timezone.excity.Africa/Windhoek", "विंडहोक" },
            { "timezone.excity.America/Antigua", "एंटीगुआ" },
            { "timezone.excity.America/Caracas", "काराकस" },
            { "timezone.excity.America/Cayenne", "कायेन" },
            { "timezone.excity.America/Chicago", "सिकागो" },
            { "timezone.excity.America/Cordoba", "कोर्डोबा" },
            { "timezone.excity.America/Creston", "क्रेस्टन" },
            { "timezone.excity.America/Curacao", "कुराकाओ" },
            { "timezone.excity.America/Detroit", "डेट्रॉयट" },
            { "timezone.excity.America/Godthab", "नुक" },
            { "timezone.excity.America/Grenada", "ग्रेनाडा" },
            { "timezone.excity.America/Halifax", "हेलिपेक्स" },
            { "timezone.excity.America/Iqaluit", "इकालुतिट" },
            { "timezone.excity.America/Jamaica", "जमाइका" },
            { "timezone.excity.America/Managua", "मानागुआ" },
            { "timezone.excity.America/Marigot", "मेरिगोट" },
            { "timezone.excity.America/Mendoza", "मेंडोज़ा" },
            { "timezone.excity.America/Moncton", "मोंकटन" },
            { "timezone.excity.America/Noronha", "नोरोन्हा" },
            { "timezone.excity.America/Ojinaga", "ओकाजीनागा" },
            { "timezone.excity.America/Phoenix", "प़ीनिक्स" },
            { "timezone.excity.America/Tijuana", "तिजुआना" },
            { "timezone.excity.America/Toronto", "टोरंटो" },
            { "timezone.excity.America/Tortola", "टोर्टोला" },
            { "timezone.excity.America/Yakutat", "याकूटाट" },
            { "timezone.excity.Asia/Phnom_Penh", "पनॉम पेन्ह" },
            { "timezone.excity.Atlantic/Azores", "अज़ोरेस" },
            { "timezone.excity.Atlantic/Canary", "क्यानेरी" },
            { "timezone.excity.Atlantic/Faeroe", "प्यारो" },
            { "timezone.excity.Australia/Eucla", "यूक्ला" },
            { "timezone.excity.Australia/Perth", "पर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रूसेल्स" },
            { "timezone.excity.Europe/Budapest", "बुडापेस्ट" },
            { "timezone.excity.Europe/Busingen", "ब्यूसिनजेन" },
            { "timezone.excity.Europe/Chisinau", "चिसीनाउ" },
            { "timezone.excity.Europe/Guernsey", "गर्नसी" },
            { "timezone.excity.Europe/Helsinki", "हेलसिंकी" },
            { "timezone.excity.Europe/Istanbul", "इस्तांबुल" },
            { "timezone.excity.Europe/Sarajevo", "साराजेवो" },
            { "timezone.excity.Indian/Maldives", "मालदीव" },
            { "timezone.excity.Pacific/Chatham", "च्याथम" },
            { "timezone.excity.Pacific/Fakaofo", "प़ाकाओप़ो" },
            { "timezone.excity.Pacific/Gambier", "ग्यामबियर" },
            { "timezone.excity.Pacific/Norfolk", "नॉरप़ॉक" },
            { "timezone.excity.Africa/Bujumbura", "बुजुंबूरा" },
            { "timezone.excity.Africa/Mogadishu", "मोगादिसु" },
            { "timezone.excity.America/Anguilla", "एंग्विला" },
            { "timezone.excity.America/Asuncion", "एसनसियॉन" },
            { "timezone.excity.America/Barbados", "बारबाडोस" },
            { "timezone.excity.America/Dominica", "डोमिनिका" },
            { "timezone.excity.America/Edmonton", "एडमंटन" },
            { "timezone.excity.America/Eirunepe", "तिरुनेपे" },
            { "timezone.excity.America/Mazatlan", "माज़ाटलान" },
            { "timezone.excity.America/Miquelon", "मिकेलॉन" },
            { "timezone.excity.America/New_York", "न्यूयॉर्क" },
            { "timezone.excity.America/Resolute", "रिसोल्यूट" },
            { "timezone.excity.America/Santarem", "सेन्टारेम" },
            { "timezone.excity.America/Santiago", "सेंतिआगो" },
            { "timezone.excity.America/St_Johns", "सेंट जॉन्स" },
            { "timezone.excity.America/St_Kitts", "सेंट किट्स" },
            { "timezone.excity.America/St_Lucia", "सेंट लूसिया" },
            { "timezone.excity.America/Winnipeg", "विनीपेग" },
            { "timezone.excity.Antarctica/Casey", "केसी" },
            { "timezone.excity.Antarctica/Davis", "डेविस" },
            { "timezone.excity.Antarctica/Syowa", "स्योवा" },
            { "timezone.excity.Antarctica/Troll", "ट्रोल" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रास्नोयार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नोवोसिबिर्स्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलानबातर" },
            { "timezone.excity.Asia/Vladivostok", "व्लादिवोस्तोक" },
            { "timezone.excity.Atlantic/Bermuda", "बरमूडा" },
            { "timezone.excity.Atlantic/Madeira", "मडेरा" },
            { "timezone.excity.Atlantic/Stanley", "स्ट्यानली" },
            { "timezone.excity.Australia/Darwin", "डार्विन" },
            { "timezone.excity.Australia/Hobart", "होबार्ट" },
            { "timezone.excity.Australia/Sydney", "सिडनी" },
            { "timezone.excity.Europe/Amsterdam", "एम्स्टर्डम" },
            { "timezone.excity.Europe/Astrakhan", "आस्ट्राकान" },
            { "timezone.excity.Europe/Bucharest", "बुकारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टर" },
            { "timezone.excity.Europe/Ljubljana", "ल्यूबेलजाना" },
            { "timezone.excity.Europe/Mariehamn", "मारियाहैम" },
            { "timezone.excity.Europe/Podgorica", "पोड्गोरिका" },
            { "timezone.excity.Europe/Stockholm", "स्टॉकहोम" },
            { "timezone.excity.Europe/Ulyanovsk", "उल्यानोव्स्क" },
            { "timezone.excity.Europe/Volgograd", "वोल्गोग्राड" },
            { "timezone.excity.Indian/Christmas", "क्रिसमस" },
            { "timezone.excity.Indian/Kerguelen", "करगुलेन" },
            { "timezone.excity.Indian/Mauritius", "मॉरीसस" },
            { "timezone.excity.Pacific/Auckland", "ऑकलेंड" },
            { "timezone.excity.Pacific/Funafuti", "प़्यूनाप़ुटी" },
            { "timezone.excity.Pacific/Pitcairn", "पिटकेर्न" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लांका" },
            { "timezone.excity.Africa/Libreville", "लिब्रेविले" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुमबासी" },
            { "timezone.excity.Africa/Nouakchott", "नुआकचॉट" },
            { "timezone.excity.Africa/Porto-Novo", "पोर्टो-नोवो" },
            { "timezone.excity.America/Anchorage", "एंकरेज" },
            { "timezone.excity.America/Araguaina", "आराग्वेना" },
            { "timezone.excity.America/Boa_Vista", "बोआ विस्ता" },
            { "timezone.excity.America/Catamarca", "काटामार्का" },
            { "timezone.excity.America/Chihuahua", "चिहुआहुआ" },
            { "timezone.excity.America/Fortaleza", "प़ोर्टालेज़ा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस बे" },
            { "timezone.excity.America/Goose_Bay", "गूस बे" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "ग्वायाकील" },
            { "timezone.excity.America/Matamoros", "माटामोरोस" },
            { "timezone.excity.America/Menominee", "मेनोमिनी" },
            { "timezone.excity.America/Monterrey", "मोंटेरेरी" },
            { "timezone.excity.America/Sao_Paulo", "साओ पाउलो" },
            { "timezone.excity.America/St_Thomas", "सेंट तॉमस" },
            { "timezone.excity.America/Vancouver", "व्यान्कूवर" },
            { "timezone.excity.Antarctica/Mawson", "मॉसन" },
            { "timezone.excity.Antarctica/Palmer", "पॉमर" },
            { "timezone.excity.Antarctica/Vostok", "वोस्तोक" },
            { "timezone.excity.Asia/Kuala_Lumpur", "कुआलालंपुर" },
            { "timezone.excity.Asia/Novokuznetsk", "नोवोकुज़्नेत्स्क" },
            { "timezone.excity.Europe/Bratislava", "ब्रातिस्लावा" },
            { "timezone.excity.Europe/Copenhagen", "कोपेनहेगन" },
            { "timezone.excity.Europe/Luxembourg", "लक्ज़मबर्ग" },
            { "timezone.excity.Europe/San_Marino", "सैन मारीनो" },
            { "timezone.excity.Europe/Simferopol", "सिम्प़ेरोपोल" },
            { "timezone.excity.Pacific/Galapagos", "गेलापागोस" },
            { "timezone.excity.Pacific/Kwajalein", "क्वाज़ालीन" },
            { "timezone.excity.Pacific/Marquesas", "मार्केसस" },
            { "timezone.excity.Pacific/Pago_Pago", "पागो पागो" },
            { "timezone.excity.Pacific/Rarotonga", "रारोटोंगा" },
            { "timezone.excity.Pacific/Tongatapu", "टोंगाटापू" },
            { "timezone.excity.Africa/Addis_Ababa", "अदीस अबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्राज़ाविले" },
            { "timezone.excity.Africa/Ouagadougou", "औगाडोगू" },
            { "timezone.excity.America/Costa_Rica", "कोस्टा रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रांड टर्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वाडेलोप" },
            { "timezone.excity.America/Hermosillo", "हर्मोसिल्लो" },
            { "timezone.excity.America/Kralendijk", "क्रालेन्डिजिक" },
            { "timezone.excity.America/Louisville", "लुइसविले" },
            { "timezone.excity.America/Martinique", "मार्टिनिक" },
            { "timezone.excity.America/Metlakatla", "मेट्लेकाट्ला" },
            { "timezone.excity.America/Montevideo", "मोंटेवीडियो" },
            { "timezone.excity.America/Montserrat", "मोंटसेरात" },
            { "timezone.excity.America/Paramaribo", "पारामारिबो" },
            { "timezone.excity.America/Rio_Branco", "रियो ब्रांको" },
            { "timezone.excity.America/St_Vincent", "सेंट विंसेंट" },
            { "timezone.excity.America/Whitehorse", "व्हाइटहोर्स" },
            { "timezone.excity.Antarctica/McMurdo", "म्याकमुर्डो" },
            { "timezone.excity.Antarctica/Rothera", "रोथेरा" },
            { "timezone.excity.Asia/Srednekolymsk", "स्रेद्निकोलिमस्क" },
            { "timezone.excity.Asia/Yekaterinburg", "येकातेरिनबर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रेक्याविक" },
            { "timezone.excity.Atlantic/St_Helena", "सेंट हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडिलेड" },
            { "timezone.excity.Australia/Brisbane", "ब्रिस्बन" },
            { "timezone.excity.Australia/Lindeman", "लिंडेमान" },
            { "timezone.excity.Europe/Isle_of_Man", "आइल ऑप् म्यान" },
            { "timezone.excity.Europe/Kaliningrad", "कालीनिनग्राड" },
            { "timezone.excity.Pacific/Kiritimati", "किरीतिमाति" },
            { "timezone.excity.Africa/Johannesburg", "जोहांसबर्ग" },
            { "timezone.excity.America/El_Salvador", "अल सल्वाडोर" },
            { "timezone.excity.America/Fort_Nelson", "प़ोर्ट नेल्सन" },
            { "timezone.excity.America/Los_Angeles", "लॉस एंजिल्स" },
            { "timezone.excity.America/Mexico_City", "मेक्सिको सिटी" },
            { "timezone.excity.America/Porto_Velho", "पोर्टो वेल्हो" },
            { "timezone.excity.America/Puerto_Rico", "पोर्टो रिको" },
            { "timezone.excity.America/Tegucigalpa", "टेगुसिगल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लॉन्गयरब्येन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप वर्ड" },
            { "timezone.excity.Australia/Lord_Howe", "लॉर्ड होव" },
            { "timezone.excity.Australia/Melbourne", "मेलबोर्न" },
            { "timezone.excity.Indian/Antananarivo", "एंटानानरीवो" },
            { "timezone.excity.Pacific/Guadalcanal", "ग्वाडलकनाल" },
            { "timezone.excity.Africa/Dar_es_Salaam", "दार अस सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लां-सेबलोन" },
            { "timezone.excity.America/Buenos_Aires", "ब्यूनस आयरस" },
            { "timezone.excity.America/Campo_Grande", "क्याम्पो ग्रांडे" },
            { "timezone.excity.America/Danmarkshavn", "डेनमार्कसॉन" },
            { "timezone.excity.America/Dawson_Creek", "डॉसन क्रीक" },
            { "timezone.excity.America/Indiana/Knox", "नॉक्स, इंडियाना" },
            { "timezone.excity.America/Indianapolis", "इंडियानापोलिस" },
            { "timezone.excity.America/Punta_Arenas", "पुंटा एरिनास" },
            { "timezone.excity.America/Rankin_Inlet", "रेंकिन इनलेट" },
            { "timezone.excity.America/Scoresbysund", "इटोकोर्टोरमिट" },
            { "timezone.excity.Antarctica/Macquarie", "मक्वारी" },
            { "timezone.excity.Pacific/Bougainville", "बोगनविले" },
            { "timezone.excity.Pacific/Port_Moresby", "पोर्ट मोरेस्बी" },
            { "timezone.excity.America/Cambridge_Bay", "केम्ब्रिज बे" },
            { "timezone.excity.America/Coral_Harbour", "अटिकोकान" },
            { "timezone.excity.America/Indiana/Vevay", "वेवे, इंडियाना" },
            { "timezone.excity.America/Lower_Princes", "लोअर प्रिंसेस क्वार्टर" },
            { "timezone.excity.America/Port_of_Spain", "पोर्ट ऑप़ स्पेन" },
            { "timezone.excity.America/Santo_Domingo", "सेंटो डोमिंगो" },
            { "timezone.excity.America/St_Barthelemy", "सेंट बार्तेलेमि" },
            { "timezone.excity.America/Swift_Current", "स्विप़्ट करंट" },
            { "timezone.excity.Australia/Broken_Hill", "ब्रोकन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बेहिया बांडेरास" },
            { "timezone.excity.America/Port-au-Prince", "पोर्ट-ऑ-प्रिंस" },
            { "timezone.excity.Atlantic/South_Georgia", "दाॅकिणाॅ जाॅर्जिया" },
            { "timezone.excity.America/Argentina/Salta", "साल्टा" },
            { "timezone.excity.America/Indiana/Marengo", "मारेंगो, इंडियाना" },
            { "timezone.excity.America/Indiana/Winamac", "विनामेक, इंडियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टोकूमन" },
            { "timezone.excity.America/Argentina/Ushuaia", "उसुआइया" },
            { "timezone.excity.America/Indiana/Tell_City", "टेल सिटी, इंडियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "विंसेनेस, इंडियाना" },
            { "timezone.excity.Antarctica/DumontDUrville", "ड्यूमोंट डी अर्विले" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रिओजा" },
            { "timezone.excity.America/Argentina/San_Juan", "स्यान ह्वान" },
            { "timezone.excity.America/Argentina/San_Luis", "स्यान लूति" },
            { "timezone.excity.America/Indiana/Petersburg", "पीटर्सबर्ग, इंडियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मोंटीसेलो, केंटकी" },
            { "timezone.excity.America/North_Dakota/Beulah", "ब्यूला, उतॉरॉ डकोटा" },
            { "timezone.excity.America/North_Dakota/Center", "मादिनी उतॉरॉ डकोटा" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रियो गालेगोस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "न्यू सालेम, उतॉरॉ डकोटा" },
        };
        return data;
    }
}
