/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hsb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujarati";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "001", "swět" },
            { "002", "Afrika" },
            { "003", "Sewjerna Amerika" },
            { "005", "Južna Amerika" },
            { "009", "Oceaniska" },
            { "011", "zapadna Afrika" },
            { "013", "Srjedźna Amerika" },
            { "014", "wuchodna Afrika" },
            { "015", "sewjerna Afrika" },
            { "017", "srjedźna Afrika" },
            { "018", "južna Afrika" },
            { "019", "Amerika" },
            { "021", "sewjerny ameriski kontinent" },
            { "029", "Karibika" },
            { "030", "wuchodna Azija" },
            { "034", "južna Azija" },
            { "035", "juhowuchodna Azija" },
            { "039", "južna Europa" },
            { "053", "Awstralazija" },
            { "054", "Melaneziska" },
            { "057", "Mikroneziska (kupowy region)" },
            { "061", "Polyneziska" },
            { "142", "Azija" },
            { "143", "centralna Azija" },
            { "145", "zapadna Azija" },
            { "150", "Europa" },
            { "151", "wuchodna Europa" },
            { "154", "sewjerna Europa" },
            { "155", "zapadna Europa" },
            { "202", "subsaharaska Afrika" },
            { "419", "Łaćonska Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Zjednoćene arabske emiraty" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanska" },
            { "AM", "Armenska" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentinska" },
            { "AS", "Ameriska Samoa" },
            { "AT", "Awstriska" },
            { "AU", "Awstralska" },
            { "AW", "Aruba" },
            { "AX", "Åland" },
            { "AZ", "Azerbajdźan" },
            { "BA", "Bosniska a Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeš" },
            { "BE", "Belgiska" },
            { "BF", "Burkina Faso" },
            { "BG", "Bołharska" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthélemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei" },
            { "BO", "Boliwiska" },
            { "BQ", "Karibiska Nižozemska" },
            { "BR", "Brazilska" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetowa kupa" },
            { "BW", "Botswana" },
            { "BY", "Běłoruska" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosowe kupy" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralnoafriska republika" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Šwicarska" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Cookowe kupy" },
            { "CL", "Chilska" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbiska" },
            { "CP", "Clippertonowa kupa" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Hodowna kupa" },
            { "CY", "Cypern" },
            { "CZ", "Čěska republika" },
            { "DE", "Němska" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dźibuti" },
            { "DK", "Danska" },
            { "DM", "Dominika" },
            { "DO", "Dominikanska republika" },
            { "DZ", "Algeriska" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estiska" },
            { "EG", "Egyptowska" },
            { "EH", "Zapadna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "Španiska" },
            { "ET", "Etiopiska" },
            { "EU", "Europska unija" },
            { "EZ", "europasmo" },
            { "FI", "Finska" },
            { "FJ", "Fidźi" },
            { "FK", "Falklandske kupy" },
            { "FM", "Mikroneziska" },
            { "FO", "Färöske kupy" },
            { "FR", "Francoska" },
            { "GA", "Gabun" },
            { "GB", "Zjednoćene kralestwo" },
            { "GD", "Grenada" },
            { "GE", "Georgiska" },
            { "GF", "Francoska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönlandska" },
            { "GM", "Gambija" },
            { "GN", "Gineja" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatorialna Gineja" },
            { "GR", "Grjekska" },
            { "GS", "Južna Georgiska a Južne Sandwichowe kupy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gineja-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Wosebita zarjadniska cona Hongkong" },
            { "HM", "Heardowa kupa a McDonaldowe kupy" },
            { "HN", "Honduras" },
            { "HR", "Chorwatska" },
            { "HT", "Haiti" },
            { "HU", "Madźarska" },
            { "IC", "Kanariske kupy" },
            { "ID", "Indoneska" },
            { "IE", "Irska" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "Indiska" },
            { "IO", "Britiski teritorij w Indiskim oceanje" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandska" },
            { "IT", "Italska" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordaniska" },
            { "JP", "Japanska" },
            { "KE", "Kenija" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodźa" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "St. Kitts a Nevis" },
            { "KP", "Sewjerna Koreja" },
            { "KR", "Južna Koreja" },
            { "KW", "Kuwait" },
            { "KY", "Kajmanske kupy" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesotho" },
            { "LT", "Litawska" },
            { "LU", "Luxemburgska" },
            { "LV", "Letiska" },
            { "LY", "Libyska" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawska" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallowe kupy" },
            { "MK", "Serwjerna Makedonska" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolska" },
            { "MO", "Wosebita zarjadniska cona Macao" },
            { "MP", "Sewjerne Mariany" },
            { "MQ", "Martinique" },
            { "MR", "Mawretanska" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajzija" },
            { "MZ", "Mosambik" },
            { "NA", "Namibija" },
            { "NC", "Nowa Kaledoniska" },
            { "NE", "Niger" },
            { "NF", "Norfolkowa kupa" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragua" },
            { "NL", "Nižozemska" },
            { "NO", "Norwegska" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowoseelandska" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francoska Polyneziska" },
            { "PG", "Papuwa-Nowa Gineja" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Pólska" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairnowe kupy" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinski awtonomny teritorij" },
            { "PT", "Portugalska" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Wonkowna Oceaniska" },
            { "RE", "Réunion" },
            { "RO", "Rumunska" },
            { "RS", "Serbiska" },
            { "RU", "Ruska" },
            { "RW", "Ruanda" },
            { "SA", "Sawdi-Arabska" },
            { "SB", "Salomony" },
            { "SC", "Seychelle" },
            { "SD", "Sudan" },
            { "SE", "Šwedska" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Słowjenska" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "Słowakska" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinam" },
            { "SS", "Južny Sudan" },
            { "ST", "São Tomé a Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syriska" },
            { "SZ", "Swaziska" },
            { "TA", "Tristan da Cunha" },
            { "TC", "kupy Turks a Caicos" },
            { "TD", "Čad" },
            { "TF", "Francoski južny a antarktiski teritorij" },
            { "TG", "Togo" },
            { "TH", "Thailandska" },
            { "TJ", "Tadźikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmeniska" },
            { "TN", "Tuneziska" },
            { "TO", "Tonga" },
            { "TR", "Turkowska" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansanija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Ameriska Oceaniska" },
            { "UN", "Zjednoćene narody" },
            { "US", "Zjednoćene staty Ameriki" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanske město" },
            { "VC", "St. Vincent a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britiske knježniske kupy" },
            { "VI", "Ameriske knježniske kupy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-akcenty" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosowo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Južna Afrika (Republika)" },
            { "ZM", "Sambija" },
            { "ZW", "Simbabwe" },
            { "ZZ", "njeznaty region" },
            { "aa", "afaršćina" },
            { "ab", "abchazišćina" },
            { "af", "afrikaanšćina" },
            { "ak", "akanšćina" },
            { "am", "amharšćina" },
            { "an", "aragonšćina" },
            { "ar", "arabšćina" },
            { "as", "asamšćina" },
            { "av", "awaršćina" },
            { "ay", "aymaršćina" },
            { "az", "azerbajdźanšćina" },
            { "ba", "baškiršćina" },
            { "be", "běłorušćina" },
            { "bg", "bołharšćina" },
            { "bi", "bislamšćina" },
            { "bm", "bambara" },
            { "bn", "bengalšćina" },
            { "bo", "tibetšćina" },
            { "br", "bretonšćina" },
            { "bs", "bosnišćina" },
            { "ca", "katalanšćina" },
            { "ce", "čečenšćina" },
            { "ch", "čamoršćina" },
            { "co", "korsišćina" },
            { "cr", "kri" },
            { "cs", "čěšćina" },
            { "cu", "cyrkwinosłowjanšćina" },
            { "cv", "chuvashišćina" },
            { "cy", "walizišćina" },
            { "da", "danšćina" },
            { "de", "němčina" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grjekšćina" },
            { "en", "jendźelšćina" },
            { "eo", "esperanto" },
            { "es", "španišćina" },
            { "et", "estišćina" },
            { "eu", "baskišćina" },
            { "fa", "persišćina" },
            { "ff", "fulbšćina" },
            { "fi", "finšćina" },
            { "fj", "fidźišćina" },
            { "fo", "färöšćina" },
            { "fr", "francošćina" },
            { "fy", "frizišćina" },
            { "ga", "iršćina" },
            { "gd", "šotiska gelšćina" },
            { "gl", "galicišćina" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manšćina" },
            { "ha", "hausa" },
            { "he", "hebrejšćina" },
            { "hi", "hindišćina" },
            { "hr", "chorwatšćina" },
            { "ht", "haitišćina" },
            { "hu", "madźaršćina" },
            { "hy", "armenšćina" },
            { "hz", "hererošćina" },
            { "ia", "interlingua" },
            { "id", "indonešćina" },
            { "ie", "interlinguešćina" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandšćina" },
            { "it", "italšćina" },
            { "iu", "inuitšćina" },
            { "ja", "japanšćina" },
            { "jv", "javašćina" },
            { "ka", "georgišćina" },
            { "ki", "kikuyu" },
            { "kj", "kuanyamašćina" },
            { "kk", "kazachšćina" },
            { "kl", "gröndlandšćina" },
            { "km", "khmeršćina" },
            { "kn", "kannadšćina" },
            { "ko", "korejšćina" },
            { "kr", "kanurišćina" },
            { "ks", "kašmiršćina" },
            { "ku", "kurdišćina" },
            { "kv", "komišćina" },
            { "kw", "kornišćina" },
            { "ky", "kirgišćina" },
            { "la", "łaćonšćina" },
            { "lb", "luxemburgšćina" },
            { "lg", "gandšćina" },
            { "li", "limburšćina" },
            { "ln", "lingala" },
            { "lo", "laošćina" },
            { "lt", "litawšćina" },
            { "lu", "luba-katanga" },
            { "lv", "letišćina" },
            { "mg", "malagassišćina" },
            { "mh", "marshallezišćina" },
            { "mi", "maoršćina" },
            { "mk", "makedonšćina" },
            { "ml", "malajamšćina" },
            { "mn", "mongolšćina" },
            { "mr", "maratišćina" },
            { "ms", "malajšćina" },
            { "mt", "maltašćina" },
            { "my", "burmašćina" },
            { "na", "naurušćina" },
            { "nb", "norwegšćina (bokmål)" },
            { "nd", "sewjero-ndebele" },
            { "ne", "nepalšćina" },
            { "ng", "ndongašćina" },
            { "nl", "nižozemšćina" },
            { "nn", "norwegšćina (nynorsk)" },
            { "no", "norwegšćina" },
            { "nr", "južna ndebelšćina" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "okcitanšćina" },
            { "om", "oromo" },
            { "or", "orijšćina" },
            { "os", "osetšćina" },
            { "pa", "pandźabšćina" },
            { "pl", "pólšćina" },
            { "ps", "paštunšćina" },
            { "pt", "portugalšćina" },
            { "qu", "kečua" },
            { "rm", "retoromanšćina" },
            { "rn", "kirundišćina" },
            { "ro", "rumunšćina" },
            { "ru", "rušćina" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardinšćina" },
            { "sd", "sindhišćina" },
            { "se", "sewjerosamišćina" },
            { "sg", "sango" },
            { "sh", "serbochorwatšćina" },
            { "si", "singhalšćina" },
            { "sk", "słowakšćina" },
            { "sl", "słowjenšćina" },
            { "sm", "samoašćina" },
            { "sn", "šonašćina" },
            { "so", "somališćina" },
            { "sq", "albanšćina" },
            { "sr", "serbišćina" },
            { "ss", "siswati" },
            { "st", "južnosotšćina (Sesotho)" },
            { "su", "sundanezišćina" },
            { "sv", "šwedšćina" },
            { "sw", "suahelšćina" },
            { "ta", "tamilšćina" },
            { "te", metaValue_te },
            { "tg", "tadźikšćina" },
            { "th", "thailandšćina" },
            { "ti", "tigrinšćina" },
            { "tk", "turkmenšćina" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tongašćina" },
            { "tr", "turkowšćina" },
            { "ts", "tsonga" },
            { "tt", "tataršćina" },
            { "tw", "twi" },
            { "ty", "tahitišćina" },
            { "ug", "ujguršćina" },
            { "uk", "ukrainšćina" },
            { "ur", "urdušćina" },
            { "uz", "uzbekšćina" },
            { "ve", "vendašćina" },
            { "vi", "vietnamšćina" },
            { "vo", "volapük" },
            { "wa", "walonšćina" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jidišćina" },
            { "yo", "jorubašćina" },
            { "za", "zhuang" },
            { "zh", "chinšćina" },
            { "zu", "zulušćina" },
            { "ace", "achinezišćina" },
            { "ada", "adangmešćina" },
            { "ady", "adyghešćina" },
            { "agq", "aghemšćina" },
            { "ain", "ainušćina" },
            { "ale", "aleutišćina" },
            { "alt", "južna altaišćina" },
            { "ang", "anglosakšćina" },
            { "ann", "obološćina" },
            { "anp", "angikašćina" },
            { "arn", "arawkanšćina" },
            { "arp", "arapahošćina" },
            { "ars", "najdi arabšćina" },
            { "asa", "pare" },
            { "ast", "asturšćina" },
            { "atj", "atikamekwišćina" },
            { "awa", "awandhišćina" },
            { "ban", "balinezišćina" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bho", "bhojpurišćina" },
            { "bin", "binišćina" },
            { "bla", "siksikášćina" },
            { "blo", "aniišćina" },
            { "brx", "bodo" },
            { "bug", "buginezišćina" },
            { "byn", "blinšćina" },
            { "cay", "cayugašćina" },
            { "ccp", "čakma" },
            { "ceb", "cebuanšćina" },
            { "cgg", "chiga" },
            { "chk", "chuukezišćina" },
            { "chm", "marišćina" },
            { "cho", "choctawšćina" },
            { "chp", "chipewyanšćina" },
            { "chr", "cherokee" },
            { "chy", "cheyennešćina" },
            { "ckb", "sorani" },
            { "clc", "chilcotinšćina" },
            { "crg", "michifšćina" },
            { "crj", "južnowuchodna creešćina" },
            { "crk", "plains creešćina" },
            { "crl", "sewjernowuchodna creešćina" },
            { "crm", "moode creešćina" },
            { "crr", "carolina algonquianšćina" },
            { "csw", "swampy creešćina" },
            { "dak", "dakotašćina" },
            { "dar", "dargwašćina" },
            { "dav", "taita" },
            { "dgr", "dogribšćina" },
            { "dje", "zarma" },
            { "doi", "dogrišćina" },
            { "dsb", "delnjoserbšćina" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazagašćina" },
            { "ebu", "embu" },
            { "efi", "efikšćina" },
            { "eka", "ekajukšćina" },
            { "ewo", "ewondo" },
            { "fil", "filipinšćina" },
            { "fon", "fonšćina" },
            { "frc", "cajun francošćina" },
            { "frr", "sewjernofrizišćina" },
            { "fur", "friulšćina" },
            { "gaa", "gašćina" },
            { "gag", "gagauzišćina" },
            { "gez", "geezišćina" },
            { "gil", "gilbertezišćina" },
            { "gor", "gorontalošćina" },
            { "got", "gotšćina" },
            { "gsw", "šwicarska němčina" },
            { "guz", "gusii" },
            { "gwi", "gwichʼinšćina" },
            { "hai", "haidašćina" },
            { "haw", "hawaiišćina" },
            { "hax", "južna haidašćina" },
            { "hil", "hiligaynonšćina" },
            { "hmn", "hmongšćina" },
            { "hsb", "hornjoserbšćina" },
            { "hup", "hupašćina" },
            { "hur", "halkomelemšćina" },
            { "iba", "ibanšćina" },
            { "ibb", "ibibiošćina" },
            { "ikt", "zapadnokanadska inuktitutšćina" },
            { "ilo", "ilokošćina" },
            { "inh", "ingushišćina" },
            { "jbo", "lojbanšćina" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabylšćina" },
            { "kac", "kachinšćina" },
            { "kaj", "jjušćina" },
            { "kam", "kamba" },
            { "kbd", "kabardianšćina" },
            { "kcg", "tyapšćina" },
            { "kde", "makonde" },
            { "kea", "kapverdšćina" },
            { "kfo", "korošćina" },
            { "kgp", "kaingangšćina" },
            { "kha", "khasišćina" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundušćina" },
            { "koi", "permska komišćina" },
            { "kok", "konkani" },
            { "kpe", "kpellešćina" },
            { "krc", "karachay-balkaršćina" },
            { "krl", "karelianšćina" },
            { "kru", "kurukhšćina" },
            { "ksb", "šambala" },
            { "ksf", "bafia" },
            { "ksh", "kelnšćina" },
            { "kum", "kumykšćina" },
            { "kwk", "kwakʼwalašćina" },
            { "kxv", "kuvišćina" },
            { "lad", "ladinšćina" },
            { "lag", "langi" },
            { "lez", "lezgianšćina" },
            { "lij", "ligurianšćina" },
            { "lil", "lillooetšćina" },
            { "lkt", "lakota" },
            { "lmo", "lombardšćina" },
            { "lou", "Louisiana kreolšćina" },
            { "loz", "lozišćina" },
            { "lrc", "sewjerna lurišćina" },
            { "lsm", "saamiašćina" },
            { "lua", "luba-luluašćina" },
            { "lun", "lundašćina" },
            { "lus", "mizošćina" },
            { "luy", "luhya" },
            { "mad", "madurezišćina" },
            { "mag", "magahišćina" },
            { "mai", "maithilšćina" },
            { "mak", "makasaršćina" },
            { "mas", "masaišćina" },
            { "mdf", "mokshašćina" },
            { "men", "mendišćina" },
            { "mer", "meru" },
            { "mfe", "mauriciska kreolšćina" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "mi'kmaqšćina" },
            { "min", "minangkabaušćina" },
            { "mni", "manipuršćina" },
            { "moe", "innu-aimunšćina" },
            { "moh", "mohawkšćina" },
            { "mos", "mossišćina" },
            { "mua", "mundang" },
            { "mul", "wjacerěčne" },
            { "mus", "krik" },
            { "mwl", "mirandezišćina" },
            { "myv", "erzyašćina" },
            { "mzn", "mazanderanšćina" },
            { "nap", "neapolitanšćina" },
            { "naq", "nama" },
            { "nds", "delnjoněmčina" },
            { "new", "newarišćina" },
            { "nia", "niazišćina" },
            { "niu", "niueanšćina" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaišćina" },
            { "nqo", "n’ko" },
            { "nso", "sewjerna sothošćina" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "sewjernozapadna ojibwašćina" },
            { "ojc", "centralna ojibwašćina" },
            { "ojs", "oji-creešćina" },
            { "ojw", "zapadna ojibwašćina" },
            { "oka", "okanaganšćina" },
            { "pag", "pangasinanšćina" },
            { "pam", "pampangašćina" },
            { "pap", "papiamentošćina" },
            { "pau", "palauanšćina" },
            { "pcm", "nigerijanski pidgin" },
            { "pis", "pijinšćina" },
            { "pqm", "maliseet-passamaquoddyšćina" },
            { "prg", "prušćina" },
            { "quc", "kʼicheʼ" },
            { "raj", "rajasthani" },
            { "rap", "rapanuišćina" },
            { "rar", "rarotonganšćina" },
            { "rhg", "rohingyašćina" },
            { "rof", "rombo" },
            { "rup", "armanianšćina" },
            { "rwk", "rwa" },
            { "sad", "sandawešćina" },
            { "sah", "jakutšćina" },
            { "saq", "samburu" },
            { "sat", "santalšćina" },
            { "sba", "ngambayšćina" },
            { "sbp", "sangu" },
            { "scn", "sicilšćina" },
            { "sco", "scotšćina" },
            { "seh", "sena" },
            { "ses", "koyra senni" },
            { "shi", "tašelhit" },
            { "shn", "shanšćina" },
            { "slh", "južna lushootseedšćina" },
            { "sma", "južnosamišćina" },
            { "smj", "lule-samišćina" },
            { "smn", "inari-samišćina" },
            { "sms", "skolt-samišćina" },
            { "snk", "soninkešćina" },
            { "srn", "sranan tongošćina" },
            { "stq", "saterfrizišćina" },
            { "str", "straits salishšćina" },
            { "suk", "sukumašćina" },
            { "swb", "comorianšćina" },
            { "syr", "syriacšćina" },
            { "szl", "šlezišćina" },
            { "tce", "južna tutchonšćina" },
            { "tem", "timnešćina" },
            { "teo", "teso" },
            { "tet", "tetumšćina" },
            { "tgx", "tagishšćina" },
            { "tht", "tahltanšćina" },
            { "tig", "tigrešćina" },
            { "tlh", "klingonšćina" },
            { "tli", "tlingitšćina" },
            { "tok", "toki ponašćina" },
            { "tpi", "tok pisinšćina" },
            { "trv", "tarokošćina" },
            { "ttm", "sewjerna tutchonšćina" },
            { "tum", "tumbukašćina" },
            { "tvl", "tuvalušćina" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinianšćina" },
            { "tzm", "tamazight (srjedźny Marokko)" },
            { "udm", "udmurtšćina" },
            { "umb", "umbundušćina" },
            { "und", "njeznata rěč" },
            { "vec", "venetišćina" },
            { "vmw", "makhuwašćina" },
            { "vun", "vunjo" },
            { "wae", "walzeršćina" },
            { "wal", "wolayttašćina" },
            { "war", "warayšćina" },
            { "wuu", "wu chinšćina" },
            { "xal", "kalmykšćina" },
            { "xnr", "kangrišćina" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yembašćina" },
            { "yrl", "nheengatušćina" },
            { "yue", "kantonšćina" },
            { "zgh", "tamazight" },
            { "zun", "zunišćina" },
            { "zxx", "žadyn rěčny wobsah" },
            { "zza", "zazašćina" },
            { "Adlm", "adlamske pismo" },
            { "Arab", "arabsce" },
            { "Aran", "nastaliqske pismo" },
            { "Armn", "armensce" },
            { "Beng", "bengalsce" },
            { "Bopo", "bopomofo" },
            { "Brai", "Braillowe pismo" },
            { "Cakm", "chakmaske pismo" },
            { "Cans", "zjednotnjene kanadske aboriginske złóžkowe pismo" },
            { "Cher", "cherokeeske pismo" },
            { "Cyrl", "kyrilisce" },
            { "Deva", "devanagari" },
            { "Ethi", "etiopisce" },
            { "Geor", "georgisce" },
            { "Grek", "grjeksce" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "chinšćina z bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "chinsce" },
            { "Hans", "zjednorjene" },
            { "Hant", "tradicionalne" },
            { "Hebr", "hebrejsce" },
            { "Hira", "hiragana" },
            { "Hrkt", "japanske złóžkowe pismo" },
            { "Jamo", "jamo" },
            { "Jpan", "japansce" },
            { "Kana", "katakana" },
            { "Khmr", "khmersce" },
            { "Knda", "kannadsce" },
            { "Kore", "korejsce" },
            { "Laoo", "laosce" },
            { "Latn", "łaćonsce" },
            { "Mlym", "malayalamsce" },
            { "Mong", "mongolsce" },
            { "Mtei", "meitei-mayekse pismo" },
            { "Mymr", "burmasce" },
            { "Nkoo", "n’Koske pismo" },
            { "Olck", "ol-chikiske pismo" },
            { "Orya", "oriya" },
            { "Rohg", "hanifiske pismo" },
            { "Sinh", "singhalsce" },
            { "Sund", "sundaneske pismo" },
            { "Syrc", "syriacske pismo" },
            { "Taml", "tamilsce" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinanghske pismo" },
            { "Thaa", "thaana" },
            { "Thai", "thailandsce" },
            { "Tibt", "tibetsce" },
            { "Vaii", "vaiske pismo" },
            { "Yiii", "yiske pismo" },
            { "Zmth", "matematiski zapis" },
            { "Zsye", "emoji" },
            { "Zsym", "symbole" },
            { "Zxxx", "bjez pisma" },
            { "Zyyy", "powšitkowne" },
            { "Zzzz", "njeznate pismo" },
            { "de_AT", "awstriska němčina" },
            { "de_CH", "šwicarska wysokoněmčina" },
            { "en_AU", "awstralska jendźelšćina" },
            { "en_CA", "kanadiska jendźelšćina" },
            { "en_GB", "britiska jendźelšćina" },
            { "en_US", "ameriska jendźelšćina" },
            { "es_ES", "europska španišćina" },
            { "es_MX", "mexiska španišćina" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadiska francošćina" },
            { "fr_CH", "šwicarska francošćina" },
            { "nl_BE", "flamšćina" },
            { "pt_BR", "brazilska portugalšćina" },
            { "pt_PT", "europska portugalšćina" },
            { "ro_MD", "moldawšćina" },
            { "sw_CD", "kongoska suahelšćina" },
            { "ar_001", "moderna wysokoarabšćina" },
            { "es_419", "łaćonskoameriska španišćina" },
            { "key.ca", "protyka" },
            { "key.cf", "format měny" },
            { "key.co", "rjadowanski slěd" },
            { "key.cu", "měna" },
            { "key.hc", "hodźinowy cyklus (12 vs 24)" },
            { "key.lb", "system łamanja linkow" },
            { "key.ms", "system měrow" },
            { "key.nu", "ličby" },
            { "zh_Hans", "chinšćina (zjednorjena)" },
            { "zh_Hant", "chinšćina (tradicionalna)" },
            { "type.ca.roc", "protyka republiki China" },
            { "type.hc.h11", "12-hodźinowy cyklus (0-11)" },
            { "type.hc.h12", "12-hodźinowy cyklus (1-12)" },
            { "type.hc.h23", "24-hodźinowy cyklus (0-23)" },
            { "type.hc.h24", "24-hodźinowy cyklus (1-24)" },
            { "type.nu.arab", "arabsko-indiske cyfry" },
            { "type.nu.armn", "armenske cyfry" },
            { "type.nu.beng", "bengalske cyfry" },
            { "type.nu.cakm", "chakmaske cyfry" },
            { "type.nu.deva", "devanagari-cyfry" },
            { "type.nu.ethi", "etiopiske cyfry" },
            { "type.nu.geor", "georgiske cyfry" },
            { "type.nu.grek", "grjekske cyfry" },
            { "type.nu.gujr", "gujarati-cyfry" },
            { "type.nu.guru", "gurmukhi-cyfry" },
            { "type.nu.hans", "zjednorjene chinske cyfry" },
            { "type.nu.hant", "tradicionalne chinske cyfry" },
            { "type.nu.hebr", "hebrejske cyfry" },
            { "type.nu.java", "javaske cyfry" },
            { "type.nu.jpan", "japanske cyfry" },
            { "type.nu.khmr", "khmerske cyfry" },
            { "type.nu.knda", "kannadske cyfry" },
            { "type.nu.laoo", "laoske cyfry" },
            { "type.nu.latn", "arabske cyfry" },
            { "type.nu.mlym", "malayalamske cyfry" },
            { "type.nu.mtei", "meetei-mayekske cyfry" },
            { "type.nu.mymr", "burmaske cyfry" },
            { "type.nu.olck", "ol-chikiske cyfry" },
            { "type.nu.orya", "oriya-cyfry" },
            { "type.nu.taml", "tradicionalne tamilske cyfry" },
            { "type.nu.telu", "telugu-cyfry" },
            { "type.nu.thai", "thailandske cyfry" },
            { "type.nu.tibt", "tibetske cyfry" },
            { "type.nu.vaii", "vaiske cyfry" },
            { "type.ca.dangi", "dangi-protyka" },
            { "type.co.ducet", "rjadowanski slěd po Unicode" },
            { "type.lb.loose", "swobodny stil łamanja linkow" },
            { "type.nu.roman", "romske cyfry" },
            { "type.ca.coptic", "koptiska protyka" },
            { "type.ca.hebrew", "židowska protyka" },
            { "type.co.search", "powšitkowne pytanje" },
            { "type.lb.normal", "běžny stil łamanja linkow" },
            { "type.lb.strict", "kruty stil łamanja linkow" },
            { "type.ms.metric", "metriski system" },
            { "type.ca.chinese", "chinska protyka" },
            { "type.ca.islamic", "islamska protyka" },
            { "type.ca.iso8601", "protyka po iso-8601" },
            { "type.ca.persian", "persiska protyka" },
            { "type.cf.account", "knihiwjedniski format měny" },
            { "type.nu.arabext", "rozšěrjene arabsko-indiske cyfry" },
            { "type.nu.armnlow", "armenske cyfry, małe pisane" },
            { "type.nu.greklow", "grjekske cyfry, małe pisane" },
            { "type.nu.hanidec", "chinske decimalne ličby" },
            { "type.nu.hansfin", "zjednorjene chinske financne cyfry" },
            { "type.nu.hantfin", "tradicionalne chinske financne cyfry" },
            { "type.nu.jpanfin", "japanske financne cyfry" },
            { "type.nu.tamldec", "tamilske cyfry" },
            { "type.ca.buddhist", "buddhistiska protyka" },
            { "type.ca.ethiopic", "etiopiska protyka" },
            { "type.ca.japanese", "japanska protyka" },
            { "type.cf.standard", "standardny format měny" },
            { "type.co.standard", "standardowy rjadowanski slěd" },
            { "type.ms.uksystem", "britiski system měrow" },
            { "type.ms.ussystem", "ameriski system měrow" },
            { "type.nu.fullwide", "połnošěroke cyfry" },
            { "type.nu.romanlow", "romske cyfry, małe pisane" },
            { "type.ca.gregorian", "gregorianska protyka" },
            { "type.ca.islamic-civil", "islamska ciwilna protyka" },
            { "type.ca.islamic-umalqura", "islamska umalqura-protyka" },
            { "type.ca.ethiopic-amete-alem", "etiopiska amete-alem-protyka" },
        };
        return data;
    }
}
