/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_WS = "Samoa";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "arabų";
        final String metaValue_hy = "armėnų";
        final String metaValue_bn = "bengalų";
        final String metaValue_bug = "buginezų";
        final String metaValue_chr = "čerokių";
        final String metaValue_cop = "koptų";
        final String metaValue_ka = "gruzinų";
        final String metaValue_got = "gotų";
        final String metaValue_el = "graikų";
        final String metaValue_gu = "gudžaratų";
        final String metaValue_he = "hebrajų";
        final String metaValue_jv = "javiečių";
        final String metaValue_ja = "japonų";
        final String metaValue_km = "khmerų";
        final String metaValue_kn = "kanadų";
        final String metaValue_ko = "korėjiečių";
        final String metaValue_lo = "laosiečių";
        final String metaValue_la = "lotynų";
        final String metaValue_ml = "malajalių";
        final String metaValue_mn = "mongolų";
        final String metaValue_my = "birmiečių";
        final String metaValue_nqo = "enko";
        final String metaValue_si = "sinhalų";
        final String metaValue_su = "sundų";
        final String metaValue_syr = "sirų";
        final String metaValue_ta = "tamilų";
        final String metaValue_te = "telugų";
        final String metaValue_tl = "tagalogų";
        final String metaValue_th = "tajų";
        final String metaValue_bo = "tibetiečių";
        final Object[][] data = new Object[][] {
            { "001", "pasaulis" },
            { "002", "Afrika" },
            { "003", "Šiaurės Amerika" },
            { "005", "Pietų Amerika" },
            { "009", "Okeanija" },
            { "011", "Vakarų Afrika" },
            { "013", "Centrinė Amerika" },
            { "014", "Rytų Afrika" },
            { "015", "Šiaurės Afrika" },
            { "017", "Vidurio Afrika" },
            { "018", "Pietinė Afrika" },
            { "019", "Amerika" },
            { "021", "Šiaurinė Amerika" },
            { "029", "Karibai" },
            { "030", "Rytų Azija" },
            { "034", "Pietų Azija" },
            { "035", "Pietryčių Azija" },
            { "039", "Pietų Europa" },
            { "053", "Australazija" },
            { "054", "Melanezija" },
            { "057", "Mikronezijos regionas" },
            { "061", "Polinezija" },
            { "142", "Azija" },
            { "143", "Centrinė Azija" },
            { "145", "Vakarų Azija" },
            { "150", "Europa" },
            { "151", "Rytų Europa" },
            { "154", "Šiaurės Europa" },
            { "155", "Vakarų Europa" },
            { "202", "Užsachario Afrika" },
            { "419", "Lotynų Amerika" },
            { "AC", "Dangun Žengimo sala" },
            { "AD", "Andora" },
            { "AE", "Jungtiniai Arabų Emyratai" },
            { "AF", "Afganistanas" },
            { "AG", "Antigva ir Barbuda" },
            { "AI", "Angilija" },
            { "AL", "Albanija" },
            { "AM", "Armėnija" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Amerikos Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Alandų Salos" },
            { "AZ", "Azerbaidžanas" },
            { "BA", "Bosnija ir Hercegovina" },
            { "BB", "Barbadosas" },
            { "BD", "Bangladešas" },
            { "BE", "Belgija" },
            { "BF", "Burkina Fasas" },
            { "BG", "Bulgarija" },
            { "BH", "Bahreinas" },
            { "BI", "Burundis" },
            { "BJ", "Beninas" },
            { "BL", "Sen Bartelemi" },
            { "BM", "Bermuda" },
            { "BN", "Brunėjus" },
            { "BO", "Bolivija" },
            { "BQ", "Karibų Nyderlandai" },
            { "BR", "Brazilija" },
            { "BS", "Bahamos" },
            { "BT", "Butanas" },
            { "BV", "Buvė Sala" },
            { "BW", "Botsvana" },
            { "BY", "Baltarusija" },
            { "BZ", "Belizas" },
            { "CA", "Kanada" },
            { "CC", "Kokosų (Kilingo) Salos" },
            { "CD", "Kongas-Kinšasa" },
            { "CF", "Centrinės Afrikos Respublika" },
            { "CG", "Kongas-Brazavilis" },
            { "CH", "Šveicarija" },
            { "CI", "Dramblio Kaulo Krantas" },
            { "CK", "Kuko Salos" },
            { "CL", "Čilė" },
            { "CM", "Kamerūnas" },
            { "CN", "Kinija" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertono sala" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Žaliasis Kyšulys" },
            { "CW", "Kiurasao" },
            { "CX", "Kalėdų Sala" },
            { "CY", "Kipras" },
            { "CZ", "Čekija" },
            { "DE", "Vokietija" },
            { "DG", "Diego Garsija" },
            { "DJ", "Džibutis" },
            { "DK", "Danija" },
            { "DM", "Dominika" },
            { "DO", "Dominikos Respublika" },
            { "DZ", "Alžyras" },
            { "EA", "Seuta ir Melila" },
            { "EC", "Ekvadoras" },
            { "EE", "Estija" },
            { "EG", "Egiptas" },
            { "EH", "Vakarų Sachara" },
            { "ER", "Eritrėja" },
            { "ES", "Ispanija" },
            { "ET", "Etiopija" },
            { "EU", "Europos Sąjunga" },
            { "EZ", "euro zona" },
            { "FI", "Suomija" },
            { "FJ", "Fidžis" },
            { "FK", "Folklando Salos" },
            { "FM", "Mikronezija" },
            { "FO", "Farerų Salos" },
            { "FR", "Prancūzija" },
            { "GA", "Gabonas" },
            { "GB", "Jungtinė Karalystė" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Prancūzijos Gviana" },
            { "GG", "Gernsis" },
            { "GH", "Gana" },
            { "GI", "Gibraltaras" },
            { "GL", "Grenlandija" },
            { "GM", "Gambija" },
            { "GN", "Gvinėja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Pusiaujo Gvinėja" },
            { "GR", "Graikija" },
            { "GS", "Pietų Džordžija ir Pietų Sandvičo salos" },
            { "GT", "Gvatemala" },
            { "GU", "Guamas" },
            { "GW", "Bisau Gvinėja" },
            { "GY", "Gajana" },
            { "HK", "Ypatingasis Administracinis Kinijos Regionas Honkongas" },
            { "HM", "Herdo ir Makdonaldo Salos" },
            { "HN", "Hondūras" },
            { "HR", "Kroatija" },
            { "HT", "Haitis" },
            { "HU", "Vengrija" },
            { "IC", "Kanarų salos" },
            { "ID", "Indonezija" },
            { "IE", "Airija" },
            { "IL", "Izraelis" },
            { "IM", "Meno Sala" },
            { "IN", "Indija" },
            { "IO", "Indijos Vandenyno Britų Sritis" },
            { "IQ", "Irakas" },
            { "IR", "Iranas" },
            { "IS", "Islandija" },
            { "IT", "Italija" },
            { "JE", "Džersis" },
            { "JM", "Jamaika" },
            { "JO", "Jordanija" },
            { "JP", "Japonija" },
            { "KE", "Kenija" },
            { "KG", "Kirgizija" },
            { "KH", "Kambodža" },
            { "KI", "Kiribatis" },
            { "KM", "Komorai" },
            { "KN", "Sent Kitsas ir Nevis" },
            { "KP", "Šiaurės Korėja" },
            { "KR", "Pietų Korėja" },
            { "KW", "Kuveitas" },
            { "KY", "Kaimanų Salos" },
            { "KZ", "Kazachstanas" },
            { "LA", "Laosas" },
            { "LB", "Libanas" },
            { "LC", "Sent Lusija" },
            { "LI", "Lichtenšteinas" },
            { "LK", "Šri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesotas" },
            { "LT", "Lietuva" },
            { "LU", "Liuksemburgas" },
            { "LV", "Latvija" },
            { "LY", "Libija" },
            { "MA", "Marokas" },
            { "MC", "Monakas" },
            { "MD", "Moldova" },
            { "ME", "Juodkalnija" },
            { "MF", "Sen Martenas" },
            { "MG", "Madagaskaras" },
            { "MH", "Maršalo Salos" },
            { "MK", "Šiaurės Makedonija" },
            { "ML", "Malis" },
            { "MM", "Mianmaras (Birma)" },
            { "MN", "Mongolija" },
            { "MO", "Ypatingasis Administracinis Kinijos Regionas Makao" },
            { "MP", "Marianos Šiaurinės Salos" },
            { "MQ", "Martinika" },
            { "MR", "Mauritanija" },
            { "MS", "Montseratas" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "MV", "Maldyvai" },
            { "MW", "Malavis" },
            { "MX", "Meksika" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambikas" },
            { "NA", "Namibija" },
            { "NC", "Naujoji Kaledonija" },
            { "NE", "Nigeris" },
            { "NF", "Norfolko sala" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragva" },
            { "NL", "Nyderlandai" },
            { "NO", "Norvegija" },
            { "NP", "Nepalas" },
            { "NR", "Nauru" },
            { "NU", "Niujė" },
            { "NZ", "Naujoji Zelandija" },
            { "OM", "Omanas" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Prancūzijos Polinezija" },
            { "PG", "Papua Naujoji Gvinėja" },
            { "PH", "Filipinai" },
            { "PK", "Pakistanas" },
            { "PL", "Lenkija" },
            { "PM", "Sen Pjeras ir Mikelonas" },
            { "PN", "Pitkerno salos" },
            { "PR", "Puerto Rikas" },
            { "PS", "Palestinos teritorija" },
            { "PT", "Portugalija" },
            { "PW", "Palau" },
            { "PY", "Paragvajus" },
            { "QA", "Kataras" },
            { "QO", "Nuošali Okeanija" },
            { "RE", "Reunjonas" },
            { "RO", "Rumunija" },
            { "RS", "Serbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "SA", "Saudo Arabija" },
            { "SB", "Saliamono Salos" },
            { "SC", "Seišeliai" },
            { "SD", "Sudanas" },
            { "SE", "Švedija" },
            { "SG", "Singapūras" },
            { "SH", "Šv. Elenos Sala" },
            { "SI", "Slovėnija" },
            { "SJ", "Svalbardas ir Janas Majenas" },
            { "SK", "Slovakija" },
            { "SL", "Siera Leonė" },
            { "SM", "San Marinas" },
            { "SN", "Senegalas" },
            { "SO", "Somalis" },
            { "SR", "Surinamas" },
            { "SS", "Pietų Sudanas" },
            { "ST", "San Tomė ir Prinsipė" },
            { "SV", "Salvadoras" },
            { "SX", "Sint Martenas" },
            { "SY", "Sirija" },
            { "SZ", "Svazilandas" },
            { "TA", "Tristano da Kunjos" },
            { "TC", "Terkso ir Kaikoso Salos" },
            { "TD", "Čadas" },
            { "TF", "Prancūzijos Pietų sritys" },
            { "TG", "Togas" },
            { "TH", "Tailandas" },
            { "TJ", "Tadžikija" },
            { "TK", metaValue_TK },
            { "TL", "Rytų Timoras" },
            { "TM", "Turkmėnistanas" },
            { "TN", "Tunisas" },
            { "TO", "Tonga" },
            { "TR", "Turkija" },
            { "TT", "Trinidadas ir Tobagas" },
            { "TV", metaValue_TV },
            { "TW", "Taivanas" },
            { "TZ", "Tanzanija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Jungtinių Valstijų Mažosios Tolimosios Salos" },
            { "UN", "Jungtinės Tautos" },
            { "US", "Jungtinės Valstijos" },
            { "UY", "Urugvajus" },
            { "UZ", "Uzbekistanas" },
            { "VA", "Vatikano Miesto Valstybė" },
            { "VC", "Šventasis Vincentas ir Grenadinai" },
            { "VE", "Venesuela" },
            { "VG", "Didžiosios Britanijos Mergelių Salos" },
            { "VI", "Jungtinių Valstijų Mergelių Salos" },
            { "VN", "Vietnamas" },
            { "VU", "Vanuatu" },
            { "WF", "Volisas ir Futūna" },
            { "WS", metaValue_WS },
            { "XA", "pseudo A" },
            { "XB", "pseudo B" },
            { "XK", "Kosovas" },
            { "YE", "Jemenas" },
            { "YT", "Majotas" },
            { "ZA", "Pietų Afrika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabvė" },
            { "ZZ", "nežinoma sritis" },
            { "aa", "afarų" },
            { "ab", "abchazų" },
            { "ae", "avestų" },
            { "af", "afrikanų" },
            { "ak", "akanų" },
            { "am", "amharų" },
            { "an", "aragonesų" },
            { "ar", metaValue_ar },
            { "as", "asamų" },
            { "av", "avarikų" },
            { "ay", "aimarų" },
            { "az", "azerbaidžaniečių" },
            { "ba", "baškirų" },
            { "be", "baltarusių" },
            { "bg", "bulgarų" },
            { "bi", "bislama" },
            { "bm", "bambarų" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonų" },
            { "bs", "bosnių" },
            { "ca", "katalonų" },
            { "ce", "čečėnų" },
            { "ch", "čamorų" },
            { "co", "korsikiečių" },
            { "cr", "kry" },
            { "cs", "čekų" },
            { "cu", "bažnytinė slavų" },
            { "cv", "čiuvašų" },
            { "cy", "valų" },
            { "da", "danų" },
            { "de", "vokiečių" },
            { "dv", "divehų" },
            { "dz", "botijų" },
            { "ee", "evių" },
            { "el", metaValue_el },
            { "en", "anglų" },
            { "eo", "esperanto" },
            { "es", "ispanų" },
            { "et", "estų" },
            { "eu", "baskų" },
            { "fa", "persų" },
            { "ff", "fulahų" },
            { "fi", "suomių" },
            { "fj", "fidžių" },
            { "fo", "farerų" },
            { "fr", "prancūzų" },
            { "fy", "vakarų fryzų" },
            { "ga", "airių" },
            { "gd", "škotų (gėlų)" },
            { "gl", "galisų" },
            { "gn", "gvaranių" },
            { "gu", metaValue_gu },
            { "gv", "meniečių" },
            { "ha", "hausų" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "kroatų" },
            { "ht", "Haičio" },
            { "hu", "vengrų" },
            { "hy", metaValue_hy },
            { "hz", "hererų" },
            { "ia", "tarpinė" },
            { "id", "indoneziečių" },
            { "ie", "interkalba" },
            { "ig", "igbų" },
            { "ii", "sičuan ji" },
            { "ik", "inupiakų" },
            { "io", "ido" },
            { "is", "islandų" },
            { "it", "italų" },
            { "iu", "inukitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "kikujų" },
            { "kj", "kuaniama" },
            { "kk", "kazachų" },
            { "kl", "kalalisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanurių" },
            { "ks", "kašmyrų" },
            { "ku", "kurdų" },
            { "kv", "komi" },
            { "kw", "kornų" },
            { "ky", "kirgizų" },
            { "la", metaValue_la },
            { "lb", "liuksemburgiečių" },
            { "lg", "ganda" },
            { "li", "limburgiečių" },
            { "ln", "ngalų" },
            { "lo", metaValue_lo },
            { "lt", "lietuvių" },
            { "lu", "luba katanga" },
            { "lv", "latvių" },
            { "mg", "malagasų" },
            { "mh", "Maršalo Salų" },
            { "mi", "maorių" },
            { "mk", "makedonų" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "maratų" },
            { "ms", "malajiečių" },
            { "mt", "maltiečių" },
            { "my", metaValue_my },
            { "na", "naurų" },
            { "nb", "norvegų bukmolas" },
            { "nd", "šiaurės ndebelų" },
            { "ne", "nepaliečių" },
            { "ng", "ndongų" },
            { "nl", "olandų" },
            { "nn", "naujoji norvegų" },
            { "no", "norvegų" },
            { "nr", "pietų ndebele" },
            { "nv", "navajų" },
            { "ny", "nianjų" },
            { "oc", "očitarų" },
            { "oj", "ojibva" },
            { "om", "oromų" },
            { "or", "odijų" },
            { "os", "osetinų" },
            { "pa", "pendžabų" },
            { "pi", "pali" },
            { "pl", "lenkų" },
            { "ps", "puštūnų" },
            { "pt", "portugalų" },
            { "qu", "kečujų" },
            { "rm", "retoromanų" },
            { "rn", "rundi" },
            { "ro", "rumunų" },
            { "ru", "rusų" },
            { "rw", "kinjaruandų" },
            { "sa", "sanskritas" },
            { "sc", "sardiniečių" },
            { "sd", "sindų" },
            { "se", "šiaurės samių" },
            { "sg", "sango" },
            { "sh", "serbų-kroatų" },
            { "si", metaValue_si },
            { "sk", "slovakų" },
            { "sl", "slovėnų" },
            { "sm", metaValue_WS },
            { "sn", "šonų" },
            { "so", "somaliečių" },
            { "sq", "albanų" },
            { "sr", "serbų" },
            { "ss", "svatų" },
            { "st", "pietų Soto" },
            { "su", metaValue_su },
            { "sv", "švedų" },
            { "sw", "suahilių" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadžikų" },
            { "th", metaValue_th },
            { "ti", "tigrajų" },
            { "tk", "turkmėnų" },
            { "tl", metaValue_tl },
            { "tn", "tsvanų" },
            { "to", "tonganų" },
            { "tr", "turkų" },
            { "ts", "tsongų" },
            { "tt", "totorių" },
            { "tw", "tvi" },
            { "ty", "taitiečių" },
            { "ug", "uigūrų" },
            { "uk", "ukrainiečių" },
            { "ur", "urdų" },
            { "uz", "uzbekų" },
            { "ve", "vendų" },
            { "vi", "vietnamiečių" },
            { "vo", "volapiuko" },
            { "wa", "valonų" },
            { "wo", "volofų" },
            { "xh", "kosų" },
            { "yi", "jidiš" },
            { "yo", "jorubų" },
            { "za", "chuang" },
            { "zh", "kinų" },
            { "zu", "zulų" },
            { "ace", "ačinezų" },
            { "ach", "akolių" },
            { "ada", "adangmų" },
            { "ady", "adygėjų" },
            { "aeb", "Tuniso arabų" },
            { "afh", "afrihili" },
            { "agq", "aghemų" },
            { "ain", "ainų" },
            { "akk", "akadianų" },
            { "akz", "alabamiečių" },
            { "ale", "aleutų" },
            { "aln", "albanų kalbos gegų tarmė" },
            { "alt", "pietų Altajaus" },
            { "ang", "senoji anglų" },
            { "ann", "obolų" },
            { "anp", "angikų" },
            { "arc", "aramaikų" },
            { "arn", "mapudungunų" },
            { "aro", "araonų" },
            { "arp", "arapahų" },
            { "arq", "Alžyro arabų" },
            { "ars", "arabų najdi" },
            { "arw", "aravakų" },
            { "ary", "Maroko arabų" },
            { "arz", "Egipto arabų" },
            { "asa", "asu" },
            { "ase", "Amerikos ženklų kalba" },
            { "ast", "asturianų" },
            { "atj", "atikamekų" },
            { "avk", "kotava" },
            { "awa", "avadhi" },
            { "bal", "baluči" },
            { "ban", "baliečių" },
            { "bar", "bavarų" },
            { "bas", "basų" },
            { "bax", "bamunų" },
            { "bbc", "batak toba" },
            { "bbj", "ghomalų" },
            { "bej", "bėjų" },
            { "bem", "bembų" },
            { "bew", "betavi" },
            { "bez", "benų" },
            { "bfd", "bafutų" },
            { "bfq", "badaga" },
            { "bgc", "harijanvi" },
            { "bgn", "vakarų beludžių" },
            { "bho", "baučpuri" },
            { "bik", "bikolų" },
            { "bin", "bini" },
            { "bjn", "bandžarų" },
            { "bkm", "komų" },
            { "bla", "siksikų" },
            { "blo", "guanų" },
            { "bpy", "bišnuprijos" },
            { "bqi", "bakhtiari" },
            { "bra", "brajų" },
            { "brh", "brahujų" },
            { "brx", "bodo" },
            { "bss", "akūsų" },
            { "bua", "buriatų" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumbų" },
            { "cad", "kado" },
            { "car", "karibų" },
            { "cay", "kaijūgų" },
            { "cch", "atsamų" },
            { "ccp", "Čakma" },
            { "ceb", "sebuanų" },
            { "cgg", "čigų" },
            { "chb", "čibčų" },
            { "chg", "čagatų" },
            { "chk", "čukesų" },
            { "chm", "marių" },
            { "chn", "činuk žargonas" },
            { "cho", "čoktau" },
            { "chp", "čipvėjų" },
            { "chr", metaValue_chr },
            { "chy", "čajenų" },
            { "ckb", "soranių kurdų" },
            { "clc", "čilkotinų" },
            { "cop", metaValue_cop },
            { "cps", "capiznon" },
            { "crg", "metisų" },
            { "crh", "Krymo turkų" },
            { "crj", "pietryčių kri" },
            { "crk", "supraprastinta kri" },
            { "crl", "šiaurės rytų kri" },
            { "crm", "muskri" },
            { "crr", "pamlikų" },
            { "crs", "Seišelių kreolų ir prancūzų" },
            { "csb", "kašubų" },
            { "csw", "pelkynų kri" },
            { "dak", "dakotų" },
            { "dar", "dargva" },
            { "dav", "taitų" },
            { "del", "delavero" },
            { "den", "slave" },
            { "dgr", "dogribų" },
            { "din", "dinkų" },
            { "dje", "zarmų" },
            { "doi", "dogri" },
            { "dsb", "žemutinių sorbų" },
            { "dtp", "centrinio Dusuno" },
            { "dua", "dualų" },
            { "dum", "Vidurio Vokietijos" },
            { "dyo", "džiola-foni" },
            { "dyu", "dyulų" },
            { "dzg", "dazagų" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "italų kalbos Emilijos tarmė" },
            { "egy", "senovės egiptiečių" },
            { "eka", "ekajuk" },
            { "elx", "elamitų" },
            { "enm", "Vidurio Anglijos" },
            { "esu", "centrinės Aliaskos jupikų" },
            { "ewo", "evondo" },
            { "ext", "ispanų kalbos Ekstremadūros tarmė" },
            { "fan", "fangų" },
            { "fat", "fanti" },
            { "fil", "filipiniečių" },
            { "fit", "suomių kalbos Tornedalio tarmė" },
            { "fon", "fon" },
            { "frc", "kadžunų prancūzų" },
            { "frm", "Vidurio Prancūzijos" },
            { "fro", "senoji prancūzų" },
            { "frp", "arpitano" },
            { "frr", "šiaurinių fryzų" },
            { "frs", "rytų fryzų" },
            { "fur", "friulių" },
            { "gaa", "ga" },
            { "gag", "gagaūzų" },
            { "gan", "kinų kalbos dziangsi tarmė" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gbz", "zoroastrų dari" },
            { "gez", "gyz" },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "Vidurio Aukštosios Vokietijos" },
            { "goh", "senoji Aukštosios Vokietijos" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "senovės graikų" },
            { "gsw", "Šveicarijos vokiečių" },
            { "guc", "vajų" },
            { "gur", "frafra" },
            { "guz", "gusi" },
            { "gwi", "gvičino" },
            { "hai", "haido" },
            { "hak", "kinų kalbos hakų tarmė" },
            { "haw", "havajiečių" },
            { "hax", "Pietų Haidos" },
            { "hif", "Fidžio hindi" },
            { "hil", "hiligainonų" },
            { "hit", "hititų" },
            { "hmn", "hmong" },
            { "hsb", "aukštutinių sorbų" },
            { "hsn", "kinų kalbos hunano tarmė" },
            { "hup", "hupa" },
            { "hur", "halkomelemų" },
            { "iba", "iban" },
            { "ibb", "ibibijų" },
            { "ikt", "vakarų kanadiečių inuktitutas" },
            { "ilo", "ilokų" },
            { "inh", "ingušų" },
            { "izh", "ingrų" },
            { "jam", "Jamaikos kreolų anglų" },
            { "jbo", "loiban" },
            { "jgo", "ngombų" },
            { "jmc", "mačamų" },
            { "jpr", "judėjų persų" },
            { "jrb", "judėjų arabų" },
            { "jut", "danų kalbos jutų tarmė" },
            { "kaa", "karakalpakų" },
            { "kab", "kebailų" },
            { "kac", "kačinų" },
            { "kaj", "ju" },
            { "kam", "kembų" },
            { "kaw", "kavių" },
            { "kbd", "kabardinų" },
            { "kbl", "kanembų" },
            { "kcg", "tyap" },
            { "kde", "makondų" },
            { "kea", "Žaliojo Kyšulio kreolų" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kasi" },
            { "kho", "kotanezų" },
            { "khq", "kojra čini" },
            { "khw", "khovarų" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjinų" },
            { "kmb", "kimbundu" },
            { "koi", "komių-permių" },
            { "kok", "konkanių" },
            { "kos", "kosreanų" },
            { "kpe", "kpelių" },
            { "krc", "karačiajų balkarijos" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelų" },
            { "kru", "kuruk" },
            { "ksb", "šambalų" },
            { "ksf", "bafų" },
            { "ksh", "kolognų" },
            { "kum", "kumikų" },
            { "kut", "kutenai" },
            { "kwk", "kvakvalų" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "landa" },
            { "lam", "lamba" },
            { "lez", "lezginų" },
            { "lfn", "naujoji frankų kalba" },
            { "lij", "ligūrų" },
            { "lil", "liluetų" },
            { "liv", "lyvių" },
            { "lkt", "lakotų" },
            { "lmo", "lombardų" },
            { "lol", "mongų" },
            { "lou", "Luizianos kreolų" },
            { "loz", "lozių" },
            { "lrc", "šiaurės luri" },
            { "lsm", "samių" },
            { "ltg", "latgalių" },
            { "lua", "luba lulua" },
            { "lui", "luiseno" },
            { "lun", "Lundos" },
            { "lus", "mizo" },
            { "luy", "luja" },
            { "lzh", "klasikinė kinų" },
            { "lzz", "laz" },
            { "mad", "madurezų" },
            { "maf", "mafų" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "Makasaro" },
            { "man", "mandingų" },
            { "mas", "masajų" },
            { "mde", "mabų" },
            { "mdf", "mokša" },
            { "mdr", "mandarų" },
            { "men", "mende" },
            { "mer", "merų" },
            { "mfe", "morisijų" },
            { "mga", "Vidurio Airijos" },
            { "mgh", "makua-maeto" },
            { "mgo", "meta" },
            { "mic", "mikmakų" },
            { "min", "minangkabau" },
            { "mnc", "manču" },
            { "mni", "manipurių" },
            { "moe", "montanjų" },
            { "moh", "mohok" },
            { "mos", "mosi" },
            { "mrj", "vakarų mari" },
            { "mua", "mundangų" },
            { "mul", "kelios kalbos" },
            { "mus", "krykų" },
            { "mwl", "mirandezų" },
            { "mwr", "marvari" },
            { "mwv", "mentavai" },
            { "mye", "mjenų" },
            { "myv", "erzyjų" },
            { "mzn", "mazenderanių" },
            { "nan", "kinų kalbos pietų minų tarmė" },
            { "nap", "neapoliečių" },
            { "naq", "nama" },
            { "nds", "Žemutinės Vokietijos" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niujiečių" },
            { "njo", "ao naga" },
            { "nmg", "kvasių" },
            { "nnh", "ngiembūnų" },
            { "nog", "nogų" },
            { "non", "senoji norsų" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "šiaurės Soto" },
            { "nus", "nuerų" },
            { "nwc", "klasikinė nevari" },
            { "nym", "niamvezi" },
            { "nyn", "niankolų" },
            { "nyo", "niorų" },
            { "nzi", "nzima" },
            { "ojb", "šiaurės vakarų odžibvių" },
            { "ojc", "ojibvų" },
            { "ojs", "odži kri" },
            { "ojw", "vakarų odžibvių" },
            { "oka", "okanaganų" },
            { "osa", "osage" },
            { "ota", "osmanų turkų" },
            { "pag", "pangasinanų" },
            { "pal", "vidurinė persų kalba" },
            { "pam", "pampangų" },
            { "pap", "papiamento" },
            { "pau", "palauliečių" },
            { "pcd", "pikardų" },
            { "pcm", "Nigerijos pidžinų" },
            { "pdc", "Pensilvanijos vokiečių" },
            { "pdt", "vokiečių kalbos žemaičių tarmė" },
            { "peo", "senoji persų" },
            { "pfl", "vokiečių kalbos Pfalco tarmė" },
            { "phn", "finikiečių" },
            { "pis", "pidžinų" },
            { "pms", "italų kalbos Pjemonto tarmė" },
            { "pnt", "Ponto" },
            { "pon", "Ponapės" },
            { "pqm", "Maliset-Pasamakvodžio" },
            { "prg", "prūsų" },
            { "pro", "senovės provansalų" },
            { "quc", "kičių" },
            { "qug", "Čimboraso aukštumų kečujų" },
            { "raj", "Radžastano" },
            { "rap", "rapanui" },
            { "rar", "rarotonganų" },
            { "rgn", "italų kalbos Romanijos tarmė" },
            { "rhg", "rochindža" },
            { "rif", "rifų" },
            { "rof", "rombo" },
            { "rom", "romų" },
            { "rtm", "rotumanų" },
            { "rue", "rusinų" },
            { "rug", "Rovianos" },
            { "rup", "aromanių" },
            { "rwk", "rua" },
            { "sad", "sandavių" },
            { "sah", "jakutų" },
            { "sam", "samarėjų aramių" },
            { "saq", "sambūrų" },
            { "sas", "sasak" },
            { "sat", "santalių" },
            { "saz", "sauraštrų" },
            { "sba", "ngambajų" },
            { "sbp", "sangų" },
            { "scn", "siciliečių" },
            { "sco", "škotų" },
            { "sdc", "sasaresų sardinų" },
            { "sdh", "pietų kurdų" },
            { "see", "senecų" },
            { "seh", "senų" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "kojraboro seni" },
            { "sga", "senoji airių" },
            { "sgs", "žemaičių" },
            { "shi", "tachelhitų" },
            { "shn", "šan" },
            { "shu", "chadian arabų" },
            { "sid", "sidamų" },
            { "slh", "pietų lushusidų" },
            { "sli", "sileziečių žemaičių" },
            { "sly", "selajarų" },
            { "sma", "pietų samių" },
            { "smj", "Liuleo samių" },
            { "smn", "Inario samių" },
            { "sms", "Skolto samių" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "sererų" },
            { "ssy", "saho" },
            { "stq", "Saterlendo fryzų" },
            { "str", "Sališo sąsiaurio" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "šumerų" },
            { "swb", "komorų" },
            { "syc", "klasikinė sirų" },
            { "syr", metaValue_syr },
            { "szl", "sileziečių" },
            { "tce", "pietų tučonų" },
            { "tcy", "tulų" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "Tereno" },
            { "tet", "tetum" },
            { "tgx", "tagišų" },
            { "tht", "taltanų" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", metaValue_TK },
            { "tkr", "tsakurų" },
            { "tlh", "klingonų" },
            { "tli", "tlingitų" },
            { "tly", "talyšų" },
            { "tmh", "tamašek" },
            { "tog", "niasa tongų" },
            { "tok", "Toki Pona" },
            { "tpi", "Papua pidžinų" },
            { "tru", "turoyo" },
            { "trv", "Taroko" },
            { "tsd", "tsakonų" },
            { "tsi", "tsimšian" },
            { "ttm", "šiaurės tutsonų" },
            { "ttt", "musulmonų tatų" },
            { "tum", "tumbukų" },
            { "tvl", metaValue_TV },
            { "twq", "tasavakų" },
            { "tyv", "tuvių" },
            { "tzm", "Centrinio Maroko tamazitų" },
            { "udm", "udmurtų" },
            { "uga", "ugaritų" },
            { "umb", "umbundu" },
            { "und", "nežinoma kalba" },
            { "vec", "venetų" },
            { "vep", "vepsų" },
            { "vls", "vakarų flamandų" },
            { "vmf", "pagrindinė frankonų" },
            { "vmw", "makua" },
            { "vot", "Votik" },
            { "vro", "veru" },
            { "vun", "vunjo" },
            { "wae", "valserų" },
            { "wal", "valamo" },
            { "war", "varai" },
            { "was", "Vašo" },
            { "wbp", "valrpiri" },
            { "wuu", "kinų kalbos vu tarmė" },
            { "xal", "kalmukų" },
            { "xmf", "megrelų" },
            { "xnr", "kangri" },
            { "xog", "sogų" },
            { "yao", "jao" },
            { "yap", "japezų" },
            { "yav", "jangbenų" },
            { "ybb", "jembų" },
            { "yrl", "njengatu" },
            { "yue", "kinų kalbos Kantono tarmė" },
            { "zap", "zapotekų" },
            { "zbl", "BLISS simbolių" },
            { "zea", "zelandų" },
            { "zen", "zenaga" },
            { "zgh", "standartinė Maroko tamazigtų" },
            { "zun", "Zuni" },
            { "zxx", "nėra kalbinio turinio" },
            { "zza", "zaza" },
            { "Adlm", "ADLAM" },
            { "Afak", "Afaka" },
            { "Aghb", "Kaukazo Albanijos" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastalik" },
            { "Armi", "imperinė aramaikų" },
            { "Armn", metaValue_hy },
            { "Avst", "avestano" },
            { "Bali", "Baliečių" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "„Bliss“ simboliai" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "brailio" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", "čakma" },
            { "Cans", "suvienodinti Kanados aborigenų silabiniai" },
            { "Cari", "karių" },
            { "Cham", "čam" },
            { "Cher", metaValue_chr },
            { "Cirt", "kirt" },
            { "Copt", metaValue_cop },
            { "Cprt", "kipro" },
            { "Cyrl", "kirilica" },
            { "Cyrs", "senoji bažnytinė slavų kirilica" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseretas" },
            { "Dupl", "Duplojė stenografija" },
            { "Egyd", "Egipto liaudies" },
            { "Egyh", "Egipto žynių" },
            { "Egyp", "egipto hieroglifai" },
            { "Elba", "Elbasano" },
            { "Ethi", "etiopų" },
            { "Geok", "gruzinų kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitik" },
            { "Goth", metaValue_got },
            { "Gran", "Granta" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuki" },
            { "Hanb", "hanbų" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanuno" },
            { "Hans", "supaprastinti" },
            { "Hant", "tradiciniai" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "Anatolijaus hieroglifai" },
            { "Hmng", "pahav hmong" },
            { "Hrkt", "katakana / hiragana" },
            { "Hung", "senasis vengrų" },
            { "Inds", "indus" },
            { "Ital", "senasis italų" },
            { "Jamo", "Jamo simboliai" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "kajah li" },
            { "Kana", "katakana" },
            { "Khar", "karošti" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "Kpelų" },
            { "Kthi", "kaithi" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latf", "fraktur lotynų" },
            { "Latg", "gėlų lotynų" },
            { "Latn", metaValue_la },
            { "Lepc", "lepča" },
            { "Limb", "limbu" },
            { "Lina", "linijiniai A" },
            { "Linb", "linijiniai B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "lician" },
            { "Lydi", "lidian" },
            { "Mahj", "Mahadžani" },
            { "Mand", "mandėjų" },
            { "Mani", "maničų" },
            { "Maya", "malų hieroglifai" },
            { "Mend", "Mende" },
            { "Merc", "Merojitų rankraštinis" },
            { "Mero", "meroitik" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "mūn" },
            { "Mroo", "Mro" },
            { "Mtei", "meitei majek" },
            { "Mymr", metaValue_my },
            { "Narb", "Senasis šiaurės arabų" },
            { "Nbat", "Nabatėjų" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol čiki" },
            { "Orkh", "orkon" },
            { "Orya", "orijų" },
            { "Osma", "osmanų" },
            { "Palm", "Palmiros" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "senieji permės" },
            { "Phag", "pagsa pa" },
            { "Phli", "rašytiniai pahlavi" },
            { "Phlp", "pselter pahlavi" },
            { "Phlv", "buk pahvali" },
            { "Phnx", "foenikų" },
            { "Plrd", "polard fonetinė" },
            { "Prti", "rašytiniai partų" },
            { "Rjng", "rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runų" },
            { "Samr", "samariečių" },
            { "Sara", "sarati" },
            { "Sarb", "senoji pietų Arabijos" },
            { "Saur", "sauraštra" },
            { "Sgnw", "ženklų raštas" },
            { "Shaw", "šavių" },
            { "Shrd", "Šarados" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "Sora Sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "estrangelo siriečių" },
            { "Syrj", "vakarų sirų" },
            { "Syrn", "rytų sirų" },
            { "Tagb", "tagbanva" },
            { "Takr", "Takri" },
            { "Tale", "tai le" },
            { "Talu", "naujasis Tailando lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "tai vet" },
            { "Telu", metaValue_te },
            { "Teng", "tengvar" },
            { "Tfng", "tifinag" },
            { "Tglg", metaValue_tl },
            { "Thaa", "hana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Ugar", "ugaritik" },
            { "Vaii", "vai" },
            { "Visp", "matoma kalba" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleai" },
            { "Xpeo", "senieji persų" },
            { "Xsux", "Šumero Akado dantiraštis" },
            { "Yiii", "ji" },
            { "Zinh", "paveldėtas" },
            { "Zmth", "matematiniai simboliai" },
            { "Zsye", "jaustukai" },
            { "Zsym", "simbolių" },
            { "Zxxx", "neparašyta" },
            { "Zyyy", "bendri" },
            { "Zzzz", "nežinomi rašmenys" },
            { "de_AT", "Austrijos vokiečių" },
            { "de_CH", "Šveicarijos aukštutinė vokiečių" },
            { "en_AU", "Australijos anglų" },
            { "en_CA", "Kanados anglų" },
            { "en_GB", "Didžiosios Britanijos anglų" },
            { "en_US", "Jungtinių Valstijų anglų" },
            { "fr_CA", "Kanados prancūzų" },
            { "fr_CH", "Šveicarijos prancūzų" },
            { "nl_BE", "flamandų" },
            { "ro_MD", "moldavų" },
            { "sw_CD", "Kongo suahilių" },
            { "%%1901", "Įprasta vokiečių rašyba" },
            { "%%1994", "Sunorminta Resian rašyba" },
            { "%%1996", "1996 -ųjų metų vokiečių rašyba" },
            { "ar_001", "šiuolaikinė standartinė arabų" },
            { "key.ca", "kalendorius" },
            { "key.cf", "valiutos formatas" },
            { "key.co", "rikiavimas" },
            { "key.cu", "valiuta" },
            { "key.hc", "valandų ciklas (12 ir 24)" },
            { "key.lb", "teksto laužymo stilius" },
            { "key.ms", "matų sistema" },
            { "key.nu", "skaičiai" },
            { "key.tz", "Laiko juosta" },
            { "key.va", "Lokalės variantas" },
            { "nds_NL", "Žemutinės Saksonijos (Nyderlandai)" },
            { "%%BISKE", "San Giorgio / Bila tarmė" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Įprasta rašyba" },
            { "%%LIPAW", "Resian tarmei priklausanti Lipovaz tarmė" },
            { "%%NEDIS", "Natisone tarmė" },
            { "%%NJIVA", "Gniva / Njiva tarmė" },
            { "%%OSOJS", "Oseacco / Osojane tarmė" },
            { "%%POSIX", "Kompiuteris" },
            { "%%ROZAJ", "Resian" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvizza / Solbica tarmė" },
            { "%%UCCOR", "Suvienodinta rašyba" },
            { "zh_Hans", "supaprastintoji kinų" },
            { "zh_Hant", "tradicinė kinų" },
            { "%%FONIPA", "Tarptautinės abėcėlės fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%PINYIN", "Kinų hieroglifų vertimo sistema Romanization" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskievica tarmė" },
            { "%%UCRCOR", "Suvienodinta ištaisyta rašyba" },
            { "%%AREVELA", "Rytų armėnai" },
            { "%%AREVMDA", "Vakarų armėnai" },
            { "%%MONOTON", "Vienodas" },
            { "%%POLYTON", "Polytonic" },
            { "%%REVISED", "Ištaisyta rašyba" },
            { "%%1606NICT", "1606 -ųjų metų prancūzų kalba" },
            { "%%1694ACAD", "Ankstyvasis Prancūzijos modernizmas" },
            { "%%1959ACAD", "Akademinis" },
            { "%%BAKU1926", "Suvienodinta turkų kalbos lotyniška abėcėlė" },
            { "%%SCOTLAND", "Norminė škotiška anglų kalba" },
            { "%%VALENCIA", "Valenciečiai" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "type.ca.roc", "Kinijos Respublikos kalendorius" },
            { "type.co.eor", "rūšiavimo tvarka daugiakalbės Europos dokumentų" },
            { "type.hc.h11", "12 valandų sistema (0–11)" },
            { "type.hc.h12", "12 valandų sistema (1–12)" },
            { "type.hc.h23", "24 valandų sistema (0–23)" },
            { "type.hc.h24", "24 valandų sistema (1–24)" },
            { "type.m0.bgn", "BGN simboliai" },
            { "type.nu.arab", "arabų-indų skaitmenys" },
            { "type.nu.armn", "armėnų skaitmenys" },
            { "type.nu.bali", "bali skaitmenys" },
            { "type.nu.beng", "bengalų skaitmenys" },
            { "type.nu.brah", "Brahmi skaitmenys" },
            { "type.nu.cakm", "Čakmų skaitmenys" },
            { "type.nu.cham", "cham skaitmenys" },
            { "type.nu.deva", "devanagari skaitmenys" },
            { "type.nu.ethi", "Etiopijos skaitmenys" },
            { "type.nu.geor", "gruzinų skaitmenys" },
            { "type.nu.grek", "graikų skaitmenys" },
            { "type.nu.gujr", "gudžaratų skaitmenys" },
            { "type.nu.guru", "gurmuki skaitmenys" },
            { "type.nu.hans", "supaprastintos kinų k. skaitmenys" },
            { "type.nu.hant", "tradicinės kinų k. skaitmenys" },
            { "type.nu.hebr", "hebrajų skaitmenys" },
            { "type.nu.java", "javiečių skaitmenys" },
            { "type.nu.jpan", "japonų skaitmenys" },
            { "type.nu.kali", "Kayah Li skaitmenys" },
            { "type.nu.khmr", "khmerų skaitmenys" },
            { "type.nu.knda", "kanadų skaitmenys" },
            { "type.nu.lana", "Tai Tham Hora skaitmenys" },
            { "type.nu.laoo", "laosiečių skaitmenys" },
            { "type.nu.latn", "lotyniški skaitmenys" },
            { "type.nu.lepc", "Lepcha skaitmenys" },
            { "type.nu.limb", "Limbu skaitmenys" },
            { "type.nu.mlym", "malajalių skaitmenys" },
            { "type.nu.mong", "mongolų skaitmenys" },
            { "type.nu.mtei", "Meetei Mayek skaitmenys" },
            { "type.nu.mymr", "mianmariečių skaitmenys" },
            { "type.nu.nkoo", "N’Ko skaitmenys" },
            { "type.nu.olck", "Ol Chiki skaitmenys" },
            { "type.nu.orya", "orijų skaitmenys" },
            { "type.nu.osma", "Osmanų skaitmenys" },
            { "type.nu.saur", "Sauraštrų skaitmenys" },
            { "type.nu.shrd", "Šaradų skaitmenys" },
            { "type.nu.sora", "Sora Sompeng skaitmenys" },
            { "type.nu.sund", "Sudaniečių skaitmenys" },
            { "type.nu.takr", "Takri skaitmenys" },
            { "type.nu.talu", "Naujieji Tai Lue skaitmenys" },
            { "type.nu.taml", "tradicinės tamilų skaitmenys" },
            { "type.nu.telu", "telugų skaitmenys" },
            { "type.nu.thai", "tajų skaitmenys" },
            { "type.nu.tibt", "tibetiečių skaitmenys" },
            { "type.nu.vaii", "vai skaitmenys" },
            { "type.ca.dangi", "dangi kalendorius" },
            { "type.co.ducet", "numatytasis unikodo rikiavimas" },
            { "type.lb.loose", "laisvas teksto laužymo stilius" },
            { "type.nu.roman", "romėniški skaitmenys" },
            { "type.ca.coptic", "koptų kalendorius" },
            { "type.ca.hebrew", "hebrajų kalendorius" },
            { "type.ca.indian", "nacionalinis indų kalendorius" },
            { "type.co.compat", "ankstesnė rūšiavimo tvarka, skirta suderinamumui" },
            { "type.co.pinyin", "supaprastinta kiniškų hieroglifų rūšiavimo tvarka" },
            { "type.co.search", "bendroji paieška" },
            { "type.co.stroke", "Įprasta kiniško požymio rūšiavimo tvarka" },
            { "type.co.unihan", "Šaknies ženklų ir brūkšnių rūšiavimo tvarka" },
            { "type.co.zhuyin", "Zhuyin rikiavimo tvarka" },
            { "type.d0.fwidth", "viso pločio" },
            { "type.d0.hwidth", "vidutinio pločio" },
            { "type.lb.normal", "įprastas teksto laužymo stilius" },
            { "type.lb.strict", "griežtas teksto laužymo stilius" },
            { "type.m0.ungegn", "UNGEGN simboliai" },
            { "type.ms.metric", "metrinė sistema" },
            { "type.nu.native", "Vietiniai skaitmenys" },
            { "type.ca.chinese", "kinų kalendorius" },
            { "type.ca.islamic", "islamo kalendorius" },
            { "type.ca.iso8601", "ISO 8601 kalendorius" },
            { "type.ca.persian", "persų kalendorius" },
            { "type.cf.account", "apskaitos valiutos formatas" },
            { "type.co.big5han", "įprasta kiniška rūšiavimo tvarka - Big5" },
            { "type.d0.npinyin", "Skaitinis" },
            { "type.nu.arabext", "išplėstiniai arabų-indų skaitmenys" },
            { "type.nu.armnlow", "armėnų skaitmenys mažosiomis raidėmis" },
            { "type.nu.finance", "Finansiniai skaičiai" },
            { "type.nu.greklow", "graikų skaitmenys mažosiomis raidėmis" },
            { "type.nu.hanidec", "kinų dešimtainiai skaitmenys" },
            { "type.nu.hansfin", "supaprastintos kinų k. finans. skaitmenys" },
            { "type.nu.hantfin", "tradicinės kinų k. finans. skaitmenys" },
            { "type.nu.jpanfin", "japonų finans. skaitmenys" },
            { "type.nu.tamldec", "tamilų skaitmenys" },
            { "type.ca.buddhist", "budistų kalendorius" },
            { "type.ca.ethiopic", "Etiopijos kalendorius" },
            { "type.ca.japanese", "japonų kalendorius" },
            { "type.cf.standard", "standartinis valiutos formatas" },
            { "type.co.phonetic", "Fonetinė rikiavimo tvarka" },
            { "type.co.standard", "standartinis rikiavimas" },
            { "type.ms.uksystem", "angliška matų sistema" },
            { "type.ms.ussystem", "amerikietiška matų sistema" },
            { "type.nu.fullwide", "viso pločio skaitmenys" },
            { "type.nu.lanatham", "Tai Tham Tham skaitmenys" },
            { "type.nu.mymrshan", "Myanmar Shan skaitmenys" },
            { "type.nu.romanlow", "romėniški skaitmenys mažosiomis raidėmis" },
            { "type.ca.gregorian", "Grigaliaus kalendorius" },
            { "type.co.gb2312han", "supaprastinta kiniška rūšiavimo tvarka - GB2312" },
            { "type.co.phonebook", "telefonų knygos rūšiavimo tvarka" },
            { "type.co.dictionary", "žodyno rūšiavimo tvarka" },
            { "type.co.traditional", "įprasta rūšiavimo tvarka" },
            { "type.nu.traditional", "Tradiciniai skaičiai" },
            { "type.ca.islamic-rgsa", "Islamo kalendorius (Saudo Arabija)" },
            { "type.ca.islamic-tbla", "Islamo kalendorius (lentelinis, astronominė era)" },
            { "type.ca.islamic-civil", "Islamo kalendorius (lentelinis, pilietinė era)" },
            { "type.ca.islamic-umalqura", "Islamo kalendorius (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopijos „Amete Alem“ kalendorius" },
        };
        return data;
    }
}
