/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kxv_Orya extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "ଏପିଆ ମାନାଙ୍କ ବେଲା",
               "",
               "ଏପିଆ ଡେଲାଇଟ୍ ବେଲା",
               "",
               "ଏପିଆ ବେଲା",
               "",
            };
        final String[] Cook = new String[] {
               "କୁକ ଦିପ ମାନାଙ୍କ ବେଲା",
               "",
               "କୁକ ଦିପ ଆଦ୍ଦା କାରାଁ ବେଲା",
               "",
               "କୁକ ଦିପ ବେଲା",
               "",
            };
        final String[] Cuba = new String[] {
               "କ୍ୱୁବା ମାନାଙ୍କ ବେଲା",
               "CST",
               "କ୍ୱୁବା ଡେଲାଇଟ୍ ବେଲା",
               "CDT",
               "କ୍ୱୁବା ବେଲା",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ପିଜି ମାନାଙ୍କ ବେଲା",
               "",
               "ପିଜି କାରାଁ ବେଲା",
               "",
               "ପିଜି ବେଲା",
               "",
            };
        final String[] Gulf = new String[] {
               "ଗଲ୍ପ ମାନାଙ୍କ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ହୱଡ ମାନାଙ୍କ ବେଲା",
               "",
               "ହୱଡ କାରାଁ ବେଲା",
               "",
               "ହୱଡ ବେଲା",
               "",
            };
        final String[] Iran = new String[] {
               "ଇରାନ ମାନାଙ୍କ ବେଲା",
               "",
               "ଇରାନ ଡେ ଲାଇଟ୍ ବେଲା",
               "",
               "ଇରାନ ବେଲା",
               "",
            };
        final String[] Niue = new String[] {
               "ନିୟୁ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ଅମସ୍କ ମାନାଙ୍କ ବେଲା",
               "",
               "ଅମସ୍କ କାରାଁ ବେଲା",
               "",
               "ଅମସ୍କ ବେଲା",
               "",
            };
        final String[] Peru = new String[] {
               "ପେରୁ ମାନାଙ୍କ ବେଲା",
               "",
               "ପେରୁ କାରାଁ ବେଲା",
               "",
               "ପେରୁ ବେଲା",
               "",
            };
        final String[] Truk = new String[] {
               "ଚୁକ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ୱେକ ଦିପ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ଚିଲି ମାନାଙ୍କ ବେଲା",
               "",
               "ଚିଲି କାରାଁ ବେଲା",
               "",
               "ଚିଲି ବେଲା",
               "",
            };
        final String[] China = new String[] {
               "ଚିନ ମାନାଙ୍କ ବେଲା",
               "CST",
               "ଚିନ ଡେଲାଇଟ ବେଲା",
               "CDT",
               "ଚିନ ବେଲା",
               "CT",
            };
        final String[] Cocos = new String[] {
               "କକସ ଦିପ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ଡେବିସ୍ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ବାରତ ମାନାଙ୍କ ବେଲା",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ଜାପାନ ମାନାଙ୍କ ବେଲା",
               "JST",
               "ଜାପାନ ଡେଲାଇଟ ବେଲା",
               "JDT",
               "ଜାପାନ ବେଲା",
               "JT",
            };
        final String[] Korea = new String[] {
               "କରିୟା ମାନାଙ୍କ ବେଲା",
               "KST",
               "କରିୟା ଡେଲାଇଟ ବେଲା",
               "KST",
               "କରିୟା ବେଲା",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ନଉରୁ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ନେପାଲ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ପଲାଉ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ସାମଆ ମାନାଙ୍କ ବେଲା",
               "SST",
               "ସାମଆ ଡେଲାଇଟ ବେଲା",
               "SST",
               "ସାମଆ ବେଲା",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ସୱା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ଟଙ୍ଗା ମାନାଙ୍କ ବେଲା",
               "",
               "ଟଙ୍ଗା କାରାଁ ବେଲା",
               "",
               "ଟଙ୍ଗା ବେଲା",
               "",
            };
        final String[] Alaska = new String[] {
               "ଆଲାସ୍କା ମାନାଙ୍କ ବେଲା",
               "AKST",
               "ଆଲାସ୍କା ଡେଲାଇଟ୍ ବେଲା",
               "AKDT",
               "ଆଲାସ୍କା ବେଲା",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ଆମେଜନ ମାନାଙ୍କ ବେଲା",
               "",
               "ଆମେଜନ କାରାଁ ବେଲା",
               "",
               "ଆମେଜନ ବେଲା",
               "",
            };
        final String[] Azores = new String[] {
               "ଅଜରେସ ମାନାଙ୍କ ବେଲା",
               "",
               "ଅଜରେସ କାରାଁ ବେଲା",
               "",
               "ଅଜରେସ ବେଲା",
               "",
            };
        final String[] Bhutan = new String[] {
               "ବୁଟାନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ବ୍ରୁନେଇ ଦାରୁସାଲାମ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ଇସ୍ଟର ଦିପ ମାନାଙ୍କ ବେଲା",
               "",
               "ଇସ୍ଟର ଦିପ କାରାଁ ବେଲା",
               "",
               "ଇସ୍ଟର ଦିପ ବେଲା",
               "",
            };
        final String[] Guyana = new String[] {
               "ଗୁୟାନା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "ଇଜରାଇଲ ମାନାଙ୍କ ବେଲା",
               "IST",
               "ଇଜରାଇଲ ଡେଲାଇଟ ବେଲା",
               "IDT",
               "ଇଜରାଇଲ ବେଲା",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "କସରାଏ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ମାୱସନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ମସ୍କ ମାନାଙ୍କ ବେଲା",
               "MSK",
               "ମସ୍କ କାରାଁ ବେଲା",
               "MSK",
               "ମସ୍କ ବେଲା",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ପନାପେ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ତାହିତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ତାଇପେ ମାନଙ୍କ ବେଲା",
               "CST",
               "ତାଇପେ ଡେଲାଇଟ ବେଲା",
               "CDT",
               "ତାଇପେ ବେଲା",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ତୁୱାଲୁ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ୱସ୍ତକ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ୱାଲିସ ଅଡ଼େ ପୁଟୁନା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ଆରବିଆତି ମାନାଙ୍କ ବେଲା",
               "",
               "ଆରବିଆତି ମେଦାଣା ବେଲା",
               "",
               "ଆରବିଆତି ବେଲା",
               "",
            };
        final String[] Armenia = new String[] {
               "ଆରମେନିୟା ମାନାଙ୍କ ବେଲା",
               "",
               "ଆରମେନିୟା କାରାଁ ବେଲା",
               "",
               "ଆରମେନିୟା ବେଲା",
               "",
            };
        final String[] Bolivia = new String[] {
               "ବଲୱିଆ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ଚାତାମ ମାନାଙ୍କ ବେଲା",
               "",
               "ଚାତାମ ଡେଲାଇଟ୍ ବେଲା",
               "",
               "ଚାତାମ ବେଲା",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ଇକ୍ୱାଡର ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ଗମ୍ବିୟର ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ଜର୍ଜିୟା ମାନାଙ୍କ ବେଲା",
               "",
               "ଜର୍ଜିୟା କାରା ବେଲା",
               "",
               "ଜର୍ଜିୟା ବେଲା",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ଇରକୁସ୍ତକ ମାନାଙ୍କ ବେଲା",
               "",
               "ଇରକୁସ୍ତକ କାରାଁ ବେଲା",
               "",
               "ଇରକୁସ୍ତକ ବେଲା",
               "",
            };
        final String[] Magadan = new String[] {
               "ମାଗାଦାନ ମାନଙ୍କ ବେଲା",
               "",
               "ମାଗାଦାନ କାରାଁ ବେଲା",
               "",
               "ମାଗାଦାନ ଦିପ ବେଲା",
               "",
            };
        final String[] Myanmar = new String[] {
               "ମ୍ୟାଁମାର ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ନରପାଁକ ଦିପ ମାନାଙ୍କ ବେଲା",
               "",
               "ନରପାଁକ ଦିପ ଡେଲାଇଟ ବେଲା",
               "",
               "ନରପାଁକ ଦିପ ବେଲା",
               "",
            };
        final String[] Noronha = new String[] {
               "ପର୍ନାଡ ଡେ ନରହ୍ନ ମାନାଙ୍କା ବେଲା",
               "",
               "ପର୍ନାଡ ଡେ ନରହ୍ନ କାରାଁ ବେଲା",
               "",
               "ପେର୍ନାଡ ଡେ ନରହ୍ନ ବେଲା",
               "",
            };
        final String[] Reunion = new String[] {
               "ରିୟୁନିୟନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ରତେରା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ସଲମନ ଦିପତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ଟକେଲାଉ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ଉରୁଗ୍ୱେ ମାନାଙ୍କ ବେଲା",
               "",
               "ଉରୁଗ୍ୱେ କାରାଁ ବେଲା",
               "",
               "ଉରୁଗ୍ୱେ ବେଲା",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ୱନୁଆତୁ ମାନାଙ୍କ ବେଲା",
               "",
               "ୱନୁଆତୁ କାରାଁ ବେଲା",
               "",
               "ୱନୁଆତୁ ବେଲା",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ୟାକୁତ୍ସକ ମାନାଙ୍କ ବେଲା",
               "",
               "ୟାକୁତ୍ସକ କାରାଁ ବେଲା",
               "",
               "ୟାକୁତ୍ସକ ବେଲା",
               "",
            };
        final String[] Atlantic = new String[] {
               "ଆଟ୍ଲାଣ୍ଟିକ ମାନାଙ୍କ ବେଲା",
               "AST",
               "ଆଟ୍ଲାଣ୍ଟିକ ଡେଲାଇଟ ବେଲା",
               "AST",
               "ଆଟ୍ଲାଣ୍ଟିକ ବେଲା",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ବ୍ରାଜିଲିୟା ମାନକ ବେଲା",
               "",
               "ବ୍ରାଜିଲିୟା କାରାଁ ବେଲା",
               "",
               "ବ୍ରାଜିଲିୟା ବେଲା",
               "",
            };
        final String[] Chamorro = new String[] {
               "ଚମର ମାନାଙ୍କ ବେଲା",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "କଲମ୍ବିୟା ମାନାଙ୍କ ବେଲା",
               "",
               "କଲମ୍ବିୟା କାରାଁ ବେଲା",
               "",
               "କଲମ୍ବିୟା ବେଲା",
               "",
            };
        final String[] Falkland = new String[] {
               "ପାକଲାଣ୍ଡ ଦିପତି ମାନାଙ୍କ ବେଲା",
               "",
               "ପାକଲାଣ୍ଡ ଦିପତି କାରାଁ ବେଲା",
               "",
               "ପାକଲାଣ୍ଡ ଦିପ ବେଲା",
               "",
            };
        final String[] Malaysia = new String[] {
               "ମାଲେସିୟା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "ମାଲଡ୍ୱିସ୍ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ଉଲାନ ବଟର ମାନାଙ୍କ ବେଲା",
               "",
               "ଉଲାନ ବଟର କାରାଁ ବେଲା",
               "",
               "ଉଲାନ ବଟର ବେଲା",
               "",
            };
        final String[] Pakistan = new String[] {
               "ପାକିସ୍ତାନ ମାନାଙ୍କ ବେଲା",
               "PKT",
               "ପାକିସ୍ତାନ କାରାଁ ବେଲା",
               "PKST",
               "ପାକିସ୍ତାନ ବେଲା",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ପେରାଗ୍ୱେ ମାନାଙ୍କ ବେଲା",
               "",
               "ପେରାଗ୍ୱେ କାରାଁ ବେଲା",
               "",
               "ପେରାଗ୍ୱେ ବେଲା",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ପିଟକଇରନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "ସକାଲିନ ମାନାଙ୍କ ବେଲା",
               "",
               "ସକାଲିନ କାରାଁ ବେଲା",
               "",
               "ସକାଲିନ ବେଲା",
               "",
            };
        final String[] Suriname = new String[] {
               "ସୁରିନାମ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ଆରଜେଣ୍ଟିନା ମାନାଙ୍କ ବେଲା",
               "",
               "ଆର୍ଜେଣ୍ଟିନା କାରା ବେଲା",
               "",
               "ଆରଜେଣ୍ଟିନା ବେଲା",
               "",
            };
        final String[] Christmas = new String[] {
               "କ୍ରିସମାସ ଦିପ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ଗଲାପଗସ ତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ହଙ୍ଗ କଙ୍ଗ ମାନାଙ୍କ ବେଲା",
               "HKT",
               "ହଙ୍ଗ କଙ୍କ କାରାଁ ବେଲା",
               "HKST",
               "ହଙ୍ଗ କଙ୍ଗ ବେଲା",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ଇଣ୍ଡଚିନା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "କିର୍ଗିସ୍ତାନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ଲର୍ଡ ହୱେ ମାନାଙ୍କ ବେଲା",
               "",
               "ଲର୍ଡ ହୱେ ଡେଲାଇଟ୍ ବେଲା",
               "",
               "ଲର୍ଡ ହୱେ ବେଲା",
               "",
            };
        final String[] Marquesas = new String[] {
               "ମାର୍କସସ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ମରିସସ୍ ମାନାଙ୍କ ବେଲା",
               "",
               "ମରିସସ୍ କାରାଁ ବେଲା",
               "",
               "ମରିସସ୍ ବେଲା",
               "",
            };
        final String[] Singapore = new String[] {
               "ସାଙ୍ଗାପୁର ମାନାଙ୍କ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ୱେନେଜୁଏଲା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "ୱାଲଗଗ୍ରାଡ ମାନାଙ୍କ ବେଲା",
               "MSK",
               "ୱାଲଗଗ୍ରାଡ କାରାଁ ବେଲା",
               "MSK",
               "ୱାଲଗଗ୍ରାଡ ବେଲା",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "ଅଜେରବାଇଜାନ ମାନାଙ୍କ ବେଲା",
               "",
               "ଅଜେରବାଇଜାନ କାରାଁ ବେଲା",
               "",
               "ଅଜେରବାଇଜାନ ବେଲା",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ବାଙ୍ଗଲାଦେସ୍ ମାନାଙ୍କ ବେଲା",
               "",
               "ବାଙ୍ଗଲାଦେସ୍ କାରାଁ ବେଲା",
               "",
               "ବାଙ୍ଗଲାଦେସ୍ ବେଲା",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "କେପ ବର୍ଡ ମାନାଙ୍କ ବେଲା",
               "",
               "କେପ ବର୍ଡ କାରାଁ ବେଲା",
               "",
               "କେପ ବର୍ଡ ବେଲା",
               "",
            };
        final String[] East_Timor = new String[] {
               "ୱେଡ଼ାହପୁ ତିମର ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "କଜାକାସ୍ତାନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ସେସେଲ୍ସ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ତାଜିକିସ୍ତାନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ଉଜ୍ୱେକିସ୍ତାନ ମାନାଙ୍କ ବେଲା",
               "",
               "ଉଜ୍ୱେକିସ୍ତାନ କାରାଁ ବେଲା",
               "",
               "ଉଜ୍ୱେକିସ୍ତାନ ବେଲା",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ଆପଗାନିସ୍ତାନ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "କ୍ରାସ୍ନୟାର୍ସ୍କ ମାନାଙ୍କ ବେଲା",
               "",
               "କ୍ରାସ୍ନାର୍ସ୍କ କାରାଁ ବେଲା",
               "",
               "କ୍ରାସ୍ନୟାର୍ସ୍କ ବେଲା",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ନ୍ୟୁଜିଲାଣ୍ଡ ମାନାଙ୍କ ବେଲା",
               "NZST",
               "ନ୍ୟୁଜିଲାଣ୍ଡ ଡେଲାଇଟ ବେଲା",
               "NZDT",
               "ନ୍ୟୁଜିଲାଣ୍ଡ ବେଲା",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "ନୱସିବିର୍ସ୍କ ମାନାଙ୍କ ବେଲା",
               "",
               "ନୱସିବର୍ସ୍କ କାରାଁ ବଲା",
               "",
               "ନୱସିବିର୍ସ୍କ ବେଲା",
               "",
            };
        final String[] Philippines = new String[] {
               "ପିଲିପିନ ମାନାଙ୍କ ବେଲା",
               "PST",
               "ପିଲିପିନ କାରାଁ ବେଲା",
               "PDT",
               "ପିଲିପିନ ବେଲା",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ୱ୍ଲାଦିୱସ୍ତକ ମାନାଙ୍କ ବେଲା",
               "",
               "ୱ୍ଲାଦିୱସ୍ତକ କାରାଁ ବେଲା",
               "",
               "ୱ୍ଲାଦିୱସ୍ତକ ବେଲା",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ବାରତ କାଜା ସାମୁଦ୍ରି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ଲାଇନ ଦିପତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ନ୍ୟୁପାଉଣ୍ଡଲାଣ୍ଡ ମାନାଙ୍କ ବେଲା",
               "NST",
               "ନ୍ୟୁପାଉଣ୍ଡଲାଣ୍ଡ ଡେଲାଇଟ ବେଲା",
               "NDT",
               "ନ୍ୟୁପାଉଣ୍ଡଲାଣ୍ଡ ବେଲା",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ତୁର୍କମେନିସ୍ତାନ ମାନାଙ୍କ ବେଲା",
               "",
               "ତୁର୍କମେନିସ୍ତାନ କାରାଁ ବେଲା",
               "",
               "ତୁର୍କମେନିସ୍ତାନ ବେଲା",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ପ୍ରେଞ୍ଚ୍ ଗୁୟାନା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ନ୍ୟୁ କେଲେଡନିୟା ମାନାଙ୍କ ବେଲା",
               "",
               "ନ୍ୟୁ କେଲେଡନିୟା କାରାଁ ବେଲା",
               "",
               "ନ୍ୟୁ କେଲେଡନିୟା ବେଲା",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ଦକିଣ ଜର୍ଜିୟା ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ୟେକାତେରିନବର୍ଗ ମାନାଙ୍କ ବେଲା",
               "",
               "ୟେକାତେରିନବର୍ଗ କାରାଁ ବେଲା",
               "",
               "ୟେକାତେରିନବର୍ଗ ବେଲା",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ମାଦିନି ଆପ୍ରିକା ବେଲା",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ୱେଡ଼ା ହପୁ ଆପ୍ରିକା ବେଲା",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ୱେଡ଼ା କୁଣ୍‍ପୁ ଆପ୍ରିକା ମାନାଙ୍କ ବେଲା",
               "WAT",
               "ୱେଡ଼ା କୁଣ୍‍ପୁ ଆପ୍ରିକା କାରାଁ ବେଲା",
               "WAT",
               "ୱେଡ଼ା କୁଣ୍‍ପୁ ଆପ୍ରିକା ବେଲା",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ଡ୍ୟୁମାଣ୍ଟ ଡି ଅରୱିଲେ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ମାଦିନି ୟୁରପିଆ ତି ମାନାଙ୍କ ବେଲା",
               "CET",
               "ମାଦିନା ୟୁରପିଆ ତି କାରାଁ ବେଲା",
               "CEST",
               "ମାଦିନି ୟୁରପିଆ ତି ବେଲା",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ୱେଡ଼ାହପୁ ୟୁରପିଆତି ମାନାଙ୍କ ବେଲା",
               "EET",
               "ୱେଡ଼ାହପୁ ୟୁରପିଆତି କାରାଁ ବେଲା",
               "EEST",
               "ୱେଡ଼ା ହପୁ ୟୁରପତି ବେଲା",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ୱେଡ଼ାକୁଣ୍‍ପୁ ୟୁରପିଆତି ମାନାଙ୍କ ବେଲା",
               "WET",
               "ୱେଡ଼ାକୁଣ୍‍ପୁ ୟୁରପତି କାରାଁ ବେଲା",
               "WEST",
               "ୱେଡ଼ାକୁଣ୍‍ପୁ ୟୁରପତି ବେଲା",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ମେକ୍ସିକତି ପେସିପିକ ମାନାଙ୍କ ବେଲା",
               "MST",
               "ମେକ୍ସିକତି ପେସିପିକ ଡେଲାଇଟ ବେଲା",
               "MDT",
               "ମେକ୍ସିକତି ପେସିପିକ ବେଲା",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ଦକିଣ ଆପ୍ରିକା ମାନାଙ୍କ ବେଲା",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ମାଦିନି ମାନାଙ୍କ ବେଲା",
               "CST",
               "ମାଦିନି ଡେଲାଇଟ୍ ବେଲା",
               "CDT",
               "ମାଦିନି ବେଲା",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ୱେଡ଼ାହପୁ ଜାଗାତି ମାନାଙ୍କ ବେଲା",
               "EST",
               "ୱେଡ଼ାହପୁ ଜାଗାତି ଡେଲାଇଟ୍ ବେଲା",
               "EST",
               "ୱେଡ଼ାହପୁତି ଜାଗା ବେଲା",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ପେସିପିକ୍ ମାନାଙ୍କ ବେଲା",
               "PST",
               "ପେସିପିକ୍ ଡେଲାଇଟ୍ ବେଲା",
               "PDT",
               "ପେସିପିକ୍ ବେଲା",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ପ୍ରେଞ୍ଚ ଦକିଣ ଅଡ଼େ ଆଣ୍ଟାରଟିକ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ଗିଲ୍‍ବେର୍ଟ ଦିପତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ହାୱାଇ-ଆଲ୍ୟୁସାନ ମାନାଙ୍କ ବେଲା",
               "HST",
               "ହାୱାଇ-ଆଲ୍ୟୁସାନ ଡେ ଲାଇଟ ବେଲା",
               "HST",
               "ହାୱାଇ-ଆଲ୍ୟୁସାନ ବେଲା",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "ପିନିକ୍ସ ଦିପତି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ ମାନାଙ୍କ ବେଲା",
               "",
               "ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ ଡେଲାଇଟ ବେଲା",
               "",
               "ସେଣ୍ଟ ପିଏରେ ଅଡ଼େ ମିକ୍ୱେଲାନ ବେଲା",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ହର୍କା ମାନାଙ୍କ ବେଲା",
               "MST",
               "ହର୍କା ଡେଲାଇଟ୍ ବେଲା",
               "MST",
               "ହର୍କା ବେଲା",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "ମାର୍ସାଲ ଦିପ ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ପାପୁୟା ପୁନି ଗିନି ବେଲା",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ଅସ୍ଟ୍ରେଲିଆତି ମାଦିନି ମାନାଙ୍କ ବେଲା",
               "ACST",
               "ଅସ୍ଟ୍ରେଲିଆତି ମାଦିନି ଡେଲାଇଟ ବେଲା",
               "ACDT",
               "ମାଦିନି ଅସ୍ଟ୍ରେଲିଆ ବେଲା",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ଅସ୍ଟ୍ରେଲିଆତି ୱେଡ଼ାହପୁ ମାନାଙ୍କ ବେଲା",
               "AEST",
               "ଅସ୍ଟ୍ରେଲିଆତି ୱେଡ଼ାହପୁ ଡେଲାଇଟ ବେଲା",
               "AEDT",
               "ୱେଡ଼ାହପୁ ଅସ୍ଟ୍ରେଲିଆ ବେଲା",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ଅସ୍ଟ୍ରେଲିଆତି ୱେଡ଼ାକୁଣ୍‍ପୁ ମାନାଙ୍କ ବେଲା",
               "AWST",
               "ଅସ୍ଟ୍ରେଲିଆତି ୱେଡ଼ାକୁଣ୍‍ପୁ ଡେଲାଇଟ ବେଲା",
               "AWDT",
               "ୱେଡ଼ାକୁଣ୍‍ପୁ ଅସ୍ଟ୍ରେଲିଆ ବେଲା",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ମାଦିନି ଇଣ୍ଡନେସିଆ ବେଲା",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ୱେଡ଼ାହପୁ ଇଣ୍ଡନେସିଆ ବେଲା",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ୱେଡ଼ାକୁଣ୍ପୁ ଇଣ୍ଡନେସିଆ ବେଲା",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ଅସ୍ଟ୍ରେଲିଆତି ମାଦିନି ୱେଡ଼ାକୁଣ୍‍ପୁ ମାନାଙ୍କ ବେଲା",
               "",
               "ଅସ୍ଟ୍ରେଲିଆତି ମାଦିନି ୱେଡ଼ାକୁଣ୍‍ପୁ ଡେଲାଇଟ ବେଲା",
               "",
               "ଅସ୍ଟ୍ରେଲିଆତି ମାଦିନି ୱେଡ଼ାକୁଣ୍‍ପୁ ବେଲା",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ଆଇରିସ୍ ମାନାଙ୍କ ବେଲା",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ସମାନି ଜାଗା ପ୍ରୁତି ବେଲା",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ଆଇରିସ୍ ମାନାଙ୍କ ବେଲା",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ଗ୍ରିନୱିଚ ମିନ ବେଲା",
                    "GMT",
                    "ବ୍ରିଟିଶ୍‌ କାରାଁ ବେଲା",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ଏଡେନ୍‌" },
            { "timezone.excity.Asia/Baku", "ବାକୁ" },
            { "timezone.excity.Asia/Dili", "ଦିଲ୍ଲୀ" },
            { "timezone.excity.Asia/Gaza", "ଗାଜା" },
            { "timezone.excity.Asia/Hovd", "ହୋୱଡ୍‌" },
            { "timezone.excity.Asia/Omsk", "ଓମସ୍କ" },
            { "timezone.excity.Asia/Oral", "ଅରାଲ୍‌" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "ଅମ୍ମାନ" },
            { "timezone.excity.Asia/Aqtau", "ଆକଟାଉ" },
            { "timezone.excity.Asia/Chita", "ଚିଟା" },
            { "timezone.excity.Asia/Dhaka", "ଡାକା" },
            { "timezone.excity.Asia/Dubai", "ଦୁବାଇ" },
            { "timezone.excity.Asia/Kabul", "କବୁଲ୍" },
            { "timezone.excity.Asia/Macau", "ମାକାଉ" },
            { "timezone.excity.Asia/Qatar", "କତାର୍" },
            { "timezone.excity.Asia/Seoul", "ସିଅଲ" },
            { "timezone.excity.Asia/Tokyo", "ଟକିଅ" },
            { "timezone.excity.Asia/Tomsk", "ଟମସ୍କ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ଜୁବା" },
            { "timezone.excity.Africa/Lome", "ଲମ୍‌" },
            { "timezone.excity.Asia/Almaty", "ଅଲମାଟି" },
            { "timezone.excity.Asia/Anadyr", "ଆନାଡୟାର୍" },
            { "timezone.excity.Asia/Aqtobe", "ଆକ୍ଟବେ" },
            { "timezone.excity.Asia/Atyrau", "ଅତିରାଉ" },
            { "timezone.excity.Asia/Beirut", "ବୀରୁଟ୍‌" },
            { "timezone.excity.Asia/Brunei", "ବ୍ରୁନେଇ" },
            { "timezone.excity.Asia/Hebron", "ହେବ୍ରନ୍‌" },
            { "timezone.excity.Asia/Kuwait", "କୁଏତ" },
            { "timezone.excity.Asia/Manila", "ମାନିଲା" },
            { "timezone.excity.Asia/Muscat", "ମସ୍କାଟ୍‌" },
            { "timezone.excity.Asia/Riyadh", "ରିଆଦ" },
            { "timezone.excity.Asia/Saigon", "ହ ଚି ମିନ୍‌ ସିଟି" },
            { "timezone.excity.Asia/Taipei", "ତାଇପେଇ" },
            { "timezone.excity.Asia/Tehran", "ତେହେରାନ୍" },
            { "timezone.excity.Asia/Urumqi", "ଉରୁମକି" },
            { "timezone.excity.Etc/Unknown", "ପୁଣ୍ଆଁ ତି ଗାଡ଼ା" },
            { "timezone.excity.Europe/Kiev", "କିଏଭ୍" },
            { "timezone.excity.Europe/Oslo", "ଅସଲୋ" },
            { "timezone.excity.Europe/Riga", "ରିଗା" },
            { "timezone.excity.Europe/Rome", "ରମ୍" },
            { "timezone.excity.Indian/Mahe", "ମାହେ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ଏକ୍ରା" },
            { "timezone.excity.Africa/Cairo", "କାଇର" },
            { "timezone.excity.Africa/Ceuta", "ସେଉଟା" },
            { "timezone.excity.Africa/Dakar", "ଡକାର" },
            { "timezone.excity.Africa/Lagos", "ଲାଗସ୍‌" },
            { "timezone.excity.Africa/Tunis", "ଟୁନିସ୍‌" },
            { "timezone.excity.America/Adak", "ଆଡାକ୍" },
            { "timezone.excity.America/Lima", "ଲିମା" },
            { "timezone.excity.America/Nome", "ନୋମେ" },
            { "timezone.excity.Asia/Baghdad", "ବାଗଦାଦ୍‌" },
            { "timezone.excity.Asia/Bahrain", "ବହାରେନ" },
            { "timezone.excity.Asia/Bangkok", "ବ୍ୟାଙ୍ଗକକ୍‌" },
            { "timezone.excity.Asia/Barnaul", "ବାରନାଉଲ୍" },
            { "timezone.excity.Asia/Bishkek", "ବିସକେକ୍‌" },
            { "timezone.excity.Asia/Colombo", "କଲମ୍ବୋ" },
            { "timezone.excity.Asia/Irkutsk", "ଇରକୁଟସ୍କ" },
            { "timezone.excity.Asia/Jakarta", "ଜାକର୍ତା" },
            { "timezone.excity.Asia/Karachi", "କରାଚି" },
            { "timezone.excity.Asia/Kuching", "କୁଚିଂ" },
            { "timezone.excity.Asia/Magadan", "ମାଗାଡାନ୍" },
            { "timezone.excity.Asia/Nicosia", "ନିକସିଆ" },
            { "timezone.excity.Asia/Rangoon", "ୟାଙ୍ଗୁନ୍‌" },
            { "timezone.excity.Asia/Tbilisi", "ଟିବିଲିସି" },
            { "timezone.excity.Asia/Thimphu", "ତିମ୍ପୁ" },
            { "timezone.excity.Asia/Yakutsk", "ୟାକୁଟସ୍କ" },
            { "timezone.excity.Asia/Yerevan", "ୟେରେବାନ୍" },
            { "timezone.excity.Europe/Kirov", "କିରୱ" },
            { "timezone.excity.Europe/Malta", "ମାଲଟା" },
            { "timezone.excity.Europe/Minsk", "ମିନସ୍କ" },
            { "timezone.excity.Europe/Paris", "ପେରିସ୍" },
            { "timezone.excity.Europe/Sofia", "ସପିୟା" },
            { "timezone.excity.Europe/Vaduz", "ବାଡୁଜ" },
            { "timezone.excity.Indian/Cocos", "କକସ୍‌" },
            { "timezone.excity.Pacific/Apia", "ଆପିଆ" },
            { "timezone.excity.Pacific/Fiji", "ପିଜି" },
            { "timezone.excity.Pacific/Guam", "ଗୁଆମ" },
            { "timezone.excity.Pacific/Niue", "ନିୟୂ" },
            { "timezone.excity.Pacific/Truk", "ଚୂକ୍‌" },
            { "timezone.excity.Pacific/Wake", "ୱେକ୍" },
            { "timezone.excity.Africa/Asmera", "ଅସମରା" },
            { "timezone.excity.Africa/Bamako", "ବାମାକ" },
            { "timezone.excity.Africa/Bangui", "ବାଙ୍ଗୁଇ" },
            { "timezone.excity.Africa/Banjul", "ବାଞ୍ଜୁଲ" },
            { "timezone.excity.Africa/Bissau", "ବିସାଉ" },
            { "timezone.excity.Africa/Douala", "ଡଉଲା" },
            { "timezone.excity.Africa/Harare", "ହରାରେ" },
            { "timezone.excity.Africa/Kigali", "କିଗାଲି" },
            { "timezone.excity.Africa/Luanda", "ଲୁଆଣ୍ଡା" },
            { "timezone.excity.Africa/Lusaka", "ଲୁସାକା" },
            { "timezone.excity.Africa/Malabo", "ମାଲାବ" },
            { "timezone.excity.Africa/Maputo", "ମାପୁତୋ" },
            { "timezone.excity.Africa/Maseru", "ମେସେରୁ" },
            { "timezone.excity.Africa/Niamey", "ନିଆମି" },
            { "timezone.excity.America/Aruba", "ଅରୁବା" },
            { "timezone.excity.America/Bahia", "ବାହିଆ" },
            { "timezone.excity.America/Belem", "ବେଲେମ" },
            { "timezone.excity.America/Boise", "ବଇସେ" },
            { "timezone.excity.America/Jujuy", "ଜୁଜୋଏ" },
            { "timezone.excity.America/Sitka", "ସିଟକା" },
            { "timezone.excity.America/Thule", "ତୁଲେ" },
            { "timezone.excity.Asia/Ashgabat", "ଆସ୍‍ଗାବଟ୍" },
            { "timezone.excity.Asia/Calcutta", "କୋଲକାତା" },
            { "timezone.excity.Asia/Damascus", "ଡାମାସକସ୍‌" },
            { "timezone.excity.Asia/Dushanbe", "ଦୁସାନବେ" },
            { "timezone.excity.Asia/Jayapura", "ଜୟପୁରା" },
            { "timezone.excity.Asia/Katmandu", "କାଟମାଣ୍ଡୁ" },
            { "timezone.excity.Asia/Khandyga", "କାନଡ୍ୟାଗା" },
            { "timezone.excity.Asia/Makassar", "ମାକାସାର୍‌" },
            { "timezone.excity.Asia/Qostanay", "କଷ୍ଟନେ" },
            { "timezone.excity.Asia/Sakhalin", "ସକାଲିନ୍" },
            { "timezone.excity.Asia/Shanghai", "ସଂଗାଇ" },
            { "timezone.excity.Asia/Tashkent", "ତାସକେଣ୍ଟ" },
            { "timezone.excity.Asia/Ust-Nera", "ୟୁସ୍‍ଟ-ନେରା" },
            { "timezone.excity.Europe/Athens", "ଏତେନ୍ସ" },
            { "timezone.excity.Europe/Berlin", "ବର୍ଲିନ୍" },
            { "timezone.excity.Europe/Dublin", "ଡବଲିନ୍" },
            { "timezone.excity.Europe/Jersey", "ଜର୍ସି" },
            { "timezone.excity.Europe/Lisbon", "ଲିସବୋନ୍" },
            { "timezone.excity.Europe/London", "ଲଣ୍ଡନ୍" },
            { "timezone.excity.Europe/Madrid", "ମାଡ୍ରିଡ୍" },
            { "timezone.excity.Europe/Monaco", "ମନାକ" },
            { "timezone.excity.Europe/Moscow", "ମସ୍କ" },
            { "timezone.excity.Europe/Prague", "ପ୍ରାଗ୍" },
            { "timezone.excity.Europe/Samara", "ସାମାରା" },
            { "timezone.excity.Europe/Skopje", "ସ୍କପୟେ" },
            { "timezone.excity.Europe/Tirane", "ଟାଇରେନ୍" },
            { "timezone.excity.Europe/Vienna", "ୱିଏନା" },
            { "timezone.excity.Europe/Warsaw", "ୱାରସୱା" },
            { "timezone.excity.Europe/Zagreb", "ଜାଗ୍ରେବ୍" },
            { "timezone.excity.Europe/Zurich", "ଜୁରିକ୍" },
            { "timezone.excity.Indian/Chagos", "ଚାଗୋସ୍‌" },
            { "timezone.excity.Indian/Comoro", "କମର" },
            { "timezone.excity.Pacific/Efate", "ଇଫେଟ୍‌" },
            { "timezone.excity.Pacific/Nauru", "ନାଉରୁ" },
            { "timezone.excity.Pacific/Palau", "ପାଲାଉ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ଆବିଦଜାନ" },
            { "timezone.excity.Africa/Algiers", "ଅଲଜିୟର୍ସ" },
            { "timezone.excity.Africa/Conakry", "କନାକ୍ରି" },
            { "timezone.excity.Africa/Kampala", "କାମ୍ପାଲା" },
            { "timezone.excity.Africa/Mbabane", "ମ୍-ବାବାନେ" },
            { "timezone.excity.Africa/Nairobi", "ନାଇରବି" },
            { "timezone.excity.Africa/Tripoli", "ତ୍ରିପଲି" },
            { "timezone.excity.America/Belize", "ବେଲିଜେ" },
            { "timezone.excity.America/Bogota", "ବଗଟା" },
            { "timezone.excity.America/Cancun", "କାନକୁନ୍" },
            { "timezone.excity.America/Cayman", "କାୟମ୍ୟାନ୍" },
            { "timezone.excity.America/Cuiaba", "କୁଇବା" },
            { "timezone.excity.America/Dawson", "ଡସନ୍‌" },
            { "timezone.excity.America/Denver", "ଡେନୱିର୍" },
            { "timezone.excity.America/Guyana", "ଗୁଏନା" },
            { "timezone.excity.America/Havana", "ହାୱନା" },
            { "timezone.excity.America/Inuvik", "ଇନୁୱିକ୍" },
            { "timezone.excity.America/Juneau", "ଜୁନେଆଉ" },
            { "timezone.excity.America/La_Paz", "ଲା ପାଜ" },
            { "timezone.excity.America/Maceio", "ମାସିଅ" },
            { "timezone.excity.America/Manaus", "ମାନାଉସ୍‌" },
            { "timezone.excity.America/Merida", "ମେରିଡା" },
            { "timezone.excity.America/Nassau", "ନାସାଉ" },
            { "timezone.excity.America/Panama", "ପାନାମା" },
            { "timezone.excity.America/Recife", "ରେସିପି" },
            { "timezone.excity.America/Regina", "ରେଗିନା" },
            { "timezone.excity.Asia/Famagusta", "ପାମାଗୁସ୍ଟା" },
            { "timezone.excity.Asia/Hong_Kong", "ହଂ କଂ" },
            { "timezone.excity.Asia/Jerusalem", "ଜେରୁଜେଲମ" },
            { "timezone.excity.Asia/Kamchatka", "କାମଚାଟକା" },
            { "timezone.excity.Asia/Pontianak", "ପଣ୍ଟିଆନାକ୍‌" },
            { "timezone.excity.Asia/Pyongyang", "ପୋୟଙ୍ଗୟାଙ୍ଗ" },
            { "timezone.excity.Asia/Qyzylorda", "କୀଜିଲର୍ଡା" },
            { "timezone.excity.Asia/Samarkand", "ସମରକନ୍ଦ" },
            { "timezone.excity.Asia/Singapore", "ସିଙ୍ଗାପୁର୍‌" },
            { "timezone.excity.Asia/Vientiane", "ୱିଏଣ୍ଟିଏନ୍‌" },
            { "timezone.excity.Europe/Andorra", "ଆଣ୍ଡରା" },
            { "timezone.excity.Europe/Saratov", "ସାରାଟୱ୍" },
            { "timezone.excity.Europe/Tallinn", "ଟାଲିନ୍ନ" },
            { "timezone.excity.Europe/Vatican", "ୱାଟିକାନ୍" },
            { "timezone.excity.Europe/Vilnius", "ୱିଲନିଉସ୍" },
            { "timezone.excity.Indian/Mayotte", "ମାୟଟେ" },
            { "timezone.excity.Indian/Reunion", "ରିୟୁନିଅନ୍‌" },
            { "timezone.excity.Pacific/Easter", "ଇଷ୍ଟର୍‌" },
            { "timezone.excity.Pacific/Kanton", "କେଣ୍ଟନ" },
            { "timezone.excity.Pacific/Kosrae", "କୋସରେଇ" },
            { "timezone.excity.Pacific/Majuro", "ମାଜୁର" },
            { "timezone.excity.Pacific/Midway", "ମିଡ୍‌ୱେ" },
            { "timezone.excity.Pacific/Noumea", "ନଉମିୟ" },
            { "timezone.excity.Pacific/Ponape", "ପହନପେଇ" },
            { "timezone.excity.Pacific/Saipan", "ସାଇପାନ୍" },
            { "timezone.excity.Pacific/Tahiti", "ତାହିତି" },
            { "timezone.excity.Pacific/Tarawa", "ତାରୱା" },
            { "timezone.excity.Pacific/Wallis", "ୱାଲିସ୍‌" },
            { "timezone.excity.Africa/Blantyre", "ବ୍ଲାଣ୍ଟାୟାର୍‌" },
            { "timezone.excity.Africa/Djibouti", "ଜିବଟି" },
            { "timezone.excity.Africa/El_Aaiun", "ଏଲ୍‌ ଏୟନ୍" },
            { "timezone.excity.Africa/Freetown", "ପ୍ରିଟାଉନ୍‌" },
            { "timezone.excity.Africa/Gaborone", "ଗାବର୍ଣ୍ଣ" },
            { "timezone.excity.Africa/Khartoum", "କରଟଉମ୍‌" },
            { "timezone.excity.Africa/Kinshasa", "କିନସାସ୍‌" },
            { "timezone.excity.Africa/Monrovia", "ମନରୋବିଆ" },
            { "timezone.excity.Africa/Ndjamena", "ଜାମେନା" },
            { "timezone.excity.Africa/Sao_Tome", "ସାଅ ଟମେ" },
            { "timezone.excity.Africa/Windhoek", "ୱିଣ୍ଡହକ୍" },
            { "timezone.excity.America/Antigua", "ଆଣ୍ଟିଗୁଆ" },
            { "timezone.excity.America/Caracas", "କାରକାସ୍‌" },
            { "timezone.excity.America/Cayenne", "କେୟେନ୍ନି" },
            { "timezone.excity.America/Chicago", "ସିକାଗ" },
            { "timezone.excity.America/Cordoba", "କୋଡୋବା" },
            { "timezone.excity.America/Creston", "କ୍ରେସ୍‍ଟନ" },
            { "timezone.excity.America/Curacao", "କୁରାକ" },
            { "timezone.excity.America/Detroit", "ଡେଟ୍ରଇଟ୍" },
            { "timezone.excity.America/Godthab", "ନୁଉକ୍" },
            { "timezone.excity.America/Grenada", "ଗ୍ରେନାଡା" },
            { "timezone.excity.America/Halifax", "ହାଲିଫ୍ୟାକ୍ସ୍" },
            { "timezone.excity.America/Iqaluit", "ଇକ୍ଵାଲୁଇଟ୍" },
            { "timezone.excity.America/Jamaica", "ଜାମାଇକା" },
            { "timezone.excity.America/Managua", "ମାନାଗୁଆ" },
            { "timezone.excity.America/Marigot", "ମାରିଗଟ୍" },
            { "timezone.excity.America/Mendoza", "ମେଣ୍ଡଜା" },
            { "timezone.excity.America/Moncton", "ମାନକଟନ୍" },
            { "timezone.excity.America/Noronha", "ନରହ୍ନ" },
            { "timezone.excity.America/Ojinaga", "ଅଜିନାଗା" },
            { "timezone.excity.America/Phoenix", "ପଇନିକ୍ସ" },
            { "timezone.excity.America/Tijuana", "ତିଜୁଆନା" },
            { "timezone.excity.America/Toronto", "ଟରଣ୍ଟ" },
            { "timezone.excity.America/Tortola", "ଟରଟଲା" },
            { "timezone.excity.America/Yakutat", "ୟାକୁଟାଟ୍" },
            { "timezone.excity.Asia/Phnom_Penh", "ପନମ୍‌ ପେନହ" },
            { "timezone.excity.Atlantic/Azores", "ଆଜରେସ୍" },
            { "timezone.excity.Atlantic/Canary", "କାନାରେ" },
            { "timezone.excity.Atlantic/Faeroe", "ପରଏ" },
            { "timezone.excity.Australia/Eucla", "ୟୁକଲା" },
            { "timezone.excity.Australia/Perth", "ପର୍ତ" },
            { "timezone.excity.Europe/Belgrade", "ବେଲଗ୍ରେଡେ" },
            { "timezone.excity.Europe/Brussels", "ବ୍ରୁସିଲ୍‍ସ" },
            { "timezone.excity.Europe/Budapest", "ବୁଡାପେସ୍ଟ" },
            { "timezone.excity.Europe/Busingen", "ବୁସିନଗେନ୍" },
            { "timezone.excity.Europe/Chisinau", "ଚିସିନାଉ" },
            { "timezone.excity.Europe/Guernsey", "ଗୁଏରନସେ" },
            { "timezone.excity.Europe/Helsinki", "ହେଲସିନକି" },
            { "timezone.excity.Europe/Istanbul", "ଇସ୍ତାନବୁଲ" },
            { "timezone.excity.Europe/Sarajevo", "ସାରାଜେବ" },
            { "timezone.excity.Indian/Maldives", "ମାଳଦ୍ୱୀପ" },
            { "timezone.excity.Pacific/Chatham", "ଚାତାମ୍‌" },
            { "timezone.excity.Pacific/Fakaofo", "ପକାଅପ" },
            { "timezone.excity.Pacific/Gambier", "ଗାମ୍ବିୟର୍‌" },
            { "timezone.excity.Pacific/Norfolk", "ନରପକ୍‌" },
            { "timezone.excity.Africa/Bujumbura", "ବୁଜୂମ୍ବୁରା" },
            { "timezone.excity.Africa/Mogadishu", "ମୋଗାଡିସୁ" },
            { "timezone.excity.America/Anguilla", "ଆଙ୍ଗୁଇଲା" },
            { "timezone.excity.America/Asuncion", "ଆସନସିଅନ୍‌" },
            { "timezone.excity.America/Barbados", "ବାରବାଡସ" },
            { "timezone.excity.America/Dominica", "ଡମିନିକା" },
            { "timezone.excity.America/Edmonton", "ଏଡ୍‍ମନଟନ୍" },
            { "timezone.excity.America/Eirunepe", "ଇରୁନେପେ" },
            { "timezone.excity.America/Mazatlan", "ମାଜାଟଲାନ୍" },
            { "timezone.excity.America/Miquelon", "ମିକ୍ଵେଲନ୍" },
            { "timezone.excity.America/New_York", "ନ୍ୟୁ ୟର୍କ୍" },
            { "timezone.excity.America/Resolute", "ରିସୋଲୁଟେ" },
            { "timezone.excity.America/Santarem", "ସାନ୍ତରେମ୍" },
            { "timezone.excity.America/Santiago", "ସାଣ୍ଟିଆଗ" },
            { "timezone.excity.America/St_Johns", "ସେଣ୍ଟ୍. ଜନସ୍" },
            { "timezone.excity.America/St_Kitts", "ସେଣ୍ଟ୍ କିଟ୍‍ସ" },
            { "timezone.excity.America/St_Lucia", "ସେଣ୍ଟ୍. ଲୁସିଆ" },
            { "timezone.excity.America/Winnipeg", "ୱିନିପେଗ୍" },
            { "timezone.excity.Antarctica/Casey", "କେସି" },
            { "timezone.excity.Antarctica/Davis", "ଡେୱିସ୍" },
            { "timezone.excity.Antarctica/Syowa", "ସୋୱା" },
            { "timezone.excity.Antarctica/Troll", "ଟୋଲ୍" },
            { "timezone.excity.Asia/Krasnoyarsk", "କ୍ରାସନୟାରସ୍କ" },
            { "timezone.excity.Asia/Novosibirsk", "ନୱସିବିରସ୍କ" },
            { "timezone.excity.Asia/Ulaanbaatar", "ଉଲାନ୍‌ବାଟର୍‌" },
            { "timezone.excity.Asia/Vladivostok", "ୱ୍ଲାଡିୱଷ୍ଟୋକ୍" },
            { "timezone.excity.Atlantic/Bermuda", "ବରମୁଡା" },
            { "timezone.excity.Atlantic/Madeira", "ମାଡେଇରା" },
            { "timezone.excity.Atlantic/Stanley", "ସ୍‍ଟାଲିନ" },
            { "timezone.excity.Australia/Darwin", "ଡାର୍ୱିନ୍" },
            { "timezone.excity.Australia/Hobart", "ହୋବାର୍ଟ" },
            { "timezone.excity.Australia/Sydney", "ସିଡନୀ" },
            { "timezone.excity.Europe/Amsterdam", "ଆମଷ୍ଟ୍ରେଡାମ୍" },
            { "timezone.excity.Europe/Astrakhan", "ଆସ୍‍ଟରାକାନ" },
            { "timezone.excity.Europe/Bucharest", "ବୁଚାରେସ୍ଟ" },
            { "timezone.excity.Europe/Gibraltar", "ଜିବ୍ରାଲଟର୍‌" },
            { "timezone.excity.Europe/Ljubljana", "ଲଜୁବ୍ଲଜାନ୍" },
            { "timezone.excity.Europe/Mariehamn", "ମାରିୟାହେମ" },
            { "timezone.excity.Europe/Podgorica", "ପଡଗରିକା" },
            { "timezone.excity.Europe/Stockholm", "ସ୍ଟକ୍ ହମ୍‌" },
            { "timezone.excity.Europe/Ulyanovsk", "ୟୁଲୟାନୱସ୍କ" },
            { "timezone.excity.Europe/Volgograd", "ୱଲଗଗ୍ରାଡ୍" },
            { "timezone.excity.Indian/Christmas", "ଖ୍ରୀସ୍‍ଟ ମାସ" },
            { "timezone.excity.Indian/Kerguelen", "କେରଗୁଲେନ" },
            { "timezone.excity.Indian/Mauritius", "ମରିସସ୍" },
            { "timezone.excity.Pacific/Auckland", "ଅକଲାଣ୍ଡ" },
            { "timezone.excity.Pacific/Funafuti", "ଫୁନାଫୁଟି" },
            { "timezone.excity.Pacific/Pitcairn", "ପିଟକାରିନ୍‌" },
            { "timezone.excity.Africa/Casablanca", "କାସାବ୍ଲାଙ୍କା" },
            { "timezone.excity.Africa/Libreville", "ଲିବ୍ରେୱିଲ୍ଲେ" },
            { "timezone.excity.Africa/Lubumbashi", "ଲୁବୁମ୍ବାଶି" },
            { "timezone.excity.Africa/Nouakchott", "ନୁଆକଚଟ" },
            { "timezone.excity.Africa/Porto-Novo", "ପର୍ଟ-ନୱ" },
            { "timezone.excity.America/Anchorage", "ଆଙ୍କରେଜ୍" },
            { "timezone.excity.America/Araguaina", "ଆରାଗୁଆନା" },
            { "timezone.excity.America/Boa_Vista", "ବୋଆ ୱିସ୍ଟା" },
            { "timezone.excity.America/Catamarca", "କା଼ଟାମାକାଁ" },
            { "timezone.excity.America/Chihuahua", "ଚିହୁଆହୁଆ" },
            { "timezone.excity.America/Fortaleza", "ପର୍ଟଲେଜା" },
            { "timezone.excity.America/Glace_Bay", "ଗ୍ଲାସେ ବେ" },
            { "timezone.excity.America/Goose_Bay", "ଗୁସ୍ ବେ" },
            { "timezone.excity.America/Guatemala", "ଗୁଆତେମାଲା" },
            { "timezone.excity.America/Guayaquil", "ଗୁୟାକ୍ୱିଲ" },
            { "timezone.excity.America/Matamoros", "ମାଟାମରସ୍" },
            { "timezone.excity.America/Menominee", "ମେନୋମିନି" },
            { "timezone.excity.America/Monterrey", "ମନଟେରିଏ" },
            { "timezone.excity.America/Sao_Paulo", "ସାଓ ପାଓଲୋ" },
            { "timezone.excity.America/St_Thomas", "ସେଣ୍ଟ୍. ଥମାସ୍" },
            { "timezone.excity.America/Vancouver", "ୱାଙ୍କୁୱର୍" },
            { "timezone.excity.Antarctica/Mawson", "ମାଁସନ" },
            { "timezone.excity.Antarctica/Palmer", "ପାଁମର" },
            { "timezone.excity.Antarctica/Vostok", "ୱୋସ୍ତକୋ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "କ୍ୱାଲାଲମ୍ପୁର" },
            { "timezone.excity.Asia/Novokuznetsk", "ନୱକୁଜନେଟସ୍କ" },
            { "timezone.excity.Europe/Bratislava", "ବ୍ରାଟିସଲାୱା" },
            { "timezone.excity.Europe/Copenhagen", "କପେନହାଗେନ୍" },
            { "timezone.excity.Europe/Luxembourg", "ଲକ୍ସମବର୍ଗ" },
            { "timezone.excity.Europe/San_Marino", "ସାନ୍ ମାରିନୋ" },
            { "timezone.excity.Europe/Simferopol", "ସିମଫେରପଲ୍" },
            { "timezone.excity.Pacific/Galapagos", "ଗାଲାପାଗସ" },
            { "timezone.excity.Pacific/Kwajalein", "କ୍ୱାଜାଲେଇନ୍" },
            { "timezone.excity.Pacific/Marquesas", "ମାର୍କ୍ୱେସାସ୍‌" },
            { "timezone.excity.Pacific/Pago_Pago", "ପାଗୋ ପାଗୋ" },
            { "timezone.excity.Pacific/Rarotonga", "ରାରଟଙ୍ଗା" },
            { "timezone.excity.Pacific/Tongatapu", "ଟଙ୍ଗାଟାପୁ" },
            { "timezone.excity.Africa/Addis_Ababa", "ଆଦିସ୍‌ ଆବାବା" },
            { "timezone.excity.Africa/Brazzaville", "ବ୍ରାଜାୱିଲ୍ଲେ" },
            { "timezone.excity.Africa/Ouagadougou", "ଅଗାଡଗୁ" },
            { "timezone.excity.America/Costa_Rica", "କଷ୍ଟା ରିକା" },
            { "timezone.excity.America/Grand_Turk", "ଗ୍ରାଣ୍ଡ୍ ଟର୍କ୍" },
            { "timezone.excity.America/Guadeloupe", "ଗୁଆଡେଲଉପେ" },
            { "timezone.excity.America/Hermosillo", "ହେରମସିଲୋ" },
            { "timezone.excity.America/Kralendijk", "କ୍ରାଲେଣ୍ଡିଜିକ" },
            { "timezone.excity.America/Louisville", "ଲଉଇସୱିଲ୍ଲେ" },
            { "timezone.excity.America/Martinique", "ମାର୍ଟିନିକ୍ୟୁ" },
            { "timezone.excity.America/Metlakatla", "ମାଟଲାକାଟଲା" },
            { "timezone.excity.America/Montevideo", "ମଣ୍ଟେଭିଡିଅ" },
            { "timezone.excity.America/Montserrat", "ମନଟସେରରାଟ୍" },
            { "timezone.excity.America/Paramaribo", "ପାରାମାରିବ" },
            { "timezone.excity.America/Rio_Branco", "ରିୟ ବ୍ରାଙ୍କ" },
            { "timezone.excity.America/St_Vincent", "ସେଣ୍ଟ୍. ୱିନସେଣ୍ଟ୍" },
            { "timezone.excity.America/Whitehorse", "ହ୍ଵାଇଟହର୍ସ୍" },
            { "timezone.excity.Antarctica/McMurdo", "ମ୍ୟାକମୁର୍ଡ" },
            { "timezone.excity.Antarctica/Rothera", "ରୋତେରା" },
            { "timezone.excity.Asia/Srednekolymsk", "ସ୍ରେଡନେକଲୟମସ୍କ" },
            { "timezone.excity.Asia/Yekaterinburg", "ୟେକାଟେରିନବର୍ଗ୍" },
            { "timezone.excity.Atlantic/Reykjavik", "ରେକ୍ୟାବିକ" },
            { "timezone.excity.Atlantic/St_Helena", "ସେଣ୍ଟ୍‌ ହେଲିନା" },
            { "timezone.excity.Australia/Adelaide", "ଏଡିଲେଡ୍" },
            { "timezone.excity.Australia/Brisbane", "ବ୍ରିସବନ୍" },
            { "timezone.excity.Australia/Lindeman", "ଲିଣ୍ଡେମାନ" },
            { "timezone.excity.Europe/Isle_of_Man", "ଆଇଲ୍ ଅପ୍ ମ୍ୟାନ୍" },
            { "timezone.excity.Europe/Kaliningrad", "କାଲିନିନଗ୍ରାଡ୍" },
            { "timezone.excity.Pacific/Kiritimati", "କିରିତିମାଟି" },
            { "timezone.excity.Africa/Johannesburg", "ଜହାନ୍ସବର୍ଗ" },
            { "timezone.excity.America/El_Salvador", "ଏଲ୍ ସାଲୱାଡୋର୍" },
            { "timezone.excity.America/Fort_Nelson", "ପର୍ଟ ନେଲସନ୍" },
            { "timezone.excity.America/Los_Angeles", "ଲସ୍ ଏଞ୍ଜେଲେସ୍" },
            { "timezone.excity.America/Mexico_City", "ମେକ୍ସିକୋ ସିଟି" },
            { "timezone.excity.America/Porto_Velho", "ପୋର୍ଟୋ ଭେଲୋ" },
            { "timezone.excity.America/Puerto_Rico", "ପୁଏର୍ତ ରିକ" },
            { "timezone.excity.America/Tegucigalpa", "ଟେଗୁସିଗାଲପା" },
            { "timezone.excity.Arctic/Longyearbyen", "ଳଙ୍ଖୟାରବେନ" },
            { "timezone.excity.Atlantic/Cape_Verde", "କେପ୍‌ ୱର୍ଦେ" },
            { "timezone.excity.Australia/Lord_Howe", "ଲର୍‍ଡ ହାୱେ" },
            { "timezone.excity.Australia/Melbourne", "ମେଲବୋନଁ" },
            { "timezone.excity.Indian/Antananarivo", "ଆଣ୍ଟାନାନାରିଭ" },
            { "timezone.excity.Pacific/Guadalcanal", "ଗୁଆଡାଲକାନାଲ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ଡର୍‌ ଇସ୍‌ ସାଲାମ" },
            { "timezone.excity.America/Blanc-Sablon", "ବ୍ଲାଙ୍କ-ସାବଲନ୍" },
            { "timezone.excity.America/Buenos_Aires", "ବୁଏନସ୍ ଆଇରେସ୍" },
            { "timezone.excity.America/Campo_Grande", "କାମ୍ପ ଗ୍ରାଣ୍ଡେ" },
            { "timezone.excity.America/Danmarkshavn", "ଡାନମାର୍କସାଭନ୍" },
            { "timezone.excity.America/Dawson_Creek", "ଡୱସନ୍ କ୍ରିକ୍" },
            { "timezone.excity.America/Indiana/Knox", "କ୍ନୋକ୍ସ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indianapolis", "ଇଣ୍ଡିଆନାପଲିସ୍" },
            { "timezone.excity.America/Punta_Arenas", "ପୁଣ୍ଟା ଏରିନାସ୍‌" },
            { "timezone.excity.America/Rankin_Inlet", "ରାନକିନ୍ ଇନଲେଟ୍" },
            { "timezone.excity.America/Scoresbysund", "ଇଟ୍ଟକ୍ଵରଟରମିଟ୍" },
            { "timezone.excity.Antarctica/Macquarie", "ମକ୍ୱାରି" },
            { "timezone.excity.Pacific/Bougainville", "ବଗେନ୍‌ୱିଲ୍ଲେ" },
            { "timezone.excity.Pacific/Port_Moresby", "ପର୍ଟ୍‌ ମରେସବି" },
            { "timezone.excity.America/Cambridge_Bay", "କେମ୍ଵ୍ରିଜ୍ ବେ" },
            { "timezone.excity.America/Coral_Harbour", "ଆଟିକୋକାନ୍" },
            { "timezone.excity.America/Indiana/Vevay", "ୱେୱାୟ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Lower_Princes", "ନିମ୍ନ ପ୍ରିନ୍ସ’ର କ୍ଵାଟର୍" },
            { "timezone.excity.America/Port_of_Spain", "ପର୍ଟ୍ ଅଫ୍ ସ୍ପେନ୍" },
            { "timezone.excity.America/Santo_Domingo", "ସାଣ୍ଟ ଡମିଙ୍ଗ" },
            { "timezone.excity.America/St_Barthelemy", "ସେଣ୍ଟ ବାର୍ତେଲେମି" },
            { "timezone.excity.America/Swift_Current", "ସୁଇଫ୍ଟ୍ କରେଣ୍ଟ୍" },
            { "timezone.excity.Australia/Broken_Hill", "ବ୍ରୋକନ ହିଲ" },
            { "timezone.excity.America/Bahia_Banderas", "ବାହିଆ ବ୍ୟାଣ୍ଡେରାସ୍" },
            { "timezone.excity.America/Port-au-Prince", "ପର୍ଟ-ଏୟୁ-ପ୍ରିନ୍‍ସ" },
            { "timezone.excity.Atlantic/South_Georgia", "ଦକ୍ଷିଣ ଜର୍ଜିଆ" },
            { "timezone.excity.America/Argentina/Salta", "ସାଲ୍ଟା" },
            { "timezone.excity.America/Indiana/Marengo", "ମାରେନଗ, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indiana/Winamac", "ୱିନାମାକ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Argentina/Tucuman", "ଟୋକୁମନ" },
            { "timezone.excity.America/Argentina/Ushuaia", "ଉସୁଆଇୟା" },
            { "timezone.excity.America/Indiana/Tell_City", "ଟେଲ୍ ସିଟି, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Indiana/Vincennes", "ଭିନସେନ୍ନେସ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.Antarctica/DumontDUrville", "ଡ୍ୟୁମାଣ୍ଟ ଡି ଉରୱିଲେ" },
            { "timezone.excity.America/Argentina/La_Rioja", "ଲା ରି୍ଅଜା" },
            { "timezone.excity.America/Argentina/San_Juan", "ସାୟାନ୍ ୱାନ୍" },
            { "timezone.excity.America/Argentina/San_Luis", "ସୟାନ ଲୁଇସ" },
            { "timezone.excity.America/Indiana/Petersburg", "ପେଟେର୍ସବର୍ଗ୍, ଇଣ୍ଡିଆନା" },
            { "timezone.excity.America/Kentucky/Monticello", "ମଣ୍ଟିସେଲ, କେଣ୍ଟଉକିକେ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ବେଉଲାହ, ଉତ୍ତର ଡାକଟା" },
            { "timezone.excity.America/North_Dakota/Center", "କେନ୍ଦ୍ର, ଉତ୍ତର ଡାକଟା" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ରିୟୋ ଗାଲେଗୋସ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ନ୍ୟୁ ସାଲେମ୍, ଉତ୍ତର ଡାକଟା" },
        };
        return data;
    }
}
