/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mai extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "फिजी";
        final String metaValue_AL = "अलबानिया";
        final String metaValue_TV = "टुवालू";
        final String metaValue_ar = "अरबी";
        final String metaValue_bn = "बंगाली";
        final String metaValue_ccp = "चकमा";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_el = "यूनानी";
        final String metaValue_gu = "गुजराती";
        final String metaValue_he = "हीब्रू";
        final String metaValue_ja = "जापानी";
        final String metaValue_kn = "कन्नड़";
        final String metaValue_ko = "कोरियाई";
        final String metaValue_lo = "लाओ";
        final String metaValue_la = "लातिन";
        final String metaValue_ml = "मलयालम";
        final String metaValue_nqo = "एनको";
        final String metaValue_or = "उड़िया";
        final String metaValue_si = "सिंहला";
        final String metaValue_syr = "सीरियक";
        final String metaValue_ta = "तमिल";
        final String metaValue_th = "थाई";
        final String metaValue_bo = "तिब्बती";
        final String metaValue_vai = "बाई";
        final Object[][] data = new Object[][] {
            { "001", "विश्व" },
            { "002", "अफ्रीका" },
            { "003", "उत्तरी अमेरिका" },
            { "005", "दक्षिण अमेरिका" },
            { "009", "ओसेनिया" },
            { "011", "पश्चिमी अफ्रीका" },
            { "013", "मध्य अमेरिका" },
            { "014", "पूरबी अफ्रीका" },
            { "015", "उत्तरी अफ्रीका" },
            { "017", "मध्य अफ्रीका" },
            { "018", "दक्षिणी अफ्रीका" },
            { "019", "अमेरिका" },
            { "021", "उत्तर अमेरिका" },
            { "029", "कैरिबियाई" },
            { "030", "पूरबी एशिया" },
            { "034", "दक्षिणी एशिया" },
            { "035", "दक्षिण-पूरबी एशिया" },
            { "039", "दक्षिणी यूरोप" },
            { "053", "आस्ट्रेलेशिया" },
            { "054", "मेलानेशिया" },
            { "057", "माइक्रोनेशियाई क्षेत्र" },
            { "061", "पोलिनेशिया" },
            { "142", "एशिया" },
            { "143", "मध्य एशिया" },
            { "145", "पश्चिमी एशिया" },
            { "150", "यूरोप" },
            { "151", "पूरबी यूरोप" },
            { "154", "उत्तरी यूरोप" },
            { "155", "पश्चिमी यूरोप" },
            { "202", "उप सहारा अफ्रीका" },
            { "419", "लातिन अमेरिका" },
            { "AC", "असेंशन द्वीप" },
            { "AD", "एंडोरा" },
            { "AE", "संयुक्त अरब अमीरात" },
            { "AF", "अफगानिस्तान" },
            { "AG", "एंटिगुआ आ बारबुडा" },
            { "AI", "एंग्विला" },
            { "AL", metaValue_AL },
            { "AM", "आरमेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्टिका" },
            { "AR", "अर्जेंटिना" },
            { "AS", "अमेरिकी समोआ" },
            { "AT", "आस्ट्रिया" },
            { "AU", "आस्ट्रेलिया" },
            { "AW", "अरूबा" },
            { "AX", "अलैंड द्वीपसमूह" },
            { "AZ", "अजरबैजान" },
            { "BA", "बोस्निया आ हर्जेगोबिना" },
            { "BB", "बारबाडोस" },
            { "BD", "बंगलादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुरकिना फासो" },
            { "BG", "बुल्गारिया" },
            { "BH", "बहरीन" },
            { "BI", "बुरूंडी" },
            { "BJ", "बेनिन" },
            { "BL", "सेंट बार्थेलेमी" },
            { "BM", "बरमुडा" },
            { "BN", "ब्रूनेई" },
            { "BO", "बोलिबिया" },
            { "BQ", "कैरिबियाई नीदरलैंड" },
            { "BR", "ब्राज़ील" },
            { "BS", "बहामास" },
            { "BT", "भूटान" },
            { "BV", "बोबेत द्वीप" },
            { "BW", "बोत्सबाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलीज" },
            { "CA", "कनाडा" },
            { "CC", "कोकेज (कीलिंग) द्वीपसमूह" },
            { "CD", "कांगो-किंशासा" },
            { "CF", "मध्य अफ्रीकी रिपब्लिक" },
            { "CG", "कांगो-ब्राजाबिले" },
            { "CH", "स्विट्जरलैंड" },
            { "CI", "कोट डी आइवर" },
            { "CK", "कुक द्वीपसमूह" },
            { "CL", "चिली" },
            { "CM", "कैमरून" },
            { "CN", "चीन" },
            { "CO", "कोलंबिया" },
            { "CP", "क्लिपर्टन द्वीप" },
            { "CR", "कोस्टारिका" },
            { "CU", "क्यूबा" },
            { "CV", "कैप बर्डे" },
            { "CW", "कुरासाओ" },
            { "CX", "क्रिसमस द्वीप" },
            { "CY", "साइप्रस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डियागो गार्सिया" },
            { "DJ", "जिबूति" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन रिपब्लिक" },
            { "DZ", "अल्जीरिया" },
            { "EA", "सेउटा आ मेलिला" },
            { "EC", "इक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "मिस्र" },
            { "EH", "पश्चिमी सहारा" },
            { "ER", "एरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इथोपिया" },
            { "EU", "यूरोपीय यूनियन" },
            { "EZ", "यूरो जोन" },
            { "FI", "फिनलैंड" },
            { "FJ", metaValue_FJ },
            { "FK", "फाकलैंड द्वीपसमूह" },
            { "FM", "माइक्रोनेशिया" },
            { "FO", "फेरो द्वीपसमूह" },
            { "FR", "फ़्रांस" },
            { "GA", "गैबन" },
            { "GB", "यूनाइटेड किंगडम" },
            { "GD", "ग्रेनाडा" },
            { "GE", "जार्जिया" },
            { "GF", "फ्रेंच गुयाना" },
            { "GG", "गर्नसी" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलैंड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलूप" },
            { "GQ", "इक्वेटोरियल गिनी" },
            { "GR", "यूनान" },
            { "GS", "दक्षिण जार्जिया आ दक्षिण सैंडविच द्वीपसमूह" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाऊ" },
            { "GY", "गुयाना" },
            { "HK", "हांग कांग (विशेष प्रशासनिक क्षेत्र चीन)" },
            { "HM", "हर्ड आ मैकडोनल्ड द्वीपसमूह" },
            { "HN", "होंडुरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैती" },
            { "HU", "हंगरी" },
            { "IC", "कैनरी द्वीपसमूह" },
            { "ID", "इंडोनेशिया" },
            { "IE", "आयरलैंड" },
            { "IL", "इजरायल" },
            { "IM", "आइल ऑफ मैन" },
            { "IN", "भारत" },
            { "IO", "ब्रिटिश हिंद महासागरीय क्षेत्र" },
            { "IQ", "इराक" },
            { "IR", "ईरान" },
            { "IS", "आइसलैंड" },
            { "IT", "इटली" },
            { "JE", "जरसी" },
            { "JM", "जमैका" },
            { "JO", "जार्डन" },
            { "JP", "जापान" },
            { "KE", "केन्या" },
            { "KG", "किर्गिजस्तान" },
            { "KH", "कंबोडिया" },
            { "KI", "किरिबाती" },
            { "KM", "कोमोरोस" },
            { "KN", "सेंट किट्स आ नेविस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दक्षिण कोरिया" },
            { "KW", "कुवैत" },
            { "KY", "कैमेन द्वीपसमूह" },
            { "KZ", "कजाखस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनान" },
            { "LC", "सेंट लूसिया" },
            { "LI", "लिख्तेंस्ताइन" },
            { "LK", "श्रीलंका" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लिथुआनिया" },
            { "LU", "लग्जमबर्ग" },
            { "LV", "लातविया" },
            { "LY", "लीबिया" },
            { "MA", "मोरोक्को" },
            { "MC", "मोनाको" },
            { "MD", "मोलडोवा" },
            { "ME", "मोंटेनीग्रो" },
            { "MF", "सेंट मार्टिन" },
            { "MG", "मेडागास्कर" },
            { "MH", "मार्शल द्वीपसमूह" },
            { "MK", "उत्तरी मकदूनिया" },
            { "ML", "माली" },
            { "MM", "मयनमार (बर्मा)" },
            { "MN", "मंगोलिया" },
            { "MO", "मकाउ (विशेष प्रशासनिक क्षेत्र चीन)" },
            { "MP", "उत्तर मरीना द्वीपसमूह" },
            { "MQ", "मार्टिनिक" },
            { "MR", "मारिटानिया" },
            { "MS", "मोंटसेरात" },
            { "MT", "माल्टा" },
            { "MU", "मारीशस" },
            { "MV", "मालदीब" },
            { "MW", "मलाबी" },
            { "MX", "मैक्सिको" },
            { "MY", "मलेशिया" },
            { "MZ", "मोजाम्बिक" },
            { "NA", "नामीबिया" },
            { "NC", "न्यू कैलेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नौरफोक द्वीप" },
            { "NG", "नाइजीरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नीदरलैंड" },
            { "NO", "नार्वे" },
            { "NP", "नेपाल" },
            { "NR", "नौरू" },
            { "NU", "नीयू" },
            { "NZ", "न्यूजीलैंड" },
            { "OM", "ओमान" },
            { "PA", "पनामा" },
            { "PE", "पेरू" },
            { "PF", "फ्रेंच पोलिनेशिया" },
            { "PG", "पापुआ न्यू गिनी" },
            { "PH", "फिलिपींस" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलैंड" },
            { "PM", "सेंट पियरे आ मिक्वेलान" },
            { "PN", "पिटकेयर्न द्वीपसमूह" },
            { "PR", "प्योर्टो रिको" },
            { "PS", "फिलिस्तीनी क्षेत्र" },
            { "PT", "पुर्तगाल" },
            { "PW", "पलाऊ" },
            { "PY", "पराग्वे" },
            { "QA", "कतर" },
            { "QO", "आउटलाइंग ओसेनिया" },
            { "RE", "रियूनियन" },
            { "RO", "रोमानिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "रवांडा" },
            { "SA", "सऊदी अरब" },
            { "SB", "सोलोमन द्वीपसमूह" },
            { "SC", "सेशेल्स" },
            { "SD", "सूडान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापुर" },
            { "SH", "सेंट हेलेना" },
            { "SI", "स्लोबेनिया" },
            { "SJ", "स्वालबार्ड आ जान मायेन" },
            { "SK", "स्लोवाकिया" },
            { "SL", "सियरा लियोन" },
            { "SM", "सेन मरीनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सुरीनाम" },
            { "SS", "दक्षिण सुडान" },
            { "ST", "साओ टोम आ प्रिंसिप" },
            { "SV", "अल सल्वाडोर" },
            { "SX", "सिंट मार्टेन" },
            { "SY", "सीरिया" },
            { "SZ", "एस्वाटिनी" },
            { "TA", "ट्रिस्टन दा कुना" },
            { "TC", "तुर्क आ कैकोज द्वीपसमूह" },
            { "TD", "चाड" },
            { "TF", "फ्रांसीसी दक्षिणी क्षेत्र" },
            { "TG", "टोगो" },
            { "TH", "थाईलैंड" },
            { "TJ", "ताजिकिस्तान" },
            { "TK", "टोकेलाऊ" },
            { "TL", "तिमोर-लेस्त" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्यूनिशिया" },
            { "TO", "टोंगा" },
            { "TR", "तुर्की" },
            { "TT", "ट्रिनिदाद आ टोबैगो" },
            { "TV", metaValue_TV },
            { "TW", "ताइबान" },
            { "TZ", "तंजानिया" },
            { "UA", "यूक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "यू॰एस॰ आउटलाइंग द्वीपसमूह" },
            { "UN", "संयुक्त राष्ट्र" },
            { "US", "संयुक्त राज्य" },
            { "UY", "उरुग्वे" },
            { "UZ", "उजबेकिस्तान" },
            { "VA", "वेटिकन सिटी" },
            { "VC", "सेंट विंसेंट आ ग्रेनाडाइंस" },
            { "VE", "बेनेजुएला" },
            { "VG", "ब्रिटिश वर्जिन द्वीपसमूह" },
            { "VI", "यू॰एस॰ वर्जिन द्वीपसमूह" },
            { "VN", "बियतनाम" },
            { "VU", "बनातू" },
            { "WF", "बालिस आ फुटुना" },
            { "WS", "समोआ" },
            { "XA", "छद्म उच्चारण" },
            { "XB", "छद्म बिडि" },
            { "XK", "कोसोवो" },
            { "YE", "यमन" },
            { "YT", "मयोटे" },
            { "ZA", "दक्षिण अफ्रीका" },
            { "ZM", "जाम्बिया" },
            { "ZW", "जिम्बाब्बे" },
            { "ZZ", "अज्ञात क्षेत्र" },
            { "ab", "अबखाजियान" },
            { "af", "अफ्रीकांस" },
            { "ak", "अकेन" },
            { "am", "अम्हरिक" },
            { "an", "अरगोनीज" },
            { "ar", metaValue_ar },
            { "as", "असमी" },
            { "av", "अवरिक" },
            { "ay", "आयमरा" },
            { "az", "अजरबैजानी" },
            { "ba", "बशकीर" },
            { "be", "बेलारूसी" },
            { "bg", "बुलगेरियाई" },
            { "bi", "बिसलामा" },
            { "bm", "बमबारा" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ब्रेटन" },
            { "bs", "बोसनियाई" },
            { "ca", "केटालान" },
            { "ce", "चेचेन" },
            { "ch", "चमोरो" },
            { "co", "कोर्शियाई" },
            { "cs", "चेक" },
            { "cv", "शुवास" },
            { "cy", "बेल्श" },
            { "da", "डेनिश" },
            { "de", "जर्मन" },
            { "dv", "डिबेही" },
            { "dz", "जोनखा" },
            { "ee", "इयु" },
            { "el", metaValue_el },
            { "en", "अंगरेजी" },
            { "eo", "एसपेरेंटो" },
            { "es", "स्पेनिश" },
            { "et", "एसटोनियाई" },
            { "eu", "बास्क" },
            { "fa", "परसियन" },
            { "ff", "फुलाह" },
            { "fi", "फिनिश" },
            { "fj", metaValue_FJ },
            { "fo", "फेरोइज" },
            { "fr", "फ़्रेंच" },
            { "fy", "पश्चिमी फ्रीजन" },
            { "ga", "आइरिश" },
            { "gd", "स्काउटिस गेलिक" },
            { "gl", "गेलिशियन" },
            { "gn", "गुआरानी" },
            { "gu", metaValue_gu },
            { "gv", "मेंक्स" },
            { "ha", "हउसा" },
            { "he", metaValue_he },
            { "hi", "हिन्दी" },
            { "hr", "क्रोशियाई" },
            { "ht", "हैतियाई क्रियोल" },
            { "hu", "हंगेरियन" },
            { "hy", "अर्मेनियाई" },
            { "hz", "हैरेरो" },
            { "ia", "इंटरलिंगुआ" },
            { "id", "इंडोनेशियाई" },
            { "ig", "इगबो" },
            { "ii", "सिचुआन यी" },
            { "io", "ईडो" },
            { "is", "आइसलैंडी" },
            { "it", "इतालवी" },
            { "iu", "इनुकतितुत" },
            { "ja", metaValue_ja },
            { "jv", "जावानी" },
            { "ka", "जार्जियाई" },
            { "ki", "किकुयू" },
            { "kj", "कुअनयामा" },
            { "kk", "कजाक" },
            { "kl", "कलालिसुत" },
            { "km", "खमेर" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "कनुरी" },
            { "ks", "कशमीरी" },
            { "ku", "कुर्दी" },
            { "kv", "कोमी" },
            { "kw", "कोर्निश" },
            { "ky", "किर्गिज" },
            { "la", metaValue_la },
            { "lb", "लगजमबर्गी" },
            { "lg", "गंडा" },
            { "li", "लिमबर्गिश" },
            { "ln", "लिंगाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियाई" },
            { "lu", "लुबा-कटांगा" },
            { "lv", "लातवियाई" },
            { "mg", "मलगासी" },
            { "mh", "मार्शेलीज" },
            { "mi", "माओरी" },
            { "mk", "मेसिडोनियाई" },
            { "ml", metaValue_ml },
            { "mn", "मोंगोलियाई" },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "mt", "मलटीज" },
            { "my", "बर्मी" },
            { "na", "नउरू" },
            { "nb", "नार्वेजियन बोकमाल" },
            { "nd", "उत्तरी डेबले" },
            { "ne", "नेपाली" },
            { "ng", "एनडोंगा" },
            { "nl", "डच" },
            { "nn", "नार्वेजियन निनोरेस्क" },
            { "no", "नार्वेजियन" },
            { "nr", "दक्षिणी एनडेबेले" },
            { "nv", "नवाजो" },
            { "ny", "नींजा" },
            { "oc", "औकसीटान" },
            { "om", "ओरोमो" },
            { "or", metaValue_or },
            { "os", "ओसेटिक" },
            { "pa", "पंजाबी" },
            { "pl", "पोलिश" },
            { "ps", "पश्तो" },
            { "pt", "पुर्तगाली" },
            { "qu", "कुएचुआ" },
            { "rm", "रोमांश" },
            { "rn", "रूंडी" },
            { "ro", "रोमानियाई" },
            { "ru", "रूसी" },
            { "rw", "किनयरवांडा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्डिनियाई" },
            { "sd", "सिंधी" },
            { "se", "उत्तरी सामी" },
            { "sg", "सांगो" },
            { "si", metaValue_si },
            { "sk", "स्लोबाक" },
            { "sl", "स्लोबेनियाई" },
            { "sm", "समोअन" },
            { "sn", "शोना" },
            { "so", "सोमाली" },
            { "sq", metaValue_AL },
            { "sr", "सर्बियाई" },
            { "ss", "स्वाती" },
            { "st", "दक्षिणी सोथो" },
            { "su", "सुंदनेजे" },
            { "sv", "स्वीडिश" },
            { "sw", "स्वाहिलि" },
            { "ta", metaValue_ta },
            { "te", "तेलगू" },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "टिगरिनया" },
            { "tk", "तुर्कमैन" },
            { "tn", "टुआना" },
            { "to", "टोंगन" },
            { "tr", "टर्किश" },
            { "ts", "शोंगा" },
            { "tt", "ततार" },
            { "ty", "ताहितियन" },
            { "ug", "उइगर" },
            { "uk", "यूक्रेनी" },
            { "ur", "उर्दू" },
            { "uz", "उजबेक" },
            { "ve", "बेंदा" },
            { "vi", "बियतनामी" },
            { "wa", "बलून" },
            { "wo", "बोलोफ" },
            { "xh", "खोसा" },
            { "yi", "ईडिश" },
            { "yo", "योरूबा" },
            { "za", "जा" },
            { "zh", "चीनी" },
            { "zu", "जुलू" },
            { "ace", "ऐचिनीज" },
            { "ada", "अदेंग" },
            { "ady", "अदिगे" },
            { "agq", "अगेम" },
            { "ain", "आयू" },
            { "ale", "अल्यूट" },
            { "alt", "दक्षिणी अलटाई" },
            { "ann", "ओबोलो" },
            { "anp", "अंगिका" },
            { "arn", "मापुचे" },
            { "arp", "अरापहो" },
            { "ars", "नजदी अरबी" },
            { "asa", "असु" },
            { "ast", "अस्तुरियाई" },
            { "atj", "अतिकामेक" },
            { "awa", "अवधी" },
            { "ban", "बाली" },
            { "bas", "बासा" },
            { "bem", "बेम्बा" },
            { "bez", "बेना" },
            { "bho", "भोजपुरी" },
            { "bin", "बिनी" },
            { "bla", "सिकसिका" },
            { "brx", "बोडो" },
            { "bug", "बगिनीज" },
            { "byn", "बलिन" },
            { "cay", "केयुगा" },
            { "ccp", metaValue_ccp },
            { "ceb", "सेबुयानो" },
            { "cgg", "चिजिया" },
            { "chk", "चुकीज" },
            { "chm", "मारी" },
            { "cho", "चोकटाउ" },
            { "chp", "चिपवायन" },
            { "chr", metaValue_chr },
            { "chy", "शयेन" },
            { "ckb", "सेंट्रल कुर्दी" },
            { "clc", "चोकोटिन" },
            { "crg", "मिचिफ" },
            { "crj", "दक्षिण-पुरबी क्री" },
            { "crk", "प्लेंस क्री" },
            { "crl", "उत्तर-पूरबी क्री" },
            { "crm", "मूज क्री" },
            { "crr", "केरोलिना अलगोनकुइन" },
            { "csw", "स्वम्पी क्री" },
            { "dak", "डकोटा" },
            { "dar", "डर्गबा" },
            { "dav", "टैटा" },
            { "dgr", "डोग्रीब" },
            { "dje", "जरमा" },
            { "doi", "डोगरी" },
            { "dsb", "लोअर सोर्बियाई" },
            { "dua", "डुआला" },
            { "dyo", "जोला-फोनी" },
            { "dzg", "दजागा" },
            { "ebu", "एमबु" },
            { "efi", "एफिक" },
            { "eka", "एकाजुक" },
            { "ewo", "इवोनडो" },
            { "fil", "फिलिपीनो" },
            { "fon", "फोन" },
            { "frc", "केजन फ्रांसीसी" },
            { "fur", "फ्रियूयन" },
            { "gaa", "गा" },
            { "gez", "गीज" },
            { "gil", "गिलबर्टीज" },
            { "gor", "गोरोंटेलो" },
            { "gsw", "स्वीस जर्मन" },
            { "guz", "गुसी" },
            { "gwi", "गुअचीन" },
            { "hai", "हैदा" },
            { "haw", "हवाईयन" },
            { "hax", "दक्षिणी हैदा" },
            { "hil", "हिलिगेनन" },
            { "hmn", "मौंग" },
            { "hsb", "उच्च सोर्बियाई" },
            { "hup", "हुपा" },
            { "hur", "हलकोमैलेम" },
            { "iba", "इबन" },
            { "ibb", "इबिबियो" },
            { "ikt", "पश्चिमी कनाडाई इनुकतुत" },
            { "ilo", "इलोको" },
            { "inh", "इंगुश" },
            { "jbo", "लोजबन" },
            { "jgo", "नेगोमबा" },
            { "jmc", "मैकेम" },
            { "kab", "कबाइल" },
            { "kac", "कचिन" },
            { "kaj", "जू" },
            { "kam", "कामबा" },
            { "kbd", "कबर्दियन" },
            { "kcg", "टियाप" },
            { "kde", "मकोंडे" },
            { "kea", "काबुबरदियानु" },
            { "kfo", "कोरो" },
            { "kgp", "कैनगैंग" },
            { "kha", "खासी" },
            { "khq", "कोयरा चीनी" },
            { "kkj", "काको" },
            { "kln", "केलैंजिन" },
            { "kmb", "किमबुंडू" },
            { "kok", "कोंकणी" },
            { "kpe", "कपैले" },
            { "krc", "करचय-बालकर" },
            { "krl", "केरैलियन" },
            { "kru", "कुरूक" },
            { "ksb", "शमबाला" },
            { "ksf", "बाफिया" },
            { "ksh", "कोलोनियन" },
            { "kum", "कुमिक" },
            { "kwk", "कुअकवाला" },
            { "lad", "लडीनो" },
            { "lag", "लंगी" },
            { "lez", "लजगियान" },
            { "lil", "लिलुइट" },
            { "lkt", "लकोटा" },
            { "lou", "लुइसियाना क्रियोल" },
            { "loz", "लोजी" },
            { "lrc", "उत्तरी लूरी" },
            { "lsm", "सामिया" },
            { "lua", "लुबा-लुलुआ" },
            { "lun", "लुंडा" },
            { "luo", "लुओ" },
            { "lus", "मिजो" },
            { "luy", "लुुइया" },
            { "mad", "मदुरीज" },
            { "mag", "मगही" },
            { "mai", "मैथिली" },
            { "mak", "मकसर" },
            { "mas", "मसाई" },
            { "mdf", "मोकशा" },
            { "men", "मेंडे" },
            { "mer", "मेरू" },
            { "mfe", "मोरीसेन" },
            { "mgh", "मखुआ-मेटो" },
            { "mgo", "मेटा" },
            { "mic", "मिकमक" },
            { "min", "मिननकबाऊ" },
            { "mni", "मणिपुरी" },
            { "moe", "इनु-ऐमन" },
            { "moh", "मोहौक" },
            { "mos", "मोसी" },
            { "mua", "मुंडांग" },
            { "mul", "एक सं बेसी भाषा" },
            { "mus", "मसकोगी" },
            { "mwl", "मिरंडीज" },
            { "myv", "अरजाया" },
            { "mzn", "मजनदेरानी" },
            { "nap", "नेपोलिटन" },
            { "naq", "नामा" },
            { "nds", "लो जर्मन" },
            { "new", "नेबारी" },
            { "nia", "नियास" },
            { "niu", "नियुएन" },
            { "nmg", "कवासियो" },
            { "nnh", "जियमबून" },
            { "nog", "नोगई" },
            { "nqo", metaValue_nqo },
            { "nso", "उत्तरी सोथो" },
            { "nus", "नूअर" },
            { "nyn", "नीयनकोले" },
            { "ojb", "उत्तरी-पश्चिम ओजिवा" },
            { "ojc", "सेंट्रल ओजिबा" },
            { "ojs", "ओजि-क्री" },
            { "ojw", "पश्चिमी ओजिबा" },
            { "oka", "ओकंगान" },
            { "pag", "पैंगासिनान" },
            { "pam", "पैमपंगा" },
            { "pap", "पैपियामेंटो" },
            { "pau", "पलौआन" },
            { "pcm", "नाइजीरियाई पिजिन" },
            { "pis", "पिजिन" },
            { "pqm", "मलिसीट-पैसमाकोडी" },
            { "rap", "रपानुई" },
            { "rar", "रेरोटोंगन" },
            { "rhg", "रोहिंग्या" },
            { "rof", "रोमबो" },
            { "rup", "अरोमानियाई" },
            { "rwk", "रूवा" },
            { "sad", "संदाउ" },
            { "sah", "सखा" },
            { "saq", "समबुरू" },
            { "sat", "संथाली" },
            { "sba", "नामबे" },
            { "sbp", "सांगू" },
            { "scn", "सिसिलियाई" },
            { "sco", "स्काउट्स" },
            { "seh", "सेना" },
            { "ses", "कोयराबोरो सैनी" },
            { "shi", "टेचलहिट" },
            { "shn", "शान" },
            { "slh", "दक्षिणी लसूटसीड" },
            { "smn", "इनारी सामी" },
            { "sms", "स्कोल्ट समी" },
            { "snk", "सोनिनके" },
            { "srn", "श्रेनन टोंगो" },
            { "str", "स्ट्रेट्स सैलिस" },
            { "suk", "सुकुमा" },
            { "swb", "कोमोरायन" },
            { "syr", metaValue_syr },
            { "tce", "दक्षिणी टोचेन" },
            { "tem", "टिमने" },
            { "teo", "टेसो" },
            { "tet", "टैटम" },
            { "tgx", "टेगिश" },
            { "tht", "टालटन" },
            { "tig", "टिगरे" },
            { "tlh", "किलिंगौन" },
            { "tli", "टिलिंगिट" },
            { "tok", "टोकी पोना" },
            { "tpi", "टोक पिसिन" },
            { "trv", "टरोको" },
            { "ttm", "उत्तरी टचोन" },
            { "tum", "टुमबुका" },
            { "tvl", metaValue_TV },
            { "twq", "टासावाक" },
            { "tyv", "टुविनियन" },
            { "tzm", "सेंट्रल एटलस टेमेजिघ" },
            { "udm", "उदमुर्त" },
            { "umb", "उमबुंदू" },
            { "und", "अज्ञात भाषा" },
            { "vai", metaValue_vai },
            { "vun", "बुंजो" },
            { "wae", "बालसर" },
            { "wal", "बोलेटा" },
            { "war", "बरय" },
            { "wuu", "ऊ चीनी" },
            { "xal", "कलमिक" },
            { "xog", "सोगा" },
            { "yav", "यंगबैन" },
            { "ybb", "येमबा" },
            { "yrl", "एनहींगाटु" },
            { "yue", "केंटोनी" },
            { "zgh", "मानक मोरोक्कन टेमेजिग्थ" },
            { "zun", "जूनी" },
            { "zxx", "कुनु भाषाई सामग्री नहि" },
            { "zza", "जाजा" },
            { "Adlm", "अदलाम" },
            { "Arab", metaValue_ar },
            { "Aran", "नास्तलिक" },
            { "Armn", "आर्मेनियाई" },
            { "Beng", metaValue_bn },
            { "Bopo", "बोपोमोफो" },
            { "Brai", "ब्रेल" },
            { "Cakm", metaValue_ccp },
            { "Cans", "यूनिफाइड कनाडियम एबोरिजनल सिलेबिक्स" },
            { "Cher", metaValue_chr },
            { "Cyrl", "सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Ethi", "इथोपिक" },
            { "Geor", "जार्जियन" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरमुखी" },
            { "Hanb", "बोपोमोफो कें संग हान" },
            { "Hang", "हंगुल" },
            { "Hani", "हान" },
            { "Hans", "सरलीकृत" },
            { "Hant", "पारंपरिक" },
            { "Hebr", metaValue_he },
            { "Hira", "हीरागना" },
            { "Hrkt", "जापानी शब्दांश" },
            { "Jamo", "जमो" },
            { "Jpan", metaValue_ja },
            { "Kana", "कटाकाना" },
            { "Khmr", "कुमेर" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "मंंगोलियन" },
            { "Mtei", "मैती मायेक" },
            { "Mymr", "मयनमार" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ओल चिकी" },
            { "Orya", metaValue_or },
            { "Rohg", "हनिफी" },
            { "Sinh", metaValue_si },
            { "Sund", "सुंडानीज" },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", "तेलुगू" },
            { "Tfng", "टिफिनघ" },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "यी" },
            { "Zmth", "गणितीय संकेतन" },
            { "Zsye", "इमोजी" },
            { "Zsym", "संकेत" },
            { "Zxxx", "अलिखित" },
            { "Zyyy", "सामान्य" },
            { "Zzzz", "अज्ञात लिपि" },
            { "de_AT", "ऑस्ट्रियाई जर्मन" },
            { "de_CH", "स्विस उच्च जर्मन" },
            { "en_AU", "आस्ट्रेलियाई अंंगरेजी" },
            { "en_CA", "कनाडाई अंग्रेज़ी" },
            { "en_GB", "ब्रिटिश अंग्रेज़ी" },
            { "en_US", "अमेरिकी अंग्रेज़ी" },
            { "es_ES", "यूरोपीय स्पेनिश" },
            { "es_MX", "मैक्सिकन स्पेनिश" },
            { "fa_AF", "परसियन डारी" },
            { "fr_CA", "कनाडाई फ़्रेंच" },
            { "fr_CH", "स्विस फ़्रेंच" },
            { "nl_BE", "फ्लेमिश" },
            { "pt_BR", "ब्राज़ीली पुर्तगाली" },
            { "pt_PT", "यूरोपीय पुर्तगाली" },
            { "ar_001", "आधुनिक मानक अरबी" },
            { "es_419", "लैटिन अमेरिकी स्पेनिश" },
            { "key.ca", "कैलेंडर" },
            { "key.cf", "मुद्रा प्रारूप" },
            { "key.co", "सॉर्ट क्रम" },
            { "key.cu", "मुद्रा" },
            { "key.hc", "घंटे का चक्र (12 बनाम 24)" },
            { "key.lb", "लाइन ब्रेक का स्टाइल" },
            { "key.ms", "माप प्रणाली" },
            { "key.nu", "संख्या" },
            { "hi_Latn", "हिन्दी (ल्याटिन)" },
            { "zh_Hans", "सरलीकृत चीनी" },
            { "zh_Hant", "पारंपरिक चीनी" },
            { "type.ca.roc", "मिंगो कैलेंडर" },
            { "type.hc.h11", "12 घंटे वाला प्रारूप (0–11)" },
            { "type.hc.h12", "12 घंटे वाला प्रारूप (1–12)" },
            { "type.hc.h23", "24 घंटे वाला प्रारूप (0–23)" },
            { "type.hc.h24", "24 घंटे वाला प्रारूप (0–24)" },
            { "type.nu.arab", "अरबी-इंडिक अंक" },
            { "type.nu.armn", "अर्मेनियाई संख्याएं" },
            { "type.nu.beng", "बंगाली अंक" },
            { "type.nu.cakm", "चकमा अंक" },
            { "type.nu.deva", "देवनागरी अंक" },
            { "type.nu.ethi", "इथोपियाई संख्याएं" },
            { "type.nu.geor", "जार्जियाई संख्याएं" },
            { "type.nu.grek", "यूनानी संख्याएं" },
            { "type.nu.gujr", "गूजराती अंक" },
            { "type.nu.guru", "गुरमुखी अंक" },
            { "type.nu.hans", "सरलीकृत चीनी संख्याएं" },
            { "type.nu.hant", "पारंपरिक चीनी संख्याएं" },
            { "type.nu.hebr", "हीब्रू संख्याएं" },
            { "type.nu.java", "जेवेनी अंक" },
            { "type.nu.jpan", "जापानी अंक" },
            { "type.nu.khmr", "खमेर अंक" },
            { "type.nu.knda", "कन्नड़ अंक" },
            { "type.nu.laoo", "लाओ अंक" },
            { "type.nu.latn", "पश्चिमी अंक" },
            { "type.nu.mlym", "मलयाली अंक" },
            { "type.nu.mtei", "मितेई मायेक अंक" },
            { "type.nu.mymr", "मयनमार अंक" },
            { "type.nu.olck", "ओल चिकि अंक" },
            { "type.nu.orya", "उड़िया अंक" },
            { "type.nu.taml", "पारंपरिक तमिल संख्याएँ" },
            { "type.nu.telu", "तेलुगू अंक" },
            { "type.nu.thai", "थाई अंक" },
            { "type.nu.tibt", "तिब्बती अंक" },
            { "type.nu.vaii", "बाय अंक" },
            { "type.ca.dangi", "डांगी कैलेंडर" },
            { "type.co.ducet", "डिफाल्ट यूनिकोड सॉर्ट क्रम" },
            { "type.lb.loose", "लाइन ब्रेक का लचीला स्टाइल" },
            { "type.nu.roman", "रोमन संख्याएँ" },
            { "type.ca.coptic", "काप्टिक कैलेंडर" },
            { "type.ca.hebrew", "हीब्रू कैलेंडर" },
            { "type.ca.indian", "भारतीय राष्ट्रीय कैलेंडर" },
            { "type.co.search", "सामान्य प्रयोजन वाली खोज" },
            { "type.lb.normal", "लाइन ब्रेक का सामान्य स्टाइल" },
            { "type.lb.strict", "लाइन ब्रेक का सख्त स्टाइल" },
            { "type.ms.metric", "मीट्रिक प्रणाली" },
            { "type.ca.chinese", "चीनी कैलेंडर" },
            { "type.ca.islamic", "इस्लामिक कैलेंडर" },
            { "type.ca.iso8601", "ISO-8601 कैलेंडर" },
            { "type.ca.persian", "फारसी कैलेंडर" },
            { "type.cf.account", "लेखा मुद्रा प्रारूप" },
            { "type.nu.arabext", "विस्तारित अरबी-इंडिक अंक" },
            { "type.nu.armnlow", "लोअरकेस वाले अर्मेनियाई संख्याएं" },
            { "type.nu.greklow", "लोअरकेस वाले यूनानी संख्याएं" },
            { "type.nu.hanidec", "चीनी दशमलव संख्याएं" },
            { "type.nu.hansfin", "सरलीकृत चीनी बित्तीय संख्याएं" },
            { "type.nu.hantfin", "पारंपरिक चीनी बित्तीय संख्याएं" },
            { "type.nu.jpanfin", "जापानी बित्तीय संख्याएँ" },
            { "type.nu.tamldec", "तमिल अंक" },
            { "type.ca.buddhist", "बौद्ध कैलेंडर" },
            { "type.ca.ethiopic", "इथोपियाई कैलेंडर" },
            { "type.ca.japanese", "जापानी कैलेंडर" },
            { "type.cf.standard", "सामान्य मुद्रा प्रारूप" },
            { "type.co.standard", "मानक सॉर्ट क्रम" },
            { "type.ms.uksystem", "इम्पीरियल माप प्रणाली" },
            { "type.ms.ussystem", "अमेरिकी माप प्रणाली" },
            { "type.nu.fullwide", "पूर्ण-चौड़ाई वाले अंक" },
            { "type.nu.romanlow", "रोमन लोअरकेस संख्याएँ" },
            { "type.ca.gregorian", "ग्रेगोरियन कैलेंडर" },
            { "type.ca.islamic-civil", "इस्लामिक कैलेंडर (टैबुलर, सिविल एपेक)" },
            { "type.ca.islamic-umalqura", "इस्लामिक कैलेंडर (उम अल कुरा)" },
            { "type.ca.ethiopic-amete-alem", "इथोपियाई एमटे अलेम कैलेंडर" },
        };
        return data;
    }
}
