/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ak extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Gyaaman";
        final String metaValue_CA = "Kanada";
        final String metaValue_ar = "Arabeke";
        final String metaValue_he = "Hibri kasa";
        final String metaValue_ko = "Korea kasa";
        final String metaValue_lo = "Lawo kasa";
        final String metaValue_ml = "Malayalam kasa";
        final String metaValue_mn = "Mongoliafoɔ kasa";
        final String metaValue_ta = "Tamil kasa";
        final Object[][] data = new Object[][] {
            { "001", "wiase" },
            { "002", "Abibirem" },
            { "003", "Amɛrika Atifi" },
            { "005", "Amɛrika Anaafoɔ" },
            { "009", "Osiana" },
            { "011", "Abibirem Atɔeɛ Fam" },
            { "013", "Amɛrika Mfimfini" },
            { "014", "Abibirem Apueiɛ Fam" },
            { "015", "Abibirem Atifi Fam" },
            { "017", "Abibirem Mfimfini" },
            { "018", "Abibirem Anaafoɔ Fam" },
            { "019", "Amɛrikafoɔ" },
            { "021", "Amɛrika Atifi Fam" },
            { "029", "Karibia" },
            { "030", "Asia Apueiɛ" },
            { "034", "Asia Anaafoɔ" },
            { "035", "Asia Anaafoɔ Apuieɛ" },
            { "039", "Yuropu Anaafoɔ" },
            { "053", "Ɔstrelia ne Asia" },
            { "054", "Melanesia" },
            { "057", "Micronesia Mantam" },
            { "061", "Pɔlenesia" },
            { "142", "Asia" },
            { "143", "Asia Mfimfini" },
            { "145", "Asia Atɔeɛ" },
            { "150", "Yuropu" },
            { "151", "Yuropu Apuieɛ" },
            { "154", "Yuropu Atifi" },
            { "155", "Yuropu Atɔeɛ" },
            { "202", "Abibirem Mpaprɛ Anaafoɔ" },
            { "419", "Laaten Amɛrika" },
            { "AC", "Asɛnhyin" },
            { "AD", "Andora" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ne Baabuda" },
            { "AI", "Anguila" },
            { "AL", "Albenia" },
            { "AM", "Aamenia" },
            { "AO", "Angola" },
            { "AQ", "Antaatika" },
            { "AR", "Agyɛntina" },
            { "AS", "Amɛrika Samoa" },
            { "AT", "Ɔstria" },
            { "AU", "Ɔstrelia" },
            { "AW", "Aruba" },
            { "AX", "Aland Aeland" },
            { "AZ", "Asabegyan" },
            { "BA", "Bosnia ne Hɛzegovina" },
            { "BB", "Baabados" },
            { "BD", "Bangladɛhye" },
            { "BE", "Bɛlgyium" },
            { "BF", "Bɔkina Faso" },
            { "BG", "Bɔlgeria" },
            { "BH", "Baren" },
            { "BI", "Burundi" },
            { "BJ", "Bɛnin" },
            { "BL", "St. Baatilemi" },
            { "BM", "Bɛmuda" },
            { "BN", "Brunae" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "BT", "Butan" },
            { "BV", "Bouvet Island" },
            { "BW", "Bɔtswana" },
            { "BY", "Bɛlarus" },
            { "BZ", "Beliz" },
            { "CA", metaValue_CA },
            { "CC", "Kokoso Supɔ" },
            { "CD", "Kongo Kinhyaahya" },
            { "CF", "Afrika Finimfin Man" },
            { "CG", "Kongo" },
            { "CH", "Swetzaland" },
            { "CI", "Kodivuwa" },
            { "CK", "Kuk Nsupɔ" },
            { "CL", "Kyili" },
            { "CM", "Kamɛrun" },
            { "CN", "Kyaena" },
            { "CO", "Kolombia" },
            { "CP", "Klepatin Aeland" },
            { "CR", "Kɔsta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kepvɛdfo Islands" },
            { "CW", "Kurakaw" },
            { "CX", "Buronya Supɔ" },
            { "CY", "Saeprɔso" },
            { "CZ", "Kyɛk" },
            { "DE", metaValue_DE },
            { "DG", "Diɛgo Gaasia" },
            { "DJ", "Gyibuti" },
            { "DK", "Dɛnmak" },
            { "DM", "Dɔmeneka" },
            { "DO", "Dɔmeneka Man" },
            { "DZ", "Ɔlgyeria" },
            { "EA", "Ceuta ne Melilla" },
            { "EC", "Yikuwedɔ" },
            { "EE", "Ɛstonia" },
            { "EG", "Misrim" },
            { "EH", "Sahara Atɔeɛ" },
            { "ER", "Ɛritrea" },
            { "ES", "Spain" },
            { "ET", "Ithiopia" },
            { "EU", "Yuropu Nkabomkuo" },
            { "EZ", "Yuropu Fam" },
            { "FI", "Finland" },
            { "FJ", "Figyi" },
            { "FK", "Fɔkman Aeland" },
            { "FM", "Maekronehyia" },
            { "FO", "Faro Aeland" },
            { "FR", "Franse" },
            { "GA", "Gabɔn" },
            { "GB", "UK" },
            { "GD", "Grenada" },
            { "GE", "Gyɔgyea" },
            { "GF", "Frɛnkye Gayana" },
            { "GG", "Guɛnse" },
            { "GH", "Gaana" },
            { "GI", "Gyebralta" },
            { "GL", "Greenman" },
            { "GM", "Gambia" },
            { "GN", "Gini" },
            { "GP", "Guwadelup" },
            { "GQ", "Gini Ikuweta" },
            { "GR", "Greekman" },
            { "GS", "Gyɔɔgyia Anaafoɔ ne Sandwich Aeland Anaafoɔ" },
            { "GT", "Guwatemala" },
            { "GU", "Guam" },
            { "GW", "Gini Bisaw" },
            { "GY", "Gayana" },
            { "HK", "Hɔnkɔn Kyaena" },
            { "HM", "Heard ne McDonald Supɔ" },
            { "HN", "Hɔnduras" },
            { "HR", "Krowehyia" },
            { "HT", "Heiti" },
            { "HU", "Hangari" },
            { "IC", "Canary Islands" },
            { "ID", "Indɔnehyia" },
            { "IE", "Aereland" },
            { "IL", "Israe" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Britenfo Man Wɔ India Po No Mu" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Aesland" },
            { "IT", "Itali" },
            { "JE", "Gyɛsi" },
            { "JM", "Gyameka" },
            { "JO", "Gyɔdan" },
            { "JP", "Gyapan" },
            { "KE", "Kenya" },
            { "KG", "Kɛɛgestan" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "KM", "Kɔmɔrɔs" },
            { "KN", "Saint Kitts ne Nɛves" },
            { "KP", "Korea Atifi" },
            { "KR", "Korea Anaafoɔ" },
            { "KW", "Kuweti" },
            { "KY", "Kemanfo Islands" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Lɛbanɔn" },
            { "LC", "Saint Lucia" },
            { "LI", "Lektenstaen" },
            { "LK", "Sri Lanka" },
            { "LR", "Laeberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituwenia" },
            { "LU", "Lusimbɛg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MD", "Mɔldova" },
            { "ME", "Mɔntenegro" },
            { "MF", "St. Maatin" },
            { "MG", "Madagaska" },
            { "MH", "Mahyaa Aeland" },
            { "MK", "Mesidonia Atifi" },
            { "ML", "Mali" },
            { "MM", "Mayaama (Bɛɛma)" },
            { "MN", "Mɔngolia" },
            { "MO", "Makaw Kyaena" },
            { "MP", "Mariana Atifi Fam Aeland" },
            { "MQ", "Matinik" },
            { "MR", "Mɔretenia" },
            { "MS", "Mantserat" },
            { "MT", "Mɔlta" },
            { "MU", "Mɔrehyeɔs" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mɛksiko" },
            { "MY", "Malehyia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Foforo" },
            { "NE", "Nigyɛɛ" },
            { "NF", "Norfold Supɔ" },
            { "NG", "Naegyeria" },
            { "NI", "Nekaraguwa" },
            { "NL", "Nɛdɛland" },
            { "NO", "Nɔɔwe" },
            { "NP", "Nɛpal" },
            { "NR", "Naworu" },
            { "NU", "Niyu" },
            { "NZ", "Ziland Foforo" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frɛnkye Pɔlenehyia" },
            { "PG", "Papua Gini Foforɔ" },
            { "PH", "Filipin" },
            { "PK", "Pakistan" },
            { "PL", "Pɔland" },
            { "PM", "Saint Pierre ne Miquelon" },
            { "PN", "Pitkaan Nsupɔ" },
            { "PR", "Puɛto Riko" },
            { "PS", "Palestaen West Bank ne Gaza" },
            { "PT", "Pɔtugal" },
            { "PW", "Palau" },
            { "PY", "Paraguae" },
            { "QA", "Kata" },
            { "QO", "Osiana Ano Ano" },
            { "RE", "Reyuniɔn" },
            { "RO", "Romenia" },
            { "RS", "Sɛbia" },
            { "RU", "Rɔhyea" },
            { "RW", "Rewanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solomɔn Aeland" },
            { "SC", "Seyhyɛl" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapɔ" },
            { "SH", "Saint Helena" },
            { "SI", "Slovinia" },
            { "SJ", "Svalbard ne Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sɛra Liɔn" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudan Anaafoɔ" },
            { "ST", "São Tomé ne Príncipe" },
            { "SV", "Ɛl Salvadɔ" },
            { "SX", "Sint Maaten" },
            { "SY", "Siria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Kuna" },
            { "TC", "Turks ne Caicos Islands" },
            { "TD", "Kyad" },
            { "TF", "Franse Anaafoɔ Nsaase" },
            { "TG", "Togo" },
            { "TH", "Taeland" },
            { "TJ", "Tagyikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timɔ Boka" },
            { "TM", "Tɛkmɛnistan" },
            { "TN", "Tunihyia" },
            { "TO", "Tonga" },
            { "TR", "Tɛɛki" },
            { "TT", "Trinidad ne Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukren" },
            { "UG", "Yuganda" },
            { "UM", "U.S. Nkyɛnnkyɛn Supɔ Ahodoɔ" },
            { "UN", "Amansan Nkabomkuo" },
            { "US", "Amɛrika" },
            { "UY", "Yurugwae" },
            { "UZ", "Usbɛkistan" },
            { "VA", "Vatican Man" },
            { "VC", "Saint Vincent ne Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Ngresifoɔ Virgin Island" },
            { "VI", "Amɛrika Virgin Islands" },
            { "VN", "Viɛtnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ne Futuna" },
            { "WS", "Samoa" },
            { "XA", "Anto Kasa" },
            { "XB", "Anto Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yɛmɛn" },
            { "YT", "Mayɔte" },
            { "ZA", "Abibirem Anaafoɔ" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Mantam a Yɛnnim" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amarik" },
            { "ar", metaValue_ar },
            { "as", "Asamese" },
            { "az", "Asabegyanni" },
            { "be", "Belarus kasa" },
            { "bg", "Bɔlgeria kasa" },
            { "bn", "Bengali kasa" },
            { "br", "Britenni" },
            { "bs", "Bosniani" },
            { "ca", "Katalan" },
            { "cs", "Kyɛk kasa" },
            { "cv", "Kyuvahyi" },
            { "cy", "Wɛɛhye Kasa" },
            { "da", "Dane kasa" },
            { "de", metaValue_DE },
            { "el", "Greek kasa" },
            { "en", "Borɔfo" },
            { "eo", "Esperanto" },
            { "es", "Spain kasa" },
            { "et", "Estonia kasa" },
            { "eu", "Baske" },
            { "fa", "Pɛɛhyia kasa" },
            { "ff", "Fula kasa" },
            { "fi", "Finlande kasa" },
            { "fo", "Farosi" },
            { "fr", "Frɛnkye" },
            { "fy", "Atɔeɛ Fam Frihyia Kasa" },
            { "ga", "Aerelande kasa" },
            { "gd", "Skotlandfoɔ Galek Kasa" },
            { "gl", "Galisia kasa" },
            { "gu", "Gugyarata" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Kurowehyia kasa" },
            { "hu", "Hangri kasa" },
            { "hy", "Aameniani" },
            { "ia", "Kasa ntam" },
            { "id", "Indonihyia kasa" },
            { "ie", "Kasa afrafra" },
            { "ig", "Igbo kasa" },
            { "is", "Aeslande kasa" },
            { "it", "Italy kasa" },
            { "ja", "Gyapan kasa" },
            { "jv", "Gyabanis kasa" },
            { "ka", "Gyɔɔgyia kasa" },
            { "kk", "kasaki kasa" },
            { "km", "Kambodia kasa" },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "ks", "Kahyimiɛ" },
            { "ku", "Kɛɛde kasa" },
            { "ky", "Kɛgyese kasa" },
            { "lb", "Lɔsimbɔge kasa" },
            { "lo", metaValue_lo },
            { "lt", "Lituania kasa" },
            { "lv", "Latvia kasa" },
            { "mi", "Mawori" },
            { "mk", "Mɛsidonia kasa" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marati" },
            { "ms", "Malay kasa" },
            { "mt", "Malta kasa" },
            { "my", "Bɛɛmis kasa" },
            { "ne", "Nɛpal kasa" },
            { "nl", "Dɛɛkye" },
            { "nn", "Nɔwefoɔ Ninɔso" },
            { "no", "Nɔwefoɔ kasa" },
            { "oc", "Osita kasa" },
            { "or", "Odia" },
            { "pa", "Pungyabi kasa" },
            { "pl", "Pɔland kasa" },
            { "ps", "Pahyito" },
            { "pt", "Pɔɔtugal kasa" },
            { "qu", "Kwɛkya" },
            { "rm", "Romanhye kasa" },
            { "ro", "Romenia kasa" },
            { "ru", "Rahyia kasa" },
            { "rw", "Rewanda kasa" },
            { "sa", "Sanskrit kasa" },
            { "sc", "Saadinia kasa" },
            { "sd", "Sindi" },
            { "si", "Sinhala" },
            { "sk", "Slovak Kasa" },
            { "sl", "Slovɛniafoɔ Kasa" },
            { "so", "Somalia kasa" },
            { "sq", "Aabeniani" },
            { "sr", "Sɛbia Kasa" },
            { "su", "Sunda Kasa" },
            { "sv", "Sweden kasa" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", "Telugu" },
            { "tg", "Tɛgyeke kasa" },
            { "th", "Taeland kasa" },
            { "ti", "Tigrinya kasa" },
            { "tk", "Tɛkmɛnistan Kasa" },
            { "to", "Tonga kasa" },
            { "tr", "Tɛɛki kasa" },
            { "tt", "Tata kasa" },
            { "ug", "Yugaa Kasa" },
            { "uk", "Ukren kasa" },
            { "ur", "Urdu kasa" },
            { "uz", "Usbɛkistan Kasa" },
            { "vi", "Viɛtnam kasa" },
            { "wo", "Wolɔfo Kasa" },
            { "xh", "Hosa Kasa" },
            { "yo", "Yoruba" },
            { "za", "Zuang" },
            { "zh", "Kyaena kasa" },
            { "zu", "Zulu" },
            { "ast", "Asturiani" },
            { "bgc", "Harianvi" },
            { "bho", "Bopuri" },
            { "blo", "Anii" },
            { "brx", "Bodo" },
            { "ceb", "Kebuano" },
            { "chr", "Kiroki" },
            { "csw", "Tadeɛm Kreefoɔ Kasa" },
            { "doi", "Dɔgri" },
            { "dsb", "Sɔɔbia a ɛwɔ fam" },
            { "fil", "Filipin kasa" },
            { "hsb", "Atifi fam Sɔɔbia Kasa" },
            { "kea", "Kabuvadianu" },
            { "kgp", "Kaingang" },
            { "kok", "Konkani kasa" },
            { "kxv", "Kuvi kasa" },
            { "lij", "Liguria kasa" },
            { "lmo", "Lombad kasa" },
            { "mai", "Maetili" },
            { "mni", "Manipuri" },
            { "mul", "Kasa ahodoɔ" },
            { "nds", "Gyaaman kasa a ɛwɔ fam" },
            { "nqo", "Nko" },
            { "pcm", "Nigeriafoɔ Pigyin" },
            { "prg", "Prusia kasa" },
            { "raj", "Ragyasitan kasa" },
            { "sah", "Yakut Kasa" },
            { "sat", "Santal kasa" },
            { "syr", "Siiria Kasa" },
            { "szl", "Silesiafoɔ Kasa" },
            { "und", "kasa a yɛnnim" },
            { "vec", "Vɛnihyia Kasa" },
            { "vmw", "Makuwa" },
            { "xnr", "Kangri" },
            { "yrl", "Ningatu" },
            { "yue", "Kantonese" },
            { "zxx", "Lengwestese biara nnim" },
            { "Adlm", "Adlam kasa" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliki kasa" },
            { "Armn", "Amenia kasa" },
            { "Beng", "Bangala kasa" },
            { "Bopo", "Bopomofo kasa" },
            { "Brai", "Anifrafoɔ kasa" },
            { "Cakm", "Kyakma kasa" },
            { "Cans", "Kanadafoɔ Kann Kasa a Wɔakeka Abom" },
            { "Cher", "Kɛroki" },
            { "Cyrl", "Kreleke" },
            { "Deva", "Dɛvanagari kasa" },
            { "Ethi", "Yitiopia kasa" },
            { "Geor", "Dwɔɔgyia kasa" },
            { "Grek", "Griiki kasa" },
            { "Gujr", "Gudwurati kasa" },
            { "Guru", "Gurumuki kasa" },
            { "Hanb", "Hanse a Bopomofo kasa ka ho" },
            { "Hang", "Hangul kasa" },
            { "Hani", "Han" },
            { "Hans", "Kyaena Kasa Hanse" },
            { "Hant", "Tete" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana kasa" },
            { "Hrkt", "Gyapanfoɔ selabolo kasa" },
            { "Jamo", "Gyamo kasa" },
            { "Jpan", "Gyapanfoɔ kasa" },
            { "Kana", "Katakana kasa" },
            { "Khmr", "Kɛma kasa" },
            { "Knda", "Kanada kasa" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "Laatin" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meeti Mayɛke kasa" },
            { "Mymr", "Mayama kasa" },
            { "Nkoo", "Nko kasa" },
            { "Olck", "Ol Kyiki kasa" },
            { "Orya", "Odia kasa" },
            { "Rohg", "Hanifi kasa" },
            { "Sinh", "Sinhala kasa" },
            { "Sund", "Sudanni kasa" },
            { "Syrc", "Siiria Tete kasa" },
            { "Taml", metaValue_ta },
            { "Telu", "Telugu kasa" },
            { "Tfng", "Tifinafo kasa" },
            { "Thaa", "Taana kasa" },
            { "Thai", "Taelanfoɔ kasa" },
            { "Tibt", "Tibɛtanfoɔ kasa" },
            { "Vaii", "Vai kasa" },
            { "Yiii", "Yifoɔ kasa" },
            { "Zmth", "Nkontabudeɛ" },
            { "Zsye", "Yimogyi" },
            { "Zsym", "Ahyɛnsodeɛ" },
            { "Zxxx", "Deɛ wɔntwerɛeɛ" },
            { "Zyyy", "obiara nim" },
            { "Zzzz", "Deɛ yɛnnim" },
            { "de_AT", "Ɔstria Gyaaman" },
            { "de_CH", "Swisalande Gyaaman" },
            { "en_GB", "Ngresi Borɔfo" },
            { "en_US", "Amɛrika Borɔfo" },
            { "fr_CA", "Kanada Frɛnkye" },
            { "fr_CH", "Swisalande Frɛnkye" },
            { "nl_BE", "Dɛɛkye (Bɛɛgyiɔm" },
            { "ar_001", "Arabeke Kasa Nhyehyɛeɛ Foforɔ" },
            { "es_419", "Spain kasa (Laaten Amɛrika)" },
            { "key.ca", "Kalɛnna" },
            { "key.cf", "Sika Fɔmate" },
            { "key.co", "Nyiyie Kwan" },
            { "key.cu", "Sika" },
            { "key.hc", "Dɔnhwere Nkɔmmaeɛ (12 anaa 24)" },
            { "key.lb", "Line Break Nhyehyɛeɛ" },
            { "key.ms", "Nsusudeɛ Sestɛm" },
            { "key.nu", "Nɛma" },
            { "hi_Latn", "Laatenfoɔ Hindi" },
            { "zh_Hans", "Kyaena kasa a emu yɛ mmrɛ" },
            { "zh_Hant", "Tete Kyaena kasa" },
            { "type.ca.roc", "Minguo Kalɛnda" },
            { "type.hc.h11", "Nnɔnhwere 12 Sestɛm (0–11)" },
            { "type.hc.h12", "Nnɔnhwere 12 Sestɛm (1–12" },
            { "type.hc.h23", "Nnɔnhwere 24 Sestɛm (0–23)" },
            { "type.hc.h24", "Nnɔnhwere 24 Sestɛm (0–24)" },
            { "type.nu.arab", "Arabeke Digyete" },
            { "type.nu.armn", "Aamenia Nɔma" },
            { "type.nu.beng", "Bangla Gigyete" },
            { "type.nu.cakm", "Kyakma Digyete" },
            { "type.nu.deva", "Devanagari Gigyete" },
            { "type.nu.ethi", "Yitiopia Nɔma" },
            { "type.nu.geor", "Gyɔgyea Nɔma" },
            { "type.nu.grek", "Griiki Nɔma" },
            { "type.nu.gujr", "Gugyarati Digyete" },
            { "type.nu.guru", "Gurumuki Digyete" },
            { "type.nu.hans", "Kyaenafoɔ Dɛsima Nɔma a Emu Yɛ Mmrɛ" },
            { "type.nu.hant", "Kyaenafoɔ Tete Nɔma" },
            { "type.nu.hebr", "Hibri Nɔma" },
            { "type.nu.java", "Gyavaniisi Digyete" },
            { "type.nu.jpan", "Gyapanfoɔ Nɔma" },
            { "type.nu.khmr", "Kima Digyete" },
            { "type.nu.knda", "Kanada Digyete" },
            { "type.nu.laoo", "Lawo Digyete" },
            { "type.nu.latn", "Atɔeɛ Fam Digyete" },
            { "type.nu.mlym", "Malayalam Digyete" },
            { "type.nu.mtei", "Meeti Mayɛke Digyete" },
            { "type.nu.mymr", "Mayaama Digyete" },
            { "type.nu.olck", "Ol Kyiki Digyete" },
            { "type.nu.orya", "Odia Digyete" },
            { "type.nu.taml", "Tamil Tete Nɔma" },
            { "type.nu.telu", "Telugu Digyete" },
            { "type.nu.thai", "Taelanfoɔ Digyete" },
            { "type.nu.tibt", "Tibɛtan Digyete" },
            { "type.nu.vaii", "Vai Gigyete" },
            { "type.ca.dangi", "Dangi Kalɛnna" },
            { "type.co.ducet", "Koodu Korɔ Nyiyie Kwan a ɛdi Kan" },
            { "type.lb.loose", "Line Break Nhyehyɛeɛ a Emu Yɛ Mmrɛ" },
            { "type.nu.roman", "Roman Nɔma" },
            { "type.ca.coptic", "Kɔtesefoɔ Kalɛnna" },
            { "type.ca.hebrew", "Hibri Kalɛnda" },
            { "type.co.search", "Daa-Botaeɛ Adehwehwɛ" },
            { "type.lb.normal", "Daa Line Break Nhyehyɛeɛ" },
            { "type.lb.strict", "Line Break Nhyehyɛeɛ Ferenkyemm" },
            { "type.ms.metric", "Mɛtreke Nhyehyɛeɛ" },
            { "type.ca.chinese", "Kyaenafoɔ Kalɛnna" },
            { "type.ca.islamic", "Higyiri Kalɛnda" },
            { "type.ca.iso8601", "ISO-8601 Kalɛnna" },
            { "type.ca.persian", "Pɛɛsiafoɔ Kalɛnda" },
            { "type.cf.account", "Sika Nkotabuo Fɔmate" },
            { "type.nu.arabext", "Arabeke Digyete a Wɔatrɛm" },
            { "type.nu.armnlow", "Aamenia Nɔma Nkumaa" },
            { "type.nu.greklow", "Griiki Nɔma Nkumaa" },
            { "type.nu.hanidec", "Kyaenafoɔ Dɛsima Nɔma" },
            { "type.nu.hansfin", "Kyaenafoɔ Sikasɛm Dɛsima Nɔma a Emu Yɛ Mmrɛ" },
            { "type.nu.hantfin", "Tete Kyaena Sikasɛm Nɔma" },
            { "type.nu.jpanfin", "Gyapanfoɔ Sikasɛm Nɔma" },
            { "type.nu.tamldec", "Tamil Digyete" },
            { "type.ca.buddhist", "Budafoɔ Kalɛnna" },
            { "type.ca.ethiopic", "Yitiopia Kalɛnna" },
            { "type.ca.japanese", "Gyapanfoɔ Kalɛnda" },
            { "type.cf.standard", "Sika Fɔmate Susudua" },
            { "type.co.standard", "Nyiyie Kwan Susudua" },
            { "type.ms.uksystem", "Imperial Nsusudeɛ Sestɛm" },
            { "type.ms.ussystem", "US Nsusudeɛ Sestɛm" },
            { "type.nu.fullwide", "Digyete a Emu Pi" },
            { "type.nu.romanlow", "Romanfoɔ Nɔma Nkumaa" },
            { "type.ca.gregorian", "Gregorian Kalɛnna" },
            { "type.ca.islamic-civil", "Higyiri Kalɛnda (tabula, sivil epokyi" },
            { "type.ca.islamic-umalqura", "Higyiri Kalɛnda (Ummm al-Kura)" },
            { "type.ca.ethiopic-amete-alem", "Yitiopia Amete Alɛm Kalɛnna" },
        };
        return data;
    }
}
