/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_dz extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "འཛམ་གླིང༌" },
            { "002", "ཨཕ་རི་ཀ" },
            { "003", "བྱང་ཨ་མི་རི་ཀ" },
            { "005", "ལྷོ་ཨ་མི་རི་ཀ" },
            { "009", "ཨོཤི་ཡཱན་ན" },
            { "011", "ནུབ་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ" },
            { "013", "བར་ཕྱོགས་ཨ་མི་རི་ཀ" },
            { "014", "ཤར་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ" },
            { "015", "བྱང་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ" },
            { "017", "སྦུག་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ" },
            { "018", "ལྷོའི་ཨཕ་རི་ཀ" },
            { "019", "ཨ་མི་རི་ཀ་ཚུ" },
            { "021", "བྱང་ཕྱོགས་ཀྱི་ཨ་མི་རི་ཀ" },
            { "029", "ཀེ་རི་བི་ཡེན" },
            { "030", "ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ" },
            { "034", "ལྷོའི་ཨེ་ཤི་ཡ" },
            { "035", "ལྷོ་ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ" },
            { "039", "ལྷོའི་ཡུ་རོབ" },
            { "053", "ཨཱོས་ཊྲེལ་ཨེ་ཤི་ཡ" },
            { "054", "མེ་ལ་ནི་ཤི་ཡ" },
            { "057", "ལུང་ཕྱོགས་མའི་ཀྲོ་ནི་ཤི་ཡ" },
            { "061", "པོ་ལི་ནི་ཤི་ཡ" },
            { "142", "ཨེ་ཤི་ཡ" },
            { "143", "སྦུག་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ" },
            { "145", "ནུབ་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ" },
            { "150", "ཡུ་རོབ" },
            { "151", "ཤར་ཕྱོགས་ཀྱི་ཡུ་རོབ" },
            { "154", "བྱང་ཕྱོགས་ཀྱི་ཡུ་རོབ" },
            { "155", "ནུབ་ཕྱོགས་ཀྱི་ཡུ་རོབ" },
            { "419", "ལེ་ཊིནཨ་མི་རི་ཀ" },
            { "AC", "ཨེ་སེན་ཤུན་ཚོ་གླིང༌" },
            { "AD", "ཨཱན་དོ་ར" },
            { "AE", "ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས" },
            { "AF", "ཨཕ་གྷ་ནི་སཏཱན" },
            { "AG", "ཨན་ཊི་གུ་ཝ་ ཨེནཌ་ བྷར་བྷུ་ཌ" },
            { "AI", "ཨང་གི་ལ" },
            { "AL", "ཨཱལ་བེ་ནི་ཡ" },
            { "AM", "ཨར་མི་ནི་ཡ" },
            { "AO", "ཨང་གྷོ་ལ" },
            { "AQ", "འཛམ་གླིང་ལྷོ་མཐའི་ཁྱགས་གླིང" },
            { "AR", "ཨར་ཇེན་ཊི་ན" },
            { "AS", "ས་མོ་ཨ་ཡུ་ཨེས་ཨེ་མངའ་ཁོངས" },
            { "AT", "ཨཱོས་ཊྲི་ཡ" },
            { "AU", "ཨཱོས་ཊྲེལ་ལི་ཡ" },
            { "AW", "ཨ་རུ་བཱ" },
            { "AX", "ཨ་ལནཌ་གླིང་ཚོམ" },
            { "AZ", "ཨ་ཛར་བྷའི་ཇཱན" },
            { "BA", "བྷོས་ནི་ཡ་ ཨེནཌ་ ཧར་ཛི་གྷོ་བི་ན" },
            { "BB", "བྷར་བེ་ཌོས" },
            { "BD", "བངྒ་ལ་དེཤ" },
            { "BE", "བྷེལ་ཇམ" },
            { "BF", "བྷར་ཀི་ན་ ཕེ་སོ" },
            { "BG", "བུལ་ག་རི་ཡ" },
            { "BH", "བྷ་རེན" },
            { "BI", "བྷུ་རུན་ཌི" },
            { "BJ", "བྷེ་ནིན" },
            { "BL", "སེནཊ་ བར་ཐོ་ལོམ་མིའུ" },
            { "BM", "བར་མུ་ཌ" },
            { "BN", "བྷྲུ་ནའི" },
            { "BO", "བྷེ་ལི་བི་ཡ" },
            { "BQ", "ཀེ་རི་བི་ཡེན་ནེ་དར་ལནཌས྄" },
            { "BR", "བྲ་ཛིལ" },
            { "BS", "བྷ་ཧ་མས྄" },
            { "BT", "འབྲུག" },
            { "BV", "བོའུ་ཝེཊ་མཚོ་གླིང" },
            { "BW", "བྷོཙ་ཝ་ན" },
            { "BY", "བེལ་ཨ་རུ་སུ" },
            { "BZ", "བྷེ་ལིཛ" },
            { "CA", "ཀེ་ན་ཌ" },
            { "CC", "ཀོ་ཀོས་གླིང་ཚོམ" },
            { "CD", "ཀོང་གྷོ ཀིན་ཤ་ས" },
            { "CF", "སེན་ཊལ་ ཨཕ་རི་ཀཱན་ རི་པབ་ལིཀ" },
            { "CG", "ཀོང་གྷོ བྷྲ་ཛ་བིལ" },
            { "CH", "སུ་ཝིཊ་ཛར་ལེནཌ" },
            { "CI", "ཀོ་ཊེ་ ཌི་ཨི་ཝོ་རེ" },
            { "CK", "ཀུག་གླིང་ཚོམ" },
            { "CL", "ཅི་ལི" },
            { "CM", "ཀེ་མ་རུན" },
            { "CN", "རྒྱ་ནག" },
            { "CO", "ཀོ་ལོམ་བྷི་ཡ" },
            { "CP", "ཀི་ལི་པེར་ཊོན་མཚོ་གླིང་" },
            { "CR", "ཀོས་ཊ་རི་ཀ" },
            { "CU", "ཀིའུ་བྷ" },
            { "CV", "ཀེཔ་བཱཌ" },
            { "CW", "ཀྱཱུར་ར་ཀོ" },
            { "CX", "ཁི་རིསྟ་མེས་མཚོ་གླིང" },
            { "CY", "སཱའི་པྲས" },
            { "CZ", "ཅེཀ་ རི་པབ་ལིཀ" },
            { "DE", "ཇཱར་མ་ནི" },
            { "DG", "ཌི་ཡེ་གོ་གར་སིའོ" },
            { "DJ", "ཇི་བྷུ་ཊི" },
            { "DK", "ཌེན་མཱཀ" },
            { "DM", "ཌོ་མི་ནི་ཀ" },
            { "DO", "ཌོ་མི་ནི་ཀཱན་ རི་པབ་ལིཀ" },
            { "DZ", "ཨཱལ་ཇི་རི་ཡ" },
            { "EA", "སེ་ཨུ་ཏ་ ཨེནཌ་ མེལ་ལི་ལ" },
            { "EC", "ཨེ་ཁྭ་ཌོར" },
            { "EE", "ཨེས་ཊོ་ནི་ཡ" },
            { "EG", "ཨི་ཇིབཊ" },
            { "EH", "ནུབ་ཕྱོགས་ ས་ཧཱ་ར" },
            { "ER", "ཨེ་རི་ཊྲེ་ཡ" },
            { "ES", "ཨིས་པེན" },
            { "ET", "ཨི་ཐི་ཡོ་པི་ཡ" },
            { "EU", "ཡུ་རོབ་གཅིག་བསྡོམས་ཚོགས་པ" },
            { "FI", "ཕིན་ལེནཌ" },
            { "FJ", "ཕི་ཇི" },
            { "FK", "ཕལྐ་ལནྜ་གླིང་ཚོམ" },
            { "FM", "མའི་ཀྲོ་ནི་ཤི་ཡ" },
            { "FO", "ཕཱའེ་རོ་གླིང་ཚོམ" },
            { "FR", "ཕྲཱནས" },
            { "GA", "གྷ་བྷོན" },
            { "GB", "ཡུ་ནཱའི་ཊེཌ་ ཀིང་ཌམ" },
            { "GD", "གྲྀ་ན་ཌ" },
            { "GE", "ཇཽར་ཇཱ" },
            { "GF", "གུའི་ཡ་ན་ ཕྲནས྄་མངའ་ཁོངས" },
            { "GG", "གུ་ཨེརྣ་སི" },
            { "GH", "གྷ་ན" },
            { "GI", "ཇིབ་རཱལ་ཊར" },
            { "GL", "གིརཱིན་ལནཌ྄" },
            { "GM", "གྷེམ་བི་ཡ" },
            { "GN", "གྷི་ནི" },
            { "GP", "གོ་ཌེ་ལུ་པེ" },
            { "GQ", "ཨེ་ཀུ་ཊོ་རེལ་ གི་ནི" },
            { "GR", "གིརིས྄" },
            { "GS", "སཱའུཐ་ཇཽར་ཇཱ་ དང་ སཱའུཐ་སེནཌ྄་ཝིཅ་གླིང་ཚོམ" },
            { "GT", "གྷོ་ཊ་མ་ལ" },
            { "GU", "གུ་འམ་ མཚོ་གླིང" },
            { "GW", "གྷི་ནི་ བྷི་སཱའུ" },
            { "GY", "གྷ་ཡ་ན" },
            { "HK", "ཧོང་ཀོང་ཅཱའི་ན" },
            { "HM", "ཧཱརཌ་མཚོ་གླིང་ དང་ མེཀ་ཌོ་ནལཌ྄་གླིང་ཚོམ" },
            { "HN", "ཧཱན་ཌུ་རཱས྄" },
            { "HR", "ཀྲོ་ཨེ་ཤ" },
            { "HT", "ཧེ་ཊི" },
            { "HU", "ཧཱང་གྷ་རི" },
            { "IC", "ཀ་ནེ་རི་གླིང་ཚོམ" },
            { "ID", "ཨིན་ཌོ་ནེ་ཤི་ཡ" },
            { "IE", "ཨཱ་ཡ་ལེནཌ" },
            { "IL", "ཨིས་ར་ཡེལ" },
            { "IM", "ཨ་ཡུལ་ ཨོཕ་ མཱན" },
            { "IN", "རྒྱ་གར" },
            { "IQ", "ཨི་རཱཀ" },
            { "IR", "ཨི་རཱན" },
            { "IS", "ཨཱའིས་ལེནཌ" },
            { "IT", "ཨི་ཊ་ལི" },
            { "JE", "ཇེར་སི" },
            { "JM", "ཇཱ་མཻ་ཀ" },
            { "JO", "ཇོར་ཌན" },
            { "JP", "ཇ་པཱན" },
            { "KE", "ཀེན་ཡ" },
            { "KG", "ཀིར་གིས་སཏཱན" },
            { "KH", "ཀམ་བྷོ་ཌི་ཡ" },
            { "KI", "ཀི་རི་བ་ཏི་མཚོ་གླིང" },
            { "KM", "ཀོ་མོ་རོས" },
            { "KN", "སེནཊ་ ཀིཊས་ དང་ ནེ་བིས" },
            { "KP", "བྱང་ ཀོ་རི་ཡ" },
            { "KR", "ལྷོ་ ཀོ་རི་ཡ" },
            { "KW", "ཀུ་ཝེཊ" },
            { "KY", "ཁེ་མེན་གླིང་ཚོམ" },
            { "KZ", "ཀ་ཛགས་སཏཱན" },
            { "LA", "ལཱ་ཝོས" },
            { "LB", "ལེ་བ་ནོན" },
            { "LC", "སེནཊ་ ལུ་སི་ཡ" },
            { "LI", "ལིཀ་ཏནས་ཏ་ཡིན" },
            { "LK", "ཤྲཱི་ལང་ཀ" },
            { "LR", "ལཱའི་བེ་རི་ཡ" },
            { "LS", "ལཻ་སོ་ཐོ" },
            { "LT", "ལི་ཐུ་ཝེ་ནི་ཡ" },
            { "LU", "ལག་ཛམ་བོརྒ" },
            { "LV", "ལཊ་བི་ཡ" },
            { "LY", "ལི་བི་ཡ" },
            { "MA", "མོ་རོ་ཀོ" },
            { "MC", "མོ་ན་ཀོ" },
            { "MD", "མོལ་དོ་བཱ" },
            { "ME", "མོན་ཊི་ནེག་རོ" },
            { "MF", "སེནཊ་ མཱར་ཊིན" },
            { "MG", "མ་དཱ་གེས་ཀར" },
            { "MH", "མར་ཤེལ་གླིང་ཚོམ" },
            { "ML", "མཱ་ལི" },
            { "MM", "མི་ཡཱན་མར་ (བྷར་མ)" },
            { "MN", "སོག་པོ་ཡུལ" },
            { "MO", "མཀ་ཨའུ་ཅཱའི་ན" },
            { "MP", "བྱང་ཕྱོགས་ཀྱི་མ་ར་ཡ་ན་གླིང་ཚོམ" },
            { "MQ", "མཱར་ཊི་ནིཀ" },
            { "MR", "མོ་རི་ཊེ་ནི་ཡ" },
            { "MS", "མོན་ས་རཊ" },
            { "MT", "མཱལ་ཊ" },
            { "MU", "མོ་རི་ཤཱས" },
            { "MV", "མཱལ་དིབས" },
            { "MW", "མ་ལ་ཝི" },
            { "MX", "མེཀ་སི་ཀོ" },
            { "MY", "མ་ལེ་ཤི་ཡ" },
            { "MZ", "མོ་ཛམ་བྷིཀ" },
            { "NA", "ན་མི་བི་ཡ" },
            { "NC", "ནིའུ་ཀ་ལི་དོ་ནི་ཡ" },
            { "NE", "ནཱའི་ཇཱ" },
            { "NF", "ནོར་ཕོལཀ་མཚོ་གླིང༌" },
            { "NG", "ནཱའི་ཇི་རི་ཡ" },
            { "NI", "ནི་ཀྲ་ཝ་ག" },
            { "NL", "ནེ་དར་ལནཌས྄" },
            { "NO", "ནོར་ཝེ" },
            { "NP", "བལ་ཡུལ" },
            { "NR", "ནའུ་རུ་" },
            { "NU", "ནི་ཨུ་ཨཻ" },
            { "NZ", "ནིའུ་ཛི་ལེནཌ" },
            { "OM", "ཨོ་མཱན" },
            { "PA", "པ་ན་མ" },
            { "PE", "པེ་རུ" },
            { "PF", "ཕྲཱནས྄་ཀྱི་པོ་ལི་ནི་ཤི་ཡ" },
            { "PG", "པ་པུ་ ནིའུ་གི་ནི" },
            { "PH", "ཕི་ལི་པིནས" },
            { "PK", "པ་ཀི་སཏཱན" },
            { "PL", "པོ་ལེནཌ" },
            { "PM", "སིནཊ་པི་ཡེར་ ཨེནཌ་ མིཀོ་ལེན" },
            { "PN", "པིཊ་ཀེ་ཡེརན་གླིང་ཚོམ" },
            { "PR", "པུ་འེར་ཊོ་རི་ཁོ" },
            { "PS", "པེ་ལིསི་ཊི་ནི་ཡན་ཊེ་རི་ཐོ་རི" },
            { "PT", "པོར་ཅུ་གཱལ" },
            { "PW", "པ་ལའུ" },
            { "PY", "པ་ར་གུ་ཝའི" },
            { "QA", "ཀ་ཊར" },
            { "QO", "ཨོཤི་ཡཱན་ན་གྱི་མཐའ་མཚམས" },
            { "RE", "རེ་ཡུ་ནི་ཡོན" },
            { "RO", "རོ་མེ་ནི་ཡ" },
            { "RS", "སཱར་བྷི་ཡ" },
            { "RU", "ཨུ་རུ་སུ" },
            { "RW", "རུ་ཝན་ཌ" },
            { "SA", "སཱཝ་དི་ ཨ་རེ་བྷི་ཡ" },
            { "SB", "སོ་ལོ་མོན་ གླིང་ཚོམ" },
            { "SC", "སེ་ཤཱལས" },
            { "SD", "སུ་ཌཱན" },
            { "SE", "སུའི་ཌེན" },
            { "SG", "སིང་ག་པོར" },
            { "SH", "སེནཊ་ ཧེ་ལི་ན" },
            { "SI", "སུ་ལོ་བི་ནི་ཡ" },
            { "SJ", "སྭཱལ་བྷརྡ་ ཨེནཌ་ ཇཱན་མ་ཡེན" },
            { "SK", "སུ་ལོ་བཱ་ཀི་ཡ" },
            { "SL", "སི་ར་ ལི་འོན" },
            { "SM", "སཱན་མ་རི་ནོ" },
            { "SN", "སེ་ནི་གྷལ" },
            { "SO", "སོ་མ་ལི་ཡ" },
            { "SR", "སུ་རི་ནཱམ" },
            { "SS", "སཱའུཐ་ སུ་ཌཱན" },
            { "ST", "སཝ་ ཊོ་མེ་ ཨེནཌ་ པྲྀན་སི་པེ" },
            { "SV", "ཨེལ་སལ་བ་ཌོར" },
            { "SX", "སིནཊ་ མཱར་ཊེན" },
            { "SY", "སི་རི་ཡ" },
            { "SZ", "སུ་ཝ་ཛི་ལེནཌ" },
            { "TA", "ཏྲིས་ཏན་ད་ཀུན་ཧ" },
            { "TC", "ཏུརྐས྄་ ཨེནཌ་ ཀ་ཀོས་གླིང་ཚོམ" },
            { "TD", "ཅཱཌ" },
            { "TF", "ཕྲནཅ་གི་ལྷོ་ཕྱོགས་མངའ་ཁོངས" },
            { "TG", "ཊོ་གྷོ" },
            { "TH", "ཐཱའི་ལེནཌ" },
            { "TJ", "ཏ་ཇིག་གི་སཏཱན" },
            { "TK", "ཏོ་ཀེ་ལའུ་ མཚོ་གླིང" },
            { "TL", "ཏི་་མོར་ལེ་ཨེསཊ" },
            { "TM", "ཊཱརཀ་མེནའི་སཏཱན" },
            { "TN", "ཊུ་ནི་ཤི་ཡ" },
            { "TO", "ཊོང་གྷ" },
            { "TR", "ཊཱར་ཀི" },
            { "TT", "ཊི་ནི་ཌཱཌ་ ཨེནཌ་ ཊོ་བྷེ་གྷོ" },
            { "TV", "ཏུ་ཝ་ལུ" },
            { "TW", "ཊཱའི་ཝཱན" },
            { "TZ", "ཊཱན་ཛཱ་ནི་ཡ" },
            { "UA", "ཡུ་ཀརེན" },
            { "UG", "ཡུ་གྷན་ཌ" },
            { "UM", "ཡུ་ཨེས་གྱི་མཐའ་མཚམས་མཚོ་གླིང་" },
            { "US", "ཡུ་ཨེས་ཨེ" },
            { "UY", "ཡུ་རུ་གུ་ཝའི" },
            { "UZ", "ཨུས་བེག་གི་སཏཱན" },
            { "VA", "བ་ཊི་ཀཱན་ སི་ཊི" },
            { "VC", "སེནཊ་ཝིན་སེནཌ྄ ཨེནཌ་ གི་རེ་ན་དིནས྄" },
            { "VE", "བེ་ནི་ཛུ་ཝེ་ལ" },
            { "VG", "ཝརཇིན་གླིང་ཚོམ་ བྲཱི་ཊིཤ་མངའ་ཁོངས" },
            { "VI", "ཝརཇིན་གླིང་ཚོམ་ ཡུ་ཨེས་ཨེ་མངའ་ཁོངས" },
            { "VN", "བེཊ་ནཱམ" },
            { "VU", "ཝ་ནུ་ཨ་ཏུ" },
            { "WF", "ཝལ་ལིས྄་ ཨེནཌ་ ཕུ་ཏུ་ན་" },
            { "WS", "ས་མོ་ཨ" },
            { "YE", "ཡེ་མེན" },
            { "YT", "མེ་ཡོཊ" },
            { "ZA", "སཱའུཐ་ ཨཕ་རི་ཀ" },
            { "ZM", "ཛམ་བྷི་ཡ" },
            { "ZW", "ཛིམ་བྷབ་ཝེ" },
            { "ZZ", "ངོ་མ་ཤེས་པའི་ལུང་ཕྱོགས" },
            { "aa", "ཨ་ཕར་ཁ" },
            { "ab", "ཨཱབ་ཁ་ཟི་ཡ་ཁ" },
            { "af", "ཨཕ་རི་ཀཱནས་ཁ" },
            { "am", "ཨམ་ཧ་རིཀ་ཁ" },
            { "ar", "ཨེ་ར་བིཀ་ཁ" },
            { "as", "ཨ་ས་མིས་ཁ" },
            { "az", "ཨ་ཛར་བྷའི་ཇཱན་ཁ" },
            { "be", "བེལ་ཨ་རུས་ཁ" },
            { "bg", "བཱལ་གེ་རི་ཡཱན་ཁ" },
            { "bn", "བངྒ་ལ་ཁ" },
            { "bo", "བོད་ཁ" },
            { "bs", "བྷོས་ནི་ཡཱན་ཁ" },
            { "ca", "ཀེ་ཊ་ལཱན་ཁ" },
            { "cs", "ཅེཀ་ཁ" },
            { "cy", "ཝེལཤ་ཁ" },
            { "da", "ཌེ་ནིཤ་ཁ" },
            { "de", "ཇཱར་མཱན་ཁ" },
            { "dv", "དི་བེ་ཧི་ཁ" },
            { "dz", "རྫོང་ཁ" },
            { "el", "གྲིཀ་ཁ" },
            { "en", "ཨིང་ལིཤ་ཁ" },
            { "eo", "ཨེས་པ་རཱན་ཏོ་ཁ" },
            { "es", "ཨིས་པེ་ནིཤ་ཁ" },
            { "et", "ཨེས་ཊོ་ནི་ཡཱན་ཁ" },
            { "eu", "བཱསཀ་ཁ" },
            { "fa", "པར་ཤི་ཡཱན་ཁ" },
            { "fi", "ཕི་ནིཤ་ཁ" },
            { "fj", "ཕི་ཇི་ཡཱན་ཁ" },
            { "fo", "ཕཱ་རོ་ཨིས་ཁ" },
            { "fr", "ཕྲནཅ་ཁ" },
            { "fy", "ནུབ་ཕྼི་སི་ཡན་ཁ" },
            { "ga", "ཨཱའི་རིཤ་ཁ" },
            { "gl", "གལ་ཨིས་ཨི་ཡན་ཁ" },
            { "gn", "གུ་ཝ་ར་ནི་ཁ" },
            { "gu", "གུ་ཇ་ར་ཏི་ཁ" },
            { "ha", "ཧཝ་ས་ཁ" },
            { "he", "ཧེ་བྲུ་ཁ" },
            { "hi", "ཧིན་དི་ཁ" },
            { "hr", "ཀྲོ་ཨེ་ཤི་ཡཱན་ཁ" },
            { "ht", "ཧེ་ཏི་ཡཱན་ཁ" },
            { "hu", "ཧཱང་གྷ་རི་ཡཱན་ཁ" },
            { "hy", "ཨར་མི་ནི་ཡཱན་ཁ" },
            { "id", "ཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁ" },
            { "ig", "ཨིག་བོ་ཁ" },
            { "is", "ཨ་ཡིས་ལེན་ཌིཀ་ཁ" },
            { "it", "ཨི་ཊ་ལི་ཡཱན་ཁ" },
            { "ja", "ཇཱ་པཱ་ནིས་ཁ" },
            { "jv", "ཇཱ་བ་ནིས་ཁ" },
            { "ka", "ཇཽ་ཇི་ཡཱན་ཁ" },
            { "kk", "ཀ་ཛགས་ཁ" },
            { "km", "ཁེ་མེར་ཁ" },
            { "kn", "ཀ་ན་ཌ་ཁ" },
            { "ko", "ཀོ་རི་ཡཱན་ཁ" },
            { "ks", "ཀཱཤ་མི་རི་ཁ" },
            { "ku", "ཀར་ཌིཤ་ཁ" },
            { "ky", "ཀིར་གིས་ཁ" },
            { "la", "ལེ་ཊིན་ཁ" },
            { "lb", "ལག་ཛམ་བོརྒ་ཁ" },
            { "lo", "ལཱ་ཝོས་ཁ" },
            { "lt", "ལི་ཐུ་ཝེ་ནི་ཡཱན་ཁ" },
            { "lv", "ལཊ་བི་ཡཱན་ཁ" },
            { "mg", "མ་ལ་ག་སི་ཁ" },
            { "mi", "མ་ཨོ་རི་ཁ" },
            { "mk", "མ་སེ་ཌོ་ནི་ཡཱན་ཁ" },
            { "ml", "མ་ལ་ཡ་ལམ་ཁ" },
            { "mr", "མ་ར་ཐི་ཁ" },
            { "ms", "མ་ལེ་ཁ" },
            { "mt", "མཱལ་ཊ་ཁ" },
            { "my", "བར་མིས་ཁ" },
            { "nb", "ནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁ" },
            { "ne", "ནེ་པཱལི་ཁ" },
            { "nl", "ཌཆ་ཁ" },
            { "nn", "ནོར་ཝེ་ཇི་ཡཱན་ནོརསཀ་ཁ" },
            { "no", "ནོར་ཝི་ཇི་ཡན་ཁ" },
            { "or", "ཨོ་རི་ཡ་ཁ" },
            { "pa", "པཱན་ཇ་བི་ཁ" },
            { "pl", "པོ་ལིཤ་ཁ" },
            { "ps", "པཱཤ་ཏོ་ཁ" },
            { "pt", "པོར་ཅུ་གིས་ཁ" },
            { "qu", "ཀྭེ་ཆུ་ཨ་ཁ" },
            { "rm", "རོ་མེ་ནིཤ་ཁ" },
            { "ro", "རོ་མེ་ནི་ཡཱན་ཁ" },
            { "ru", "ཨུ་རུ་སུའི་ཁ" },
            { "sa", "སཾསྐྲྀཏ་ཁ" },
            { "sd", "སིན་དཱི་ཁ" },
            { "si", "སིང་ཧ་ལ་ཁ" },
            { "sk", "སུ་ལོ་བཱཀ་ཁ" },
            { "sl", "སུ་ལོ་བི་ནི་ཡཱན་ཁ" },
            { "so", "སོ་མ་ལི་ཁ" },
            { "sq", "ཨཱལ་བེ་ནི་ཡཱན་ཁ" },
            { "sr", "སཱར་བྷི་ཡཱན་ཁ" },
            { "su", "སཱུན་ད་ནིས་ཁ" },
            { "sv", "སུའི་ཌིཤ་ཁ" },
            { "sw", "སྭཱ་ཧི་ལི་ཁ" },
            { "ta", "ཏ་མིལ་ཁ" },
            { "te", "ཏེ་ལུ་གུ་ཁ" },
            { "tg", "ཏ་ཇིཀ་ཁ" },
            { "th", "ཐཱའི་ཁ" },
            { "ti", "ཏིག་རི་ཉ་ཁ" },
            { "tk", "ཊཱརཀ་མེན་ཁ" },
            { "to", "ཊོང་གྷན་ཁ" },
            { "tr", "ཊཱར་ཀིཤ་ཁ" },
            { "tt", "ཊ་ཊར་ཁ" },
            { "ug", "ཝི་གུར་ཁ" },
            { "uk", "ཡུ་ཀེ་རེ་ནི་ཡཱན་ཁ" },
            { "ur", "ཨུར་དུ་ཁ" },
            { "uz", "ཨུས་བེཀ་ཁ" },
            { "vi", "བེཊ་ནཱ་མིས་ཁ" },
            { "wo", "ཝོ་ལོཕ་ཁ" },
            { "xh", "ཞོ་ས་ཁ" },
            { "yo", "ཡོ་རུ་བ་ཁ" },
            { "zh", "རྒྱ་མི་ཁ" },
            { "zu", "ཟུ་ལུ་ཁ" },
            { "dak", "ད་ཀོ་ཏ་ཁ" },
            { "fil", "ཕི་ལི་པི་ནོ་ཁ" },
            { "gsw", "སུ་ཡིས་ཇཱར་མཱན་ཁ" },
            { "haw", "ཧ་ཝ་ཡིའི་ཁ" },
            { "kac", "ཀ་ཆིན་ཁ" },
            { "kfo", "ཀོ་རོ་ཁ" },
            { "mnc", "མན་ཇུ་ཁ" },
            { "shn", "ཤཱན་ཁ" },
            { "und", "ཁ་ངོ་མ་ཤེསཔ" },
            { "zxx", "སྐད་རིག་ནང་དོན་མེདཔ" },
            { "Arab", "ཨེ་ར་བིཀ་ཡིག་གུ" },
            { "Armn", "ཨར་མི་ནི་ཡཱན་ཡིག་གུ" },
            { "Beng", "བངྒ་ལ་ཡིག་གུ" },
            { "Bopo", "བོ་པོ་མོ་ཕཱོ་ཡིག་གུ" },
            { "Brai", "འབུར་ཡིག" },
            { "Cyrl", "སིརིལ་ལིཀ་ཡིག་གུ" },
            { "Deva", "དེ་ཝ་ན་ག་རི་ཡིག་གུ" },
            { "Ethi", "ཨི་ཐི་ཡོ་པིཀ྄་ཡིག་གུ" },
            { "Geor", "ཇཽ་ཇི་ཡཱན་ཡིག་གུ" },
            { "Grek", "གྲིཀ་ཡིག་གུ" },
            { "Gujr", "གུ་ཇ་ར་ཏི་ཡིག་གུ" },
            { "Guru", "གུ་རུ་མུ་ཁ་ཡིག་གུ" },
            { "Hang", "ཧཱན་གུལ་ཡིག་གུ" },
            { "Hani", "རྒྱ་ནག་ཡིག་གུ" },
            { "Hans", "རྒྱ་ཡིག་ ལུགས་གསར་" },
            { "Hant", "ལུགས་རྙིང་ རྒྱ་ཡིག" },
            { "Hebr", "ཧེ་བྲུ་ཡིག་གུ" },
            { "Hira", "ཇ་པཱན་གྱི་ཧི་ར་ག་ན་ཡིག་གུ" },
            { "Jpan", "ཇ་པཱན་ཡིག་གུ" },
            { "Kana", "ཇ་པཱན་གྱི་ཀ་ཏ་ཀ་ན་ཡིག་གུ" },
            { "Khmr", "ཁེ་མེར་ཡིག་གུ" },
            { "Knda", "ཀ་ན་ཌ་ཡིག་གུ" },
            { "Kore", "ཀོ་རི་ཡཱན་ཡིག་གུ" },
            { "Laoo", "ལའོ་ཡིག་གུ" },
            { "Latn", "ལེ་ཊིན་ཡིག་གུ" },
            { "Mlym", "མ་ལ་ཡ་ལམ་ཡིག་གུ" },
            { "Mong", "སོག་པོའི་ཡིག་གུ" },
            { "Mymr", "བར་མིས་ཡིག་གུ" },
            { "Orya", "ཨོ་རི་ཡ་ཡིག་གུ" },
            { "Sinh", "སིན་ཧ་ལ་རིག་གུ" },
            { "Taml", "ཏ་མིལ་ཡིག་གུ" },
            { "Telu", "ཏེ་ལུ་གུ་ཡིག་གུ" },
            { "Thaa", "ཐཱ་ན་ཡིག་གུ" },
            { "Thai", "ཐཱའི་ཡིག་གུ" },
            { "Tibt", "ང་བཅས་ཀྱི་ཡིག་གུ" },
            { "Zsym", "མཚན་རྟགས" },
            { "Zxxx", "ཡིག་ཐོག་མ་བཀོདཔ" },
            { "Zyyy", "སྤྱིཡིག" },
            { "Zzzz", "ངོ་མ་ཤེས་པའི་ཡི་གུ" },
            { "de_AT", "ཨཱོས་ཊྲི་ཡཱན་ཇཱར་མཱན་ཁ" },
            { "de_CH", "སུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁ" },
            { "en_AU", "ཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁ" },
            { "en_CA", "ཀེ་ན་ཌི་ཡཱན་ཨིང་ལིཤ་ཁ" },
            { "en_GB", "བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ" },
            { "en_US", "ཡུ་ཨེས་ཨིང་ལིཤ་ཁ" },
            { "es_ES", "ཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁ" },
            { "fr_CA", "ཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁ" },
            { "fr_CH", "སུ་ཡིས་ཕྲནཅ་ཁ" },
            { "nl_BE", "ཕྷེལེ་མིཤ་ཁ" },
            { "pt_BR", "བྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁ" },
            { "pt_PT", "ཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་ཁ" },
            { "es_419", "ལེ་ཊིན་ཨ་མེ་རི་ཀཱན་གི་ཨིས་པེ་ནིཤ་ཁ" },
            { "key.ca", "ཟླ་ཐོ" },
            { "key.co", "གནས་སདུད་རིམ་ སགྲིག" },
            { "key.cu", "ཤོག་དངུལ" },
            { "key.nu", "ཨང་ཡིག" },
            { "zh_Hans", "རྒྱ་མི་ཁ་འཇམ་སངམ" },
            { "zh_Hant", "སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ" },
            { "type.nu.arab", "ཨེ་ར་བིཀ་-ཨིན་ཌིཀ་ཨང" },
            { "type.nu.armn", "ཨར་མི་ནི་ཡཱན་ཨང" },
            { "type.nu.beng", "བངྒ་ལི་ཨང" },
            { "type.nu.deva", "དེ་ཝ་ན་ག་རི་ཨང" },
            { "type.nu.ethi", "ཨི་ཐི་ཡོ་པིཀ་ཨང་རྟགཨ" },
            { "type.nu.geor", "ཇཽར་ཇཱི་ཡཱན་ཨང་རྟགས" },
            { "type.nu.grek", "གྲིཀ་ཨང་རྟགས" },
            { "type.nu.gujr", "གུ་ཇ་ར་ཏི་ཨང" },
            { "type.nu.guru", "གུ་རུ་མུ་ཁི་ཨང" },
            { "type.nu.hans", "འཇམ་སངམ་རྒྱ་མིའི་ཨང་རྟགས" },
            { "type.nu.hant", "སྔ་དུས་རྒྱ་མིའི་ཨང་རྟགས" },
            { "type.nu.hebr", "ཧེ་བྲུ་ཨང་རྟགས" },
            { "type.nu.jpan", "ཇཱ་པཱན་ནིས་ཨང་རྟགས" },
            { "type.nu.khmr", "ཁེ་མར་ཨང" },
            { "type.nu.knda", "ཀ་ན་ཌ་ཨང" },
            { "type.nu.laoo", "ལཱ་འོས་ཨང་" },
            { "type.nu.latn", "ཕྱི་གླིང་པའི་ཨང" },
            { "type.nu.mlym", "མ་ལ་ཡ་ལམ་ཨང་" },
            { "type.nu.mymr", "མི་ཡཱན་མར་ཨང་" },
            { "type.nu.orya", "ཨོ་རི་ཡ་ཨང་" },
            { "type.nu.taml", "སྔ་དུས་ཊ་མིལ་ཨང་རྟགས" },
            { "type.nu.telu", "ཏེ་ལུ་གུ་ཨང" },
            { "type.nu.thai", "ཐཱའི་ཨང" },
            { "type.nu.tibt", "ང་བཅས་ཀྱི་ཨང་ཡིག" },
            { "type.co.ducet", "སྔ་སྒྲིག་ཡུ་ནི་ཀོཊ་གི་གོ་རིམ" },
            { "type.nu.roman", "རོ་མཱན་ཨང་རྟགས" },
            { "type.co.search", "སྤྱི་དོན་འཚོལ་བ" },
            { "type.nu.arabext", "ཨེ་ར་བིཀ་-ཨིན་ཌིཀ་རྒྱ་སྐྱེད་ཨང" },
            { "type.nu.armnlow", "ཨར་མི་ནི་ཡཱན་གྱི་མགྱོགས་ཡིག་ཨང་རྟགས" },
            { "type.nu.greklow", "གྲིཀ་གི་མགྱོགས་ཡིག་ཨང་རྟགས" },
            { "type.nu.hanidec", "རྒྱ་མིའི་ཚག་ཅན་མའི་ཨང་རྟགས" },
            { "type.nu.hansfin", "འཇམ་སངམ་རྒྱ་མི་གི་དངུལ་འབྲེལ་ཨང་རྟགས" },
            { "type.nu.hantfin", "སྔ་དུས་རྒྱ་མིའི་གི་དངུལ་འབྲེལ་ཨང་རྟགས" },
            { "type.nu.jpanfin", "ཇཱ་པཱན་ནིས་དངུལ་འབྲེལ་ཨང་རྟགས" },
            { "type.nu.tamldec", "ཊ་མིལ་ཨང" },
            { "type.nu.fullwide", "རྒྱ་ཚད་གང་བའི་ཨང" },
            { "type.nu.romanlow", "རོ་མཱན་གྱི་མགྱོགས་ཡིག་ཨང་རྟགས" },
            { "type.ca.gregorian", "གྲེག་གོ་རི་ཡཱན་ཟླ་ཐོ" },
            { "ListKeyTypePattern", "{0}།: {1}" },
            { "ListCompositionPattern", "{0}་, {1}" },
        };
        return data;
    }
}
