/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_chr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "ᎠᏎᏆᏣᏂ";
        final String metaValue_JP = "ᏣᏩᏂᏏ";
        final String metaValue_KG = "ᎩᎵᏣᎢᏍ";
        final String metaValue_NR = "ᏃᎤᎷ";
        final String metaValue_NP = "ᏁᏆᎵ";
        final String metaValue_SO = "ᏐᎹᎵ";
        final String metaValue_ML = "ᎹᎵ";
        final String metaValue_TV = "ᏚᏩᎷ";
        final String metaValue_hy = "ᎠᎳᎻᎠᏂ";
        final String metaValue_ccp = "ᏣᎧᎹ";
        final String metaValue_chr = "ᏣᎳᎩ";
        final String metaValue_ka = "ᏦᏥᎠᏂ";
        final String metaValue_gu = "ᎫᏣᎳᏘ";
        final String metaValue_km = "ᎩᎻᎷ";
        final String metaValue_kn = "ᎧᎾᏓ";
        final String metaValue_ko = "ᎪᎵᎠᏂ";
        final String metaValue_lo = "ᎳᎣ";
        final String metaValue_la = "ᎳᏘᏂ";
        final String metaValue_ml = "ᎹᎳᏯᎳᎻ";
        final String metaValue_mn = "ᎹᏂᎪᎵᎠᏂ";
        final String metaValue_nqo = "ᎾᎪ";
        final String metaValue_or = "ᎣᏗᎠ";
        final String metaValue_ta = "ᏔᎻᎵ";
        final String metaValue_te = "ᏖᎷᎦ";
        final String metaValue_bo = "ᏘᏇᏔᏂ";
        final String metaValue_vai = "ᏩᏱ";
        final Object[][] data = new Object[][] {
            { "001", "ᎡᎶᎯ" },
            { "002", "ᎬᎿᎨᏍᏛ" },
            { "003", "ᏧᏴᏢ ᎠᎹᏰᏟ" },
            { "005", "ᏧᎦᏃᏮ ᎠᎺᎵᎦ" },
            { "009", "ᎣᏏᏰᏂᎠ" },
            { "011", "ᏭᏕᎵᎬ ᏗᏜ ᎬᎿᎨᏍᏛ" },
            { "013", "ᎠᏰᏟ ᎠᎹᏰᏟ" },
            { "014", "ᏗᎧᎸᎬ ᏗᏜ ᎬᎿᎨᏍᏛ" },
            { "015", "ᏧᏴᏢ ᏗᏜ ᎬᎿᎨᏍᏛ" },
            { "017", "ᎠᏰᏟ ᎬᎿᎨᏍᏛ" },
            { "018", "ᏧᎦᎾᏮ ᏗᏜ ᎬᎿᎨᏍᏛ" },
            { "019", "ᎠᎺᎵᎦᎢ" },
            { "021", "ᏧᏴᏢ ᏗᏜ ᎠᎹᏰᏟ" },
            { "029", "ᎨᏆᏙᏯ" },
            { "030", "ᏗᎧᎸᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ" },
            { "034", "ᏧᎦᎾᏮ ᏗᏜ ᏓᎶᏂᎨᏍᏛ" },
            { "035", "ᏧᎦᎾᏮ ᏗᎧᎸᎬ ᏓᎶᏂᎨᏍᏛ" },
            { "039", "ᏧᎦᎾᏮ ᏗᏜ ᏳᎳᏛ" },
            { "053", "ᎠᏍᏔᎴᏏᎠ" },
            { "054", "ᎺᎳᏁᏏᎠ" },
            { "057", "ᎠᏰᏟ ᏧᎾᎵᎪᎯ ᎾᎿ ᎹᎢᏉᏂᏏᏯ ᎢᎬᎾᏕᎾ" },
            { "061", "ᏆᎵᏂᏏᎠ" },
            { "142", "ᏓᎶᎾᎨᏍᏛ" },
            { "143", "ᎠᏰᏟ ᏓᎶᏂᎨᏍᏛ" },
            { "145", "ᏭᏕᎵᎬ ᏗᏜ ᏓᎶᏂᎨᏍᏛ" },
            { "150", "ᏳᎳᏛ" },
            { "151", "ᏗᎧᎸᎬ ᏗᏜ ᏳᎳᏛ" },
            { "154", "ᏧᏴᏢ ᏗᏜ ᏳᎳᏛ" },
            { "155", "ᏭᏕᎵᎬ ᏗᏜ ᏳᎳᏛ" },
            { "202", "ᎭᏫᏂ-ᏌᎭᏩ ᎬᎿᎨᏍᏛ" },
            { "419", "ᎳᏘᏂ ᎠᎹᏰᏟ" },
            { "AC", "ᎤᎵᏌᎳᏓᏅ ᎤᎦᏚᏛᎢ" },
            { "AD", "ᎠᏂᏙᎳ" },
            { "AE", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎡᎳᏈ ᎢᎹᎵᏘᏏ" },
            { "AF", "ᎠᏫᎨᏂᏍᏖᏂ" },
            { "AG", "ᎤᏪᏘ & ᏆᏊᏓ" },
            { "AI", "ᎠᏂᎩᎳ" },
            { "AL", "ᎠᎵᏇᏂᏯ" },
            { "AM", "ᎠᎵᎻᏂᎠ" },
            { "AO", "ᎠᏂᎪᎳ" },
            { "AQ", "ᏧᏁᏍᏓᎸ" },
            { "AR", "ᎠᏥᏂᏘᏂᎠ" },
            { "AS", "ᎠᎺᎵᎧ ᏌᎼᎠ" },
            { "AT", "ᎠᏍᏟᏯ" },
            { "AU", "ᎡᎳᏗᏜ" },
            { "AW", "ᎠᎷᏆ" },
            { "AX", "ᎣᎴᏅᏓ ᏚᎦᏚᏛᎢ" },
            { "AZ", metaValue_AZ },
            { "BA", "ᏉᏏᏂᎠ & ᎲᏤᎪᏫᎾ" },
            { "BB", "ᏆᏇᏙᏍ" },
            { "BD", "ᏆᏂᎦᎵᏕᏍ" },
            { "BE", "ᏇᎵᏥᎥᎻ" },
            { "BF", "ᏋᎩᎾ ᏩᏐ" },
            { "BG", "ᏊᎵᎨᎵᎠ" },
            { "BH", "ᏆᎭᎴᎢᏂ" },
            { "BI", "ᏋᎷᏂᏗ" },
            { "BJ", "ᏆᏂᎢᏂ" },
            { "BL", "ᎤᏓᏅᏘ ᏆᏕᎳᎻ" },
            { "BM", "ᏆᏊᏓ" },
            { "BN", "ᏊᎾᎢ" },
            { "BO", "ᏉᎵᏫᎠ" },
            { "BQ", "ᎧᎵᏈᎢᏂᎯ ᎾᏍᎩᏁᏛᎳᏂ" },
            { "BR", "ᏆᏏᎵ" },
            { "BS", "ᎾᏍᎩ ᏆᎭᎹᏍ" },
            { "BT", "ᏊᏔᏂ" },
            { "BV", "ᏊᏪ ᎤᎦᏚᏛᎢ" },
            { "BW", "ᏆᏣᏩᎾ" },
            { "BY", "ᏇᎳᎷᏍ" },
            { "BZ", "ᏇᎵᏍ" },
            { "CA", "ᎨᎾᏓ" },
            { "CC", "ᎪᎪᏍ (ᎩᎵᏂ) ᏚᎦᏚᏛᎢ" },
            { "CD", "ᎧᏂᎪ - ᎨᏂᏝᏌ" },
            { "CF", "ᎬᎿᎨᏍᏛ ᎠᏰᏟ ᏍᎦᏚᎩ" },
            { "CG", "ᎧᏂᎪ - ᏆᏌᏩᎵ" },
            { "CH", "ᏍᏫᏍ" },
            { "CI", "ᎢᏬᎵ ᎾᎿ ᎠᎹᏳᎶᏗ" },
            { "CK", "ᎠᏓᏍᏓᏴᎲᏍᎩ ᏚᎦᏚᏛᎢ" },
            { "CL", "ᏥᎵ" },
            { "CM", "ᎧᎹᎷᏂ" },
            { "CN", "ᏓᎶᏂᎨᏍᏛ" },
            { "CO", "ᎪᎸᎻᏈᎢᎠ" },
            { "CP", "ᎦᏂᏴᏔᏅᎣᏓᎸ ᎤᎦᏚᏛᎢ" },
            { "CR", "ᎪᏍᏓ ᎵᎧ" },
            { "CU", "ᎫᏆ" },
            { "CV", "ᎢᎬᎾᏕᎾ ᎢᏤᏳᏍᏗ" },
            { "CW", "ᎫᎳᎨᎣ" },
            { "CX", "ᏓᏂᏍᏓᏲᎯᎲ ᎤᎦᏚᏛᎢ" },
            { "CY", "ᏌᎢᏆᏍ" },
            { "CZ", "ᏤᎩᎠ" },
            { "DE", "ᎠᏂᏛᏥ" },
            { "DG", "ᏗᏰᎪ ᎦᏏᏯ" },
            { "DJ", "ᏥᏊᏗ" },
            { "DK", "ᏗᏂᎹᎦ" },
            { "DM", "ᏙᎻᏂᎧ" },
            { "DO", "ᏙᎻᏂᎧᏂ ᏍᎦᏚᎩ" },
            { "DZ", "ᎠᎵᏥᎵᏯ" },
            { "EA", "ᏑᏔ ᎠᎴ ᎺᎵᏯ" },
            { "EC", "ᎡᏆᏙᎵ" },
            { "EE", "ᎡᏍᏙᏂᏯ" },
            { "EG", "ᎢᏥᏈᎢ" },
            { "EH", "ᏭᏕᎵᎬ ᏗᏜ ᏌᎮᎳ" },
            { "ER", "ᎡᎵᏟᏯ" },
            { "ES", "ᎠᏂᏍᏆᏂᏱ" },
            { "ET", "ᎢᏗᎣᏈᎠ" },
            { "EU", "ᏳᎳᏛ ᎠᏂᎤᎾᏓᏡᎬ" },
            { "EZ", "ᏳᎶᎠᏍᏓᏅᏅ" },
            { "FI", "ᏫᏂᎦᏙᎯ" },
            { "FJ", "ᏫᏥ" },
            { "FK", "ᏩᎩ ᏚᎦᏚᏛᎢ" },
            { "FM", "ᎹᎢᏉᏂᏏᏯ" },
            { "FO", "ᏪᎶ ᏚᎦᏚᏛᎢ" },
            { "FR", "ᎦᎸᏥᏱ" },
            { "GA", "ᎦᏉᏂ" },
            { "GB", "ᎩᎵᏏᏲ" },
            { "GD", "ᏋᎾᏓ" },
            { "GE", "ᏣᎠᏥᎢ" },
            { "GF", "ᎠᏂᎦᎸᏥ ᎩᎠ" },
            { "GG", "ᎬᏂᏏ" },
            { "GH", "ᎦᎠᎾ" },
            { "GI", "ᏥᏆᎵᏓ" },
            { "GL", "ᎢᏤᏍᏛᏱ" },
            { "GM", "ᎦᎹᏈᎢᎠ" },
            { "GN", "ᎩᎢᏂ" },
            { "GP", "ᏩᏓᎷᏇ" },
            { "GQ", "ᎡᏆᏙᎵᎠᎵ ᎩᎢᏂ" },
            { "GR", "ᎪᎢᎯ" },
            { "GS", "ᏧᎦᏃᏮ ᏣᎠᏥᎢ ᎠᎴ ᎾᏍᎩ ᏧᎦᏃᏮ ᎠᏍᏛᎭᏟ ᏚᎦᏚᏛᎢ" },
            { "GT", "ᏩᏔᎹᎳ" },
            { "GU", "ᏆᎻ" },
            { "GW", "ᎩᎢᏂ-ᏈᏌᎤᏫ" },
            { "GY", "ᎦᏯᎾ" },
            { "HK", "ᎰᏂᎩ ᎪᏂᎩ ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ ᏓᎶᏂᎨᏍᏛ" },
            { "HM", "ᎲᏗ ᎤᎦᏚᏛᎢ ᎠᎴ ᎺᎩᏓᎾᎵᏗ ᏚᎦᏚᏛᎢ" },
            { "HN", "ᎭᏂᏚᎳᏍ" },
            { "HR", "ᎧᎶᎡᏏᎠ" },
            { "HT", "ᎮᎢᏘ" },
            { "HU", "ᎲᏂᎦᎵ" },
            { "IC", "ᏥᏍᏆ ᏚᎦᏚᏛᎢ" },
            { "ID", "ᎢᏂᏙᏂᏍᏯ" },
            { "IE", "ᎠᏲᎳᏂ" },
            { "IL", "ᎢᏏᎵᏱ" },
            { "IM", "ᎤᏍᏗ ᎤᎦᏚᏛᎢ ᎾᎿ ᎠᏍᎦᏯ" },
            { "IN", "ᎢᏅᏗᎾ" },
            { "IO", "ᏈᏗᏏ ᏴᏫᏯ ᎠᎺᏉ ᎢᎬᎾᏕᏅ" },
            { "IQ", "ᎢᎳᎩ" },
            { "IR", "ᎢᎴᏂ" },
            { "IS", "ᏧᏁᏍᏓᎸᎯ" },
            { "IT", "ᎢᏔᎵ" },
            { "JE", "ᏨᎵᏏ" },
            { "JM", "ᏣᎺᎢᎧ" },
            { "JO", "ᏦᏓᏂ" },
            { "JP", metaValue_JP },
            { "KE", "ᎨᏂᏯ" },
            { "KG", metaValue_KG },
            { "KH", "ᎧᎹᏉᏗᎠᏂ" },
            { "KI", "ᎧᎵᏆᏘ" },
            { "KM", "ᎪᎼᎳᏍ" },
            { "KN", "ᎤᏓᏅᏘ ᎨᏘᏏ ᎠᎴ ᏁᏪᏏ" },
            { "KP", "ᏧᏴᏢ ᎪᎵᎠ" },
            { "KR", "ᏧᎦᏃᏮ ᎪᎵᎠ" },
            { "KW", "ᎫᏪᎢᏘ" },
            { "KY", "ᎨᎢᎹᏂ ᏚᎦᏚᏛᎢ" },
            { "KZ", "ᎧᏎᎧᏍᏕᏂ" },
            { "LA", "ᎴᎣᏍ" },
            { "LB", "ᎴᏆᎾᏂ" },
            { "LC", "ᎤᏓᏅᏘ ᎷᏏᏯ" },
            { "LI", "ᎵᎦᏗᏂᏍᏓᏂ" },
            { "LK", "ᏍᎵ ᎳᏂᎧ" },
            { "LR", "ᎳᏈᎵᏯ" },
            { "LS", "ᎴᏐᏙ" },
            { "LT", "ᎵᏗᏪᏂᎠ" },
            { "LU", "ᎸᎧᏎᏋᎩ" },
            { "LV", "ᎳᏘᏫᎠ" },
            { "LY", "ᎵᏈᏯ" },
            { "MA", "ᎼᎶᎪ" },
            { "MC", "ᎹᎾᎪ" },
            { "MD", "ᎹᎵᏙᏫᎠ" },
            { "ME", "ᎼᏂᏔᏁᎦᎶ" },
            { "MF", "ᎤᏓᏅᏘ ᏡᏡ" },
            { "MG", "ᎹᏓᎦᏍᎧᎵ" },
            { "MH", "ᎹᏌᎵ ᏚᎦᏚᏛᎢ" },
            { "MK", "ᏧᏴᏜ ᎹᏎᏙᏂᏯ" },
            { "ML", metaValue_ML },
            { "MM", "ᎹᏯᎹᎵ (ᏇᎵᎹ)" },
            { "MN", "ᎹᏂᎪᎵᎠ" },
            { "MO", "ᎹᎧᎣ (ᎤᏓᏤᎵᏓ ᏧᏂᎸᏫᏍᏓᏁᏗ ᎢᎬᎾᏕᎾ) ᏣᎢ" },
            { "MP", "ᏧᏴᏢ ᏗᏜ ᎹᎵᎠᎾ ᏚᎦᏚᏛᎢ" },
            { "MQ", "ᎹᏘᏂᎨ" },
            { "MR", "ᎹᏘᎢᏯ" },
            { "MS", "ᎹᏂᏘᏌᎳᏗ" },
            { "MT", "ᎹᎵᏔ" },
            { "MU", "ᎼᎵᏏᎥᏍ" },
            { "MV", "ᎹᎵᏗᏫᏍ" },
            { "MW", "ᎹᎳᏫ" },
            { "MX", "ᎠᏂᏍᏆᏂ" },
            { "MY", "ᎹᎴᏏᎢᎠ" },
            { "MZ", "ᎼᏎᎻᏇᎩ" },
            { "NA", "ᎾᎻᏈᎢᏯ" },
            { "NC", "ᎢᏤ ᎧᎵᏙᏂᎠᏂ" },
            { "NE", "ᎾᎢᏨ" },
            { "NF", "ᏃᎵᏬᎵᎩ ᎤᎦᏚᏛᎢ" },
            { "NG", "ᏂᏥᎵᏯ" },
            { "NI", "ᏂᎧᎳᏆ" },
            { "NL", "ᏁᏛᎳᏂ" },
            { "NO", "ᏃᏪ" },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "ᏂᏳ" },
            { "NZ", "ᎢᏤ ᏏᎢᎴᏂᏗ" },
            { "OM", "ᎣᎺᏂ" },
            { "PA", "ᏆᎾᎹ" },
            { "PE", "ᏇᎷ" },
            { "PF", "ᎠᏂᎦᎸᏥ ᏆᎵᏂᏏᎠ" },
            { "PG", "ᏆᏇ ᎢᏤ ᎩᎢᏂ" },
            { "PH", "ᎠᏂᏈᎵᎩᏃ" },
            { "PK", "ᏆᎩᏍᏖᏂ" },
            { "PL", "ᏉᎳᏂ" },
            { "PM", "ᎤᏓᏅᏘ ᏈᏰ ᎠᎴ ᎻᏇᎶᏂ" },
            { "PN", "ᏈᎧᎵᏂ ᏚᎦᏚᏛᎢ" },
            { "PR", "ᏇᎡᏙ ᎵᎢᎪ" },
            { "PS", "ᏆᎴᏍᏗᏂᎠᏂ ᏄᎬᏫᏳᏌᏕᎩ" },
            { "PT", "ᏉᏥᎦᎳ" },
            { "PW", "ᏆᎴᎠᏫ" },
            { "PY", "ᏆᎳᏇᎢᏯ" },
            { "QA", "ᎧᏔᎵ" },
            { "QO", "ᎠᏍᏛ ᎣᏏᏰᏂᎠ" },
            { "RE", "ᎴᏳᏂᎠᏂ" },
            { "RO", "ᎶᎹᏂᏯ" },
            { "RS", "ᏒᏈᏯ" },
            { "RU", "ᏲᏂᎢ" },
            { "RW", "ᎶᏩᏂᏓ" },
            { "SA", "ᏌᎤᏗ ᎡᎴᏈᎠ" },
            { "SB", "ᏐᎶᎹᏂ ᏚᎦᏚᏛᎢ" },
            { "SC", "ᏏᎡᏥᎵᏍ" },
            { "SD", "ᏑᏕᏂ" },
            { "SE", "ᏍᏫᏕᏂ" },
            { "SG", "ᏏᏂᎦᏉᎵ" },
            { "SH", "ᎤᏓᏅᏘ ᎮᎵᎾ" },
            { "SI", "ᏍᎶᏫᏂᎠ" },
            { "SJ", "ᏍᏩᎵᏆᎵᏗ ᎠᎴ ᏤᏂ ᎹᏰᏂ" },
            { "SK", "ᏍᎶᏩᎩᎠ" },
            { "SL", "ᏏᎡᎳ ᎴᎣᏂ" },
            { "SM", "ᎤᏓᏅᏘ ᎹᎵᎢᏃ" },
            { "SN", "ᏏᏂᎦᎵ" },
            { "SO", metaValue_SO },
            { "SR", "ᏒᎵᎾᎻ" },
            { "SS", "ᏧᎦᎾᏮ ᏑᏕᏂ" },
            { "ST", "ᏌᎣ ᏙᎺ ᎠᎴ ᏈᏂᏏᏇ" },
            { "SV", "ᎡᎵᏌᎵᏆᏙᎵ" },
            { "SX", "ᏏᏂᏘ ᎹᏘᏂ" },
            { "SY", "ᏏᎵᎠ" },
            { "SZ", "ᎡᏍᏩᏘᏂ" },
            { "TA", "ᏟᏍᏛᏂ Ꮣ ᎫᎾᎭ" },
            { "TC", "ᎠᏂᏛᎵᎩ ᎠᎴ ᎨᎢᎪ ᏚᎦᏚᏛᎢ" },
            { "TD", "ᏣᏗ" },
            { "TF", "ᎠᏂᎦᎸᏥ ᏧᎦᎾᏮ ᎦᏙᎯ ᎤᎵᏍᏛᎢ" },
            { "TG", "ᏙᎪ" },
            { "TH", "ᏔᏯᎴᏂ" },
            { "TJ", "ᏔᏥᎩᏍᏕᏂ" },
            { "TK", "ᏙᎨᎳᏭ" },
            { "TL", "ᏘᎼᎵ-ᎴᏍᏖ" },
            { "TM", "ᏛᎵᎩᎺᏂᏍᏔᏂ" },
            { "TN", "ᏚᏂᏏᏍᎠ" },
            { "TO", "ᏙᎾᎦ" },
            { "TR", "ᎬᏃ" },
            { "TT", "ᏟᏂᏕᏗ ᎠᎴ ᏙᏆᎪ" },
            { "TV", metaValue_TV },
            { "TW", "ᏔᎢᏩᏂ" },
            { "TZ", "ᏖᏂᏏᏂᏯ" },
            { "UA", "ᏳᎧᎴᏂ" },
            { "UG", "ᏳᎦᏂᏓ" },
            { "UM", "U.S. ᎠᏍᏛ ᏚᎦᏚᏛᎢ" },
            { "UN", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᎠᏰᎵ ᏚᎾᏙᏢᏒ" },
            { "US", "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ" },
            { "UY", "ᏳᎷᏇ" },
            { "UZ", "ᎤᏍᏇᎩᏍᏖᏂ" },
            { "VA", "ᎠᏥᎳᏁᏠ ᎦᏚᎲ" },
            { "VC", "ᎤᏓᏅᏘ ᏫᏂᏏᏂᏗ ᎠᎴ ᎾᏍᎩ ᏇᎾᏗᏁᏍ" },
            { "VE", "ᏪᏁᏑᏪᎳ" },
            { "VG", "ᏈᏗᏍ ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ" },
            { "VI", "U.S. ᎠᏒᏂᎸ ᏂᎨᏒᎾ ᏚᎦᏚᏛᎢ" },
            { "VN", "ᏫᎡᏘᎾᎻ" },
            { "VU", "ᏩᏂᎤᏩᏚ" },
            { "WF", "ᏩᎵᏍ ᎠᎴ ᏊᏚᎾ" },
            { "WS", "ᏌᎼᎠ" },
            { "XA", "ᏡᏙ-ᏄᏍᏛᎢᎥᎧᏁᎬᎢ" },
            { "XB", "ᏡᏙ-ᏈᏗ" },
            { "XK", "ᎪᏐᏉ" },
            { "YE", "ᏰᎺᏂ" },
            { "YT", "ᎺᏯᏖ" },
            { "ZA", "ᏧᎦᎾᏮ ᎬᎿᎨᏍᏛ" },
            { "ZM", "ᏌᎻᏈᏯ" },
            { "ZW", "ᏏᎻᏆᏇ" },
            { "ZZ", "ᏄᏬᎵᏍᏛᎾ ᎤᏔᏂᏗᎦᏙᎯ" },
            { "aa", "ᎠᏩᎳ" },
            { "ab", "ᎠᏆᏏᎠᏂ" },
            { "af", "ᎠᎬᎿᎨᏍᏛ" },
            { "ak", "ᎠᎧᎾ" },
            { "am", "ᎠᎹᎭᎵᎩ" },
            { "an", "ᎠᏩᎪᏂᏏ" },
            { "ar", "ᎡᎳᏈ" },
            { "as", "ᎠᏌᎻᏏ" },
            { "av", "ᎠᏩᎵᎧ" },
            { "ay", "ᎠᏱᎹᎳ" },
            { "az", metaValue_AZ },
            { "ba", "ᏆᏍᎯᎩᎠ" },
            { "be", "ᏇᎳᎷᏏ" },
            { "bg", "ᏊᎵᎨᎵᎠᏂ" },
            { "bi", "ᏈᏍᎳᎹ" },
            { "bm", "ᏆᎻᏆᎳ" },
            { "bn", "ᏇᏂᎦᎳ" },
            { "bo", metaValue_bo },
            { "br", "ᏇᏙᏂ" },
            { "bs", "ᏆᏍᏂᎠᏂ" },
            { "ca", "ᎨᏔᎳᏂ" },
            { "ce", "ᏤᏤᏂ" },
            { "ch", "ᏣᎼᎶ" },
            { "co", "ᎪᎵᏍᎢᎧᏂ" },
            { "cs", "ᏤᎩ" },
            { "cu", "ᏧᏂᎳᏫᏍᏗ ᏍᎳᏫᎪ" },
            { "cv", "ᏧᏩᏏ" },
            { "cy", "ᏪᎵᏏ" },
            { "da", "ᏕᏂᏍ" },
            { "de", "ᏙᎢᏥ" },
            { "dv", "ᏗᏪᎯ" },
            { "dz", "ᏓᏐᏅᎧ" },
            { "ee", "ᎡᏪ" },
            { "el", "ᎠᏂᎪᎢ" },
            { "en", "ᎩᎵᏏ" },
            { "eo", "ᎡᏍᏇᎳᏂᏙ" },
            { "es", "ᏍᏆᏂ" },
            { "et", "ᎡᏍᏙᏂᎠᏂ" },
            { "eu", "ᏆᏍᎨ" },
            { "fa", "ᏇᏏᎠᏂ" },
            { "ff", "ᏊᎳᏂ" },
            { "fi", "ᏈᏂᏍ" },
            { "fj", "ᏫᏥᎠᏂ" },
            { "fo", "ᏇᎶᎡᏍ" },
            { "fr", "ᎦᎸᏥ" },
            { "fy", "ᏭᏕᎵᎬ ᏗᏜ ᏟᏏᎠᏂ" },
            { "ga", "ᎨᎵᎩ" },
            { "gd", "ᏍᎦᏗ ᎨᎵᎩ" },
            { "gl", "ᎦᎵᏏᎠᏂ" },
            { "gn", "ᏆᎳᏂ" },
            { "gu", metaValue_gu },
            { "gv", "ᎹᎾᎧᏏ" },
            { "ha", "ᎭᎤᏌ" },
            { "he", "ᎠᏂᏈᎷ" },
            { "hi", "ᎯᏂᏗ" },
            { "hr", "ᎧᎶᎡᏏᏂ" },
            { "ht", "ᎮᏏᎠᏂ ᏟᏲᎵ" },
            { "hu", "ᎲᏂᎦᎵᎠᏂ" },
            { "hy", metaValue_hy },
            { "hz", "ᎮᎴᎶ" },
            { "ia", "ᎠᏰᏟ ᎦᏬᏂᎯᏍᏗ" },
            { "id", "ᎢᏂᏙᏂᏏᎠ" },
            { "ie", "ᏈᏖᎵᏆ" },
            { "ig", "ᎢᎦᎪ" },
            { "ii", "ᏏᏧᏩᏂ Ᏹ" },
            { "io", "ᎢᏙ" },
            { "is", "ᏧᏁᏍᏓᎸᎯᎢᎩ" },
            { "it", "ᎬᏩᎵᏲᏥᎢ" },
            { "iu", "ᎢᏄᎦᏘᏚ" },
            { "ja", metaValue_JP },
            { "jv", "ᏆᏌ ᏣᏩ" },
            { "ka", metaValue_ka },
            { "ki", "ᎩᎫᏳ" },
            { "kj", "ᎫᏩᏂᎠᎹ" },
            { "kk", "ᎧᏌᎧ" },
            { "kl", "ᎧᎳᎵᏑᏘ" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "ᎧᏄᎵ" },
            { "ks", "ᎧᏏᎻᎵ" },
            { "ku", "ᎫᏗᏏ" },
            { "kv", "ᎪᎻ" },
            { "kw", "ᏎᎷᎭ" },
            { "ky", metaValue_KG },
            { "la", metaValue_la },
            { "lb", "ᎸᎦᏏᎻᏋᎢᏍ" },
            { "lg", "ᎦᏂᏓ" },
            { "li", "ᎴᎹᏊᎵᏏ" },
            { "ln", "ᎵᏂᎦᎳ" },
            { "lo", metaValue_lo },
            { "lt", "ᎵᏚᏩᏂᎠᏂ" },
            { "lu", "ᎷᏆ-ᎧᏔᎦ" },
            { "lv", "ᎳᏘᏫᎠᏂ" },
            { "mg", "ᎹᎳᎦᏏ" },
            { "mh", "ᎹᏌᎵᏏ" },
            { "mi", "ᎹᏫ" },
            { "mk", "ᎹᏎᏙᏂᎠᏂ" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "ᎹᎳᏘ" },
            { "ms", "ᎹᎴ" },
            { "mt", "ᎹᎵᏘᏍ" },
            { "my", "ᏋᎻᏍ" },
            { "na", metaValue_NR },
            { "nb", "ᏃᎵᏪᏥᏂ ᏉᎧᎹᎵ" },
            { "nd", "ᏧᏴᏢ ᏂᏕᏇᎴ" },
            { "ne", metaValue_NP },
            { "ng", "ᎾᏙᎦ" },
            { "nl", "ᏛᏥ" },
            { "nn", "ᏃᎵᏪᏥᏂ ᎾᎵᏍᎩ" },
            { "no", "ᏃᎵᏪᏥᏂ" },
            { "nr", "ᏧᎦᎾᏮ ᏂᏕᏇᎴ" },
            { "nv", "ᎾᏩᎰ" },
            { "ny", "ᏂᏯᏂᏣ" },
            { "oc", "ᎠᏏᏔᏂ" },
            { "om", "ᎣᎶᎼ" },
            { "or", metaValue_or },
            { "os", "ᎣᏎᏘᎧ" },
            { "pa", "ᏡᏂᏣᏈ" },
            { "pl", "ᏉᎵᏍ" },
            { "ps", "ᏆᏍᏙ" },
            { "pt", "ᏉᏧᎩᏍ" },
            { "qu", "ᎨᏧᏩ" },
            { "rm", "ᎠᏂᎶᎺᏂ" },
            { "rn", "ᎷᏂᏗ" },
            { "ro", "ᎶᎹᏂᎠᏂ" },
            { "ru", "ᏲᏅᎯ" },
            { "rw", "ᎩᏂᏯᏩᏂᏓ" },
            { "sa", "ᏍᏂᏍᎩᏗ" },
            { "sc", "ᏌᏗᏂᎠᏂ" },
            { "sd", "ᏏᏂᏗ" },
            { "se", "ᏧᏴᏢ ᏗᏜ ᏌᎻ" },
            { "sg", "ᏌᏂᎪ" },
            { "si", "ᏏᎾᎭᎳ" },
            { "sk", "ᏍᎶᏩᎩ" },
            { "sl", "ᏍᎶᏫᏂᎠᏂ" },
            { "sm", "ᏌᎼᏯᏂ" },
            { "sn", "ᏠᎾ" },
            { "so", metaValue_SO },
            { "sq", "ᎠᎵᏇᏂ" },
            { "sr", "ᏒᏈᎠᏂ" },
            { "ss", "ᏍᏩᏘ" },
            { "st", "ᏧᎦᎾᏮ ᏗᏜ ᏐᏠ" },
            { "su", "ᏑᏂᏓᏂᏏ" },
            { "sv", "ᏍᏫᏗᏏ" },
            { "sw", "ᏍᏩᎯᎵ" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ᏔᏥᎩ" },
            { "th", "ᏔᏱ" },
            { "ti", "ᏘᎩᎵᏂᎠ" },
            { "tk", "ᎠᏂᎬᎾ" },
            { "tn", "ᏧᏩᎾ" },
            { "to", "ᏙᎾᎦᏂ" },
            { "tr", "ᎠᎬᎾ" },
            { "ts", "ᏦᎾᎦ" },
            { "tt", "ᏔᏔ" },
            { "ty", "ᏔᎯᏘᎠᏂ" },
            { "ug", "ᏫᎦ" },
            { "uk", "ᏳᎧᎴᏂᎠᏂ" },
            { "ur", "ᎤᎵᏚ" },
            { "uz", "ᎤᏍᏇᎩ" },
            { "ve", "ᏫᏂᏓ" },
            { "vi", "ᏫᎡᏘᎾᎻᏍ" },
            { "vo", "ᏬᎳᏊᎩ" },
            { "wa", "ᏩᎷᎾ" },
            { "wo", "ᏬᎶᏫ" },
            { "xh", "ᏠᏌ" },
            { "yi", "ᏱᏗᏍ" },
            { "yo", "ᏲᏄᏆ" },
            { "za", "ᎱᎠᏂ" },
            { "zh", "ᏓᎶᏂᎨ" },
            { "zu", "ᏑᎷ" },
            { "ace", "ᎠᏥᏂᏏ" },
            { "ada", "ᎠᏓᎾᎦᎺ" },
            { "ady", "ᎠᏗᎨ" },
            { "agq", "ᎠᎨᎹ" },
            { "ain", "ᎠᏱᏄ" },
            { "ale", "ᎠᎵᎤᏘ" },
            { "alt", "ᏧᎦᎾᏮ ᏗᏜ ᎠᎵᏔᎢ" },
            { "ann", "ᎣᏉᎶ" },
            { "anp", "ᎠᎾᎩᎧ" },
            { "arn", "ᎹᏊᏤ" },
            { "arp", "ᎠᏩᏈᎰ" },
            { "ars", "ᎾᏣᏗ ᎠᎳᏈ" },
            { "asa", "ᎠᏑ" },
            { "ast", "ᎠᏍᏚᎵᎠᏂ" },
            { "atj", "ᎠᏂᏘᎧᎺᏆ" },
            { "awa", "ᎠᏩᏗ" },
            { "ban", "ᏆᎵᏁᏏ" },
            { "bas", "ᏆᏌᎠ" },
            { "bem", "ᏇᎹᏆ" },
            { "bez", "ᏇᎾ" },
            { "bgc", "ᎭᏯᏅᎢ" },
            { "bho", "ᏉᏣᏊᎵ" },
            { "bin", "ᏈᏂ" },
            { "bla", "ᏏᎩᏏᎧ" },
            { "blo", "ᎠᏂᎵ" },
            { "brx", "ᏉᏙ" },
            { "bug", "ᏈᎥᎩᏂᏍ" },
            { "byn", "ᏟᏂ" },
            { "cay", "ᎧᏳᎦ" },
            { "ccp", metaValue_ccp },
            { "ceb", "ᏎᏆᏃ" },
            { "cgg", "ᏥᎦ" },
            { "chk", "ᏧᎨᏎ" },
            { "chm", metaValue_ML },
            { "cho", "ᎠᏣᏓ" },
            { "chp", "ᎠᏥᏇᏯᏂ" },
            { "chr", metaValue_chr },
            { "chy", "ᏣᏰᏂ" },
            { "ckb", "ᎠᏰᏟ ᎫᏗᏏ" },
            { "clc", "ᏥᎸᎪᏘᎾ" },
            { "crg", "ᎻᏥᏩ" },
            { "crj", "ᏧᎦᏃᏮ ᏗᎧᎸᎬ Ꮯ" },
            { "crk", "ᏠᎨᏏ Ꮯ" },
            { "crl", "ᏧᏴᏢ ᏗᎧᎸᎬ Ꮯ" },
            { "crm", "ᎠᏫ ᎡᏆ Ꮯ" },
            { "crr", "ᎠᎵᎦᏂᏈᎠᎾ" },
            { "crs", "ᏎᏎᎵᏩ ᏟᏲᎵ ᎠᏂᎦᎸ" },
            { "csw", "ᏌᎷᏱ Ꮯ" },
            { "dak", "ᏓᎪᏔ" },
            { "dar", "ᏓᎳᏆ" },
            { "dav", "ᏔᎢᏔ" },
            { "dgr", "ᎩᏟ ᎤᏄᎳᏥ" },
            { "dje", "ᏌᎹ" },
            { "doi", "ᏙᎦᎵ" },
            { "dsb", "ᎡᎳᏗ ᏐᏈᎠᏂ" },
            { "dua", "ᏚᎠᎳ" },
            { "dyo", "ᏦᎳ-ᏬᏱ" },
            { "dzg", "ᏓᏌᎦ" },
            { "ebu", "ᎡᎻᏊ" },
            { "efi", "ᎡᏫᎩ" },
            { "eka", "ᎨᎧᏧᎧ" },
            { "ewo", "ᎡᏬᏂᏙ" },
            { "fil", "ᎠᏈᎵᎩ" },
            { "fon", "ᏠᏂ" },
            { "frc", "ᎨᏨᏂ ᎦᎸᏥ" },
            { "frr", "ᏧᏴᏢ ᎷᏈ" },
            { "fur", "ᏞᎤᎵᎠᏂ" },
            { "gaa", "Ꭶ" },
            { "gez", "ᎩᏏ" },
            { "gil", "ᎩᏇᏘᏏ" },
            { "gor", "ᎪᎶᏂᏔᏃ" },
            { "gsw", "ᏍᏫᏏ ᎠᏂᏓᏥ" },
            { "guz", "ᎫᏏ" },
            { "gwi", "ᏈᏥᏂ" },
            { "hai", "ᎭᏱᏓ" },
            { "haw", "ᎭᏩᎼ" },
            { "hax", "ᏧᎦᏃᏮ ᏗᏜ ᎭᏱᏓ" },
            { "hil", "ᎯᎵᎨᎾᏂ" },
            { "hmn", "ᎭᎼᏂᎩ" },
            { "hsb", "ᎦᎸᎳᏗᎨ ᏐᏈᎠᏂ" },
            { "hup", "ᎠᏂᎱᏆ" },
            { "hur", "ᎭᎵᎪᎺᎴᎻ" },
            { "iba", "ᎢᏆᏂ" },
            { "ibb", "ᎢᏈᏈᎣ" },
            { "ikt", "ᏭᏕᎵᎬ ᎨᎾᏓ ᎢᏄᎩᏘᏚᏘ" },
            { "ilo", "ᎢᎶᎪ" },
            { "inh", "ᎢᏂᎫᏏ" },
            { "jbo", "ᎶᏣᏆᏂ" },
            { "jgo", "ᎾᎪᏆ" },
            { "jmc", "ᎹᏣᎺ" },
            { "kab", "ᎧᏈᎴ" },
            { "kac", "ᎧᏥᏂ" },
            { "kaj", "ᏥᏧ" },
            { "kam", "ᎧᎻᏆ" },
            { "kbd", "ᎧᏆᏗᎠᏂ" },
            { "kcg", "ᏔᏯᏆ" },
            { "kde", "ᎹᎪᏕ" },
            { "kea", "ᎧᏊᏪᏗᎠᏄ" },
            { "kfo", "ᎪᎶ" },
            { "kgp", "ᎨᏂᎨᏂ" },
            { "kha", "ᎧᏏ" },
            { "khq", "ᎪᏱᎳ ᏥᏂ" },
            { "kkj", "ᎧᎪ" },
            { "kln", "ᎧᎴᏂᏥᏂ" },
            { "kmb", "ᎩᎻᏊᏚ" },
            { "kok", "ᎧᏂᎧᏂ" },
            { "kpe", "ᏇᎴ" },
            { "krc", "ᎧᎳᏣᏱ-ᏆᎵᎧᎵ" },
            { "krl", "ᎧᎴᎵᎠᏂ" },
            { "kru", "ᎫᎷᎩ" },
            { "ksb", "ᏝᎻᏆᎸ" },
            { "ksf", "ᏆᏫᎠ" },
            { "ksh", "ᎪᎶᏂᎠᏂ" },
            { "kum", "ᎫᎻᎧ" },
            { "kwk", "ᏆᏆᎳ" },
            { "kxv", "ᎫᏈ" },
            { "lad", "ᎳᏗᏃ" },
            { "lag", "ᎳᏂᎩ" },
            { "lez", "ᎴᏏᎦᏂ" },
            { "lij", "ᎵᏇᎢᎠ" },
            { "lil", "ᎵᎶᎡᏘ" },
            { "lkt", "ᎳᎪᏓ" },
            { "lmo", "ᎶᏆᏗ" },
            { "lou", "ᎷᏫᏏᎡᎾ ᎦᏬᏂᎯᏍᏗ" },
            { "loz", "ᎶᏏ" },
            { "lrc", "ᏧᏴᏢ ᏗᏜ ᎷᎵ" },
            { "lsm", "ᏌᎠᎻᎠ" },
            { "lua", "ᎷᏆ-ᎷᎷᎠ" },
            { "lun", "ᎷᎾᏓ" },
            { "luo", "ᎷᎣ" },
            { "lus", "ᎻᏐ" },
            { "luy", "ᎷᏱᎠ" },
            { "mad", "ᎹᏚᎴᏏ" },
            { "mag", "ᎹᎦᎯ" },
            { "mai", "ᎹᏟᎵ" },
            { "mak", "ᎹᎧᏌ" },
            { "mas", "ᎹᏌᏱ" },
            { "mdf", "ᎼᎧᏌ" },
            { "men", "ᎺᎾᏕ" },
            { "mer", "ᎺᎷ" },
            { "mfe", "ᎼᎵᏏᎡᏂ" },
            { "mgh", "ᎹᎫᏩ-ᎻᏙ" },
            { "mgo", "ᎺᎳ’" },
            { "mic", "ᎻᎧᎹᎩ" },
            { "min", "ᎻᎾᎧᏆᎤ" },
            { "mni", "ᎺᏂᏉᎵ" },
            { "moe", "ᎢᏄ-ᎠᏱᏵᏂ" },
            { "moh", "ᎼᎭᎩ" },
            { "mos", "ᎼᏍᏏ" },
            { "mua", "ᎽᏂᏓᎩ" },
            { "mul", "ᏧᏈᏍᏗ ᏗᎦᏬᏂᎯᏍᏗ" },
            { "mus", "ᎠᎫᏌ" },
            { "mwl", "ᎻᎳᏕᏏ" },
            { "myv", "ᎡᏏᏯ" },
            { "mzn", "ᎹᏌᏕᎳᏂ" },
            { "nap", "ᏂᏯᏆᎵᏔᏂ" },
            { "naq", "ᎾᎹ" },
            { "nds", "ᎡᎳᏗ ᎠᏂᏓᏥ" },
            { "new", "ᏁᏩᎵ" },
            { "nia", "ᏂᎠᏏ" },
            { "niu", "ᏂᏳᏫᏯᏂ" },
            { "nmg", "ᏆᏏᏲ" },
            { "nnh", "ᎾᏥᏰᎹᏊᏂ" },
            { "nog", "ᏃᎦᏱ" },
            { "nqo", metaValue_nqo },
            { "nso", "ᏧᏴᏢ ᏗᏜ ᏐᏠ" },
            { "nus", "ᏄᏪᎵ" },
            { "nyn", "ᏂᏯᎾᎪᎴ" },
            { "ojb", "ᏧᏴᏢ ᏭᏕᎵᎬ ᎣᏥᏆ" },
            { "ojc", "ᎠᏰᏟ ᎣᏥᏆ" },
            { "ojs", "ᎣᏥ-Ꮯ" },
            { "ojw", "ᏭᏕᎵᎬ ᏗᏜ ᎣᏥᏆ" },
            { "oka", "ᎣᎧᎾᎦᏂ" },
            { "pag", "ᏇᎦᏏᎠᏂ" },
            { "pam", "ᏆᎹᏆᎾᎦ" },
            { "pap", "ᏆᏈᏯᎺᎾᏙ" },
            { "pau", "ᏆᎳᎤᏩᏂ" },
            { "pcm", "ᎾᎩᎵᎠᏂ ᏈᏥᏂ" },
            { "pis", "ᏈᏥᎾ" },
            { "pqm", "ᎹᎵᏏᏘ-ᏇᏌᎹᏉᏗ" },
            { "prg", "ᏡᏏᎠᏂ" },
            { "quc", "ᎩᏤ" },
            { "raj", "ᎳᏣᏍᎭᏂ" },
            { "rap", "ᎳᏆᏄᏫ" },
            { "rar", "ᎳᎶᏙᎾᎦᏂ" },
            { "rhg", "ᎶᎯᏂᏯ" },
            { "rof", "ᎶᎹᏉ" },
            { "rup", "ᎠᏬᎹᏂᎠᏂ" },
            { "rwk", "Ꮖ" },
            { "sad", "ᏌᏅᏓᏫ" },
            { "sah", "ᏌᎧᎾ" },
            { "saq", "ᏌᎹᏊᎷ" },
            { "sat", "ᏌᏂᏔᎵ" },
            { "sba", "ᎾᎦᎹᏇ" },
            { "sbp", "ᏌᏁᎫ" },
            { "scn", "ᏏᏏᎵᎠᏂ" },
            { "sco", "ᏍᎦᏗ" },
            { "see", "ᏏᏂᎦ" },
            { "seh", "ᏎᎾ" },
            { "ses", "ᎪᏱᎳᏈᎶ ᏎᏂ" },
            { "shi", "ᏔᏤᎵᎯᏘ" },
            { "shn", "ᏝᏂ" },
            { "slh", "ᏧᎦᏃᏮ ᏗᏜ ᎷᏑᏘᏏᏗ" },
            { "sma", "ᏧᎦᎾᏮ ᏗᏜ ᏌᎻ" },
            { "smj", "ᎷᎴ ᏌᎻ" },
            { "smn", "ᎢᎾᎵ ᏌᎻ" },
            { "sms", "ᏍᎪᎵᏘ ᏌᎻ" },
            { "snk", "ᏐᏂᏂᎨ" },
            { "srn", "ᏏᎳᎾᏂ ᏙᏃᎪ" },
            { "ssy", "ᏌᎰ" },
            { "str", "ᏌᎵᏏ" },
            { "suk", "ᏑᎫᎹ" },
            { "swb", "ᎪᎼᎵᎠᏂ" },
            { "syr", "ᏏᎵᎠᎩ" },
            { "szl", "ᏏᎴᏏᏂ" },
            { "tce", "ᏧᎦᏃᏮ ᏚᏦᏁ" },
            { "tem", "ᏘᎹᏁ" },
            { "teo", "ᏖᏐ" },
            { "tet", "ᏖᏚᎼ" },
            { "tgx", "ᏔᎩᏏ" },
            { "tht", "ᏔᏝᎾ" },
            { "tig", "ᏢᏓᏥ" },
            { "tlh", "ᏟᎦᎾ" },
            { "tli", "ᏟᎩᏘ" },
            { "tok", "ᏙᎩ ᏉᎾ" },
            { "tpi", "ᏙᎩ ᏈᏏᏂ" },
            { "trv", "ᏔᎶᎪ" },
            { "ttm", "ᏧᏴᏢ ᏗᏜ ᏚᏦᏁ" },
            { "tum", "ᏛᎹᏊᎧ" },
            { "tvl", metaValue_TV },
            { "twq", "ᏔᏌᏩᎩ" },
            { "tyv", "ᏚᏫᏂᎠᏂ" },
            { "tzm", "ᎠᏰᏟ ᎡᎶᎯ ᏓᏟᎶᏍᏗᏓᏅᎢ ᏔᎹᏏᏘ" },
            { "udm", "ᎤᏚᎷᏘ" },
            { "umb", "ᎤᎹᏊᏅᏚ" },
            { "und", "ᏄᏬᎵᏍᏛᎾ ᎦᏬᏂᎯᏍᏗ" },
            { "vai", metaValue_vai },
            { "vec", "ᏈᏂᏒᏂ" },
            { "vmw", "ᎹᎱᏩ" },
            { "vun", "ᏭᎾᏦ" },
            { "wae", "ᏩᎵᏎᎵ" },
            { "wal", "ᏬᎳᏱᏔ" },
            { "war", "ᏩᎴ" },
            { "wuu", "Ꮽ ᏓᎶᏂᎨᏍᏛ" },
            { "xal", "ᎧᎳᎻᎧ" },
            { "xnr", "ᎧᏈᎢ" },
            { "xog", "ᏐᎦ" },
            { "yav", "ᏰᎾᎦᏇᏂ" },
            { "ybb", "ᏰᎹᏋ" },
            { "yrl", "ᏂᎾᎦᏚ" },
            { "yue", "ᎨᎾᏙᏂᏏ" },
            { "zgh", "ᎠᏟᎶᏍᏗ ᎼᎶᎪ ᏔᎹᏏᏘ" },
            { "zun", "ᏑᏂ" },
            { "zxx", "Ꮭ ᎦᏬᏂᎯᏍᏗ ᎦᎸᏛᎢ ᏱᎩ" },
            { "zza", "ᏌᏌ" },
            { "Adlm", "ᎠᏓᎳᎻ" },
            { "Arab", "ᎡᎳᏈᎩ" },
            { "Aran", "ᎾᏍᏔᎵᏆ" },
            { "Armn", metaValue_hy },
            { "Beng", "ᏇᏂᎦᎠ" },
            { "Bopo", "ᏆᏉᎼᏬ" },
            { "Brai", "ᏗᏂᎨᏫ ᎤᏃᏪᎶᏙᏗ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ᏌᏊ ᎨᎾᏓ ᎠᏂᏴᏫᏯ ᏗᎪᏪᎸ" },
            { "Cher", metaValue_chr },
            { "Cyrl", "ᏲᏂᎢ ᏗᎪᏪᎵ" },
            { "Deva", "ᏕᏫᎾᎦᎵ" },
            { "Ethi", "ᎢᏗᏯᏈᎩ" },
            { "Geor", metaValue_ka },
            { "Grek", "ᎪᎢ" },
            { "Gujr", metaValue_gu },
            { "Guru", "ᎬᎹᎩ" },
            { "Hanb", "ᎭᏂ ᎾᎿ ᏆᏉᎼᏬ" },
            { "Hang", "ᎭᏂᎫᎵ" },
            { "Hani", "ᎭᏂ" },
            { "Hans", "ᎠᎯᏗᎨ" },
            { "Hant", "ᎤᏦᏍᏗ" },
            { "Hebr", "ᎠᏂᏈᎵ" },
            { "Hira", "ᎯᎳᎦᎾ" },
            { "Hrkt", "ᏣᏩᏂᏏ ᏧᏃᏴᎩ" },
            { "Jamo", "ᏣᎼ" },
            { "Jpan", "ᏣᏆᏂᏏ" },
            { "Kana", "ᎧᏔᎧᎾ" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "ᎺᏖ ᎹᏰᎩ" },
            { "Mymr", "ᎹᎡᏂᎹᎳ" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ᎣᎵ ᏥᎩ" },
            { "Orya", metaValue_or },
            { "Rohg", "ᎭᏂᏫ" },
            { "Sinh", "ᏏᏅᎭᎳ" },
            { "Sund", "ᏚᏓᏂᏎ" },
            { "Syrc", "ᏏᎵᎡᎩ" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ᏘᏫᎾᎦ" },
            { "Thaa", "ᏔᎠᎾ" },
            { "Thai", "ᏔᏱ ᏔᏯᎴᏂ" },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Ᏹ" },
            { "Zmth", "ᎠᏰᎦᎴᏴᏫᏍᎩ ᎠᎤᏓᏗᏍᏙᏗ" },
            { "Zsye", "ᎡᎼᏥ" },
            { "Zsym", "ᏗᎬᏟᎶᏍᏙᏗ" },
            { "Zxxx", "ᎪᏪᎳᏅ ᏂᎨᏒᎾ" },
            { "Zyyy", "ᏯᏃᏉ ᏱᎬᏍᏛᏭ" },
            { "Zzzz", "ᏄᏬᎵᏍᏛᎾ ᎠᏍᏓᏩᏛᏍᏙᏗ" },
            { "de_AT", "ᎠᏟᏯᏂ ᎠᏂᏓᏥ" },
            { "de_CH", "ᏍᏫᏏ ᎦᎸᎳᏗ ᎠᏂᏓᏥ" },
            { "en_AU", "ᎡᎳᏗᏜ ᎩᎵᏏ" },
            { "en_CA", "ᎨᎾᏓ ᎩᎵᏏ" },
            { "en_GB", "ᎩᎵᏏᏲ ᎩᎵᏏ" },
            { "en_US", "ᎠᎹᏰᏟ ᎩᎵᏏ" },
            { "es_ES", "ᎠᏂᏍᏆᏂᏱ ᏍᏆᏂ" },
            { "es_MX", "ᏍᏆᏂᏱ ᏍᏆᏂ" },
            { "fa_AF", "ᏓᎵ" },
            { "fr_CA", "ᎨᎾᏓ ᎦᎸᏥ" },
            { "fr_CH", "ᏍᏫᏏ ᎦᎸᏥ" },
            { "nl_BE", "ᏊᎵᏥᎥᎻ ᏛᏥ" },
            { "pt_BR", "ᏆᏏᎵᎢ ᏉᏧᎩᏍ" },
            { "pt_PT", "ᏳᎳᏈ ᏉᏧᎩᏍ" },
            { "ro_MD", "ᎹᎵᏙᏫᎠ ᏣᎹᏂᎠᏂ" },
            { "sw_CD", "ᎧᏂᎪ ᏍᏩᎯᎵ" },
            { "ar_001", "ᎪᎯᏊ ᎢᎬᏥᎩ ᎠᏟᎶᏍᏗ ᎡᎳᏈ" },
            { "es_419", "ᏔᏘᏂ ᎠᎹᏰᏟ ᏍᏆᏂ" },
            { "key.ca", "ᏅᏙ ᏗᏎᏍᏗ" },
            { "key.cf", "ᎠᏕᎳ ᏱᎬᏁᎸᎯ" },
            { "key.co", "ᏗᎦᏅᏃᏙᏗ ᏕᎦᏅᏃᏛᎢ" },
            { "key.cu", "ᎠᏕᎳ" },
            { "key.hc", "ᏑᏟᎶᏓ ᎠᏓᏁᏟᏴᏎᎬ (12 vs 24)" },
            { "key.lb", "ᎠᏍᏓᏅᏅ ᎠᏲᏍᏔᏅᎩ ᏂᏚᏍᏛ" },
            { "key.ms", "ᎠᏟᎶᏛ ᏄᏍᏗᏓᏅᎢ" },
            { "key.nu", "ᏗᏎᏍᏗ" },
            { "nds_NL", "ᎡᎳᏗ ᏁᏛᎳᏂ" },
            { "zh_Hans", "ᎠᎯᏗᎨ ᏓᎶᏂᎨ" },
            { "zh_Hant", "ᎤᏦᏍᏗ ᏓᎶᏂᎨ" },
            { "type.ca.roc", "ᏍᎦᏚᎩ ᎾᎿ ᏓᎶᏂᎨᏍᏛ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.hc.h11", "12 ᎢᏳᏟᎶᏓ ᏄᏍᏗᏓᏅᎢ (0–11)" },
            { "type.hc.h12", "12 ᎢᏳᏟᎶᏓ ᏄᏍᏗᏓᏅᎢ (1–12)" },
            { "type.hc.h23", "24 ᎢᏳᏟᎶᏓ ᏄᏍᏗᏓᏅᎢ (0–23)" },
            { "type.hc.h24", "24 ᎢᏳᏟᎶᏓ ᏄᏍᏗᏓᏅᎢ (1–24)" },
            { "type.nu.arab", "ᎠᎳᏈ-ᎡᏂᏗᎩ ᏗᏎᏍᏗ" },
            { "type.nu.armn", "ᎠᎳᎻᎠᏂ ᏗᏎᏍᏗ" },
            { "type.nu.beng", "ᏇᏂᎦᎳ ᏗᏎᏍᏗ" },
            { "type.nu.cakm", "ᏣᎩᎹ ᏗᏎᏍᏗ" },
            { "type.nu.deva", "ᏕᏫᎾᎦᎵ ᏗᏎᏍᏗ" },
            { "type.nu.ethi", "ᎢᏗᏯᏈᎩ ᏗᏎᏍᏗ" },
            { "type.nu.geor", "ᎩᎴᎪᎵᎠᏂ ᏗᏎᏍᏗ" },
            { "type.nu.grek", "ᎠᏂᎪᎢ ᏗᏎᏍᏗ" },
            { "type.nu.gujr", "ᎫᏣᎳᏘ ᏗᏎᏍᏗ" },
            { "type.nu.guru", "ᎬᎹᎩ ᏗᏎᏍᏗ" },
            { "type.nu.hans", "ᎠᎯᏗᎨ ᏓᎶᏂᎨ ᏗᏎᏍᏗ" },
            { "type.nu.hant", "ᎤᏦᏍᏗ ᏓᎶᏂᎨ ᏗᏎᏍᏗ" },
            { "type.nu.hebr", "ᎠᏂᏈᎷ ᏗᏎᏍᏗ" },
            { "type.nu.java", "ᏣᏩᏂᏎ ᏗᏎᏍᏗ" },
            { "type.nu.jpan", "ᏣᏆᏂᏏ ᏗᏎᏍᏗ" },
            { "type.nu.khmr", "ᎩᎻᎷ ᏗᏎᏍᏗ" },
            { "type.nu.knda", "ᎧᎾᏓ ᏗᏎᏍᏗ" },
            { "type.nu.laoo", "ᎳᎣ ᏗᏎᏍᏗ" },
            { "type.nu.latn", "ᏭᏗᎵᎬ ᏗᏜ ᏗᏎᏍᏗ" },
            { "type.nu.mlym", "ᎹᎳᏯᎳᎻ ᏗᏎᏍᏗ" },
            { "type.nu.mtei", "ᎻᏖ ᎹᏰᎩ ᏗᏎᏍᏗ" },
            { "type.nu.mymr", "ᎹᏯᎹᎵ ᏗᏎᏍᏗ" },
            { "type.nu.olck", "ᎣᎵ ᏥᎩ ᏗᏎᏍᏗ" },
            { "type.nu.orya", "ᎣᏗᎠ ᏗᏎᏍᏗ" },
            { "type.nu.taml", "ᎤᏦᏍᏗ ᏔᎻᎵ ᏗᏎᏍᏗ" },
            { "type.nu.telu", "ᏖᎷᎦ ᏗᏎᏍᏗ" },
            { "type.nu.thai", "ᏔᏱ ᏗᏎᏍᏗ" },
            { "type.nu.tibt", "ᏘᏇᏔᏂ ᏗᏎᏍᏗ" },
            { "type.nu.vaii", "ᏩᏱ ᏗᏎᏍᏗ" },
            { "type.ca.dangi", "ᏓᏂᎩ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.co.ducet", "ᎠᏓᏁᏟᏴᏗᏍᎩ Unicode ᏗᎦᏅᏃᏙᏗ ᏕᎦᏅᏃᏛᎢ" },
            { "type.lb.loose", "ᏩᎾᎢ ᎠᏍᏓᏅᏅ ᎠᏲᏍᏔᏅᎩ ᏂᏚᏍᏛ" },
            { "type.nu.roman", "ᎠᏂᎶᎻ ᏗᏎᏍᏗ" },
            { "type.ca.coptic", "ᎧᏘ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.hebrew", "ᎠᏂᏈᎷ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.co.search", "ᏂᎦᎥ-ᎢᏳᏱᎸᏗ ᎠᏱᏍᏗ" },
            { "type.lb.normal", "ᏱᎬᏍᏗᎭᏊ ᎠᏍᏓᏅᏅ ᎠᏲᏍᏔᏅᎩ ᏂᏚᏍᏛ" },
            { "type.lb.strict", "ᎤᎶᏒᏍᏔᏅᎯ ᎠᏍᏓᏅᏅ ᎠᏲᏍᏔᏅᎩ ᏂᏚᏍᏛ" },
            { "type.ms.metric", "ᎠᏂᎩᎸᏥ ᏂᏓᏳᏓᎴᏅᎯ ᏗᏎᏍᏗ ᏄᏍᏗᏓᏅᎢ" },
            { "type.ca.chinese", "ᏓᎶᏂᎨᏍᏛ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.islamic", "ᎢᏍᎳᎻᎩ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.iso8601", "ISO-8601 ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.persian", "ᏇᏏᎠᏂ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.cf.account", "ᎠᏕᎳ ᏗᏎᎯᎯ ᎠᏕᎳ ᏱᎬᏁᎸᎯ" },
            { "type.nu.arabext", "ᎦᏅᎯᏛ ᎠᎳᏈ-ᎡᏂᏗᎩ ᏗᏎᏍᏗ" },
            { "type.nu.armnlow", "ᎠᎳᎻᎠᏂ ᏧᏍᏗ ᏗᎪᏪᎵ ᏗᏎᏍᏗ" },
            { "type.nu.greklow", "ᎠᏂᎪᎢ ᏧᏍᏗ ᏗᎪᏪᎵ ᏗᏎᏍᏗ" },
            { "type.nu.hanidec", "ᏓᎶᏂᎨ ᏕᏏᎹᎵ ᏗᏎᏍᏗ" },
            { "type.nu.hansfin", "ᎠᎯᏗᎨ ᏓᎶᏂᎨ ᎠᏕᎳ ᏗᏎᏍᏗ" },
            { "type.nu.hantfin", "ᎤᏦᏍᏗ ᏓᎶᏂᎨ ᎠᏕᎳ ᏗᏎᏍᏗ" },
            { "type.nu.jpanfin", "ᏣᏆᏂᏏ ᎠᏕᎳ ᏗᏎᏍᏗ" },
            { "type.nu.tamldec", "ᏔᎻᎵ ᏗᏎᏍᏗ" },
            { "type.ca.buddhist", "ᏊᏗᏍᏘ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.ethiopic", "ᎢᏗᏯᏈᎩ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.japanese", "ᏣᏆᏂᏏ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.cf.standard", "ᎠᏟᎶᏍᏗ ᎠᏕᎳ ᏱᎬᏁᎸᎯ" },
            { "type.co.standard", "ᎠᏟᎶᏍᏗ ᏗᎦᏅᏃᏙᏗ ᏕᎦᏅᏃᏛᎢ" },
            { "type.ms.uksystem", "ᏂᎬᎾᏛᎢ ᎤᏓᏤᎵᎦᏯ ᎠᏟᎶᏛ ᏄᏍᏗᏓᏅᎢ" },
            { "type.ms.ussystem", "US ᎠᏟᎶᏛ ᏄᏍᏗᏓᏅᎢ" },
            { "type.nu.fullwide", "ᎧᎵᎢ-ᎾᏯᏛᏒ ᏗᏎᏍᏗ" },
            { "type.nu.romanlow", "ᎠᏂᎶᎻ ᏧᏍᏗ ᏗᎪᏪᎵ ᏗᏎᏍᏗ" },
            { "type.ca.gregorian", "ᎩᎴᎪᎵᎠᏂ ᏅᏙ ᏗᏎᏍᏗ" },
            { "type.ca.islamic-civil", "ᎢᏌᎳᎻᎩ ᏅᏙ ᏗᏎᏍᏗ (ᏴᏫ ᎡᏆᎩ)" },
            { "type.ca.islamic-umalqura", "ᎢᏌᎳᎻᎩ ᏅᏙ ᏗᏎᏍᏗ (ᎥᎻ ᎠᎵ-ᏊᎳ)" },
            { "type.ca.ethiopic-amete-alem", "ᎡᏘᎣᏈᎠ ᎠᎺᏖ ᎠᎴᎻ ᏅᏙ ᏗᏎᏍᏗ" },
        };
        return data;
    }
}
