/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_vi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Giờ Trung bình Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Giờ Chuẩn Acre",
               "",
               "Giờ Mùa Hè Acre",
               "",
               "Giờ Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Giờ Chuẩn Apia",
               "",
               "Giờ Mùa Hè Apia",
               "",
               "Giờ Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Giờ Chuẩn Quần Đảo Cook",
               "",
               "Giờ Nửa Mùa Hè Quần Đảo Cook",
               "",
               "Giờ Quần Đảo Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Giờ Chuẩn Cuba",
               "CST",
               "Giờ Mùa Hè Cuba",
               "CDT",
               "Giờ Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Giờ Chuẩn Fiji",
               "",
               "Giờ Mùa Hè Fiji",
               "",
               "Giờ Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Giờ Chuẩn Vùng Vịnh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Giờ Chuẩn Hovd",
               "",
               "Giờ Mùa Hè Hovd",
               "",
               "Giờ Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Giờ Chuẩn Iran",
               "",
               "Giờ Mùa Hè Iran",
               "",
               "Giờ Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Giờ Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Giờ chuẩn Omsk",
               "",
               "Giờ mùa hè Omsk",
               "",
               "Giờ Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Giờ Chuẩn Peru",
               "",
               "Giờ Mùa Hè Peru",
               "",
               "Giờ Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Giờ Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Giờ Đảo Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Giờ Chuẩn Chile",
               "",
               "Giờ Mùa Hè Chile",
               "",
               "Giờ Chile",
               "",
            };
        final String[] China = new String[] {
               "Giờ Chuẩn Trung Quốc",
               "CST",
               "Giờ Mùa Hè Trung Quốc",
               "CDT",
               "Giờ Trung Quốc",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Giờ Quần Đảo Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Giờ Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Giờ Chuẩn Ấn Độ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Giờ Chuẩn Nhật Bản",
               "JST",
               "Giờ Mùa Hè Nhật Bản",
               "JDT",
               "Giờ Nhật Bản",
               "JT",
            };
        final String[] Korea = new String[] {
               "Giờ Chuẩn Hàn Quốc",
               "KST",
               "Giờ Mùa Hè Hàn Quốc",
               "KST",
               "Giờ Hàn Quốc",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Giờ Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Giờ Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Giờ Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Giờ Chuẩn Samoa",
               "SST",
               "Giờ ban ngày Samoa",
               "SST",
               "Giờ Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Giờ Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Giờ Chuẩn Tonga",
               "",
               "Giờ Mùa Hè Tonga",
               "",
               "Giờ Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Giờ Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Giờ Chuẩn Alaska",
               "AKST",
               "Giờ Mùa Hè Alaska",
               "AKDT",
               "Giờ Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Giờ Chuẩn Amazon",
               "",
               "Giờ Mùa Hè Amazon",
               "",
               "Giờ Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "Giờ Chuẩn Anadyr",
               "",
               "Giờ mùa hè Anadyr",
               "",
               "Giờ Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Giờ chuẩn Azores",
               "",
               "Giờ mùa hè Azores",
               "",
               "Giờ Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Giờ Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Giờ Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Giờ Chuẩn Đảo Phục Sinh",
               "",
               "Giờ Mùa Hè Đảo Phục Sinh",
               "",
               "Giờ Đảo Phục Sinh",
               "",
            };
        final String[] Guyana = new String[] {
               "Giờ Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Giờ Chuẩn Israel",
               "IST",
               "Giờ Mùa Hè Israel",
               "IDT",
               "Giờ Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Giờ Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Giờ Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Giờ Chuẩn Matxcơva",
               "MSK",
               "Giờ Mùa Hè Matxcơva",
               "MSK",
               "Giờ Matxcơva",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Giờ Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Giờ Chuẩn Samara",
               "",
               "Giờ mùa hè Samara",
               "",
               "Giờ Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Giờ Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Giờ Chuẩn Đài Bắc",
               "CST",
               "Giờ Mùa Hè Đài Bắc",
               "CDT",
               "Giờ Đài Bắc",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Giờ Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Giờ Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Giờ Wallis và Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Giờ chuẩn Ả Rập",
               "",
               "Giờ Mùa Hè Ả Rập",
               "",
               "Giờ Ả Rập",
               "",
            };
        final String[] Armenia = new String[] {
               "Giờ Chuẩn Armenia",
               "",
               "Giờ Mùa Hè Armenia",
               "",
               "Giờ Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Giờ Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Giờ Chuẩn Chatham",
               "",
               "Giờ Mùa Hè Chatham",
               "",
               "Giờ Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Giờ Phối hợp Quốc tế",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Giờ Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Giờ Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Giờ Chuẩn Georgia",
               "",
               "Giờ Mùa Hè Georgia",
               "",
               "Giờ Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Giờ Chuẩn Irkutsk",
               "",
               "Giờ Mùa Hè Irkutsk",
               "",
               "Giờ Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Giờ Chuẩn Magadan",
               "",
               "Giờ mùa hè Magadan",
               "",
               "Giờ Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Giờ Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Giờ Chuẩn Đảo Norfolk",
               "",
               "Giờ Mùa Hè Đảo Norfolk",
               "",
               "Giờ Đảo Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Giờ Chuẩn Fernando de Noronha",
               "",
               "Giờ Mùa Hè Fernando de Noronha",
               "",
               "Giờ Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Giờ Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Giờ Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Giờ Quần Đảo Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Giờ Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Giờ Chuẩn Uruguay",
               "",
               "Giờ Mùa Hè Uruguay",
               "",
               "Giờ Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Giờ Chuẩn Vanuatu",
               "",
               "Giờ Mùa Hè Vanuatu",
               "",
               "Giờ Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Giờ Chuẩn Yakutsk",
               "",
               "Giờ mùa hè Yakutsk",
               "",
               "Giờ Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Giờ Chuẩn Đại Tây Dương",
               "AST",
               "Giờ mùa hè Đại Tây Dương",
               "ADT",
               "Giờ Đại Tây Dương",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Giờ Chuẩn Brasilia",
               "",
               "Giờ Mùa Hè Brasilia",
               "",
               "Giờ Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Giờ Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Giờ Chuẩn Colombia",
               "",
               "Giờ Mùa Hè Colombia",
               "",
               "Giờ Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Giờ Chuẩn Quần Đảo Falkland",
               "",
               "Giờ Mùa Hè Quần Đảo Falkland",
               "",
               "Giờ Quần Đảo Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Giờ Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Giờ Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Giờ chuẩn Ulan Bator",
               "",
               "Giờ mùa hè Ulan Bator",
               "",
               "Giờ Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Giờ Chuẩn Pakistan",
               "PKT",
               "Giờ Mùa Hè Pakistan",
               "PKST",
               "Giờ Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Giờ Chuẩn Paraguay",
               "",
               "Giờ Mùa Hè Paraguay",
               "",
               "Giờ Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Giờ Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Giờ Chuẩn Sakhalin",
               "",
               "Giờ mùa hè Sakhalin",
               "",
               "Giờ Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Giờ Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Giờ Chuẩn Argentina",
               "",
               "Giờ Mùa Hè Argentina",
               "",
               "Giờ Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Giờ Đảo Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Giờ Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Giờ Chuẩn Hồng Kông",
               "HKT",
               "Giờ Mùa Hè Hồng Kông",
               "HKST",
               "Giờ Hồng Kông",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Giờ Đông Dương",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Giờ chuẩn Petropavlovsk-Kamchatski",
               "",
               "Giờ mùa hè Petropavlovsk-Kamchatski",
               "",
               "Giờ Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Giờ Kyrgystan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Giờ Chuẩn Lord Howe",
               "",
               "Giờ Mùa Hè Lord Howe",
               "",
               "Giờ Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Giờ Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Giờ Chuẩn Mauritius",
               "",
               "Giờ Mùa Hè Mauritius",
               "",
               "Giờ Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Giờ Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Giờ Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Giờ Chuẩn Volgograd",
               "MSK",
               "Giờ Mùa Hè Volgograd",
               "MSK",
               "Giờ Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Giờ Chuẩn Azerbaijan",
               "",
               "Giờ Mùa Hè Azerbaijan",
               "",
               "Giờ Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Giờ Chuẩn Bangladesh",
               "",
               "Giờ Mùa Hè Bangladesh",
               "",
               "Giờ Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Giờ Chuẩn Cape Verde",
               "",
               "Giờ Mùa Hè Cape Verde",
               "",
               "Giờ Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Giờ Đông Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Giờ Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Giờ Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Giờ Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Giờ Chuẩn Uzbekistan",
               "",
               "Giờ Mùa Hè Uzbekistan",
               "",
               "Giờ Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Giờ Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Giờ Chuẩn Krasnoyarsk",
               "",
               "Giờ Mùa Hè Krasnoyarsk",
               "",
               "Giờ Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Giờ Chuẩn New Zealand",
               "NZST",
               "Giờ Mùa Hè New Zealand",
               "NZDT",
               "Giờ New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Giờ chuẩn Novosibirsk",
               "",
               "Giờ mùa hè Novosibirsk",
               "",
               "Giờ Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Giờ Chuẩn Philippin",
               "PST",
               "Giờ Mùa Hè Philippin",
               "PDT",
               "Giờ Philippin",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Giờ Chuẩn Vladivostok",
               "",
               "Giờ mùa hè Vladivostok",
               "",
               "Giờ Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Giờ Ấn Độ Dương",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Giờ Quần Đảo Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Giờ Chuẩn Newfoundland",
               "NST",
               "Giờ Mùa Hè Newfoundland",
               "NDT",
               "Giờ Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Giờ Chuẩn Turkmenistan",
               "",
               "Giờ Mùa Hè Turkmenistan",
               "",
               "Giờ Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Giờ Guiana thuộc Pháp",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Giờ Chuẩn New Caledonia",
               "",
               "Giờ Mùa Hè New Caledonia",
               "",
               "Giờ New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Giờ Nam Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Giờ Chuẩn Yekaterinburg",
               "",
               "Giờ mùa hè Yekaterinburg",
               "",
               "Giờ Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Giờ Trung Phi",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Giờ Đông Phi",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Giờ Chuẩn Tây Phi",
               "WAT",
               "Giờ Mùa Hè Tây Phi",
               "WAT",
               "Giờ Tây Phi",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Giờ Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Giờ chuẩn Trung Âu",
               "CET",
               "Giờ mùa hè Trung Âu",
               "CEST",
               "Giờ Trung Âu",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Giờ chuẩn Đông Âu",
               "EET",
               "Giờ mùa hè Đông Âu",
               "EEST",
               "Giờ Đông Âu",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Giờ Chuẩn Tây Âu",
               "WET",
               "Giờ mùa hè Tây Âu",
               "WEST",
               "Giờ Tây Âu",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Giờ Chuẩn Thái Bình Dương Mexico",
               "MST",
               "Giờ Mùa Hè Thái Bình Dương Mexico",
               "MDT",
               "Giờ Thái Bình Dương Mexico",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Giờ Chuẩn Nam Phi",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Giờ chuẩn miền Trung",
               "CST",
               "Giờ mùa hè miền Trung",
               "CDT",
               "Giờ miền Trung",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Giờ chuẩn miền Đông",
               "EST",
               "Giờ mùa hè miền Đông",
               "EDT",
               "Giờ miền Đông",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Giờ chuẩn Thái Bình Dương",
               "PST",
               "Giờ mùa hè Thái Bình Dương",
               "PDT",
               "Giờ Thái Bình Dương",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Giờ Nam Cực và Nam Nước Pháp",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Giờ Quần Đảo Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Giờ Chuẩn Hawaii-Aleut",
               "HAST",
               "Giờ Mùa Hè Hawaii-Aleut",
               "HADT",
               "Giờ Hawaii-Aleut",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Giờ Quần Đảo Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Giờ Chuẩn St. Pierre và Miquelon",
               "",
               "Giờ Mùa Hè Saint Pierre và Miquelon",
               "",
               "Giờ St. Pierre và Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Giờ chuẩn miền núi",
               "MST",
               "Giờ mùa hè miền núi",
               "MDT",
               "Giờ miền núi",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Giờ Quần Đảo Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Giờ Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Giờ Chuẩn Miền Trung Australia",
               "ACST",
               "Giờ Mùa Hè Miền Trung Australia",
               "ACDT",
               "Giờ Miền Trung Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Giờ Chuẩn Miền Đông Australia",
               "AEST",
               "Giờ Mùa Hè Miền Đông Australia",
               "AEDT",
               "Giờ Miền Đông Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Giờ Chuẩn Miền Tây Australia",
               "AWST",
               "Giờ Mùa Hè Miền Tây Australia",
               "AWDT",
               "Giờ Miền Tây Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Giờ Miền Trung Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Giờ Miền Đông Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Giờ Miền Tây Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Giờ Chuẩn Miền Trung Tây Australia",
               "",
               "Giờ Mùa Hè Miền Trung Tây Australia",
               "",
               "Giờ Miền Trung Tây Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Giờ Chuẩn Hawaii-Aleut",
                    "HST",
                    "Giờ Mùa Hè Hawaii-Aleut",
                    "HDT",
                    "Giờ Hawaii-Aleut",
                    "Giờ HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST",
                new String[] {
                    "Giờ Chuẩn Hawaii-Aleut",
                    "HST",
                    "Giờ Mùa Hè Hawaii-Aleut",
                    "HDT",
                    "Giờ Hawaii-Aleut",
                    "Giờ HST",
                }
            },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ chuẩn Ai-len",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "Giờ Chuẩn Hawaii-Aleut",
                    "HST",
                    "Giờ Mùa Hè Hawaii-Aleut",
                    "HDT",
                    "Giờ Hawaii-Aleut",
                    "Giờ HST",
                }
            },
            { "Universal",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Giờ Phối hợp Quốc tế",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ chuẩn Ai-len",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "Giờ Chuẩn Hawaii-Aleut",
                    "HST",
                    "Giờ Mùa Hè Hawaii-Aleut",
                    "HDT",
                    "Giờ Hawaii-Aleut",
                    "Giờ HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "Giờ Chuẩn Hawaii-Aleut",
                    "HST",
                    "Giờ Mùa Hè Hawaii-Aleut",
                    "HDT",
                    "Giờ Hawaii-Aleut",
                    "Giờ HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Giờ Trung bình Greenwich",
                    "GMT",
                    "Giờ Mùa Hè Anh",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Ma Cao" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "TP Hồ Chí Minh" },
            { "timezone.excity.Asia/Taipei", "Đài Bắc" },
            { "timezone.excity.Etc/Unknown", "Thành phố không xác định" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Shanghai", "Thượng Hải" },
            { "timezone.excity.Europe/Moscow", "Mát-xcơ-va" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hồng Kông" },
            { "timezone.excity.Asia/Pyongyang", "Bình Nhưỡng" },
            { "timezone.excity.Asia/Vientiane", "Viêng Chăn" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Europe/Isle_of_Man", "Đảo Man" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Nam Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Bắc Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Bắc Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Bắc Dakota" },
        };
        return data;
    }
}
