/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_to extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_Hant = "tukufakaholo";
        final Object[][] data = new Object[][] {
            { "001", "Māmani" },
            { "002", "ʻAfilika" },
            { "003", "ʻAmelika tokelau" },
            { "005", "ʻAmelika tonga" },
            { "009", "ʻOsēnia" },
            { "011", "ʻAfilika fakahihifo" },
            { "013", "ʻAmelika lotoloto" },
            { "014", "ʻAfilika fakahahake" },
            { "015", "ʻAfilika fakatokelau" },
            { "017", "ʻAfilika lotoloto" },
            { "018", "ʻAfilika fakatonga" },
            { "019", "Ongo ʻAmelika" },
            { "021", "ʻAmelika fakatokelau" },
            { "029", "Kalipiane" },
            { "030", "ʻĒsia fakahahake" },
            { "034", "ʻĒsia fakatonga" },
            { "035", "ʻĒsia fakatongahahake" },
            { "039", "ʻEulope fakatonga" },
            { "053", "ʻAositelēlēsia" },
            { "054", "Melanīsia" },
            { "057", "Potu fonua Mikolonīsia" },
            { "061", "Polinīsia" },
            { "142", "ʻĒsia" },
            { "143", "ʻĒsia lotoloto" },
            { "145", "ʻĒsia fakahihifo" },
            { "150", "ʻEulope" },
            { "151", "ʻEulope fakahahake" },
            { "154", "ʻEulope fakatokelau" },
            { "155", "ʻEulope fakahihifo" },
            { "202", "ʻAfilika fakasahala-tonga" },
            { "419", "ʻAmelika fakalatina" },
            { "AC", "Motu ʻAsenisini" },
            { "AD", "ʻAnitola" },
            { "AE", "ʻAlepea Fakatahataha" },
            { "AF", "ʻAfikānisitani" },
            { "AG", "Anitikua mo Palaputa" },
            { "AI", "Anikuila" },
            { "AL", "ʻAlipania" },
            { "AM", "ʻĀmenia" },
            { "AO", "ʻAngikola" },
            { "AQ", "ʻAnitātika" },
            { "AR", "ʻAsenitina" },
            { "AS", "Haʻamoa ʻAmelika" },
            { "AT", "ʻAositulia" },
            { "AU", "ʻAositelēlia" },
            { "AW", "ʻAlupa" },
            { "AX", "ʻOtumotu ʻAlani" },
            { "AZ", "ʻAsapaisani" },
            { "BA", "Posinia mo Hesikōvina" },
            { "BB", "Pāpeitosi" },
            { "BD", "Pengilātesi" },
            { "BE", "Pelesiume" },
            { "BF", "Pekano Faso" },
            { "BG", "Pulukalia" },
            { "BH", "Paleini" },
            { "BI", "Puluniti" },
            { "BJ", "Penini" },
            { "BL", "Sā Patēlemi" },
            { "BM", "Pēmuta" },
            { "BN", "Pulunei" },
            { "BO", "Polīvia" },
            { "BQ", "Kalipiane fakahōlani" },
            { "BR", "Palāsili" },
            { "BS", "Pahama" },
            { "BT", "Pūtani" },
            { "BV", "Motu Puveti" },
            { "BW", "Potisiuana" },
            { "BY", "Pelalusi" },
            { "BZ", "Pelise" },
            { "CA", "Kānata" },
            { "CC", "ʻOtumotu Koko" },
            { "CD", "Kongo - Kinisasa" },
            { "CF", "Lepupelika ʻAfilika Lotoloto" },
            { "CG", "Kongo - Palasavila" },
            { "CH", "Suisilani" },
            { "CI", "Matafonua ʻAivolī" },
            { "CK", "ʻOtumotu Kuki" },
            { "CL", "Sili" },
            { "CM", "Kameluni" },
            { "CN", "Siaina" },
            { "CO", "Kolomipia" },
            { "CP", "Motu Kilipatoni" },
            { "CR", "Kosita Lika" },
            { "CU", "Kiupa" },
            { "CV", "Muiʻi Vēte" },
            { "CW", "Kulasao" },
            { "CX", "Motu Kilisimasi" },
            { "CY", "Saipalesi" },
            { "CZ", "Sēkia" },
            { "DE", "Siamane" },
            { "DG", "Tieko Kāsia" },
            { "DJ", "Siputi" },
            { "DK", "Tenimaʻake" },
            { "DM", "Tominika" },
            { "DO", "Lepupelika Tominika" },
            { "DZ", "ʻAlisilia" },
            { "EA", "Siuta mo Melila" },
            { "EC", "ʻEkuetoa" },
            { "EE", "ʻEsitōnia" },
            { "EG", "ʻIsipite" },
            { "EH", "Sahala fakahihifo" },
            { "ER", "ʻElitulia" },
            { "ES", "Sipeini" },
            { "ET", "ʻĪtiōpia" },
            { "EU", "ʻEulope fakatahataha" },
            { "EZ", "ʻEulope fekauʻaki-paʻanga" },
            { "FI", "Finilani" },
            { "FJ", "Fisi" },
            { "FK", "ʻOtumotu Fokulani" },
            { "FM", "Mikolonīsia" },
            { "FO", "ʻOtumotu Faloe" },
            { "FR", "Falanisē" },
            { "GA", "Kaponi" },
            { "GB", "Pilitānia" },
            { "GD", "Kelenatā" },
            { "GE", "Seōsia" },
            { "GF", "Kuiana fakafalanisē" },
            { "GG", "Kuenisī" },
            { "GH", "Kana" },
            { "GI", "Sipalālitā" },
            { "GL", "Kulinilani" },
            { "GM", "Kamipia" },
            { "GN", "Kini" },
            { "GP", "Kuatalupe" },
            { "GQ", "ʻEkueta Kini" },
            { "GR", "Kalisi" },
            { "GS", "ʻOtumotu Seōsia-tonga mo Saniuisi-tonga" },
            { "GT", "Kuatamala" },
            { "GU", "Kuamu" },
            { "GW", "Kini-Pisau" },
            { "GY", "Kuiana" },
            { "HK", "Hongi Kongi SAR Siaina" },
            { "HM", "ʻOtumotu Heati mo Makitonali" },
            { "HN", "Honitulasi" },
            { "HR", "Kuloisia" },
            { "HT", "Haiti" },
            { "HU", "Hungakalia" },
            { "IC", "ʻOtumotu Kaneli" },
            { "ID", "ʻInitonēsia" },
            { "IE", "ʻAealani" },
            { "IL", "ʻIsileli" },
            { "IM", "Motu Mani" },
            { "IN", "ʻInitia" },
            { "IO", "Potu fonua moana ʻInitia fakapilitānia" },
            { "IQ", "ʻIlaaki" },
            { "IR", "ʻIlaani" },
            { "IS", "ʻAisilani" },
            { "IT", "ʻĪtali" },
            { "JE", "Selusī" },
            { "JM", "Samaika" },
            { "JO", "Soatane" },
            { "JP", "Siapani" },
            { "KE", "Keniā" },
            { "KG", "Kīkisitani" },
            { "KH", "Kamipōtia" },
            { "KI", "Kilipasi" },
            { "KM", "Komolosi" },
            { "KN", "Sā Kitisi mo Nevisi" },
            { "KP", "Kōlea tokelau" },
            { "KR", "Kōlea tonga" },
            { "KW", "Kueiti" },
            { "KY", "ʻOtumotu Keimeni" },
            { "KZ", "Kasakitani" },
            { "LA", "Lau" },
            { "LB", "Lepanoni" },
            { "LC", "Sā Lūsia" },
            { "LI", "Likitenisiteini" },
            { "LK", "Sīlangikā" },
            { "LR", "Laipelia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Lakisimipeki" },
            { "LV", "Lativia" },
            { "LY", "Līpia" },
            { "MA", "Moloko" },
            { "MC", "Monako" },
            { "MD", "Molotova" },
            { "ME", "Monitenikalo" },
            { "MF", "Sā Mātini (fakafalanisē)" },
            { "MG", "Matakasika" },
            { "MH", "ʻOtumotu Māsolo" },
            { "MK", "Masetōnia fakatokelau" },
            { "ML", "Māli" },
            { "MM", "Mianimā (Pema)" },
            { "MN", "Mongokōlia" },
            { "MO", "Makau SAR Siaina" },
            { "MP", "ʻOtumotu Maliana tokelau" },
            { "MQ", "Mātiniki" },
            { "MR", "Maulitenia" },
            { "MS", "Moʻungaselati" },
            { "MT", "Malita" },
            { "MU", "Maulitiusi" },
            { "MV", "Malativisi" },
            { "MW", "Malaui" },
            { "MX", "Mekisikou" },
            { "MY", "Malēsia" },
            { "MZ", "Mosēmipiki" },
            { "NA", "Namipia" },
            { "NC", "Niu Kaletōnia" },
            { "NE", "Nisia" },
            { "NF", "Motu Nōfoliki" },
            { "NG", "Naisilia" },
            { "NI", "Nikalakua" },
            { "NL", "Hōlani" },
            { "NO", "Noauē" },
            { "NP", "Nepali" },
            { "NR", "Naulu" },
            { "NU", "Niuē" },
            { "NZ", "Nuʻusila" },
            { "OM", "ʻOmani" },
            { "PA", "Panamā" },
            { "PE", "Pelū" },
            { "PF", "Polinisia fakafalanisē" },
            { "PG", "Papuaniukini" },
            { "PH", "Filipaini" },
            { "PK", "Pākisitani" },
            { "PL", "Polani" },
            { "PM", "Sā Piea mo Mikeloni" },
            { "PN", "ʻOtumotu Pitikeni" },
            { "PR", "Puēto Liko" },
            { "PS", "Potu Palesitaine" },
            { "PT", "Potukali" },
            { "PW", "Palau" },
            { "PY", "Palakuai" },
            { "QA", "Katā" },
            { "QO", "ʻOsēnia mamaʻo" },
            { "RE", "Lēunioni" },
            { "RO", "Lomēnia" },
            { "RS", "Sēpia" },
            { "RU", "Lūsia" },
            { "RW", "Luanitā" },
            { "SA", "Saute ʻAlepea" },
            { "SB", "ʻOtumotu Solomone" },
            { "SC", "ʻOtumotu Seiseli" },
            { "SD", "Sūteni" },
            { "SE", "Suēteni" },
            { "SG", "Singapoa" },
            { "SH", "Sā Helena" },
            { "SI", "Silōvenia" },
            { "SJ", "Sivolopāti mo Sani Maieni" },
            { "SK", "Silōvakia" },
            { "SL", "Siela Leone" },
            { "SM", "Sā Malino" },
            { "SN", "Senekalo" },
            { "SO", "Sōmalia" },
            { "SR", "Suliname" },
            { "SS", "Sūtani fakatonga" },
            { "ST", "Sao Tomē mo Pilinisipe" },
            { "SV", "ʻEle Salavatoa" },
            { "SX", "Sā Mātini (fakahōlani)" },
            { "SY", "Sīlia" },
            { "SZ", "ʻEsuatini" },
            { "TA", "Tulisitani ta Kunuha" },
            { "TC", "ʻOtumotu Tuki mo Kaikosi" },
            { "TD", "Sāti" },
            { "TF", "Potu fonua tonga fakafalanisē" },
            { "TG", "Toko" },
            { "TH", "Tailani" },
            { "TJ", "Tasikitani" },
            { "TK", "Tokelau" },
            { "TL", "Timoa fakahahake" },
            { "TM", "Tūkimenisitani" },
            { "TN", "Tunīsia" },
            { "TO", "Tonga" },
            { "TR", "Toake" },
            { "TT", "Tilinitati mo Topako" },
            { "TV", "Tūvalu" },
            { "TW", "Taiuani" },
            { "TZ", "Tenisānia" },
            { "UA", "ʻŪkalaʻine" },
            { "UG", "ʻIukanitā" },
            { "UM", "ʻOtumotu siʻi ʻo ʻAmelika" },
            { "UN", "ʻŪ fonua fakatahataha" },
            { "US", "Puleʻanga fakatahataha ʻAmelika" },
            { "UY", "ʻUlukuai" },
            { "UZ", "ʻUsipekitani" },
            { "VA", "Kolo Vatikani" },
            { "VC", "Sā Viniseni mo Kulenatini" },
            { "VE", "Venesuela" },
            { "VG", "ʻOtumotu Vilikini fakapilitānia" },
            { "VI", "ʻOtumotu Vilikini fakaʻamelika" },
            { "VN", "Vietinami" },
            { "VU", "Vanuatu" },
            { "WF", "ʻUvea mo Futuna" },
            { "WS", "Haʻamoa" },
            { "XA", "fasiʻalea loi" },
            { "XB", "fua-ua loi" },
            { "XK", "Kōsovo" },
            { "YE", "Iemeni" },
            { "YT", "Maiote" },
            { "ZA", "ʻAfilika tonga" },
            { "ZM", "Semipia" },
            { "ZW", "Simipapuei" },
            { "ZZ", "Potu fonua taʻeʻiloa pe hala" },
            { "aa", "lea fakaʻafāla" },
            { "ab", "lea fakaʻapakasia" },
            { "ae", "lea fakaʻavesitani" },
            { "af", "lea fakaʻafilikana" },
            { "ak", "lea fakaʻakani" },
            { "am", "lea fakaʻameliki" },
            { "an", "lea fakaʻalakoni" },
            { "ar", "lea fakaʻalepea" },
            { "as", "lea fakaʻasamia" },
            { "av", "lea fakaʻavaliki" },
            { "ay", "lea fakaʻaimala" },
            { "az", "lea fakaʻasepaisani" },
            { "ba", "lea fakapasikili" },
            { "be", "lea fakapelalusi" },
            { "bg", "lea fakapulukalia" },
            { "bi", "lea fakapisilama" },
            { "bm", "lea fakapamipala" },
            { "bn", "lea fakapāngilā" },
            { "bo", "lea fakatipeti" },
            { "br", "lea fakapeletoni" },
            { "bs", "lea fakaposinia" },
            { "ca", "lea fakakatalani" },
            { "ce", "lea fakasese" },
            { "ch", "lea fakakamolo" },
            { "co", "lea fakakōsika" },
            { "cr", "lea fakakelī" },
            { "cs", "lea fakaseki" },
            { "cu", "lea fakasilavia-fakasiasi" },
            { "cv", "lea fakasuvasa" },
            { "cy", "lea fakauēlesi" },
            { "da", "lea fakatenimaʻake" },
            { "de", "lea fakasiamane" },
            { "dv", "lea fakativehi" },
            { "dz", "lea fakatisōngika" },
            { "ee", "lea fakaʻeue" },
            { "el", "lea fakakalisi" },
            { "en", "lea fakapālangi" },
            { "eo", "lea fakaʻesipulanito" },
            { "es", "lea fakasipēnisi" },
            { "et", "lea fakaʻesitōnia" },
            { "eu", "lea fakapāsiki" },
            { "fa", "lea fakapēsia" },
            { "ff", "lea fakafulā" },
            { "fi", "lea fakafinilani" },
            { "fj", "lea fakafisi" },
            { "fo", "lea fakafaloe" },
            { "fr", "lea fakafalanisē" },
            { "fy", "lea fakafilisia-hihifo" },
            { "ga", "lea fakaʻaelani" },
            { "gd", "lea fakakaeliki" },
            { "gl", "lea fakakalisia" },
            { "gn", "lea fakakualani" },
            { "gu", "lea fakakutalati" },
            { "gv", "lea fakamangikī" },
            { "ha", "lea fakahausa" },
            { "he", "lea fakahepelū" },
            { "hi", "lea fakahinitī" },
            { "ho", "lea fakahili-motu" },
            { "hr", "lea fakakuloisia" },
            { "ht", "lea fakahaiti" },
            { "hu", "lea fakahungakalia" },
            { "hy", "lea fakaʻāmenia" },
            { "hz", "lea fakahelelo" },
            { "ia", "lea fakavahaʻalea" },
            { "id", "lea fakaʻinitōnesia" },
            { "ie", "lea fakavahaʻalingikē" },
            { "ig", "lea fakaʻikipō" },
            { "ii", "lea fakasisiuani-ī" },
            { "ik", "lea fakaʻinupiaki" },
            { "io", "lea fakaʻito" },
            { "is", "lea fakaʻaisilani" },
            { "it", "lea fakaʻītali" },
            { "iu", "lea fakaʻinuketītuti" },
            { "ja", "lea fakasiapani" },
            { "jv", "lea fakasava" },
            { "ka", "lea fakaseōsia" },
            { "kg", "lea fakakongikō" },
            { "ki", "lea fakakikuiu" },
            { "kj", "lea fakakuaniama" },
            { "kk", "lea fakakasaki" },
            { "kl", "lea fakakalaʻalisuti" },
            { "km", "lea fakakamipōtia" },
            { "kn", "lea fakakanata" },
            { "ko", "lea fakakōlea" },
            { "kr", "lea fakakanuli" },
            { "ks", "lea fakakāsimila" },
            { "ku", "lea fakakulitī" },
            { "kv", "lea fakakomi" },
            { "kw", "lea fakakoniuali" },
            { "ky", "lea fakakīsisi" },
            { "la", "lea fakalatina" },
            { "lb", "lea fakalakisimipeki" },
            { "lg", "lea fakakanita" },
            { "li", "lea fakalimipūliki" },
            { "ln", "lea lingikala" },
            { "lo", "lea fakalau" },
            { "lt", "lea fakalituania" },
            { "lu", "lea fakalupa-katanga" },
            { "lv", "lea fakalativia" },
            { "mg", "lea fakamalakasi" },
            { "mh", "lea fakamāsolo" },
            { "mi", "lea fakamāuli" },
            { "mk", "lea fakamasitōnia" },
            { "ml", "lea fakaʻinitia-malāialami" },
            { "mn", "lea fakamongokōlia" },
            { "mr", "lea fakamalati" },
            { "ms", "lea fakamalei" },
            { "mt", "lea fakamalita" },
            { "my", "lea fakapema" },
            { "na", "lea fakanaulu" },
            { "nb", "lea fakanouaē-pokimali" },
            { "nd", "lea fakanetepele-tokelau" },
            { "ne", "lea fakanepali" },
            { "ng", "lea fakanetongikā" },
            { "nl", "lea fakahōlani" },
            { "nn", "lea fakanoauē-ninosiki" },
            { "no", "lea fakanouaē" },
            { "nr", "lea fakanetepele-tonga" },
            { "nv", "lea fakanavaho" },
            { "ny", "lea fakanianisa" },
            { "oc", "lea fakaʻokitane" },
            { "oj", "lea fakaʻosipiuā" },
            { "om", "lea fakaʻolomo" },
            { "or", "lea fakaʻotia" },
            { "os", "lea fakaʻosetiki" },
            { "pa", "lea fakapūnusapi" },
            { "pi", "lea fakapāli" },
            { "pl", "lea fakapolani" },
            { "ps", "lea fakapasitō" },
            { "pt", "lea fakapotukali" },
            { "qu", "lea fakakuetisa" },
            { "rm", "lea fakalaito-lomēnia" },
            { "rn", "lea fakaluaniti" },
            { "ro", "lea fakalōmenia" },
            { "ru", "lea fakalūsia" },
            { "rw", "lea fakakiniāuanita" },
            { "sa", "lea fakasanisukuliti" },
            { "sc", "lea fakasaletīnia" },
            { "sd", "lea fakasīniti" },
            { "se", "lea fakasami-tokelau" },
            { "sg", "lea fakasangikō" },
            { "sh", "lea fakakuloisia-sēpia" },
            { "si", "lea fakasingihala" },
            { "sk", "lea fakasolāvaki" },
            { "sl", "lea fakasolovenia" },
            { "sm", "lea fakahaʻamoa" },
            { "sn", "lea fakasiona" },
            { "so", "lea fakasomali" },
            { "sq", "lea fakaʻalapēnia" },
            { "sr", "lea fakasēpia" },
            { "ss", "lea fakasuati" },
            { "st", "lea fakasoto-tonga" },
            { "su", "lea fakasunitā" },
            { "sv", "lea fakasuēteni" },
            { "sw", "lea fakasuahili" },
            { "ta", "lea fakatamili" },
            { "te", "lea fakaʻinitia-teluku" },
            { "tg", "lea fakatāsiki" },
            { "th", "lea fakatailani" },
            { "ti", "lea fakatikilinia" },
            { "tk", "lea fakatēkimeni" },
            { "tl", "lea fakatakāloka" },
            { "tn", "lea fakatisuana" },
            { "to", "lea fakatonga" },
            { "tr", "lea fakatoake" },
            { "ts", "lea fakatisonga" },
            { "tt", "lea fakatatale" },
            { "tw", "lea fakatusuī" },
            { "ty", "lea fakatahiti" },
            { "ug", "lea fakaʻuikūli" },
            { "uk", "lea fakaʻūkalaʻine" },
            { "ur", "lea fakaʻūtū" },
            { "uz", "lea fakaʻusipeki" },
            { "ve", "lea fakavenitā" },
            { "vi", "lea fakavietinami" },
            { "vo", "lea fakavolapiki" },
            { "wa", "lea fakaʻualonia" },
            { "wo", "lea fakaʻuolofo" },
            { "xh", "lea fakatōsa" },
            { "yi", "lea fakaītisi" },
            { "yo", "lea fakaʻiōlupa" },
            { "za", "lea fakasuangi" },
            { "zh", "lea fakasiaina" },
            { "zu", "lea fakasulu" },
            { "ace", "lea fakaʻatisē" },
            { "ach", "lea fakaʻakoli" },
            { "ada", "lea fakaʻatangimē" },
            { "ady", "lea fakaʻatikē" },
            { "aeb", "lea fakaʻalepea-tunīsia" },
            { "afh", "lea fakaʻafilihili" },
            { "agq", "lea fakaʻakihemi" },
            { "ain", "lea fakaʻainu" },
            { "akk", "lea fakaʻakatia" },
            { "akz", "lea fakaʻalapama" },
            { "ale", "lea fakaʻaleuti" },
            { "aln", "lea fakaʻalapēnia-keki" },
            { "alt", "lea fakaʻalitai-tonga" },
            { "ang", "lea fakapālangi-motuʻa" },
            { "ann", "lea fakaʻopolo" },
            { "anp", "lea fakaʻangika" },
            { "arc", "lea fakaʻalāmiti" },
            { "arn", "lea fakamapuse" },
            { "aro", "lea fakaʻalaona" },
            { "arp", "lea fakaʻalapaho" },
            { "arq", "lea fakaʻalepea-ʻaisilia" },
            { "ars", "lea fakaʻalepea-nāsiti" },
            { "arw", "lea fakaʻalauaki" },
            { "ary", "lea fakaʻalepea-moloko" },
            { "arz", "lea fakaʻalepea-ʻisipite" },
            { "asa", "lea fakaʻasu" },
            { "ase", "lea fakaʻilonga-ʻamelika" },
            { "ast", "lea fakaʻasitūlia" },
            { "atj", "lea fakaʻatikameku" },
            { "avk", "lea fakakotava" },
            { "awa", "lea fakaʻauati" },
            { "bal", "lea fakapalusi" },
            { "ban", "lea fakapali" },
            { "bar", "lea fakapavālia" },
            { "bas", "lea fakapasaʻa" },
            { "bax", "lea fakapamuni" },
            { "bbc", "lea fakatōpe-pēteki" },
            { "bbj", "lea fakakomala" },
            { "bej", "lea fakapesa" },
            { "bem", "lea fakapēmipa" },
            { "bew", "lea fakapetavi" },
            { "bez", "lea fakapena" },
            { "bfd", "lea fakapafuti" },
            { "bfq", "lea fakapataka" },
            { "bgc", "lea fakahalaiānivi" },
            { "bgn", "lea fakapalusi-hihifo" },
            { "bho", "lea fakaposipuli" },
            { "bik", "lea fakapikoli" },
            { "bin", "lea fakapini" },
            { "bjn", "lea fakapanisali" },
            { "bkm", "lea fakakome" },
            { "bla", "lea fakasikesikā" },
            { "bpy", "lea fakapisinupilia" },
            { "bqi", "lea fakapakitiāli" },
            { "bra", "lea fakapalai" },
            { "brh", "lea fakapalahui" },
            { "brx", "lea fakapōto" },
            { "bss", "lea fakaʻakōse" },
            { "bua", "lea fakapuliati" },
            { "bug", "lea fakapukisi" },
            { "bum", "lea fakapulu" },
            { "byn", "lea fakapilini" },
            { "byv", "lea fakametūmipa" },
            { "cad", "lea fakakato" },
            { "car", "lea fakakalipa" },
            { "cay", "lea fakakaiuka" },
            { "cch", "lea fakaʻatisami" },
            { "ccp", "lea fakasākima" },
            { "ceb", "lea fakasepuano" },
            { "cgg", "lea fakakika" },
            { "chb", "lea fakasīpisa" },
            { "chg", "lea fakasakatāi" },
            { "chk", "lea fakatūke" },
            { "chm", "lea fakamalī" },
            { "chn", "lea fakasinuki-takote" },
            { "cho", "lea fakasokitau" },
            { "chp", "lea fakasipeuiani" },
            { "chr", "lea fakaselokī" },
            { "chy", "lea fakaseiene" },
            { "ckb", "lea fakakūtisi-loloto" },
            { "clc", "lea fakatisilikōtini" },
            { "cop", "lea fakakopitika" },
            { "cps", "lea fakakapiseno" },
            { "crg", "lea fakametisifi" },
            { "crh", "lea fakatatali-kilimea" },
            { "crj", "lea fakakilī-tongahahake" },
            { "crk", "lea fakakilī-toafa" },
            { "crl", "lea fakakilī-tokelauhahake" },
            { "crm", "lea fakamose-kilī" },
            { "crr", "lea fakaʻalakonikuia-kalolina" },
            { "crs", "lea fakaseselua-falanisē" },
            { "csb", "lea fakakasiupia" },
            { "csw", "lea fakakilī-ano" },
            { "dak", "lea fakatakota" },
            { "dar", "lea fakatalakuā" },
            { "dav", "lea fakataita" },
            { "del", "lea fakatelauale" },
            { "den", "lea fakasilave" },
            { "dgr", "lea fakatōkelipi" },
            { "din", "lea fakatingikā" },
            { "dje", "lea fakatisāma" },
            { "doi", "lea fakatokili" },
            { "dsb", "lea fakasōpia-hifo" },
            { "dtp", "lea fakatusuni-loloto" },
            { "dua", "lea fakatuala" },
            { "dum", "lea fakahōlani-lotoloto" },
            { "dyo", "lea fakaiola-fonī" },
            { "dyu", "lea fakatiula" },
            { "dzg", "lea fakatasaka" },
            { "ebu", "lea fakaʻemipū" },
            { "efi", "lea fakaʻefiki" },
            { "egl", "lea fakaʻemilia" },
            { "egy", "lea fakaʻisipitemuʻa" },
            { "eka", "lea fakaʻekaiuki" },
            { "elx", "lea fakaʻelamite" },
            { "enm", "lea fakapālangi-lotoloto" },
            { "esu", "lea fakaiūpiki-loloto" },
            { "ewo", "lea fakaʻeuōnito" },
            { "ext", "lea fakaʻekisitematula" },
            { "fan", "lea fakafangi" },
            { "fat", "lea fakafanitē" },
            { "fil", "lea fakafilipaini" },
            { "fit", "lea fakafinilani-tōnetale" },
            { "fon", "lea fakafōngi" },
            { "frc", "lea fakafalanisē-kasuni" },
            { "frm", "lea fakafalanisē-lotoloto" },
            { "fro", "lea fakafalanisē-motuʻa" },
            { "frp", "lea fakaʻāpitano" },
            { "frr", "lea fakafilisia-tokelau" },
            { "frs", "lea fakafilisia-hahake" },
            { "fur", "lea fakafulilāni" },
            { "gaa", "lea fakakā" },
            { "gag", "lea fakakakausi" },
            { "gan", "lea fakasiaina-kani" },
            { "gay", "lea fakakaio" },
            { "gba", "lea fakakapaia" },
            { "gbz", "lea fakateli-soloasitelia" },
            { "gez", "lea fakasiʻisi" },
            { "gil", "lea fakakilipasi" },
            { "glk", "lea fakakilaki" },
            { "gmh", "lea fakasiamane-hake-lotoloto" },
            { "goh", "lea fakasiamane-hake-motuʻa" },
            { "gon", "lea fakakonitī" },
            { "gor", "lea fakakolonitalo" },
            { "got", "lea fakakotika" },
            { "grb", "lea fakakēpo" },
            { "grc", "lea fakakalisimuʻa" },
            { "gsw", "lea fakasiamane-suisilani" },
            { "guc", "lea fakaʻuaiū" },
            { "gur", "lea fakafalefale" },
            { "guz", "lea fakakusī" },
            { "gwi", "lea fakaʻuīsini" },
            { "hai", "lea fakahaita" },
            { "hak", "lea fakasiaina-haka" },
            { "haw", "lea fakahauaiʻi" },
            { "hax", "lea fakahaita-tonga" },
            { "hif", "lea fakahinitī-fisi" },
            { "hil", "lea fakahilikainoni" },
            { "hit", "lea fakahitite" },
            { "hmn", "lea fakamōngi" },
            { "hsb", "lea fakasōpia-hake" },
            { "hsn", "lea fakasiaina-siangi" },
            { "hup", "lea fakahupa" },
            { "hur", "lea fakahalikomele" },
            { "iba", "lea fakaʻipani" },
            { "ibb", "lea fakaʻipipio" },
            { "ikt", "lea fakaʻinuketītuti-kānata-hihifo" },
            { "ilo", "lea fakaʻiloko" },
            { "inh", "lea fakaʻingusi" },
            { "izh", "lea fakaʻingiliani" },
            { "jam", "lea fakapālangi-samaika" },
            { "jbo", "lea fakalosipani" },
            { "jgo", "lea fakanikōmipa" },
            { "jmc", "lea fakamasame" },
            { "jpr", "lea fakaʻiuteo-pēsia" },
            { "jrb", "lea fakaʻiuteo-ʻalepea" },
            { "jut", "lea fakaʻiutilani" },
            { "kaa", "lea fakakala-kalipaki" },
            { "kab", "lea fakakapile" },
            { "kac", "lea fakakasini" },
            { "kaj", "lea fakasisū" },
            { "kam", "lea fakakamipa" },
            { "kaw", "lea fakakavi" },
            { "kbd", "lea fakakapālitia" },
            { "kbl", "lea fakakanēmipu" },
            { "kcg", "lea fakatiapi" },
            { "kde", "lea fakamakōnite" },
            { "kea", "lea fakakapuvelitianu" },
            { "ken", "lea fakakeniangi" },
            { "kfo", "lea fakakolo" },
            { "kgp", "lea fakakaingangi" },
            { "kha", "lea fakakāsi" },
            { "kho", "lea fakakōtani" },
            { "khq", "lea fakakoila-sīni" },
            { "khw", "lea fakakouali" },
            { "kiu", "lea fakakilimanisikī" },
            { "kkj", "lea fakakako" },
            { "kln", "lea fakakalenisini" },
            { "kmb", "lea fakakimipūnitu" },
            { "koi", "lea fakakomi-pelemiaki" },
            { "kok", "lea fakakonikanī" },
            { "kos", "lea fakakosilae" },
            { "kpe", "lea fakakepele" },
            { "krc", "lea fakakalate-palakili" },
            { "kri", "lea fakakilio" },
            { "krj", "lea fakakinaraiā" },
            { "krl", "lea fakakalelia" },
            { "kru", "lea fakakuluki" },
            { "ksb", "lea fakasiamipala" },
            { "ksf", "lea fakapafia" },
            { "ksh", "lea fakakolongia" },
            { "kum", "lea fakakumiki" },
            { "kut", "lea fakakutenai" },
            { "kwk", "lea fakakuakuala" },
            { "lad", "lea fakalatino" },
            { "lag", "lea fakalangi" },
            { "lah", "lea fakapunisapi-hihifoi" },
            { "lam", "lea fakalamipā" },
            { "lez", "lea fakalesikia" },
            { "lfn", "lea fakakavakava-foʻou" },
            { "lij", "lea fakalikulia" },
            { "lil", "lea fakalilōeti" },
            { "liv", "lea fakalivonia" },
            { "lkt", "lea fakalakota" },
            { "lmo", "lea fakalomipāti" },
            { "lol", "lea fakamongikō" },
            { "lou", "lea fakaluisiana" },
            { "loz", "lea fakalosi" },
            { "lrc", "lea fakaluli-tokelau" },
            { "lsm", "lea fakasāmia" },
            { "ltg", "lea fakalatakale" },
            { "lua", "lea fakalupa-lulua" },
            { "lui", "lea fakaluiseno" },
            { "lun", "lea fakalunitā" },
            { "luo", "lea fakaluo" },
            { "lus", "lea fakamiso" },
            { "luy", "lea fakaluīa" },
            { "lzh", "lea fakasiaina-faʻutohi" },
            { "lzz", "lea fakalasu" },
            { "mad", "lea fakamatula" },
            { "maf", "lea fakamafa" },
            { "mag", "lea fakamakahi" },
            { "mai", "lea fakamaitili" },
            { "mak", "lea fakamakasali" },
            { "man", "lea fakamanitīngiko" },
            { "mas", "lea fakamasai" },
            { "mde", "lea fakamapa" },
            { "mdf", "lea fakamokisiā" },
            { "mdr", "lea fakamanetali" },
            { "men", "lea fakamenetī" },
            { "mer", "lea fakamelu" },
            { "mfe", "lea fakamolisieni" },
            { "mga", "lea fakaʻaelani-lotoloto" },
            { "mgh", "lea fakamakūa-meʻeto" },
            { "mgo", "lea fakametā" },
            { "mic", "lea fakamikemaki" },
            { "min", "lea fakaminangikapau" },
            { "mnc", "lea fakamanisū" },
            { "mni", "lea fakamanipuli" },
            { "moe", "lea fakaʻinuʻaimuni" },
            { "moh", "lea fakamohauki" },
            { "mos", "lea fakamosi" },
            { "mrj", "lea fakamali-hihifo" },
            { "mua", "lea fakamunitangi" },
            { "mul", "lea tuifio" },
            { "mus", "lea fakakileki" },
            { "mwl", "lea fakamilanitēsi" },
            { "mwr", "lea fakamaliwali" },
            { "mwv", "lea fakamenitauai" },
            { "mye", "lea fakamiene" },
            { "myv", "lea fakaʻelisia" },
            { "mzn", "lea fakamasanitelani" },
            { "nan", "lea fakasiaina-mininani" },
            { "nap", "lea fakanapoletano" },
            { "naq", "lea fakanama" },
            { "nds", "lea fakasiamane-hifo" },
            { "new", "lea fakaneuali" },
            { "nia", "lea fakaniasi" },
            { "niu", "lea fakaniuē" },
            { "njo", "lea fakaʻaonasa" },
            { "nmg", "lea fakakuasio" },
            { "nnh", "lea fakangiemipōni" },
            { "nog", "lea fakanokai" },
            { "non", "lea fakanoauē-motuʻa" },
            { "nov", "lea fakanoviale" },
            { "nqo", "lea fakanikō" },
            { "nso", "lea fakasoto-tokelau" },
            { "nus", "lea fakanueli" },
            { "nwc", "lea fakaneuali-motuʻa" },
            { "nym", "lea fakaniamiuesi" },
            { "nyn", "lea fakanianikole" },
            { "nyo", "lea fakaniolo" },
            { "nzi", "lea fakanesima" },
            { "ojb", "lea fakaʻosipiuā-tokelauhihifo" },
            { "ojc", "lea fakaʻosipiuā-loto" },
            { "ojs", "lea fakakilī-osi" },
            { "ojw", "lea fakaʻosipiuā-hihifo" },
            { "oka", "lea faka-ʻokanākani" },
            { "osa", "lea fakaʻosēse" },
            { "ota", "lea fakatoake-ʻotomani" },
            { "pag", "lea fakapangasinani" },
            { "pal", "lea fakapālavi" },
            { "pam", "lea fakapamipanga" },
            { "pap", "lea fakapapiamēnito" },
            { "pau", "lea fakapalau" },
            { "pcd", "lea fakapikāti" },
            { "pcm", "lea fakanaisilia" },
            { "pdc", "lea fakasiamane-penisilivania" },
            { "pdt", "lea fakasiamane-lafalafa" },
            { "peo", "lea fakapēsia-motuʻa" },
            { "pfl", "lea fakasiamane-palatine" },
            { "phn", "lea fakafoinikia" },
            { "pis", "lea fakapisini" },
            { "pms", "lea fakapiemonite" },
            { "pnt", "lea fakaponitiki" },
            { "pon", "lea fakaponapē" },
            { "pqm", "lea fakamaliseti-pasamakuoti" },
            { "prg", "lea fakapulūsia" },
            { "pro", "lea fakapolovenisi-motuʻa" },
            { "quc", "lea fakakīsē" },
            { "qug", "lea fakakuitisa-simipolaso" },
            { "raj", "lea fakalasasitani" },
            { "rap", "lea fakalapanui" },
            { "rar", "lea fakalalotonga" },
            { "rgn", "lea fakalomaniolo" },
            { "rhg", "lea fakalouhingia" },
            { "rif", "lea fakalifi" },
            { "rof", "lea fakalomipō" },
            { "rom", "lea fakalomani" },
            { "rtm", "lea fakalotuma" },
            { "rue", "lea fakalusini" },
            { "rug", "lea fakaloviana" },
            { "rup", "lea fakaʻalomania" },
            { "rwk", "lea fakaluā" },
            { "sad", "lea fakasanitaue" },
            { "sah", "lea fakaiakuti" },
            { "sam", "lea fakasamalitani-ʻalāmiti" },
            { "saq", "lea fakasamipulu" },
            { "sas", "lea fakasasaki" },
            { "sat", "lea fakasanitali" },
            { "saz", "lea fakasaulasitilā" },
            { "sba", "lea fakangāmipai" },
            { "sbp", "lea fakasangu" },
            { "scn", "lea fakasisīlia" },
            { "sco", "lea fakasikotilani" },
            { "sdc", "lea fakasaletīnia-sasalesu" },
            { "sdh", "lea faka-tonga ‘o Ketesi" },
            { "see", "lea fakaseneka" },
            { "seh", "lea fakasena" },
            { "sei", "lea fakaseli" },
            { "sel", "lea fakaselikupi" },
            { "ses", "lea fakakoilapolo-seni" },
            { "sga", "lea fakaʻaelani-motuʻa" },
            { "sgs", "lea fakasamositia" },
            { "shi", "lea fakataselihiti" },
            { "shn", "lea fakasiani" },
            { "shu", "lea fakaʻalepea-sāti" },
            { "sid", "lea fakasitamo" },
            { "slh", "lea fakalusūtisiti" },
            { "sli", "lea fakasilesia-hifo" },
            { "sly", "lea fakaselaiā" },
            { "sma", "lea fakasami-tonga" },
            { "smj", "lea fakasami-lule" },
            { "smn", "lea fakasami-ʻinali" },
            { "sms", "lea fakasami-sikolita" },
            { "snk", "lea fakasoninekē" },
            { "sog", "lea fakasokitiana" },
            { "srn", "lea fakasulanane-tongikō" },
            { "srr", "lea fakasēlēle" },
            { "ssy", "lea fakasaho" },
            { "stq", "lea fakafilisia-satēlani" },
            { "str", "lea fakasalisi-vahatokelau" },
            { "suk", "lea fakasukuma" },
            { "sus", "lea fakasusū" },
            { "sux", "lea fakasumelia" },
            { "swb", "lea fakakomolo" },
            { "syc", "lea fakasuliāiā-muʻa" },
            { "syr", "lea fakasuliāiā" },
            { "szl", "lea fakasilesia" },
            { "tce", "lea fakatutisone-tonga" },
            { "tcy", "lea fakatulu" },
            { "tem", "lea fakatimenē" },
            { "teo", "lea fakateso" },
            { "ter", "lea fakateleno" },
            { "tet", "lea fakatetumu" },
            { "tgx", "lea fakatākisi" },
            { "tht", "lea fakatālitāni" },
            { "tig", "lea fakatikilē" },
            { "tiv", "lea fakativi" },
            { "tkl", "lea fakatokelau" },
            { "tkr", "lea fakasākuli" },
            { "tlh", "lea fakakilingoni" },
            { "tli", "lea fakatilingikīte" },
            { "tly", "lea fakatalisi" },
            { "tmh", "lea fakatamasieki" },
            { "tog", "lea fakaniasa-tonga" },
            { "tok", "lea fakatoki-pona" },
            { "tpi", "lea fakatoki-pisini" },
            { "tru", "lea fakatuloio" },
            { "trv", "lea fakataloko" },
            { "tsd", "lea fakasakōnia" },
            { "tsi", "lea fakatisīmisiani" },
            { "ttm", "lea fakatutisone-tokelau" },
            { "ttt", "lea fakatati-moselemi" },
            { "tum", "lea fakatumepuka" },
            { "tvl", "lea fakatūvalu" },
            { "twq", "lea fakatasauaki" },
            { "tyv", "lea fakatuvīnia" },
            { "tzm", "lea fakatamasaiti-ʻatilasi-loloto" },
            { "udm", "lea fakaʻutimuliti" },
            { "uga", "lea fakaʻūkaliti" },
            { "umb", "lea fakaʻumipūnitu" },
            { "und", "lea taʻeʻiloa" },
            { "vai", "lea fakavai" },
            { "vec", "lea fakavenēsia" },
            { "vep", "lea fakavepisi" },
            { "vls", "lea fakavelamingi-hihifo" },
            { "vmf", "lea fakafalanikoni-loloto" },
            { "vot", "lea fakavotiki" },
            { "vro", "lea fakavōlo" },
            { "vun", "lea fakavūniso" },
            { "wae", "lea fakaʻualiseli" },
            { "wal", "lea fakaʻuolaita" },
            { "war", "lea fakaʻualai" },
            { "was", "lea fakaʻuasiō" },
            { "wbp", "lea fakaʻuālipili" },
            { "wuu", "lea fakasiaina-uū" },
            { "xal", "lea fakakalimiki" },
            { "xmf", "lea fakamingilelia" },
            { "xog", "lea fakasoka" },
            { "yao", "lea fakaʻiao" },
            { "yap", "lea fakaʻiapi" },
            { "yav", "lea fakaʻiangipeni" },
            { "ybb", "lea fakaʻiēmipa" },
            { "yrl", "lea fakaneʻēngatū" },
            { "yue", "lea fakakuangitongi" },
            { "zap", "lea fakasapoteki" },
            { "zbl", "lea fakaʻilonga-pilisi" },
            { "zea", "lea fakasēlani" },
            { "zen", "lea fakasenaka" },
            { "zgh", "lea fakatamasaiti-moloko" },
            { "zun", "lea fakasuni" },
            { "zxx", "ʻikai ha lea" },
            { "zza", "lea fakasāsā" },
            { "Adlm", "tohinima fakaʻatilami" },
            { "Afak", "tohinima fakaʻafaka" },
            { "Aghb", "tohinima fakaʻalapēnia-kaukasia" },
            { "Arab", "tohinima fakaʻalepea" },
            { "Aran", "tohinima fakanasatalīki" },
            { "Armi", "tohinima fakaʻalāmiti-ʻemipaea" },
            { "Armn", "tohinima fakaʻāmenia" },
            { "Avst", "tohinima fakaʻavesitani" },
            { "Bali", "tohinima fakapali" },
            { "Bamu", "tohinima fakapamumi" },
            { "Bass", "tohinima fakapasa-vā" },
            { "Batk", "tohinima fakapātaki" },
            { "Beng", "tohinima fakapāngilā" },
            { "Blis", "tohinima fakaʻilonga-pilisi" },
            { "Bopo", "tohinima fakapopomofo" },
            { "Brah", "tohinima fakapalāmī" },
            { "Brai", "tohinima laukonga ki he kui" },
            { "Bugi", "tohinima fakapukisi" },
            { "Buhd", "tohinima fakapuhiti" },
            { "Cakm", "tohinima fakasakimā" },
            { "Cans", "tohinima fakatupuʻi-kānata-fakatahataha" },
            { "Cari", "tohinima fakakali" },
            { "Cham", "tohinima fakasami" },
            { "Cher", "tohinima fakaselokī" },
            { "Cirt", "tohinima fakakīliti" },
            { "Copt", "tohinima fakakopitika" },
            { "Cprt", "tohinima fakasaipalesi" },
            { "Cyrl", "tohinima fakalūsia" },
            { "Cyrs", "tohinima fakalūsia-lotu-motuʻa" },
            { "Deva", "tohinima fakaʻinitia-tevanākalī" },
            { "Dsrt", "tohinima fakateseleti" },
            { "Dupl", "tohinimanounou fakatupoloiē" },
            { "Egyd", "tohinima temotika-fakaʻisipite" },
            { "Egyh", "tohinima hielatika-fakaʻisipite" },
            { "Egyp", "tohinima tongitapu-fakaʻisipite" },
            { "Elba", "tohinima fakaʻelepasani" },
            { "Ethi", "tohinima fakaʻītiōpia" },
            { "Geok", "tohinima fakakutusuli-seōsia" },
            { "Geor", "tohinima fakaseōsia" },
            { "Glag", "tohinima fakakalakoliti" },
            { "Goth", "tohinima fakakotika" },
            { "Gran", "tohinima fakasilanitā" },
            { "Grek", "tohinima fakakalisi" },
            { "Gujr", "tohinima fakaʻinitia-kutalati" },
            { "Guru", "tohinima fakakūmuki" },
            { "Hanb", "tohinima fakahānipi" },
            { "Hang", "tohinima fakakōlea-hāngūlu" },
            { "Hani", "tohinima fakasiaina" },
            { "Hano", "tohinima fakahanunōʻo" },
            { "Hans", "fakafaingofua" },
            { "Hant", metaValue_Hant },
            { "Hebr", "tohinima fakahepelū" },
            { "Hira", "tohinima fakasiapani-hilakana" },
            { "Hluw", "tohinima tongitapu-fakaʻanatolia" },
            { "Hmng", "tohinima fakapahaumongi" },
            { "Hrkt", "tohinima fakasilapa-siapani" },
            { "Hung", "tohinima fakahungakalia-motuʻa" },
            { "Inds", "tohinima fakaʻinitusi" },
            { "Ital", "tohinima fakaʻītali-motuʻa" },
            { "Jamo", "tohinima fakasamo" },
            { "Java", "tohinima fakasava" },
            { "Jpan", "tohinima fakasiapani" },
            { "Jurc", "tohinima fakaiūkeni" },
            { "Kali", "tohinima fakakaialī" },
            { "Kana", "tohinima fakasiapani-katakana" },
            { "Khar", "tohinima fakakalositī" },
            { "Khmr", "tohinima fakakamipōtia" },
            { "Khoj", "tohinima fakakosikī" },
            { "Knda", "tohinima fakaʻinitia-kanata" },
            { "Kore", "tohinima fakakōlea" },
            { "Kpel", "tohinima fakakepele" },
            { "Kthi", "tohinima fakakaiatī" },
            { "Lana", "tohinima fakalana" },
            { "Laoo", "tohinima fakalau" },
            { "Latf", "tohinima fakalatina-falakituli" },
            { "Latg", "tohinima fakalatina-kaeliki" },
            { "Latn", "tohinima fakalatina" },
            { "Lepc", "tohinima fakalepasā" },
            { "Limb", "tohinima fakalimipū" },
            { "Lina", "tohinima fakalinea-A" },
            { "Linb", "tohinima fakalinea-P" },
            { "Lisu", "tohinima fakafalāse" },
            { "Loma", "tohinima fakaloma" },
            { "Lyci", "tohinima fakalīsia" },
            { "Lydi", "tohinima fakalītia" },
            { "Mahj", "tohinima fakamahasani" },
            { "Mand", "tohinima fakamanitaea" },
            { "Mani", "tohinima fakamanikaea" },
            { "Maya", "tohinima tongitapu fakamaia" },
            { "Mend", "tohinima fakamēniti" },
            { "Merc", "tohinima fakameloue-heihei" },
            { "Mero", "tohinima fakameloue" },
            { "Mlym", "tohinima fakaʻinitia-malāialami" },
            { "Modi", "tohinima fakamotī" },
            { "Mong", "tohinima fakamongokōlia" },
            { "Moon", "tohinima laukonga ki he kui-māhina" },
            { "Mroo", "tohinima fakamolō" },
            { "Mtei", "tohinima fakametei-maieki" },
            { "Mymr", "tohinima fakapema" },
            { "Narb", "tohinima fakaʻalepea-tokelau-motuʻa" },
            { "Nbat", "tohinima fakanapatea" },
            { "Nkgb", "tohinima fakanati-sepa" },
            { "Nkoo", "tohinima fakanikō" },
            { "Nshu", "tohinima fakanasiū" },
            { "Ogam", "tohinima fakaʻokami" },
            { "Olck", "tohinima fakaʻolisiki" },
            { "Orkh", "tohinima fakaʻolikoni" },
            { "Orya", "tohinima fakaʻotia" },
            { "Osma", "tohinima fakaʻosimānia" },
            { "Palm", "tohinima fakapalamilene" },
            { "Pauc", "tohinima fakapausinihau" },
            { "Perm", "tohinima fakapēmi-motuʻa" },
            { "Phag", "tohinima fakapākisipā" },
            { "Phli", "tohinima fakapālavi-tongi" },
            { "Phlp", "tohinima fakapālavi-saame" },
            { "Phlv", "tohinima fakapālavi-tohi" },
            { "Phnx", "tohinima fakafoinikia" },
            { "Plrd", "tohinima fakafonētiki-polāti" },
            { "Prti", "tohinima fakapātia-tongi" },
            { "Rjng", "tohinima fakalesiangi" },
            { "Rohg", "tohinima fakahanifi-lohingia" },
            { "Roro", "tohinima fakalongolongo" },
            { "Runr", "tohinima fakaluniki" },
            { "Samr", "tohinima fakasamalitane" },
            { "Sara", "tohinima fakasalati" },
            { "Sarb", "tohinima fakaʻalepea-tonga-motuʻa" },
            { "Saur", "tohinima fakasaulasitā" },
            { "Sgnw", "tohinima fakaʻilonga-tohi" },
            { "Shaw", "tohinima fakasiavi" },
            { "Shrd", "tohinima fakasiālatā" },
            { "Sidd", "tohinima fakasititami" },
            { "Sind", "tohinima fakakutauāti" },
            { "Sinh", "tohinima fakasingihala" },
            { "Sora", "tohinima fakasolasomipengi" },
            { "Sund", "tohinima fakasunitā" },
            { "Sylo", "tohinima fakasailoti-nakili" },
            { "Syrc", "tohinima fakasuliāiā" },
            { "Syre", "tohinima fakasuliāiā-ʻesitelangelo" },
            { "Syrj", "tohinima fakasuliāiā-hihifo" },
            { "Syrn", "tohinima fakasuliāiā-hahake" },
            { "Tagb", "tohinima fakatakipaneuā" },
            { "Takr", "tohinima fakatakili" },
            { "Tale", "tohinima fakatai-lue" },
            { "Talu", "tohinima fakatai-lue-foʻou" },
            { "Taml", "tohinima fakatamili" },
            { "Tang", "tohinima fakatanguti" },
            { "Tavt", "tohinima fakatai-vieti" },
            { "Telu", "tohinima fakaʻinitia-teluku" },
            { "Teng", "tohinima fakatengiuali" },
            { "Tfng", "tohinima fakatifināki" },
            { "Tglg", "tohinima fakatakaloka" },
            { "Thaa", "tohinima fakatāna" },
            { "Thai", "tohinima fakatailani" },
            { "Tibt", "tohinima fakataipeti" },
            { "Tirh", "tohinima fakatīhuta" },
            { "Ugar", "tohinima fakaʻūkaliti" },
            { "Vaii", "tohinima fakavai" },
            { "Visp", "tohinima fakafonētiki-hāmai" },
            { "Wara", "tohinima fakavalangi-kisitī" },
            { "Wole", "tohinima fakauoleai" },
            { "Xpeo", "tohinima fakapēsiamuʻa" },
            { "Xsux", "tohinima fakamataʻingahau-sumelo-akatia" },
            { "Yiii", "tohinima fakaīī" },
            { "Zinh", "tohinima hokosi" },
            { "Zmth", "tohinima fakamatematika" },
            { "Zsye", "tohinima fakatātā" },
            { "Zsym", "tohinima fakaʻilonga" },
            { "Zxxx", "tohinima taʻetohitohiʻi" },
            { "Zyyy", "tohinima fakatatau" },
            { "Zzzz", "tohinima taʻeʻiloa" },
            { "de_AT", "lea fakasiamane-ʻaositulia" },
            { "de_CH", "lea fakasiamane-hake-suisilani" },
            { "en_AU", "lea fakapālangi-ʻaositelēlia" },
            { "en_CA", "lea fakapālangi-kānata" },
            { "en_GB", "lea fakapilitānia" },
            { "en_US", "lea fakapālangi-ʻamelika" },
            { "es_ES", "lea fakasipeini-ʻeulope" },
            { "es_MX", "lea fakasipeini-mekisikou" },
            { "fa_AF", "lea fakapēsia (ʻtalī)" },
            { "fr_CA", "lea fakafalanisē-kānata" },
            { "fr_CH", "lea fakafalanisē-suisilani" },
            { "nl_BE", "lea fakahōlani-pelesiume" },
            { "ro_MD", "lea fakamolitāvia" },
            { "sw_CD", "lea fakasuahili-kongikō" },
            { "ar_001", "lea fakaʻalepea (māmani)" },
            { "es_419", "lea fakasipeini-lātini-ʻamelika" },
            { "key.ca", "tohi māhina" },
            { "key.cf", "anga paʻanga" },
            { "key.co", "tohi hokohoko" },
            { "key.cu", "paʻanga" },
            { "key.hc", "takai houa" },
            { "key.lb", "fesiʻilaine" },
            { "key.ms", "founga fakafuofua" },
            { "key.nu", "fika" },
            { "nds_NL", "lea fakasakisoni-hifo" },
            { "hi_Latn", "lea fakahinitī (fakalatina)" },
            { "zh_Hans", "lea fakasiaina-fakafaingofua" },
            { "zh_Hant", "lea fakasiaina-tukufakaholo" },
            { "type.ca.roc", "fakalepupelika siaina" },
            { "type.hc.h11", "takai houa 0–11" },
            { "type.hc.h12", "takai houa 1–12" },
            { "type.hc.h23", "takai houa 0–23" },
            { "type.hc.h24", "takai houa 1–24" },
            { "type.nu.arab", "fika fakaʻalepea" },
            { "type.nu.armn", "fika fakaʻāmenia" },
            { "type.nu.beng", "faka fakapāngilā" },
            { "type.nu.cakm", "fika fakakakema" },
            { "type.nu.deva", "fika fakatevanākalī" },
            { "type.nu.ethi", "fika fakaʻītiōpia" },
            { "type.nu.geor", "fika fakaseōsia" },
            { "type.nu.grek", "fika fakakalisi" },
            { "type.nu.gujr", "fika fakakutalati" },
            { "type.nu.guru", "fika fakakūmuki" },
            { "type.nu.hans", "fika fakasiaina fakafaingofua" },
            { "type.nu.hant", "fika fakasiaina tukufakaholo" },
            { "type.nu.hebr", "fika fakahepelū" },
            { "type.nu.java", "fika fakasava" },
            { "type.nu.jpan", "fika fakasiapani" },
            { "type.nu.khmr", "fika fakakamipōtia" },
            { "type.nu.knda", "fika fakakanata" },
            { "type.nu.laoo", "fika fakalau" },
            { "type.nu.latn", "fika fakalatina" },
            { "type.nu.mlym", "fika fakamalāialami" },
            { "type.nu.mtei", "fika fakametei-maieki" },
            { "type.nu.mymr", "fika fakapema" },
            { "type.nu.nkoo", "fika fakanikō" },
            { "type.nu.olck", "fika fakaʻolisiki" },
            { "type.nu.orya", "fika fakaʻotia" },
            { "type.nu.taml", "fika fakatamili tukufakaholo" },
            { "type.nu.telu", "fika fakateluku" },
            { "type.nu.thai", "fika fakatailani" },
            { "type.nu.tibt", "fika fakatipeti" },
            { "type.nu.vaii", "fika fakavai" },
            { "type.ca.dangi", "fakataniki" },
            { "type.co.ducet", "ʻunikōti" },
            { "type.lb.loose", "fesiʻilaine ngaloku" },
            { "type.nu.roman", "fika fakaloma" },
            { "type.ca.coptic", "fakakopitika" },
            { "type.ca.hebrew", "fakahepelū" },
            { "type.ca.indian", "fakaʻinitia" },
            { "type.co.search", "fakakumi ʻi hono anga lahi" },
            { "type.lb.normal", "fesiʻilaine faʻafai" },
            { "type.lb.strict", "fesiʻilaine mafao" },
            { "type.ms.metric", "founga fakamita" },
            { "type.ca.chinese", "fakasiaina" },
            { "type.ca.islamic", "fakamohameti" },
            { "type.ca.iso8601", "faka-iso8601" },
            { "type.ca.persian", "fakapēsia" },
            { "type.cf.account", "anga paʻanga-kalake" },
            { "type.nu.arabext", "fika fakaʻalepea fakalahi" },
            { "type.nu.armnlow", "fika fakaʻāmenia fakalalo" },
            { "type.nu.greklow", "fika fakakalisi fakalalo" },
            { "type.nu.hanidec", "fika fakasiaina" },
            { "type.nu.hansfin", "fika fakasiaina fakafaingofua fakapaʻanga" },
            { "type.nu.hantfin", "fika fakasiaina tukufakaholo fakapaʻanga" },
            { "type.nu.jpanfin", "fika fakasiapani fakapaʻanga" },
            { "type.nu.tamldec", "fika fakatamili" },
            { "type.ca.buddhist", "fakaputa" },
            { "type.ca.ethiopic", "fakaʻītiōpia" },
            { "type.ca.japanese", "fakasiapani" },
            { "type.cf.standard", "anga paʻanga-sīpinga" },
            { "type.co.standard", "fakasīpinga" },
            { "type.ms.uksystem", "founga fakapilitānia" },
            { "type.ms.ussystem", "founga fakaʻamelika" },
            { "type.nu.fullwide", "fika laulahi" },
            { "type.nu.romanlow", "fika fakaloma fakalalo" },
            { "type.ca.gregorian", "fakakelekolia" },
            { "type.co.phonebook", "fika telefoni" },
            { "type.co.traditional", metaValue_Hant },
            { "type.ca.islamic-civil", "fakamohameti-sivile" },
            { "type.ca.islamic-umalqura", "fakamohameti-ʻumalakula" },
            { "type.ca.ethiopic-amete-alem", "fakaʻītiōpia-ʻamete-ʻalemi" },
        };
        return data;
    }
}
