/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.IOException;
import java.util.zip.Inflater;
import jdk.internal.jimage.decompressor.ResourceDecompressor;

final class ZipDecompressor
implements ResourceDecompressor {
    ZipDecompressor() {
    }

    @Override
    public String getName() {
        return "zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] decompress(byte[] bytesIn, int offset, long originalSize) throws Exception {
        if (originalSize > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Required array size too large");
        }
        byte[] bytesOut = new byte[(int)originalSize];
        int count = 0;
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(bytesIn, offset, bytesIn.length - offset);
            while (!inflater.finished() && (long)count < originalSize) {
                count += inflater.inflate(bytesOut, count, bytesOut.length - count);
            }
        }
        finally {
            inflater.end();
        }
        if ((long)count != originalSize) {
            throw new IOException("Resource content size mismatch");
        }
        return bytesOut;
    }

    @Override
    public byte[] decompress(ResourceDecompressor.StringsProvider reader, byte[] content, int offset, long originalSize) throws Exception {
        byte[] decompressed = ZipDecompressor.decompress(content, offset, originalSize);
        return decompressed;
    }
}

