/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_am extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CA = "\u12ab\u1293\u12f3";
        final String metaValue_NR = "\u1293\u12a1\u1229";
        final String metaValue_TV = "\u1271\u126b\u1209";
        final String metaValue_ar = "\u12d3\u1228\u1265\u129b";
        final String metaValue_ccp = "\u127b\u12ad\u121b";
        final String metaValue_cop = "\u12ae\u1355\u1272\u12ad";
        final String metaValue_GR = "\u130d\u122a\u12ad";
        final String metaValue_ja = "\u1303\u1353\u1295\u129b";
        final String metaValue_ko = "\u12ae\u122a\u12eb\u129b";
        final String metaValue_mn = "\u121e\u1295\u130e\u120a\u12eb\u129b";
        final String metaValue_nqo = "\u1295\u12ae";
        final String metaValue_or = "\u12a6\u12f2\u12eb";
        final String metaValue_si = "\u1232\u1295\u1203\u120b";
        final String metaValue_su = "\u1231\u12f3\u1295\u129b";
        final String metaValue_syr = "\u1232\u122a\u12eb\u12ad";
        final String metaValue_ta = "\u1273\u121a\u120d";
        final String metaValue_te = "\u1270\u1209\u1309";
        final String metaValue_th = "\u1273\u12ed";
        final String metaValue_vai = "\u126b\u12ed";
        final Object[][] data = new Object[][] {
            { "001", "\u12d3\u1208\u121d" },
            { "002", "\u12a0\u134d\u122a\u12ab" },
            { "003", "\u1230\u121c\u1295 \u12a0\u121c\u122a\u12ab" },
            { "005", "\u12f0\u1261\u1265 \u12a0\u121c\u122a\u12ab" },
            { "009", "\u12a6\u123a\u12eb\u1295\u12eb" },
            { "011", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "013", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u121c\u122a\u12ab" },
            { "014", "\u121d\u1235\u122b\u1245 \u12a0\u134d\u122a\u12ab" },
            { "015", "\u1230\u121c\u1293\u12ca \u12a0\u134d\u122a\u12ab" },
            { "017", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab" },
            { "018", "\u12f0\u1261\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "019", "\u12a0\u121c\u122a\u12ab" },
            { "021", "\u1230\u121c\u1293\u12ca \u12a0\u121c\u122a\u12ab" },
            { "029", "\u12ab\u122a\u1262\u12eb\u1295" },
            { "030", "\u121d\u1235\u122b\u1243\u12ca \u12a5\u1235\u12eb" },
            { "034", "\u12f0\u1261\u1263\u12ca \u12a5\u1235\u12eb" },
            { "035", "\u12f0\u1261\u1265 \u121d\u1235\u122b\u1245 \u12a5\u1235\u12eb" },
            { "039", "\u12f0\u1261\u1263\u12ca \u12a0\u12cd\u122e\u1353" },
            { "053", "\u12a0\u12cd\u1235\u1275\u122b\u120c\u12e5\u12eb" },
            { "054", "\u121c\u120b\u1294\u12e5\u12eb" },
            { "057", "\u12e8\u121b\u12ed\u12ad\u122e\u1294\u12e5\u12eb\u1295 \u12ad\u120d\u120d" },
            { "061", "\u1356\u120a\u1294\u12e5\u12eb" },
            { "142", "\u12a5\u1235\u12eb" },
            { "143", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a5\u1235\u12eb" },
            { "145", "\u121d\u12d5\u122b\u1263\u12ca \u12a5\u1235\u12eb" },
            { "150", "\u12a0\u12cd\u122e\u1353" },
            { "151", "\u121d\u1235\u122b\u1245 \u12a0\u12cd\u122e\u1353" },
            { "154", "\u1230\u121c\u1293\u12ca \u12a0\u12cd\u122e\u1353" },
            { "155", "\u121d\u12d5\u122b\u1265 \u12a0\u12cd\u122e\u1353" },
            { "202", "\u12a8\u1230\u1203\u122b \u1260\u1273\u127d \u12a0\u134d\u122a\u12ab" },
            { "419", "\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab" },
            { "AC", "\u12a0\u1234\u1295\u123d\u1295 \u12f0\u1234\u1275" },
            { "AD", "\u12a0\u1295\u12f6\u122b" },
            { "AE", "\u12e8\u1270\u1263\u1260\u1229\u1275 \u12d3\u1228\u1265 \u12a4\u121d\u122c\u1275\u1235" },
            { "AF", "\u12a0\u134d\u130b\u1292\u1235\u1273\u1295" },
            { "AG", "\u12a0\u1295\u1272\u1313 \u12a5\u1293 \u1263\u122d\u1261\u12f3" },
            { "AI", "\u12a0\u1295\u1309\u12ed\u120b" },
            { "AL", "\u12a0\u120d\u1263\u1292\u12eb" },
            { "AM", "\u12a0\u122d\u121c\u1292\u12eb" },
            { "AO", "\u12a0\u1295\u1310\u120b" },
            { "AQ", "\u12a0\u1295\u1273\u122d\u12ad\u1272\u12ab" },
            { "AR", "\u12a0\u122d\u1300\u1295\u1272\u1293" },
            { "AS", "\u12e8\u12a0\u121c\u122a\u12ab \u1233\u121e\u12a0" },
            { "AT", "\u12a6\u1235\u1275\u122a\u12eb" },
            { "AU", "\u12a0\u12cd\u1235\u1275\u122b\u120d\u12eb" },
            { "AW", "\u12a0\u1229\u1263" },
            { "AX", "\u12e8\u12a0\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "AZ", "\u12a0\u12d8\u122d\u1263\u1303\u1295" },
            { "BA", "\u1266\u1235\u1292\u12eb \u12a5\u1293 \u1204\u122d\u12de\u130e\u126a\u1292\u12eb" },
            { "BB", "\u1263\u122d\u1264\u12f6\u1235" },
            { "BD", "\u1263\u1295\u130d\u120b\u12f2\u123d" },
            { "BE", "\u1264\u120d\u1304\u121d" },
            { "BF", "\u1261\u122d\u12aa\u1293 \u134b\u1236" },
            { "BG", "\u1261\u120d\u130b\u122a\u12eb" },
            { "BH", "\u1263\u1205\u122c\u1295" },
            { "BI", "\u1265\u1229\u1295\u12f2" },
            { "BJ", "\u1264\u1292\u1295" },
            { "BL", "\u1234\u1295\u1275 \u1263\u122d\u1274\u120c\u121a" },
            { "BM", "\u1264\u122d\u1219\u12f3" },
            { "BN", "\u1265\u1229\u1292" },
            { "BO", "\u1266\u120a\u126a\u12eb" },
            { "BQ", "\u12e8\u12ab\u122a\u1262\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5\u1235" },
            { "BR", "\u1265\u122b\u12da\u120d" },
            { "BS", "\u1263\u1203\u121b\u1235" },
            { "BT", "\u1261\u1205\u1273\u1295" },
            { "BV", "\u1261\u126c\u1275 \u12f0\u1234\u1275" },
            { "BW", "\u1266\u1275\u1235\u12cb\u1293" },
            { "BY", "\u1264\u120b\u1229\u1235" },
            { "BZ", "\u1260\u120a\u12dd" },
            { "CA", metaValue_CA },
            { "CC", "\u12ae\u12ae\u1235(\u12ac\u120a\u1295\u130d) \u12f0\u1234\u1276\u127d" },
            { "CD", "\u12ae\u1295\u130e-\u12aa\u1295\u123b\u1233" },
            { "CF", "\u121b\u12d5\u12a8\u120b\u12ca \u12a0\u134d\u122a\u12ab \u122a\u1351\u1265\u120a\u12ad" },
            { "CG", "\u12ae\u1295\u130e \u1265\u122b\u12db\u126a\u120d" },
            { "CH", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5" },
            { "CI", "\u12ae\u1275\u12f2\u126f\u122d" },
            { "CK", "\u12a9\u12ad \u12f0\u1234\u1276\u127d" },
            { "CL", "\u127a\u120a" },
            { "CM", "\u12ab\u121c\u1229\u1295" },
            { "CN", "\u127b\u12ed\u1293" },
            { "CO", "\u12ae\u120e\u121d\u1262\u12eb" },
            { "CP", "\u12ad\u120a\u1350\u122d\u1276\u1295 \u12f0\u1234\u1275" },
            { "CR", "\u12ae\u1235\u1273\u122a\u12ab" },
            { "CU", "\u12a9\u1263" },
            { "CV", "\u12ac\u1355\u1268\u122d\u12f4" },
            { "CW", "\u12a9\u122b\u1233\u12ce" },
            { "CX", "\u12ad\u122a\u1235\u121b\u1235 \u12f0\u1234\u1275" },
            { "CY", "\u1233\u12ed\u1355\u1228\u1235" },
            { "CZ", "\u127c\u127a\u12eb" },
            { "DE", "\u1300\u122d\u1218\u1295" },
            { "DG", "\u12f2\u12ec\u130e \u130b\u122d\u1232\u12eb" },
            { "DJ", "\u1302\u1261\u1272" },
            { "DK", "\u12f4\u1295\u121b\u122d\u12ad" },
            { "DM", "\u12f6\u121a\u1292\u12ab" },
            { "DO", "\u12f6\u1218\u1292\u12ab\u1295 \u122a\u1351\u1265\u120a\u12ad" },
            { "DZ", "\u12a0\u120d\u1304\u122a\u12eb" },
            { "EA", "\u1234\u12a1\u1273\u1293 \u121c\u120a\u120b" },
            { "EC", "\u12a2\u12b3\u12f6\u122d" },
            { "EE", "\u12a4\u1235\u1276\u1292\u12eb" },
            { "EG", "\u130d\u1265\u133d" },
            { "EH", "\u121d\u12d5\u122b\u1263\u12ca \u1233\u1205\u122b" },
            { "ER", "\u12a4\u122d\u1275\u122b" },
            { "ES", "\u1235\u1354\u1295" },
            { "ET", "\u12a2\u1275\u12ee\u1335\u12eb" },
            { "EU", "\u12e8\u12a0\u12cd\u122e\u1353 \u1205\u1265\u1228\u1275" },
            { "EZ", "\u12e8\u12e9\u122e \u12de\u1295" },
            { "FI", "\u134a\u1295\u120b\u1295\u12f5" },
            { "FJ", "\u134a\u1302" },
            { "FK", "\u12e8\u134e\u12ad\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "FM", "\u121b\u12ed\u12ad\u122e\u1294\u12e2\u12eb" },
            { "FO", "\u12e8\u134b\u122e \u12f0\u1234\u1276\u127d" },
            { "FR", "\u1348\u1228\u1295\u1233\u12ed" },
            { "GA", "\u130b\u1266\u1295" },
            { "GB", "\u12e9\u1293\u12ed\u1275\u12f5 \u12aa\u1295\u130d\u12f0\u121d" },
            { "GD", "\u130d\u122c\u1293\u12f3" },
            { "GE", "\u1306\u122d\u1302\u12eb" },
            { "GF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1309\u12ca\u12a0\u1293" },
            { "GG", "\u1309\u122d\u1290\u1232" },
            { "GH", "\u130b\u1293" },
            { "GI", "\u1302\u1265\u122b\u120d\u1270\u122d" },
            { "GL", "\u130d\u122a\u1295\u120b\u1295\u12f5" },
            { "GM", "\u130b\u121d\u1262\u12eb" },
            { "GN", "\u130a\u1292" },
            { "GP", "\u1309\u12cb\u12f0\u1209\u1355" },
            { "GQ", "\u12a2\u12b3\u1276\u122a\u12eb\u120d \u130a\u1292" },
            { "GR", metaValue_GR },
            { "GS", "\u12f0\u1261\u1265 \u1306\u122d\u1302\u12eb \u12a5\u1293 \u12e8\u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d \u12f0\u1234\u1276\u127d" },
            { "GT", "\u1309\u12cb\u1272\u121b\u120b" },
            { "GU", "\u1309\u12cb\u121d" },
            { "GW", "\u130a\u1292-\u1262\u1233\u12cd" },
            { "GY", "\u1309\u12eb\u1293" },
            { "HK", "\u1206\u1295\u130d \u12ae\u1295\u130d \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293" },
            { "HM", "\u12bd\u122d\u12f5 \u12a3\u1293 \u121b\u12ad\u12f6\u1293\u120d\u12f5 \u12f0\u1234\u1276\u127d" },
            { "HN", "\u1206\u1295\u12f1\u122b\u1235" },
            { "HR", "\u12ad\u122e\u12a4\u123d\u12eb" },
            { "HT", "\u1200\u12ed\u1272" },
            { "HU", "\u1200\u1295\u130b\u122a" },
            { "IC", "\u12e8\u12ab\u1293\u122a \u12f0\u1234\u1276\u127d" },
            { "ID", "\u12a2\u1295\u12f6\u1294\u12e2\u12eb" },
            { "IE", "\u12a0\u12e8\u122d\u120b\u1295\u12f5" },
            { "IL", "\u12a5\u1235\u122b\u12a4\u120d" },
            { "IM", "\u12a0\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "IN", "\u1205\u1295\u12f5" },
            { "IO", "\u12e8\u1265\u122a\u1273\u1292\u12eb \u1205\u1295\u12f5 \u12cd\u1242\u12eb\u1296\u1235 \u130d\u12db\u1275" },
            { "IQ", "\u12a2\u122b\u1245" },
            { "IR", "\u12a2\u122b\u1295" },
            { "IS", "\u12a0\u12ed\u1235\u120b\u1295\u12f5" },
            { "IT", "\u1323\u120a\u12eb\u1295" },
            { "JE", "\u1300\u122d\u12da" },
            { "JM", "\u1303\u121b\u12ed\u12ab" },
            { "JO", "\u1306\u122d\u12f3\u1295" },
            { "JP", "\u1303\u1353\u1295" },
            { "KE", "\u12ac\u1295\u12eb" },
            { "KG", "\u12aa\u122d\u130a\u1235\u1273\u1295" },
            { "KH", "\u12ab\u121d\u1266\u12f2\u12eb" },
            { "KI", "\u12aa\u122a\u1263\u1272" },
            { "KM", "\u12ae\u121e\u122e\u1235" },
            { "KN", "\u1245\u12f1\u1235 \u12aa\u1275\u1235 \u12a5\u1293 \u1294\u126a\u1235" },
            { "KP", "\u1230\u121c\u1295 \u12ae\u122a\u12eb" },
            { "KR", "\u12f0\u1261\u1265 \u12ae\u122a\u12eb" },
            { "KW", "\u12a9\u12cc\u1275" },
            { "KY", "\u12ab\u12ed\u121b\u1295 \u12f0\u1234\u1276\u127d" },
            { "KZ", "\u12ab\u12db\u12aa\u1235\u1273\u1295" },
            { "LA", "\u120b\u12a6\u1235" },
            { "LB", "\u120a\u1263\u1296\u1235" },
            { "LC", "\u1234\u1295\u1275 \u1209\u127a\u12eb" },
            { "LI", "\u120a\u127d\u1270\u1295\u1235\u1273\u12ed\u1295" },
            { "LK", "\u1232\u122a\u120b\u1295\u12ab" },
            { "LR", "\u120b\u12ed\u1264\u122a\u12eb" },
            { "LS", "\u120c\u1236\u1276" },
            { "LT", "\u120a\u1271\u12cc\u1292\u12eb" },
            { "LU", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "LV", "\u120b\u1275\u126a\u12eb" },
            { "LY", "\u120a\u1262\u12eb" },
            { "MA", "\u121e\u122e\u12ae" },
            { "MC", "\u121e\u1293\u12ae" },
            { "MD", "\u121e\u120d\u12f6\u126b" },
            { "ME", "\u121e\u1295\u1270\u1294\u130d\u122e" },
            { "MF", "\u1234\u1295\u1275 \u121b\u122d\u1272\u1295" },
            { "MG", "\u121b\u12f3\u130b\u1235\u12ab\u122d" },
            { "MH", "\u121b\u122d\u123b\u120d \u12f0\u1234\u1276\u127d" },
            { "MK", "\u1230\u121c\u1295 \u1218\u1244\u12f6\u1295\u12eb" },
            { "ML", "\u121b\u120a" },
            { "MM", "\u121b\u12ed\u1293\u121b\u122d(\u1260\u122d\u121b)" },
            { "MN", "\u121e\u1295\u130e\u120a\u12eb" },
            { "MO", "\u121b\u12ab\u12a6 \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293" },
            { "MP", "\u12e8\u1230\u121c\u1293\u12ca \u121b\u122a\u12eb\u1293 \u12f0\u1234\u1276\u127d" },
            { "MQ", "\u121b\u122d\u1272\u1292\u12ad" },
            { "MR", "\u121e\u122a\u1274\u1292\u12eb" },
            { "MS", "\u121e\u1295\u1275\u1234\u122b\u1275" },
            { "MT", "\u121b\u120d\u1273" },
            { "MU", "\u121e\u122a\u1238\u1235" },
            { "MV", "\u121b\u120d\u12f2\u126d\u1235" },
            { "MW", "\u121b\u120b\u12ca" },
            { "MX", "\u121c\u12ad\u1232\u12ae" },
            { "MY", "\u121b\u120c\u12e2\u12eb" },
            { "MZ", "\u121e\u12db\u121d\u1262\u12ad" },
            { "NA", "\u1293\u121a\u1262\u12eb" },
            { "NC", "\u1292\u12cd \u12ab\u120c\u12f6\u1292\u12eb" },
            { "NE", "\u1292\u1300\u122d" },
            { "NF", "\u1296\u122d\u134e\u120d\u12ad \u12f0\u1234\u1275" },
            { "NG", "\u1293\u12ed\u1304\u122a\u12eb" },
            { "NI", "\u1292\u12ab\u122b\u1313" },
            { "NL", "\u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "NO", "\u1296\u122d\u12cc\u12ed" },
            { "NP", "\u1294\u1353\u120d" },
            { "NR", metaValue_NR },
            { "NU", "\u1292\u12cc" },
            { "NZ", "\u1292\u12cd \u12da\u120b\u1295\u12f5" },
            { "OM", "\u12a6\u121b\u1295" },
            { "PA", "\u1353\u1293\u121b" },
            { "PE", "\u1354\u1229" },
            { "PF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1294\u12e2\u12eb" },
            { "PG", "\u1353\u1351\u12cb \u1292\u12cd \u130a\u1292" },
            { "PH", "\u134a\u120a\u1352\u1295\u1235" },
            { "PK", "\u1353\u12aa\u1235\u1273\u1295" },
            { "PL", "\u1356\u120b\u1295\u12f5" },
            { "PM", "\u1234\u1295\u1275 \u1352\u12ec\u122d \u12a5\u1293 \u121a\u12a9\u12a4\u120e\u1295" },
            { "PN", "\u1352\u1275\u12ab\u12a2\u122d\u1295 \u12f0\u1234\u1276\u127d" },
            { "PR", "\u1351\u12cc\u122d\u1276 \u122a\u12ae" },
            { "PS", "\u12e8\u134d\u120d\u1235\u1324\u121d \u130d\u12db\u1275" },
            { "PT", "\u1356\u122d\u1271\u130b\u120d" },
            { "PW", "\u1353\u120b\u12cd" },
            { "PY", "\u1353\u122b\u1313\u12ed" },
            { "QA", "\u12b3\u1273\u122d" },
            { "QO", "\u12e8\u12a6\u123a\u12eb\u1295\u12eb \u12f3\u122d\u127b" },
            { "RE", "\u122a\u12e9\u1292\u12e8\u1295" },
            { "RO", "\u122e\u121c\u1292\u12eb" },
            { "RS", "\u1230\u122d\u1265\u12eb" },
            { "RU", "\u1229\u1235\u12eb" },
            { "RW", "\u1229\u12cb\u1295\u12f3" },
            { "SA", "\u1233\u12cd\u12f5\u12a0\u1228\u1262\u12eb" },
            { "SB", "\u1230\u1208\u121e\u1295 \u12f0\u1234\u1276\u127d" },
            { "SC", "\u1232\u123c\u120d\u1235" },
            { "SD", "\u1231\u12f3\u1295" },
            { "SE", "\u1235\u12ca\u12f5\u1295" },
            { "SG", "\u1232\u1295\u130b\u1356\u122d" },
            { "SH", "\u1234\u1295\u1275 \u1204\u1208\u1293" },
            { "SI", "\u1235\u120e\u126c\u1292\u12eb" },
            { "SJ", "\u1235\u126b\u120d\u1263\u122d\u12f5 \u12a5\u1293 \u1303\u1295 \u121b\u12e8\u1295" },
            { "SK", "\u1235\u120e\u126b\u12aa\u12eb" },
            { "SL", "\u1234\u122b\u120a\u12ee\u1295" },
            { "SM", "\u1233\u1295 \u121b\u122a\u1296" },
            { "SN", "\u1234\u1294\u130b\u120d" },
            { "SO", "\u1236\u121b\u120a\u12eb" },
            { "SR", "\u1231\u122a\u1293\u121d" },
            { "SS", "\u12f0\u1261\u1265 \u1231\u12f3\u1295" },
            { "ST", "\u1233\u12a6 \u1276\u121c \u12a5\u1293 \u1355\u122a\u1295\u1232\u1354" },
            { "SV", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "SX", "\u1232\u1295\u1275 \u121b\u122d\u1270\u1295" },
            { "SY", "\u1236\u122a\u12eb" },
            { "SZ", "\u12a4\u1235\u12cb\u1272\u1292" },
            { "TA", "\u1275\u122a\u1235\u1273\u1295 \u12f3 \u12a9\u1295\u1203" },
            { "TC", "\u12e8\u1271\u122d\u12ae\u127d\u1293 \u12e8\u12ab\u12a2\u12ae\u1235 \u12f0\u1234\u1276\u127d" },
            { "TD", "\u127b\u12f5" },
            { "TF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u12f0\u1261\u1263\u12ca \u130d\u12db\u1276\u127d" },
            { "TG", "\u1276\u1310" },
            { "TH", "\u1273\u12ed\u120b\u1295\u12f5" },
            { "TJ", "\u1273\u1303\u12aa\u1235\u1273\u1295" },
            { "TK", "\u1276\u12ad\u120b\u12cd" },
            { "TL", "\u1272\u121e\u122d \u120c\u1235\u1274" },
            { "TM", "\u1271\u122d\u12ad\u121c\u1292\u1235\u1273\u1295" },
            { "TN", "\u1271\u1292\u12da\u12eb" },
            { "TO", "\u1276\u1295\u130b" },
            { "TR", "\u1271\u122d\u12ad" },
            { "TT", "\u1275\u122a\u1293\u12f3\u12f5 \u12a5\u1293 \u1276\u1264\u130e" },
            { "TV", metaValue_TV },
            { "TW", "\u1273\u12ed\u12cb\u1295" },
            { "TZ", "\u1273\u1295\u12db\u1292\u12eb" },
            { "UA", "\u12e9\u12ad\u122c\u1295" },
            { "UG", "\u12e9\u130b\u1295\u12f3" },
            { "UM", "\u12e8\u12e9 \u12a4\u1235 \u1320\u1228\u134d \u120b\u12ed \u12eb\u1209 \u12f0\u1234\u1276\u127d" },
            { "UN", "\u12e8\u1270\u1263\u1260\u1229\u1275 \u1218\u1295\u130d\u1235\u1273\u1275" },
            { "US", "\u12e9\u1293\u12ed\u1275\u12f5 \u1235\u1274\u1275\u1235" },
            { "UY", "\u12a1\u122b\u1313\u12ed" },
            { "UZ", "\u12a1\u12dd\u1264\u12aa\u1235\u1273\u1295" },
            { "VA", "\u126b\u1272\u12ab\u1295 \u12a8\u1270\u121b" },
            { "VC", "\u1234\u1295\u1275 \u126a\u1295\u1234\u1295\u1275 \u12a5\u1293 \u130d\u122c\u1293\u12f2\u1295\u1235" },
            { "VE", "\u126c\u1295\u12d9\u12cc\u120b" },
            { "VG", "\u12e8\u12a5\u1295\u130d\u120a\u12dd \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "VI", "\u12e8\u12a0\u121c\u122a\u12ab \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "VN", "\u126c\u1275\u1293\u121d" },
            { "VU", "\u126b\u1291\u12a0\u1271" },
            { "WF", "\u12cb\u120a\u1235 \u12a5\u1293 \u1349\u1271\u1293 \u12f0\u1234\u1276\u127d" },
            { "WS", "\u1233\u121e\u12a0" },
            { "XA", "\u12e8\u1200\u1230\u1275 \u1275\u12a5\u121d\u122d\u1275" },
            { "XB", "\u12e8\u1200\u1230\u1275 \u1263\u1208\u1201\u1208\u1275 \u12a0\u1245\u1323\u132b" },
            { "XK", "\u12ae\u1236\u126e" },
            { "YE", "\u12e8\u1218\u1295" },
            { "YT", "\u121c\u12ed\u12a6\u1274" },
            { "ZA", "\u12f0\u1261\u1265 \u12a0\u134d\u122a\u12ab" },
            { "ZM", "\u12db\u121d\u1262\u12eb" },
            { "ZW", "\u12da\u121d\u1267\u1264" },
            { "ZZ", "\u12eb\u120d\u1273\u12c8\u1240 \u12ad\u120d\u120d" },
            { "aa", "\u12a0\u134b\u122d\u129b" },
            { "ab", "\u12a0\u1265\u1210\u12da\u129b" },
            { "ae", "\u12a0\u126c\u1235\u1273\u1295" },
            { "af", "\u12a0\u134d\u122a\u12ab\u1295\u129b" },
            { "ak", "\u12a0\u12ab\u1295\u129b" },
            { "am", "\u12a0\u121b\u122d\u129b" },
            { "an", "\u12a0\u122b\u130e\u1295\u1235" },
            { "ar", metaValue_ar },
            { "as", "\u12a0\u1233\u121c\u12dd" },
            { "av", "\u12a0\u126b\u122a\u12ad" },
            { "ay", "\u12a0\u12eb\u121b\u122d\u129b" },
            { "az", "\u12a0\u12d8\u122d\u1263\u1303\u1295\u129b" },
            { "ba", "\u1263\u1235\u12aa\u122d\u129b" },
            { "be", "\u1264\u120b\u122b\u123b\u129b" },
            { "bg", "\u1261\u120d\u130b\u122a\u129b" },
            { "bi", "\u1262\u1235\u120b\u121d\u129b" },
            { "bm", "\u1263\u121d\u1263\u122d\u129b" },
            { "bn", "\u1264\u1295\u130b\u120a\u129b" },
            { "bo", "\u1272\u1264\u1273\u1295\u129b" },
            { "br", "\u1265\u122c\u1276\u1295\u129b" },
            { "bs", "\u1266\u1235\u1292\u12eb\u1295\u129b" },
            { "ca", "\u12ab\u1273\u120b\u1295\u129b" },
            { "ce", "\u127d\u127d\u1295" },
            { "ch", "\u127b\u121e\u122e" },
            { "co", "\u12ae\u122d\u1232\u12ab\u129b" },
            { "cr", "\u12ad\u122a" },
            { "cs", "\u127c\u12ad\u129b" },
            { "cu", "\u1278\u122d\u127d \u1235\u120b\u126a\u12ad" },
            { "cv", "\u1279\u126b\u123d\u129b" },
            { "cy", "\u12cc\u120d\u123d" },
            { "da", "\u12f4\u1292\u123d" },
            { "de", "\u1300\u122d\u1218\u1295\u129b" },
            { "dv", "\u12f2\u126c\u1202" },
            { "dz", "\u12f5\u12de\u1295\u130d\u12bb\u129b" },
            { "ee", "\u12a2\u12ca" },
            { "el", "\u130d\u122a\u12ad\u129b" },
            { "en", "\u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "eo", "\u12a4\u1235\u1350\u122b\u1295\u1276" },
            { "es", "\u1235\u1353\u1292\u123d" },
            { "et", "\u12a2\u1235\u1276\u1292\u12eb\u1295\u129b" },
            { "eu", "\u1263\u1235\u12ad\u129b" },
            { "fa", "\u1350\u122d\u123a\u12eb\u129b" },
            { "ff", "\u1349\u120b\u1292\u129b" },
            { "fi", "\u134a\u1295\u120b\u1295\u12f5\u129b" },
            { "fj", "\u134a\u1302\u129b" },
            { "fo", "\u134b\u122e\u129b" },
            { "fr", "\u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "fy", "\u121d\u12d5\u122b\u1263\u12ca \u134d\u122a\u1232\u129b" },
            { "ga", "\u12a0\u12e8\u122d\u120b\u1295\u12f5\u129b" },
            { "gd", "\u12e8\u1235\u12ae\u1275\u120b\u1295\u12f5 \u130c\u12ed\u120a\u12ad" },
            { "gl", "\u130b\u120a\u123a\u12eb\u1295\u129b" },
            { "gn", "\u1313\u122b\u1292\u129b" },
            { "gu", "\u1309\u1303\u122d\u1272\u129b" },
            { "gv", "\u121b\u1295\u12ad\u1235" },
            { "ha", "\u1203\u12cd\u1233\u129b" },
            { "he", "\u12d5\u1265\u122b\u12ed\u1235\u1325" },
            { "hi", "\u1215\u1295\u12f5\u129b" },
            { "hr", "\u12ad\u122e\u123d\u12eb\u1295\u129b" },
            { "ht", "\u1203\u12ed\u1275\u129b \u12ad\u122e\u120c" },
            { "hu", "\u1200\u1295\u130b\u122a\u129b" },
            { "hy", "\u12a0\u122d\u121c\u1295\u129b" },
            { "hz", "\u1204\u122c\u122e" },
            { "ia", "\u12a2\u1295\u1274\u122d\u120a\u1295\u1313" },
            { "id", "\u12a2\u1295\u12f6\u1294\u12e5\u12eb\u129b" },
            { "ie", "\u12a5\u1295\u1270\u122d\u120a\u1295\u130d\u12c8" },
            { "ig", "\u12a2\u130d\u1266\u129b" },
            { "ii", "\u1232\u1279\u12cb\u1295 \u12ea" },
            { "ik", "\u12a5\u1291\u1352\u12eb\u1245\u129b" },
            { "io", "\u12a2\u12f6" },
            { "is", "\u12a0\u12ed\u1235\u120b\u1295\u12f5\u129b" },
            { "it", "\u1323\u120a\u12eb\u1295\u129b" },
            { "iu", "\u12a5\u1291\u12ad\u1272\u1271\u1275\u129b" },
            { "ja", metaValue_ja },
            { "jv", "\u1303\u126b\u129b" },
            { "ka", "\u1306\u122d\u1302\u12eb\u1295\u129b" },
            { "kg", "\u12ae\u1295\u130e\u129b" },
            { "ki", "\u12aa\u12a9\u12e9" },
            { "kj", "\u12a9\u12cb\u1295\u12eb\u121b" },
            { "kk", "\u12ab\u12db\u12ad\u129b" },
            { "kl", "\u12ab\u120b\u120a\u1231\u1275" },
            { "km", "\u12ad\u1218\u122d" },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "kr", "\u12ab\u1291\u122a" },
            { "ks", "\u12ab\u123d\u121a\u122d\u129b" },
            { "ku", "\u12a9\u122d\u12f5\u123d" },
            { "kv", "\u12ae\u121a" },
            { "kw", "\u12ae\u122d\u1292\u123d" },
            { "ky", "\u12ad\u12ed\u122d\u130d\u12ed\u12dd" },
            { "la", "\u120b\u1272\u1295\u129b" },
            { "lb", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d\u129b" },
            { "lg", "\u130b\u1295\u12f3\u129b" },
            { "li", "\u120a\u121d\u1261\u122d\u130a\u123d" },
            { "ln", "\u120a\u1295\u130b\u120b" },
            { "lo", "\u120b\u12a6\u129b" },
            { "lt", "\u120a\u1271\u12cc\u1295\u12eb\u129b" },
            { "lu", "\u1209\u1263-\u12ab\u1273\u1295\u130b" },
            { "lv", "\u120b\u1275\u126a\u12eb\u129b" },
            { "mg", "\u121b\u120b\u130b\u1235\u12ed" },
            { "mh", "\u121b\u122d\u123b\u120a\u12dd" },
            { "mi", "\u121b\u12a6\u122a" },
            { "mk", "\u121c\u1244\u12f6\u1295\u129b" },
            { "ml", "\u121b\u120b\u12eb\u120b\u121d" },
            { "mn", metaValue_mn },
            { "mr", "\u121b\u122b\u1272" },
            { "ms", "\u121b\u120b\u12ed" },
            { "mt", "\u121b\u120d\u1272\u12dd\u129b" },
            { "my", "\u1261\u122d\u121b\u129b" },
            { "na", metaValue_NR },
            { "nb", "\u12e8\u1296\u122d\u12cc\u12ed \u1266\u12ad\u121b\u120d" },
            { "nd", "\u1230\u121c\u1295 \u1295\u12f4\u1265\u120c" },
            { "ne", "\u1294\u1353\u120a\u129b" },
            { "ng", "\u1295\u12f6\u1295\u130b" },
            { "nl", "\u12f0\u127d" },
            { "nn", "\u12e8\u1296\u122d\u12cc\u12ed \u1293\u12ed\u1296\u122d\u1235\u12ad" },
            { "no", "\u1296\u122d\u12cc\u12ed\u129b" },
            { "nr", "\u12f0\u1261\u1265 \u1295\u12f0\u1264\u120c" },
            { "nv", "\u1293\u126b\u1306" },
            { "ny", "\u1295\u12eb\u1295\u1303" },
            { "oc", "\u12a6\u1232\u1273\u1295" },
            { "om", "\u12a6\u122e\u121a\u129b" },
            { "or", metaValue_or },
            { "os", "\u12a6\u1234\u1272\u12ad" },
            { "pa", "\u1351\u1295\u1303\u1265\u129b" },
            { "pl", "\u1356\u120a\u123d" },
            { "ps", "\u1353\u123d\u1276" },
            { "pt", "\u1356\u122d\u1279\u130b\u120d\u129b" },
            { "qu", "\u12a9\u12cc\u1279\u12cb" },
            { "rm", "\u122e\u121b\u1295\u123d" },
            { "rn", "\u1229\u1295\u12f2" },
            { "ro", "\u122e\u121b\u1292\u12eb\u129b" },
            { "ru", "\u122b\u123d\u12eb\u129b" },
            { "rw", "\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f3" },
            { "sa", "\u1233\u1295\u1235\u12ad\u122a\u1275" },
            { "sc", "\u1233\u122d\u12f2\u1295\u12eb\u1295" },
            { "sd", "\u1232\u1295\u12f2" },
            { "se", "\u1230\u121c\u1293\u12ca \u1233\u121a" },
            { "sg", "\u1233\u1295\u130e" },
            { "sh", "\u1230\u122d\u1266-\u12ad\u122e\u12a4\u123d\u12eb\u129b" },
            { "si", metaValue_si },
            { "sk", "\u1235\u120e\u126b\u12ad\u129b" },
            { "sl", "\u1235\u120e\u126c\u1295\u129b" },
            { "sm", "\u1233\u121e\u12a3\u1295" },
            { "sn", "\u123e\u1293" },
            { "so", "\u1231\u121b\u120d\u129b" },
            { "sq", "\u12a0\u120d\u1263\u1295\u12eb\u1295\u129b" },
            { "sr", "\u1230\u122d\u1265\u12eb\u129b" },
            { "ss", "\u1235\u12cb\u1272" },
            { "st", "\u12f0\u1261\u1263\u12ca \u1236\u1276" },
            { "su", metaValue_su },
            { "sv", "\u1235\u12ca\u12f5\u1295\u129b" },
            { "sw", "\u1235\u12cb\u1202\u120a\u129b" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u1273\u1302\u12ad" },
            { "th", metaValue_th },
            { "ti", "\u1275\u130d\u122d\u129b" },
            { "tk", "\u1271\u122d\u12ad\u121c\u1295" },
            { "tl", "\u1273\u130b\u120e\u1308\u129b" },
            { "tn", "\u133d\u12cb\u1293" },
            { "to", "\u1276\u1295\u130b\u1295" },
            { "tr", "\u1271\u122d\u12ad\u129b" },
            { "ts", "\u133e\u1295\u130b" },
            { "tt", "\u1273\u1273\u122d" },
            { "tw", "\u1275\u12ca\u129b" },
            { "ty", "\u1273\u1202\u1273\u1295\u129b" },
            { "ug", "\u12a1\u12ed\u130d\u1201\u122d" },
            { "uk", "\u12e9\u12ad\u122c\u1295\u129b" },
            { "ur", "\u12a1\u122d\u12f1\u129b" },
            { "uz", "\u12a1\u12dd\u1264\u12ad\u129b" },
            { "ve", "\u126c\u1295\u12f3" },
            { "vi", "\u126a\u12e8\u1275\u1293\u121d\u129b" },
            { "vo", "\u126e\u120b\u1351\u12ad\u129b" },
            { "wa", "\u12cb\u120e\u1295" },
            { "wo", "\u12ce\u120e\u134d\u129b" },
            { "xh", "\u12de\u1233\u129b" },
            { "yi", "\u12ed\u12f2\u123d\u129b" },
            { "yo", "\u12ee\u1229\u1263\u12ca\u129b" },
            { "za", "\u12e1\u12cb\u1295\u130d\u129b" },
            { "zh", "\u127b\u12ed\u1295\u129b" },
            { "zu", "\u12d9\u1209\u129b" },
            { "ace", "\u12a0\u127b\u12ed\u1295\u129b" },
            { "ach", "\u12a0\u12ae\u120a\u129b" },
            { "ada", "\u12a0\u12f3\u1295\u130d\u121c" },
            { "ady", "\u12a0\u12f5\u12ed\u130d\u1204" },
            { "afh", "\u12a0\u134d\u122a\u1202\u120a" },
            { "agq", "\u12a0\u1308\u121d" },
            { "ain", "\u12a0\u12ed\u1291" },
            { "akk", "\u12a0\u12ab\u12f2\u12eb\u1295" },
            { "akz", "\u12a0\u120b\u1263\u121b" },
            { "ale", "\u12a0\u120d\u12e9\u1275" },
            { "alt", "\u12f0\u1261\u1263\u12ca \u12a0\u120d\u1273\u12ed" },
            { "ann", "\u12a6\u1266\u120e" },
            { "anp", "\u12a0\u1295\u130a\u12ab" },
            { "arc", "\u12a0\u122b\u121b\u12ed\u12ad" },
            { "arn", "\u121b\u1351\u127c" },
            { "aro", "\u12a0\u122b\u12a6\u1293" },
            { "arp", "\u12a0\u122b\u1353\u1206" },
            { "arq", "\u12e8\u12a0\u120d\u1304\u122a\u12eb \u12d3\u1228\u1265\u129b" },
            { "ars", "\u1293\u1305\u12f2 \u12a0\u1228\u1265\u129b" },
            { "arw", "\u12a0\u122b\u12cb\u12ad" },
            { "asa", "\u12a0\u1231" },
            { "ase", "\u12e8\u12a0\u121c\u122a\u12ab \u12e8\u121d\u120d\u12ad\u1275 \u124b\u1295\u124b" },
            { "ast", "\u12a0\u1235\u1271\u122a\u12eb\u1295\u129b" },
            { "atj", "\u12a0\u1272\u12ab\u121d\u12a8\u12cd" },
            { "awa", "\u12a0\u12cb\u12f5\u1202" },
            { "bal", "\u1263\u1209\u127a" },
            { "ban", "\u1263\u120a\u1294\u1235" },
            { "bar", "\u1263\u126b\u122a\u12eb\u1295" },
            { "bas", "\u1263\u1233" },
            { "bax", "\u1263\u1219\u1295" },
            { "bbc", "\u1263\u1273\u12ab \u1276\u1263" },
            { "bej", "\u1264\u1303" },
            { "bem", "\u1264\u121d\u1263" },
            { "bew", "\u1264\u1273\u12ca" },
            { "bez", "\u1264\u1293" },
            { "bfd", "\u1263\u1349\u1275" },
            { "bfq", "\u1263\u12f3\u130b" },
            { "bgc", "\u1203\u122d\u12eb\u1295\u126a\u129b" },
            { "bgn", "\u12e8\u121d\u12d5\u122b\u1265 \u1263\u120e\u127a" },
            { "bho", "\u1266\u1305\u1351\u122a" },
            { "bik", "\u1262\u12ae\u120d" },
            { "bin", "\u1262\u1292" },
            { "bjn", "\u1263\u1295\u1303\u122d" },
            { "bla", "\u1232\u12ad\u1232\u12ab" },
            { "blo", "\u12a0\u1292\u129b" },
            { "bpy", "\u1262\u1239\u1295\u1351\u122a\u12eb" },
            { "bqi", "\u1263\u12ad\u1205\u1272\u12eb\u122a" },
            { "bra", "\u1265\u122b\u1305" },
            { "brh", "\u1265\u122b\u1201\u12ea" },
            { "brx", "\u1266\u12f6" },
            { "bss", "\u12a0\u12ae\u1235" },
            { "bua", "\u1261\u122a\u12eb\u1275" },
            { "bug", "\u1261\u130a\u1294\u12dd" },
            { "bum", "\u1261\u1209" },
            { "byn", "\u1265\u120a\u1295" },
            { "cad", "\u12ab\u12f6" },
            { "car", "\u12ab\u122a\u1265" },
            { "cay", "\u12ab\u12e9\u130b" },
            { "cch", "\u12a0\u1275\u1233\u121d" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u1234\u1265\u12cb\u1296" },
            { "cgg", "\u127a\u130b\u129b" },
            { "chb", "\u127a\u1265\u127b" },
            { "chg", "\u127b\u130b\u1273\u12ed" },
            { "chk", "\u1279\u12ad\u1235" },
            { "chm", "\u121b\u122a" },
            { "chn", "\u127a\u1291\u12ad \u1303\u122d\u130e\u1295" },
            { "cho", "\u127e\u12ad\u1273\u12cb" },
            { "chp", "\u127a\u1354\u12cd\u12eb\u1295" },
            { "chr", "\u127c\u122e\u12ac\u129b" },
            { "chy", "\u127d\u12ec\u1294" },
            { "ckb", "\u12e8\u1236\u122b\u1292 \u12a9\u122d\u12f5\u129b" },
            { "clc", "\u127a\u120d\u12ae\u1272\u1295" },
            { "cop", metaValue_cop },
            { "cps", "\u12ab\u1352\u12dd\u1296\u1295" },
            { "crg", "\u121a\u127a\u134d" },
            { "crh", "\u12ad\u122a\u121a\u12eb\u1295 \u1270\u122d\u12aa\u123d" },
            { "crj", "\u12f0\u1261\u1265 \u121d\u12d5\u122b\u1263\u12ca \u12ad\u122a" },
            { "crk", "\u1355\u120b\u12ed\u1295\u1235 \u12ad\u122a" },
            { "crl", "\u1230\u121c\u1295 \u121d\u1235\u122b\u1243\u12ca \u12ad\u122a" },
            { "crm", "\u1219\u12dd \u12ad\u122a" },
            { "crr", "\u12ab\u122e\u120a\u1293 \u12a0\u120d\u130e\u1295\u12ad\u12ca\u12eb\u1295" },
            { "crs", "\u1230\u1230\u120b\u12ca \u12ad\u122c\u12a6\u120a \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "csw", "\u1235\u12cb\u121d\u1352 \u12ad\u122a" },
            { "dak", "\u12f3\u12ae\u1273" },
            { "dar", "\u12f3\u122d\u130d\u12cb" },
            { "dav", "\u1273\u12ed\u1273" },
            { "del", "\u12f3\u120b\u12cc\u122d" },
            { "dgr", "\u12f6\u130d\u122a\u1265" },
            { "din", "\u12f2\u1295\u12ab" },
            { "dje", "\u12db\u122d\u121b\u129b" },
            { "doi", "\u12f6\u130d\u122a" },
            { "dsb", "\u12e8\u1273\u127d\u129b\u12cd \u1236\u122d\u1262\u12eb\u129b" },
            { "dtp", "\u1234\u1295\u1270\u122b\u120d \u12f1\u1230\u1295" },
            { "dua", "\u12f1\u12cb\u120b\u129b" },
            { "dyo", "\u1306\u120b-\u134e\u1295\u12ea" },
            { "dyu", "\u12f5\u12e9\u120b" },
            { "dzg", "\u12f3\u12db\u130b" },
            { "ebu", "\u12a2\u121d\u1261" },
            { "efi", "\u12a4\u134a\u12ad" },
            { "egy", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u1265\u133d\u129b" },
            { "eka", "\u12a4\u12ab\u1301\u12ad" },
            { "esu", "\u1234\u1295\u1270\u122b\u120d \u12e9\u1352\u12ad" },
            { "ewo", "\u12a4\u12ce\u1295\u12f6" },
            { "fil", "\u134a\u120a\u1352\u1295\u129b" },
            { "fon", "\u134e\u1295" },
            { "frc", "\u12ab\u1301\u1295 \u134d\u122c\u1295\u127d" },
            { "frp", "\u12a0\u122d\u1352\u1273\u1295" },
            { "frr", "\u1230\u121c\u1293\u12ca \u134d\u122a\u1235\u12eb\u1295" },
            { "fur", "\u134d\u1229\u120a\u12eb\u1295" },
            { "gaa", "\u130b" },
            { "gag", "\u130b\u1309\u12dd\u129b" },
            { "gan", "\u130b\u1295 \u127b\u12ed\u1295\u129b" },
            { "gez", "\u130d\u12d5\u12dd\u129b" },
            { "gil", "\u1305\u120d\u1260\u122d\u1275\u1235" },
            { "gor", "\u130e\u122e\u1295\u1273\u120e" },
            { "grc", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u122a\u12ad" },
            { "gsw", "\u1235\u12ca\u12dd \u1300\u122d\u1218\u1295\u129b" },
            { "guz", "\u1309\u1235\u120a\u129b" },
            { "gwi", "\u130d\u12ca\u127a\u1295" },
            { "hai", "\u1203\u12ed\u12f3" },
            { "hak", "\u1203\u12ab \u127b\u12ed\u1295\u129b" },
            { "haw", "\u1203\u12ca\u12eb\u129b" },
            { "hax", "\u12f0\u1261\u1263\u12ca \u1203\u12ed\u12f3" },
            { "hil", "\u1202\u120a\u130b\u12ed\u1296\u1295" },
            { "hmn", "\u1205\u121e\u1295\u130d" },
            { "hsb", "\u12e8\u120b\u12ed\u129b\u12cd \u1236\u122d\u1262\u12eb\u1295\u129b" },
            { "hsn", "\u12e2\u12eb\u1295\u130d \u127b\u12ed\u1295\u129b" },
            { "hup", "\u1201\u1353" },
            { "hur", "\u1203\u120d\u12ae\u1218\u120d\u121d" },
            { "iba", "\u12a2\u1263\u1295" },
            { "ibb", "\u12a2\u1262\u1265\u12ee" },
            { "ikt", "\u12e8\u121d\u12d5\u122b\u1263\u12ca \u12ab\u1293\u12f3 \u12a2\u1291\u12ad\u1272\u1271\u1275" },
            { "ilo", "\u12a2\u120e\u12ae" },
            { "inh", "\u12a2\u1295\u1309\u123d" },
            { "jbo", "\u120e\u1305\u1263\u1295" },
            { "jgo", "\u1295\u130e\u121d\u1263" },
            { "jmc", "\u121b\u127b\u121c\u129b" },
            { "kab", "\u12ab\u1265\u12ed\u120d" },
            { "kac", "\u12ab\u127a\u1295" },
            { "kaj", "\u1305\u1301" },
            { "kam", "\u12ab\u121d\u1263" },
            { "kbd", "\u12ab\u1263\u122d\u12f2\u12eb\u1295" },
            { "kcg", "\u1273\u12eb\u1355" },
            { "kde", "\u121b\u12ae\u1295\u12f4" },
            { "kea", "\u12ab\u1261\u1268\u122d\u12f2\u12eb\u1291" },
            { "kfo", "\u12ae\u122e" },
            { "kgp", "\u12ab\u12ed\u1295\u130b\u1295\u130d" },
            { "kha", "\u12ab\u1232" },
            { "khq", "\u12ae\u12ed\u122b \u127a\u1292" },
            { "kkj", "\u12ab\u12ae" },
            { "kln", "\u12ab\u1208\u1295\u1302\u1295" },
            { "kmb", "\u12aa\u121d\u1261\u1295\u12f1" },
            { "koi", "\u12ae\u121a \u1354\u122d\u121d\u12eb\u12ad" },
            { "kok", "\u12ae\u1295\u12ab\u1292" },
            { "kpe", "\u12ad\u1354\u120c" },
            { "krc", "\u12ab\u122b\u127b\u12ed-\u1263\u120d\u12ab\u122d" },
            { "krl", "\u12ab\u1228\u120a\u12eb\u1295" },
            { "kru", "\u12a9\u1229\u12ad" },
            { "ksb", "\u123b\u121d\u1263\u120b" },
            { "ksf", "\u1263\u134a\u12eb" },
            { "ksh", "\u12ae\u120e\u129d\u129b" },
            { "kum", "\u12a9\u121b\u12ed\u12ad" },
            { "kwk", "\u12ad\u12cb\u12ad\u12cb\u120b" },
            { "kxv", "\u12a9\u126a\u129b" },
            { "lad", "\u120b\u12f2\u1296" },
            { "lag", "\u120b\u1295\u130a" },
            { "lez", "\u120c\u12dd\u130a\u12eb\u1295" },
            { "lij", "\u120a\u1313\u122a\u12eb\u129b" },
            { "lil", "\u120a\u120e\u12a4\u1275" },
            { "lkt", "\u120b\u12ae\u1273" },
            { "lmo", "\u120e\u121d\u1263\u122d\u12f5\u129b" },
            { "lou", "\u1209\u12ca\u12da\u12eb\u1293 \u12ad\u122c\u12a6\u120d" },
            { "loz", "\u120e\u12da" },
            { "lrc", "\u1230\u121c\u1293\u12ca \u1209\u122a" },
            { "lsm", "\u1233\u121a\u12eb" },
            { "lua", "\u1209\u1263-\u1209\u120f" },
            { "lun", "\u1209\u1295\u12f3" },
            { "luo", "\u1209\u12a6" },
            { "lus", "\u121a\u12de" },
            { "luy", "\u1209\u12eb" },
            { "mad", "\u121b\u12f1\u1228\u1235" },
            { "mag", "\u121b\u130b\u1202" },
            { "mai", "\u121b\u12ed\u1272\u120a" },
            { "mak", "\u121b\u12ab\u1233\u122d" },
            { "mas", "\u121b\u1233\u12ed" },
            { "mdf", "\u121e\u12ad\u123b" },
            { "men", "\u121c\u1295\u12f4" },
            { "mer", "\u121c\u1229" },
            { "mfe", "\u121e\u122a\u1235\u12e8\u1295" },
            { "mgh", "\u121b\u12a9\u12cb-\u121c\u1276" },
            { "mgo", "\u121c\u1273" },
            { "mic", "\u121a\u12ad\u121b\u12cd" },
            { "min", "\u121a\u1293\u1295\u130d\u12ab\u1263\u12a1" },
            { "mni", "\u121b\u1292\u1351\u122a" },
            { "moe", "\u12a2\u1291-\u12a0\u12ed\u1218\u1295" },
            { "moh", "\u121e\u1203\u12cd\u12ad" },
            { "mos", "\u121e\u1232" },
            { "mua", "\u1219\u1295\u12f3\u1295\u130d" },
            { "mul", "\u1263\u1208\u1265\u12d9 \u124b\u1295\u124b\u12ce\u127d" },
            { "mus", "\u1219\u1235\u12ae\u12aa" },
            { "mwl", "\u121a\u122b\u1295\u12f4\u12dd" },
            { "myv", "\u12a4\u122d\u12dd\u12eb" },
            { "mzn", "\u121b\u12db\u1295\u12f0\u122b\u1292" },
            { "nan", "\u121a\u1295 \u129b\u1295 \u127b\u12ed\u1295\u129b" },
            { "nap", "\u1292\u12a0\u1356\u120a\u1273\u1295" },
            { "naq", "\u1293\u121b" },
            { "nds", "\u12e8\u1273\u127d\u129b\u12cd \u1300\u122d\u1218\u1295\u129b" },
            { "new", "\u1292\u12cb\u122a(\u1294\u1353\u120d)" },
            { "nia", "\u1292\u12a0\u1235" },
            { "niu", "\u1292\u12e9\u12a0\u1295\u129b" },
            { "njo", "\u12a6 \u1293\u130b" },
            { "nmg", "\u12ad\u12cb\u1232\u12ee" },
            { "nnh", "\u1292\u130a\u121d\u1261\u1295" },
            { "nog", "\u1296\u130b\u12ed" },
            { "nqo", metaValue_nqo },
            { "nso", "\u1230\u121c\u1293\u12ca \u1236\u1276" },
            { "nus", "\u1291\u12cc\u122d" },
            { "nwc", "\u12ad\u120b\u1232\u12ad \u1294\u12cb\u122a" },
            { "nyn", "\u1292\u12eb\u1295\u12ae\u120d" },
            { "ojb", "\u1230\u121c\u1295 \u121d\u12d5\u122b\u1263\u12ca \u12a6\u1302\u1265\u12cb" },
            { "ojc", "\u121b\u12d5\u12a8\u120b\u12ca \u12a6\u1302\u1265\u12cb" },
            { "ojs", "\u12a6\u1302-\u12ad\u122a" },
            { "ojw", "\u121d\u12d5\u122b\u1263\u12ca \u12a6\u1302\u1261\u12cb" },
            { "oka", "\u12a6\u12ab\u1293\u130b\u1295" },
            { "pag", "\u1353\u1295\u130b\u1232\u1293\u1295" },
            { "pam", "\u1353\u121d\u1353\u1295\u130b" },
            { "pap", "\u1353\u1352\u12eb\u121c\u1295\u1276" },
            { "pau", "\u1353\u1209\u12cb\u1295" },
            { "pcm", "\u12e8\u1293\u12ed\u1304\u122a\u12eb \u1352\u1302\u1295" },
            { "pis", "\u1352\u1302\u1295" },
            { "pqm", "\u121b\u120a\u1234\u1275-\u1353\u1233\u121b\u12a9\u12ce\u12f5\u12ed" },
            { "prg", "\u1350\u1229\u1233\u1295\u129b" },
            { "quc", "\u12aa\u127c" },
            { "qug", "\u127a\u121d\u1266\u122b\u12de \u1203\u12ed\u120b\u1295\u12f5 \u12a9\u1279\u12cb" },
            { "raj", "\u122b\u1303\u1235\u1273\u1292" },
            { "rap", "\u122b\u1353\u1291\u12a2" },
            { "rar", "\u122b\u122e\u1276\u1295\u130b\u1295" },
            { "rhg", "\u122e\u1202\u1295\u130d\u12eb" },
            { "rof", "\u122e\u121d\u1266" },
            { "rup", "\u12a0\u122e\u121b\u1295\u12eb\u1295" },
            { "rwk", "\u122d\u12cb" },
            { "sad", "\u1233\u1295\u12f3\u12cc" },
            { "sah", "\u12eb\u12a9\u1275" },
            { "saq", "\u1233\u121d\u1261\u1229" },
            { "sat", "\u1233\u1295\u1273\u120a" },
            { "sba", "\u1295\u130b\u121d\u1263\u12ed" },
            { "sbp", "\u1233\u1295\u1309" },
            { "scn", "\u1232\u1232\u120a\u12eb\u1295\u129b" },
            { "sco", "\u1235\u12ae\u1275\u1235" },
            { "sdh", "\u12f0\u1261\u1263\u12ca \u12a9\u122d\u12f2\u123d" },
            { "seh", "\u1234\u1293" },
            { "ses", "\u12ae\u12ed\u122b\u1266\u122e \u1234\u1292" },
            { "shi", "\u1273\u127c\u120d\u1202\u1275" },
            { "shn", "\u123b\u1295" },
            { "shu", "\u127b\u12f2\u12eb\u1295 \u12d3\u1228\u1265\u129b" },
            { "sid", "\u1232\u12f3\u121d\u129b" },
            { "slh", "\u12f0\u1261\u1263\u12ca \u1209\u1239\u1275\u1232\u12f5" },
            { "sma", "\u12f0\u1261\u1263\u12ca \u1233\u121a" },
            { "smj", "\u1209\u120c \u1233\u121a" },
            { "smn", "\u12a2\u1293\u122a \u1233\u121a" },
            { "sms", "\u1235\u12ae\u120d\u1275 \u1233\u121a" },
            { "snk", "\u1236\u1292\u1295\u12ac" },
            { "srn", "\u1235\u122b\u1293\u1295 \u1276\u1295\u130e" },
            { "ssy", "\u1233\u1206\u129b" },
            { "str", "\u1235\u1275\u122c\u12ed\u1275\u1235 \u1235\u1273\u120a\u123d" },
            { "suk", "\u1231\u12a9\u121b" },
            { "swb", "\u12ae\u121e\u122a\u12eb\u1295" },
            { "syc", "\u12ad\u120b\u1232\u12ad \u1294\u12ed\u122b" },
            { "syr", metaValue_syr },
            { "szl", "\u1232\u120c\u1232\u12eb\u129b" },
            { "tce", "\u12f0\u1261\u1263\u12ca \u1271\u1275\u127e\u1295" },
            { "tem", "\u1272\u121d\u1294" },
            { "teo", "\u1274\u1236" },
            { "tet", "\u1274\u1270\u121d" },
            { "tgx", "\u1273\u130a\u123d" },
            { "tht", "\u1273\u1205\u120d\u1273\u1295" },
            { "tig", "\u1275\u130d\u1228" },
            { "tlh", "\u12ad\u120a\u1295\u130e\u1295" },
            { "tli", "\u1275\u120a\u1295\u130a\u1275" },
            { "tok", "\u1276\u12aa \u1356\u1293" },
            { "tpi", "\u1276\u12ad \u1352\u1232\u1295" },
            { "trv", "\u1273\u122e\u12ae" },
            { "ttm", "\u1230\u121c\u1293\u12ca \u1271\u1275\u127e\u1295" },
            { "tum", "\u1271\u121d\u1261\u12ab" },
            { "tvl", metaValue_TV },
            { "twq", "\u1273\u1233\u12cb\u12ad" },
            { "tyv", "\u1271\u126a\u1295\u12eb\u1295\u129b" },
            { "tzm", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u1275\u120b\u1235 \u1273\u121b\u12da\u129b" },
            { "udm", "\u12a1\u12f5\u1219\u122d\u1275" },
            { "umb", "\u12a1\u121d\u1261\u1295\u12f1" },
            { "und", "\u12eb\u120d\u1273\u12c8\u1240 \u124b\u1295\u124b" },
            { "vai", metaValue_vai },
            { "vec", "\u126c\u1290\u1272\u12eb\u1295\u129b" },
            { "vmw", "\u121b\u12ad\u1201\u12cb\u129b" },
            { "vun", "\u1269\u1295\u1306" },
            { "wae", "\u12cb\u120d\u1230\u122d" },
            { "wal", "\u12c8\u120b\u12ed\u1275\u129b" },
            { "war", "\u12cb\u122b\u12ed" },
            { "wbp", "\u12cb\u122d\u120d\u1352\u122a" },
            { "wuu", "\u12c9 \u127b\u12ed\u1295\u129b" },
            { "xal", "\u12ab\u120d\u121b\u12ed\u12ad" },
            { "xnr", "\u12ab\u1295\u130b\u122a" },
            { "xog", "\u1236\u130b" },
            { "yav", "\u12eb\u1295\u130d\u1264\u1295\u129b" },
            { "ybb", "\u12e8\u121d\u1263" },
            { "yrl", "\u1295\u1204\u1295\u130b\u1271" },
            { "yue", "\u12ab\u1295\u1276\u1292\u12dd" },
            { "zbl", "\u1265\u120a\u1235\u12ed\u121d\u1266\u120d\u1235" },
            { "zgh", "\u1218\u12f0\u1260\u129b \u12e8\u121e\u122e\u12ae \u1273\u121b\u12da\u130d\u1275" },
            { "zun", "\u12d9\u1292" },
            { "zxx", "\u124b\u1295\u124b\u12ca \u12ed\u12d8\u1275 \u12e8\u1208\u12cd\u121d" },
            { "zza", "\u12db\u12db" },
            { "Adlm", "\u12a0\u12f5\u120b\u121d" },
            { "Arab", metaValue_ar },
            { "Aran", "\u1293\u1235\u1273\u120a\u12ad" },
            { "Armn", "\u12a0\u122d\u121c\u1295\u12eb\u12ca" },
            { "Beng", "\u1264\u1295\u130b\u120a" },
            { "Bopo", "\u1266\u1356\u121e\u134e" },
            { "Brai", "\u1265\u122c\u12ed\u120d" },
            { "Buhd", "\u1261\u1202\u12f5" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u12e8\u1270\u12cb\u1210\u12f1 \u12e8\u12ab\u1293\u12f3 \u12a0\u1266\u122a\u1302\u1296\u127d \u134a\u12f0\u120b\u1275" },
            { "Cher", "\u127c\u122e\u12aa" },
            { "Copt", metaValue_cop },
            { "Cprt", "\u1232\u1355\u122a\u12a6\u1275" },
            { "Cyrl", "\u1232\u12ed\u122a\u120d\u12ad" },
            { "Deva", "\u12f0\u126b\u1295\u130b\u122a" },
            { "Dsrt", "\u12f4\u12d8\u1228\u1275" },
            { "Ethi", "\u12a2\u1275\u12ee\u1352\u12ad" },
            { "Geor", "\u1306\u122d\u1302\u12eb\u129b" },
            { "Goth", "\u1310\u1272\u12ad" },
            { "Grek", metaValue_GR },
            { "Gujr", "\u1309\u1303\u122b\u1272" },
            { "Guru", "\u1309\u122d\u1219\u12aa" },
            { "Hanb", "\u1203\u1295 \u12a8\u1266\u1356\u121e\u134e \u130b\u122d" },
            { "Hang", "\u1210\u1295\u1309\u120d" },
            { "Hani", "\u1203\u1295" },
            { "Hano", "\u1200\u1291\u12a6" },
            { "Hans", "\u1240\u1208\u120d \u12eb\u1208" },
            { "Hant", "\u1263\u1205\u120b\u12ca" },
            { "Hebr", "\u12a5\u1265\u122b\u12ed\u1235\u1325" },
            { "Hira", "\u1202\u122b\u130b\u1293" },
            { "Hrkt", "\u1303\u1353\u1295\u129b \u134a\u12f0\u120b\u1275" },
            { "Jamo", "\u1303\u121e" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u12ab\u1273\u12ab\u1293" },
            { "Khmr", "\u12ad\u1205\u1218\u122d" },
            { "Knda", metaValue_CA },
            { "Kore", metaValue_ko },
            { "Laoo", "\u120b\u12a6" },
            { "Latn", "\u120b\u1272\u1295" },
            { "Limb", "\u120a\u121d\u1261" },
            { "Lina", "\u120a\u1292\u12eb\u122d \u12a4" },
            { "Linb", "\u120a\u1292\u12eb\u122d \u1262" },
            { "Mlym", "\u121b\u120b\u12ed\u120b\u121d" },
            { "Mong", metaValue_mn },
            { "Mtei", "\u121c\u1274 \u121b\u12ed\u12ad" },
            { "Mymr", "\u121d\u12eb\u1295\u121b\u122d" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "\u12a6\u130d\u1200\u121d" },
            { "Olck", "\u12a6\u12ed \u127a\u12aa" },
            { "Orya", metaValue_or },
            { "Osma", "\u12a6\u1235\u121b\u1292\u12eb" },
            { "Rohg", "\u1203\u1292\u134a" },
            { "Runr", "\u1229\u1292\u12ad" },
            { "Shaw", "\u12e8\u123b\u126a\u12eb \u134a\u12f0\u120d" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Tagb", "\u1275\u12a0\u130d\u1263\u1295\u12cb" },
            { "Tale", "\u1273\u12a2 \u1208" },
            { "Talu", "\u12a0\u12f2\u1235 \u1273\u12a2 \u1209" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u1272\u134a\u1293\u130d\u1205" },
            { "Tglg", "\u1273\u130b\u120e\u130d" },
            { "Thaa", "\u1273\u1293" },
            { "Thai", metaValue_th },
            { "Tibt", "\u1272\u1264\u1275\u129b" },
            { "Ugar", "\u12a1\u130b\u122a\u1272\u12ad" },
            { "Vaii", metaValue_vai },
            { "Yiii", "\u12ea" },
            { "Zinh", "\u12e8\u1270\u12c8\u1228\u1230" },
            { "Zmth", "\u12e8\u1202\u1233\u1265 \u1218\u130d\u1208\u132b" },
            { "Zsye", "\u12a2\u121e\u1302" },
            { "Zsym", "\u121d\u120d\u12ad\u1276\u127d" },
            { "Zxxx", "\u12eb\u120d\u1270\u133b\u1348" },
            { "Zyyy", "\u12e8\u130b\u122b" },
            { "Zzzz", "\u12eb\u120d\u1273\u12c8\u1240 \u134a\u12f0\u120d" },
            { "de_AT", "\u12e8\u12a6\u1235\u1275\u122a\u12eb \u1300\u122d\u1218\u1295\u129b" },
            { "de_CH", "\u12e8\u1235\u12ca\u12dd \u12a8\u134d\u1270\u129b \u1300\u122d\u1218\u1295\u129b" },
            { "en_AU", "\u12e8\u12a0\u12cd\u1235\u1275\u122b\u120a\u12eb \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "en_CA", "\u12e8\u12ab\u1293\u12f3 \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "en_GB", "\u12e8\u1265\u122a\u1272\u123d \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "en_US", "\u12e8\u12a0\u121c\u122a\u12ab \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "es_ES", "\u12e8\u12a0\u12cd\u122e\u1353 \u1235\u1353\u1292\u123d" },
            { "es_MX", "\u12e8\u121c\u12ad\u1232\u12ae \u1235\u1353\u1292\u123d" },
            { "fa_AF", "\u12f3\u122a" },
            { "fr_CA", "\u12e8\u12ab\u1293\u12f3 \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "fr_CH", "\u12e8\u1235\u12ca\u12dd \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "nl_BE", "\u134d\u120c\u121a\u123d" },
            { "pt_BR", "\u12e8\u1265\u122b\u12da\u120d \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "pt_PT", "\u12e8\u12a0\u12cd\u122e\u1353 \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "ro_MD", "\u121e\u120d\u12f3\u126a\u12eb\u1295\u129b" },
            { "sw_CD", "\u12ae\u1295\u130e \u1235\u12cb\u1202\u120a" },
            { "ar_001", "\u12d8\u1218\u1293\u12ca \u1218\u12f0\u1260\u129b \u12d3\u1228\u1265\u129b" },
            { "es_419", "\u12e8\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab \u1235\u1353\u1292\u123d" },
            { "key.ca", "\u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "key.cf", "\u12e8\u121d\u1295\u12db\u122a \u1245\u122d\u1338\u1275" },
            { "key.co", "\u12a0\u1240\u121b\u1218\u1325 \u12f0\u122d\u12f5\u122d" },
            { "key.cu", "\u121d\u1295\u12db\u122a" },
            { "key.hc", "\u12e8\u1230\u12d3\u1275 \u12d1\u12f0\u1275 (12 \u12c8\u12ed\u121d 24)" },
            { "key.lb", "\u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "key.ms", "\u12e8\u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "key.nu", "\u1241\u1325\u122e\u127d" },
            { "key.tz", "\u12e8\u1230\u12d3\u1275 \u1230\u1245" },
            { "key.va", "\u12e8\u12a0\u12ab\u1263\u1262 \u12a0\u12ed\u1290\u1275" },
            { "nds_NL", "\u12e8\u1273\u127d\u129b\u12cd \u1233\u12ad\u1230\u1295" },
            { "hi_Latn", "\u1215\u1295\u12f5\u129b (\u120b\u1272\u1295)" },
            { "zh_Hans", "\u1240\u1208\u120d \u12eb\u1208 \u127b\u12ed\u1295\u129b" },
            { "zh_Hant", "\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b" },
            { "type.ca.roc", "\u12e8\u121a\u1295\u1309 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.hc.h11", "\u12e812 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (0\u201311)" },
            { "type.hc.h12", "\u12e812 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (1\u201312)" },
            { "type.hc.h23", "\u12e824 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (0\u201323)" },
            { "type.hc.h24", "\u12e824 \u1230\u12d3\u1275 \u1235\u122d\u12d3\u1275 (1\u201324)" },
            { "type.m0.bgn", "\u12e9\u12a4\u1235 \u1262\u1302\u12a4\u1295 \u1275\u122b\u1295\u1235\u120a\u1275\u122c\u123d\u1295" },
            { "type.nu.arab", "\u12e8\u12a0\u1228\u1262\u12ad-\u12a2\u1295\u12f2\u12ad \u12a0\u1203\u12de\u127d" },
            { "type.nu.armn", "\u12e8\u12a0\u122d\u1218\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "type.nu.beng", "\u12e8\u1264\u1295\u130b\u120a \u12a0\u1203\u12de\u127d" },
            { "type.nu.cakm", "\u12e8\u127b\u12ad\u121b \u12a0\u1203\u12de\u127d" },
            { "type.nu.deva", "\u12e8\u12f4\u126b\u1295\u130b\u122a \u12a0\u1203\u12de\u127d" },
            { "type.nu.ethi", "\u12e8\u12a2\u1275\u12ee\u1335\u12eb \u1241\u1325\u122e\u127d" },
            { "type.nu.geor", "\u12e8\u1306\u122d\u1302\u12eb \u1241\u1325\u122e\u127d" },
            { "type.nu.grek", "\u12e8\u130d\u122a\u12ad \u1241\u1325\u122e\u127d" },
            { "type.nu.gujr", "\u12e8\u1309\u1303\u122b\u1272 \u12a0\u1203\u12de\u127d" },
            { "type.nu.guru", "\u12e8\u1309\u122d\u1219\u12aa \u12a0\u1203\u12de\u127d" },
            { "type.nu.hans", "\u1240\u1208\u120d \u12eb\u1209 \u12e8\u127b\u12ed\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "type.nu.hant", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "type.nu.hebr", "\u12e8\u12a5\u1265\u122b\u12ed\u1235\u1325 \u1241\u1325\u122e\u127d" },
            { "type.nu.java", "\u12e8\u1303\u126b \u12a0\u1203\u12de\u127d" },
            { "type.nu.jpan", "\u12e8\u1303\u1353\u1295\u129b \u1241\u1325\u122e\u127d" },
            { "type.nu.khmr", "\u12e8\u12ad\u1205\u1218\u122d \u12a0\u1203\u12de\u127d" },
            { "type.nu.knda", "\u12e8\u12ab\u1295\u12a0\u12f3 \u12a0\u1203\u12de\u127d" },
            { "type.nu.laoo", "\u12e8\u120b\u12a6 \u12a0\u1203\u12de\u127d" },
            { "type.nu.latn", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u1203\u12de\u127d" },
            { "type.nu.mlym", "\u12e8\u121b\u120b\u12eb\u120b\u121d\u129b \u12a0\u1203\u12de\u127d" },
            { "type.nu.mong", "\u12e8\u121e\u1295\u130e\u120d\u129b \u12a0\u1203\u12de\u127d" },
            { "type.nu.mtei", "\u121c\u1272 \u121b\u12e8\u12ad \u12a0\u1203\u12de\u127d" },
            { "type.nu.mymr", "\u12e8\u121b\u12eb\u1295\u121b\u122d \u12a0\u1203\u12de\u127d" },
            { "type.nu.olck", "\u12a6\u12ed \u127a\u12aa \u12a0\u1203\u12de\u127d" },
            { "type.nu.orya", "\u12e8\u12a6\u12f2\u12eb \u12a0\u1203\u12de\u127d" },
            { "type.nu.taml", "\u1263\u1205\u120b\u12ca \u12e8\u1273\u121a\u120d \u1241\u1325\u122e\u127d" },
            { "type.nu.telu", "\u12e8\u1270\u120d\u1309 \u12a0\u1203\u12de\u127d" },
            { "type.nu.thai", "\u12e8\u1273\u12ed \u12a0\u1203\u12de\u127d" },
            { "type.nu.tibt", "\u12e8\u1272\u1264\u1275 \u12a0\u1203\u12de\u127d" },
            { "type.nu.vaii", "\u12e8\u126b\u12ed \u12a0\u1203\u12de\u127d" },
            { "type.ca.dangi", "\u12e8\u12f3\u1295\u130a \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.co.ducet", "\u12e8\u1290\u1263\u122a \u12e9\u1292\u12ae\u12f5 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.lb.loose", "\u120b\u120b \u12eb\u1208 \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "type.nu.roman", "\u12e8\u122e\u121b\u1295 \u1241\u1325\u122e\u127d" },
            { "type.ca.coptic", "\u12e8\u12ae\u1355\u1272\u12ad \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.hebrew", "\u12e8\u12a5\u1265\u122b\u12ca\u12eb\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.indian", "\u12e8\u1205\u1295\u12f5 \u1265\u1214\u122b\u12ca \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.co.pinyin", "\u1352\u1295\u12ed\u1295 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.co.search", "\u1208\u1320\u1245\u120b\u120b \u1309\u12f3\u12ed \u134d\u1208\u130b" },
            { "type.co.stroke", "\u12e8\u1260\u1275\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.co.unihan", "\u12e8\u1218\u1230\u1228\u1273\u12ca \u1260\u1275\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.d0.fwidth", "\u1219\u1209 \u12c8\u122d\u12f5" },
            { "type.d0.hwidth", "\u130d\u121b\u123d \u12c8\u122d\u12f5" },
            { "type.lb.normal", "\u1218\u12f0\u1260\u129b \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "type.lb.strict", "\u1320\u1260\u1245 \u12eb\u1208 \u1218\u1235\u1218\u122d \u1218\u1235\u1260\u122a\u12eb \u1245\u1325" },
            { "type.m0.ungegn", "\u12e9\u12a4\u1295 \u1302\u12a2\u1302\u12a4\u1295 \u1275\u122b\u1295\u1235\u120a\u1275\u122c\u123d\u1295" },
            { "type.ms.metric", "\u121c\u1275\u122a\u12ad \u1235\u122d\u12d3\u1275" },
            { "type.nu.native", "\u1200\u1308\u122d \u1260\u1240\u120d \u12a0\u1203\u12de\u127d" },
            { "type.ca.chinese", "\u12e8\u127b\u12ed\u1293 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.islamic", "\u12e8\u1202\u1305\u122b \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.iso8601", "ISO-8601 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.persian", "\u12e8\u1350\u122d\u123d\u12eb \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.cf.account", "\u12e8\u1202\u1233\u1265 \u121d\u1295\u12db\u122a \u1245\u122d\u1338\u1275" },
            { "type.co.big5han", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d - \u1275\u120d\u12455" },
            { "type.d0.npinyin", "\u12a0\u1203\u12db\u12ca" },
            { "type.nu.arabext", "\u12e8\u1270\u122b\u12d8\u1219 \u12e8\u12a0\u1228\u1262\u12ad-\u12a2\u1295\u12f2\u12ad \u12a0\u1203\u12de\u127d" },
            { "type.nu.armnlow", "\u12e8\u12a0\u121c\u122a\u12ab \u1295\u12d1\u1235 \u1206\u1204 \u12a0\u1203\u12de\u127d" },
            { "type.nu.finance", "\u12e8\u134b\u12ed\u1293\u1295\u1235 \u1241\u1325\u122e\u127d" },
            { "type.nu.greklow", "\u12e8\u130d\u122a\u12ad \u1295\u12d1\u1235 \u1206\u1204 \u1241\u1325\u122e\u127d" },
            { "type.nu.hanidec", "\u12e8\u127b\u12ed\u1295\u129b \u12a0\u1235\u122d\u12ee\u123d \u1241\u1325\u122e\u127d" },
            { "type.nu.hansfin", "\u1240\u1208\u120d \u12eb\u1209 \u12e8\u127b\u12ed\u1295\u129b \u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "type.nu.hantfin", "\u12e8\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b \u12e8\u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "type.nu.jpanfin", "\u12e8\u1303\u1353\u1295\u129b \u12e8\u1308\u1295\u12d8\u1265 \u1290\u12ad \u1241\u1325\u122e\u127d" },
            { "type.nu.tamldec", "\u12e8\u1273\u121a\u120d \u12a0\u1203\u12de\u127d" },
            { "type.ca.buddhist", "\u12e8\u1261\u12f2\u1235\u1275 \u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.ethiopic", "\u12e8\u12a2\u1275\u12ee\u1335\u12eb \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.ca.japanese", "\u12e8\u1303\u1353\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.cf.standard", "\u1218\u12f0\u1260\u129b \u12e8\u121d\u1295\u12db\u122a \u1245\u122d\u1338\u1275" },
            { "type.co.phonetic", "\u12e8\u134e\u1290\u1272\u12ad \u12f5\u122d\u12f0\u122b \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.co.searchjl", "\u1260\u1203\u1295\u1309\u120d \u12e8\u1218\u1300\u1218\u122a\u12eb \u1270\u1290\u1263\u1262 \u1348\u120d\u130d" },
            { "type.co.standard", "\u1218\u12f0\u1260\u129b \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.ms.uksystem", "\u12a2\u121d\u1354\u122a\u12eb\u120d \u12e8\u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "type.ms.ussystem", "\u12e8\u12a0\u121c\u122a\u12ab \u1218\u1208\u12aa\u12eb \u1235\u122d\u12d3\u1275" },
            { "type.nu.fullwide", "\u12e8\u1219\u1209 \u12c8\u122d\u12f5 \u12a0\u1203\u12de\u127d" },
            { "type.nu.romanlow", "\u12e8\u122e\u121b\u1295 \u1295\u12d1\u1235 \u1206\u1204 \u1241\u1325\u122e\u127d" },
            { "type.ca.gregorian", "\u12e8\u130d\u122a\u130e\u122a\u12eb\u1295 \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
            { "type.co.gb2312han", "\u12e8\u1240\u1208\u1208 \u12e8\u127b\u12ed\u1295\u129b \u12e8\u12f5\u122d\u12f0\u122b \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d - GB2312" },
            { "type.co.phonebook", "\u12e8\u1235\u120d\u12ad \u12f0\u1265\u1270\u122d \u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "ListKeyTypePattern", "{0}\u1366 {1}" },
            { "type.co.dictionary", "\u12e8\u1218\u12dd\u1308\u1260 \u1243\u120b\u1275 \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.co.traditional", "\u1263\u1205\u120b\u12ca \u12e8\u12f5\u122d\u12f5\u122d \u1245\u12f0\u121d \u1270\u12a8\u1270\u120d" },
            { "type.nu.traditional", "\u1270\u1208\u121d\u12f7\u12ca \u1241\u1325\u122e\u127d" },
            { "type.ca.islamic-civil", "\u12e8\u1202\u1305\u122b \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d (\u1273\u1261\u120b\u122d\u1363 \u1232\u126a\u120d \u12a0\u1356\u127d)" },
            { "ListCompositionPattern", "{0}\u1363 {1}" },
            { "type.ca.islamic-umalqura", "\u12e8\u1202\u1305\u122b \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d (\u12a1\u121d \u12a0\u120d-\u1241\u122b)" },
            { "type.ca.ethiopic-amete-alem", "\u12e8\u12a2\u1275\u12ee\u1352\u12ad \u12a0\u1218\u1270 \u12a0\u1208\u121d \u12e8\u1240\u1295 \u12a0\u1246\u1323\u1320\u122d" },
        };
        return data;
    }
}
