/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv_Orya extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_EE = "\u0b0f\u0b38\u0b4d\u0b1f\u0b28\u0b3f\u0b06";
        final String metaValue_chr = "\u0b1a\u0b47\u0b30\u0b15\u0b40";
        final String metaValue_ml = "\u0b2e\u0b3e\u0b32\u0b3e\u0b5f\u0b32\u0b2e\u0b4d";
        final String metaValue_or = "\u0b05\u0b21\u0b3c\u0b3f\u0b06";
        final String metaValue_ta = "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d";
        final String metaValue_te = "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41";
        final Object[][] data = new Object[][] {
            { "419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e" },
            { "AD", "\u0b06\u0b23\u0b4d\u0b21\u0b4b\u0b30\u0b3e" },
            { "AE", "\u0b06\u0b23\u0b4d\u0b21\u0b3f\u0b24\u0b3f \u0b06\u0b30\u0b2c \u0b0f\u0b2e\u0b3f\u0b30\u0b47\u0b1f\u0b38\u0b4d" },
            { "AF", "\u0b06\u0b2a\u0b17\u0b3e\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28\u0b4d" },
            { "AG", "\u0b0f\u0b23\u0b4d\u0b1f\u0b3f\u0b17\u0b41\u0b06 \u0b05\u0b21\u0b3c\u0b47 \u0b2c\u0b3e\u0b30\u0b2c\u0b41\u0b26\u0b3e" },
            { "AI", "\u0b0f\u0b19\u0b4d\u0b17\u0b4d\u0b71\u0b3f\u0b32\u0b3e" },
            { "AL", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06" },
            { "AM", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06" },
            { "AO", "\u0b05\u0b19\u0b4d\u0b17\u0b32\u0b3e" },
            { "AQ", "\u0b06\u0b23\u0b4d\u0b1f\u0b3e\u0b30\u0b4d\u0b15\u0b1f\u0b3f\u0b15\u0b3e" },
            { "AR", "\u0b05\u0b30\u0b4d\u0b1c\u0b47\u0b23\u0b4d\u0b1f\u0b3f\u0b28\u0b3e" },
            { "AS", "\u0b05\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e \u0b24\u0b3f \u0b38\u0b2e\u0b71\u0b3e" },
            { "AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06" },
            { "AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b06" },
            { "AW", "\u0b05\u0b30\u0b41\u0b2c\u0b3e" },
            { "AX", "\u0b0f\u0b32\u0b47\u0b23\u0b4d\u0b21" },
            { "AZ", "\u0b05\u0b1c\u0b47\u0b30\u0b4d\u200d\u200d\u0b2c\u0b3e\u0b07\u0b1c\u0b3e\u0b28\u0b4d" },
            { "BA", "\u0b2c\u0b38\u0b4d\u0b28\u0b3f\u0b06 \u0b05\u0b21\u0b3c\u0b47 \u0b39\u0b30\u0b4d\u0b1c\u0b17\u0b71\u0b3f\u0b28\u0b3e" },
            { "BB", "\u0b2c\u0b3e\u0b30\u0b4d\u200d\u0b2c\u0b21\u0b38" },
            { "BD", "\u0b2c\u0b3e\u0b02\u0b32\u0b3e\u0b26\u0b47\u0b36" },
            { "BE", "\u0b2c\u0b47\u0b32\u0b1c\u0b3f\u0b5f\u0b2e\u0b4d" },
            { "BF", "\u0b2c\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b28\u0b3e \u0b2a\u0b3e\u0b38\u0b4d\u0b71" },
            { "BG", "\u0b2c\u0b41\u0b32\u0b4d\u200d\u0b17\u0b3e\u0b30\u0b3f\u0b06" },
            { "BH", "\u0b2c\u0b39\u0b30\u0b47\u0b28\u0b4d" },
            { "BI", "\u0b2c\u0b41\u0b30\u0b41\u0b28\u0b4d\u0b26\u0b3f" },
            { "BJ", "\u0b2c\u0b47\u0b28\u0b3f\u0b28\u0b4d" },
            { "BL", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2c\u0b3e\u0b30\u0b4d\u0b24\u0b47\u0b32\u0b47\u0b2e\u0b3f" },
            { "BM", "\u0b2c\u0b30\u0b4d\u200d\u0b2e\u0b41\u0b23\u0b4d\u0b21\u0b3e" },
            { "BN", "\u0b2c\u0b4d\u0b30\u0b42\u0b28\u0b47\u0b07" },
            { "BO", "\u0b2c\u0b32\u0b3f\u0b71\u0b3f\u0b5f\u0b3e" },
            { "BQ", "\u0b15\u0b3e\u0b30\u0b3f\u0b2c\u0b3f\u0b5f\u0b28 \u0b28\u0b47\u0b26\u0b30\u0b32\u0b4d\u0b5f\u0b3e\u0b23\u0b4d\u0b21\u0b38\u0b4d" },
            { "BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b4d" },
            { "BS", "\u0b2c\u0b3e\u0b39\u0b3e\u0b2e\u0b3e\u0b38\u0b4d" },
            { "BT", "\u0b2c\u0b41\u0b1f\u0b3e\u0b28" },
            { "BW", "\u0b2c\u0b38\u0b4d\u0b1f\u0b71\u0b3e\u0b28\u0b3e" },
            { "BY", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b42\u0b38\u0b4d" },
            { "BZ", "\u0b2c\u0b47\u0b32\u0b3f\u0b1c\u0b4d" },
            { "CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3e" },
            { "CC", "\u0b15\u0b15\u0b38\u0b4d (\u0b15\u0b3f\u0b32\u0b3f\u0b02) \u0b26\u0b3f\u0b2a" },
            { "CD", "\u0b15\u0b19\u0b4d\u0b17-\u0b15\u0b3f\u0b02\u0b38\u0b3e\u0b38\u0b3e" },
            { "CF", "\u0b2e\u0b3e\u0b26\u0b3f\u0b28\u0b3f \u0b06\u0b2a\u0b4d\u0b30\u0b3f\u0b15\u0b3e \u0b30\u0b3f\u0b2a\u0b2c\u0b4d\u0b32\u0b3f\u0b15\u0b4d" },
            { "CG", "\u0b15\u0b02\u0b19\u0b4d\u0b17- \u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3e\u0b71\u0b3f\u0b32\u0b3f" },
            { "CH", "\u0b38\u0b4d\u0b71\u0b40\u0b1c\u0b05\u0b30\u0b4d\u200d\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "CI", "\u0b15\u0b1f \u0b21\u0b3f \u0b71\u0b3e" },
            { "CK", "\u0b15\u0b41\u0b15 \u0b26\u0b3f\u0b2a" },
            { "CL", "\u0b1a\u0b3f\u0b32\u0b3f" },
            { "CM", "\u0b15\u0b3e\u0b2e\u0b47\u0b30\u0b28\u0b4d" },
            { "CN", "\u0b1a\u0b3f\u0b28\u0b4d" },
            { "CO", "\u0b15\u0b32\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "CR", "\u0b15\u0b38\u0b4d\u0b1f\u0b3e \u0b30\u0b3f\u0b15\u0b3e" },
            { "CU", "\u0b15\u0b4d\u0b5f\u0b41\u0b2c\u0b3e" },
            { "CV", "\u0b15\u0b47\u0b2a\u0b4d \u0b71\u0b21\u0b3c" },
            { "CW", "\u0b15\u0b4d\u0b5f\u0b41\u0b30\u0b3e\u0b38\u0b3e\u0b05" },
            { "CX", "\u0b15\u0b4d\u0b30\u0b3f\u0b38\u0b4d\u0b1f\u0b2e\u0b3e\u0b38\u0b4d \u0b26\u0b3f\u0b2a" },
            { "CY", "\u0b38\u0b3e\u0b07\u0b2a\u0b4d\u0b30\u0b38\u0b4d" },
            { "CZ", "\u0b1a\u0b47\u0b15\u0b3f\u0b06" },
            { "DE", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b3f" },
            { "DG", "\u0b21\u0b3f\u0b0f\u0b17 \u0b17\u0b3e\u0b30\u0b4d\u0b38\u0b3f\u0b06" },
            { "DJ", "\u0b1c\u0b3f\u0b2c\u0b41\u0b24\u0b3f" },
            { "DK", "\u0b21\u0b47\u0b28\u0b2e\u0b3e\u0b30\u0b4d\u0b15" },
            { "DM", "\u0b21\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e" },
            { "DO", "\u0b21\u0b2e\u0b3f\u0b28\u0b3f\u0b15\u0b3e \u0b24\u0b3f \u0b30\u0b3f\u0b2a\u0b2c\u0b4d\u0b32\u0b3f\u0b15\u0b4d" },
            { "DZ", "\u0b05\u0b32\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "EA", "\u0b38\u0b47\u0b05\u0b1f\u0b3e \u0b05\u0b21\u0b3c\u0b47 \u0b2e\u0b47\u0b32\u0b3f\u0b32\u0b3e" },
            { "EC", "\u0b07\u0b15\u0b4d\u0b71\u0b3e\u0b21\u0b30" },
            { "EE", metaValue_EE },
            { "EG", "\u0b07\u0b1c\u0b3f\u0b2a\u0b4d\u0b1f" },
            { "EH", "\u0b71\u0b47\u0b21\u0b3c\u0b3e\u0b15\u0b41\u0b23\u0b4d\u0b2a\u0b41 \u0b38\u0b3e\u0b39\u0b3e\u0b30\u0b3e" },
            { "ER", "\u0b07\u0b30\u0b3f\u0b1f\u0b4d\u0b30\u0b3f\u0b06" },
            { "ES", "\u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b4d" },
            { "ET", "\u0b07\u0b24\u0b3f\u0b5f\u0b2a\u0b3f\u0b06" },
            { "FI", "\u0b2a\u0b3f\u0b28\u0b4d\u200d\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "FJ", "\u0b2a\u0b3f\u0b1c\u0b3f" },
            { "FK", "\u0b2a\u0b3e\u0b15\u0b4d\u200d\u0b32\u0b3e\u0b23\u0b4d\u0b21 \u0b26\u0b3f\u0b2a" },
            { "FM", "\u0b2e\u0b3e\u0b15\u0b4d\u0b30\u0b28\u0b47\u0b38\u0b3f\u0b06" },
            { "FO", "\u0b2a\u0b47\u0b30\u0b4b \u0b26\u0b40\u0b2a" },
            { "FR", "\u0b2a\u0b4d\u0b30\u0b3e\u0b28\u0b4d\u0b38" },
            { "GA", "\u0b17\u0b3e\u0b2c\u0b28" },
            { "GB", "\u0b07\u0b09\u0b28\u0b3e\u0b07\u0b1f\u0b47\u0b21\u0b4d \u0b15\u0b3f\u0b02\u0b21\u0b2e\u0b4d" },
            { "GD", "\u0b17\u0b4d\u0b30\u0b47\u0b28\u0b3e\u0b21\u0b3e" },
            { "GE", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06" },
            { "GF", "\u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u0b4d \u0b17\u0b41\u0b5f\u0b3e\u0b28\u0b3e" },
            { "GG", "\u0b17\u0b30\u0b4d\u0b28\u0b38\u0b3f" },
            { "GH", "\u0b17\u0b3e\u0b28\u0b3e" },
            { "GI", "\u0b1c\u0b3f\u0b2c\u0b4d\u0b30\u0b3e\u0b32\u0b1f\u0b30" },
            { "GL", "\u0b17\u0b4d\u0b30\u0b40\u0b28\u0b4d \u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "GM", "\u0b17\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b06" },
            { "GN", "\u0b17\u0b3f\u0b28\u0b3f" },
            { "GP", "\u0b17\u0b4d\u0b71\u0b3e\u0b21\u0b47\u0b32\u0b41\u0b2a" },
            { "GQ", "\u0b07\u0b15\u0b4d\u0b5f\u0b41\u0b0f\u0b1f\u0b47\u0b30\u0b3f\u0b5f\u0b32 \u0b17\u0b3f\u0b28\u0b3f" },
            { "GR", "\u0b17\u0b4d\u0b30\u0b3f\u0b38\u0b4d" },
            { "GS", "\u0b26\u0b15\u0b3f\u0b28 \u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b06 \u0b05\u0b21\u0b3c\u0b47 \u0b26\u0b15\u0b3f\u0b28 \u0b38\u0b3e\u0b23\u0b4d\u0b21\u0b71\u0b3f\u0b1a\u0b4d \u0b26\u0b40\u0b2a" },
            { "GT", "\u0b17\u0b4d\u0b71\u0b3e\u0b1f\u0b47\u0b2e\u0b3e\u0b32\u0b3e" },
            { "GU", "\u0b17\u0b41\u0b06\u0b2e\u0b4d" },
            { "GW", "\u0b17\u0b3f\u0b28\u0b3f \u0b2c\u0b3f\u0b38\u0b3e\u0b09" },
            { "GY", "\u0b17\u0b41\u0b5f\u0b3e\u0b28\u0b3e" },
            { "HK", "\u0b39\u0b02\u0b17 \u0b15\u0b02\u0b17 (\u0b0f\u0b38\u0b0f\u0b06\u0b30\u0b4d \u0b1a\u0b3f\u0b28\u0b3e)" },
            { "HN", "\u0b39\u0b23\u0b4d\u0b21\u0b41\u0b30\u0b3e\u0b38" },
            { "HR", "\u0b15\u0b4d\u0b30\u0b38\u0b3f\u0b06" },
            { "HT", "\u0b39\u0b3e\u0b07\u0b24\u0b3f" },
            { "HU", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b3f" },
            { "IC", "\u0b15\u0b47\u0b28\u0b3e\u0b30\u0b3f \u0b26\u0b3f\u0b2a" },
            { "ID", "\u0b07\u0b23\u0b4d\u0b21\u0b28\u0b47\u0b38\u0b3f\u0b5f\u0b3e" },
            { "IE", "\u0b05\u0b07\u0b30\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "IL", "\u0b07\u0b38\u0b30\u0b3e\u0b07\u0b32" },
            { "IM", "\u0b2e\u0b3e\u0b23\u0b3f\u0b38\u0b3f \u0b24\u0b3e \u0b26\u0b3f\u0b2a" },
            { "IN", "\u0b2c\u0b3e\u0b30\u0b24" },
            { "IO", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b38\u0b4d \u0b39\u0b3f\u0b28\u0b4d\u0b26 \u0b38\u0b3e\u0b2e\u0b41\u0b26\u0b4d\u0b30\u0b3f \u0b39\u0b3e\u0b28\u0b4d\u0b26\u0b3f" },
            { "IQ", "\u0b07\u0b30\u0b3e\u0b15" },
            { "IR", "\u0b07\u0b30\u0b3e\u0b28" },
            { "IS", "\u0b06\u0b07\u0b38\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "IT", "\u0b07\u0b1f\u0b3e\u0b32\u0b3f" },
            { "JE", "\u0b1c\u0b30\u0b38\u0b3f" },
            { "JM", "\u0b1c\u0b3e\u0b2e\u0b3e\u0b07\u0b15\u0b3e" },
            { "JO", "\u0b1c\u0b30\u0b4d\u0b21\u0b3e\u0b28" },
            { "JP", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28" },
            { "KE", "\u0b15\u0b47\u0b28\u0b4d\u0b5f\u0b3e" },
            { "KG", "\u0b15\u0b3f\u0b30\u0b17\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "KH", "\u0b15\u0b2e\u0b4d\u0b2c\u0b21\u0b3f\u0b06" },
            { "KI", "\u0b15\u0b3f\u0b30\u0b3f\u0b2c\u0b3e\u0b24\u0b3f" },
            { "KM", "\u0b15\u0b2e\u0b30\u0b38" },
            { "KN", "\u0b38\u0b47\u0b23\u0b4d\u0b1f. \u0b15\u0b3f\u0b1f\u0b4d\u0b38 \u0b05\u0b21\u0b3c\u0b47 \u0b28\u0b47\u0b2c\u0b3f\u0b38" },
            { "KP", "\u0b09\u0b24\u0b30 \u0b15\u0b30\u0b3f\u0b5f\u0b3e" },
            { "KR", "\u0b26\u0b15\u0b3f\u0b23 \u0b15\u0b30\u0b3f\u0b5f\u0b3e" },
            { "KW", "\u0b15\u0b41\u0b71\u0b47\u0b24\u0b4d" },
            { "KY", "\u0b15\u0b3e\u0b07\u0b2e\u0b3e\u0b28 \u0b26\u0b3f\u0b2a" },
            { "KZ", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "LA", "\u0b32\u0b3e\u0b05\u0b38\u0b4d" },
            { "LB", "\u0b32\u0b47\u0b2c\u0b28\u0b3e\u0b28" },
            { "LC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f. \u0b32\u0b41\u0b38\u0b3f\u0b06" },
            { "LI", "\u0b32\u0b3f\u0b15\u0b4d\u200d\u0b1f\u0b28\u0b4d\u200d\u0b38\u0b4d\u0b1f\u0b3e\u0b07\u0b28\u0b4d" },
            { "LK", "\u0b38\u0b4d\u0b30\u0b3f \u0b32\u0b19\u0b4d\u0b15\u0b3e" },
            { "LR", "\u0b32\u0b3e\u0b07\u0b2c\u0b47\u0b30\u0b3f\u0b06" },
            { "LS", "\u0b32\u0b47\u0b38\u0b24" },
            { "LT", "\u0b32\u0b3f\u0b24\u0b41\u0b06\u0b28\u0b3f\u0b06" },
            { "LU", "\u0b32\u0b17\u0b4d\u0b1c\u0b2e\u0b2c\u0b30\u0b4d\u0b17" },
            { "LV", "\u0b32\u0b3e\u0b24\u0b4d\u200d\u0b71\u0b3f\u0b5f\u0b3e" },
            { "LY", "\u0b32\u0b3f\u0b2c\u0b3f\u0b5f\u0b3e" },
            { "MA", "\u0b2e\u0b30\u0b15" },
            { "MC", "\u0b2e\u0b28\u0b3e\u0b15" },
            { "MD", "\u0b2e\u0b32\u0b4d\u200d\u0b21\u0b71\u0b3e" },
            { "ME", "\u0b2e\u0b23\u0b4d\u0b1f\u0b47\u0b28\u0b47\u0b17\u0b4d\u0b30" },
            { "MF", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28" },
            { "MG", "\u0b2e\u0b3e\u0b21\u0b3c\u0b3e\u0b17\u0b3e\u0b38\u0b4d\u0b15\u0b3e\u0b30" },
            { "MH", "\u0b2e\u0b3e\u0b30\u0b4d\u0b38\u0b3e\u0b32 \u0b26\u0b3f\u0b2a" },
            { "MK", "\u0b09\u0b24\u0b30 \u0b2e\u0b3e\u0b38\u0b3e\u0b21\u0b28\u0b3f\u0b5f\u0b3e" },
            { "ML", "\u0b2e\u0b3e\u0b32\u0b3f" },
            { "MM", "\u0b2e\u0b3f\u0b5f\u0b3e\u0b01\u0b2e\u0b3e\u0b30 (\u0b2c\u0b30\u0b4d\u0b2e\u0b3e)" },
            { "MN", "\u0b2e\u0b19\u0b4d\u0b17\u0b32\u0b3f\u0b5f\u0b3e" },
            { "MO", "\u0b2e\u0b15\u0b3e\u0b09 \u0b0f\u0b38\u0b0f\u0b06\u0b30 \u0b1a\u0b3f\u0b28\u0b3e" },
            { "MP", "\u0b09\u0b24\u0b30 \u0b2e\u0b3e\u0b30\u0b3f\u0b5f\u0b3e\u0b28 \u0b26\u0b3f\u0b2a" },
            { "MQ", "\u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28\u0b3f\u0b15\u0b4d" },
            { "MR", "\u0b2e\u0b09\u0b30\u0b3f\u0b1f\u0b3e\u0b28\u0b3f\u0b5f\u0b3e" },
            { "MS", "\u0b2e\u0b23\u0b4d\u0b1f\u0b38\u0b47\u0b30\u0b47\u0b1f" },
            { "MT", "\u0b2e\u0b3e\u0b32\u0b4d\u0b1f\u0b3e" },
            { "MU", "\u0b2e\u0b30\u0b3f\u0b38\u0b38\u0b4d" },
            { "MV", "\u0b2e\u0b3e\u0b32\u0b26\u0b40\u0b2a\u0b3f" },
            { "MW", "\u0b2e\u0b32\u0b3e\u0b71\u0b3f" },
            { "MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15" },
            { "MY", "\u0b2e\u0b3e\u0b32\u0b47\u0b38\u0b3f\u0b06" },
            { "MZ", "\u0b2e\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b15" },
            { "NA", "\u0b28\u0b3e\u0b2e\u0b3f\u0b2c\u0b3f\u0b5f\u0b3e" },
            { "NC", "\u0b28\u0b4d\u0b5f\u0b41 \u0b15\u0b47\u0b32\u0b47\u0b21\u0b28\u0b3f\u0b5f\u0b3e" },
            { "NE", "\u0b28\u0b3e\u0b07\u0b1c\u0b30" },
            { "NF", "\u0b28\u0b30\u0b4d\u200d\u0b2a\u0b15\u0b4d \u0b26\u0b3f\u0b2a" },
            { "NG", "\u0b28\u0b3e\u0b07\u0b1c\u0b47\u0b30\u0b3f\u0b06" },
            { "NI", "\u0b28\u0b3f\u0b15\u0b3e\u0b30\u0b17\u0b41\u0b06" },
            { "NL", "\u0b28\u0b47\u0b26\u0b30\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "NO", "\u0b28\u0b30\u0b71\u0b47" },
            { "NP", "\u0b28\u0b47\u0b2a\u0b3e\u0b32" },
            { "NR", "\u0b28\u0b3e\u0b09\u0b30\u0b41" },
            { "NU", "\u0b28\u0b3f\u0b5f\u0b41" },
            { "NZ", "\u0b28\u0b3f\u0b5f\u0b41\u0b1c\u0b3f\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "OM", "\u0b05\u0b2e\u0b3e\u0b28" },
            { "PA", "\u0b2a\u0b28\u0b2e\u0b3e" },
            { "PE", "\u0b2a\u0b47\u0b30\u0b41" },
            { "PF", "\u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u0b4d \u0b2a\u0b32\u0b3f\u0b28\u0b47\u0b38\u0b3f\u0b5f\u0b3e" },
            { "PG", "\u0b2a\u0b2a\u0b41\u0b06 \u0b28\u0b3f\u0b5f\u0b41 \u0b17\u0b3f\u0b28\u0b3f" },
            { "PH", "\u0b2a\u0b3f\u0b32\u0b3f\u0b2a\u0b3e\u0b07\u0b28\u0b4d\u0b38" },
            { "PK", "\u0b2a\u0b3e\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "PL", "\u0b2a\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "PM", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b2a\u0b3f\u0b0f\u0b30\u0b47 \u0b05\u0b21\u0b3c\u0b47 \u0b2e\u0b3f\u0b15\u0b4d\u0b71\u0b47\u0b32\u0b3e\u0b28" },
            { "PN", "\u0b2a\u0b3f\u0b1f\u0b4d\u200d\u0b15\u0b07\u0b30\u0b4d\u0b28\u0b4d \u0b26\u0b3f\u0b2a" },
            { "PR", "\u0b2a\u0b30\u0b4d\u0b1f \u0b30\u0b3f\u0b15" },
            { "PS", "\u0b2a\u0b3e\u0b32\u0b47\u0b38\u0b4d\u0b1f\u0b3f\u0b06\u0b24\u0b3f \u0b39\u0b3e\u0b28\u0b4d\u0b26\u0b3f" },
            { "PT", "\u0b2a\u0b30\u0b4d\u0b24\u0b41\u0b17\u0b3e\u0b32" },
            { "PW", "\u0b2a\u0b32\u0b3e\u0b09" },
            { "PY", "\u0b2a\u0b30\u0b17\u0b4d\u0b71\u0b47" },
            { "QA", "\u0b15\u0b24\u0b30" },
            { "RE", "\u0b30\u0b3f\u0b5f\u0b41\u0b28\u0b3f\u0b5f\u0b28" },
            { "RO", "\u0b30\u0b2e\u0b3e\u0b28\u0b3f\u0b06" },
            { "RS", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b5f\u0b3e" },
            { "RU", "\u0b30\u0b41\u0b38\u0b3f\u0b06" },
            { "RW", "\u0b30\u0b4d\u200d\u0b71\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "SA", "\u0b38\u0b3e\u0b09\u0b26\u0b3f \u0b06\u0b30\u0b2c" },
            { "SB", "\u0b38\u0b32\u0b2e\u0b28 \u0b26\u0b3f\u0b2a" },
            { "SC", "\u0b38\u0b3f\u0b38\u0b47\u0b32\u0b4d\u0b38" },
            { "SD", "\u0b38\u0b41\u0b21\u0b3e\u0b28" },
            { "SE", "\u0b38\u0b4d\u0b71\u0b3f\u0b21\u0b47\u0b28" },
            { "SG", "\u0b38\u0b3f\u0b19\u0b4d\u0b17\u0b3e\u0b2a\u0b41\u0b30" },
            { "SH", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b39\u0b47\u0b32\u0b47\u0b28" },
            { "SI", "\u0b38\u0b4d\u0b32\u0b2c\u0b47\u0b28\u0b3f\u0b06" },
            { "SJ", "\u0b38\u0b4d\u0b71\u0b3e\u0b32\u0b2c\u0b3e\u0b30\u0b4d\u0b21 \u0b05\u0b21\u0b3c\u0b47 \u0b1c\u0b3e\u0b28 \u0b2e\u0b3e\u0b5f\u0b47\u0b28" },
            { "SK", "\u0b38\u0b4d\u0b32\u0b2c\u0b3e\u0b15\u0b3f\u0b5f\u0b3e" },
            { "SL", "\u0b38\u0b3f\u0b0f\u0b30\u0b3e \u0b32\u0b3f\u0b5f\u0b28" },
            { "SM", "\u0b38\u0b28 \u0b2e\u0b3e\u0b30\u0b3f\u0b28" },
            { "SN", "\u0b38\u0b47\u0b28\u0b47\u0b17\u0b3e\u0b32" },
            { "SO", "\u0b38\u0b2e\u0b3e\u0b32\u0b3f\u0b06" },
            { "SR", "\u0b38\u0b41\u0b30\u0b3f\u0b28\u0b3e\u0b2e" },
            { "SS", "\u0b26\u0b15\u0b3f\u0b23 \u0b38\u0b41\u0b21\u0b3e\u0b28" },
            { "ST", "\u0b38\u0b3e\u0b05 \u0b1f\u0b2e \u0b05\u0b21\u0b3c\u0b47 \u0b2a\u0b4d\u0b30\u0b3f\u0b28\u0b4d\u0b38\u0b3f\u0b2a\u0b47" },
            { "SV", "\u0b05\u0b32 \u0b38\u0b32\u0b2c\u0b3e\u0b21\u0b30" },
            { "SX", "\u0b38\u0b3f\u0b23\u0b4d\u0b1f \u0b2e\u0b3e\u0b30\u0b4d\u0b1f\u0b3f\u0b28" },
            { "SY", "\u0b38\u0b3f\u0b30\u0b3f\u0b5f\u0b3e" },
            { "SZ", "\u0b0f\u0b38\u0b4d\u0b71\u0b3e\u0b1f\u0b3f\u0b28\u0b3f" },
            { "TC", "\u0b24\u0b41\u0b30\u0b4d\u0b15 \u0b05\u0b21\u0b3c\u0b47 \u0b15\u0b3e\u0b07\u0b15\u0b38 \u0b26\u0b3f\u0b2a" },
            { "TD", "\u0b1a\u0b3e\u0b21" },
            { "TF", "\u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a \u0b26\u0b15\u0b3f\u0b28\u0b40\u0b5f \u0b1f\u0b47\u0b30\u0b3f\u0b1f\u0b4b\u0b30\u0b40" },
            { "TG", "\u0b1f\u0b17" },
            { "TH", "\u0b24\u0b3e\u0b07\u0b32\u0b3e\u0b23\u0b4d\u0b21" },
            { "TJ", "\u0b24\u0b3e\u0b1c\u0b3f\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "TK", "\u0b24\u0b15\u0b47\u0b32\u0b3e\u0b09" },
            { "TL", "\u0b24\u0b3f\u0b2e\u0b30-\u0b32\u0b47\u0b38\u0b4d\u0b24\u0b47" },
            { "TM", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b2e\u0b47\u0b28\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "TN", "\u0b1f\u0b4d\u0b5f\u0b41\u0b28\u0b3f\u0b38\u0b3f\u0b5f\u0b3e" },
            { "TO", "\u0b1f\u0b19\u0b4d\u0b17" },
            { "TR", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f" },
            { "TT", "\u0b24\u0b4d\u0b30\u0b3f\u0b28\u0b3f\u0b21\u0b3e\u0b21 \u0b05\u0b21\u0b3c\u0b47 \u0b1f\u0b2c\u0b3e\u0b17" },
            { "TV", "\u0b24\u0b41\u0b71\u0b3e\u0b32\u0b41" },
            { "TW", "\u0b24\u0b3e\u0b07\u0b71\u0b3e\u0b28" },
            { "TZ", "\u0b24\u0b3e\u0b1e\u0b4d\u0b1c\u0b3e\u0b28\u0b3f\u0b5f\u0b3e" },
            { "UA", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b47\u0b28\u0b4d" },
            { "UG", "\u0b09\u0b17\u0b3e\u0b23\u0b4d\u0b21\u0b3e" },
            { "UM", "\u0b5f\u0b41 \u0b0f\u0b38\u0b4d \u0b06\u0b09\u0b1f\u0b32\u0b3e\u0b07\u0b19\u0b4d\u0b15 \u0b26\u0b3f\u0b2a" },
            { "US", "\u0b06\u0b23\u0b4d\u0b21\u0b3f\u0b24\u0b3f \u0b30\u0b3e\u0b1c\u0b4d\u0b5f" },
            { "UY", "\u0b09\u0b30\u0b41\u0b17\u0b4d\u0b71\u0b47" },
            { "UZ", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b3f\u0b38\u0b4d\u0b24\u0b3e\u0b28" },
            { "VA", "\u0b2c\u0b3e\u0b1f\u0b3f\u0b15\u0b3e\u0b28\u0b4d \u0b38\u0b3f\u0b1f\u0b3f" },
            { "VC", "\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b71\u0b3f\u0b28\u0b38\u0b47\u0b23\u0b4d\u0b1f \u0b05\u0b21\u0b3c\u0b47 \u0b17\u0b4d\u0b30\u0b3f\u0b28\u0b3e\u0b21\u0b3e\u0b07\u0b28\u0b4d\u0b38" },
            { "VE", "\u0b71\u0b47\u0b28\u0b47\u0b1c\u0b41\u0b0f\u0b32" },
            { "VG", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b38\u0b4d \u0b71\u0b3f\u0b30\u0b1c\u0b3f\u0b28 \u0b26\u0b3f\u0b2a" },
            { "VI", "\u0b5f\u0b41 \u0b0f\u0b38 \u0b71\u0b3f\u0b30\u0b1c\u0b3f\u0b28 \u0b26\u0b3f\u0b2a" },
            { "VN", "\u0b71\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e" },
            { "VU", "\u0b71\u0b3e\u0b28\u0b41\u0b06\u0b24\u0b41" },
            { "WF", "\u0b71\u0b3e\u0b32\u0b3f\u0b38 \u0b05\u0b21\u0b3c\u0b47 \u0b2a\u0b41\u0b1f\u0b41\u0b28\u0b3e" },
            { "WS", "\u0b38\u0b2e\u0b71\u0b3e" },
            { "XK", "\u0b15\u0b38\u0b71" },
            { "YE", "\u0b5f\u0b2e\u0b28" },
            { "YT", "\u0b2e\u0b3e\u0b5f\u0b24\u0b47" },
            { "ZA", "\u0b26\u0b15\u0b3f\u0b23 \u0b06\u0b2a\u0b4d\u0b30\u0b3f\u0b15\u0b3e" },
            { "ZM", "\u0b1c\u0b3e\u0b2e\u0b4d\u0b2c\u0b3f\u0b5f\u0b3e" },
            { "ZW", "\u0b1c\u0b3f\u0b2e\u0b4d\u0b2c\u0b3e\u0b71\u0b47" },
            { "af", "\u0b06\u0b2a\u0b4d\u0b30\u0b40\u0b15\u0b3e\u0b28\u0b4d\u200d\u0b38" },
            { "am", "\u0b06\u0b2e\u0b4d\u200d\u0b39\u0b47\u0b30\u0b3f" },
            { "ar", "\u0b06\u0b30\u0b2c\u0b3f\u0b15" },
            { "as", "\u0b06\u0b38\u0b3e\u0b2e\u0b3f\u0b1c\u0b4d" },
            { "az", "\u0b06\u0b1c\u0b47\u0b30\u0b2c\u0b47\u0b07\u0b1c\u0b3e\u0b28\u0b3f" },
            { "be", "\u0b2c\u0b47\u0b32\u0b3e\u0b30\u0b41\u0b37\u0b3f\u0b06\u0b28\u0b4d" },
            { "bg", "\u0b2c\u0b41\u0b32\u0b17\u0b3e\u0b30\u0b3f\u0b06\u0b28\u0b4d" },
            { "bn", "\u0b2c\u0b19\u0b4d\u0b17\u0b3e\u0b32\u0b3f" },
            { "bo", "\u0b24\u0b3f\u0b2c\u0b24\u0b3f" },
            { "bs", "\u0b2c\u0b38\u0b28\u0b3f\u0b06\u0b28\u0b4d" },
            { "ca", "\u0b15\u0b3e\u0b1f\u0b32\u0b3e\u0b28\u0b4d" },
            { "cs", "\u0b1a\u0b47\u0b15\u0b4d" },
            { "da", "\u0b21\u0b47\u0b28\u0b3f\u0b38\u0b4d" },
            { "de", "\u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28\u0b4d" },
            { "el", "\u0b17\u0b4d\u0b30\u0b40\u0b15\u0b4d" },
            { "en", "\u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "es", "\u0b38\u0b4d\u0b2a\u0b3e\u0b28\u0b3f\u0b38\u0b4d" },
            { "et", metaValue_EE },
            { "eu", "\u0b2c\u0b3e\u0b38\u0b4d\u0b15" },
            { "fa", "\u0b2a\u0b30\u0b4d\u0b38\u0b3f\u0b5f\u0b3e\u0b28\u0b4d" },
            { "fi", "\u0b2a\u0b3f\u0b28\u0b3f\u0b38\u0b4d" },
            { "fr", "\u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u200d" },
            { "gl", "\u0b17\u0b32\u0b38\u0b3f\u0b06\u0b24\u0b3f" },
            { "gu", "\u0b17\u0b41\u0b1c\u0b41\u0b30\u0b3e\u0b1f\u0b3f" },
            { "he", "\u0b39\u0b3f\u0b2c\u0b4d\u0b30\u0b41" },
            { "hi", "\u0b39\u0b3f\u0b28\u0b4d\u0b26\u0b3f" },
            { "hr", "\u0b15\u0b4d\u0b30\u0b0f\u0b38\u0b3f\u0b06\u0b24\u0b3f" },
            { "hu", "\u0b39\u0b19\u0b4d\u0b17\u0b47\u0b30\u0b40\u0b5f\u0b3e\u0b24\u0b3f" },
            { "hy", "\u0b06\u0b30\u0b4d\u0b2e\u0b47\u0b28\u0b3f\u0b06\u0b24\u0b3f" },
            { "id", "\u0b07\u0b23\u0b4d\u0b21\u0b28\u0b47\u0b38\u0b40\u0b5f\u0b3e \u0b24\u0b3f" },
            { "is", "\u0b06\u0b07\u0b38\u0b32\u0b3e\u0b23\u0b4d\u0b21\u0b3f\u0b15\u0b4d" },
            { "it", "\u0b07\u0b1f\u0b3e\u0b32\u0b3f \u0b24\u0b3f" },
            { "ja", "\u0b1c\u0b3e\u0b2a\u0b3e\u0b28\u0b3f\u0b1c\u0b4d" },
            { "ka", "\u0b1c\u0b30\u0b4d\u0b1c\u0b3f\u0b5f\u0b3e\u0b24\u0b3f" },
            { "kk", "\u0b15\u0b3e\u0b1c\u0b3e\u0b15\u0b4d" },
            { "km", "\u0b15\u0b3e\u0b2e\u0b47\u0b30\u0b4d" },
            { "kn", "\u0b15\u0b3e\u0b28\u0b4d\u0b28\u0b3e\u0b21\u0b3c\u0b3e" },
            { "ko", "\u0b15\u0b30\u0b3f\u0b06\u0b28\u0b4d \u0b24\u0b3f" },
            { "ks", "\u0b15\u0b3e\u0b38\u0b4d\u0b2e\u0b3f\u0b30" },
            { "ky", "\u0b15\u0b40\u0b30\u0b17\u0b40\u0b1c\u0b4d" },
            { "lo", "\u0b32\u0b3e\u0b05" },
            { "lt", "\u0b32\u0b3f\u0b25\u0b41\u0b06\u0b28\u0b3f\u0b06\u0b24\u0b3f" },
            { "lv", "\u0b32\u0b3e\u0b1f\u0b2c\u0b3f\u0b06\u0b24\u0b3f" },
            { "mk", "\u0b2e\u0b3e\u0b38\u0b47\u0b21\u0b4b\u0b28\u0b3f\u0b06 \u0b24\u0b3f" },
            { "ml", metaValue_ml },
            { "mn", "\u0b2e\u0b19\u0b4d\u0b17\u0b32\u0b3f\u0b5f \u0b24\u0b3f" },
            { "mr", "\u0b2e\u0b30\u0b3e\u0b1f\u0b40" },
            { "ms", "\u0b2e\u0b32\u0b5f" },
            { "my", "\u0b2c\u0b30\u0b4d\u0b2e\u0b40\u0b1c\u0b4d" },
            { "nb", "\u0b28\u0b30\u0b71\u0b47\u0b1c\u0b3f\u0b06\u0b28\u0b4d \u0b2c\u0b4b\u0b15\u0b2e\u0b32\u0b4d" },
            { "ne", "\u0b28\u0b47\u0b2a\u0b3e\u0b33\u0b40" },
            { "nl", "\u0b21\u0b1a\u0b4d" },
            { "or", metaValue_or },
            { "pa", "\u0b2a\u0b1e\u0b4d\u0b1c\u0b3e\u0b2c\u0b40" },
            { "pl", "\u0b2a\u0b32\u0b3f\u0b38\u0b4d" },
            { "pt", "\u0b2a\u0b30\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d\u200c" },
            { "ro", "\u0b30\u0b2e\u0b3e\u0b28\u0b3f\u0b06 \u0b24\u0b3f" },
            { "ru", "\u0b30\u0b41\u0b37\u0b3f\u0b06 \u0b24\u0b3f" },
            { "sa", "\u0b38\u0b02\u0b38\u0b4d\u0b15\u0b43\u0b24" },
            { "sd", "\u0b38\u0b3f\u0b28\u0b4d\u0b26\u0b40" },
            { "si", "\u0b38\u0b3f\u0b02\u0b39\u0b32\u0b3e" },
            { "sk", "\u0b38\u0b4d\u0b32\u0b2c\u0b3e\u0b15\u0b4d" },
            { "sl", "\u0b38\u0b4d\u0b32\u0b2c\u0b47\u0b28\u0b3f\u0b06 \u0b24\u0b3f" },
            { "sq", "\u0b06\u0b32\u0b2c\u0b3e\u0b28\u0b3f\u0b06\u0b28\u0b4d \u0b24\u0b3f" },
            { "sr", "\u0b38\u0b30\u0b4d\u0b2c\u0b3f\u0b5f \u0b24\u0b3f" },
            { "sv", "\u0b38\u0b4d\u0b71\u0b3f\u0b21\u0b3f\u0b38\u0b4d" },
            { "sw", "\u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b3f" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "\u0b24\u0b3e\u0b07" },
            { "tr", "\u0b24\u0b41\u0b30\u0b4d\u0b15\u0b3f\u0b38\u0b4d" },
            { "uk", "\u0b5f\u0b41\u0b15\u0b4d\u0b30\u0b3e\u0b28\u0b3f\u0b06\u0b24\u0b3f" },
            { "ur", "\u0b09\u0b30\u0b4d\u0b26\u0b41" },
            { "uz", "\u0b09\u0b1c\u0b2c\u0b47\u0b15\u0b4d" },
            { "vi", "\u0b71\u0b3f\u0b0f\u0b24\u0b28\u0b3e\u0b2e \u0b24\u0b3f" },
            { "zh", "\u0b1a\u0b3e\u0b07\u0b28\u0b3e \u0b24\u0b3f" },
            { "zu", "\u0b1c\u0b41\u0b32\u0b41" },
            { "brx", "\u0b2c\u0b21" },
            { "chr", metaValue_chr },
            { "doi", "\u0b21\u0b17\u0b4d\u0b30\u0b40" },
            { "fil", "\u0b2a\u0b3f\u0b32\u0b3f\u0b2a\u0b3f\u0b28" },
            { "kok", "\u0b15\u0b02\u0b19\u0b4d\u0b15\u0b23\u0b3f" },
            { "kxv", "\u0b15\u0b41\u0b71\u0b3f" },
            { "mai", "\u0b2e\u0b07\u0b24\u0b3f\u0b32\u0b40" },
            { "mni", "\u0b2e\u0b23\u0b3f\u0b2a\u0b41\u0b30\u0b40" },
            { "sat", "\u0b38\u0b3e\u0b28\u0b4d\u0b24\u0b3e\u0b32\u0b3f" },
            { "Arab", "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d" },
            { "Beng", "\u0b2c\u0b19\u0b4d\u0b17\u0b3e\u0b32\u0b40" },
            { "Brah", "\u0b2c\u0b4d\u0b30\u0b3e\u0b39\u0b4d\u0b2e\u0b3f" },
            { "Cher", metaValue_chr },
            { "Cyrl", "\u0b38\u0b3f\u0b30\u0b3f\u0b32\u0b3f\u0b15\u0b4d" },
            { "Deva", "\u0b26\u0b47\u0b71\u0b28\u0b3e\u0b17\u0b30\u0b40" },
            { "Gujr", "\u0b17\u0b41\u0b1c\u0b41\u0b30\u0b3e\u0b1f\u0b40" },
            { "Guru", "\u0b17\u0b41\u0b30\u0b2e\u0b41\u0b15\u0b40" },
            { "Hans", "\u0b38\u0b39\u0b1c" },
            { "Hant", "\u0b39\u0b3f\u0b30\u0b41\u0b26\u0b32\u0b41" },
            { "Knda", "\u0b15\u0b28\u0b4d\u0b28\u0b21\u0b3c" },
            { "Latn", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d" },
            { "Mlym", metaValue_ml },
            { "Orya", metaValue_or },
            { "Saur", "\u0b38\u0b09\u0b30\u0b3e\u0b37\u0b4d\u0b1f\u0b4d\u0b30" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "de_AT", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b3f\u0b06 \u0b24\u0b3f \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "de_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d\u200c \u0b39\u0b3e\u0b07 \u0b24\u0b3f \u0b1c\u0b30\u0b4d\u0b2e\u0b3e\u0b28" },
            { "en_AU", "\u0b05\u0b37\u0b4d\u0b1f\u0b4d\u0b30\u0b47\u0b32\u0b3f\u0b5f\u0b3e\u0b24\u0b3f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3f\u0b5f\u0b3e\u0b24\u0b3f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_GB", "\u0b2c\u0b4d\u0b30\u0b3f\u0b1f\u0b3f\u0b36\u0b4d\u200c\u0b24\u0b3f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "en_US", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e\u0b24\u0b3f \u0b07\u0b02\u0b30\u0b3e\u0b1c\u0b40" },
            { "es_ES", "\u0b5f\u0b41\u0b30\u0b2a\u0b40\u0b5f\u0b3e\u0b24\u0b3f \u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "es_MX", "\u0b2e\u0b47\u0b15\u0b4d\u0b38\u0b3f\u0b15\u0b24\u0b3f \u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b3f\u0b38\u0b4d\u200c" },
            { "fa_AF", "\u0b21\u0b30\u0b3f" },
            { "fr_CA", "\u0b15\u0b3e\u0b28\u0b3e\u0b21\u0b3e\u0b24\u0b3f \u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u200d" },
            { "fr_CH", "\u0b38\u0b4d\u0b71\u0b3f\u0b38\u0b4d \u0b2a\u0b4d\u0b30\u0b47\u0b1e\u0b4d\u0b1a\u200d" },
            { "nl_BE", "\u0b2a\u0b47\u0b4d\u0b32\u0b2e\u0b3f\u0b38\u0b4d" },
            { "pt_BR", "\u0b2c\u0b4d\u0b30\u0b3e\u0b1c\u0b3f\u0b32\u0b3f\u0b06\u0b28\u0b4d \u0b2a\u0b30\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d" },
            { "pt_PT", "\u0b5f\u0b41\u0b30\u0b2a\u0b4d \u0b24\u0b3f \u0b2a\u0b30\u0b4d\u0b24\u0b41\u0b17\u0b40\u0b1c\u0b4d" },
            { "ro_MD", "\u0b2e\u0b32\u0b21\u0b4b\u0b2d\u0b3f\u0b06\u0b28\u0b4d \u0b24\u0b3f" },
            { "sw_CD", "\u0b15\u0b19\u0b4d\u0b17 \u0b38\u0b4d\u0b71\u0b3e\u0b39\u0b3f\u0b32\u0b3f" },
            { "ar_001", "\u0b2a\u0b41\u0b28\u0b3f \u0b1c\u0b41\u0b17 \u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d" },
            { "es_419", "\u0b32\u0b3e\u0b1f\u0b3f\u0b28\u0b4d\u200c \u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e \u0b24\u0b3f \u0b38\u0b4d\u0b2a\u0b47\u0b28\u0b3f\u0b38\u0b4d" },
            { "key.ca", "\u0b15\u0b47\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30" },
            { "key.cf", "\u0b1f\u0b3e\u0b15\u0b3e\u0b01 \u0b2a\u0b30\u0b2e\u0b3e\u0b1f" },
            { "key.co", "\u0b2e\u0b3f\u0b32\u0b3e \u0b15\u0b4d\u0b30\u0b2e" },
            { "key.cu", "\u0b1f\u0b3e\u0b15\u0b3e\u0b01" },
            { "key.hc", "\u0b71\u0b47\u0b21\u0b3c\u0b3e\u0b24\u0b3f \u0b17\u0b3f\u0b32\u0b3e (\u0b67\u0b68 \u0b05\u0b21\u0b3c\u0b47 \u0b68\u0b6a)" },
            { "key.lb", "\u0b26\u0b3e\u0b21\u0b3c\u0b3f \u0b21\u0b3f\u0b15\u0b3f\u0b39\u0b3f\u0b28 \u0b06\u0b21\u0b3e" },
            { "key.ms", "\u0b32\u0b3e\u0b1a\u0b3f\u0b28\u0b3f \u0b32\u0b47\u0b15\u0b3e" },
            { "key.nu", "\u0b38\u0b02\u0b15\u0b4d\u0b5f\u0b3e" },
            { "zh_Hans", "\u0b38\u0b39\u0b1c \u0b1a\u0b40\u0b28" },
            { "zh_Hant", "\u0b39\u0b3f\u0b30\u0b41\u0b26\u0b32\u0b41 \u0b1a\u0b3e\u0b07\u0b28\u0b3f\u0b1c\u0b4d\u200c" },
            { "type.hc.h11", "\u0b67\u0b68 \u0b17\u0b23\u0b4d\u0b1f\u0b3e \u0b24\u0b3f \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f (0\u2013\u0b67\u0b67)" },
            { "type.hc.h12", "\u0b67\u0b68 \u0b17\u0b23\u0b4d\u0b1f\u0b3e \u0b24\u0b3f \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f (\u0b67\u2013\u0b67\u0b68)" },
            { "type.hc.h23", "\u0b68\u0b6a \u0b17\u0b23\u0b4d\u0b1f\u0b3e \u0b24\u0b3f \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f (0\u2013\u0b68\u0b69)" },
            { "type.hc.h24", "\u0b68\u0b6a \u0b17\u0b23\u0b4d\u0b1f\u0b3e \u0b24\u0b3f \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f (\u0b67\u2013\u0b68\u0b6a)" },
            { "type.nu.arab", "\u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d-\u0b2c\u0b3e\u0b30\u0b24\u0b40\u0b5f \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.beng", "\u0b2c\u0b19\u0b4d\u0b17\u0b3e\u0b32\u0b40 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.deva", "\u0b26\u0b47\u0b2c\u0b28\u0b3e\u0b17\u0b30\u0b40 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.gujr", "\u0b17\u0b41\u0b1c\u0b30\u0b3e\u0b1f\u0b3f \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.guru", "\u0b17\u0b41\u0b30\u0b41\u0b2e\u0b41\u0b15\u0b3f \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.knda", "\u0b15\u0b28\u0b21 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.latn", "\u0b71\u0b47\u0b38\u0b4d\u0b1f\u0b47\u0b28\u0b4d \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.mlym", "\u0b2e\u0b3e\u0b32\u0b3e\u0b5f\u0b3e\u0b32\u0b2e\u0b4d \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.orya", "\u0b05\u0b21\u0b3c\u0b3f\u0b06 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.taml", "\u0b39\u0b3f\u0b30\u0b41\u0b26\u0b41\u0b32\u0b41 \u0b24\u0b3e\u0b2e\u0b3f\u0b32 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.telu", "\u0b24\u0b47\u0b32\u0b41\u0b17\u0b41 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.co.ducet", "\u0b21\u0b3f\u0b2a\u0b32\u0b1f \u0b5f\u0b41\u0b28\u0b3f\u0b15\u0b21 \u0b38\u0b30\u0b4d\u0b1f \u0b32\u0b47\u0b01" },
            { "type.nu.roman", "\u0b30\u0b2e\u0b3e\u0b28 \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.ca.indian", "\u0b2c\u0b3e\u0b30\u0b24 \u0b1c\u0b3e\u0b24\u0b3f\u0b5f \u0b15\u0b47\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30" },
            { "type.co.search", "\u0b38\u0b3e\u0b2e\u0b3e\u0b28\u0b3f-\u0b09\u0b26\u0b47\u0b38\u0b4d\u0b5f \u0b2a\u0b3e\u0b30\u0b3f\u0b28" },
            { "type.ms.metric", "\u0b2e\u0b47\u0b1f\u0b4d\u0b30\u0b15\u0b3f \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f" },
            { "type.nu.arabext", "\u0b28\u0b15\u0b3f\u0b06\u0b24\u0b3f \u0b06\u0b30\u0b2c\u0b3f\u0b15\u0b4d-\u0b2c\u0b3e\u0b30\u0b24\u0b40\u0b5f \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.nu.tamldec", "\u0b24\u0b3e\u0b2e\u0b3f\u0b32\u0b4d \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.cf.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b1f\u0b3e\u0b15\u0b3e\u0b01 \u0b30\u0b41\u0b2a" },
            { "type.co.standard", "\u0b2e\u0b3e\u0b28\u0b3e\u0b19\u0b4d\u0b15 \u0b38\u0b30\u0b4d\u0b1f \u0b32\u0b47\u0b01" },
            { "type.ms.uksystem", "\u0b38\u0b3e\u0b2e\u0b4d\u0b30\u0b3e\u0b1c\u0b4d\u0b5f\u0b24\u0b3f \u0b06\u0b1f\u0b3f\u0b28\u0b3f \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f" },
            { "type.ms.ussystem", "\u0b06\u0b2e\u0b47\u0b30\u0b3f\u0b15\u0b3e\u0b24\u0b3f \u0b2e\u0b3e\u0b2a \u0b2a\u0b26\u0b4d\u0b26\u0b24\u0b3f" },
            { "type.nu.romanlow", "\u0b30\u0b2e\u0b3e\u0b28 \u0b2e\u0b3f\u0b32\u0b3e \u0b05\u0b30\u0b3e \u0b28\u0b2e\u0b4d\u0b2c\u0b30" },
            { "type.ca.gregorian", "\u0b17\u0b4d\u0b30\u0b47\u0b17\u0b30\u0b3f\u0b5f\u0b3e\u0b28 \u0b15\u0b47\u0b32\u0b47\u0b23\u0b4d\u0b21\u0b30" },
            { "type.co.phonebook", "\u0b2a\u0b28\u0b4d\u200d\u0b2c\u0b39\u0b3f \u0b2c\u0b3e\u0b17\u0b3e \u0b05\u0b30\u0b4d\u0b21\u0b30" },
        };
        return data;
    }
}
