/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hsb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gujarati";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "001", "sw\u011bt" },
            { "002", "Afrika" },
            { "003", "Sewjerna Amerika" },
            { "005", "Ju\u017ena Amerika" },
            { "009", "Oceaniska" },
            { "011", "zapadna Afrika" },
            { "013", "Srjed\u017ana Amerika" },
            { "014", "wuchodna Afrika" },
            { "015", "sewjerna Afrika" },
            { "017", "srjed\u017ana Afrika" },
            { "018", "ju\u017ena Afrika" },
            { "019", "Amerika" },
            { "021", "sewjerny ameriski kontinent" },
            { "029", "Karibika" },
            { "030", "wuchodna Azija" },
            { "034", "ju\u017ena Azija" },
            { "035", "juhowuchodna Azija" },
            { "039", "ju\u017ena Europa" },
            { "053", "Awstralazija" },
            { "054", "Melaneziska" },
            { "057", "Mikroneziska (kupowy region)" },
            { "061", "Polyneziska" },
            { "142", "Azija" },
            { "143", "centralna Azija" },
            { "145", "zapadna Azija" },
            { "150", "Europa" },
            { "151", "wuchodna Europa" },
            { "154", "sewjerna Europa" },
            { "155", "zapadna Europa" },
            { "202", "subsaharaska Afrika" },
            { "419", "\u0141a\u0107onska Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Zjedno\u0107ene arabske emiraty" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanska" },
            { "AM", "Armenska" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentinska" },
            { "AS", "Ameriska Samoa" },
            { "AT", "Awstriska" },
            { "AU", "Awstralska" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Azerbajd\u017aan" },
            { "BA", "Bosniska a Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u0161" },
            { "BE", "Belgiska" },
            { "BF", "Burkina Faso" },
            { "BG", "Bo\u0142harska" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei" },
            { "BO", "Boliwiska" },
            { "BQ", "Karibiska Ni\u017eozemska" },
            { "BR", "Brazilska" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetowa kupa" },
            { "BW", "Botswana" },
            { "BY", "B\u011b\u0142oruska" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosowe kupy" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralnoafriska republika" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "\u0160wicarska" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookowe kupy" },
            { "CL", "Chilska" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbiska" },
            { "CP", "Clippertonowa kupa" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Hodowna kupa" },
            { "CY", "Cypern" },
            { "CZ", "\u010c\u011bska republika" },
            { "DE", "N\u011bmska" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u017aibuti" },
            { "DK", "Danska" },
            { "DM", "Dominika" },
            { "DO", "Dominikanska republika" },
            { "DZ", "Algeriska" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estiska" },
            { "EG", "Egyptowska" },
            { "EH", "Zapadna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "\u0160paniska" },
            { "ET", "Etiopiska" },
            { "EU", "Europska unija" },
            { "EZ", "europasmo" },
            { "FI", "Finska" },
            { "FJ", "Fid\u017ai" },
            { "FK", "Falklandske kupy" },
            { "FM", "Mikroneziska" },
            { "FO", "F\u00e4r\u00f6ske kupy" },
            { "FR", "Francoska" },
            { "GA", "Gabun" },
            { "GB", "Zjedno\u0107ene kralestwo" },
            { "GD", "Grenada" },
            { "GE", "Georgiska" },
            { "GF", "Francoska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nlandska" },
            { "GM", "Gambija" },
            { "GN", "Gineja" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatorialna Gineja" },
            { "GR", "Grjekska" },
            { "GS", "Ju\u017ena Georgiska a Ju\u017ene Sandwichowe kupy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gineja-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Wosebita zarjadniska cona Hongkong" },
            { "HM", "Heardowa kupa a McDonaldowe kupy" },
            { "HN", "Honduras" },
            { "HR", "Chorwatska" },
            { "HT", "Haiti" },
            { "HU", "Mad\u017aarska" },
            { "IC", "Kanariske kupy" },
            { "ID", "Indoneska" },
            { "IE", "Irska" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "Indiska" },
            { "IO", "Britiski teritorij w Indiskim oceanje" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandska" },
            { "IT", "Italska" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordaniska" },
            { "JP", "Japanska" },
            { "KE", "Kenija" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambod\u017aa" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "St. Kitts a Nevis" },
            { "KP", "Sewjerna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "KW", "Kuwait" },
            { "KY", "Kajmanske kupy" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesotho" },
            { "LT", "Litawska" },
            { "LU", "Luxemburgska" },
            { "LV", "Letiska" },
            { "LY", "Libyska" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawska" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallowe kupy" },
            { "MK", "Serwjerna Makedonska" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolska" },
            { "MO", "Wosebita zarjadniska cona Macao" },
            { "MP", "Sewjerne Mariany" },
            { "MQ", "Martinique" },
            { "MR", "Mawretanska" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajzija" },
            { "MZ", "Mosambik" },
            { "NA", "Namibija" },
            { "NC", "Nowa Kaledoniska" },
            { "NE", "Niger" },
            { "NF", "Norfolkowa kupa" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragua" },
            { "NL", "Ni\u017eozemska" },
            { "NO", "Norwegska" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowoseelandska" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francoska Polyneziska" },
            { "PG", "Papuwa-Nowa Gineja" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lska" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairnowe kupy" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinski awtonomny teritorij" },
            { "PT", "Portugalska" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Wonkowna Oceaniska" },
            { "RE", "R\u00e9union" },
            { "RO", "Rumunska" },
            { "RS", "Serbiska" },
            { "RU", "Ruska" },
            { "RW", "Ruanda" },
            { "SA", "Sawdi-Arabska" },
            { "SB", "Salomony" },
            { "SC", "Seychelle" },
            { "SD", "Sudan" },
            { "SE", "\u0160wedska" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "S\u0142owjenska" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "S\u0142owakska" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinam" },
            { "SS", "Ju\u017eny Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syriska" },
            { "SZ", "Swaziska" },
            { "TA", "Tristan da Cunha" },
            { "TC", "kupy Turks a Caicos" },
            { "TD", "\u010cad" },
            { "TF", "Francoski ju\u017eny a antarktiski teritorij" },
            { "TG", "Togo" },
            { "TH", "Thailandska" },
            { "TJ", "Tad\u017aikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmeniska" },
            { "TN", "Tuneziska" },
            { "TO", "Tonga" },
            { "TR", "Turkowska" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansanija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Ameriska Oceaniska" },
            { "UN", "Zjedno\u0107ene narody" },
            { "US", "Zjedno\u0107ene staty Ameriki" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanske m\u011bsto" },
            { "VC", "St. Vincent a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britiske knje\u017eniske kupy" },
            { "VI", "Ameriske knje\u017eniske kupy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-akcenty" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosowo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Ju\u017ena Afrika (Republika)" },
            { "ZM", "Sambija" },
            { "ZW", "Simbabwe" },
            { "ZZ", "njeznaty region" },
            { "aa", "afar\u0161\u0107ina" },
            { "ab", "abchazi\u0161\u0107ina" },
            { "af", "afrikaan\u0161\u0107ina" },
            { "ak", "akan\u0161\u0107ina" },
            { "am", "amhar\u0161\u0107ina" },
            { "an", "aragon\u0161\u0107ina" },
            { "ar", "arab\u0161\u0107ina" },
            { "as", "asam\u0161\u0107ina" },
            { "av", "awar\u0161\u0107ina" },
            { "ay", "aymar\u0161\u0107ina" },
            { "az", "azerbajd\u017aan\u0161\u0107ina" },
            { "ba", "ba\u0161kir\u0161\u0107ina" },
            { "be", "b\u011b\u0142oru\u0161\u0107ina" },
            { "bg", "bo\u0142har\u0161\u0107ina" },
            { "bi", "bislam\u0161\u0107ina" },
            { "bm", "bambara" },
            { "bn", "bengal\u0161\u0107ina" },
            { "bo", "tibet\u0161\u0107ina" },
            { "br", "breton\u0161\u0107ina" },
            { "bs", "bosni\u0161\u0107ina" },
            { "ca", "katalan\u0161\u0107ina" },
            { "ce", "\u010de\u010den\u0161\u0107ina" },
            { "ch", "\u010damor\u0161\u0107ina" },
            { "co", "korsi\u0161\u0107ina" },
            { "cr", "kri" },
            { "cs", "\u010d\u011b\u0161\u0107ina" },
            { "cu", "cyrkwinos\u0142owjan\u0161\u0107ina" },
            { "cv", "chuvashi\u0161\u0107ina" },
            { "cy", "walizi\u0161\u0107ina" },
            { "da", "dan\u0161\u0107ina" },
            { "de", "n\u011bm\u010dina" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grjek\u0161\u0107ina" },
            { "en", "jend\u017ael\u0161\u0107ina" },
            { "eo", "esperanto" },
            { "es", "\u0161pani\u0161\u0107ina" },
            { "et", "esti\u0161\u0107ina" },
            { "eu", "baski\u0161\u0107ina" },
            { "fa", "persi\u0161\u0107ina" },
            { "ff", "fulb\u0161\u0107ina" },
            { "fi", "fin\u0161\u0107ina" },
            { "fj", "fid\u017ai\u0161\u0107ina" },
            { "fo", "f\u00e4r\u00f6\u0161\u0107ina" },
            { "fr", "franco\u0161\u0107ina" },
            { "fy", "frizi\u0161\u0107ina" },
            { "ga", "ir\u0161\u0107ina" },
            { "gd", "\u0161otiska gel\u0161\u0107ina" },
            { "gl", "galici\u0161\u0107ina" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "man\u0161\u0107ina" },
            { "ha", "hausa" },
            { "he", "hebrej\u0161\u0107ina" },
            { "hi", "hindi\u0161\u0107ina" },
            { "hr", "chorwat\u0161\u0107ina" },
            { "ht", "haiti\u0161\u0107ina" },
            { "hu", "mad\u017aar\u0161\u0107ina" },
            { "hy", "armen\u0161\u0107ina" },
            { "hz", "herero\u0161\u0107ina" },
            { "ia", "interlingua" },
            { "id", "indone\u0161\u0107ina" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "island\u0161\u0107ina" },
            { "it", "ital\u0161\u0107ina" },
            { "iu", "inuit\u0161\u0107ina" },
            { "ja", "japan\u0161\u0107ina" },
            { "jv", "java\u0161\u0107ina" },
            { "ka", "georgi\u0161\u0107ina" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama\u0161\u0107ina" },
            { "kk", "kazach\u0161\u0107ina" },
            { "kl", "gr\u00f6ndland\u0161\u0107ina" },
            { "km", "khmer\u0161\u0107ina" },
            { "kn", "kannad\u0161\u0107ina" },
            { "ko", "korej\u0161\u0107ina" },
            { "kr", "kanuri\u0161\u0107ina" },
            { "ks", "ka\u0161mir\u0161\u0107ina" },
            { "ku", "kurdi\u0161\u0107ina" },
            { "kv", "komi\u0161\u0107ina" },
            { "kw", "korni\u0161\u0107ina" },
            { "ky", "kirgi\u0161\u0107ina" },
            { "la", "\u0142a\u0107on\u0161\u0107ina" },
            { "lb", "luxemburg\u0161\u0107ina" },
            { "lg", "gand\u0161\u0107ina" },
            { "li", "limbur\u0161\u0107ina" },
            { "ln", "lingala" },
            { "lo", "lao\u0161\u0107ina" },
            { "lt", "litaw\u0161\u0107ina" },
            { "lu", "luba-katanga" },
            { "lv", "leti\u0161\u0107ina" },
            { "mg", "malagassi\u0161\u0107ina" },
            { "mh", "marshallezi\u0161\u0107ina" },
            { "mi", "maor\u0161\u0107ina" },
            { "mk", "makedon\u0161\u0107ina" },
            { "ml", "malajam\u0161\u0107ina" },
            { "mn", "mongol\u0161\u0107ina" },
            { "mr", "marati\u0161\u0107ina" },
            { "ms", "malaj\u0161\u0107ina" },
            { "mt", "malta\u0161\u0107ina" },
            { "my", "burma\u0161\u0107ina" },
            { "na", "nauru\u0161\u0107ina" },
            { "nb", "norweg\u0161\u0107ina (bokm\u00e5l)" },
            { "nd", "sewjero-ndebele" },
            { "ne", "nepal\u0161\u0107ina" },
            { "ng", "ndonga\u0161\u0107ina" },
            { "nl", "ni\u017eozem\u0161\u0107ina" },
            { "nn", "norweg\u0161\u0107ina (nynorsk)" },
            { "no", "norweg\u0161\u0107ina" },
            { "nr", "ju\u017ena ndebel\u0161\u0107ina" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "okcitan\u0161\u0107ina" },
            { "om", "oromo" },
            { "or", "orij\u0161\u0107ina" },
            { "os", "oset\u0161\u0107ina" },
            { "pa", "pand\u017aab\u0161\u0107ina" },
            { "pl", "p\u00f3l\u0161\u0107ina" },
            { "ps", "pa\u0161tun\u0161\u0107ina" },
            { "pt", "portugal\u0161\u0107ina" },
            { "qu", "ke\u010dua" },
            { "rm", "retoroman\u0161\u0107ina" },
            { "rn", "kirundi\u0161\u0107ina" },
            { "ro", "rumun\u0161\u0107ina" },
            { "ru", "ru\u0161\u0107ina" },
            { "rw", "kinjarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardin\u0161\u0107ina" },
            { "sd", "sindhi\u0161\u0107ina" },
            { "se", "sewjerosami\u0161\u0107ina" },
            { "sg", "sango" },
            { "sh", "serbochorwat\u0161\u0107ina" },
            { "si", "singhal\u0161\u0107ina" },
            { "sk", "s\u0142owak\u0161\u0107ina" },
            { "sl", "s\u0142owjen\u0161\u0107ina" },
            { "sm", "samoa\u0161\u0107ina" },
            { "sn", "\u0161ona\u0161\u0107ina" },
            { "so", "somali\u0161\u0107ina" },
            { "sq", "alban\u0161\u0107ina" },
            { "sr", "serbi\u0161\u0107ina" },
            { "ss", "siswati" },
            { "st", "ju\u017enosot\u0161\u0107ina (Sesotho)" },
            { "su", "sundanezi\u0161\u0107ina" },
            { "sv", "\u0161wed\u0161\u0107ina" },
            { "sw", "suahel\u0161\u0107ina" },
            { "ta", "tamil\u0161\u0107ina" },
            { "te", metaValue_te },
            { "tg", "tad\u017aik\u0161\u0107ina" },
            { "th", "thailand\u0161\u0107ina" },
            { "ti", "tigrin\u0161\u0107ina" },
            { "tk", "turkmen\u0161\u0107ina" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga\u0161\u0107ina" },
            { "tr", "turkow\u0161\u0107ina" },
            { "ts", "tsonga" },
            { "tt", "tatar\u0161\u0107ina" },
            { "tw", "twi" },
            { "ty", "tahiti\u0161\u0107ina" },
            { "ug", "ujgur\u0161\u0107ina" },
            { "uk", "ukrain\u0161\u0107ina" },
            { "ur", "urdu\u0161\u0107ina" },
            { "uz", "uzbek\u0161\u0107ina" },
            { "ve", "venda\u0161\u0107ina" },
            { "vi", "vietnam\u0161\u0107ina" },
            { "vo", "volap\u00fck" },
            { "wa", "walon\u0161\u0107ina" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jidi\u0161\u0107ina" },
            { "yo", "joruba\u0161\u0107ina" },
            { "za", "zhuang" },
            { "zh", "chin\u0161\u0107ina" },
            { "zu", "zulu\u0161\u0107ina" },
            { "ace", "achinezi\u0161\u0107ina" },
            { "ada", "adangme\u0161\u0107ina" },
            { "ady", "adyghe\u0161\u0107ina" },
            { "agq", "aghem\u0161\u0107ina" },
            { "ain", "ainu\u0161\u0107ina" },
            { "ale", "aleuti\u0161\u0107ina" },
            { "alt", "ju\u017ena altai\u0161\u0107ina" },
            { "ang", "anglosak\u0161\u0107ina" },
            { "ann", "obolo\u0161\u0107ina" },
            { "anp", "angika\u0161\u0107ina" },
            { "arn", "arawkan\u0161\u0107ina" },
            { "arp", "arapaho\u0161\u0107ina" },
            { "ars", "najdi arab\u0161\u0107ina" },
            { "asa", "pare" },
            { "ast", "astur\u0161\u0107ina" },
            { "atj", "atikamekwi\u0161\u0107ina" },
            { "awa", "awandhi\u0161\u0107ina" },
            { "ban", "balinezi\u0161\u0107ina" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "haryanvi" },
            { "bho", "bhojpuri\u0161\u0107ina" },
            { "bin", "bini\u0161\u0107ina" },
            { "bla", "siksik\u00e1\u0161\u0107ina" },
            { "brx", "bodo" },
            { "bug", "buginezi\u0161\u0107ina" },
            { "byn", "blin\u0161\u0107ina" },
            { "cay", "cayuga\u0161\u0107ina" },
            { "ccp", "\u010dakma" },
            { "ceb", "cebuan\u0161\u0107ina" },
            { "cgg", "chiga" },
            { "chk", "chuukezi\u0161\u0107ina" },
            { "chm", "mari\u0161\u0107ina" },
            { "cho", "choctaw\u0161\u0107ina" },
            { "chp", "chipewyan\u0161\u0107ina" },
            { "chr", "cherokee" },
            { "chy", "cheyenne\u0161\u0107ina" },
            { "ckb", "sorani" },
            { "clc", "chilcotin\u0161\u0107ina" },
            { "crg", "michif\u0161\u0107ina" },
            { "crj", "ju\u017enowuchodna cree\u0161\u0107ina" },
            { "crk", "plains cree\u0161\u0107ina" },
            { "crl", "sewjernowuchodna cree\u0161\u0107ina" },
            { "crm", "moode cree\u0161\u0107ina" },
            { "crr", "carolina algonquian\u0161\u0107ina" },
            { "csw", "swampy cree\u0161\u0107ina" },
            { "dak", "dakota\u0161\u0107ina" },
            { "dar", "dargwa\u0161\u0107ina" },
            { "dav", "taita" },
            { "dgr", "dogrib\u0161\u0107ina" },
            { "dje", "zarma" },
            { "doi", "dogri\u0161\u0107ina" },
            { "dsb", "delnjoserb\u0161\u0107ina" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga\u0161\u0107ina" },
            { "ebu", "embu" },
            { "efi", "efik\u0161\u0107ina" },
            { "eka", "ekajuk\u0161\u0107ina" },
            { "ewo", "ewondo" },
            { "fil", "filipin\u0161\u0107ina" },
            { "fon", "fon\u0161\u0107ina" },
            { "frc", "cajun franco\u0161\u0107ina" },
            { "frr", "sewjernofrizi\u0161\u0107ina" },
            { "fur", "friul\u0161\u0107ina" },
            { "gaa", "ga\u0161\u0107ina" },
            { "gag", "gagauzi\u0161\u0107ina" },
            { "gez", "geezi\u0161\u0107ina" },
            { "gil", "gilbertezi\u0161\u0107ina" },
            { "gor", "gorontalo\u0161\u0107ina" },
            { "got", "got\u0161\u0107ina" },
            { "gsw", "\u0161wicarska n\u011bm\u010dina" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin\u0161\u0107ina" },
            { "hai", "haida\u0161\u0107ina" },
            { "haw", "hawaii\u0161\u0107ina" },
            { "hax", "ju\u017ena haida\u0161\u0107ina" },
            { "hil", "hiligaynon\u0161\u0107ina" },
            { "hmn", "hmong\u0161\u0107ina" },
            { "hsb", "hornjoserb\u0161\u0107ina" },
            { "hup", "hupa\u0161\u0107ina" },
            { "hur", "halkomelem\u0161\u0107ina" },
            { "iba", "iban\u0161\u0107ina" },
            { "ibb", "ibibio\u0161\u0107ina" },
            { "ikt", "zapadnokanadska inuktitut\u0161\u0107ina" },
            { "ilo", "iloko\u0161\u0107ina" },
            { "inh", "ingushi\u0161\u0107ina" },
            { "jbo", "lojban\u0161\u0107ina" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabyl\u0161\u0107ina" },
            { "kac", "kachin\u0161\u0107ina" },
            { "kaj", "jju\u0161\u0107ina" },
            { "kam", "kamba" },
            { "kbd", "kabardian\u0161\u0107ina" },
            { "kcg", "tyap\u0161\u0107ina" },
            { "kde", "makonde" },
            { "kea", "kapverd\u0161\u0107ina" },
            { "kfo", "koro\u0161\u0107ina" },
            { "kgp", "kaingang\u0161\u0107ina" },
            { "kha", "khasi\u0161\u0107ina" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu\u0161\u0107ina" },
            { "koi", "permska komi\u0161\u0107ina" },
            { "kok", "konkani" },
            { "kpe", "kpelle\u0161\u0107ina" },
            { "krc", "karachay-balkar\u0161\u0107ina" },
            { "krl", "karelian\u0161\u0107ina" },
            { "kru", "kurukh\u0161\u0107ina" },
            { "ksb", "\u0161ambala" },
            { "ksf", "bafia" },
            { "ksh", "keln\u0161\u0107ina" },
            { "kum", "kumyk\u0161\u0107ina" },
            { "kwk", "kwak\u02bcwala\u0161\u0107ina" },
            { "lad", "ladin\u0161\u0107ina" },
            { "lag", "langi" },
            { "lez", "lezgian\u0161\u0107ina" },
            { "lil", "lillooet\u0161\u0107ina" },
            { "lkt", "lakota" },
            { "lou", "Louisiana kreol\u0161\u0107ina" },
            { "loz", "lozi\u0161\u0107ina" },
            { "lrc", "sewjerna luri\u0161\u0107ina" },
            { "lsm", "saamia\u0161\u0107ina" },
            { "lua", "luba-lulua\u0161\u0107ina" },
            { "lun", "lunda\u0161\u0107ina" },
            { "luo", "luo" },
            { "lus", "mizo\u0161\u0107ina" },
            { "luy", "luhya" },
            { "mad", "madurezi\u0161\u0107ina" },
            { "mag", "magahi\u0161\u0107ina" },
            { "mai", "maithil\u0161\u0107ina" },
            { "mak", "makasar\u0161\u0107ina" },
            { "mas", "masai\u0161\u0107ina" },
            { "mdf", "moksha\u0161\u0107ina" },
            { "men", "mendi\u0161\u0107ina" },
            { "mer", "meru" },
            { "mfe", "mauriciska kreol\u0161\u0107ina" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "mi'kmaq\u0161\u0107ina" },
            { "min", "minangkabau\u0161\u0107ina" },
            { "mni", "manipur\u0161\u0107ina" },
            { "moe", "innu-aimun\u0161\u0107ina" },
            { "moh", "mohawk\u0161\u0107ina" },
            { "mos", "mossi\u0161\u0107ina" },
            { "mua", "mundang" },
            { "mul", "wjacer\u011b\u010dne" },
            { "mus", "krik" },
            { "mwl", "mirandezi\u0161\u0107ina" },
            { "myv", "erzya\u0161\u0107ina" },
            { "mzn", "mazanderan\u0161\u0107ina" },
            { "nap", "neapolitan\u0161\u0107ina" },
            { "naq", "nama" },
            { "nds", "delnjon\u011bm\u010dina" },
            { "new", "newari\u0161\u0107ina" },
            { "nia", "niazi\u0161\u0107ina" },
            { "niu", "niuean\u0161\u0107ina" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai\u0161\u0107ina" },
            { "nqo", "n\u2019ko" },
            { "nso", "sewjerna sotho\u0161\u0107ina" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "sewjernozapadna ojibwa\u0161\u0107ina" },
            { "ojc", "centralna ojibwa\u0161\u0107ina" },
            { "ojs", "oji-cree\u0161\u0107ina" },
            { "ojw", "zapadna ojibwa\u0161\u0107ina" },
            { "oka", "okanagan\u0161\u0107ina" },
            { "pag", "pangasinan\u0161\u0107ina" },
            { "pam", "pampanga\u0161\u0107ina" },
            { "pap", "papiamento\u0161\u0107ina" },
            { "pau", "palauan\u0161\u0107ina" },
            { "pcm", "nigerijanski pidgin" },
            { "pis", "pijin\u0161\u0107ina" },
            { "pqm", "maliseet-passamaquoddy\u0161\u0107ina" },
            { "prg", "pru\u0161\u0107ina" },
            { "quc", "k\u02bciche\u02bc" },
            { "raj", "rajasthani" },
            { "rap", "rapanui\u0161\u0107ina" },
            { "rar", "rarotongan\u0161\u0107ina" },
            { "rhg", "rohingya\u0161\u0107ina" },
            { "rof", "rombo" },
            { "rup", "armanian\u0161\u0107ina" },
            { "rwk", "rwa" },
            { "sad", "sandawe\u0161\u0107ina" },
            { "sah", "jakut\u0161\u0107ina" },
            { "saq", "samburu" },
            { "sat", "santal\u0161\u0107ina" },
            { "sba", "ngambay\u0161\u0107ina" },
            { "sbp", "sangu" },
            { "scn", "sicil\u0161\u0107ina" },
            { "sco", "scot\u0161\u0107ina" },
            { "seh", "sena" },
            { "ses", "koyra senni" },
            { "shi", "ta\u0161elhit" },
            { "shn", "shan\u0161\u0107ina" },
            { "slh", "ju\u017ena lushootseed\u0161\u0107ina" },
            { "sma", "ju\u017enosami\u0161\u0107ina" },
            { "smj", "lule-sami\u0161\u0107ina" },
            { "smn", "inari-sami\u0161\u0107ina" },
            { "sms", "skolt-sami\u0161\u0107ina" },
            { "snk", "soninke\u0161\u0107ina" },
            { "srn", "sranan tongo\u0161\u0107ina" },
            { "stq", "saterfrizi\u0161\u0107ina" },
            { "str", "straits salish\u0161\u0107ina" },
            { "suk", "sukuma\u0161\u0107ina" },
            { "swb", "comorian\u0161\u0107ina" },
            { "syr", "syriac\u0161\u0107ina" },
            { "tce", "ju\u017ena tutchon\u0161\u0107ina" },
            { "tem", "timne\u0161\u0107ina" },
            { "teo", "teso" },
            { "tet", "tetum\u0161\u0107ina" },
            { "tgx", "tagish\u0161\u0107ina" },
            { "tht", "tahltan\u0161\u0107ina" },
            { "tig", "tigre\u0161\u0107ina" },
            { "tlh", "klingon\u0161\u0107ina" },
            { "tli", "tlingit\u0161\u0107ina" },
            { "tok", "toki pona\u0161\u0107ina" },
            { "tpi", "tok pisin\u0161\u0107ina" },
            { "trv", "taroko\u0161\u0107ina" },
            { "ttm", "sewjerna tutchon\u0161\u0107ina" },
            { "tum", "tumbuka\u0161\u0107ina" },
            { "tvl", "tuvalu\u0161\u0107ina" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian\u0161\u0107ina" },
            { "tzm", "tamazight (srjed\u017any Marokko)" },
            { "udm", "udmurt\u0161\u0107ina" },
            { "umb", "umbundu\u0161\u0107ina" },
            { "und", "njeznata r\u011b\u010d" },
            { "vai", "vai" },
            { "vun", "vunjo" },
            { "wae", "walzer\u0161\u0107ina" },
            { "wal", "wolaytta\u0161\u0107ina" },
            { "war", "waray\u0161\u0107ina" },
            { "wuu", "wu chin\u0161\u0107ina" },
            { "xal", "kalmyk\u0161\u0107ina" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba\u0161\u0107ina" },
            { "yrl", "nheengatu\u0161\u0107ina" },
            { "yue", "kanton\u0161\u0107ina" },
            { "zgh", "tamazight" },
            { "zun", "zuni\u0161\u0107ina" },
            { "zxx", "\u017eadyn r\u011b\u010dny wobsah" },
            { "zza", "zaza\u0161\u0107ina" },
            { "Adlm", "adlamske pismo" },
            { "Arab", "arabsce" },
            { "Aran", "nastaliqske pismo" },
            { "Armn", "armensce" },
            { "Beng", "bengalsce" },
            { "Bopo", "bopomofo" },
            { "Brai", "Braillowe pismo" },
            { "Cakm", "chakmaske pismo" },
            { "Cans", "zjednotnjene kanadske aboriginske z\u0142\u00f3\u017ekowe pismo" },
            { "Cher", "cherokeeske pismo" },
            { "Cyrl", "kyrilisce" },
            { "Deva", "devanagari" },
            { "Ethi", "etiopisce" },
            { "Geor", "georgisce" },
            { "Grek", "grjeksce" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "chin\u0161\u0107ina z bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "chinsce" },
            { "Hans", "zjednorjene" },
            { "Hant", "tradicionalne" },
            { "Hebr", "hebrejsce" },
            { "Hira", "hiragana" },
            { "Hrkt", "japanske z\u0142\u00f3\u017ekowe pismo" },
            { "Jamo", "jamo" },
            { "Jpan", "japansce" },
            { "Kana", "katakana" },
            { "Khmr", "khmersce" },
            { "Knda", "kannadsce" },
            { "Kore", "korejsce" },
            { "Laoo", "laosce" },
            { "Latn", "\u0142a\u0107onsce" },
            { "Mlym", "malayalamsce" },
            { "Mong", "mongolsce" },
            { "Mtei", "meitei-mayekse pismo" },
            { "Mymr", "burmasce" },
            { "Nkoo", "n\u2019Koske pismo" },
            { "Olck", "ol-chikiske pismo" },
            { "Orya", "oriya" },
            { "Rohg", "hanifiske pismo" },
            { "Sinh", "singhalsce" },
            { "Sund", "sundaneske pismo" },
            { "Syrc", "syriacske pismo" },
            { "Taml", "tamilsce" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinanghske pismo" },
            { "Thaa", "thaana" },
            { "Thai", "thailandsce" },
            { "Tibt", "tibetsce" },
            { "Vaii", "vaiske pismo" },
            { "Yiii", "yiske pismo" },
            { "Zmth", "matematiski zapis" },
            { "Zsye", "emoji" },
            { "Zsym", "symbole" },
            { "Zxxx", "bjez pisma" },
            { "Zyyy", "pow\u0161itkowne" },
            { "Zzzz", "njeznate pismo" },
            { "de_AT", "awstriska n\u011bm\u010dina" },
            { "de_CH", "\u0161wicarska wysokon\u011bm\u010dina" },
            { "en_AU", "awstralska jend\u017ael\u0161\u0107ina" },
            { "en_CA", "kanadiska jend\u017ael\u0161\u0107ina" },
            { "en_GB", "britiska jend\u017ael\u0161\u0107ina" },
            { "en_US", "ameriska jend\u017ael\u0161\u0107ina" },
            { "es_ES", "europska \u0161pani\u0161\u0107ina" },
            { "es_MX", "mexiska \u0161pani\u0161\u0107ina" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadiska franco\u0161\u0107ina" },
            { "fr_CH", "\u0161wicarska franco\u0161\u0107ina" },
            { "nl_BE", "flam\u0161\u0107ina" },
            { "pt_BR", "brazilska portugal\u0161\u0107ina" },
            { "pt_PT", "europska portugal\u0161\u0107ina" },
            { "ro_MD", "moldaw\u0161\u0107ina" },
            { "sw_CD", "kongoska suahel\u0161\u0107ina" },
            { "ar_001", "moderna wysokoarab\u0161\u0107ina" },
            { "es_419", "\u0142a\u0107onskoameriska \u0161pani\u0161\u0107ina" },
            { "key.ca", "protyka" },
            { "key.cf", "format m\u011bny" },
            { "key.co", "rjadowanski sl\u011bd" },
            { "key.cu", "m\u011bna" },
            { "key.hc", "hod\u017ainowy cyklus (12 vs 24)" },
            { "key.lb", "system \u0142amanja linkow" },
            { "key.ms", "system m\u011brow" },
            { "key.nu", "li\u010dby" },
            { "zh_Hans", "chin\u0161\u0107ina (zjednorjena)" },
            { "zh_Hant", "chin\u0161\u0107ina (tradicionalna)" },
            { "type.ca.roc", "protyka republiki China" },
            { "type.hc.h11", "12-hod\u017ainowy cyklus (0-11)" },
            { "type.hc.h12", "12-hod\u017ainowy cyklus (1-12)" },
            { "type.hc.h23", "24-hod\u017ainowy cyklus (0-23)" },
            { "type.hc.h24", "24-hod\u017ainowy cyklus (1-24)" },
            { "type.nu.arab", "arabsko-indiske cyfry" },
            { "type.nu.armn", "armenske cyfry" },
            { "type.nu.beng", "bengalske cyfry" },
            { "type.nu.cakm", "chakmaske cyfry" },
            { "type.nu.deva", "devanagari-cyfry" },
            { "type.nu.ethi", "etiopiske cyfry" },
            { "type.nu.geor", "georgiske cyfry" },
            { "type.nu.grek", "grjekske cyfry" },
            { "type.nu.gujr", "gujarati-cyfry" },
            { "type.nu.guru", "gurmukhi-cyfry" },
            { "type.nu.hans", "zjednorjene chinske cyfry" },
            { "type.nu.hant", "tradicionalne chinske cyfry" },
            { "type.nu.hebr", "hebrejske cyfry" },
            { "type.nu.java", "javaske cyfry" },
            { "type.nu.jpan", "japanske cyfry" },
            { "type.nu.khmr", "khmerske cyfry" },
            { "type.nu.knda", "kannadske cyfry" },
            { "type.nu.laoo", "laoske cyfry" },
            { "type.nu.latn", "arabske cyfry" },
            { "type.nu.mlym", "malayalamske cyfry" },
            { "type.nu.mtei", "meetei-mayekske cyfry" },
            { "type.nu.mymr", "burmaske cyfry" },
            { "type.nu.olck", "ol-chikiske cyfry" },
            { "type.nu.orya", "oriya-cyfry" },
            { "type.nu.taml", "tradicionalne tamilske cyfry" },
            { "type.nu.telu", "telugu-cyfry" },
            { "type.nu.thai", "thailandske cyfry" },
            { "type.nu.tibt", "tibetske cyfry" },
            { "type.nu.vaii", "vaiske cyfry" },
            { "type.ca.dangi", "dangi-protyka" },
            { "type.co.ducet", "rjadowanski sl\u011bd po Unicode" },
            { "type.lb.loose", "swobodny stil \u0142amanja linkow" },
            { "type.nu.roman", "romske cyfry" },
            { "type.ca.coptic", "koptiska protyka" },
            { "type.ca.hebrew", "\u017eidowska protyka" },
            { "type.co.search", "pow\u0161itkowne pytanje" },
            { "type.lb.normal", "b\u011b\u017eny stil \u0142amanja linkow" },
            { "type.lb.strict", "kruty stil \u0142amanja linkow" },
            { "type.ms.metric", "metriski system" },
            { "type.ca.chinese", "chinska protyka" },
            { "type.ca.islamic", "islamska protyka" },
            { "type.ca.iso8601", "protyka po iso-8601" },
            { "type.ca.persian", "persiska protyka" },
            { "type.cf.account", "knihiwjedniski format m\u011bny" },
            { "type.nu.arabext", "roz\u0161\u011brjene arabsko-indiske cyfry" },
            { "type.nu.armnlow", "armenske cyfry, ma\u0142e pisane" },
            { "type.nu.greklow", "grjekske cyfry, ma\u0142e pisane" },
            { "type.nu.hanidec", "chinske decimalne li\u010dby" },
            { "type.nu.hansfin", "zjednorjene chinske financne cyfry" },
            { "type.nu.hantfin", "tradicionalne chinske financne cyfry" },
            { "type.nu.jpanfin", "japanske financne cyfry" },
            { "type.nu.tamldec", "tamilske cyfry" },
            { "type.ca.buddhist", "buddhistiska protyka" },
            { "type.ca.ethiopic", "etiopiska protyka" },
            { "type.ca.japanese", "japanska protyka" },
            { "type.cf.standard", "standardny format m\u011bny" },
            { "type.co.standard", "standardowy rjadowanski sl\u011bd" },
            { "type.ms.uksystem", "britiski system m\u011brow" },
            { "type.ms.ussystem", "ameriski system m\u011brow" },
            { "type.nu.fullwide", "po\u0142no\u0161\u011broke cyfry" },
            { "type.nu.romanlow", "romske cyfry, ma\u0142e pisane" },
            { "type.ca.gregorian", "gregorianska protyka" },
            { "type.ca.islamic-civil", "islamska ciwilna protyka" },
            { "type.ca.islamic-umalqura", "islamska umalqura-protyka" },
            { "type.ca.ethiopic-amete-alem", "etiopiska amete-alem-protyka" },
        };
        return data;
    }
}
