/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_gu extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0a9c\u0abe\u0aa8\u0acd\u0aaf\u0ac1\u0a86\u0ab0\u0ac0",
               "\u0aab\u0ac7\u0aac\u0acd\u0ab0\u0ac1\u0a86\u0ab0\u0ac0",
               "\u0aae\u0abe\u0ab0\u0acd\u0a9a",
               "\u0a8f\u0aaa\u0acd\u0ab0\u0abf\u0ab2",
               "\u0aae\u0ac7",
               "\u0a9c\u0ac2\u0aa8",
               "\u0a9c\u0ac1\u0ab2\u0abe\u0a88",
               "\u0a91\u0a97\u0ab8\u0acd\u0a9f",
               "\u0ab8\u0aaa\u0acd\u0a9f\u0ac7\u0aae\u0acd\u0aac\u0ab0",
               "\u0a91\u0a95\u0acd\u0a9f\u0acb\u0aac\u0ab0",
               "\u0aa8\u0ab5\u0ac7\u0aae\u0acd\u0aac\u0ab0",
               "\u0aa1\u0abf\u0ab8\u0ac7\u0aae\u0acd\u0aac\u0ab0",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0a9c\u0abe\u0aa8\u0acd\u0aaf\u0ac1",
               "\u0aab\u0ac7\u0aac\u0acd\u0ab0\u0ac1",
               "\u0aae\u0abe\u0ab0\u0acd\u0a9a",
               "\u0a8f\u0aaa\u0acd\u0ab0\u0abf\u0ab2",
               "\u0aae\u0ac7",
               "\u0a9c\u0ac2\u0aa8",
               "\u0a9c\u0ac1\u0ab2\u0abe\u0a88",
               "\u0a91\u0a97\u0ab8\u0acd\u0a9f",
               "\u0ab8\u0aaa\u0acd\u0a9f\u0ac7",
               "\u0a91\u0a95\u0acd\u0a9f\u0acb",
               "\u0aa8\u0ab5\u0ac7",
               "\u0aa1\u0abf\u0ab8\u0ac7",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0a9c\u0abe",
               "\u0aab\u0ac7",
               "\u0aae\u0abe",
               "\u0a8f",
               "\u0aae\u0ac7",
               "\u0a9c\u0ac2",
               "\u0a9c\u0ac1",
               "\u0a91",
               "\u0ab8",
               "\u0a91",
               "\u0aa8",
               "\u0aa1\u0abf",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0ab0\u0ab5\u0abf\u0ab5\u0abe\u0ab0",
               "\u0ab8\u0acb\u0aae\u0ab5\u0abe\u0ab0",
               "\u0aae\u0a82\u0a97\u0ab3\u0ab5\u0abe\u0ab0",
               "\u0aac\u0ac1\u0aa7\u0ab5\u0abe\u0ab0",
               "\u0a97\u0ac1\u0ab0\u0ac1\u0ab5\u0abe\u0ab0",
               "\u0ab6\u0ac1\u0a95\u0acd\u0ab0\u0ab5\u0abe\u0ab0",
               "\u0ab6\u0aa8\u0abf\u0ab5\u0abe\u0ab0",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0ab0\u0ab5\u0abf",
               "\u0ab8\u0acb\u0aae",
               "\u0aae\u0a82\u0a97\u0ab3",
               "\u0aac\u0ac1\u0aa7",
               "\u0a97\u0ac1\u0ab0\u0ac1",
               "\u0ab6\u0ac1\u0a95\u0acd\u0ab0",
               "\u0ab6\u0aa8\u0abf",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0ab0",
               "\u0ab8\u0acb",
               "\u0aae\u0a82",
               "\u0aac\u0ac1",
               "\u0a97\u0ac1",
               "\u0ab6\u0ac1",
               "\u0ab6",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1\u0ab2\u0acb \u0aa4\u0acd\u0ab0\u0abf\u0aae\u0abe\u0ab8",
               "2\u0a9c\u0acb \u0aa4\u0acd\u0ab0\u0abf\u0aae\u0abe\u0ab8",
               "3\u0a9c\u0acb \u0aa4\u0acd\u0ab0\u0abf\u0aae\u0abe\u0ab8",
               "4\u0aa5\u0acb \u0aa4\u0acd\u0ab0\u0abf\u0aae\u0abe\u0ab8",
            };
        final String[] metaValue_standalone_QuarterAbbreviations = new String[] {
               "Q1",
               "Q2",
               "Q3",
               "Q4",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "AM",
               "PM",
               "\u0aae\u0aa7\u0acd\u0aaf\u0ab0\u0abe\u0aa4\u0acd\u0ab0\u0abf",
               "",
               "\u0ab8\u0ab5\u0abe\u0ab0\u0ac7",
               "",
               "\u0aac\u0aaa\u0acb\u0ab0\u0ac7",
               "",
               "\u0ab8\u0abe\u0a82\u0a9c\u0ac7",
               "",
               "\u0ab0\u0abe\u0aa4\u0acd\u0ab0\u0ac7",
               "",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "AM",
               "PM",
               "\u0aae.\u0ab0\u0abe\u0aa4\u0acd\u0ab0\u0abf",
               "",
               "\u0ab8\u0ab5\u0abe\u0ab0\u0ac7",
               "",
               "\u0aac\u0aaa\u0acb\u0ab0\u0ac7",
               "",
               "\u0ab8\u0abe\u0a82\u0a9c\u0ac7",
               "",
               "\u0ab0\u0abe\u0aa4\u0acd\u0ab0\u0ac7",
               "",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "hh:mm:ss a zzzz",
               "hh:mm:ss a z",
               "hh:mm:ss a",
               "hh:mm a",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "BE",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, G y",
               "d MMMM, G y",
               "d MMM, G y",
               "d-MM- GGGGG y",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, GGGG y",
               "d MMMM, GGGG y",
               "d MMM, GGGG y",
               "d-MM- G y",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "\u0a86\u0ab0.\u0a93.\u0ab8\u0ac0. \u0aaa\u0ab9\u0ac7\u0ab2\u0abe\u0a82",
               "\u0a86\u0ab0.\u0a93.\u0ab8\u0ac0.",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "AH",
            };
        final String metaValue_calendarname_gregorian = "\u0a97\u0acd\u0ab0\u0ac7\u0a97\u0acb\u0ab0\u0abf\u0a85\u0aa8 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0ab5\u0ab0\u0acd\u0ab7" },
            { "calendarname.islamic-umalqura", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0 (\u0a89\u0aae\u0aae \u0a85\u0ab2-\u0a95\u0ac1\u0ab0\u0abe)" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95-\u0aa8\u0abe\u0a97\u0ab0\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "\u0a87 \u0ab8 \u0aaa\u0ac1",
                    "\u0a87\u0ab8",
                }
            },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \u0aae\u0abe\u0aa8\u0a95 \u0ab8\u0aae\u0aaf" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "\u0a9c\u0abe\u0aaa\u0abe\u0aa8\u0ac0\u0a9d \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\u0a88\u0ab8\u0ab5\u0ac0\u0ab8\u0aa8 \u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac7",
                    "\u0a87\u0ab8\u0ab5\u0ac0\u0ab8\u0aa8",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} \u0a8f {0} \u0ab5\u0abe\u0a97\u0acd\u0aaf\u0ac7",
                    "{1} \u0a8f {0} \u0ab5\u0abe\u0a97\u0acd\u0aaf\u0ac7",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u0aae\u0abf\u0aa8\u0abf\u0a9f" },
            { "field.era", "\u0aaf\u0ac1\u0a97" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u0aae\u0ac1\u0ab9\u0ab0\u0acd\u0ab0\u0aae",
                    "\u0ab8\u0aab\u0ab0",
                    "\u0ab0\u0abe\u0aac\u0ac0\u02bb I",
                    "\u0ab0\u0abe\u0aac\u0ac0\u02bb II",
                    "\u0a9c\u0ac1\u0aae\u0abe\u0aa6\u0abe I",
                    "\u0a9c\u0ac1\u0aae\u0abe\u0aa6\u0abe II",
                    "\u0ab0\u0a9c\u0aac",
                    "\u0ab6\u0abe\u02bb\u0aac\u0abe\u0aa8",
                    "\u0ab0\u0aae\u0aa6\u0abe\u0aa8",
                    "\u0ab6\u0abe\u0ab5\u0acd\u0ab5\u0ab2",
                    "\u0aa7\u0ac1\u02bb\u0ab2-\u0a95\u0acd\u0ab5\u0ac0\u02bb\u0aa1\u0abe\u0ab9",
                    "\u0aa7\u0ac1\u02bb\u0ab2-\u0ab9\u0abf\u0a9c\u0acd\u0a9c\u0abe\u0ab9",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "arab.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a\u061c",
                    "\u0660",
                    "#",
                    "\u061c-",
                    "\u0627\u0633",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "calendarname.roc", "\u0aae\u0abf\u0a82\u0a97\u0ac1\u0a93 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\u0aae\u0ab9\u0abf\u0aa8\u0acb" },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.second", "\u0ab8\u0ac7\u0a95\u0aa8\u0acd\u0aa1" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0a87\u0ab8\u0acd\u0ab2\u0abe\u0aae\u0abf\u0a95 \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "DayPeriodRules", "midnight:00:00;night1:20:00-04:00;afternoon1:12:00-16:00;morning1:04:00-12:00;evening1:16:00-20:00" },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0} \u0ab8\u0aae\u0aaf" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0ab9\u0a9c\u0abe\u0ab0 other:0' '\u0ab9\u0a9c\u0abe\u0ab0}",
                    "{one:00' '\u0ab9\u0a9c\u0abe\u0ab0 other:00' '\u0ab9\u0a9c\u0abe\u0ab0}",
                    "{one:0' '\u0ab2\u0abe\u0a96 other:0' '\u0ab2\u0abe\u0a96}",
                    "{one:00' '\u0ab2\u0abe\u0a96 other:00' '\u0ab2\u0abe\u0a96}",
                    "{one:0' '\u0a95\u0ab0\u0acb\u0aa1 other:0' '\u0a95\u0ab0\u0acb\u0aa1}",
                    "{one:00' '\u0a95\u0ab0\u0acb\u0aa1 other:00' '\u0a95\u0ab0\u0acb\u0aa1}",
                    "{one:0' '\u0a85\u0aac\u0a9c other:0' '\u0a85\u0aac\u0a9c}",
                    "{one:00' '\u0a85\u0aac\u0a9c other:00' '\u0a85\u0aac\u0a9c}",
                    "{one:0' '\u0aa8\u0abf\u0a96\u0ab0\u0acd\u0ab5 other:0' '\u0aa8\u0abf\u0a96\u0ab0\u0acd\u0ab5}",
                    "{one:0' '\u0aae\u0ab9\u0abe\u0aaa\u0aa6\u0acd\u0aae other:0' '\u0aae\u0ab9\u0abe\u0aaa\u0aa6\u0acd\u0aae}",
                    "{one:0' '\u0ab6\u0a82\u0a95\u0ac1 other:0' '\u0ab6\u0a82\u0a95\u0ac1}",
                    "{one:0' '\u0a9c\u0ab2\u0aa7\u0abf other:0' '\u0a9c\u0ab2\u0aa7\u0abf}",
                }
            },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "gujr.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.zone", "\u0ab8\u0aae\u0aaf \u0a9d\u0acb\u0aa8" },
            { "japanese.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "arab.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0%",
                    "",
                }
            },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras",
                new String[] {
                    "\u0a88.\u0ab8.\u0aaa\u0ac2\u0ab0\u0acd\u0ab5\u0ac7",
                    "\u0a88.\u0ab8.",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0a85\u0aa0\u0ab5\u0abe\u0aa1\u0abf\u0aaf\u0abe\u0aa8\u0acb \u0aa6\u0abf\u0ab5\u0ab8" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0a85\u0aa0\u0ab5\u0abe\u0aa1\u0abf\u0aaf\u0ac1\u0a82" },
            { "gujr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ae6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0\u0ab9\u0a9c\u0abe\u0ab0 other:0\u00a0\u0ab9\u0a9c\u0abe\u0ab0}",
                    "{one:00\u00a0\u0ab9\u0a9c\u0abe\u0ab0 other:00\u00a0\u0ab9\u0a9c\u0abe\u0ab0}",
                    "{one:0\u00a0\u0ab2\u0abe\u0a96 other:0\u00a0\u0ab2\u0abe\u0a96}",
                    "{one:00\u00a0\u0ab2\u0abe\u0a96 other:00\u00a0\u0ab2\u0abe\u0a96}",
                    "{one:0\u00a0\u0a95\u0ab0\u0acb\u0aa1 other:0\u00a0\u0a95\u0ab0\u0acb\u0aa1}",
                    "{one:00\u00a0\u0a95\u0ab0\u0acb\u0aa1 other:00\u00a0\u0a95\u0ab0\u0acb\u0aa1}",
                    "{one:0\u00a0\u0a85\u0aac\u0a9c other:0\u00a0\u0a85\u0aac\u0a9c}",
                    "{one:00\u00a0\u0a85\u0aac\u0a9c other:00\u00a0\u0a85\u0aac\u0a9c}",
                    "{one:0\u00a0\u0aa8\u0abf\u0a96\u0ab0\u0acd\u0ab5 other:0\u00a0\u0aa8\u0abf\u0a96\u0ab0\u0acd\u0ab5}",
                    "{one:0\u00a0\u0aae\u0ab9\u0abe\u0aaa\u0aa6\u0acd\u0aae other:0\u00a0\u0aae\u0ab9\u0abe\u0aaa\u0aa6\u0acd\u0aae}",
                    "{one:0\u00a0\u0ab6\u0a82\u0a95\u0ac1 other:0\u00a0\u0ab6\u0a82\u0a95\u0ac1}",
                    "{one:0\u00a0\u0a9c\u0ab2\u0aa7\u0abf other:0\u00a0\u0a9c\u0ab2\u0aa7\u0abf}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.regionFormat.daylight", "{0} \u0aa6\u0abf\u0ab5\u0ab8 \u0ab8\u0aae\u0aaf" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMMM, y",
                    "d MMMM, y",
                    "d MMM, y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "PluralRules", "one:i = 0 or n = 1" },
            { "field.hour", "\u0a95\u0ab2\u0abe\u0a95" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\u0aae\u0ac1\u0ab9.",
                    "\u0ab8\u0aab.",
                    "\u0ab0\u0aac.I",
                    "\u0ab0\u0aac. II",
                    "\u0a9c\u0ac1\u0aae. I",
                    "\u0a9c\u0ac1\u0aae. II",
                    "\u0ab0\u0abe\u0a9c.",
                    "\u0ab6\u0abe.",
                    "\u0ab0\u0abe\u0aae.",
                    "\u0ab6\u0abe\u0ab5.",
                    "\u0aa7\u0ac1\u02bb\u0ab2-\u0a95\u0acd\u0aaf\u0ac1.",
                    "\u0aa7\u0ac1\u02bb\u0ab2-\u0a8f\u0a9a.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\u0aac\u0ac1\u0aa6\u0acd\u0aa7\u0abf\u0ab8\u0acd\u0a9f \u0a95\u0ac7\u0ab2\u0ac7\u0aa8\u0acd\u0aa1\u0ab0" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4#,##,##0.00",
                    "#,##,##0%",
                    "\u00a4#,##,##0.00;(\u00a4#,##,##0.00)",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
