/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;

public abstract class AbstractExtension {
    private final IConfigurationElement configElement;

    protected static void log(String message, Exception e) {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        logger.log(message, 2);
    }

    protected static boolean parseBooleanAttribute(IConfigurationElement configElement, String attributeName, boolean isRequired) throws IllegalArgumentException {
        boolean value = Boolean.parseBoolean(AbstractExtension.parseStringAttribute(configElement, attributeName, isRequired));
        return value;
    }

    protected static String parseStringAttribute(IConfigurationElement configElement, String attributeName, boolean isRequired) throws IllegalArgumentException {
        String value = configElement.getAttribute(attributeName);
        if (value != null) {
            return value;
        }
        if (isRequired) {
            throw new IllegalArgumentException("Required attribute " + attributeName + " was not found.");
        }
        return value;
    }

    protected AbstractExtension(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    protected IConfigurationElement getConfigElement() {
        return this.configElement;
    }
}

