/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.html.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.tags.html.IHtmlService;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;

public class ODTHtmlService
extends AbstractService
implements IHtmlService {
    private static final String content = "content.xml";
    protected String SEPARATOR = "/";
    private String format = "HTML";

    @Override
    public String convert(String value) {
        ILogger logger;
        String output = "";
        if ("RTF".equalsIgnoreCase(this.format)) {
            try {
                value = ODTHtmlService.rtfToHtml(new StringReader(value));
                this.format = "HTML";
            }
            catch (IOException iOException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error transforming RTF to HTML.", 4);
            }
            catch (BadLocationException badLocationException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error writing RTF to HTML.", 4);
            }
        }
        if ("HTML".equalsIgnoreCase(this.format)) {
            try {
                Tidy tidy = new Tidy();
                this.configureTidy(tidy);
                ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.parse(tidy, is, baos);
                value = baos.toString();
                ((InputStream)is).close();
                baos.close();
                value = "<root>" + value + "</root>";
                StringWriter outputWriter = new StringWriter();
                StreamSource xslSource = new StreamSource(FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.gendoc.tags.html"), (IPath)new Path("resources/html2odt.xsl"), (boolean)false));
                StreamSource inputSource = new StreamSource(new StringReader(value));
                StreamResult outputResult = new StreamResult(outputWriter);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(inputSource, outputResult);
                output = outputWriter.toString();
                output = "&lt;drop/&gt;</text:h></text:p>" + output;
            }
            catch (IOException iOException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Unable to open XSL file for HTML transformation.", 4);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error in HTML transformer configuration.", 4);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error in HTML transformer factory configuration.", 4);
            }
            catch (TransformerException transformerException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Error transforming HTML.", 4);
            }
        }
        return output;
    }

    public static String rtfToHtml(Reader reader) throws IOException, BadLocationException {
        JEditorPane p = new JEditorPane();
        p.setContentType("text/rtf");
        EditorKit kitRtf = p.getEditorKitForContentType("text/rtf");
        kitRtf.read(reader, p.getDocument(), 0);
        kitRtf = null;
        EditorKit kitHtml = p.getEditorKitForContentType("text/html");
        StringWriter writer = new StringWriter();
        kitHtml.write(writer, p.getDocument(), 0, p.getDocument().getLength());
        return ((Object)writer).toString();
    }

    public void parse(Tidy tidy, InputStream inputStream, OutputStream outputStream) {
        StringWriter stringWriter = new StringWriter();
        tidy.setErrout(new PrintWriter(stringWriter));
        tidy.parse(inputStream, outputStream);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        logger.log(stringWriter.getBuffer().toString(), 16);
    }

    public void configureTidy(Tidy tidy) {
        tidy.setShowWarnings(true);
        tidy.setMakeClean(true);
        tidy.setQuiet(false);
        tidy.setEncloseBlockText(true);
        tidy.setXmlOut(true);
        tidy.setLogicalEmphasis(true);
    }

    @Override
    public void setVersion(String version) {
    }

    @Override
    public void setInTable(String inTable) {
    }

    @Override
    public void setIncludePic(String inTable) {
    }

    @Override
    public void addAdditionalStyles(Document document) {
        String TABLEBORDERSTYLE = "TableWithBorder";
        try {
            document.jumpToStart();
            while (!content.equals(document.getXMLParser().getXmlFile().getName())) {
                document.jumpToNextFile();
            }
            org.w3c.dom.Document documentNode = document.getXMLParser().getDocument();
            Node stylesNode = this.getNodeFromXPath(documentNode, "//office:automatic-styles");
            String STYLE_NAMESPACE = "xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"";
            Element newStyle = documentNode.createElementNS(STYLE_NAMESPACE, "style:style");
            newStyle.setAttributeNS(STYLE_NAMESPACE, "style:name", TABLEBORDERSTYLE);
            newStyle.setAttributeNS(STYLE_NAMESPACE, "style:family", "table-cell");
            Element styleProps = documentNode.createElementNS(STYLE_NAMESPACE, "style:table-cell-properties");
            String FO_NAMESPACE = "xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"";
            styleProps.setAttributeNS(FO_NAMESPACE, "fo:border-bottom", "0.002cm solid #000000");
            styleProps.setAttributeNS(FO_NAMESPACE, "fo:border-left", "0.002cm solid #000000");
            styleProps.setAttributeNS(FO_NAMESPACE, "fo:border-right", "0.002cm solid #000000");
            styleProps.setAttributeNS(FO_NAMESPACE, "fo:border-top", "0.002cm solid #000000");
            newStyle.appendChild(styleProps);
            stylesNode.appendChild(newStyle);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
    }

    private Node getNodeFromXPath(Node start, String expression) {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(documentService.getNameSpaceContext());
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(start, XPathConstants.NODE);
            if (result != null && result instanceof Node) {
                return (Node)result;
            }
        }
        catch (XPathExpressionException e) {
            logger.log("Invalid XPath expression : " + expression + "\n" + e.getStackTrace().toString(), 4);
        }
        return null;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }
}

