/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.utils;

import org.eclipse.sirius.ext.swt.TextChangeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class TextChangeHelper
implements TextChangeListener {
    protected boolean notifyOnCarriageReturn = true;

    public TextChangeHelper() {
    }

    public TextChangeHelper(boolean notifyOnCarriageReturn) {
        this.notifyOnCarriageReturn = notifyOnCarriageReturn;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: {
                if (event.character != '\r' || !this.notifyOnCarriageReturn) break;
                this.textChanged((Text)event.widget);
                break;
            }
            case 16: {
                this.textChanged((Text)event.widget);
                break;
            }
        }
    }

    public abstract void textChanged(Text var1);

    public void startListeningTo(Text control) {
        control.addListener(16, (Listener)this);
        control.addListener(24, (Listener)this);
    }

    public void startListeningForEnter(Text control) {
        control.addListener(1, (Listener)this);
    }

    public void stopListeningTo(Text control) {
        if (control != null && !control.isDisposed()) {
            control.removeListener(16, (Listener)this);
            control.removeListener(24, (Listener)this);
            control.removeListener(1, (Listener)this);
        }
    }
}

