/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.MarkerSupportConstants;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class DescriptionFieldFilter
extends CompatibilityFieldFilter {
    static final String TAG_CONTAINS_MODIFIER = "containsModifier";
    static final String TAG_CONTAINS_TEXT = "containsText";
    String containsModifier = "CONTAINS";
    String containsText = "";

    @Override
    public void loadSettings(IMemento memento) {
        String modifier = memento.getString(TAG_CONTAINS_MODIFIER);
        if (modifier == null) {
            return;
        }
        String contains = memento.getString(TAG_CONTAINS_TEXT);
        if (contains == null) {
            return;
        }
        this.containsText = contains;
        this.containsModifier = modifier;
    }

    @Override
    void loadLegacySettings(IMemento memento, MarkerContentGenerator generator) {
        String setting = memento.getString("contains");
        if (setting != null) {
            String string = this.containsModifier = Boolean.parseBoolean(setting) ? "CONTAINS" : MarkerSupportConstants.DOES_NOT_CONTAIN_KEY;
        }
        if ((setting = memento.getString("description")) != null) {
            this.containsText = setting;
        }
    }

    @Override
    public void saveSettings(IMemento memento) {
        memento.putString(TAG_CONTAINS_MODIFIER, this.containsModifier);
        memento.putString(TAG_CONTAINS_TEXT, this.containsText);
    }

    @Override
    public boolean select(MarkerItem item) {
        if (this.containsText.isEmpty()) {
            return true;
        }
        String value = this.getField().getValue(item);
        if (this.containsModifier.equals("CONTAINS")) {
            return value.contains(this.containsText);
        }
        return !value.contains(this.containsText);
    }

    @Override
    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        DescriptionFieldFilter clone = (DescriptionFieldFilter)copy;
        clone.containsModifier = this.containsModifier;
        clone.containsText = this.containsText;
    }

    String getContainsModifier() {
        return this.containsModifier;
    }

    void setContainsModifier(String containsString) {
        this.containsModifier = containsString;
    }

    String getContainsText() {
        return this.containsText;
    }

    void setContainsText(String containsText) {
        this.containsText = containsText;
    }

    @Override
    public void initialize(Map values) {
        super.initialize(values);
        String value = (String)values.get("CONTAINS");
        if (value != null) {
            this.setContainsText(value);
            this.setContainsModifier("CONTAINS");
        } else {
            value = (String)values.get(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY);
            if (value != null) {
                this.setContainsText(value);
                this.setContainsModifier(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY);
            }
        }
    }

    @Override
    public void initialize(ProblemFilter problemFilter) {
        this.containsModifier = problemFilter.getContains() ? "CONTAINS" : MarkerSupportConstants.DOES_NOT_CONTAIN_KEY;
        this.containsText = problemFilter.getDescription();
    }
}

