/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class RemoveUnusedAlgVariables
extends CifWalker
implements CifToCifTransformation {
    private Set<AlgVariable> allAlgVars = Sets.set();
    private Set<AlgVariable> allUsedAlgVars = Sets.set();
    private Map<AlgVariable, Set<AlgVariable>> algVarsReferredByAlgVar = Maps.map();
    private AlgVariable analyzingAlgVar = null;
    private final List<Equation> algEquations = Lists.list();

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating unused algebraic variables from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
        boolean change = true;
        while (change) {
            change = false;
            for (Map.Entry<AlgVariable, Set<AlgVariable>> entry : this.algVarsReferredByAlgVar.entrySet()) {
                if (!this.allUsedAlgVars.contains(entry.getKey())) continue;
                boolean bl = change = change || this.allUsedAlgVars.addAll((Collection<AlgVariable>)entry.getValue());
            }
        }
        Set unusedAlgVars = Sets.difference(this.allAlgVars, this.allUsedAlgVars);
        for (AlgVariable uav : unusedAlgVars) {
            EMFHelper.removeFromParentContainment((EObject)uav);
        }
        for (Equation eq : this.algEquations) {
            if (!unusedAlgVars.contains(eq.getVariable())) continue;
            EMFHelper.removeFromParentContainment((EObject)eq);
        }
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        this.allAlgVars.addAll(Lists.filter((List)comp.getDeclarations(), AlgVariable.class));
    }

    protected void preprocessAlgVariable(AlgVariable av) {
        this.analyzingAlgVar = av;
    }

    protected void postprocessAlgVariable(AlgVariable av) {
        this.analyzingAlgVar = null;
    }

    protected void preprocessEquation(Equation eqn) {
        if (eqn.getVariable() instanceof AlgVariable) {
            this.analyzingAlgVar = (AlgVariable)eqn.getVariable();
            this.algEquations.add(eqn);
        }
    }

    protected void postprocessEquation(Equation eqn) {
        this.analyzingAlgVar = null;
    }

    protected void walkAlgVariableExpression(AlgVariableExpression algRef) {
        AlgVariable var = algRef.getVariable();
        if (this.allUsedAlgVars.contains(var)) {
            return;
        }
        if (this.analyzingAlgVar != null) {
            Set<AlgVariable> vars = this.algVarsReferredByAlgVar.get(this.analyzingAlgVar);
            if (vars != null) {
                vars.add(var);
            } else {
                this.algVarsReferredByAlgVar.put(this.analyzingAlgVar, Sets.set((Object)var));
            }
        } else {
            this.allUsedAlgVars.add(var);
        }
    }
}

