/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.svgviz;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.SimulationSpeedOption;
import org.eclipse.escet.cif.simulator.options.TestModeOption;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.svg.SvgCanvas;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.eclipse.swt.widgets.Display;

public class SvgPaintThread
extends Thread {
    private static final int QUEUE_SIZE = 1;
    private final int svgNr;
    private final BlockingQueue<Pair<Double, byte[]>> queue = new LinkedBlockingQueue<Pair<Double, byte[]>>(1);
    public final SvgVisualizer visualizer;
    public final SvgCanvas canvas;
    private final DebugNormalOutput debugOutput;
    private final boolean testMode;
    private final boolean realTimeMode;
    private final Double simSpeed;
    private int frameCount = 0;
    private long startTime;
    private final long frameTime;
    private long lastTime;
    private double lastBehindMillis;
    public AtomicReference<Throwable> exception = new AtomicReference();

    public SvgPaintThread(int svgNr, SvgVisualizer visualizer, DebugNormalOutput debugOutput) {
        super(SvgPaintThread.class.getName() + "-" + svgNr);
        this.svgNr = svgNr;
        this.visualizer = visualizer;
        this.canvas = visualizer.getSvgCanvas();
        this.debugOutput = debugOutput;
        this.testMode = TestModeOption.isEnabled();
        this.realTimeMode = FrameRateOption.isRealTimeEnabled();
        this.simSpeed = SimulationSpeedOption.getSimSpeed();
        this.frameTime = this.realTimeMode ? (long)(1.0E9 / FrameRateOption.getFrameRate()) : 0L;
    }

    public void addData(Pair<Double, byte[]> data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        try {
            this.runInternal(true);
        }
        catch (Throwable ex) {
            this.exception.set(ex);
            this.runInternal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInternal(boolean normalMode) {
        boolean first = true;
        while (true) {
            Pair<Double, byte[]> data;
            try {
                data = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            double modelTime = (Double)data.left;
            byte[] pixelData = (byte[])data.right;
            if (modelTime == -1.0) {
                return;
            }
            if (!normalMode) continue;
            ++this.frameCount;
            if (this.realTimeMode) {
                if (first) {
                    this.lastTime = this.startTime = System.nanoTime();
                    if (this.debugOutput != null) {
                        this.debug("no sleep for first frame...");
                    }
                } else {
                    boolean skipSleep;
                    long curTime = System.nanoTime();
                    long elapsedNanos = curTime - this.lastTime;
                    long remainingNanos = this.frameTime - elapsedNanos;
                    long remainingMillis = remainingNanos / 1000L / 1000L;
                    boolean bl = skipSleep = remainingMillis <= 0L;
                    if (!skipSleep && !this.testMode) {
                        try {
                            Thread.sleep(remainingMillis);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.debugOutput != null && this.debugOutput.isEnabled()) {
                        long rtNanos = System.nanoTime() - this.startTime;
                        double rtMillis = (double)rtNanos / 1000000.0;
                        double modelMillis = modelTime * 1000.0;
                        double behindMillis = rtMillis - modelMillis / this.simSpeed;
                        double behindDelta = behindMillis - this.lastBehindMillis;
                        this.debug("slept for (ms): " + remainingMillis + ", real-time time (ms): " + rtMillis + ", model time (ms): " + modelMillis + ", total behind on real-time (ms): " + behindMillis + ", delta behind on real-time (ms): " + behindDelta + (skipSleep ? " (sleep skipped)" : ""));
                        this.lastBehindMillis = behindMillis;
                    }
                    this.lastTime = System.nanoTime();
                }
            }
            Object object = this.canvas.pixelDataLock;
            synchronized (object) {
                this.canvas.pixelData = pixelData;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SvgPaintThread.this.canvas.isDisposed()) {
                        return;
                    }
                    int width = SvgPaintThread.this.canvas.getImageWidth();
                    int height = SvgPaintThread.this.canvas.getImageHeight();
                    SvgPaintThread.this.canvas.redraw(0, 0, width, height, true);
                }
            });
            if (!first) continue;
            this.visualizer.initDone();
            first = false;
        }
    }

    private void debug(String txt) {
        this.debugOutput.line("SVG#" + this.svgNr + ": frame#" + this.frameCount + ": " + txt);
    }
}

