/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.CifFormatPatternCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.LiteralCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ExprCodeGenerator {
    private ExprCodeGenerator() {
    }

    public static ExprCodeGeneratorResult gencodePreds(List<Expression> preds, CifCompilerContext ctxt, String state) {
        return ExprCodeGenerator.gencodePreds(preds, ctxt, state, "true");
    }

    public static ExprCodeGeneratorResult gencodePreds(List<Expression> preds, CifCompilerContext ctxt, String state, String noPredsCode) {
        if (preds.isEmpty()) {
            return new ExprCodeGeneratorResult(noPredsCode, (CifType)CifConstructors.newBoolType());
        }
        ExprCodeGeneratorResult rslt = ExprCodeGenerator.gencodeExpr(preds.get(0), ctxt, state);
        if (preds.size() == 1) {
            return rslt;
        }
        rslt = ExprCodeGeneratorResult.merge("(%s)", preds.get(0).getType(), ctxt, rslt);
        int i = 1;
        while (i < preds.size()) {
            ExprCodeGeneratorResult prslt = ExprCodeGenerator.gencodeExpr(preds.get(i), ctxt, state);
            rslt = ExprCodeGeneratorResult.merge("%s && (%s)", (CifType)CifConstructors.newBoolType(), ctxt, rslt, prslt);
            ++i;
        }
        return rslt;
    }

    public static List<ExprCodeGeneratorResult> gencodeExprs(List<Expression> exprs, CifCompilerContext ctxt, String state) {
        List rslts = Lists.listc((int)exprs.size());
        for (Expression expr : exprs) {
            rslts.add(ExprCodeGenerator.gencodeExpr(expr, ctxt, state));
        }
        return rslts;
    }

    public static ExprCodeGeneratorResult gencodeExpr(Expression expr, CifCompilerContext ctxt, String state) {
        if (expr instanceof BoolExpression) {
            String result = ((BoolExpression)expr).isValue() ? "true" : "false";
            return new ExprCodeGeneratorResult(result, expr.getType());
        }
        if (expr instanceof IntExpression) {
            return new ExprCodeGeneratorResult(Integer.toString(((IntExpression)expr).getValue()), expr.getType());
        }
        if (expr instanceof RealExpression) {
            String valueTxt = ((RealExpression)expr).getValue();
            double value = Double.parseDouble(valueTxt);
            return new ExprCodeGeneratorResult(CifSimulatorMath.realToStr(value), expr.getType());
        }
        if (expr instanceof StringExpression) {
            return new ExprCodeGeneratorResult(Strings.stringToJava((String)((StringExpression)expr).getValue()), expr.getType());
        }
        if (expr instanceof TimeExpression) {
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s.time", (Object[])new Object[]{state, "s"}), expr.getType());
        }
        if (expr instanceof CastExpression) {
            return ExprCodeGenerator.gencodeCastExpr((CastExpression)expr, ctxt, state);
        }
        if (expr instanceof UnaryExpression) {
            return ExprCodeGenerator.gencodeUnaryExpr((UnaryExpression)expr, ctxt, state);
        }
        if (expr instanceof BinaryExpression) {
            return ExprCodeGenerator.gencodeBinaryExpr((BinaryExpression)expr, ctxt, state);
        }
        if (expr instanceof IfExpression) {
            return ExprCodeGenerator.gencodeIfExpr((IfExpression)expr, ctxt, state);
        }
        if (expr instanceof SwitchExpression) {
            return ExprCodeGenerator.gencodeSwitchExpr((SwitchExpression)expr, ctxt, state);
        }
        if (expr instanceof ProjectionExpression) {
            return ExprCodeGenerator.gencodeProjExpr((ProjectionExpression)expr, ctxt, state);
        }
        if (expr instanceof SliceExpression) {
            return ExprCodeGenerator.gencodeSliceExpr((SliceExpression)expr, ctxt, state);
        }
        if (expr instanceof FunctionCallExpression) {
            return ExprCodeGenerator.gencodeFuncCallExpr((FunctionCallExpression)expr, ctxt, state);
        }
        if (expr instanceof ListExpression) {
            return ExprCodeGenerator.gencodeListExpr((ListExpression)expr, ctxt, state);
        }
        if (expr instanceof SetExpression) {
            return ExprCodeGenerator.gencodeSetExpr((SetExpression)expr, ctxt, state);
        }
        if (expr instanceof TupleExpression) {
            return ExprCodeGenerator.gencodeTupleExpr((TupleExpression)expr, ctxt, state);
        }
        if (expr instanceof DictExpression) {
            return ExprCodeGenerator.gencodeDictExpr((DictExpression)expr, ctxt, state);
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression cexpr = (ConstantExpression)expr;
            return new ExprCodeGeneratorResult(ctxt.getConstFieldName(cexpr.getConstant()), expr.getType());
        }
        if (expr instanceof DiscVariableExpression) {
            return ExprCodeGenerator.gencodeDiscVarExpr((DiscVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof InputVariableExpression) {
            return ExprCodeGenerator.gencodeInputVarExpr((InputVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s(%s)", (Object[])new Object[]{ctxt.getAlgVarMethodName(var), state}), expr.getType());
        }
        if (expr instanceof ContVariableExpression) {
            return ExprCodeGenerator.gencodeContVarExpr((ContVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof LocationExpression) {
            return ExprCodeGenerator.gencodeLocExpr((LocationExpression)expr, ctxt, state);
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral lit = ((EnumLiteralExpression)expr).getLiteral();
            EnumDecl enumDecl = (EnumDecl)lit.eContainer();
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s", (Object[])new Object[]{ctxt.getEnumClassName(enumDecl), ctxt.getEnumConstName(lit)}), expr.getType());
        }
        if (expr instanceof FunctionExpression) {
            Function func = ((FunctionExpression)expr).getFunction();
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s", (Object[])new Object[]{ctxt.getFuncClassName(func), ctxt.getFuncFieldName(func)}), expr.getType());
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event used as value: " + String.valueOf(expr));
        }
        if (expr instanceof ReceivedExpression) {
            return new ExprCodeGeneratorResult("rcvd", expr.getType());
        }
        if (expr instanceof SelfExpression) {
            throw new RuntimeException("Self expr unexpected.");
        }
        if (expr instanceof ComponentExpression) {
            throw new RuntimeException("Component expr unexpected.");
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    private static ExprCodeGeneratorResult gencodeCastExpr(CastExpression expr, CifCompilerContext ctxt, String state) {
        String text;
        Expression child = expr.getChild();
        if (CifTypeUtils.isAutRefExpr((Expression)child)) {
            CifType ctype = child.getType();
            Assert.check((boolean)(ctype instanceof ComponentType));
            Automaton aut = (Automaton)((ComponentType)ctype).getComponent();
            int idx = ctxt.getAutomata().indexOf(aut);
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.getAutCurLocName(%d)", (Object[])new Object[]{state, idx}), expr.getType());
        }
        ExprCodeGeneratorResult crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        CifType nctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        CifType ntype = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (nctype instanceof IntType && ntype instanceof RealType) {
            text = "intToReal(%s)";
        } else if (nctype instanceof IntType && ntype instanceof StringType) {
            text = "intToStr(%s)";
        } else if (nctype instanceof RealType && ntype instanceof StringType) {
            text = "realToStr(%s)";
        } else if (nctype instanceof BoolType && ntype instanceof StringType) {
            text = "boolToStr(%s)";
        } else if (nctype instanceof StringType && ntype instanceof IntType) {
            text = "strToInt(%s)";
        } else if (nctype instanceof StringType && ntype instanceof RealType) {
            text = "strToReal(%s)";
        } else if (nctype instanceof StringType && ntype instanceof BoolType) {
            text = "strToBool(%s)";
        } else {
            if (CifTypeUtils.checkTypeCompat((CifType)nctype, (CifType)ntype, (RangeCompat)RangeCompat.EQUAL)) {
                return crslt;
            }
            String msg = "Unknown cast: " + String.valueOf(nctype) + ", " + String.valueOf(ntype);
            throw new RuntimeException(msg);
        }
        return ExprCodeGeneratorResult.merge(text, expr.getType(), ctxt, crslt);
    }

    private static ExprCodeGeneratorResult gencodeUnaryExpr(UnaryExpression expr, CifCompilerContext ctxt, String state) {
        String text;
        ExprCodeGeneratorResult crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        switch (expr.getOperator()) {
            case INVERSE: {
                text = "!(%s)";
                break;
            }
            case NEGATE: {
                text = "negate(%s)";
                break;
            }
            case PLUS: {
                return crslt;
            }
            case SAMPLE: {
                ctxt.needSampler = true;
                text = "Sampler.sample(%s)";
                break;
            }
            default: {
                throw new RuntimeException("Unknown unop: " + String.valueOf(expr.getOperator()));
            }
        }
        return ExprCodeGeneratorResult.merge(text, expr.getType(), ctxt, crslt);
    }

    private static ExprCodeGeneratorResult gencodeBinaryExpr(BinaryExpression expr, CifCompilerContext ctxt, String state) {
        ExprCodeGeneratorResult lrslt = ExprCodeGenerator.gencodeExpr(expr.getLeft(), ctxt, state);
        ExprCodeGeneratorResult rrslt = ExprCodeGenerator.gencodeExpr(expr.getRight(), ctxt, state);
        return ExprCodeGeneratorResult.merge(switch (expr.getOperator()) {
            case BinaryOperator.IMPLICATION -> "!(%s) || (%s)";
            case BinaryOperator.BI_CONDITIONAL -> "equal(%s, %s)";
            case BinaryOperator.DISJUNCTION -> {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (nltype instanceof BoolType) {
                    yield "(%s) || (%s)";
                }
                Assert.check((boolean)(nltype instanceof SetType));
                yield "union(%s, %s)";
            }
            case BinaryOperator.CONJUNCTION -> {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (nltype instanceof BoolType) {
                    yield "(%s) && (%s)";
                }
                Assert.check((boolean)(nltype instanceof SetType));
                yield "intersection(%s, %s)";
            }
            case BinaryOperator.LESS_THAN -> "(%s) < (%s)";
            case BinaryOperator.LESS_EQUAL -> "(%s) <= (%s)";
            case BinaryOperator.GREATER_THAN -> "(%s) > (%s)";
            case BinaryOperator.GREATER_EQUAL -> "(%s) >= (%s)";
            case BinaryOperator.EQUAL -> "equal(%s, %s)";
            case BinaryOperator.UNEQUAL -> "!equal(%s, %s)";
            case BinaryOperator.ADDITION -> {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType nrtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (nltype instanceof RealType) {
                    yield "addReal(%s, %s)";
                }
                if (nrtype instanceof RealType) {
                    yield "addReal(%s, %s)";
                }
                if (nltype instanceof ListType) {
                    yield "addList(%s, %s)";
                }
                if (nltype instanceof StringType) {
                    yield "addString(%s, %s)";
                }
                if (nltype instanceof DictType) {
                    yield "addDict(%s, %s)";
                }
                yield "addInt(%s, %s)";
            }
            case BinaryOperator.SUBTRACTION -> "subtract(%s, %s)";
            case BinaryOperator.MULTIPLICATION -> "multiply(%s, %s)";
            case BinaryOperator.DIVISION -> "divide(%s, %s)";
            case BinaryOperator.INTEGER_DIVISION -> "div(%s, %s)";
            case BinaryOperator.MODULUS -> "mod(%s, %s)";
            case BinaryOperator.SUBSET -> "subset(%s, %s)";
            case BinaryOperator.ELEMENT_OF -> "in(%s, %s)";
            default -> throw new RuntimeException("Unknown binop: " + String.valueOf(expr.getOperator()));
        }, expr.getType(), ctxt, lrslt, rrslt);
    }

    private static ExprCodeGeneratorResult gencodeIfExpr(IfExpression expr, CifCompilerContext ctxt, String state) {
        ExprCodeGeneratorResult rslt = ExprCodeGenerator.gencodeExpr(expr.getElse(), ctxt, state);
        int i = expr.getElifs().size() - 1;
        while (i >= 0) {
            ElifExpression elif = (ElifExpression)expr.getElifs().get(i);
            ExprCodeGeneratorResult grslt = ExprCodeGenerator.gencodePreds((List<Expression>)elif.getGuards(), ctxt, state);
            ExprCodeGeneratorResult trslt = ExprCodeGenerator.gencodeExpr(elif.getThen(), ctxt, state);
            rslt = ExprCodeGeneratorResult.merge("(%s) ? %s : (%s)", expr.getType(), ctxt, grslt, trslt, rslt);
            --i;
        }
        ExprCodeGeneratorResult grslt = ExprCodeGenerator.gencodePreds((List<Expression>)expr.getGuards(), ctxt, state);
        ExprCodeGeneratorResult trslt = ExprCodeGenerator.gencodeExpr(expr.getThen(), ctxt, state);
        rslt = ExprCodeGeneratorResult.merge("(%s) ? %s : (%s)", expr.getType(), ctxt, grslt, trslt, rslt);
        return rslt;
    }

    private static ExprCodeGeneratorResult gencodeSwitchExpr(SwitchExpression expr, CifCompilerContext ctxt, String state) {
        Expression value = expr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        ExprCodeGeneratorResult valueRslt = isAutRef ? null : ExprCodeGenerator.gencodeExpr(value, ctxt, state);
        EList cases = expr.getCases();
        ExprCodeGeneratorResult rslt = ExprCodeGenerator.gencodeExpr(((SwitchCase)Lists.last((List)cases)).getValue(), ctxt, state);
        int i = cases.size() - 2;
        while (i >= 0) {
            SwitchCase cse = (SwitchCase)cases.get(i);
            Expression key = cse.getKey();
            Assert.notNull((Object)key);
            ExprCodeGeneratorResult keyRslt = ExprCodeGenerator.gencodeExpr(key, ctxt, state);
            if (valueRslt != null) {
                keyRslt = ExprCodeGeneratorResult.merge("equal(%s, %s)", (CifType)CifConstructors.newBoolType(), ctxt, valueRslt, keyRslt);
            }
            ExprCodeGeneratorResult cseValueRslt = ExprCodeGenerator.gencodeExpr(cse.getValue(), ctxt, state);
            rslt = ExprCodeGeneratorResult.merge("(%s) ? %s : (%s)", expr.getType(), ctxt, keyRslt, cseValueRslt, rslt);
            --i;
        }
        return rslt;
    }

    private static ExprCodeGeneratorResult gencodeProjExpr(ProjectionExpression expr, CifCompilerContext ctxt, String state) {
        ExprCodeGeneratorResult crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        CifType nctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        if (nctype instanceof TupleType && expr.getIndex() instanceof FieldExpression) {
            Field field = ((FieldExpression)expr.getIndex()).getField();
            String fieldName = ctxt.getTupleTypeFieldFieldName(field);
            return ExprCodeGeneratorResult.merge(Strings.fmt((String)"(%%s).%s", (Object[])new Object[]{fieldName}), expr.getType(), ctxt, crslt);
        }
        if (nctype instanceof TupleType) {
            int idx;
            try {
                idx = (Integer)CifEvalUtils.eval((Expression)expr.getIndex(), (boolean)false);
            }
            catch (CifEvalException e) {
                throw new RuntimeException(e);
            }
            TupleType tupleType = (TupleType)nctype;
            String fieldName = ctxt.getTupleTypeFieldFieldName(tupleType, idx);
            return ExprCodeGeneratorResult.merge(Strings.fmt((String)"(%%s).%s", (Object[])new Object[]{fieldName}), expr.getType(), ctxt, crslt);
        }
        ExprCodeGeneratorResult irslt = ExprCodeGenerator.gencodeExpr(expr.getIndex(), ctxt, state);
        return ExprCodeGeneratorResult.merge("project(%s, %s)", expr.getType(), ctxt, crslt, irslt);
    }

    private static ExprCodeGeneratorResult gencodeSliceExpr(SliceExpression expr, CifCompilerContext ctxt, String state) {
        ExprCodeGeneratorResult crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        ExprCodeGeneratorResult brslt = expr.getBegin() == null ? new ExprCodeGeneratorResult("null", (CifType)CifConstructors.newIntType()) : ExprCodeGenerator.gencodeExpr(expr.getBegin(), ctxt, state);
        ExprCodeGeneratorResult erslt = expr.getEnd() == null ? new ExprCodeGeneratorResult("null", (CifType)CifConstructors.newIntType()) : ExprCodeGenerator.gencodeExpr(expr.getEnd(), ctxt, state);
        return ExprCodeGeneratorResult.merge("slice(%s, %s, %s)", expr.getType(), ctxt, crslt, brslt, erslt);
    }

    private static ExprCodeGeneratorResult gencodeFuncCallExpr(FunctionCallExpression expr, CifCompilerContext ctxt, String state) {
        if (!(expr.getFunction() instanceof StdLibFunctionExpression)) {
            List funcAndArgResults = Lists.listc((int)(expr.getArguments().size() + 1));
            funcAndArgResults.add(ExprCodeGenerator.gencodeExpr(expr.getFunction(), ctxt, state));
            funcAndArgResults.addAll(ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getArguments(), ctxt, state));
            String argsTxt = String.join((CharSequence)", ", Collections.nCopies(expr.getArguments().size(), "%s"));
            return ExprCodeGeneratorResult.merge(Strings.fmt((String)"(%%s).evalFunc(%s)", (Object[])new Object[]{argsTxt}), expr.getType(), ctxt, funcAndArgResults);
        }
        StdLibFunctionExpression stdlibExpr = (StdLibFunctionExpression)expr.getFunction();
        StdLibFunction stdlib = stdlibExpr.getFunction();
        if (stdlib == StdLibFunction.FORMAT) {
            Expression patternExpr = (Expression)expr.getArguments().get(0);
            String pattern = ((StringExpression)patternExpr).getValue();
            List valueRslts = Lists.listc((int)(expr.getArguments().size() - 1));
            List valueTypes = Lists.listc((int)(expr.getArguments().size() - 1));
            int i = 1;
            while (i < expr.getArguments().size()) {
                Expression value = (Expression)expr.getArguments().get(i);
                valueRslts.add(ExprCodeGenerator.gencodeExpr(value, ctxt, state));
                valueTypes.add(value.getType());
                ++i;
            }
            return CifFormatPatternCodeGenerator.gencodePattern(pattern, valueRslts, valueTypes, (Expression)expr, ctxt);
        }
        List<ExprCodeGeneratorResult> argsRslts = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getArguments(), ctxt, state);
        String argsTxt = String.join((CharSequence)", ", Collections.nCopies(expr.getArguments().size(), "%s"));
        return ExprCodeGeneratorResult.merge(switch (stdlib) {
            case StdLibFunction.ACOSH -> Strings.fmt((String)"acosh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ACOS -> Strings.fmt((String)"acos(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ASINH -> Strings.fmt((String)"asinh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ASIN -> Strings.fmt((String)"asin(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ATANH -> Strings.fmt((String)"atanh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ATAN -> Strings.fmt((String)"atan(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.COSH -> Strings.fmt((String)"cosh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.COS -> Strings.fmt((String)"cos(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SINH -> Strings.fmt((String)"sinh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SIN -> Strings.fmt((String)"sin(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.TANH -> Strings.fmt((String)"tanh(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.TAN -> Strings.fmt((String)"tan(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.ABS -> Strings.fmt((String)"abs(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.CBRT -> Strings.fmt((String)"cbrt(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.CEIL -> Strings.fmt((String)"ceil(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.DELETE -> Strings.fmt((String)"delete(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.EMPTY -> Strings.fmt((String)"empty(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.EXP -> Strings.fmt((String)"exp(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.FLOOR -> Strings.fmt((String)"floor(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.FORMAT -> throw new RuntimeException("Already handled above: " + String.valueOf(stdlib));
            case StdLibFunction.LN -> Strings.fmt((String)"ln(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.LOG -> Strings.fmt((String)"log(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.MAXIMUM -> Strings.fmt((String)"max(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.MINIMUM -> Strings.fmt((String)"min(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.POP -> {
                TupleType rsltType = (TupleType)CifTypeUtils.normalizeType((CifType)expr.getType());
                String className = ctxt.getTupleTypeClassName(rsltType);
                yield Strings.fmt((String)"%s.pop(%s)", (Object[])new Object[]{className, argsTxt});
            }
            case StdLibFunction.POWER -> {
                CifType rsltType = CifTypeUtils.normalizeType((CifType)expr.getType());
                if (rsltType instanceof IntType) {
                    yield Strings.fmt((String)"powInt(%s)", (Object[])new Object[]{argsTxt});
                }
                yield Strings.fmt((String)"powReal(%s)", (Object[])new Object[]{argsTxt});
            }
            case StdLibFunction.ROUND -> Strings.fmt((String)"round(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SCALE -> Strings.fmt((String)"scale(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SIGN -> Strings.fmt((String)"sign(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SIZE -> Strings.fmt((String)"size(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.SQRT -> Strings.fmt((String)"sqrt(%s)", (Object[])new Object[]{argsTxt});
            case StdLibFunction.BERNOULLI -> Strings.fmt((String)"new BernoulliDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.BETA -> Strings.fmt((String)"new BetaDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.BINOMIAL -> Strings.fmt((String)"new BinomialDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.CONSTANT -> {
                String className;
                Expression arg = (Expression)Lists.first((List)expr.getArguments());
                CifType argType = CifTypeUtils.normalizeType((CifType)arg.getType());
                if (argType instanceof BoolType) {
                    className = "ConstantBooleanDistribution";
                } else if (argType instanceof IntType) {
                    className = "ConstantIntegerDistribution";
                } else if (argType instanceof RealType) {
                    className = "ConstantRealDistribution";
                } else {
                    String msg = "Unknown constant distribution: " + String.valueOf(argType);
                    throw new RuntimeException(msg);
                }
                yield Strings.fmt((String)"new %s(%s)", (Object[])new Object[]{className, argsTxt});
            }
            case StdLibFunction.ERLANG -> Strings.fmt((String)"new ErlangDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.EXPONENTIAL -> Strings.fmt((String)"new ExponentialDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.GAMMA -> Strings.fmt((String)"new GammaDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.GEOMETRIC -> Strings.fmt((String)"new GeometricDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.LOG_NORMAL -> Strings.fmt((String)"new LogNormalDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.NORMAL -> Strings.fmt((String)"new NormalDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.POISSON -> Strings.fmt((String)"new PoissonDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.RANDOM -> Strings.fmt((String)"new RandomDistribution(new CifMersenneTwister(%s.spec.getNextSeed()))", (Object[])new Object[]{state});
            case StdLibFunction.TRIANGLE -> Strings.fmt((String)"new TriangleDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            case StdLibFunction.UNIFORM -> {
                String className;
                Expression arg = (Expression)Lists.first((List)expr.getArguments());
                CifType argType = CifTypeUtils.normalizeType((CifType)arg.getType());
                if (argType instanceof IntType) {
                    className = "UniformIntegerDistribution";
                } else if (argType instanceof RealType) {
                    className = "UniformRealDistribution";
                } else {
                    String msg = "Unknown uniform distribution: " + String.valueOf(argType);
                    throw new RuntimeException(msg);
                }
                yield Strings.fmt((String)"new %s(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{className, state, argsTxt});
            }
            case StdLibFunction.WEIBULL -> Strings.fmt((String)"new WeibullDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            default -> throw new RuntimeException("Unknown stdlib func: " + String.valueOf(stdlib));
        }, expr.getType(), ctxt, argsRslts);
    }

    private static ExprCodeGeneratorResult gencodeListExpr(ListExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getElements().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return new ExprCodeGeneratorResult(LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt), expr.getType());
        }
        ListType ltype = (ListType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType etype = ltype.getElementType();
        int size = expr.getElements().size();
        String constructorCode = Strings.fmt((String)"new ArrayList<%s>(%d)", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true), size});
        if (expr.getElements().isEmpty()) {
            return new ExprCodeGeneratorResult(constructorCode, expr.getType());
        }
        List<ExprCodeGeneratorResult> elemRslts = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getElements(), ctxt, state);
        String elemsTxt = String.join((CharSequence)", ", Collections.nCopies(expr.getElements().size(), "%s"));
        return ExprCodeGeneratorResult.merge(Strings.fmt((String)"makelist(%s, %s)", (Object[])new Object[]{constructorCode, elemsTxt}), expr.getType(), ctxt, elemRslts);
    }

    private static ExprCodeGeneratorResult gencodeSetExpr(SetExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getElements().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return new ExprCodeGeneratorResult(LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt), expr.getType());
        }
        SetType stype = (SetType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType etype = stype.getElementType();
        int size = expr.getElements().size();
        String constructorCode = Strings.fmt((String)"new LinkedHashSet<%s>(%d)", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true), size});
        if (expr.getElements().isEmpty()) {
            return new ExprCodeGeneratorResult(constructorCode, expr.getType());
        }
        List<ExprCodeGeneratorResult> elemRslts = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getElements(), ctxt, state);
        String elemsTxt = String.join((CharSequence)", ", Collections.nCopies(expr.getElements().size(), "%s"));
        return ExprCodeGeneratorResult.merge(Strings.fmt((String)"makeset(%s, %s)", (Object[])new Object[]{constructorCode, elemsTxt}), expr.getType(), ctxt, elemRslts);
    }

    private static ExprCodeGeneratorResult gencodeTupleExpr(TupleExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getFields().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return new ExprCodeGeneratorResult(LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt), expr.getType());
        }
        TupleType tupleType = (TupleType)CifTypeUtils.normalizeType((CifType)expr.getType());
        String className = ctxt.getTupleTypeClassName(tupleType);
        List<ExprCodeGeneratorResult> fRslts = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getFields(), ctxt, state);
        String fieldsTxt = String.join((CharSequence)", ", Collections.nCopies(expr.getFields().size(), "%s"));
        return ExprCodeGeneratorResult.merge(Strings.fmt((String)"new %s(%s)", (Object[])new Object[]{className, fieldsTxt}), expr.getType(), ctxt, fRslts);
    }

    private static ExprCodeGeneratorResult gencodeDictExpr(DictExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getPairs().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return new ExprCodeGeneratorResult(LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt), expr.getType());
        }
        DictType dtype = (DictType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType ktype = dtype.getKeyType();
        CifType vtype = dtype.getValueType();
        EList pairs = expr.getPairs();
        int size = pairs.size();
        String ktypeTxt = TypeCodeGenerator.gencodeType(ktype, ctxt, true);
        String vtypeTxt = TypeCodeGenerator.gencodeType(vtype, ctxt, true);
        String rslt = Strings.fmt((String)"new LinkedHashMap<%s, %s>(%d)", (Object[])new Object[]{ktypeTxt, vtypeTxt, size});
        List keyRslts = Lists.listc((int)pairs.size());
        List valueRslts = Lists.listc((int)pairs.size());
        for (DictPair pair : pairs) {
            keyRslts.add(ExprCodeGenerator.gencodeExpr(pair.getKey(), ctxt, state));
            valueRslts.add(ExprCodeGenerator.gencodeExpr(pair.getValue(), ctxt, state));
        }
        String keysTxt = Strings.fmt((String)"array(%s)", (Object[])new Object[]{String.join((CharSequence)", ", Collections.nCopies(keyRslts.size(), "%s"))});
        String valuesTxt = Strings.fmt((String)"array(%s)", (Object[])new Object[]{String.join((CharSequence)", ", Collections.nCopies(valueRslts.size(), "%s"))});
        keyRslts.addAll(valueRslts);
        return ExprCodeGeneratorResult.merge(Strings.fmt((String)"addpairs(%s, %s, %s)", (Object[])new Object[]{rslt, keysTxt, valuesTxt}), expr.getType(), ctxt, keyRslts);
    }

    private static ExprCodeGeneratorResult gencodeDiscVarExpr(DiscVariableExpression expr, CifCompilerContext ctxt, String state) {
        DiscVariable var = expr.getVariable();
        EObject parent = var.eContainer();
        if (parent instanceof ComplexComponent) {
            return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, ctxt.getAutSubStateFieldName((Automaton)parent), ctxt.getDiscVarFieldName(var)}), expr.getType());
        }
        if (parent instanceof FunctionParameter) {
            return new ExprCodeGeneratorResult(ctxt.getFuncParamMethodParamName(var), expr.getType());
        }
        if (parent instanceof InternalFunction) {
            return new ExprCodeGeneratorResult(ctxt.getFuncLocalVarName(var), expr.getType());
        }
        throw new RuntimeException("Unknown disc var parent: " + String.valueOf(parent));
    }

    private static ExprCodeGeneratorResult gencodeInputVarExpr(InputVariableExpression expr, CifCompilerContext ctxt, String state) {
        InputVariable var = expr.getVariable();
        return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, "i", ctxt.getInputVarFieldName(var)}), expr.getType());
    }

    private static ExprCodeGeneratorResult gencodeContVarExpr(ContVariableExpression expr, CifCompilerContext ctxt, String state) {
        ContVariable var = expr.getVariable();
        if (expr.isDerivative()) {
            return new ExprCodeGeneratorResult(Strings.fmt((String)"Derivatives.%s(%s)", (Object[])new Object[]{ctxt.getDerivativeMethodName(var), state}), expr.getType());
        }
        return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, ctxt.getContVarSubStateName(var), ctxt.getContVarFieldName(var)}), expr.getType());
    }

    private static ExprCodeGeneratorResult gencodeLocExpr(LocationExpression expr, CifCompilerContext ctxt, String state) {
        Location loc = expr.getLocation();
        Automaton aut = (Automaton)loc.eContainer();
        return new ExprCodeGeneratorResult(Strings.fmt((String)"%s.%s.%s == %s", (Object[])new Object[]{state, ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut), ctxt.getLocationValueText(loc)}), expr.getType());
    }
}

