/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceUtil {
    public static Dictionary<String, Object> serviceRanking(int priority, Dictionary<String, Object> dict) {
        if (dict == null) {
            dict = new Hashtable<String, Object>();
        }
        dict.put("service.ranking", priority);
        return dict;
    }

    public static int getServiceRanking(ServiceReference<?> reference) {
        if (reference == null) {
            return 0;
        }
        Object ranking = reference.getProperty("service.ranking");
        if (ranking instanceof Integer) {
            return (Integer)ranking;
        }
        return 0;
    }

    public static Dictionary<String, Object> higherServiceRanking(ServiceReference<?> reference, Dictionary<String, Object> dict) {
        int ranking = ServiceUtil.getServiceRanking(reference);
        if (reference != null) {
            ++ranking;
        }
        return ServiceUtil.serviceRanking(ranking, dict);
    }

    public static Dictionary<String, Object> serviceName(String name, Dictionary<String, Object> dict) {
        if (dict == null) {
            dict = new Hashtable<String, Object>();
        }
        dict.put("component.name", name);
        return dict;
    }

    public static URL getUrl(Map<?, ?> properties, String key, URL defaultValue) {
        if (properties != null) {
            Object value = properties.get(key);
            if (value instanceof String) {
                try {
                    return URLUtil.toURL((String)value);
                }
                catch (MalformedURLException e) {
                    MarketplaceClientCore.error(e);
                }
            } else if (value != null) {
                MarketplaceClientCore.getLog().log((IStatus)new Status(2, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.ServiceUtil_ignoringIncompatibleServiceProperty, value, (Object)key)));
            }
        }
        return defaultValue;
    }

    public static URL parseUrl(String url) {
        try {
            return URLUtil.toURL(url);
        }
        catch (MalformedURLException e) {
            MarketplaceClientCore.error(e);
            return null;
        }
    }

    public static Object getOverridablePropertyValue(Map<?, ?> properties, String key) {
        String value;
        String overridePropertyKey = key + "Property";
        Object overrideProperty = properties.get(overridePropertyKey);
        String string = value = overrideProperty == null ? null : System.getProperty(overrideProperty.toString());
        if (value == null) {
            value = properties.get(key);
        }
        return value;
    }

    public static Object getOverridablePropertyValue(ServiceReference<?> serviceReference, String key) {
        Object value;
        String overridePropertyKey = key + "Property";
        Object overrideProperty = serviceReference.getProperty(overridePropertyKey);
        Object object = value = overrideProperty == null ? null : System.getProperty(overrideProperty.toString());
        if (value == null) {
            value = serviceReference.getProperty(key);
        }
        return value;
    }

    public static Dictionary<String, Object> getProperties(ServiceReference<?> serviceReference) {
        String[] propertyKeys;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] stringArray = propertyKeys = serviceReference.getPropertyKeys();
        int n = propertyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object value = serviceReference.getProperty(key);
            properties.put(key, value);
            ++n2;
        }
        return properties;
    }

    public static BundleContext getBundleContext(ServiceRegistration<?> registration) {
        ServiceReference reference = registration.getReference();
        return reference == null ? null : ServiceUtil.getBundleContext(reference);
    }

    public static BundleContext getBundleContext(ServiceReference<?> reference) {
        Bundle bundle = reference.getBundle();
        return bundle != null ? bundle.getBundleContext() : null;
    }

    public static <T> T getService(ServiceReference<T> reference) {
        BundleContext bundleContext = ServiceUtil.getBundleContext(reference);
        return (T)(bundleContext != null ? bundleContext.getService(reference) : null);
    }

    public static <T> T getService(ServiceRegistration<T> registration) {
        ServiceReference reference = registration.getReference();
        return reference == null ? null : (T)ServiceUtil.getService(reference);
    }

    public static <T> T getService(Class<?> context, Class<T> serviceType) {
        BundleContext bundleContext = FrameworkUtil.getBundle(context).getBundleContext();
        ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(serviceType);
        return (T)(serviceReference == null ? null : bundleContext.getService(serviceReference));
    }
}

