/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.command.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.command.adapter.CustomCommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CommandProviderAdapter {
    private final CommandProvider commandProvider;
    private final Method[] commands;

    public CommandProviderAdapter(CommandProvider commandProvider, Method[] commands) {
        this.commandProvider = commandProvider;
        this.commands = commands;
    }

    public Object main(CommandSession commandSession, Object[] args) throws Exception {
        try {
            Method command = this.findCommand("_" + args[0]);
            ArrayList<Object> argList = new ArrayList<Object>();
            int i = 1;
            while (i < args.length) {
                argList.add(args[i]);
                ++i;
            }
            return command.invoke((Object)this.commandProvider, new CustomCommandInterpreter(commandSession, argList));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw (Error)e.getTargetException();
        }
    }

    private Method findCommand(Object commandName) {
        Method[] methodArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            Method command = methodArray[n2];
            if (command.getName().equalsIgnoreCase(commandName.toString())) {
                return command;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Cannot find the command method for: " + commandName);
    }

    public Object _main(CommandSession commandSession, Object[] args) throws Exception {
        return this.main(commandSession, args);
    }
}

