/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.net.ProtocolException;
import java.util.Objects;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.DecodingCallback;
import org.glassfish.grizzly.http2.hpack.HeaderTable;
import org.glassfish.grizzly.http2.hpack.IntegerReader;
import org.glassfish.grizzly.http2.hpack.StringReader;

public final class Decoder {
    private static final State[] states = new State[256];
    private final HeaderTable table;
    private State state = State.READY;
    private final IntegerReader integerReader;
    private final StringReader stringReader;
    private final StringBuilder name;
    private final StringBuilder value;
    private int intValue;
    private boolean firstValueRead;
    private boolean firstValueIndex;
    private boolean nameHuffmanEncoded;
    private boolean valueHuffmanEncoded;
    private int capacity;

    public Decoder(int capacity) {
        this.setMaxCapacity(capacity);
        this.table = new HeaderTable(capacity);
        this.integerReader = new IntegerReader();
        this.stringReader = new StringReader();
        this.name = new StringBuilder(512);
        this.value = new StringBuilder(1024);
    }

    public void setMaxCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity >= 0: " + capacity);
        }
        this.capacity = capacity;
    }

    public void decode(Buffer headerBlock, boolean endOfHeaderBlock, DecodingCallback consumer) {
        Objects.requireNonNull(headerBlock, "headerBlock");
        Objects.requireNonNull(consumer, "consumer");
        while (headerBlock.hasRemaining()) {
            this.proceed(headerBlock, consumer);
        }
        if (endOfHeaderBlock && this.state != State.READY) {
            throw new RuntimeException(new ProtocolException("Unexpected end of header block"));
        }
    }

    private void proceed(Buffer input, DecodingCallback action) {
        switch (this.state) {
            case READY: {
                this.resumeReady(input);
                break;
            }
            case INDEXED: {
                this.resumeIndexed(input, action);
                break;
            }
            case LITERAL: {
                this.resumeLiteral(input, action);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.resumeLiteralWithIndexing(input, action);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.resumeLiteralNeverIndexed(input, action);
                break;
            }
            case SIZE_UPDATE: {
                this.resumeSizeUpdate(input, action);
                break;
            }
            default: {
                throw new InternalError("Unexpected decoder state: " + String.valueOf((Object)this.state));
            }
        }
    }

    private void resumeReady(Buffer input) {
        int b = input.get(input.position()) & 0xFF;
        State s = states[b];
        switch (s) {
            case INDEXED: {
                this.integerReader.configure(7);
                this.state = State.INDEXED;
                this.firstValueIndex = true;
                break;
            }
            case LITERAL: {
                this.state = State.LITERAL;
                boolean bl = this.firstValueIndex = (b & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case LITERAL_WITH_INDEXING: {
                this.state = State.LITERAL_WITH_INDEXING;
                boolean bl = this.firstValueIndex = (b & 0x3F) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(6);
                break;
            }
            case LITERAL_NEVER_INDEXED: {
                this.state = State.LITERAL_NEVER_INDEXED;
                boolean bl = this.firstValueIndex = (b & 0xF) != 0;
                if (!this.firstValueIndex) break;
                this.integerReader.configure(4);
                break;
            }
            case SIZE_UPDATE: {
                this.integerReader.configure(5);
                this.state = State.SIZE_UPDATE;
                this.firstValueIndex = true;
                break;
            }
            default: {
                throw new InternalError(String.valueOf((Object)s));
            }
        }
        if (!this.firstValueIndex) {
            input.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeIndexed(Buffer input, DecodingCallback action) {
        if (!this.integerReader.read(input)) {
            return;
        }
        this.intValue = this.integerReader.get();
        this.integerReader.reset();
        try {
            HeaderTable.HeaderField f = this.table.get(this.intValue);
            action.onIndexed(this.intValue, f.name, f.value);
        }
        finally {
            this.state = State.READY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteral(Buffer input, DecodingCallback action) {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                HeaderTable.HeaderField f = this.table.get(this.intValue);
                action.onLiteral(this.intValue, f.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                action.onLiteral(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    private void resumeLiteralWithIndexing(Buffer input, DecodingCallback action) {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            String n;
            String v = this.value.toString();
            if (this.firstValueIndex) {
                HeaderTable.HeaderField f = this.table.get(this.intValue);
                n = f.name;
                action.onLiteralWithIndexing(this.intValue, n, (CharSequence)v, this.valueHuffmanEncoded);
            } else {
                n = this.name.toString();
                action.onLiteralWithIndexing(n, this.nameHuffmanEncoded, (CharSequence)v, this.valueHuffmanEncoded);
            }
            this.table.put(n, v);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new RuntimeException(new ProtocolException().initCause(e));
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeLiteralNeverIndexed(Buffer input, DecodingCallback action) {
        if (!this.completeReading(input)) {
            return;
        }
        try {
            if (this.firstValueIndex) {
                HeaderTable.HeaderField f = this.table.get(this.intValue);
                action.onLiteralNeverIndexed(this.intValue, f.name, (CharSequence)this.value, this.valueHuffmanEncoded);
            } else {
                action.onLiteralNeverIndexed(this.name, this.nameHuffmanEncoded, (CharSequence)this.value, this.valueHuffmanEncoded);
            }
        }
        finally {
            this.cleanUpAfterReading();
        }
    }

    private void resumeSizeUpdate(Buffer input, DecodingCallback action) {
        if (!this.integerReader.read(input)) {
            return;
        }
        this.intValue = this.integerReader.get();
        assert (this.intValue >= 0);
        if (this.intValue > this.capacity) {
            throw new RuntimeException(new ProtocolException(String.format("Received capacity exceeds expected: capacity=%s, expected=%s", this.intValue, this.capacity)));
        }
        this.integerReader.reset();
        try {
            action.onSizeUpdate(this.intValue);
            this.table.setMaxSize(this.intValue);
        }
        finally {
            this.state = State.READY;
        }
    }

    private boolean completeReading(Buffer input) {
        if (!this.firstValueRead) {
            if (this.firstValueIndex) {
                if (!this.integerReader.read(input)) {
                    return false;
                }
                this.intValue = this.integerReader.get();
                this.integerReader.reset();
            } else {
                if (!this.stringReader.read(input, this.name)) {
                    return false;
                }
                this.nameHuffmanEncoded = this.stringReader.isHuffmanEncoded();
                this.stringReader.reset();
            }
            this.firstValueRead = true;
            return false;
        }
        if (!this.stringReader.read(input, this.value)) {
            return false;
        }
        this.valueHuffmanEncoded = this.stringReader.isHuffmanEncoded();
        this.stringReader.reset();
        return true;
    }

    private void cleanUpAfterReading() {
        this.name.setLength(0);
        this.value.setLength(0);
        this.firstValueRead = false;
        this.state = State.READY;
    }

    HeaderTable getTable() {
        return this.table;
    }

    static {
        for (int i = 0; i < states.length; ++i) {
            if ((i & 0x80) == 128) {
                Decoder.states[i] = State.INDEXED;
                continue;
            }
            if ((i & 0xC0) == 64) {
                Decoder.states[i] = State.LITERAL_WITH_INDEXING;
                continue;
            }
            if ((i & 0xE0) == 32) {
                Decoder.states[i] = State.SIZE_UPDATE;
                continue;
            }
            if ((i & 0xF0) == 16) {
                Decoder.states[i] = State.LITERAL_NEVER_INDEXED;
                continue;
            }
            if ((i & 0xF0) == 0) {
                Decoder.states[i] = State.LITERAL;
                continue;
            }
            throw new InternalError(String.valueOf(i));
        }
    }

    private static enum State {
        READY,
        INDEXED,
        LITERAL_NEVER_INDEXED,
        LITERAL,
        LITERAL_WITH_INDEXING,
        SIZE_UPDATE;

    }
}

