/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Contract;
import org.xml.sax.SAXException;

@Contract
public abstract class ExtensionsArchivist {
    public static final Logger deplLogger = DOLUtils.deplLogger;
    protected DeploymentDescriptorFile standardDD;
    protected List<ConfigurationDeploymentDescriptorFile> confDDFiles;
    private List<ConfigurationDeploymentDescriptorFile> sortedConfDDFiles;
    private ConfigurationDeploymentDescriptorFile confDD;

    public abstract DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor var1);

    public abstract List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles(RootDeploymentDescriptor var1);

    public ConfigurationDeploymentDescriptorFile getConfigurationDDFile(Archivist main, RootDeploymentDescriptor descriptor, ReadableArchive archive) throws IOException {
        if (this.confDD == null) {
            this.getSortedConfigurationDDFiles(descriptor, archive, main.getModuleType());
            if (this.sortedConfDDFiles != null && !this.sortedConfDDFiles.isEmpty()) {
                this.confDD = this.sortedConfDDFiles.get(0);
            }
        }
        return this.confDD;
    }

    public abstract boolean supportsModuleType(ArchiveType var1);

    public abstract <T extends RootDeploymentDescriptor> T getDefaultDescriptor();

    public ModuleScanner getScanner() {
        return null;
    }

    public <T extends RootDeploymentDescriptor> void addExtension(RootDeploymentDescriptor root, RootDeploymentDescriptor extension) {
        root.addExtensionDescriptor(extension.getClass(), extension, null);
        extension.setModuleDescriptor(root.getModuleDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        block7: {
            this.getStandardDDFile(descriptor).setArchiveType(main.getModuleType());
            if (archive.getURI() != null) {
                this.standardDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
            }
            try (InputStream is = null;){
                is = archive.getEntry(this.standardDD.getDeploymentDescriptorPath());
                if (is == null) {
                    if (deplLogger.isLoggable(Level.FINE)) {
                        deplLogger.log(Level.FINE, "Deployment descriptor: " + this.standardDD.getDeploymentDescriptorPath(), " does not exist in archive: " + archive.getURI().getSchemeSpecificPart());
                    }
                    break block7;
                }
                this.standardDD.setXMLValidation(main.getXMLValidation());
                this.standardDD.setXMLValidationLevel(main.getXMLValidationLevel());
                RootDeploymentDescriptor rootDeploymentDescriptor = this.standardDD.read(descriptor, is);
                return rootDeploymentDescriptor;
            }
        }
        return null;
    }

    public Object readRuntimeDeploymentDescriptor(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        ConfigurationDeploymentDescriptorFile ddFile = this.getConfigurationDDFile(main, descriptor, archive);
        if (ddFile == null) {
            return descriptor;
        }
        DOLUtils.readRuntimeDeploymentDescriptor(this.getSortedConfigurationDDFiles(descriptor, archive, main.getModuleType()), archive, descriptor, main, true);
        return descriptor;
    }

    public void writeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(main, descriptor, out);
        this.writeRuntimeDeploymentDescriptors(main, descriptor, in, out);
    }

    public void writeStandardDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, WritableArchive out) throws IOException {
        this.getStandardDDFile(descriptor).setArchiveType(main.getModuleType());
        OutputStream os = out.putNextEntry(this.standardDD.getDeploymentDescriptorPath());
        this.standardDD.write(descriptor, os);
        out.closeEntry();
    }

    public void writeRuntimeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
        List<ConfigurationDeploymentDescriptorFile> confDDFilesToWrite = this.getSortedConfigurationDDFiles(descriptor, in, main.getModuleType());
        if (confDDFilesToWrite.isEmpty()) {
            confDDFilesToWrite = this.getConfigurationDDFiles(descriptor);
        }
        for (ConfigurationDeploymentDescriptorFile ddFile : confDDFilesToWrite) {
            ddFile.setArchiveType(main.getModuleType());
            OutputStream os = out.putNextEntry(ddFile.getDeploymentDescriptorPath());
            ddFile.write(descriptor, os);
            out.closeEntry();
        }
    }

    private List<ConfigurationDeploymentDescriptorFile> getSortedConfigurationDDFiles(RootDeploymentDescriptor descriptor, ReadableArchive archive, ArchiveType archiveType) throws IOException {
        if (this.sortedConfDDFiles == null) {
            this.sortedConfDDFiles = DOLUtils.processConfigurationDDFiles(this.getConfigurationDDFiles(descriptor), archive, archiveType);
        }
        return this.sortedConfDDFiles;
    }
}

