/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class NavigationHandlers {
    public void getUIViewRoot(HandlerContext context) {
        String pageName = (String)context.getInputValue("id");
        FacesContext ctx = context.getFacesContext();
        UIViewRoot root = null;
        if (pageName == null) {
            root = ctx.getViewRoot();
        } else {
            if (pageName.charAt(0) != '/') {
                pageName = "/" + pageName;
            }
            root = ctx.getApplication().getViewHandler().createView(ctx, pageName);
        }
        context.setOutputValue("viewRoot", root);
    }

    public static void getActionURL(HandlerContext handlerCtx) {
        String url = (String)handlerCtx.getInputValue("url");
        FacesContext ctx = handlerCtx.getFacesContext();
        handlerCtx.setOutputValue("result", ctx.getApplication().getViewHandler().getActionURL(ctx, url));
    }

    public static void getResourceURL(HandlerContext handlerCtx) {
        String url = (String)handlerCtx.getInputValue("url");
        FacesContext ctx = handlerCtx.getFacesContext();
        handlerCtx.setOutputValue("result", ctx.getApplication().getViewHandler().getResourceURL(ctx, url));
    }

    public static void navigate(HandlerContext context) {
        Object page = context.getInputValue("page");
        UIViewRoot root = null;
        FacesContext ctx = context.getFacesContext();
        if (page instanceof String) {
            String strPage = (String)page;
            if (strPage.charAt(0) != '/') {
                strPage = "/" + strPage;
            }
            root = ctx.getApplication().getViewHandler().createView(ctx, strPage);
        } else if (page instanceof UIViewRoot) {
            root = (UIViewRoot)page;
        } else {
            throw new IllegalArgumentException("Type '" + page.getClass().getName() + "' is not valid.  It must be a String or UIViewRoot.");
        }
        ctx.setViewRoot(root);
    }

    public static void redirect(HandlerContext context) {
        String page = (String)context.getInputValue("page");
        FacesContext ctx = context.getFacesContext();
        try {
            ctx.getExternalContext().redirect(page);
            ctx.responseComplete();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to navigate to page '" + page + "'!", ex);
        }
    }

    public static void dispatch(HandlerContext context) {
        String path = (String)context.getInputValue("path");
        FacesContext ctx = context.getFacesContext();
        try {
            ctx.getExternalContext().dispatch(path);
            ctx.responseComplete();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to navigate to path '" + path + "'!", ex);
        }
    }
}

